/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.ThreadLocalRandom;
import org.cojen.tupl.Database;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.Filter;
import org.cojen.tupl.Index;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.Table;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.View;
import org.cojen.tupl.core.BTreeCursor;
import org.cojen.tupl.core.CommitLock;
import org.cojen.tupl.core.CursorFrame;
import org.cojen.tupl.core.LocalDatabase;
import org.cojen.tupl.core.LocalTransaction;
import org.cojen.tupl.core.LockManager;
import org.cojen.tupl.core.Locker;
import org.cojen.tupl.core.Node;
import org.cojen.tupl.core.PageOps;
import org.cojen.tupl.core.Primer;
import org.cojen.tupl.core.RedoWriter;
import org.cojen.tupl.core.Split;
import org.cojen.tupl.core.Tree;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.diag.CompactionObserver;
import org.cojen.tupl.diag.EventListener;
import org.cojen.tupl.diag.EventType;
import org.cojen.tupl.diag.IndexStats;
import org.cojen.tupl.diag.VerificationObserver;
import org.cojen.tupl.views.BoundedView;
import org.cojen.tupl.views.UnmodifiableView;

class BTree
extends Tree
implements View,
Index {
    final LocalDatabase mDatabase;
    final LockManager mLockManager;
    final long mId;
    final byte[] mIdBytes;
    final Node mRoot;
    volatile byte[] mName;
    private Node mStubTail;

    BTree(LocalDatabase db, long id, byte[] idBytes, Node root) {
        this.mDatabase = db;
        this.mLockManager = db.mLockManager;
        this.mId = id;
        this.mIdBytes = idBytes;
        this.mRoot = root;
    }

    final int pageSize() {
        return this.mDatabase.pageSize();
    }

    @Override
    public final Ordering ordering() {
        return Ordering.ASCENDING;
    }

    @Override
    public Comparator<byte[]> comparator() {
        return Utils.KEY_COMPARATOR;
    }

    @Override
    public final long id() {
        return this.mId;
    }

    @Override
    public final byte[] name() {
        return Utils.cloneArray(this.mName);
    }

    @Override
    public final String nameString() {
        return Utils.utf8(this.mName);
    }

    @Override
    public <R> Table<R> asTable(Class<R> type) throws IOException {
        return this.mDatabase.rowStore().asTable(this, type);
    }

    @Override
    public BTreeCursor newCursor(Transaction txn) {
        return new BTreeCursor(this, txn);
    }

    @Override
    public Transaction newTransaction(DurabilityMode durabilityMode) {
        return this.mDatabase.newTransaction(durabilityMode);
    }

    @Override
    public boolean isEmpty() throws IOException {
        Node root = this.mRoot;
        root.acquireShared();
        boolean empty = root.isLeaf() && !root.hasKeys();
        root.releaseShared();
        return empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(byte[] lowKey, boolean lowInclusive, byte[] highKey, boolean highInclusive) throws IOException {
        BTreeCursor cursor = this.newCursor(Transaction.BOGUS);
        BTreeCursor high = null;
        try {
            cursor.mKeyOnly = true;
            if (lowKey == null) {
                cursor.first();
            } else if (lowInclusive) {
                cursor.findGe(lowKey);
            } else {
                cursor.findGt(lowKey);
            }
            long adjust = 0L;
            if (highKey != null) {
                high = this.newCursor(Transaction.BOGUS);
                high.mKeyOnly = true;
                high.find(highKey);
                if (highInclusive && high.value() != null) {
                    adjust = 1L;
                }
            }
            long l = cursor.countTo(high) + adjust;
            return l;
        }
        finally {
            cursor.reset();
            if (high != null) {
                high.reset();
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public final byte[] load(Transaction txn, byte[] key) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean exists(Transaction txn, byte[] key) throws IOException {
        CursorFrame frame;
        int keyHash;
        int lockType;
        LocalTransaction local = this.check(txn);
        if (local != null && (lockType = local.lockMode().repeatable) != 0) {
            int hash = LockManager.hash(this.mId, key);
            local.doLock(lockType, this.mId, key, hash, local.mLockTimeoutNanos);
        }
        Node node = this.mRoot;
        node.acquireShared();
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        while (!node.isLeaf()) {
            int childPos;
            try {
                childPos = Node.internalPos(node.binarySearch(key));
            }
            catch (Throwable e) {
                node.releaseShared();
                throw e;
            }
            long childId = node.retrieveChildRefId(childPos);
            Node childNode = this.mDatabase.nodeMapGetShared(childId);
            if (childNode != null) {
                node.releaseShared();
                node = childNode;
                node.used(rnd);
            } else {
                node = node.loadChild(this.mDatabase, childId, 1);
            }
            if (node.mSplit == null) continue;
            node = node.mSplit.selectNode(node, key);
        }
        try {
            int pos = node.binarySearch(key);
            if (local != null && local.lockMode() != LockMode.READ_COMMITTED || this.mLockManager.isAvailable(local, this.mId, key, keyHash = LockManager.hash(this.mId, key))) {
                boolean childNode = pos >= 0 && node.hasLeafValue(pos) != null;
                return childNode;
            }
            frame = new CursorFrame();
            if (pos >= 0) {
                if (node.mSplit != null) {
                    pos = node.mSplit.adjustBindPosition(pos);
                }
            } else {
                frame.mNotFoundKey = key;
                if (node.mSplit != null) {
                    pos = ~node.mSplit.adjustBindPosition(~pos);
                }
            }
            frame.bind(node, pos);
        }
        finally {
            node.releaseShared();
        }
        try {
            Locker locker = local == null ? this.lockSharedLocal(key, keyHash) : (local.doLockShared(this.mId, key, keyHash) == LockResult.ACQUIRED ? local : null);
            try {
                node = frame.acquireShared();
                int pos = frame.mNodePos;
                boolean result = pos >= 0 && node.hasLeafValue(pos) != null;
                node.releaseShared();
                boolean bl = result;
                if (locker != null) {
                    locker.doUnlock();
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (locker != null) {
                    locker.doUnlock();
                }
                throw throwable;
            }
        }
        finally {
            CursorFrame.popAll(frame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void store(Transaction txn, byte[] key, byte[] value) throws IOException {
        Utils.keyCheck(key);
        BTreeCursor cursor = this.newCursor(txn);
        try {
            cursor.mKeyOnly = true;
            cursor.findAndStore(key, value);
        }
        finally {
            cursor.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final byte[] exchange(Transaction txn, byte[] key, byte[] value) throws IOException {
        Utils.keyCheck(key);
        BTreeCursor cursor = this.newCursor(txn);
        try {
            byte[] byArray = cursor.findAndStore(key, value);
            return byArray;
        }
        finally {
            cursor.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean insert(Transaction txn, byte[] key, byte[] value) throws IOException {
        Utils.keyCheck(key);
        BTreeCursor cursor = this.newCursor(txn);
        try {
            boolean bl = cursor.findAndModify(key, BTreeCursor.MODIFY_INSERT, value);
            return bl;
        }
        finally {
            cursor.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean replace(Transaction txn, byte[] key, byte[] value) throws IOException {
        Utils.keyCheck(key);
        BTreeCursor cursor = this.newCursor(txn);
        try {
            boolean bl = cursor.findAndModify(key, BTreeCursor.MODIFY_REPLACE, value);
            return bl;
        }
        finally {
            cursor.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean update(Transaction txn, byte[] key, byte[] value) throws IOException {
        Utils.keyCheck(key);
        BTreeCursor cursor = this.newCursor(txn);
        try {
            boolean bl = cursor.findAndModify(key, BTreeCursor.MODIFY_UPDATE, value);
            return bl;
        }
        finally {
            cursor.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean update(Transaction txn, byte[] key, byte[] oldValue, byte[] newValue) throws IOException {
        Utils.keyCheck(key);
        BTreeCursor cursor = this.newCursor(txn);
        try {
            boolean bl = cursor.findAndModify(key, oldValue, newValue);
            return bl;
        }
        finally {
            cursor.reset();
        }
    }

    @Override
    public LockResult touch(Transaction txn, byte[] key) throws LockFailureException {
        LockMode mode;
        LocalTransaction local = this.check(txn);
        if (local == null || (mode = local.lockMode()) == LockMode.READ_COMMITTED) {
            int hash = LockManager.hash(this.mId, key);
            if (!this.isLockAvailable(local, key, hash)) {
                if (local == null) {
                    this.lockSharedLocal(key, hash).doUnlock();
                } else {
                    LockResult result = local.doLock(0, this.mId, key, hash, local.mLockTimeoutNanos);
                    if (result == LockResult.ACQUIRED) {
                        local.doUnlock();
                    }
                }
            }
        } else if (!mode.noReadLock) {
            int hash = LockManager.hash(this.mId, key);
            return local.doLock(mode.repeatable, this.mId, key, hash, local.mLockTimeoutNanos);
        }
        return LockResult.UNOWNED;
    }

    @Override
    public final LockResult tryLockShared(Transaction txn, byte[] key, long nanosTimeout) throws LockFailureException {
        return this.check(txn).tryLockShared(this.mId, key, nanosTimeout);
    }

    @Override
    public final LockResult lockShared(Transaction txn, byte[] key) throws LockFailureException {
        return this.check(txn).lockShared(this.mId, key);
    }

    @Override
    public final LockResult tryLockUpgradable(Transaction txn, byte[] key, long nanosTimeout) throws LockFailureException {
        return this.check(txn).tryLockUpgradable(this.mId, key, nanosTimeout);
    }

    @Override
    public final LockResult lockUpgradable(Transaction txn, byte[] key) throws LockFailureException {
        return this.check(txn).lockUpgradable(this.mId, key);
    }

    @Override
    public final LockResult tryLockExclusive(Transaction txn, byte[] key, long nanosTimeout) throws LockFailureException {
        return this.check(txn).tryLockExclusive(this.mId, key, nanosTimeout);
    }

    @Override
    public final LockResult lockExclusive(Transaction txn, byte[] key) throws LockFailureException {
        return this.check(txn).lockExclusive(this.mId, key);
    }

    @Override
    public final LockResult lockCheck(Transaction txn, byte[] key) {
        return this.check(txn).lockCheck(this.mId, key);
    }

    @Override
    public View viewGe(byte[] key) {
        return BoundedView.viewGe(this, key);
    }

    @Override
    public View viewGt(byte[] key) {
        return BoundedView.viewGt(this, key);
    }

    @Override
    public View viewLe(byte[] key) {
        return BoundedView.viewLe(this, key);
    }

    @Override
    public View viewLt(byte[] key) {
        return BoundedView.viewLt(this, key);
    }

    @Override
    public View viewPrefix(byte[] prefix, int trim) {
        return BoundedView.viewPrefix(this, prefix, trim);
    }

    @Override
    public final boolean isUnmodifiable() {
        return this.isClosed();
    }

    @Override
    public final boolean isModifyAtomic() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long evict(Transaction txn, byte[] lowKey, byte[] highKey, Filter evictionFilter, boolean autoload) throws IOException {
        long length = 0L;
        BTreeCursor cursor = this.newCursor(txn);
        cursor.autoload(autoload);
        try {
            byte[] endKey = cursor.randomNode(lowKey, highKey);
            if (endKey == null) {
                long l = length;
                return l;
            }
            if (lowKey != null) {
                if (Arrays.compareUnsigned(lowKey, endKey) > 0) {
                    long l = length;
                    return l;
                }
                if (cursor.compareKeyTo(lowKey) < 0) {
                    cursor.findNearby(lowKey);
                }
            }
            if (highKey != null && Arrays.compareUnsigned(highKey, endKey) <= 0) {
                endKey = highKey;
            }
            long[] stats = new long[2];
            while (cursor.key() != null) {
                byte[] key = cursor.key();
                byte[] value = cursor.value();
                if (value != null) {
                    cursor.valueStats(stats);
                    if (stats[0] > 0L && (evictionFilter == null || evictionFilter.isAllowed(key, value))) {
                        length += (long)key.length + stats[0];
                        cursor.store(null);
                    }
                }
                cursor.nextLe(endKey);
            }
        }
        finally {
            cursor.reset();
        }
        return length;
    }

    @Override
    public IndexStats analyze(byte[] lowKey, byte[] highKey) throws IOException {
        BTreeCursor cursor = this.newCursor(Transaction.BOGUS);
        try {
            cursor.mKeyOnly = true;
            cursor.random(lowKey, highKey);
            return cursor.key() == null ? new IndexStats() : cursor.analyze();
        }
        catch (Throwable e) {
            cursor.reset();
            throw e;
        }
    }

    @Override
    final Index observableView() {
        return BTree.isInternal(this.mId) ? new UnmodifiableView(this) : this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final boolean compactTree(Index view, long highestNodeId, CompactionObserver observer) throws IOException {
        try {
            if (!observer.indexBegin(view)) {
                return false;
            }
        }
        catch (Throwable e) {
            Utils.uncaught(e);
            return false;
        }
        BTreeCursor cursor = this.newCursor(Transaction.BOGUS);
        try {
            cursor.mKeyOnly = true;
            cursor.firstLeaf();
            if (!cursor.compact(highestNodeId, observer)) {
                boolean bl = false;
                return bl;
            }
            if (!observer.indexComplete(view)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            cursor.reset();
        }
    }

    @Override
    final boolean verifyTree(Index view, VerificationObserver observer) throws IOException {
        BTreeCursor cursor = this.newCursor(Transaction.BOGUS);
        try {
            cursor.mKeyOnly = true;
            cursor.first();
            int height = cursor.height();
            if (!observer.indexBegin(view, height)) {
                cursor.reset();
                return false;
            }
            if (!cursor.verify(height, observer)) {
                cursor.reset();
                return false;
            }
            cursor.reset();
        }
        catch (Throwable e) {
            observer.failed = true;
            throw e;
        }
        return true;
    }

    @Override
    long countCursors(boolean strict) {
        return this.mRoot.countCursors(strict);
    }

    @Override
    public final void close() {
        this.close(false, false, false);
    }

    final void closeAsDeleted() {
        this.close(false, false, false, PageOps.p_deletedTreePage());
    }

    final Node close(boolean forDelete, boolean rootLatched) {
        return this.close(forDelete, rootLatched, false);
    }

    @Override
    final void forceClose() {
        this.close(false, false, true);
    }

    private Node close(boolean forDelete, boolean rootLatched, boolean force) {
        byte[] closedPage = forDelete ? PageOps.p_deletedTreePage() : PageOps.p_closedTreePage();
        return this.close(forDelete, rootLatched, force, closedPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node close(boolean forDelete, boolean rootLatched, boolean force, byte[] closedPage) {
        Node root = this.mRoot;
        if (!rootLatched) {
            root.acquireExclusive();
        }
        try {
            if (PageOps.isClosedOrDeleted(root.mPage)) {
                Node node = null;
                return node;
            }
            if (!force && BTree.isInternal(this.mId)) {
                throw new IllegalStateException("Cannot close an internal index");
            }
            if (root.hasKeys()) {
                root.releaseExclusive();
                this.mDatabase.commitLock().acquireExclusive();
                try {
                    root.acquireExclusive();
                    if (PageOps.isClosedOrDeleted(root.mPage)) {
                        Node node = null;
                        return node;
                    }
                    root.invalidateCursors(closedPage);
                }
                finally {
                    this.mDatabase.commitLock().releaseExclusive();
                }
            } else {
                root.invalidateCursors(closedPage);
            }
            Node newRoot = root.cloneNode();
            this.mDatabase.swapIfDirty(root, newRoot);
            if (root.id() > 0L) {
                this.mDatabase.nodeMapRemove(root);
            }
            root.closeRoot(closedPage);
            if (forDelete) {
                this.mDatabase.treeClosed(this);
                Node node = newRoot;
                return node;
            }
            newRoot.acquireShared();
            try {
                this.mDatabase.treeClosed(this);
                if (newRoot.id() > 0L) {
                    this.mDatabase.nodeMapPut(newRoot);
                }
            }
            finally {
                newRoot.releaseShared();
                newRoot.makeEvictableNow();
            }
            Node node = null;
            return node;
        }
        finally {
            if (!rootLatched) {
                root.releaseExclusive();
            }
        }
    }

    @Override
    public final boolean isClosed() {
        Node root = this.mRoot;
        root.acquireShared();
        boolean closed = PageOps.isClosedOrDeleted(root.mPage);
        root.releaseShared();
        return closed;
    }

    @Override
    final boolean isMemberOf(Database db) {
        return this.mDatabase == db;
    }

    @Override
    final boolean isUserOf(Tree tree) {
        return this == tree;
    }

    @Override
    final void rename(byte[] newName, long redoTxnId) throws IOException {
        this.mDatabase.renameBTree(this, newName, redoTxnId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final Runnable drop(boolean mustBeEmpty) throws IOException {
        Node root;
        CommitLock.Shared shared = this.mDatabase.commitLock().acquireShared();
        try {
            root = this.mRoot;
            root.acquireExclusive();
        }
        catch (Throwable e) {
            shared.release();
            throw e;
        }
        try {
            try {
                PageOps.checkClosedIndexException(root.mPage);
                if (mustBeEmpty && (!root.isLeaf() || root.hasKeys())) {
                    throw new IllegalStateException("Cannot drop a non-empty index");
                }
                if (BTree.isInternal(this.mId)) {
                    throw new IllegalStateException("Cannot close an internal index");
                }
            }
            catch (Throwable e) {
                shared.release();
                throw e;
            }
            Runnable runnable = this.mDatabase.deleteTree(this, shared);
            return runnable;
        }
        finally {
            root.releaseExclusive();
        }
    }

    final boolean deleteAll() throws IOException {
        return this.newCursor(Transaction.BOGUS).deleteAll();
    }

    /*
     * Exception decompiling
     */
    static BTree graftTempTree(BTree lowTree, BTree highTree) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BTree doGraftTempTree(BTree lowTree, BTree highTree, BTreeCursor lowCursor, BTreeCursor highCursor) throws IOException {
        Node rootNode;
        BTree survivor;
        block26: {
            Node rightNode;
            Node leftNode;
            block27: {
                Node survivorNode;
                Node victimNode;
                BTree victim;
                CursorFrame survivorFrame;
                byte[] midKey;
                CursorFrame highFrame;
                CursorFrame lowFrame = lowCursor.frameExclusive();
                Node lowNode = lowCursor.notSplitDirty(lowFrame);
                try {
                    highFrame = highCursor.frameExclusive();
                    Node highNode = highCursor.notSplitDirty(highFrame);
                    try {
                        midKey = lowNode.midKey(lowNode.highestLeafPos(), highNode, 0);
                    }
                    finally {
                        highNode.releaseExclusive();
                    }
                }
                finally {
                    lowNode.releaseExclusive();
                }
                while (true) {
                    CursorFrame lowParent = lowFrame.mParentFrame;
                    CursorFrame highParent = highFrame.mParentFrame;
                    if (highParent == null) {
                        survivor = lowTree;
                        survivorFrame = lowFrame;
                        victim = highTree;
                        victimNode = highFrame.acquireExclusive();
                        break;
                    }
                    if (lowParent == null) {
                        survivor = highTree;
                        survivorFrame = highFrame;
                        victim = lowTree;
                        victimNode = lowFrame.acquireExclusive();
                        break;
                    }
                    lowFrame = lowParent;
                    highFrame = highParent;
                }
                try {
                    Split split = new Split(lowTree == survivor, victimNode);
                    split.setKey(survivor, midKey);
                    survivorNode = survivorFrame.acquireExclusive();
                    survivorNode.mSplit = split;
                }
                finally {
                    victimNode.releaseExclusive();
                }
                try {
                    BTree.clearExtremityBits(lowCursor.mFrame, survivorFrame, -9);
                    BTree.clearExtremityBits(highCursor.mFrame, survivorFrame, -3);
                    survivor.finishSplit(survivorFrame, survivorNode).releaseExclusive();
                }
                catch (Throwable e) {
                    survivorNode.cleanupFragments(e, survivorNode.mSplit.fragmentedKey());
                    throw e;
                }
                victim.mDatabase.removeGraftedTempTree(victim);
                rootNode = survivor.mRoot;
                rootNode.acquireExclusive();
                if (rootNode.numKeys() != 1 || !rootNode.isInternal()) break block26;
                LocalDatabase db = survivor.mDatabase;
                leftNode = db.latchChildRetainParentEx(rootNode, 0, true);
                try {
                    rightNode = db.latchChildRetainParentEx(rootNode, 2, true);
                }
                catch (Throwable e) {
                    leftNode.releaseExclusive();
                    throw e;
                }
                if (leftNode.isLeaf()) {
                    int rightAvail;
                    int leftAvail = leftNode.availableLeafBytes();
                    int remaining = leftAvail + (rightAvail = rightNode.availableLeafBytes()) - survivor.pageSize() + 12;
                    if (remaining >= 0) {
                        try {
                            Node.moveLeafToLeftAndDelete(survivor, leftNode, rightNode);
                        }
                        catch (Throwable e) {
                            leftNode.releaseExclusive();
                            rootNode.releaseExclusive();
                            throw e;
                        }
                    }
                } else {
                    int rightAvail;
                    byte[] rootPage = rootNode.mPage;
                    int rootEntryLoc = PageOps.p_ushortGetLE(rootPage, rootNode.searchVecStart());
                    int rootEntryLen = Node.keyLengthAtLoc(rootPage, rootEntryLoc);
                    int leftAvail = leftNode.availableInternalBytes();
                    int remaining = leftAvail - rootEntryLen + (rightAvail = rightNode.availableInternalBytes()) - survivor.pageSize() + 10;
                    if (remaining >= 0) {
                        try {
                            Node.moveInternalToLeftAndDelete(survivor, leftNode, rightNode, rootPage, rootEntryLoc, rootEntryLen);
                        }
                        catch (Throwable e) {
                            leftNode.releaseExclusive();
                            rootNode.releaseExclusive();
                            throw e;
                        }
                    }
                }
                break block27;
                rootNode.deleteRightChildRef(2);
                survivor.rootDelete(leftNode);
                return survivor;
            }
            rightNode.releaseExclusive();
            leftNode.releaseExclusive();
        }
        rootNode.releaseExclusive();
        return survivor;
    }

    private static void clearExtremityBits(CursorFrame frame, CursorFrame stop, int mask) {
        do {
            Node node;
            if (frame == stop) {
                node = frame.mNode;
                node.type((byte)(node.type() & mask));
                break;
            }
            node = frame.acquireExclusive();
            node.type((byte)(node.type() & mask));
            node.releaseExclusive();
        } while ((frame = frame.mParentFrame) != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void traverseLoaded(NodeVisitor visitor) throws IOException {
        CursorFrame frame;
        Node node = this.mRoot;
        node.acquireShared();
        if (node.mSplit != null) {
            frame = new CursorFrame();
            frame.bind(node, 0);
            try {
                node = this.finishSplitShared(frame, node);
            }
            catch (Throwable e) {
                CursorFrame.popAll(frame);
                throw e;
            }
        }
        frame = null;
        int pos = 0;
        block9: while (true) {
            if (node.isInternal()) {
                int highestPos = node.highestInternalPos();
                while (pos <= highestPos) {
                    long childId = node.retrieveChildRefId(pos);
                    Node child = this.mDatabase.nodeMapGetShared(childId);
                    if (child != null) {
                        try {
                            frame = new CursorFrame(frame);
                            frame.bind(node, pos);
                        }
                        finally {
                            node.releaseShared();
                        }
                        node = child;
                        pos = 0;
                        continue block9;
                    }
                    pos += 2;
                }
            }
            try {
                visitor.visit(node);
            }
            catch (Throwable e) {
                CursorFrame.popAll(frame);
                throw e;
            }
            if (frame == null) {
                return;
            }
            node = frame.acquireShared();
            if (node.mSplit != null) {
                try {
                    node = this.finishSplitShared(frame, node);
                }
                catch (Throwable e) {
                    CursorFrame.popAll(frame);
                    throw e;
                }
            }
            pos = frame.mNodePos;
            frame = frame.pop();
            pos += 2;
        }
    }

    @Override
    final void writeCachePrimer(DataOutput dout) throws IOException {
        byte[] name = this.mName;
        dout.writeInt(name.length);
        dout.write(name);
        this.traverseLoaded(node -> {
            byte[] midKey;
            block8: {
                try {
                    if (!node.isLeaf()) {
                        return;
                    }
                    int numKeys = node.numKeys();
                    if (numKeys > 1) {
                        int highPos = numKeys & 0xFFFFFFFE;
                        midKey = node.midKey(highPos - 2, node, highPos);
                        break block8;
                    }
                    if (numKeys == 1) {
                        midKey = node.retrieveKey(0);
                        break block8;
                    }
                    return;
                }
                finally {
                    node.releaseShared();
                }
            }
            if (midKey.length < 65535) {
                dout.writeShort(midKey.length);
                dout.write(midKey);
            }
        });
        dout.writeShort(65535);
    }

    @Override
    final void applyCachePrimer(DataInput din) throws IOException {
        new Primer(this, din).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    final Node finishSplit(CursorFrame frame, Node node) throws IOException {
        block8: while (true) {
            block20: {
                if (node != this.mRoot) break block20;
                stub = this.mStubTail;
                if (stub == null) {
                    try {
                        node.finishSplitRoot();
                    }
                    finally {
                        node.releaseExclusive();
                    }
                }
                if (stub.tryAcquireExclusive()) ** GOTO lbl-1000
                node.releaseExclusive();
                stub.acquireExclusive();
                try {
                    node = frame.tryAcquireExclusive();
                }
                catch (Throwable e) {
                    stub.releaseExclusive();
                    throw e;
                }
                if (node == null) {
                    stub.releaseExclusive();
                } else {
                    if (node.mSplit == null) {
                        stub.releaseExclusive();
                        return node;
                    }
                    if (node != this.mRoot || stub != this.mStubTail) {
                        node.releaseExclusive();
                        stub.releaseExclusive();
                    } else lbl-1000:
                    // 2 sources

                    {
                        try {
                            node.finishSplitRoot();
                            this.mStubTail = stub.mNodeMapNext;
                        }
                        finally {
                            node.releaseExclusive();
                            stub.releaseExclusive();
                        }
                    }
                }
                node = frame.acquireExclusive();
                if (node.mSplit != null) continue;
                return node;
            }
            parentFrame = frame.mParentFrame;
            node.releaseExclusive();
            parentNode = parentFrame.acquireExclusive();
            while (true) {
                if (parentNode.mSplit != null) {
                    parentNode = this.finishSplit(parentFrame, parentNode);
                }
                node = frame.acquireExclusive();
                if (node.mSplit == null) {
                    parentNode.releaseExclusive();
                    return node;
                }
                if (node == this.mRoot) {
                    parentNode.releaseExclusive();
                    continue block8;
                }
                parentNode.insertSplitChildRef(parentFrame, this, parentFrame.mNodePos, node);
            }
            break;
        }
    }

    final Node finishSplitCritical(CursorFrame frame, Node node) throws IOException {
        try {
            return this.finishSplit(frame, node);
        }
        catch (Throwable e) {
            return this.finishSplitRetry(e, frame);
        }
    }

    private Node finishSplitRetry(Throwable e, CursorFrame frame) {
        boolean reported = false;
        while (true) {
            if (!Utils.isRecoverable(e)) {
                Utils.closeQuietly(this.mDatabase, e);
                throw Utils.rethrow(e);
            }
            if (!reported) {
                Throwable cause = Utils.rootCause(e);
                EventListener listener = this.mDatabase.eventListener();
                if (listener == null) {
                    Utils.uncaught(cause);
                } else {
                    listener.notify(EventType.PANIC_UNHANDLED_EXCEPTION, "Retrying node split due to exception: %1$s", cause);
                }
                reported = true;
            }
            Thread.yield();
            try {
                Node node = frame.acquireExclusive();
                return this.finishSplit(frame, node);
            }
            catch (Throwable e2) {
                e = e2;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Node finishSplitShared(CursorFrame frame, Node node) throws IOException {
        block6: {
            CommitLock.Shared shared = this.mDatabase.commitLock().acquireSharedUnchecked();
            try {
                if (!node.tryUpgrade()) {
                    node.releaseShared();
                    node = frame.acquireExclusive();
                    if (node.mSplit == null) break block6;
                }
                node = this.finishSplit(frame, node);
            }
            finally {
                shared.release();
            }
        }
        node.downgrade();
        return node;
    }

    final void rootDelete(Node child) throws IOException {
        Node stub = new Node(this.mRoot.mGroup);
        stub.mNodeMapNext = this.mStubTail;
        this.mStubTail = stub;
        this.mRoot.rootDelete(this, child, stub);
    }

    @Override
    final void rootSwap(Tree other) throws IOException {
        this.rootSwap((BTree)other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rootSwap(BTree other) throws IOException {
        CommitLock.Shared shared = this.mDatabase.commitLock().acquireShared();
        try {
            Node bTail;
            Node aRoot = this.mRoot;
            Node bRoot = other.mRoot;
            aRoot.acquireExclusive();
            try {
                this.markDirty(aRoot);
                bRoot.acquireExclusive();
                try {
                    other.markDirty(bRoot);
                    aRoot.rootSwap(bRoot);
                }
                finally {
                    bRoot.releaseExclusive();
                }
            }
            finally {
                aRoot.releaseExclusive();
            }
            Node aTail = this.mStubTail;
            this.mStubTail = bTail = other.mStubTail;
            other.mStubTail = aTail;
        }
        finally {
            shared.release();
        }
    }

    final LocalTransaction check(Transaction txn) throws IllegalArgumentException {
        if (txn instanceof LocalTransaction) {
            LocalTransaction local = (LocalTransaction)txn;
            LocalDatabase txnDb = local.mDatabase;
            if (txnDb == this.mDatabase || txnDb == null) {
                return local;
            }
        }
        if (txn != null) {
            throw new IllegalStateException("Transaction belongs to a different database");
        }
        return null;
    }

    final boolean isLockAvailable(Locker locker, byte[] key, int hash) {
        return this.mLockManager.isAvailable(locker, this.mId, key, hash);
    }

    final Locker lockSharedLocal(byte[] key, int hash) throws LockFailureException {
        return this.mLockManager.lockSharedLocal(this.mId, key, hash);
    }

    final Locker lockExclusiveLocal(byte[] key, int hash) throws LockFailureException {
        return this.mLockManager.lockExclusiveLocal(this.mId, key, hash);
    }

    final long redoStoreNullTxn(byte[] key, byte[] value) throws IOException {
        DurabilityMode mode;
        RedoWriter redo = this.mDatabase.mRedoWriter;
        if (redo == null || (mode = this.mDatabase.mDurabilityMode) == DurabilityMode.NO_REDO) {
            return 0L;
        }
        return this.mDatabase.anyTransactionContext().redoStoreAutoCommit(redo.txnRedoWriter(), this.mId, key, value, mode);
    }

    final void txnCommitSync(long commitPos) throws IOException {
        this.mDatabase.mRedoWriter.txnCommitSync(commitPos);
    }

    final boolean markDirty(Node node) throws IOException {
        return this.mDatabase.markDirty(this, node);
    }

    @FunctionalInterface
    static interface NodeVisitor {
        public void visit(Node var1) throws IOException;
    }

    static final class Repl
    extends BTree {
        Repl(LocalDatabase db, long id, byte[] idBytes, Node root) {
            super(db, id, idBytes, root);
        }
    }

    static final class Temp
    extends BTree {
        Temp(LocalDatabase db, long id, byte[] idBytes, Node root) {
            super(db, id, idBytes, root);
        }
    }
}

