/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.ThreadLocalRandom;
import org.cojen.tupl.ClosedIndexException;
import org.cojen.tupl.CorruptDatabaseException;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.DeadlockException;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.UnmodifiableReplicaException;
import org.cojen.tupl.core.BTree;
import org.cojen.tupl.core.BTreeValue;
import org.cojen.tupl.core.CommitLock;
import org.cojen.tupl.core.CoreValueAccessor;
import org.cojen.tupl.core.CursorFrame;
import org.cojen.tupl.core.GhostFrame;
import org.cojen.tupl.core.LocalDatabase;
import org.cojen.tupl.core.LocalTransaction;
import org.cojen.tupl.core.LockManager;
import org.cojen.tupl.core.Locker;
import org.cojen.tupl.core.Node;
import org.cojen.tupl.core.PageOps;
import org.cojen.tupl.core.RedoWriter;
import org.cojen.tupl.core.Split;
import org.cojen.tupl.core.TransactionContext;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.diag.CompactionObserver;
import org.cojen.tupl.diag.IndexStats;
import org.cojen.tupl.diag.VerificationObserver;
import org.cojen.tupl.views.ViewUtils;

public class BTreeCursor
extends CoreValueAccessor
implements Cursor {
    private static final int LIMIT_LE = 1;
    private static final int LIMIT_LT = 2;
    private static final int LIMIT_GE = -1;
    private static final int LIMIT_GT = -2;
    final BTree mTree;
    LocalTransaction mTxn;
    CursorFrame mFrame;
    byte[] mKey;
    byte[] mValue;
    boolean mKeyOnly;
    private int mKeyHash;
    long mCursorId;
    private static final int VARIANT_REGULAR = 0;
    private static final int VARIANT_RETAIN = 1;
    private static final int VARIANT_CHECK = 2;
    static final byte[] MODIFY_INSERT = new byte[0];
    static final byte[] MODIFY_REPLACE = new byte[0];
    static final byte[] MODIFY_UPDATE = new byte[0];

    BTreeCursor(BTree tree, Transaction txn) {
        this.mTxn = tree.check(txn);
        this.mTree = tree;
    }

    BTreeCursor(BTree tree) {
        this.mTree = tree;
    }

    @Override
    public final Ordering ordering() {
        return Ordering.ASCENDING;
    }

    @Override
    public final Comparator<byte[]> comparator() {
        return Utils.KEY_COMPARATOR;
    }

    @Override
    public final Transaction link(Transaction txn) {
        LocalTransaction old = this.mTxn;
        this.mTxn = this.mTree.check(txn);
        return old;
    }

    @Override
    public final Transaction link() {
        return this.mTxn;
    }

    @Override
    public final byte[] key() {
        return this.mKey;
    }

    @Override
    public final byte[] value() {
        return this.mValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void valueStats(long[] stats) throws IOException {
        stats[0] = -1L;
        stats[1] = 0L;
        if (this.mValue != null && this.mValue != Cursor.NOT_LOADED) {
            stats[0] = this.mValue.length;
            return;
        }
        CursorFrame frame = this.frameSharedNotSplit();
        Node node = frame.mNode;
        try {
            int pos = frame.mNodePos;
            if (pos >= 0) {
                node.retrieveLeafValueStats(pos, stats);
            }
        }
        finally {
            node.releaseShared();
        }
    }

    @Override
    public final boolean autoload(boolean mode) {
        boolean old = this.mKeyOnly;
        this.mKeyOnly = !mode;
        return !old;
    }

    @Override
    public final boolean autoload() {
        return !this.mKeyOnly;
    }

    @Override
    public final int compareKeyTo(byte[] rkey) {
        byte[] lkey = this.mKey;
        return Arrays.compareUnsigned(lkey, rkey);
    }

    @Override
    public final int compareKeyTo(byte[] rkey, int offset, int length) {
        byte[] lkey = this.mKey;
        return Arrays.compareUnsigned(lkey, 0, lkey.length, rkey, offset, offset + length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean register() throws IOException {
        if (this.mCursorId == 0L) {
            if (!this.allowRedo()) {
                return false;
            }
            LocalTransaction txn = this.mTxn;
            if (txn == null) {
                LocalDatabase db = this.mTree.mDatabase;
                RedoWriter redo = db.txnRedoWriter();
                if (redo == null || redo.adjustTransactionId(1L) <= 0L) {
                    return false;
                }
                BTree cursorRegistry = db.cursorRegistry();
                CommitLock.Shared shared = db.commitLock().acquireShared();
                try {
                    TransactionContext context = db.anyTransactionContext();
                    long cursorId = context.nextTransactionId();
                    context.redoCursorRegister(redo, cursorId, this.mTree.mId);
                    this.mCursorId = cursorId;
                    db.registerCursor(cursorRegistry, this);
                }
                catch (UnmodifiableReplicaException e) {
                    boolean bl = false;
                    return bl;
                }
                finally {
                    shared.release();
                }
            } else {
                if (txn.durabilityMode() == DurabilityMode.NO_REDO) {
                    return false;
                }
                CommitLock.Shared shared = this.mTree.mDatabase.commitLock().acquireShared();
                try {
                    boolean redo = txn.tryRedoCursorRegister(this);
                    return redo;
                }
                catch (UnmodifiableReplicaException e) {
                    boolean bl = false;
                    return bl;
                }
                finally {
                    shared.release();
                }
            }
        }
        return true;
    }

    @Override
    public final void unregister() {
        long cursorId = this.mCursorId;
        if (cursorId != 0L) {
            this.doUnregister(this.mTxn, cursorId);
        }
    }

    private int keyHash() {
        int hash = this.mKeyHash;
        if (hash == 0) {
            this.mKeyHash = hash = LockManager.hash(this.mTree.mId, this.mKey);
        }
        return hash;
    }

    @Override
    public final LockResult first() throws IOException {
        this.reset();
        if (!this.toFirst(new CursorFrame(), this.latchRootNode())) {
            return LockResult.UNOWNED;
        }
        LocalTransaction txn = this.mTxn;
        LockResult result = this.tryCopyCurrent(txn);
        if (result != null ? this.mValue != null : (result = this.lockAndCopyIfExists(txn)) != null) {
            return result;
        }
        return this.next();
    }

    private boolean toFirst(CursorFrame frame, Node node) throws IOException {
        return this.toFirstLeaf(frame, node).hasKeys() || this.toNext(this.mFrame);
    }

    byte[] firstKey() throws IOException {
        this.reset();
        if (this.toFirst(new CursorFrame(), this.latchRootNode())) {
            this.tryCopyCurrent(LocalTransaction.BOGUS);
        }
        return this.mKey;
    }

    final void firstLeaf() throws IOException {
        this.reset();
        this.toFirstLeaf(new CursorFrame(), this.latchRootNode());
        this.mFrame.mNode.releaseShared();
    }

    private Node toFirstLeaf(CursorFrame frame, Node node) throws IOException {
        try {
            while (true) {
                frame.bind(node, 0);
                if (node.mSplit != null) {
                    node = this.mTree.finishSplitShared(frame, node);
                    if (frame.mNodePos != 0) {
                        frame.bindOrReposition(node, 0);
                    }
                }
                if (node.isLeaf()) {
                    this.mFrame = frame;
                    return node;
                }
                node = this.mTree.mDatabase.latchToChild(node, 0);
                frame = new CursorFrame(frame);
            }
        }
        catch (Throwable e) {
            throw this.cleanup(e, frame);
        }
    }

    private Node toFirstInternal(CursorFrame frame, Node node) throws IOException {
        try {
            while (true) {
                frame.bind(node, 0);
                if (node.mSplit != null) {
                    node = this.mTree.finishSplitShared(frame, node);
                    if (frame.mNodePos != 0) {
                        frame.bindOrReposition(node, 0);
                    }
                }
                if (node.isBottomInternal()) {
                    this.mFrame = frame;
                    return node;
                }
                node = this.mTree.mDatabase.latchToChild(node, 0);
                frame = new CursorFrame(frame);
            }
        }
        catch (Throwable e) {
            throw this.cleanup(e, frame);
        }
    }

    @Override
    public final LockResult last() throws IOException {
        this.reset();
        if (!this.toLast(new CursorFrame(), this.latchRootNode())) {
            return LockResult.UNOWNED;
        }
        LocalTransaction txn = this.mTxn;
        LockResult result = this.tryCopyCurrent(txn);
        if (result != null ? this.mValue != null : (result = this.lockAndCopyIfExists(txn)) != null) {
            return result;
        }
        return this.previous();
    }

    private boolean toLast(CursorFrame frame, Node node) throws IOException {
        return this.toLastLeaf(frame, node).hasKeys() || this.toPrevious(this.mFrame);
    }

    private Node toLastLeaf(CursorFrame frame, Node node) throws IOException {
        try {
            while (true) {
                Split split;
                if ((split = node.mSplit) != null) {
                    frame.bind(node, split.highestPos(node));
                    node = this.mTree.finishSplitShared(frame, node);
                }
                if (node.isLeaf()) {
                    frame.bindOrReposition(node, Math.max(0, node.highestLeafPos()));
                    this.mFrame = frame;
                    return node;
                }
                int childPos = node.highestInternalPos();
                frame.bindOrReposition(node, childPos);
                node = this.mTree.mDatabase.latchToChild(node, childPos);
                frame = new CursorFrame(frame);
            }
        }
        catch (Throwable e) {
            throw this.cleanup(e, frame);
        }
    }

    private Node toLastInternal(CursorFrame frame, Node node) throws IOException {
        try {
            while (true) {
                Split split;
                if ((split = node.mSplit) != null) {
                    frame.bind(node, split.highestPos(node));
                    node = this.mTree.finishSplitShared(frame, node);
                }
                int childPos = node.highestInternalPos();
                frame.bindOrReposition(node, childPos);
                if (node.isBottomInternal()) {
                    this.mFrame = frame;
                    return node;
                }
                node = this.mTree.mDatabase.latchToChild(node, childPos);
                frame = new CursorFrame(frame);
            }
        }
        catch (Throwable e) {
            throw this.cleanup(e, frame);
        }
    }

    @Override
    public final LockResult skip(long amount) throws IOException {
        if (amount == 0L) {
            byte[] key;
            LocalTransaction txn = this.mTxn;
            if (txn != null && !txn.isBogus() && (key = this.mKey) != null) {
                return txn.mManager.check(txn, this.mTree.mId, key, this.keyHash());
            }
            return LockResult.UNOWNED;
        }
        this.mCursorId &= Long.MAX_VALUE;
        try {
            CursorFrame frame = this.frameSharedNotSplit();
            if (amount > 0L) {
                if (amount > 1L && (frame = this.skipNextGap(frame, amount - 1L, null)) == null) {
                    return LockResult.UNOWNED;
                }
                return this.next(this.mTxn, frame);
            }
            if (amount < -1L && (frame = this.skipPreviousGap(frame, -1L - amount, null)) == null) {
                return LockResult.UNOWNED;
            }
            return this.previous(this.mTxn, frame);
        }
        catch (Throwable e) {
            throw this.handleException(e, false);
        }
    }

    @Override
    public final LockResult skip(long amount, byte[] limitKey, boolean inclusive) throws IOException {
        if (amount == 0L || limitKey == null) {
            return this.skip(amount);
        }
        this.mCursorId &= Long.MAX_VALUE;
        try {
            CursorFrame frame = this.frameSharedNotSplit();
            if (amount > 0L) {
                if (amount > 1L && (frame = this.skipNextGap(frame, amount - 1L, limitKey)) == null) {
                    return LockResult.UNOWNED;
                }
                return this.nextCmp(limitKey, inclusive ? 1 : 2, frame);
            }
            if (amount < -1L && (frame = this.skipPreviousGap(frame, -1L - amount, limitKey)) == null) {
                return LockResult.UNOWNED;
            }
            return this.previousCmp(limitKey, inclusive ? -1 : -2, frame);
        }
        catch (Throwable e) {
            throw this.handleException(e, false);
        }
    }

    @Override
    public final LockResult next() throws IOException {
        return this.next(this.mTxn, this.frameSharedNotSplit());
    }

    @Override
    public final LockResult nextLe(byte[] limitKey) throws IOException {
        return this.nextCmp(limitKey, 1);
    }

    @Override
    public final LockResult nextLt(byte[] limitKey) throws IOException {
        return this.nextCmp(limitKey, 2);
    }

    private LockResult nextCmp(byte[] limitKey, int limitMode) throws IOException {
        Utils.keyCheck(limitKey);
        return this.nextCmp(limitKey, limitMode, this.frameSharedNotSplit());
    }

    private LockResult nextCmp(byte[] limitKey, int limitMode, CursorFrame frame) throws IOException {
        this.mCursorId &= Long.MAX_VALUE;
        LocalTransaction txn = this.mTxn;
        while (this.toNext(frame)) {
            LockResult result = this.tryCopyCurrentCmp(txn, limitKey, limitMode);
            if (result != null ? this.mKey == null || this.mValue != null : (result = this.lockAndCopyIfExists(txn)) != null) {
                return result;
            }
            frame = this.frameSharedNotSplit();
        }
        return LockResult.UNOWNED;
    }

    private LockResult next(LocalTransaction txn, CursorFrame frame) throws IOException {
        this.mCursorId &= Long.MAX_VALUE;
        while (this.toNext(frame)) {
            LockResult result = this.tryCopyCurrent(txn);
            if (result != null ? this.mValue != null : (result = this.lockAndCopyIfExists(txn)) != null) {
                return result;
            }
            frame = this.frameSharedNotSplit();
        }
        return LockResult.UNOWNED;
    }

    private boolean toNext(CursorFrame frame) throws IOException {
        Node node;
        while ((node = this.toNextLeaf(frame)) != null) {
            if (node.hasKeys()) {
                return true;
            }
            frame = this.mFrame;
        }
        return false;
    }

    byte[] nextKey() throws IOException {
        this.mCursorId &= Long.MAX_VALUE;
        this.mValue = NOT_LOADED;
        if (this.toNext(this.frameSharedNotSplit())) {
            this.tryCopyCurrent(LocalTransaction.BOGUS);
        }
        return this.mKey;
    }

    private void nextLeaf() throws IOException {
        Node node = this.toNextLeaf(this.frameSharedNotSplit());
        if (node != null) {
            node.releaseShared();
        }
    }

    private void skipToNextLeaf() throws IOException {
        this.mFrame.mNodePos = 0x7FFFFFFE;
        this.nextLeaf();
    }

    private Node toNextLeaf(CursorFrame frame) throws IOException {
        block0: while (true) {
            Node node;
            block13: {
                int pos;
                block14: {
                    block12: {
                        node = frame.mNode;
                        pos = frame.mNodePos;
                        if (pos >= 0) break block12;
                        if ((pos = -3 - pos) >= node.highestLeafPos()) break block13;
                        frame.mNotFoundKey = null;
                        break block14;
                    }
                    if (pos >= node.highestLeafPos()) break block13;
                }
                frame.mNodePos = pos + 2;
                return node;
            }
            while (true) {
                Node parentNode;
                CursorFrame parentFrame;
                block18: {
                    block20: {
                        int pos;
                        block21: {
                            block19: {
                                block17: {
                                    block16: {
                                        block15: {
                                            if ((parentFrame = frame.mParentFrame) == null) {
                                                this.reachedEnd(node);
                                                return null;
                                            }
                                            parentNode = parentFrame.tryAcquireShared();
                                            node.releaseShared();
                                            if (parentNode != null) break block15;
                                            parentNode = parentFrame.acquireShared();
                                            if (parentNode.mSplit != null) break block16;
                                            break block17;
                                        }
                                        if (parentNode.mSplit == null) break block18;
                                    }
                                    parentNode = this.mTree.finishSplitShared(parentFrame, parentNode);
                                }
                                if (frame != this.mFrame) {
                                    parentNode.releaseShared();
                                    frame = this.frameSharedNotSplit();
                                    continue block0;
                                }
                                node = frame.acquireShared();
                                if (node.mSplit != null) {
                                    parentNode.releaseShared();
                                    this.mTree.finishSplitShared(frame, node);
                                    continue block0;
                                }
                                pos = frame.mNodePos;
                                if (pos >= 0) break block19;
                                if ((pos = -3 - pos) >= node.highestLeafPos()) break block20;
                                frame.mNotFoundKey = null;
                                break block21;
                            }
                            if (pos >= node.highestLeafPos()) break block20;
                        }
                        parentNode.releaseShared();
                        frame.mNodePos = pos + 2;
                        return node;
                    }
                    node.releaseShared();
                }
                int parentPos = parentFrame.mNodePos;
                if (parentPos < parentNode.highestInternalPos()) {
                    parentFrame.popChildren(this.mFrame);
                    parentFrame.mNodePos = parentPos += 2;
                    frame = new CursorFrame(parentFrame);
                    return this.toFirstLeaf(frame, this.mTree.mDatabase.latchToChild(parentNode, parentPos));
                }
                frame = parentFrame;
                node = parentNode;
            }
            break;
        }
    }

    private Node toNextInternal(CursorFrame frame) throws IOException {
        block0: while (true) {
            Node node;
            int pos;
            if ((pos = frame.mNodePos) < (node = frame.mNode).highestInternalPos()) {
                frame.mNodePos = pos + 2;
                return node;
            }
            while (true) {
                Node parentNode;
                CursorFrame parentFrame;
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                if ((parentFrame = frame.mParentFrame) == null) {
                                    this.reachedEnd(node);
                                    return null;
                                }
                                parentNode = parentFrame.tryAcquireShared();
                                node.releaseShared();
                                if (parentNode != null) break block11;
                                parentNode = parentFrame.acquireShared();
                                if (parentNode.mSplit != null) break block12;
                                break block13;
                            }
                            if (parentNode.mSplit == null) break block14;
                        }
                        parentNode = this.mTree.finishSplitShared(parentFrame, parentNode);
                    }
                    if (frame != this.mFrame) {
                        parentNode.releaseShared();
                        frame = this.frameSharedNotSplit();
                        continue block0;
                    }
                    node = frame.acquireShared();
                    if (node.mSplit != null) {
                        parentNode.releaseShared();
                        this.mTree.finishSplitShared(frame, node);
                        continue block0;
                    }
                    int pos2 = frame.mNodePos;
                    if (pos2 < node.highestInternalPos()) {
                        parentNode.releaseShared();
                        frame.mNodePos = pos2 + 2;
                        return node;
                    }
                    node.releaseShared();
                }
                int parentPos = parentFrame.mNodePos;
                if (parentPos < parentNode.highestInternalPos()) {
                    parentFrame.popChildren(this.mFrame);
                    parentFrame.mNodePos = parentPos += 2;
                    frame = new CursorFrame(parentFrame);
                    Node child = this.mTree.mDatabase.latchToChild(parentNode, parentPos);
                    return this.toFirstInternal(frame, child);
                }
                frame = parentFrame;
                node = parentNode;
            }
            break;
        }
    }

    private CursorFrame skipNextGap(CursorFrame frame, long amount, byte[] inLimit) throws IOException {
        Node child;
        block28: {
            Node node;
            block13: while (true) {
                int avail;
                int pos;
                if ((pos = frame.mNodePos) < 0) {
                    pos ^= 0xFFFFFFFF;
                }
                if (amount < (long)(avail = (node = frame.mNode).highestLeafPos() + 2 - pos >> 1)) {
                    frame.mNodePos = pos + ((int)amount << 1);
                    return frame;
                }
                amount -= (long)avail;
                node.releaseShared();
                this.mFrame = frame = frame.pop();
                if (frame == null) {
                    return null;
                }
                node = frame.acquireShared();
                if (node.mSplit != null) {
                    node = this.mTree.finishSplitShared(frame, node);
                }
                while (true) {
                    if (!node.isBottomInternal()) {
                        try {
                            PageOps.checkClosedIndexException(node.mPage);
                            throw new CorruptDatabaseException(node.toString());
                        }
                        catch (Throwable throwable) {
                            node.releaseShared();
                            throw throwable;
                        }
                    }
                    if (inLimit != null && frame.mNodePos <= node.highestKeyPos()) {
                        int cmp;
                        try {
                            cmp = node.compareKey(frame.mNodePos, inLimit);
                        }
                        catch (Throwable e) {
                            this.resetLatched(node);
                            throw e;
                        }
                        if (cmp > 0) {
                            this.resetLatched(node);
                            return null;
                        }
                    }
                    if ((node = this.toNextInternal(frame)) == null) {
                        return null;
                    }
                    frame = this.mFrame;
                    int childCount = node.retrieveChildEntryCount(frame.mNodePos);
                    if (childCount >= 0) {
                        if (amount >= (long)childCount) {
                            amount -= (long)childCount;
                            continue;
                        }
                        child = this.mTree.mDatabase.latchToChild(node, frame.mNodePos);
                        break block28;
                    }
                    child = this.mTree.mDatabase.latchChildRetainParent(node, frame.mNodePos);
                    if (child.mSplit != null) {
                        node.releaseShared();
                        frame = new CursorFrame(frame);
                        this.toFirstLeaf(frame, child);
                        continue block13;
                    }
                    childCount = child.countNonGhostKeys();
                    if (child.mCachedState == 0 && node.tryUpgrade()) {
                        block29: {
                            try {
                                CommitLock.Shared shared = this.mTree.mDatabase.commitLock().tryAcquireShared();
                                if (shared == null) break block29;
                                try {
                                    if (this.tryNotSplitDirty(frame)) {
                                        node.storeChildEntryCount(frame.mNodePos, childCount);
                                    }
                                }
                                catch (Throwable e) {
                                    child.releaseShared();
                                    throw e;
                                }
                                finally {
                                    shared.release();
                                }
                            }
                            catch (Throwable e) {
                                node.releaseExclusive();
                                throw e;
                            }
                        }
                        node.downgrade();
                    }
                    if (amount < (long)childCount) break block13;
                    child.releaseShared();
                    amount -= (long)childCount;
                }
                break;
            }
            node.releaseShared();
        }
        try {
            frame = new CursorFrame(frame);
            frame.bind(child, (int)amount << 1);
            this.mFrame = frame;
            return frame;
        }
        catch (Throwable e) {
            child.releaseShared();
            throw e;
        }
    }

    long countTo(BTreeCursor high) throws IOException {
        if (this.mKey == null || high != null && Arrays.compareUnsigned(this.mKey, high.mKey) >= 0) {
            return 0L;
        }
        CursorFrame frame = this.frameSharedNotSplit();
        int pos = frame.mNodePos;
        if (pos < 0) {
            pos ^= 0xFFFFFFFF;
        }
        Node node = frame.mNode;
        int lowPos = node.searchVecStart() + pos;
        if (high != null && node == high.mFrame.mNode) {
            long count = BTreeCursor.countNonGhostKeys(node, lowPos, high);
            node.releaseShared();
            return count;
        }
        long count = node.countNonGhostKeys(lowPos, node.searchVecEnd());
        node.releaseShared();
        this.mFrame = frame = frame.pop();
        if (frame == null) {
            return count;
        }
        node = frame.acquireShared();
        if (node.mSplit != null) {
            node = this.mTree.finishSplitShared(frame, node);
        }
        while (true) {
            int childCount;
            Node child;
            block23: {
                if (!node.isBottomInternal()) {
                    try {
                        PageOps.checkClosedIndexException(node.mPage);
                        throw new CorruptDatabaseException(node.toString());
                    }
                    catch (Throwable throwable) {
                        node.releaseShared();
                        throw throwable;
                    }
                }
                node = this.toNextInternal(frame);
                if (node == null) {
                    return count;
                }
                frame = this.mFrame;
                if (high != null) {
                    while (true) {
                        CursorFrame highFrame = high.mFrame.mParentFrame;
                        if (node != highFrame.mNode || frame.mNodePos < highFrame.mNodePos) break block23;
                        child = high.mFrame.acquireShared();
                        node.releaseShared();
                        if (child.mSplit == null) break;
                        this.mTree.finishSplitShared(high.mFrame, child).releaseShared();
                        node = frame.acquireShared();
                    }
                    child.releaseShared();
                    return count += BTreeCursor.countNonGhostKeys(child, child.searchVecStart(), high);
                }
            }
            if ((childCount = node.retrieveChildEntryCount(frame.mNodePos)) >= 0) {
                count += (long)childCount;
                continue;
            }
            child = this.mTree.mDatabase.latchChildRetainParent(node, frame.mNodePos);
            childCount = child.countNonGhostKeys();
            count += (long)childCount;
            if (child.mCachedState == 0 && node.tryUpgrade()) {
                block24: {
                    try {
                        CommitLock.Shared shared = this.mTree.mDatabase.commitLock().tryAcquireShared();
                        if (shared == null) break block24;
                        try {
                            if (this.tryNotSplitDirty(frame)) {
                                node.storeChildEntryCount(frame.mNodePos, childCount);
                                child.releaseShared();
                                node.downgrade();
                                continue;
                            }
                        }
                        catch (Throwable e) {
                            child.releaseShared();
                            throw e;
                        }
                        finally {
                            shared.release();
                            continue;
                        }
                    }
                    catch (Throwable e) {
                        node.releaseExclusive();
                        throw e;
                    }
                }
                node.downgrade();
            }
            if (child.mSplit != null) {
                Node sibling = child.mSplit.latchSibling();
                count += (long)sibling.countNonGhostKeys();
                sibling.releaseShared();
            }
            child.releaseShared();
        }
    }

    private static long countNonGhostKeys(Node node, int lowPos, BTreeCursor high) {
        int highPos = high.mFrame.mNodePos;
        if (highPos < 0) {
            highPos ^= 0xFFFFFFFF;
        }
        return node.countNonGhostKeys(lowPos, node.searchVecStart() + highPos - 2);
    }

    @Override
    public final LockResult previous() throws IOException {
        return this.previous(this.mTxn, this.frameSharedNotSplit());
    }

    @Override
    public final LockResult previousGe(byte[] limitKey) throws IOException {
        return this.previousCmp(limitKey, -1);
    }

    @Override
    public final LockResult previousGt(byte[] limitKey) throws IOException {
        return this.previousCmp(limitKey, -2);
    }

    private LockResult previousCmp(byte[] limitKey, int limitMode) throws IOException {
        Utils.keyCheck(limitKey);
        return this.previousCmp(limitKey, limitMode, this.frameSharedNotSplit());
    }

    private LockResult previousCmp(byte[] limitKey, int limitMode, CursorFrame frame) throws IOException {
        this.mCursorId &= Long.MAX_VALUE;
        LocalTransaction txn = this.mTxn;
        while (this.toPrevious(frame)) {
            LockResult result = this.tryCopyCurrentCmp(txn, limitKey, limitMode);
            if (result != null ? this.mKey == null || this.mValue != null : (result = this.lockAndCopyIfExists(txn)) != null) {
                return result;
            }
            frame = this.frameSharedNotSplit();
        }
        return LockResult.UNOWNED;
    }

    private LockResult previous(LocalTransaction txn, CursorFrame frame) throws IOException {
        this.mCursorId &= Long.MAX_VALUE;
        while (this.toPrevious(frame)) {
            LockResult result = this.tryCopyCurrent(txn);
            if (result != null ? this.mValue != null : (result = this.lockAndCopyIfExists(txn)) != null) {
                return result;
            }
            frame = this.frameSharedNotSplit();
        }
        return LockResult.UNOWNED;
    }

    private boolean toPrevious(CursorFrame frame) throws IOException {
        Node node;
        while ((node = this.toPreviousLeaf(frame)) != null) {
            if (node.hasKeys()) {
                return true;
            }
            frame = this.mFrame;
        }
        return false;
    }

    private Node toPreviousLeaf(CursorFrame frame) throws IOException {
        block0: while (true) {
            Node node;
            block13: {
                int pos;
                block14: {
                    block12: {
                        node = frame.mNode;
                        pos = frame.mNodePos;
                        if (pos >= 0) break block12;
                        if ((pos ^= 0xFFFFFFFF) == 0) break block13;
                        frame.mNotFoundKey = null;
                        break block14;
                    }
                    if (pos == 0) break block13;
                }
                frame.mNodePos = pos - 2;
                return node;
            }
            while (true) {
                Node parentNode;
                CursorFrame parentFrame;
                block18: {
                    block20: {
                        int pos;
                        block21: {
                            block19: {
                                block17: {
                                    block16: {
                                        block15: {
                                            if ((parentFrame = frame.mParentFrame) == null) {
                                                this.reachedEnd(node);
                                                return null;
                                            }
                                            parentNode = parentFrame.tryAcquireShared();
                                            node.releaseShared();
                                            if (parentNode != null) break block15;
                                            parentNode = parentFrame.acquireShared();
                                            if (parentNode.mSplit != null) break block16;
                                            break block17;
                                        }
                                        if (parentNode.mSplit == null) break block18;
                                    }
                                    parentNode = this.mTree.finishSplitShared(parentFrame, parentNode);
                                }
                                if (frame != this.mFrame) {
                                    parentNode.releaseShared();
                                    frame = this.frameSharedNotSplit();
                                    continue block0;
                                }
                                node = frame.acquireShared();
                                if (node.mSplit != null) {
                                    parentNode.releaseShared();
                                    this.mTree.finishSplitShared(frame, node);
                                    continue block0;
                                }
                                pos = frame.mNodePos;
                                if (pos >= 0) break block19;
                                if ((pos ^= 0xFFFFFFFF) == 0) break block20;
                                frame.mNotFoundKey = null;
                                break block21;
                            }
                            if (pos == 0) break block20;
                        }
                        parentNode.releaseShared();
                        frame.mNodePos = pos - 2;
                        return node;
                    }
                    node.releaseShared();
                }
                int parentPos = parentFrame.mNodePos;
                if (parentPos > 0) {
                    parentFrame.popChildren(this.mFrame);
                    parentFrame.mNodePos = parentPos -= 2;
                    frame = new CursorFrame(parentFrame);
                    return this.toLastLeaf(frame, this.mTree.mDatabase.latchToChild(parentNode, parentPos));
                }
                frame = parentFrame;
                node = parentNode;
            }
            break;
        }
    }

    private Node toPreviousInternal(CursorFrame frame) throws IOException {
        block0: while (true) {
            Node node = frame.mNode;
            int pos = frame.mNodePos;
            if (pos != 0) {
                frame.mNodePos = pos - 2;
                return node;
            }
            while (true) {
                Node parentNode;
                CursorFrame parentFrame;
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                if ((parentFrame = frame.mParentFrame) == null) {
                                    this.reachedEnd(node);
                                    return null;
                                }
                                parentNode = parentFrame.tryAcquireShared();
                                node.releaseShared();
                                if (parentNode != null) break block11;
                                parentNode = parentFrame.acquireShared();
                                if (parentNode.mSplit != null) break block12;
                                break block13;
                            }
                            if (parentNode.mSplit == null) break block14;
                        }
                        parentNode = this.mTree.finishSplitShared(parentFrame, parentNode);
                    }
                    if (frame != this.mFrame) {
                        parentNode.releaseShared();
                        frame = this.frameSharedNotSplit();
                        continue block0;
                    }
                    node = frame.acquireShared();
                    if (node.mSplit != null) {
                        parentNode.releaseShared();
                        this.mTree.finishSplitShared(frame, node);
                        continue block0;
                    }
                    int pos2 = frame.mNodePos;
                    if (pos2 != 0) {
                        parentNode.releaseShared();
                        frame.mNodePos = pos2 - 2;
                        return node;
                    }
                    node.releaseShared();
                }
                int parentPos = parentFrame.mNodePos;
                if (parentPos > 0) {
                    parentFrame.popChildren(this.mFrame);
                    parentFrame.mNodePos = parentPos -= 2;
                    frame = new CursorFrame(parentFrame);
                    Node child = this.mTree.mDatabase.latchToChild(parentNode, parentPos);
                    return this.toLastInternal(frame, child);
                }
                frame = parentFrame;
                node = parentNode;
            }
            break;
        }
    }

    private CursorFrame skipPreviousGap(CursorFrame frame, long amount, byte[] inLimit) throws IOException {
        Node child;
        block28: {
            Node node;
            block13: while (true) {
                int pos;
                if ((pos = frame.mNodePos) < 0) {
                    pos ^= 0xFFFFFFFF;
                }
                node = frame.mNode;
                int avail = pos + 2 >> 1;
                if (amount < (long)avail) {
                    frame.mNodePos = pos - ((int)amount << 1);
                    return frame;
                }
                amount -= (long)avail;
                node.releaseShared();
                this.mFrame = frame = frame.pop();
                if (frame == null) {
                    return null;
                }
                node = frame.acquireShared();
                if (node.mSplit != null) {
                    node = this.mTree.finishSplitShared(frame, node);
                }
                while (true) {
                    if (!node.isBottomInternal()) {
                        try {
                            PageOps.checkClosedIndexException(node.mPage);
                            throw new CorruptDatabaseException(node.toString());
                        }
                        catch (Throwable throwable) {
                            node.releaseShared();
                            throw throwable;
                        }
                    }
                    if (inLimit != null && frame.mNodePos > 0) {
                        int cmp;
                        try {
                            cmp = node.compareKey(frame.mNodePos - 2, inLimit);
                        }
                        catch (Throwable e) {
                            this.resetLatched(node);
                            throw e;
                        }
                        if (cmp < 0) {
                            this.resetLatched(node);
                            return null;
                        }
                    }
                    if ((node = this.toPreviousInternal(frame)) == null) {
                        return null;
                    }
                    frame = this.mFrame;
                    int childCount = node.retrieveChildEntryCount(frame.mNodePos);
                    if (childCount >= 0) {
                        if (amount >= (long)childCount) {
                            amount -= (long)childCount;
                            continue;
                        }
                        child = this.mTree.mDatabase.latchToChild(node, frame.mNodePos);
                        break block28;
                    }
                    child = this.mTree.mDatabase.latchChildRetainParent(node, frame.mNodePos);
                    if (child.mSplit != null) {
                        node.releaseShared();
                        frame = new CursorFrame(frame);
                        this.toLastLeaf(frame, child);
                        continue block13;
                    }
                    childCount = child.countNonGhostKeys();
                    if (child.mCachedState == 0 && node.tryUpgrade()) {
                        block29: {
                            try {
                                CommitLock.Shared shared = this.mTree.mDatabase.commitLock().tryAcquireShared();
                                if (shared == null) break block29;
                                try {
                                    if (this.tryNotSplitDirty(frame)) {
                                        node.storeChildEntryCount(frame.mNodePos, childCount);
                                    }
                                }
                                catch (Throwable e) {
                                    child.releaseShared();
                                    throw e;
                                }
                                finally {
                                    shared.release();
                                }
                            }
                            catch (Throwable e) {
                                node.releaseExclusive();
                                throw e;
                            }
                        }
                        node.downgrade();
                    }
                    if (amount < (long)childCount) break block13;
                    child.releaseShared();
                    amount -= (long)childCount;
                }
                break;
            }
            node.releaseShared();
        }
        try {
            frame = new CursorFrame(frame);
            frame.bind(child, child.highestKeyPos() - ((int)amount << 1));
            this.mFrame = frame;
            return frame;
        }
        catch (Throwable e) {
            child.releaseShared();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockResult tryCopyCurrent(LocalTransaction txn) throws IOException {
        CursorFrame leaf = this.mFrame;
        Node node = leaf.mNode;
        int pos = leaf.mNodePos;
        try {
            int keyHash;
            int lockType;
            block15: {
                this.mKeyHash = 0;
                if (txn == null) {
                    lockType = 0;
                } else {
                    LockMode mode = txn.lockMode();
                    if (mode.noReadLock) {
                        node.retrieveLeafEntry(pos, this);
                        LockResult lockResult = LockResult.UNOWNED;
                        return lockResult;
                    }
                    lockType = mode.repeatable;
                }
                this.mKey = node.retrieveKey(pos);
                this.mValue = NOT_LOADED;
                try {
                    keyHash = this.keyHash();
                    if (lockType != 0) break block15;
                    if (this.mTree.isLockAvailable(txn, this.mKey, keyHash)) {
                        this.mValue = this.mKeyOnly ? node.hasLeafValue(pos) : node.retrieveLeafValue(pos);
                        LockResult lockResult = LockResult.UNOWNED;
                        return lockResult;
                    }
                    LockResult lockResult = null;
                    return lockResult;
                }
                catch (DeadlockException e) {
                    LockResult lockResult = null;
                    return lockResult;
                }
            }
            LockResult result = txn.doTryLock(lockType, this.mTree.mId, this.mKey, keyHash, 0L);
            if (result.isHeld()) {
                this.mValue = this.mKeyOnly ? node.hasLeafValue(pos) : node.retrieveLeafValue(pos);
                LockResult lockResult = result;
                return lockResult;
            }
            LockResult lockResult = null;
            return lockResult;
        }
        finally {
            node.releaseShared();
        }
    }

    private LockResult tryCopyCurrentCmp(LocalTransaction txn, byte[] limitKey, int limitMode) throws IOException {
        try {
            return this.doTryCopyCurrentCmp(txn, limitKey, limitMode);
        }
        catch (Throwable e) {
            this.mFrame.mNode.releaseShared();
            throw e;
        }
    }

    /*
     * Unable to fully structure code
     */
    private LockResult doTryCopyCurrentCmp(LocalTransaction txn, byte[] limitKey, int limitMode) throws IOException {
        block12: {
            leaf = this.mFrame;
            node = leaf.mNode;
            pos = leaf.mNodePos;
            key = node.retrieveKeyCmp(pos, limitKey, limitMode);
            if (key == null) ** GOTO lbl-1000
            if (key != limitKey) {
                this.mKey = key;
            } else if ((limitMode & 1) != 0) {
                this.mKey = (byte[])key.clone();
            } else lbl-1000:
            // 2 sources

            {
                node.releaseShared();
                this.reset();
                return LockResult.UNOWNED;
            }
            this.mKeyHash = 0;
            if (txn != null) break block12;
            lockType = 0;
            ** GOTO lbl26
        }
        mode = txn.lockMode();
        if (mode.noReadLock) {
            this.mValue = this.mKeyOnly != false ? node.hasLeafValue(pos) : node.retrieveLeafValue(pos);
            result = LockResult.UNOWNED;
        } else {
            lockType = mode.repeatable;
lbl26:
            // 2 sources

            this.mValue = BTreeCursor.NOT_LOADED;
            keyHash = this.keyHash();
            if (lockType == 0) {
                if (this.mTree.isLockAvailable(txn, this.mKey, keyHash)) {
                    this.mValue = this.mKeyOnly != false ? node.hasLeafValue(pos) : node.retrieveLeafValue(pos);
                    result = LockResult.UNOWNED;
                } else {
                    result = null;
                }
            } else {
                result = txn.doTryLock(lockType, this.mTree.mId, this.mKey, keyHash, 0L);
                if (result.isHeld()) {
                    this.mValue = this.mKeyOnly != false ? node.hasLeafValue(pos) : node.retrieveLeafValue(pos);
                } else {
                    result = null;
                }
            }
        }
        node.releaseShared();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockResult lockAndCopyIfExists(LocalTransaction txn) throws IOException {
        block11: {
            LockResult result;
            int keyHash = this.keyHash();
            if (txn == null) {
                Locker locker = this.mTree.lockSharedLocal(this.mKey, keyHash);
                try {
                    if (this.copyIfExists() != null) {
                        LockResult lockResult = LockResult.UNOWNED;
                        return lockResult;
                    }
                    break block11;
                }
                finally {
                    locker.doUnlock();
                }
            }
            int lockType = txn.lockMode().repeatable;
            if (lockType == 0) {
                result = txn.doLockShared(this.mTree.mId, this.mKey, keyHash);
                if (result == LockResult.ACQUIRED) {
                    result = LockResult.UNOWNED;
                }
            } else {
                result = txn.doLock(lockType, this.mTree.mId, this.mKey, keyHash, txn.mLockTimeoutNanos);
            }
            if (this.copyIfExists() != null) {
                if (result == LockResult.UNOWNED) {
                    txn.doUnlock();
                }
                return result;
            }
            if (result == LockResult.UNOWNED || result == LockResult.ACQUIRED) {
                txn.doUnlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] copyIfExists() throws IOException {
        byte[] value;
        CursorFrame frame = this.frameSharedNotSplit();
        Node node = frame.mNode;
        try {
            int pos = frame.mNodePos;
            value = pos < 0 ? null : (this.mKeyOnly ? node.hasLeafValue(pos) : node.retrieveLeafValue(pos));
        }
        finally {
            node.releaseShared();
        }
        this.mValue = value;
        return value;
    }

    private LocalTransaction prepareFind(byte[] key) {
        LockMode mode;
        Utils.keyCheck(key);
        LocalTransaction txn = this.mTxn;
        int hash = txn != null && ((mode = txn.lockMode()) == LockMode.READ_UNCOMMITTED || mode == LockMode.UNSAFE) ? 0 : LockManager.hash(this.mTree.mId, key);
        this.mKey = key;
        this.mKeyHash = hash;
        return txn;
    }

    @Override
    public final LockResult find(byte[] key) throws IOException {
        this.reset();
        return this.doFind(key);
    }

    final LockResult doFind(byte[] key) throws IOException {
        return this.find(this.prepareFind(key), key, 0, new CursorFrame(), this.latchRootNode());
    }

    @Override
    public final LockResult findGe(byte[] key) throws IOException {
        this.reset();
        LocalTransaction txn = this.prepareFind(key);
        LockResult result = this.find(txn, key, 1, new CursorFrame(), this.latchRootNode());
        if (this.mValue != null) {
            this.mFrame.mNode.releaseShared();
            return result;
        }
        if (result == LockResult.ACQUIRED) {
            txn.doUnlock();
        }
        return this.next(txn, this.mFrame);
    }

    @Override
    public final LockResult findLe(byte[] key) throws IOException {
        this.reset();
        LocalTransaction txn = this.prepareFind(key);
        LockResult result = this.find(txn, key, 1, new CursorFrame(), this.latchRootNode());
        if (this.mValue != null) {
            this.mFrame.mNode.releaseShared();
            return result;
        }
        if (result == LockResult.ACQUIRED) {
            txn.doUnlock();
        }
        return this.previous(txn, this.mFrame);
    }

    @Override
    public final LockResult findGt(byte[] key) throws IOException {
        this.findNoLock(key);
        return this.next(this.mTxn, this.mFrame);
    }

    @Override
    public final LockResult findLt(byte[] key) throws IOException {
        this.findNoLock(key);
        return this.previous(this.mTxn, this.mFrame);
    }

    private void findNoLock(byte[] key) throws IOException {
        this.reset();
        Utils.keyCheck(key);
        this.find(null, key, 2, new CursorFrame(), this.latchRootNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockResult findNearby(byte[] key) throws IOException {
        Node node;
        this.mCursorId &= Long.MAX_VALUE;
        LocalTransaction txn = this.prepareFind(key);
        CursorFrame frame = this.mFrame;
        if (frame == null) {
            frame = new CursorFrame();
            node = this.latchRootNode();
        } else {
            block25: {
                int pos;
                int startPos;
                node = frame.acquireShared();
                if (node.mSplit != null) {
                    node = this.mTree.finishSplitShared(frame, node);
                }
                if ((startPos = frame.mNodePos) < 0) {
                    startPos ^= 0xFFFFFFFF;
                }
                try {
                    pos = node.binarySearch(key, startPos);
                }
                catch (Throwable e) {
                    node.releaseShared();
                    throw e;
                }
                if (pos >= 0) {
                    block24: {
                        frame.mNotFoundKey = null;
                        frame.mNodePos = pos;
                        try {
                            LockResult result = this.tryLockKey(txn);
                            if (result == null) {
                                this.mValue = NOT_LOADED;
                                break block24;
                            }
                            try {
                                this.mValue = this.mKeyOnly ? node.hasLeafValue(pos) : node.retrieveLeafValue(pos);
                                LockResult lockResult = result;
                                return lockResult;
                            }
                            catch (Throwable e) {
                                this.mValue = NOT_LOADED;
                                throw e;
                            }
                        }
                        finally {
                            node.releaseShared();
                        }
                    }
                    return this.doLoad(txn, key, frame, 0);
                }
                if (!(pos == -1 && (node.type() & 2) == 0 || ~pos > node.highestLeafPos() && (node.type() & 8) == 0)) {
                    frame.mNotFoundKey = key;
                    frame.mNodePos = pos;
                    LockResult result = this.tryLockKey(txn);
                    if (result != null) {
                        this.mValue = null;
                        node.releaseShared();
                        return result;
                    }
                    this.mValue = NOT_LOADED;
                    node.releaseShared();
                    return this.doLoad(txn, key, frame, 0);
                }
                this.mFrame = null;
                do {
                    CursorFrame parent;
                    if ((parent = frame.pop()) == null) {
                        Node root = this.mTree.mRoot;
                        if (node != root) {
                            node.releaseShared();
                            root.acquireShared();
                            node = root;
                        }
                        frame = null;
                        break block25;
                    }
                    node.releaseShared();
                    frame = parent;
                    node = frame.acquireShared();
                    if (node.mSplit != null) {
                        node = this.mTree.finishSplitShared(frame, node);
                    }
                    try {
                        pos = Node.internalPos(node.binarySearch(key, frame.mNodePos));
                    }
                    catch (Throwable e) {
                        node.releaseShared();
                        throw this.cleanup(e, frame);
                    }
                } while (pos == 0 && (node.type() & 2) == 0 || pos >= node.highestInternalPos() && (node.type() & 8) == 0);
                frame.mNodePos = pos;
                try {
                    node = this.mTree.mDatabase.latchToChild(node, pos);
                }
                catch (Throwable e) {
                    throw this.cleanup(e, frame);
                }
            }
            frame = new CursorFrame(frame);
        }
        return this.find(txn, key, 0, frame, node);
    }

    private LockResult find(LocalTransaction txn, byte[] key, int variant, CursorFrame frame, Node node) throws IOException {
        while (true) {
            int selectedPos;
            Node selected;
            Node right;
            Node left;
            if (node.isLeaf()) {
                int pos;
                if (node.mSplit == null) {
                    try {
                        pos = node.binarySearch(key);
                    }
                    catch (Throwable e) {
                        node.releaseShared();
                        throw this.cleanup(e, frame);
                    }
                    frame.bind(node, pos);
                } else {
                    try {
                        pos = node.mSplit.binarySearchLeaf(node, key);
                    }
                    catch (Throwable e) {
                        node.releaseShared();
                        throw this.cleanup(e, frame);
                    }
                    frame.bind(node, pos);
                    if (pos < 0) {
                        frame.mNotFoundKey = key;
                    }
                    node = this.mTree.finishSplitShared(frame, node);
                    pos = frame.mNodePos;
                }
                this.mFrame = frame;
                if (variant == 2) {
                    if (pos < 0) {
                        frame.mNotFoundKey = key;
                        this.mValue = null;
                    } else {
                        this.mValue = NOT_LOADED;
                    }
                    return LockResult.UNOWNED;
                }
                LockResult result = this.tryLockKey(txn);
                if (result == null) {
                    if (pos < 0) {
                        frame.mNotFoundKey = key;
                    }
                    this.mValue = NOT_LOADED;
                    node.releaseShared();
                    return this.doLoad(txn, key, frame, variant);
                }
                if (pos < 0) {
                    frame.mNotFoundKey = key;
                    this.mValue = null;
                } else {
                    try {
                        this.mValue = this.mKeyOnly ? node.hasLeafValue(pos) : node.retrieveLeafValue(pos);
                    }
                    catch (Throwable e) {
                        this.mValue = NOT_LOADED;
                        node.releaseShared();
                        throw e;
                    }
                }
                if (variant == 0) {
                    node.releaseShared();
                }
                return result;
            }
            Split split = node.mSplit;
            if (split == null) {
                int childPos;
                try {
                    childPos = Node.internalPos(node.binarySearch(key));
                }
                catch (Throwable e) {
                    node.releaseShared();
                    throw this.cleanup(e, frame);
                }
                frame.bind(node, childPos);
                try {
                    node = this.mTree.mDatabase.latchToChild(node, childPos);
                }
                catch (Throwable e) {
                    throw this.cleanup(e, frame);
                }
            }
            Node sibling = split.latchSibling();
            if (split.mSplitRight) {
                left = node;
                right = sibling;
            } else {
                left = sibling;
                right = node;
            }
            try {
                if (split.compare(key) < 0) {
                    selected = left;
                    selectedPos = Node.internalPos(left.binarySearch(key));
                    frame.bind(node, selectedPos);
                    right.releaseShared();
                } else {
                    selected = right;
                    selectedPos = Node.internalPos(right.binarySearch(key));
                    frame.bind(node, left.highestInternalPos() + 2 + selectedPos);
                    left.releaseShared();
                }
            }
            catch (Throwable e) {
                node.releaseShared();
                sibling.releaseShared();
                throw this.cleanup(e, frame);
            }
            try {
                node = this.mTree.mDatabase.latchToChild(selected, selectedPos);
            }
            catch (Throwable e) {
                throw this.cleanup(e, frame);
            }
            frame = new CursorFrame(frame);
        }
    }

    private LockResult tryLockKey(LocalTransaction txn) {
        LockMode mode;
        if (txn == null || (mode = txn.lockMode()) == LockMode.READ_COMMITTED) {
            return this.mTree.isLockAvailable(txn, this.mKey, this.mKeyHash) ? LockResult.UNOWNED : null;
        }
        try {
            if (mode.noReadLock) {
                return LockResult.UNOWNED;
            }
            LockResult result = txn.doTryLock(mode.repeatable, this.mTree.mId, this.mKey, this.mKeyHash, 0L);
            return result.isHeld() ? result : null;
        }
        catch (DeadlockException e) {
            return null;
        }
    }

    @Override
    public final LockResult random(byte[] lowKey, boolean lowInclusive, byte[] highKey, boolean highInclusive) throws IOException {
        if (!lowInclusive && lowKey != null) {
            lowKey = ViewUtils.appendZero(lowKey);
        }
        if (highInclusive && highKey != null) {
            highKey = ViewUtils.appendZero(highKey);
        }
        if (lowKey != null && highKey != null && Arrays.compareUnsigned(lowKey, highKey) >= 0) {
            this.reset();
            return LockResult.UNOWNED;
        }
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        block8: while (true) {
            this.reset();
            CursorFrame frame = new CursorFrame();
            Node node = this.latchRootNode();
            while (true) {
                int pos;
                if (node.mSplit != null) {
                    frame.bind(node, 0);
                    node = this.mTree.finishSplitShared(frame, node);
                }
                try {
                    pos = this.randomPosition(rnd, node, lowKey, highKey);
                }
                catch (Throwable e) {
                    node.releaseShared();
                    throw this.cleanup(e, frame);
                }
                if (pos < 0) {
                    this.mFrame = frame;
                    this.resetLatched(node);
                    if (!this.isRangeEmpty(lowKey, highKey)) continue block8;
                    return LockResult.UNOWNED;
                }
                frame.bindOrReposition(node, pos);
                if (node.isLeaf()) {
                    LocalTransaction txn;
                    this.mFrame = frame;
                    try {
                        txn = this.prepareFind(node.retrieveKey(pos));
                    }
                    catch (Throwable e) {
                        this.resetLatched(node);
                        throw e;
                    }
                    LockResult result = this.tryLockKey(txn);
                    if (result == null) {
                        this.mValue = NOT_LOADED;
                        node.releaseShared();
                        result = this.doLoad(txn, this.mKey, frame, 0);
                    } else {
                        try {
                            this.mValue = this.mKeyOnly ? node.hasLeafValue(pos) : node.retrieveLeafValue(pos);
                        }
                        catch (Throwable e) {
                            this.mValue = NOT_LOADED;
                            node.releaseShared();
                            throw e;
                        }
                        node.releaseShared();
                    }
                    if (this.mValue == null) {
                        if (result == LockResult.ACQUIRED) {
                            txn.doUnlock();
                        }
                        frame = this.frameSharedNotSplit();
                        if (rnd.nextBoolean()) {
                            LockResult lockResult = result = highKey == null ? this.next(txn, frame) : this.nextCmp(highKey, 2, frame);
                            if (this.mValue == null) {
                                return this.first();
                            }
                        } else {
                            LockResult lockResult = result = lowKey == null ? this.previous(txn, frame) : this.previousCmp(lowKey, -1, frame);
                            if (this.mValue == null) {
                                return this.last();
                            }
                        }
                    }
                    return result;
                }
                try {
                    node = this.mTree.mDatabase.latchToChild(node, pos);
                }
                catch (Throwable e) {
                    throw this.cleanup(e, frame);
                }
                frame = new CursorFrame(frame);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] randomNode(byte[] lowKey, byte[] highKey) throws IOException {
        if (lowKey != null && highKey != null && Arrays.compareUnsigned(lowKey, highKey) >= 0) {
            this.reset();
            return null;
        }
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        block13: while (true) {
            this.reset();
            CursorFrame frame = new CursorFrame();
            Node node = this.latchRootNode();
            int remainingAttemptsBIN = 2;
            int remainingAttemptsLN = 2;
            while (true) {
                int pos;
                if (node.mSplit != null) {
                    frame.bindOrReposition(node, 0);
                    node = this.mTree.finishSplitShared(frame, node);
                }
                if (node.isLeaf()) {
                    pos = node.highestLeafPos() >> 31;
                } else {
                    try {
                        pos = this.randomPosition(rnd, node, lowKey, highKey);
                    }
                    catch (Throwable e) {
                        node.releaseShared();
                        throw this.cleanup(e, frame);
                    }
                }
                if (pos < 0) {
                    this.mFrame = frame;
                    this.resetLatched(node);
                    if (!this.isRangeEmpty(lowKey, highKey)) continue block13;
                    return null;
                }
                frame.bindOrReposition(node, pos);
                if (node.isLeaf()) {
                    LocalTransaction txn;
                    byte[] startKey = node.retrieveKey(pos);
                    int highPos = node.highestLeafPos();
                    byte[] endKey = highPos == pos ? startKey : node.retrieveKey(highPos);
                    this.mFrame = frame;
                    try {
                        txn = this.prepareFind(startKey);
                    }
                    catch (Throwable e) {
                        this.resetLatched(node);
                        throw e;
                    }
                    if (this.tryLockKey(txn) == null) {
                        this.mValue = NOT_LOADED;
                        node.releaseShared();
                        this.doLoad(txn, this.mKey, frame, 0);
                    } else {
                        try {
                            this.mValue = this.mKeyOnly ? node.hasLeafValue(pos) : node.retrieveLeafValue(pos);
                        }
                        catch (Throwable e) {
                            this.mValue = NOT_LOADED;
                            node.releaseShared();
                            throw e;
                        }
                        node.releaseShared();
                    }
                    return endKey;
                }
                long childId = node.retrieveChildRefId(pos);
                Node child = this.mTree.mDatabase.nodeMapGet(childId);
                if (child != null) {
                    if (node.isBottomInternal()) {
                        if (--remainingAttemptsLN >= 0) continue;
                        try {
                            int spos = 0;
                            if (lowKey != null) {
                                spos = Node.internalPos(node.binarySearch(lowKey));
                            }
                            int highestInternalPos = node.highestInternalPos();
                            int highestKeyPos = node.highestKeyPos();
                            while (spos <= highestInternalPos) {
                                childId = node.retrieveChildRefId(spos);
                                child = this.mTree.mDatabase.nodeMapGet(childId);
                                if (child == null) {
                                    pos = spos;
                                    frame.bindOrReposition(node, pos);
                                }
                                if (highKey != null && spos <= highestKeyPos && node.compareKey(spos, highKey) >= 0) break;
                                spos += 2;
                            }
                        }
                        catch (Throwable spos) {}
                    } else {
                        child.acquireShared();
                        try {
                            if (childId == child.id() && child.isBottomInternal() && --remainingAttemptsBIN >= 0) {
                                continue;
                            }
                        }
                        finally {
                            child.releaseShared();
                            continue;
                        }
                    }
                }
                try {
                    node = this.mTree.mDatabase.latchToChild(node, pos);
                }
                catch (Throwable e) {
                    throw this.cleanup(e, frame);
                }
                frame = new CursorFrame(frame);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockResult doLoad(LocalTransaction txn, byte[] key, CursorFrame leaf, int variant) throws IOException {
        Locker locker;
        LockResult result;
        if (txn == null) {
            result = LockResult.UNOWNED;
            locker = this.mTree.lockSharedLocal(key, this.keyHash());
        } else {
            LockMode mode = txn.lockMode();
            if (mode.noReadLock) {
                result = LockResult.UNOWNED;
                locker = null;
            } else {
                int keyHash = this.keyHash();
                if (mode == LockMode.READ_COMMITTED) {
                    result = txn.doLockShared(this.mTree.mId, key, keyHash);
                    if (result == LockResult.ACQUIRED) {
                        result = LockResult.UNOWNED;
                        locker = txn;
                    } else {
                        locker = null;
                    }
                } else {
                    result = txn.doLock(mode.repeatable, this.mTree.mId, key, keyHash, txn.mLockTimeoutNanos);
                    locker = null;
                }
            }
        }
        try {
            Node node = leaf.acquireShared();
            if (node.mSplit != null) {
                node = this.mTree.finishSplitShared(leaf, node);
            }
            try {
                int pos = leaf.mNodePos;
                this.mValue = pos < 0 ? null : (this.mKeyOnly ? node.hasLeafValue(pos) : node.retrieveLeafValue(pos));
            }
            catch (Throwable e) {
                node.releaseShared();
                throw e;
            }
            if (variant == 0) {
                node.releaseShared();
            }
            LockResult lockResult = result;
            return lockResult;
        }
        finally {
            if (locker != null) {
                locker.doUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IndexStats analyze() throws IOException {
        double valueBytes;
        double keyBytes;
        double totalBytes;
        double freeBytes;
        double entryCount;
        CursorFrame frame = this.frameSharedNotSplit();
        Node node = frame.mNode;
        try {
            int numKeys;
            entryCount = node.numKeys();
            int pos = frame.mNodePos;
            freeBytes = node.availableBytes();
            totalBytes = this.pageSize(node.mPage);
            if (pos < 0 || (numKeys = node.numKeys()) <= 0) {
                keyBytes = 0.0;
                valueBytes = 0.0;
            } else {
                long[] stats = new long[2];
                node.retrieveKeyStats(pos, stats);
                keyBytes = (double)stats[0] * (double)numKeys;
                totalBytes += (double)stats[1] * (double)this.pageSize(node.mPage);
                node.retrieveLeafValueStats(pos, stats);
                valueBytes = (double)stats[0] * (double)numKeys;
                totalBytes += (double)stats[1] * (double)this.pageSize(node.mPage);
            }
            frame = frame.pop();
        }
        catch (Throwable e) {
            this.resetLatched(node);
            throw e;
        }
        node.releaseShared();
        while (frame != null) {
            int pageSize;
            int availBytes;
            double scalar;
            node = frame.acquireShared();
            try {
                scalar = node.numKeys() + 1;
                availBytes = node.availableInternalBytes();
                pageSize = this.pageSize(node.mPage);
                frame = frame.pop();
            }
            finally {
                node.releaseShared();
            }
            entryCount *= scalar;
            keyBytes *= scalar;
            valueBytes *= scalar;
            freeBytes *= scalar;
            totalBytes *= scalar;
            freeBytes += (double)availBytes;
            totalBytes += (double)pageSize;
        }
        return new IndexStats(entryCount, keyBytes, valueBytes, freeBytes, totalBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean exists() throws IOException {
        CursorFrame leaf = this.frameSharedNotSplit();
        Node node = leaf.mNode;
        try {
            LockManager manager;
            int pos = leaf.mNodePos;
            if (pos < 0) {
                boolean bl = false;
                return bl;
            }
            if (this.mTxn == null || (manager = this.mTxn.mManager) == null || node.hasLeafValue(pos) != null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = !manager.check(this.mTxn, this.mTree.mId, this.mKey, this.keyHash()).isHeld();
            return bl;
        }
        finally {
            node.releaseShared();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockResult lock() throws IOException {
        LockResult result;
        Locker locker;
        byte[] key = this.mKey;
        ViewUtils.positionCheck(key);
        CursorFrame leaf = this.frame();
        LocalTransaction txn = this.mTxn;
        try {
            if (txn == null) {
                int keyHash = this.keyHash();
                if (this.tryLockLoad(txn, key, keyHash, this.mKeyOnly, leaf)) {
                    return LockResult.UNOWNED;
                }
                locker = this.mTree.lockSharedLocal(key, keyHash);
                result = LockResult.UNOWNED;
            } else {
                LockMode mode = txn.lockMode();
                if (mode.noReadLock) {
                    return LockResult.UNOWNED;
                }
                int keyHash = this.keyHash();
                if (mode == LockMode.READ_COMMITTED) {
                    if (this.tryLockLoad(txn, key, keyHash, this.mKeyOnly, leaf)) {
                        return LockResult.UNOWNED;
                    }
                    result = txn.doLockShared(this.mTree.mId, key, keyHash);
                    if (result != LockResult.ACQUIRED) {
                        return result;
                    }
                    result = LockResult.UNOWNED;
                    locker = txn;
                } else {
                    result = txn.doLock(mode.repeatable, this.mTree.mId, key, keyHash, txn.mLockTimeoutNanos);
                    if (result != LockResult.ACQUIRED) {
                        return result;
                    }
                    locker = null;
                }
            }
        }
        catch (LockFailureException e) {
            this.mValue = NOT_LOADED;
            throw e;
        }
        try {
            Node node = leaf.acquireShared();
            if (node.mSplit != null) {
                node = this.mTree.finishSplitShared(leaf, node);
            }
            try {
                int pos = leaf.mNodePos;
                this.mValue = pos < 0 ? null : (this.mKeyOnly ? node.hasLeafValue(pos) : node.retrieveLeafValue(pos));
            }
            finally {
                node.releaseShared();
            }
            LockResult lockResult = result;
            return lockResult;
        }
        finally {
            if (locker != null) {
                locker.doUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockResult load() throws IOException {
        LockResult result;
        Locker locker;
        byte[] key = this.mKey;
        ViewUtils.positionCheck(key);
        CursorFrame leaf = this.frame();
        LocalTransaction txn = this.mTxn;
        try {
            if (txn == null) {
                int keyHash = this.keyHash();
                if (this.tryLockLoad(txn, key, keyHash, false, leaf)) {
                    return LockResult.UNOWNED;
                }
                locker = this.mTree.lockSharedLocal(key, keyHash);
                result = LockResult.UNOWNED;
            } else {
                LockMode mode = txn.lockMode();
                if (mode.noReadLock) {
                    result = LockResult.UNOWNED;
                    locker = null;
                } else {
                    int keyHash = this.keyHash();
                    if (mode == LockMode.READ_COMMITTED) {
                        if (this.tryLockLoad(txn, key, keyHash, false, leaf)) {
                            return LockResult.UNOWNED;
                        }
                        result = txn.doLockShared(this.mTree.mId, key, keyHash);
                        if (result == LockResult.ACQUIRED) {
                            result = LockResult.UNOWNED;
                            locker = txn;
                        } else {
                            locker = null;
                        }
                    } else {
                        result = txn.doLock(mode.repeatable, this.mTree.mId, key, keyHash, txn.mLockTimeoutNanos);
                        locker = null;
                    }
                }
            }
        }
        catch (LockFailureException e) {
            this.mValue = NOT_LOADED;
            throw e;
        }
        try {
            Node node = leaf.acquireShared();
            if (node.mSplit != null) {
                node = this.mTree.finishSplitShared(leaf, node);
            }
            try {
                int pos = leaf.mNodePos;
                this.mValue = pos < 0 ? null : node.retrieveLeafValue(pos);
            }
            finally {
                node.releaseShared();
            }
            LockResult lockResult = result;
            return lockResult;
        }
        finally {
            if (locker != null) {
                locker.doUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryLockLoad(LocalTransaction txn, byte[] key, int keyHash, boolean keyOnly, CursorFrame leaf) throws IOException {
        Node node = leaf.tryAcquireShared();
        if (node != null) {
            if (node.mSplit != null) {
                node = this.mTree.finishSplitShared(leaf, node);
            }
            try {
                if (this.mTree.isLockAvailable(txn, key, keyHash)) {
                    int pos = leaf.mNodePos;
                    if (pos >= 0) {
                        this.mValue = keyOnly ? node.hasLeafValue(pos) : node.retrieveLeafValue(pos);
                    } else {
                        PageOps.checkClosedIndexException(node.mPage);
                        this.mValue = null;
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                node.releaseShared();
            }
        }
        return false;
    }

    private boolean allowRedo() {
        return !(this.mTree instanceof BTree.Temp);
    }

    private boolean requireTransaction() {
        return this.mTree instanceof BTree.Repl;
    }

    @Override
    public final void store(byte[] value) throws IOException {
        if (this.mTxn == null) {
            this.storeAutoCommit(value);
        } else {
            this.txnStore(value);
        }
    }

    private void txnStore(byte[] value) throws IOException {
        byte[] key = this.mKey;
        ViewUtils.positionCheck(key);
        try {
            if (this.mTxn.lockMode() != LockMode.UNSAFE) {
                this.mTxn.doLockExclusive(this.mTree.mId, key, this.keyHash());
            }
            if (this.allowRedo()) {
                this.storeAndMaybeRedo(this.mTxn, value);
            } else {
                this.storeNoRedo(this.mTxn, value);
            }
        }
        catch (Throwable e) {
            throw this.handleException(e, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeAutoCommit(byte[] value) throws IOException {
        byte[] key = this.mKey;
        ViewUtils.positionCheck(key);
        try {
            LocalTransaction txn;
            if (!this.allowRedo()) {
                txn = LocalTransaction.BOGUS;
            } else if (!this.requireTransaction()) {
                txn = null;
            } else {
                LocalDatabase db = this.mTree.mDatabase;
                LocalTransaction txn2 = db.threadLocalTransaction(Utils.alwaysRedo(db.mDurabilityMode));
                try {
                    txn2.doLockExclusive(this.mTree.mId, key, this.keyHash());
                    txn2.storeCommit(txn2, this, value);
                    return;
                }
                catch (Throwable e) {
                    db.removeThreadLocalTransaction();
                    txn2.reset();
                    throw e;
                }
            }
            Locker locker = this.mTree.lockExclusiveLocal(key, this.keyHash());
            try {
                this.storeAndMaybeRedo(txn, value);
            }
            finally {
                locker.doUnlock();
            }
        }
        catch (Throwable e) {
            throw this.handleException(e, false);
        }
    }

    @Override
    public final void commit(byte[] value) throws IOException {
        if (this.mTxn == null) {
            this.storeAutoCommit(value);
        } else {
            this.txnCommit(value);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void txnCommit(byte[] value) throws IOException {
        key = this.mKey;
        ViewUtils.positionCheck(key);
        try {
            block5: {
                if (this.mTxn.lockMode() == LockMode.UNSAFE) break block5;
                this.mTxn.doLockExclusive(this.mTree.mId, key, this.keyHash());
                if (this.allowRedo() && this.mTxn.mDurabilityMode != DurabilityMode.NO_REDO) {
                    this.mTxn.storeCommit(this.requireTransaction() != false ? this.mTxn : LocalTransaction.BOGUS, this, value);
                    return;
                }
                ** GOTO lbl-1000
            }
            if (this.allowRedo()) {
                this.storeAndMaybeRedo(this.mTxn, value);
            } else lbl-1000:
            // 2 sources

            {
                this.storeNoRedo(this.mTxn, value);
            }
            this.mTxn.commit();
        }
        catch (Throwable e) {
            throw this.handleException(e, false);
        }
    }

    final byte[] findAndStore(byte[] key, byte[] value) throws IOException {
        if (this.mTxn == null) {
            return this.findAndStoreAutoCommit(key, value);
        }
        return this.txnFindAndStore(key, value);
    }

    private byte[] txnFindAndStore(byte[] key, byte[] value) throws IOException {
        this.mKey = key;
        try {
            if (this.mTxn.lockMode() == LockMode.UNSAFE) {
                this.mKeyHash = 0;
            } else {
                int hash;
                this.mKeyHash = hash = LockManager.hash(this.mTree.mId, key);
                this.mTxn.doLockExclusive(this.mTree.mId, key, hash);
            }
            return this.doFindAndStore(this.mTxn, key, value);
        }
        catch (Throwable e) {
            throw this.handleException(e, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] findAndStoreAutoCommit(byte[] key, byte[] value) throws IOException {
        LocalTransaction txn;
        int hash;
        this.mKey = key;
        this.mKeyHash = hash = LockManager.hash(this.mTree.mId, key);
        if (!this.allowRedo()) {
            txn = LocalTransaction.BOGUS;
        } else if (!this.requireTransaction()) {
            txn = null;
        } else {
            LocalDatabase db = this.mTree.mDatabase;
            LocalTransaction txn2 = db.threadLocalTransaction(Utils.alwaysRedo(db.mDurabilityMode));
            try {
                txn2.doLockExclusive(this.mTree.mId, key, hash);
                byte[] result = this.doFindAndStore(txn2, key, value);
                txn2.commit();
                return result;
            }
            catch (Throwable e) {
                db.removeThreadLocalTransaction();
                txn2.reset();
                throw e;
            }
        }
        Locker locker = this.mTree.lockExclusiveLocal(key, hash);
        try {
            byte[] byArray = this.doFindAndStore(txn, key, value);
            locker.doUnlock();
            return byArray;
        }
        catch (Throwable throwable) {
            try {
                locker.doUnlock();
                throw throwable;
            }
            catch (Throwable e) {
                throw this.handleException(e, false);
            }
        }
    }

    private byte[] doFindAndStore(LocalTransaction txn, byte[] key, byte[] value) throws IOException {
        this.find(null, key, 2, new CursorFrame(), this.latchRootNode());
        CursorFrame leaf = this.mFrame;
        CommitLock.Shared shared = this.prepareStoreUpgrade(leaf, value);
        byte[] originalValue = null;
        int pos = leaf.mNodePos;
        if (pos >= 0 && !this.mKeyOnly) {
            Node node = leaf.mNode;
            try {
                originalValue = node.retrieveLeafValue(pos);
            }
            catch (Throwable e) {
                node.releaseExclusive();
                shared.release();
                throw e;
            }
        }
        if (value == null) {
            this.deleteNoRedo(txn, leaf);
        } else {
            this.storeNoRedo(txn, leaf, value);
        }
        if (this.allowRedo()) {
            this.maybeRedoStore(txn, shared, value);
        } else {
            shared.release();
        }
        return originalValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final boolean findAndModify(byte[] key, byte[] oldValue, byte[] newValue) throws IOException {
        this.mKey = key;
        LocalTransaction txn = this.mTxn;
        try {
            LockResult result;
            if (txn == null) {
                int hash;
                this.mKeyHash = hash = LockManager.hash(this.mTree.mId, key);
                if (!this.allowRedo()) {
                    txn = LocalTransaction.BOGUS;
                } else if (this.requireTransaction()) {
                    LocalDatabase db = this.mTree.mDatabase;
                    txn = db.threadLocalTransaction(Utils.alwaysRedo(db.mDurabilityMode));
                    try {
                        txn.doLockExclusive(this.mTree.mId, key, hash);
                        boolean result2 = this.doFindAndModify(txn, key, oldValue, newValue);
                        txn.commit();
                        return result2;
                    }
                    catch (Throwable e) {
                        db.removeThreadLocalTransaction();
                        txn.reset();
                        throw e;
                    }
                }
                Locker locker = this.mTree.lockExclusiveLocal(key, hash);
                try {
                    boolean e = this.doFindAndModify(txn, key, oldValue, newValue);
                    return e;
                }
                finally {
                    locker.doUnlock();
                }
            }
            LockMode mode = txn.lockMode();
            if (mode == LockMode.UNSAFE) {
                this.mKeyHash = 0;
                result = LockResult.OWNED_EXCLUSIVE;
            } else {
                int hash;
                this.mKeyHash = hash = LockManager.hash(this.mTree.mId, key);
                result = txn.doLockExclusive(this.mTree.mId, key, hash);
                if (result == LockResult.ACQUIRED && mode.repeatable != 0) {
                    result = LockResult.UPGRADED;
                }
            }
            try {
                if (this.doFindAndModify(txn, key, oldValue, newValue)) {
                    return true;
                }
            }
            catch (Throwable e) {
                try {
                    if (result == LockResult.ACQUIRED) {
                        txn.doUnlock();
                        throw e;
                    }
                    if (result != LockResult.UPGRADED) throw e;
                    txn.doUnlockToUpgradable();
                    throw e;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw e;
            }
            if (result == LockResult.ACQUIRED) {
                txn.doUnlock();
                return false;
            }
            if (result != LockResult.UPGRADED) return false;
            txn.doUnlockToUpgradable();
            return false;
        }
        catch (Throwable e) {
            throw this.handleException(e, false);
        }
    }

    private boolean doFindAndModify(LocalTransaction txn, byte[] key, byte[] oldValue, byte[] newValue) throws IOException {
        CommitLock.Shared shared;
        boolean exclusive;
        Node node;
        CursorFrame leaf;
        block22: {
            block23: {
                this.find(null, key, 2, new CursorFrame(), this.latchRootNode());
                leaf = this.mFrame;
                node = leaf.mNode;
                exclusive = false;
                CommitLock commitLock = this.mTree.mDatabase.commitLock();
                shared = commitLock.tryAcquireShared();
                if (shared != null) break block22;
                node.releaseShared();
                shared = commitLock.acquireShared();
                node = leaf.acquireShared();
                if (node.mSplit == null) break block22;
                exclusive = true;
                if (node.tryUpgrade()) break block23;
                node.releaseShared();
                node = leaf.acquireExclusive();
                if (node.mSplit == null) break block22;
            }
            node = this.mTree.finishSplit(leaf, node);
        }
        while (true) {
            block26: {
                block25: {
                    byte[] originalValue;
                    int pos;
                    block27: {
                        block24: {
                            pos = leaf.mNodePos;
                            if (oldValue != MODIFY_INSERT) break block24;
                            if (pos >= 0 && node.hasLeafValue(pos) != null) break block25;
                            break block26;
                        }
                        if (oldValue != MODIFY_REPLACE) break block27;
                        if (pos < 0 || node.hasLeafValue(pos) == null) break block25;
                        break block26;
                    }
                    if (pos < 0) {
                        originalValue = null;
                    } else {
                        try {
                            originalValue = node.retrieveLeafValue(pos);
                        }
                        catch (Throwable e) {
                            node.releaseExclusive();
                            shared.release();
                            throw e;
                        }
                    }
                    if (oldValue == MODIFY_UPDATE ? !Arrays.equals(originalValue, newValue) : Arrays.equals(oldValue, originalValue)) break block26;
                }
                node.release(exclusive);
                shared.release();
                return false;
            }
            try {
                if (this.notSplitDirtyUpgrade(leaf, exclusive)) {
                    break;
                }
            }
            catch (Throwable e) {
                shared.release();
                throw e;
            }
            exclusive = true;
            node = leaf.mNode;
        }
        if (newValue == null) {
            this.deleteNoRedo(txn, leaf);
        } else {
            this.storeNoRedo(txn, leaf, newValue);
        }
        if (this.allowRedo()) {
            this.maybeRedoStore(txn, shared, newValue);
        } else {
            shared.release();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final boolean deleteGhost(byte[] key) throws IOException {
        try {
            this.find(null, key, 2, new CursorFrame(), this.latchRootNode());
            try {
                CursorFrame leaf = this.mFrame;
                CommitLock.Shared shared = this.prepareStoreUpgrade(leaf, null);
                Node node = leaf.mNode;
                if (PageOps.isClosedOrDeleted(node.mPage)) {
                    node.releaseExclusive();
                    shared.release();
                    boolean bl = false;
                    return bl;
                }
                int pos = leaf.mNodePos;
                if (pos >= 0 && node.hasLeafValue(pos) == null) {
                    this.deleteNoRedo(LocalTransaction.BOGUS, leaf);
                } else {
                    node.releaseExclusive();
                }
                shared.release();
                boolean bl = true;
                return bl;
            }
            finally {
                this.reset();
            }
        }
        catch (Throwable e) {
            throw this.handleException(e, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void storeGhost(GhostFrame ghost) throws IOException {
        CommitLock.Shared shared = this.prepareStore();
        this.storeNoRedo(null, this.mFrame, Utils.EMPTY_BYTES);
        try {
            CursorFrame leaf = this.frameExclusive();
            this.notSplitDirty(leaf);
            Node node = leaf.mNode;
            int pos = leaf.mNodePos;
            try {
                if (pos >= 0) {
                    byte[] page = node.mPage;
                    int loc = PageOps.p_ushortGetLE(page, node.searchVecStart() + pos);
                    if (PageOps.p_byteGet(page, loc += Node.keyLengthAtLoc(page, loc)) == 0) {
                        if (ghost != null) {
                            ghost.bind(node, pos);
                            this.mTree.mLockManager.ghosted(this.mTree.mId, this.mKey, this.keyHash(), ghost);
                        }
                        PageOps.p_bytePut(page, loc, -1);
                        this.mValue = null;
                    }
                }
            }
            finally {
                node.releaseExclusive();
            }
        }
        finally {
            shared.release();
        }
    }

    final void storeNoRedo(LocalTransaction txn, byte[] value) throws IOException {
        this.doStoreNoRedo(txn, value).release();
    }

    final void storeAndMaybeRedo(LocalTransaction txn, byte[] value) throws IOException {
        this.maybeRedoStore(txn, this.doStoreNoRedo(txn, value), value);
    }

    private CommitLock.Shared doStoreNoRedo(LocalTransaction txn, byte[] value) throws IOException {
        CommitLock.Shared shared;
        if (value == null) {
            shared = this.mTree.mDatabase.commitLock().acquireShared();
            CursorFrame leaf = this.frameExclusive();
            if (leaf.mNodePos >= 0) {
                try {
                    this.notSplitDirty(leaf);
                }
                catch (Throwable e) {
                    shared.release();
                    throw e;
                }
            }
            this.deleteNoRedo(txn, this.mFrame);
        } else {
            shared = this.prepareStore();
            this.storeNoRedo(txn, this.mFrame, value);
        }
        this.mValue = value;
        return shared;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeRedoStore(LocalTransaction txn, CommitLock.Shared shared, byte[] value) throws IOException {
        if (txn == null) {
            long commitPos;
            try {
                commitPos = this.mTree.redoStoreNullTxn(this.mKey, value);
            }
            finally {
                shared.release();
            }
            if (commitPos != 0L) {
                this.mTree.txnCommitSync(commitPos);
            }
        } else {
            long commitPos;
            try {
                if (txn.mDurabilityMode == DurabilityMode.NO_REDO) {
                    return;
                }
                if (txn.lockMode() != LockMode.UNSAFE) {
                    long cursorId = this.mCursorId;
                    if (cursorId == 0L) {
                        txn.redoStore(this.mTree.mId, this.mKey, value);
                    } else {
                        txn.redoCursorStore(cursorId & Long.MAX_VALUE, this.mKey, value);
                        this.mCursorId = cursorId | Long.MIN_VALUE;
                    }
                    return;
                }
                commitPos = txn.redoStoreNoLock(this.mTree.mId, this.mKey, value);
            }
            finally {
                shared.release();
            }
            if (commitPos != 0L) {
                txn.mRedo.txnCommitSync(commitPos);
            }
        }
    }

    private void deleteNoRedo(LocalTransaction txn, CursorFrame leaf) throws IOException {
        try {
            Node node = leaf.mNode;
            int pos = leaf.mNodePos;
            if (pos >= 0) {
                byte[] key = this.mKey;
                try {
                    if (txn != null && txn.lockMode() != LockMode.UNSAFE) {
                        node.txnDeleteLeafEntry(txn, this.mTree, key, this.keyHash(), pos);
                    } else {
                        node.deleteLeafEntry(pos);
                        node.postDelete(pos, key);
                    }
                }
                catch (Throwable e) {
                    node.releaseExclusive();
                    throw e;
                }
                if (node.shouldLeafMerge()) {
                    this.mergeLeaf(leaf, node);
                    return;
                }
            }
            node.releaseExclusive();
        }
        catch (Throwable e) {
            this.mTree.mDatabase.commitLock().unlock();
            Utils.rethrowIfRecoverable(e);
            if (txn != null) {
                txn.reset(e);
            }
            throw e;
        }
    }

    private CommitLock.Shared prepareStore() throws IOException {
        CommitLock.Shared shared = this.mTree.mDatabase.commitLock().acquireShared();
        CursorFrame leaf = this.frameExclusive();
        try {
            this.notSplitDirty(leaf);
        }
        catch (Throwable e) {
            shared.release();
            throw e;
        }
        return shared;
    }

    private CommitLock.Shared prepareStoreUpgrade(CursorFrame leaf, byte[] value) throws IOException {
        CommitLock.Shared shared;
        block4: {
            block5: {
                CommitLock commitLock;
                block3: {
                    commitLock = this.mTree.mDatabase.commitLock();
                    shared = commitLock.tryAcquireShared();
                    if (shared == null) break block3;
                    if (leaf.mNode.tryUpgrade()) break block4;
                    leaf.mNode.releaseShared();
                    break block5;
                }
                leaf.mNode.releaseShared();
                shared = commitLock.acquireShared();
            }
            leaf.acquireExclusive();
        }
        if (value != null || leaf.mNodePos >= 0) {
            try {
                this.notSplitDirty(leaf);
            }
            catch (Throwable e) {
                shared.release();
                throw e;
            }
        }
        return shared;
    }

    private void storeNoRedo(LocalTransaction txn, CursorFrame leaf, byte[] value) throws IOException {
        block13: {
            try {
                Node node = leaf.mNode;
                int pos = leaf.mNodePos;
                byte[] key = this.mKey;
                if (pos >= 0) {
                    try {
                        if (txn != null && txn.lockMode() != LockMode.UNSAFE) {
                            node.txnPreUpdateLeafEntry(txn, this.mTree, pos);
                        }
                        node.updateLeafValue(this.mTree, pos, 0, value);
                    }
                    catch (Throwable e) {
                        node.releaseExclusive();
                        throw e;
                    }
                    if (node.shouldLeafMerge()) {
                        this.mergeLeaf(leaf, node);
                    } else {
                        if (node.mSplit != null) {
                            node = this.mTree.finishSplitCritical(leaf, node);
                        }
                        node.releaseExclusive();
                    }
                    break block13;
                }
                try {
                    if (txn != null && txn.lockMode() != LockMode.UNSAFE) {
                        txn.pushUninsert(this.mTree.mId, key);
                    }
                    node.insertLeafEntry(leaf, this.mTree, ~pos, key, value);
                }
                catch (Throwable e) {
                    node.releaseExclusive();
                    throw e;
                }
                node = this.postInsert(leaf, node, key);
                node.releaseExclusive();
            }
            catch (Throwable e) {
                this.mTree.mDatabase.commitLock().unlock();
                Utils.rethrowIfRecoverable(e);
                if (txn != null) {
                    txn.reset(e);
                }
                throw e;
            }
        }
    }

    Node postInsert(CursorFrame leaf, Node node, byte[] key) throws IOException {
        int newPos;
        int pos = leaf.mNodePos;
        leaf.mNodePos = newPos = ~pos;
        leaf.mNotFoundKey = null;
        CursorFrame frame = node.mLastCursorFrame;
        do {
            if (frame == leaf) continue;
            int framePos = frame.mNodePos;
            if (framePos == pos) {
                byte[] frameKey = frame.mNotFoundKey;
                if (frameKey == null) continue;
                int compare = Arrays.compareUnsigned(frameKey, key);
                if (compare > 0) {
                    frame.mNodePos = framePos - 2;
                    continue;
                }
                if (compare != 0) continue;
                frame.mNodePos = newPos;
                frame.mNotFoundKey = null;
                continue;
            }
            if (framePos >= newPos) {
                frame.mNodePos = framePos + 2;
                continue;
            }
            if (framePos >= pos) continue;
            frame.mNodePos = framePos - 2;
        } while ((frame = frame.mPrevCousin) != null);
        if (node.mSplit != null) {
            node = this.mTree.finishSplitCritical(leaf, node);
        }
        return node;
    }

    final void storeFragmented(byte[] value) throws IOException {
        ViewUtils.positionCheck(this.mKey);
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        CommitLock.Shared shared = this.prepareStore();
        CursorFrame leaf = this.mFrame;
        Node node = leaf.mNode;
        try {
            int pos = leaf.mNodePos;
            if (pos >= 0) {
                try {
                    node.updateLeafValue(this.mTree, pos, 64, value);
                }
                catch (Throwable e) {
                    node.releaseExclusive();
                    throw e;
                }
                if (node.mSplit != null) {
                    node = this.mTree.finishSplitCritical(leaf, node);
                }
            } else {
                byte[] key = this.mKey;
                try {
                    node.insertFragmentedLeafEntry(leaf, this.mTree, ~pos, key, value);
                }
                catch (Throwable e) {
                    node.releaseExclusive();
                    throw e;
                }
                node = this.postInsert(leaf, node, key);
            }
            this.mValue = NOT_LOADED;
            node.releaseExclusive();
        }
        catch (Throwable e) {
            throw this.handleException(e, false);
        }
        finally {
            shared.release();
        }
    }

    final Node insertBlank(CursorFrame leaf, Node node, long vlength) throws IOException {
        byte[] key = this.mKey;
        try {
            node.insertBlankLeafEntry(leaf, this.mTree, ~leaf.mNodePos, key, vlength);
        }
        catch (Throwable e) {
            node.releaseExclusive();
            throw e;
        }
        return this.postInsert(leaf, node, key);
    }

    /*
     * Exception decompiling
     */
    final boolean deleteAll() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void deleteNext() throws IOException {
        Node node;
        LocalDatabase db = this.mTree.mDatabase;
        CommitLock commitLock = db.commitLock();
        CommitLock.Shared shared = commitLock.acquireShared();
        while (true) {
            try {
                if (db.isClosed()) {
                    throw new ClosedIndexException();
                }
                this.mFrame.acquireExclusive();
                node = this.notSplitDirty(this.mFrame);
                if (node.hasKeys()) {
                    try {
                        node.deleteLeafEntry(0);
                    }
                    catch (Throwable e) {
                        node.releaseExclusive();
                        throw e;
                    }
                    if (node.hasKeys()) break;
                }
                if (!this.deleteLowestNode(this.mFrame, node)) {
                    this.mFrame = null;
                    this.reset();
                    shared.release();
                    return;
                }
                this.mFrame.acquireExclusive();
                node = this.notSplitDirty(this.mFrame);
                if (node.hasKeys()) break;
                node.releaseExclusive();
            }
            catch (Throwable e) {
                shared.release();
                throw e;
            }
            if (!commitLock.hasQueuedThreads()) continue;
            shared.release();
            commitLock.acquireShared(shared);
        }
        shared.release();
        try {
            this.mKey = node.retrieveKey(0);
            if (!this.mKeyOnly) {
                this.mValue = node.retrieveLeafValue(0);
            }
        }
        finally {
            node.releaseExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteLowestNode(CursorFrame frame, Node node) throws IOException {
        node.mLastCursorFrame = null;
        LocalDatabase db = this.mTree.mDatabase;
        if (node == this.mTree.mRoot) {
            try {
                node.asTrimmedRoot();
            }
            finally {
                node.releaseExclusive();
            }
            return false;
        }
        db.prepareToDelete(node);
        CursorFrame parentFrame = frame.mParentFrame;
        Node parentNode = parentFrame.acquireExclusive();
        if (parentNode.hasKeys()) {
            parentNode.deleteLowestChildRef();
        } else {
            if (!this.deleteLowestNode(parentFrame, parentNode)) {
                db.finishDeleteNode(node);
                return false;
            }
            parentNode = parentFrame.acquireExclusive();
        }
        Node next = db.latchChildRetainParentEx(parentNode, 0, true);
        try {
            if (db.markDirty(this.mTree, next)) {
                parentNode.updateChildRefId(0, next.id());
            }
        }
        finally {
            parentNode.releaseExclusive();
        }
        frame.mNode = next;
        frame.mNodePos = 0;
        next.mLastCursorFrame = frame;
        next.type((byte)(next.type() | 2));
        next.releaseExclusive();
        db.finishDeleteNode(node);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void deletePrevious() throws IOException {
        Node node;
        LocalDatabase db = this.mTree.mDatabase;
        CommitLock commitLock = db.commitLock();
        CommitLock.Shared shared = commitLock.acquireShared();
        while (true) {
            try {
                if (db.isClosed()) {
                    throw new ClosedIndexException();
                }
                this.mFrame.acquireExclusive();
                node = this.notSplitDirty(this.mFrame);
                if (node.hasKeys()) {
                    try {
                        node.deleteLeafEntry(node.highestLeafPos());
                    }
                    catch (Throwable e) {
                        node.releaseExclusive();
                        throw e;
                    }
                    if (node.hasKeys()) break;
                }
                if (!this.deleteHighestNode(this.mFrame, node)) {
                    this.mFrame = null;
                    this.reset();
                    shared.release();
                    return;
                }
                this.mFrame.acquireExclusive();
                node = this.notSplitDirty(this.mFrame);
                if (node.hasKeys()) {
                    break;
                }
            }
            catch (Throwable e) {
                shared.release();
                throw e;
            }
            if (!commitLock.hasQueuedThreads()) continue;
            shared.release();
            commitLock.acquireShared(shared);
        }
        shared.release();
        try {
            int pos = node.highestLeafPos();
            this.mKey = node.retrieveKey(pos);
            if (!this.mKeyOnly) {
                this.mValue = node.retrieveLeafValue(pos);
            }
        }
        finally {
            node.releaseExclusive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteHighestNode(CursorFrame frame, Node node) throws IOException {
        node.mLastCursorFrame = null;
        LocalDatabase db = this.mTree.mDatabase;
        if (node == this.mTree.mRoot) {
            try {
                node.asTrimmedRoot();
            }
            finally {
                node.releaseExclusive();
            }
            return false;
        }
        db.prepareToDelete(node);
        CursorFrame parentFrame = frame.mParentFrame;
        Node parentNode = parentFrame.acquireExclusive();
        if (parentNode.hasKeys()) {
            parentNode.deleteRightChildRef(parentNode.highestInternalPos());
        } else {
            if (!this.deleteHighestNode(parentFrame, parentNode)) {
                db.finishDeleteNode(node);
                return false;
            }
            parentNode = parentFrame.acquireExclusive();
        }
        int pos = parentNode.highestInternalPos();
        Node previous = this.mTree.mDatabase.latchChildRetainParentEx(parentNode, pos, true);
        try {
            if (db.markDirty(this.mTree, previous)) {
                parentNode.updateChildRefId(pos, previous.id());
            }
        }
        finally {
            parentNode.releaseExclusive();
        }
        frame.mNode = previous;
        frame.mNodePos = previous.highestPos();
        previous.mLastCursorFrame = frame;
        previous.type((byte)(previous.type() | 8));
        previous.releaseExclusive();
        db.finishDeleteNode(node);
        return true;
    }

    private int randomPosition(ThreadLocalRandom rnd, Node node, byte[] lowKey, byte[] highKey) throws IOException {
        int pos;
        if (highKey == null) {
            pos = node.highestPos() + 2;
        } else {
            pos = node.binarySearch(highKey);
            if (pos < 0) {
                pos ^= 0xFFFFFFFF;
            }
            if (!node.isLeaf()) {
                pos += 2;
            }
        }
        if (lowKey == null) {
            if (pos > 0) {
                pos = pos == 2 ? 0 : rnd.nextInt(pos >> 1) << 1;
                return pos;
            }
        } else {
            int lowPos = node.binarySearch(lowKey);
            if (!node.isLeaf()) {
                lowPos = Node.internalPos(lowPos);
            } else if (lowPos < 0) {
                lowPos ^= 0xFFFFFFFF;
            }
            int range = pos - lowPos;
            if (range > 0) {
                pos = range == 2 ? lowPos : lowPos + (rnd.nextInt(range >> 1) << 1);
                return pos;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRangeEmpty(byte[] lowKey, byte[] highKey) throws IOException {
        boolean oldKeyOnly = this.mKeyOnly;
        LocalTransaction oldTxn = this.mTxn;
        try {
            this.mTxn = LocalTransaction.BOGUS;
            this.mKeyOnly = true;
            if (lowKey == null) {
                this.first();
            } else {
                this.findGe(lowKey);
            }
            boolean bl = this.mKey == null || highKey != null && Arrays.compareUnsigned(this.mKey, highKey) >= 0;
            return bl;
        }
        finally {
            this.reset();
            this.mKeyOnly = oldKeyOnly;
            this.mTxn = oldTxn;
        }
    }

    private IOException handleException(Throwable e, boolean reset) throws IOException {
        DatabaseException de;
        this.mTree.mDatabase.checkClosed(e);
        if (this.mFrame == null && e instanceof IllegalStateException) {
            IllegalStateException ise = (IllegalStateException)e;
            if (reset) {
                this.reset();
            }
            throw ise;
        }
        if (e instanceof DatabaseException && (de = (DatabaseException)e).isRecoverable()) {
            if (reset) {
                this.reset();
            }
            throw de;
        }
        try {
            throw Utils.closeOnFailure(this.mTree.mDatabase, e);
        }
        catch (Throwable throwable) {
            this.reset();
            throw throwable;
        }
    }

    @Override
    public final long valueLength() throws IOException {
        CursorFrame frame;
        try {
            frame = this.frameSharedNotSplit();
        }
        catch (IllegalStateException e) {
            this.valueCheckOpen();
            throw e;
        }
        long result = BTreeValue.action(null, this, frame, 0, 0L, null, 0, 0L);
        frame.mNode.releaseShared();
        return result;
    }

    @Override
    public final void valueLength(long length) throws IOException {
        try {
            if (length <= 0L) {
                this.store((byte[])(length == 0L ? Utils.EMPTY_BYTES : null));
            } else {
                this.doValueModify(3, length, Utils.EMPTY_BYTES, 0, 0L);
            }
        }
        catch (IllegalStateException e) {
            this.valueCheckOpen();
            throw e;
        }
    }

    @Override
    protected final int doValueRead(long pos, byte[] buf, int off, int len) throws IOException {
        CursorFrame frame;
        try {
            frame = this.frameSharedNotSplit();
        }
        catch (IllegalStateException e) {
            this.valueCheckOpen();
            throw e;
        }
        long result = BTreeValue.action(null, this, frame, 1, pos, buf, off, len);
        frame.mNode.releaseShared();
        return (int)result;
    }

    @Override
    protected final void doValueWrite(long pos, byte[] buf, int off, int len) throws IOException {
        try {
            this.doValueModify(4, pos, buf, off, len);
        }
        catch (IllegalStateException e) {
            this.valueCheckOpen();
            throw e;
        }
    }

    @Override
    protected final void doValueClear(long pos, long length) throws IOException {
        try {
            this.doValueModify(2, pos, Utils.EMPTY_BYTES, 0, length);
        }
        catch (IllegalStateException e) {
            this.valueCheckOpen();
            throw e;
        }
    }

    protected final void doValueModify(int op, long pos, byte[] buf, int off, long len) throws IOException {
        if (this.mTxn == null) {
            this.doValueModifyAutoCommit(op, pos, buf, off, len);
        } else {
            this.doTxnValueModify(op, pos, buf, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTxnValueModify(int op, long pos, byte[] buf, int off, long len) throws IOException {
        byte[] key = this.mKey;
        ViewUtils.positionCheck(key);
        LocalTransaction undoTxn = null;
        if (this.mTxn.lockMode() != LockMode.UNSAFE) {
            this.mTxn.doLockExclusive(this.mTree.mId, key, this.keyHash());
            undoTxn = this.mTxn;
        }
        CommitLock.Shared shared = this.prepareStore();
        CursorFrame leaf = this.mFrame;
        try {
            BTreeValue.action(undoTxn, this, leaf, op, pos, buf, off, len);
            Node node = leaf.mNode;
            if (op == 3 && node.shouldLeafMerge()) {
                this.mergeLeaf(leaf, node);
            } else {
                node.releaseExclusive();
            }
            if (this.allowRedo() && this.mTxn.durabilityMode() != DurabilityMode.NO_REDO) {
                this.mTxn.redoCursorValueModify(this, op, pos, buf, off, len);
            }
        }
        finally {
            shared.release();
        }
    }

    private void doValueModifyAutoCommit(int op, long pos, byte[] buf, int off, long len) throws IOException {
        LocalTransaction txn;
        LocalDatabase db = this.mTree.mDatabase;
        if (!this.allowRedo()) {
            txn = db.threadLocalTransaction(DurabilityMode.NO_REDO);
        } else {
            DurabilityMode durabilityMode = db.mDurabilityMode;
            if (this.requireTransaction()) {
                txn = db.threadLocalTransaction(Utils.alwaysRedo(durabilityMode));
            } else {
                byte[] key = this.mKey;
                ViewUtils.positionCheck(key);
                txn = db.threadLocalTransaction(durabilityMode);
                txn.mLockMode = LockMode.UNSAFE;
                txn.doLockExclusive(this.mTree.mId, key, this.keyHash());
            }
        }
        try {
            this.mTxn = txn;
            this.doTxnValueModify(op, pos, buf, off, len);
            txn.commit();
        }
        catch (Throwable e) {
            db.removeThreadLocalTransaction();
            txn.reset();
            throw e;
        }
        finally {
            this.mTxn = null;
        }
    }

    @Override
    protected final int valueStreamBufferSize(int bufferSize) {
        if (bufferSize <= 1) {
            bufferSize = bufferSize < 0 ? this.mTree.mDatabase.mPageSize : 1;
        }
        return bufferSize;
    }

    @Override
    protected final void valueCheckOpen() {
        if (this.mKey == null) {
            throw new IllegalStateException("Accessor closed");
        }
    }

    @Override
    public final BTreeCursor copy() {
        BTreeCursor copy = this.copyNoValue();
        copy.mKeyOnly = this.mKeyOnly;
        copy.mValue = ViewUtils.copyValue(this.mValue);
        return copy;
    }

    private BTreeCursor copyNoValue() {
        BTreeCursor copy = new BTreeCursor(this.mTree, this.mTxn);
        CursorFrame frame = this.mFrame;
        if (frame != null) {
            CursorFrame frameCopy = new CursorFrame();
            frame.copyInto(frameCopy);
            copy.mFrame = frameCopy;
        }
        copy.mKey = this.mKey;
        copy.mKeyHash = this.mKeyHash;
        return copy;
    }

    private Node latchRootNode() {
        Node root = this.mTree.mRoot;
        root.acquireShared();
        return root;
    }

    @Override
    public final void reset() {
        this.mKey = null;
        this.mKeyHash = 0;
        this.mValue = null;
        CursorFrame frame = this.mFrame;
        this.mFrame = null;
        if (frame != null) {
            CursorFrame.popAll(frame);
        }
        this.unregister();
    }

    @Override
    public final void close() {
        this.reset();
    }

    private void resetLatched(Node node) {
        node.releaseShared();
        this.reset();
    }

    private void reachedEnd(Node node) throws ClosedIndexException {
        boolean closed = PageOps.isClosedOrDeleted(node.mPage);
        this.resetLatched(node);
        if (closed) {
            throw PageOps.newClosedIndexException(node.mPage);
        }
    }

    private RuntimeException cleanup(Throwable e, CursorFrame frame) {
        this.mFrame = frame;
        this.reset();
        return Utils.rethrow(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void appendTransfer(Node source) throws IOException {
        try {
            CursorFrame tleaf = this.mFrame;
            tleaf.acquireExclusive();
            Node tnode = this.notSplitDirty(tleaf);
            try {
                byte[] spage = source.mPage;
                int sloc = PageOps.p_ushortGetLE(spage, source.searchVecStart());
                int encodedLen = Node.leafEntryLengthAtLoc(spage, sloc);
                int tpos = tleaf.mNodePos;
                int tloc = tnode.createLeafEntry(null, this.mTree, tpos, encodedLen);
                if (tloc < 0) {
                    tnode.splitLeafAscendingAndCopyEntry(this.mTree, source, 0, encodedLen);
                    tnode = this.mTree.finishSplitCritical(tleaf, tnode);
                } else {
                    PageOps.p_copy(spage, sloc, tnode.mPage, tloc, encodedLen);
                }
                tleaf.mNodePos += 2;
            }
            finally {
                tnode.releaseExclusive();
            }
            int searchVecStart = source.searchVecStart();
            int searchVecEnd = source.searchVecEnd();
            if (searchVecStart == searchVecEnd) {
                source.searchVecEnd(searchVecEnd - 2);
            } else {
                source.searchVecStart(searchVecStart + 2);
            }
        }
        catch (Throwable e) {
            throw this.handleException(e, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void appendTransfer(BTreeCursor source) throws IOException {
        CursorFrame sleaf;
        CommitLock.Shared shared = this.mTree.mDatabase.commitLock().acquireShared();
        try {
            CursorFrame tleaf = this.mFrame;
            tleaf.acquireExclusive();
            Node tnode = this.notSplitDirty(tleaf);
            sleaf = source.mFrame;
            Node snode = sleaf.acquireExclusive();
            try {
                snode = source.notSplitDirty(sleaf);
                int spos = sleaf.mNodePos;
                try {
                    byte[] spage = snode.mPage;
                    int sloc = PageOps.p_ushortGetLE(spage, snode.searchVecStart() + spos);
                    int encodedLen = Node.leafEntryLengthAtLoc(spage, sloc);
                    int tpos = tleaf.mNodePos;
                    int tloc = tnode.createLeafEntry(null, this.mTree, tpos, encodedLen);
                    if (tloc < 0) {
                        tnode.splitLeafAscendingAndCopyEntry(this.mTree, snode, spos, encodedLen);
                        tnode = this.mTree.finishSplitCritical(tleaf, tnode);
                    } else {
                        PageOps.p_copy(spage, sloc, tnode.mPage, tloc, encodedLen);
                    }
                    tleaf.mNodePos += 2;
                    snode.finishDeleteLeafEntry(spos, encodedLen);
                    snode.postDelete(spos, null);
                }
                catch (Throwable e) {
                    snode.releaseExclusive();
                    throw e;
                }
            }
            finally {
                tnode.releaseExclusive();
            }
            if (snode.hasKeys()) {
                snode.downgrade();
            } else {
                source.mergeLeaf(sleaf, snode);
                sleaf = source.frameSharedNotSplit();
            }
        }
        catch (Throwable e) {
            throw this.handleException(e, false);
        }
        finally {
            shared.release();
        }
        source.next(LocalTransaction.BOGUS, sleaf);
    }

    private void doUnregister(LocalTransaction txn, long cursorId) {
        cursorId &= Long.MAX_VALUE;
        try {
            LocalDatabase db;
            block7: {
                RedoWriter redo;
                TransactionContext context;
                block6: {
                    block5: {
                        db = this.mTree.mDatabase;
                        if (txn != null) break block5;
                        context = db.anyTransactionContext();
                        redo = db.txnRedoWriter();
                        break block6;
                    }
                    context = txn.mContext;
                    redo = txn.mRedo;
                    if (redo == null) break block7;
                }
                context.redoCursorUnregister(redo, cursorId);
            }
            db.unregisterCursor(cursorId);
            this.mCursorId = 0L;
        }
        catch (UnmodifiableReplicaException db) {
        }
        catch (IOException e) {
            throw Utils.rethrow(e);
        }
    }

    final int height() {
        int height = 0;
        CursorFrame frame = this.mFrame;
        while (frame != null) {
            ++height;
            frame = frame.mParentFrame;
        }
        return height;
    }

    /*
     * Unable to fully structure code
     */
    final boolean compact(long highestNodeId, CompactionObserver observer) throws IOException {
        height = this.height();
        frameNodes = new Node[height];
        nodePositions = new int[height];
        frame = this.mFrame;
        while (true) {
            block16: {
                for (level = 0; level < height; ++level) {
                    node = frame.acquireShared();
                    if (frameNodes[level] == node && (level == 0 || nodePositions[level] == frame.mNodePos)) {
                        node.releaseShared();
                        break;
                    }
                    frameNodes[level] = node;
                    nodePositions[level] = frame.mNodePos;
                    id = this.compactFrame(highestNodeId, frame, node);
                    if (id > highestNodeId) {
                        return false;
                    }
                    try {
                        if (!observer.indexNodeVisited(id)) {
                            return false;
                        }
                    }
                    catch (Throwable e) {
                        Utils.uncaught(e);
                        return false;
                    }
                    if (level != 0 && !this.compactInternalNode(highestNodeId, frame)) {
                        return false;
                    }
                    frame = frame.mParentFrame;
                }
                frame = this.frameSharedNotSplit();
                node = frame.mNode;
                end = node.highestLeafPos();
                pos = frame.mNodePos;
                if (pos < 0) {
                    pos ^= -1;
                }
                while (pos <= end) {
                    if (!node.isFragmentedKey(pos) && !node.isFragmentedLeafValue(pos)) {
                        pos += 2;
                        continue;
                    }
                    break block16;
                }
                node.releaseShared();
                this.skipToNextLeaf();
                frame = this.mFrame;
                if (frame != null) ** continue;
                return true;
            }
            do {
                if ((nodePos = frame.mNodePos) >= 0) {
                    if (node.isFragmentedKey(nodePos) && (node = this.compactFragmentedEntry(frame, node, true, highestNodeId)) == null) {
                        return false;
                    }
                    if (node.isFragmentedLeafValue(nodePos) && (node = this.compactFragmentedEntry(frame, node, false, highestNodeId)) == null) {
                        return false;
                    }
                }
                node.releaseShared();
                this.nextLeaf();
                if (this.mFrame == null) {
                    return true;
                }
                frame = this.frameSharedNotSplit();
            } while ((next = frame.mNode) == node);
            next.releaseShared();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long compactFrame(long highestNodeId, CursorFrame frame, Node node) throws IOException {
        long id = node.id();
        node.releaseShared();
        if (id > highestNodeId) {
            LocalDatabase db = this.mTree.mDatabase;
            CommitLock.Shared shared = db.commitLock().acquireShared();
            try {
                node = frame.acquireExclusive();
                id = node.id();
                if (id > highestNodeId) {
                    node = this.notSplitDirty(frame);
                    id = node.id();
                }
                node.releaseExclusive();
            }
            finally {
                shared.release();
            }
        }
        return id;
    }

    private boolean compactInternalNode(long highestNodeId, CursorFrame frame) throws IOException {
        Node node = frame.acquireShared();
        if (node.mSplit != null) {
            node = this.mTree.finishSplitShared(frame, node);
        }
        boolean result = !node.isInternal() || frame.mNodePos >= node.highestInternalPos() ? true : this.compactFragmentedEntry(frame, node, true, highestNodeId) != null;
        node.releaseShared();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node compactFragmentedEntry(CursorFrame frame, Node node, boolean isKey, long highestNodeId) throws IOException {
        int pLen = this.pageSize(node.mPage);
        long pos = 0L;
        while (true) {
            int result;
            try {
                result = BTreeValue.compactCheck(frame, isKey, pos, highestNodeId);
            }
            catch (Throwable e) {
                node.releaseShared();
                throw e;
            }
            if (result < -1) {
                return node;
            }
            if (result > -1) {
                if (result > 0) {
                    pos = result;
                    continue;
                }
                CommitLock.Shared shared = this.prepareStoreUpgrade(frame, null);
                try {
                    BTreeValue.touch(frame, isKey, pos);
                }
                finally {
                    shared.release();
                }
                node = frame.mNode;
                node.downgrade();
                if (node.id() > highestNodeId) {
                    node.releaseShared();
                    return null;
                }
            }
            pos += (long)pLen;
        }
    }

    public final boolean equalPositions(BTreeCursor other) {
        if (this == other) {
            return true;
        }
        CursorFrame thisFrame = this.mFrame;
        CursorFrame otherFrame = other.mFrame;
        while (thisFrame != null) {
            if (otherFrame == null) {
                return false;
            }
            if (thisFrame.mNode != otherFrame.mNode) {
                return false;
            }
            if (thisFrame.mNodePos != otherFrame.mNodePos) {
                return false;
            }
            thisFrame = thisFrame.mParentFrame;
            otherFrame = otherFrame.mParentFrame;
        }
        return otherFrame == null;
    }

    public final boolean verifyExtremities(byte extremity) throws IOException {
        Node node = this.latchRootNode();
        try {
            while (true) {
                boolean bl;
                if ((node.type() & extremity) == 0) {
                    bl = false;
                    return bl;
                }
                if (node.isLeaf()) {
                    bl = true;
                    return bl;
                }
                int pos = 0;
                if (extremity == 8) {
                    pos = node.highestInternalPos();
                }
                node = this.mTree.mDatabase.latchToChild(node, pos);
            }
        }
        finally {
            node.releaseShared();
        }
    }

    final boolean verify(int height, VerificationObserver observer) throws IOException {
        if (height > 0) {
            Node[] stack = new Node[height];
            while (this.key() != null) {
                if (!this.verifyFrames(height, stack, this.mFrame, observer)) {
                    return false;
                }
                this.skipToNextLeaf();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyFrames(int level, Node[] stack, CursorFrame frame, VerificationObserver observer) throws IOException {
        Node childNode;
        CursorFrame parentFrame = frame.mParentFrame;
        if (parentFrame == null) {
            childNode = frame.acquireShared();
        } else {
            Node parentNode = parentFrame.mNode;
            int parentLevel = level - 1;
            if (parentLevel > 0 && stack[parentLevel] != parentNode) {
                parentNode = parentFrame.acquireShared();
                parentNode.releaseShared();
                if (stack[parentLevel] != parentNode) {
                    stack[parentLevel] = parentNode;
                    if (!this.verifyFrames(parentLevel, stack, parentFrame, observer)) {
                        return false;
                    }
                }
            }
            parentNode = parentFrame.acquireShared();
            try {
                boolean result;
                childNode = frame.acquireShared();
                try {
                    result = this.verifyParentChildFrames(level, parentFrame, parentNode, frame, childNode, observer);
                }
                catch (Throwable e) {
                    childNode.releaseShared();
                    throw e;
                }
                if (!result) {
                    childNode.releaseShared();
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                parentNode.releaseShared();
            }
        }
        return childNode.verifyTreeNode(level, observer);
    }

    private boolean verifyParentChildFrames(int level, CursorFrame parentFrame, Node parentNode, CursorFrame childFrame, Node childNode, VerificationObserver observer) throws IOException {
        long childId = childNode.id();
        if (childNode.hasKeys() && parentNode.hasKeys() && childNode.mSplit == null && parentNode.mSplit == null) {
            boolean left;
            int childPos;
            int parentPos = parentFrame.mNodePos;
            if (parentPos >= parentNode.highestInternalPos()) {
                parentPos = parentNode.highestKeyPos();
                childPos = 0;
                left = false;
            } else {
                childPos = childNode.highestKeyPos();
                left = true;
            }
            byte[] parentKey = parentNode.retrieveKey(parentPos);
            byte[] childKey = childNode.retrieveKey(childPos);
            int compare = Arrays.compareUnsigned(childKey, parentKey);
            if (left) {
                if (compare >= 0) {
                    observer.failed = true;
                    if (!observer.indexNodeFailed(childId, level, "Child keys are not less than parent key: " + parentNode)) {
                        return false;
                    }
                }
            } else if (childNode.isInternal()) {
                if (compare <= 0) {
                    observer.failed = true;
                    if (!observer.indexNodeFailed(childId, level, "Internal child keys are not greater than parent key: " + parentNode)) {
                        return false;
                    }
                }
            } else if (compare < 0) {
                observer.failed = true;
                if (!observer.indexNodeFailed(childId, level, "Child keys are not greater than or equal to parent key: " + parentNode)) {
                    return false;
                }
            }
            if ((childNode.type() & 2) != 0 && (parentNode.type() & 2) == 0) {
                observer.failed = true;
                if (!observer.indexNodeFailed(childId, level, "Child is low extremity but parent is not: " + parentNode)) {
                    return false;
                }
            }
            if ((childNode.type() & 8) != 0 && (parentNode.type() & 8) == 0) {
                observer.failed = true;
                if (!observer.indexNodeFailed(childId, level, "Child is high extremity but parent is not: " + parentNode)) {
                    return false;
                }
            }
        }
        switch (parentNode.type()) {
            case 100: {
                if (!childNode.isLeaf() || parentNode.id() <= 1L) break;
                observer.failed = true;
                if (observer.indexNodeFailed(childId, level, "Child is a leaf, but parent is a regular internal node: " + parentNode)) break;
                return false;
            }
            case 116: {
                if (childNode.isLeaf()) break;
                observer.failed = true;
                if (observer.indexNodeFailed(childId, level, "Child is not a leaf, but parent is a bottom internal node: " + parentNode)) break;
                return false;
            }
            default: {
                if (!parentNode.isLeaf()) break;
            }
            case -128: {
                observer.failed = true;
                if (observer.indexNodeFailed(childId, level, "Child parent is a leaf node: " + parentNode)) break;
                return false;
            }
        }
        return true;
    }

    private CursorFrame frame() {
        CursorFrame frame = this.mFrame;
        ViewUtils.positionCheck(frame);
        return frame;
    }

    protected final CursorFrame frameExclusive() {
        CursorFrame frame = this.frame();
        frame.acquireExclusive();
        return frame;
    }

    final CursorFrame frameSharedNotSplit() throws IOException {
        CursorFrame frame = this.frame();
        Node node = frame.acquireShared();
        if (node.mSplit != null) {
            this.mTree.finishSplitShared(frame, node);
        }
        return frame;
    }

    final Node notSplitDirty(CursorFrame frame) throws IOException {
        Node parentNode;
        CursorFrame parentFrame;
        LocalDatabase db;
        Node node;
        block13: {
            block14: {
                block12: {
                    node = frame.mNode;
                    if (node.mSplit != null) {
                        return this.mTree.finishSplit(frame, node);
                    }
                    db = this.mTree.mDatabase;
                    if (!db.shouldMarkDirty(node)) {
                        return node;
                    }
                    parentFrame = frame.mParentFrame;
                    if (parentFrame == null) {
                        try {
                            db.doMarkDirty(this.mTree, node);
                            return node;
                        }
                        catch (Throwable e) {
                            node.releaseExclusive();
                            throw e;
                        }
                    }
                    parentNode = parentFrame.tryAcquireExclusive();
                    if (parentNode == null) break block12;
                    if (parentNode.mSplit == null && !db.shouldMarkDirty(parentNode)) break block13;
                    node.releaseExclusive();
                    break block14;
                }
                node.releaseExclusive();
                parentFrame.acquireExclusive();
            }
            parentNode = this.notSplitDirty(parentFrame);
            node = frame.acquireExclusive();
            if (node.mSplit != null) {
                parentNode.releaseExclusive();
                return this.mTree.finishSplit(frame, node);
            }
            if (!db.shouldMarkDirty(node)) {
                parentNode.releaseExclusive();
                return node;
            }
        }
        try {
            db.doMarkDirty(this.mTree, node);
            parentNode.updateChildRefId(parentFrame.mNodePos, node.id());
            Node node2 = node;
            return node2;
        }
        catch (Throwable e) {
            node.releaseExclusive();
            throw e;
        }
        finally {
            parentNode.releaseExclusive();
        }
    }

    final boolean notSplitDirtyUpgrade(CursorFrame frame, boolean exclusive) throws IOException {
        Node node = frame.mNode;
        if (!exclusive && !node.tryUpgrade()) {
            node.releaseShared();
        } else {
            LocalDatabase db = this.mTree.mDatabase;
            if (!db.shouldMarkDirty(node)) {
                return true;
            }
            CursorFrame parentFrame = frame.mParentFrame;
            if (parentFrame == null) {
                try {
                    db.doMarkDirty(this.mTree, node);
                    return true;
                }
                catch (Throwable e) {
                    node.releaseExclusive();
                    throw e;
                }
            }
            Node parentNode = parentFrame.tryAcquireExclusive();
            if (parentNode != null) {
                if (parentNode.mSplit == null && !db.shouldMarkDirty(parentNode)) {
                    try {
                        db.doMarkDirty(this.mTree, node);
                        parentNode.updateChildRefId(parentFrame.mNodePos, node.id());
                        boolean bl = true;
                        return bl;
                    }
                    catch (Throwable e) {
                        node.releaseExclusive();
                        throw e;
                    }
                    finally {
                        parentNode.releaseExclusive();
                    }
                }
                node.releaseExclusive();
            } else {
                node.releaseExclusive();
                parentFrame.acquireExclusive();
            }
            this.notSplitDirty(parentFrame).releaseExclusive();
        }
        frame.acquireExclusive();
        this.notSplitDirty(frame);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean tryNotSplitDirty(CursorFrame frame) throws IOException {
        Node node = frame.mNode;
        if (node.mSplit != null) {
            return false;
        }
        LocalDatabase db = this.mTree.mDatabase;
        if (!db.shouldMarkDirty(node)) {
            return true;
        }
        CursorFrame parentFrame = frame.mParentFrame;
        if (parentFrame == null) {
            db.doMarkDirty(this.mTree, node);
            return true;
        }
        Node parentNode = parentFrame.tryAcquireExclusive();
        if (parentNode == null) {
            return false;
        }
        try {
            if (!this.tryNotSplitDirty(parentFrame)) {
                boolean bl = false;
                return bl;
            }
            db.doMarkDirty(this.mTree, node);
            parentNode.updateChildRefId(parentFrame.mNodePos, node.id());
            boolean bl = true;
            return bl;
        }
        finally {
            parentNode.releaseExclusive();
        }
    }

    /*
     * Unable to fully structure code
     */
    void mergeLeaf(CursorFrame leaf, Node node) throws IOException {
        block41: {
            parentFrame = leaf.mParentFrame;
            if (parentFrame == null) {
                node.releaseExclusive();
                return;
            }
            parentNode = parentFrame.tryAcquireExclusive();
            if (parentNode == null) {
                node.releaseExclusive();
                node = null;
                parentNode = parentFrame.acquireExclusive();
            }
            while (true) {
                block44: {
                    block43: {
                        block42: {
                            if (parentNode.mSplit == null) break block42;
                            if (node != null) {
                                node.releaseExclusive();
                            }
                            parentNode = this.mTree.finishSplit(parentFrame, parentNode);
                            break block43;
                        }
                        if (node != null) break block44;
                    }
                    node = leaf.acquireExclusive();
                }
                nodeAvail = node.availableLeafBytes();
                if (!node.shouldMerge(nodeAvail)) {
                    node.releaseExclusive();
                    parentNode.releaseExclusive();
                    return;
                }
                pos = parentFrame.mNodePos;
                if (pos == 0) {
                    leftNode = null;
                    leftAvail = -1;
                } else {
                    try {
                        leftNode = this.mTree.mDatabase.latchChildRetainParentEx(parentNode, pos - 2, false);
                    }
                    catch (Throwable e) {
                        node.releaseExclusive();
                        throw e;
                    }
                    if (leftNode == null) {
                        leftAvail = -1;
                    } else {
                        if (leftNode.mSplit != null) {
                            node.releaseExclusive();
                            node = null;
                            try {
                                parentNode.insertSplitChildRef(parentFrame, this.mTree, pos - 2, leftNode);
                            }
                            catch (Throwable e) {
                                return;
                            }
                        }
                        if (!node.hasKeys()) {
                            leftPos = parentFrame.mNodePos - 2;
                            rightNode = node;
                            ** break block40
                        }
                        leftAvail = leftNode.availableLeafBytes();
                    }
                }
                if (pos >= parentNode.highestInternalPos()) {
                    rightNode = null;
                    rightAvail = -1;
                    break block41;
                }
                try {
                    rightNode = this.mTree.mDatabase.latchChildRetainParentEx(parentNode, pos + 2, false);
                }
                catch (Throwable e) {
                    if (leftNode != null) {
                        leftNode.releaseExclusive();
                    }
                    node.releaseExclusive();
                    throw e;
                }
                if (rightNode == null) {
                    rightAvail = -1;
                    break block41;
                }
                if (rightNode.mSplit == null) break;
                if (leftNode != null) {
                    leftNode.releaseExclusive();
                }
                node.releaseExclusive();
                node = null;
                try {
                    parentNode.insertSplitChildRef(parentFrame, this.mTree, pos + 2, rightNode);
                }
                catch (Throwable e) {
                    return;
                }
            }
            rightAvail = rightNode.availableLeafBytes();
        }
        if (leftAvail <= rightAvail) {
            if (leftNode != null) {
                leftNode.releaseExclusive();
            }
            leftPos = parentFrame.mNodePos;
            leftNode = node;
            leftAvail = nodeAvail;
        } else {
            if (rightNode != null) {
                rightNode.releaseExclusive();
            }
            leftPos = parentFrame.mNodePos - 2;
            rightNode = node;
            rightAvail = nodeAvail;
        }
        rem = leftAvail + rightAvail - this.pageSize(node.mPage) + 12;
        if (rem < 0) {
            if (rightNode != null) {
                rightNode.releaseExclusive();
            }
        } else lbl-1000:
        // 2 sources

        {
            try {
                if (this.mTree.markDirty(leftNode)) {
                    parentNode.updateChildRefId(leftPos, leftNode.id());
                }
            }
            catch (Throwable e) {
                leftNode.releaseExclusive();
                rightNode.releaseExclusive();
                parentNode.releaseExclusive();
                throw e;
            }
            try {
                Node.moveLeafToLeftAndDelete(this.mTree, leftNode, rightNode);
            }
            catch (Throwable e) {
                leftNode.releaseExclusive();
                parentNode.releaseExclusive();
                throw e;
            }
            parentNode.deleteRightChildRef(leftPos + 2);
        }
        this.mergeInternal(parentFrame, parentNode, leftNode);
    }

    private void mergeInternal(CursorFrame frame, Node node, Node childNode) throws IOException {
        int leftPos;
        int rightAvail;
        int leftAvail;
        Node rightNode;
        Node leftNode;
        int nodeAvail;
        if (!node.shouldInternalMerge()) {
            childNode.releaseExclusive();
            node.releaseExclusive();
            return;
        }
        if (!node.hasKeys() && node == this.mTree.mRoot) {
            this.mTree.rootDelete(childNode);
            return;
        }
        childNode.releaseExclusive();
        CursorFrame parentFrame = frame.mParentFrame;
        if (parentFrame == null) {
            node.releaseExclusive();
            return;
        }
        Node parentNode = parentFrame.tryAcquireExclusive();
        if (parentNode == null) {
            node.releaseExclusive();
            node = null;
            parentNode = parentFrame.acquireExclusive();
        }
        if (parentNode.isLeaf()) {
            throw new AssertionError((Object)"Parent node is a leaf");
        }
        while (true) {
            block44: {
                block43: {
                    block42: {
                        if (parentNode.mSplit == null) break block42;
                        if (node != null) {
                            node.releaseExclusive();
                        }
                        parentNode = this.mTree.finishSplit(parentFrame, parentNode);
                        break block43;
                    }
                    if (node != null) break block44;
                }
                node = frame.acquireExclusive();
            }
            nodeAvail = node.availableInternalBytes();
            if (!node.shouldMerge(nodeAvail)) {
                node.releaseExclusive();
                parentNode.releaseExclusive();
                return;
            }
            int pos = parentFrame.mNodePos;
            if (pos == 0) {
                leftNode = null;
            } else {
                try {
                    leftNode = this.mTree.mDatabase.latchChildRetainParentEx(parentNode, pos - 2, false);
                }
                catch (Throwable e) {
                    node.releaseExclusive();
                    throw e;
                }
                if (leftNode != null && leftNode.mSplit != null) {
                    node.releaseExclusive();
                    node = null;
                    try {
                        parentNode.insertSplitChildRef(parentFrame, this.mTree, pos - 2, leftNode);
                    }
                    catch (Throwable e) {
                        return;
                    }
                }
            }
            if (pos >= parentNode.highestInternalPos()) {
                rightNode = null;
                break;
            }
            try {
                rightNode = this.mTree.mDatabase.latchChildRetainParentEx(parentNode, pos + 2, false);
            }
            catch (Throwable e) {
                if (leftNode != null) {
                    leftNode.releaseExclusive();
                }
                node.releaseExclusive();
                throw e;
            }
            if (rightNode == null || rightNode.mSplit == null) break;
            if (leftNode != null) {
                leftNode.releaseExclusive();
            }
            node.releaseExclusive();
            node = null;
            try {
                parentNode.insertSplitChildRef(parentFrame, this.mTree, pos + 2, rightNode);
            }
            catch (Throwable e) {
                return;
            }
        }
        if (leftNode == null) {
            if (rightNode == null) {
                this.mergeInternal(parentFrame, parentNode, node);
                return;
            }
            leftAvail = -1;
        } else {
            leftAvail = leftNode.availableInternalBytes();
        }
        int n = rightAvail = rightNode == null ? -1 : rightNode.availableInternalBytes();
        if (leftAvail <= rightAvail) {
            if (leftNode != null) {
                leftNode.releaseExclusive();
            }
            leftPos = parentFrame.mNodePos;
            leftNode = node;
            leftAvail = nodeAvail;
        } else {
            if (rightNode != null) {
                rightNode.releaseExclusive();
            }
            leftPos = parentFrame.mNodePos - 2;
            rightNode = node;
            rightAvail = nodeAvail;
        }
        byte[] parentPage = parentNode.mPage;
        int parentEntryLoc = PageOps.p_ushortGetLE(parentPage, parentNode.searchVecStart() + leftPos);
        int parentEntryLen = Node.keyLengthAtLoc(parentPage, parentEntryLoc);
        int remaining = leftAvail - parentEntryLen + rightAvail - this.pageSize(parentPage) + 10;
        if (remaining < 0) {
            if (rightNode != null) {
                rightNode.releaseExclusive();
            }
        } else {
            try {
                if (this.mTree.markDirty(leftNode)) {
                    parentNode.updateChildRefId(leftPos, leftNode.id());
                }
            }
            catch (Throwable e) {
                leftNode.releaseExclusive();
                rightNode.releaseExclusive();
                parentNode.releaseExclusive();
                throw e;
            }
            try {
                Node.moveInternalToLeftAndDelete(this.mTree, leftNode, rightNode, parentPage, parentEntryLoc, parentEntryLen);
            }
            catch (Throwable e) {
                leftNode.releaseExclusive();
                parentNode.releaseExclusive();
                throw e;
            }
            parentNode.deleteRightChildRef(leftPos + 2);
        }
        this.mergeInternal(parentFrame, parentNode, leftNode);
    }

    private int pageSize(byte[] page) {
        return page.length;
    }
}

