/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.util.concurrent.Executor;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.core.BTree;
import org.cojen.tupl.core.BTreeCursor;
import org.cojen.tupl.core.BTreeSeparator;
import org.cojen.tupl.core.Chain;
import org.cojen.tupl.core.LocalDatabase;
import org.cojen.tupl.core.Node;

abstract class BTreeMerger
extends BTreeSeparator {
    BTreeMerger(LocalDatabase db, BTree[] sources, Executor executor, int workerCount) {
        super(db, sources, executor, workerCount);
    }

    @Override
    protected void finished(Chain<BTree> firstRange) {
        block10: {
            BTree merged = firstRange.element();
            if (merged != null) {
                for (Chain<BTree> range = firstRange.next(); range != null; range = range.next()) {
                    BTree tree = range.element();
                    if (tree == null) continue;
                    try {
                        merged = BTree.graftTempTree(merged, tree);
                        continue;
                    }
                    catch (Throwable e) {
                        this.failed(e);
                        this.merged(merged);
                        block5: while (true) {
                            this.remainder(tree);
                            while ((range = range.next()) != null) {
                                tree = range.element();
                                if (tree == null) continue;
                                continue block5;
                            }
                            break block10;
                            break;
                        }
                    }
                }
                this.merged(merged);
            }
        }
        for (BTree source : this.mSources) {
            if (BTreeMerger.isEmpty(source)) {
                try {
                    this.mDatabase.quickDeleteTemporaryTree(source);
                    continue;
                }
                catch (Throwable e) {
                    this.failed(e);
                }
            }
            this.remainder(source);
        }
        this.remainder(null);
    }

    protected abstract void merged(BTree var1);

    protected abstract void remainder(BTree var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isEmpty(BTree tree) {
        Node root = tree.mRoot;
        root.acquireShared();
        boolean empty = root.isLeaf() && !root.hasKeys();
        root.releaseShared();
        if (!empty) {
            BTreeCursor c = tree.newCursor(Transaction.BOGUS);
            try {
                c.mKeyOnly = true;
                c.first();
                empty = c.key() == null;
            }
            catch (Throwable throwable) {
            }
            finally {
                c.reset();
            }
        }
        return empty;
    }
}

