/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import org.cojen.tupl.LargeKeyException;
import org.cojen.tupl.LargeValueException;
import org.cojen.tupl.core.BTree;
import org.cojen.tupl.core.BTreeCursor;
import org.cojen.tupl.core.CursorFrame;
import org.cojen.tupl.core.LocalDatabase;
import org.cojen.tupl.core.LocalTransaction;
import org.cojen.tupl.core.Node;
import org.cojen.tupl.core.PageOps;
import org.cojen.tupl.core.Utils;

final class BTreeValue {
    static final int OP_LENGTH = 0;
    static final int OP_READ = 1;
    static final int OP_CLEAR = 2;
    static final int OP_SET_LENGTH = 3;
    static final int OP_WRITE = 4;

    private BTreeValue() {
    }

    static int compactCheck(CursorFrame frame, boolean isKey, long pos, long highestNodeId) throws IOException {
        byte fHeader;
        long fLen;
        int len;
        byte header;
        Node node = frame.mNode;
        int nodePos = frame.mNodePos;
        if (nodePos < 0) {
            return -2;
        }
        byte[] page = node.mPage;
        int loc = PageOps.p_ushortGetLE(page, node.searchVecStart() + nodePos);
        if (isKey) {
            if ((header = PageOps.p_byteGet(page, loc++)) >= 0) {
                return pos >= (long)(header + 1) ? -2 : -1;
            }
            len = (header & 0x3F) << 8 | PageOps.p_ubyteGet(page, loc++);
        } else {
            loc += Node.keyLengthAtLoc(page, loc);
            if ((header = PageOps.p_byteGet(page, loc++)) >= 0) {
                return pos >= (long)header ? -2 : -1;
            }
            if ((header & 0x20) == 0) {
                len = 1 + ((header & 0x1F) << 8 | PageOps.p_ubyteGet(page, loc++));
            } else if (header != -1) {
                len = 1 + ((header & 0xF) << 16 | PageOps.p_ubyteGet(page, loc++) << 8 | PageOps.p_ubyteGet(page, loc++));
            } else {
                return -2;
            }
        }
        if ((header & 0x40) == 0) {
            return pos >= (long)len ? -2 : -1;
        }
        if (pos >= (fLen = LocalDatabase.decodeFullFragmentedValueLength(fHeader = PageOps.p_byteGet(page, loc++), page, loc))) {
            return -2;
        }
        loc = BTreeValue.skipFragmentedLengthField(loc, fHeader);
        if ((fHeader & 2) != 0) {
            int fInlineLen = PageOps.p_ushortGetLE(page, loc);
            if ((pos -= (long)fInlineLen) < 0L) {
                return fInlineLen;
            }
            fLen -= (long)fInlineLen;
            loc = loc + 2 + fInlineLen;
        }
        LocalDatabase db = node.getDatabase();
        if ((fHeader & 1) == 0) {
            long fNodeId = PageOps.p_uint48GetLE(page, loc += (int)pos / BTreeValue.pageSize(db, page) * 6);
            return fNodeId > highestNodeId ? 0 : -1;
        }
        long inodeId = PageOps.p_uint48GetLE(page, loc);
        if (inodeId == 0L) {
            return -1;
        }
        if (inodeId > highestNodeId) {
            return 0;
        }
        Node inode = db.nodeMapLoadFragment(inodeId);
        int level = db.calculateInodeLevels(fLen);
        while (true) {
            long levelCap = db.levelCap(--level);
            long childNodeId = PageOps.p_uint48GetLE(inode.mPage, (int)(pos / levelCap) * 6);
            inode.releaseShared();
            if (childNodeId > highestNodeId) {
                return 0;
            }
            if (level <= 0 || childNodeId == 0L) {
                return -1;
            }
            inode = db.nodeMapLoadFragment(childNodeId);
            pos %= levelCap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void touch(CursorFrame frame, boolean isKey, long pos) throws IOException {
        long fLen;
        byte header;
        Node node = frame.mNode;
        int nodePos = frame.mNodePos;
        if (nodePos < 0) {
            return;
        }
        byte[] page = node.mPage;
        int loc = PageOps.p_ushortGetLE(page, node.searchVecStart() + nodePos);
        if (isKey) {
            header = PageOps.p_byteGet(page, loc);
            if (header >= 0) {
                return;
            }
            loc += 2;
        } else {
            if ((header = PageOps.p_byteGet(page, loc += Node.keyLengthAtLoc(page, loc))) >= 0) {
                return;
            }
            if ((header & 0x20) == 0) {
                loc += 2;
            } else if (header != -1) {
                loc += 3;
            } else {
                return;
            }
        }
        if ((header & 0x40) == 0) {
            return;
        }
        byte fHeader = PageOps.p_byteGet(page, loc++);
        switch (fHeader >> 2 & 3) {
            default: {
                fLen = PageOps.p_ushortGetLE(page, loc);
                break;
            }
            case 1: {
                fLen = (long)PageOps.p_intGetLE(page, loc) & 0xFFFFFFFFL;
                break;
            }
            case 2: {
                fLen = PageOps.p_uint48GetLE(page, loc);
                break;
            }
            case 3: {
                fLen = PageOps.p_longGetLE(page, loc);
                if (fLen >= 0L) break;
                node.releaseExclusive();
                if (isKey) {
                    throw new LargeKeyException(fLen);
                }
                throw new LargeValueException(fLen);
            }
        }
        loc = BTreeValue.skipFragmentedLengthField(loc, fHeader);
        int fInlineLen = 0;
        if ((fHeader & 2) != 0) {
            fInlineLen = PageOps.p_ushortGetLE(page, loc);
            if (pos < (long)fInlineLen) {
                return;
            }
            loc += 2;
            loc += fInlineLen;
        }
        if (pos > fLen) {
            return;
        }
        LocalDatabase db = node.getDatabase();
        try {
            if ((fHeader & 1) == 0) {
                long fNodeId = PageOps.p_uint48GetLE(page, loc += (int)(pos - (long)fInlineLen) / BTreeValue.pageSize(db, page) * 6);
                if (fNodeId != 0L) {
                    Node fNode = db.nodeMapLoadFragmentExclusive(fNodeId, true);
                    try {
                        if (db.markFragmentDirty(fNode)) {
                            PageOps.p_int48PutLE(page, loc, fNode.id());
                        }
                    }
                    finally {
                        fNode.releaseExclusive();
                    }
                }
                return;
            }
            long inodeId = PageOps.p_uint48GetLE(page, loc);
            if (inodeId == 0L) {
                return;
            }
            Node inode = db.nodeMapLoadFragmentExclusive(inodeId, true);
            try {
                if (db.markFragmentDirty(inode)) {
                    PageOps.p_int48PutLE(page, loc, inode.id());
                }
            }
            catch (Throwable e) {
                throw BTreeValue.releaseExclusive(inode, e);
            }
            int levels = db.calculateInodeLevels(fLen - (long)fInlineLen);
            BTreeValue.touchMultilevelFragment(pos - (long)fInlineLen, levels, inode);
        }
        catch (Throwable e) {
            throw BTreeValue.releaseExclusive(node, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static long action(LocalTransaction txn, BTreeCursor cursor, CursorFrame frame, int op, long pos, byte[] b, int bOff, long bLen) throws IOException {
        block165: {
            block166: {
                while (true) {
                    block173: {
                        block169: {
                            block171: {
                                block172: {
                                    block170: {
                                        block168: {
                                            node = frame.mNode;
                                            nodePos = frame.mNodePos;
                                            if (nodePos < 0) {
                                                if (op <= 2) {
                                                    return -1L;
                                                }
                                                if (txn != null) {
                                                    try {
                                                        txn.pushUncreate(cursor.mTree.mId, cursor.mKey);
                                                        txn = null;
                                                    }
                                                    catch (Throwable e) {
                                                        throw BTreeValue.releaseExclusive(node, e);
                                                    }
                                                }
                                                node = cursor.insertBlank(frame, node, pos + bLen);
                                                if (bLen <= 0L) {
                                                    return 0L;
                                                }
                                                nodePos = frame.mNodePos;
                                                if (nodePos < 0) {
                                                    return 0L;
                                                }
                                            }
                                            page = node.mPage;
                                            kHeaderLoc = loc = PageOps.p_ushortGetLE(page, node.searchVecStart() + nodePos);
                                            loc += Node.keyLengthAtLoc(page, loc);
                                            vHeaderLoc = loc;
                                            if ((vHeader = PageOps.p_byteGet(page, loc++)) < 0) break block168;
                                            vLen = vHeader;
                                            break block169;
                                        }
                                        if ((vHeader & 32) != 0) break block170;
                                        vLen = 1 + ((vHeader & 31) << 8 | PageOps.p_ubyteGet(page, loc++));
                                        break block171;
                                    }
                                    if (vHeader != -1) break block172;
                                    if (op <= 2) {
                                        return -1L;
                                    }
                                    PageOps.p_bytePut(page, vHeaderLoc, 0);
                                    vLen = 0;
                                    break block169;
                                }
                                vLen = 1 + ((vHeader & 15) << 16 | PageOps.p_ubyteGet(page, loc++) << 8 | PageOps.p_ubyteGet(page, loc++));
                            }
                            if ((vHeader & 64) != 0) break block173;
                        }
                        switch (op) {
                            default: {
                                return vLen;
                            }
                            case 1: {
                                if (bLen <= 0L || pos >= (long)vLen) {
                                    bLen = 0L;
                                } else {
                                    bLen = Math.min((long)((int)((long)vLen - pos)), bLen);
                                    PageOps.p_copyToArray(page, (int)((long)loc + pos), b, bOff, (int)bLen);
                                }
                                return bLen;
                            }
                            case 2: {
                                if (pos < (long)vLen) {
                                    iLoc = (int)((long)loc + pos);
                                    iLen = (int)Math.min(bLen, (long)vLen - pos);
                                    if (txn != null) {
                                        try {
                                            txn.pushUnwrite(cursor.mTree.mId, cursor.mKey, pos, page, iLoc, iLen);
                                        }
                                        catch (Throwable e) {
                                            throw BTreeValue.releaseExclusive(node, e);
                                        }
                                    }
                                    PageOps.p_clear(page, iLoc, iLoc + iLen);
                                }
                                return 0L;
                            }
                            case 3: {
                                if (pos > (long)vLen) break;
                                if (pos == (long)vLen) {
                                    return 0L;
                                }
                                newLen = (int)pos;
                                oldLen = vLen;
                                garbageAccum = oldLen - newLen;
                                if (txn != null) {
                                    try {
                                        txn.pushUnwrite(cursor.mTree.mId, cursor.mKey, pos, page, loc + newLen, garbageAccum);
                                    }
                                    catch (Throwable e) {
                                        throw BTreeValue.releaseExclusive(node, e);
                                    }
                                }
                                if (newLen > 127) ** GOTO lbl82
                                PageOps.p_bytePut(page, vHeaderLoc, newLen);
                                vShift = loc - (vHeaderLoc + 1);
                                ** GOTO lbl90
lbl82:
                                // 1 sources

                                if (newLen > 8192) {
                                    PageOps.p_bytePut(page, vHeaderLoc, 160 | newLen - 1 >> 16);
                                    PageOps.p_bytePut(page, vHeaderLoc + 1, newLen - 1 >> 8);
                                    PageOps.p_bytePut(page, vHeaderLoc + 2, newLen - 1);
                                } else {
                                    PageOps.p_bytePut(page, vHeaderLoc, 128 | newLen - 1 >> 8);
                                    PageOps.p_bytePut(page, vHeaderLoc + 1, newLen - 1);
                                    vShift = loc - (vHeaderLoc + 2);
lbl90:
                                    // 2 sources

                                    if (vShift > 0) {
                                        garbageAccum += vShift;
                                        PageOps.p_copy(page, loc, page, loc - vShift, newLen);
                                    }
                                }
                                node.garbage(node.garbage() + garbageAccum);
                                return 0L;
                            }
                            case 4: {
                                if (pos >= (long)vLen) break;
                                end = pos + bLen;
                                if (end <= (long)vLen) {
                                    iLoc = (int)((long)loc + pos);
                                    iLen = (int)bLen;
                                    if (txn != null) {
                                        try {
                                            txn.pushUnwrite(cursor.mTree.mId, cursor.mKey, pos, page, iLoc, iLen);
                                        }
                                        catch (Throwable e) {
                                            throw BTreeValue.releaseExclusive(node, e);
                                        }
                                    }
                                    PageOps.p_copyFromArray(b, bOff, page, iLoc, iLen);
                                    return 0L;
                                }
                                if (pos == 0L && bOff == 0 && bLen == (long)b.length) {
                                    try {
                                        tree = cursor.mTree;
                                        if (txn != null) {
                                            txn.pushUndoStore(tree.mId, (byte)20, page, kHeaderLoc, loc + vLen - kHeaderLoc);
                                        }
                                        node.updateLeafValue(tree, nodePos, 0, b);
                                    }
                                    catch (Throwable e) {
                                        throw BTreeValue.releaseExclusive(node, e);
                                    }
                                    if (node.mSplit != null) {
                                        node = cursor.mTree.finishSplitCritical(frame, node);
                                    }
                                    return 0L;
                                }
                                iLoc = (int)((long)loc + pos);
                                iLen = (int)((long)vLen - pos);
                                if (txn != null) {
                                    try {
                                        txn.pushUnwrite(cursor.mTree.mId, cursor.mKey, pos, page, iLoc, iLen);
                                    }
                                    catch (Throwable e) {
                                        throw BTreeValue.releaseExclusive(node, e);
                                    }
                                }
                                PageOps.p_copyFromArray(b, bOff, page, iLoc, iLen);
                                pos = vLen;
                                bOff += iLen;
                                bLen -= (long)iLen;
                            }
                        }
                        try {
                            if (txn != null) {
                                txn.pushUnextend(cursor.mTree.mId, cursor.mKey, vLen);
                                txn = null;
                            }
                            oldValue = new byte[vLen];
                            PageOps.p_copyToArray(page, loc, oldValue, 0, oldValue.length);
                            node.deleteLeafEntry(nodePos);
                        }
                        catch (Throwable e) {
                            throw BTreeValue.releaseExclusive(node, e);
                        }
                        node.postDelete(nodePos, cursor.mKey);
                        cursor.insertBlank(frame, node, pos + bLen);
                        op = 4;
                        if (bLen <= 0L) {
                            pos = 0L;
                            b = oldValue;
                            bOff = 0;
                            bLen = oldValue.length;
                            continue;
                        }
                        BTreeValue.action(null, cursor, frame, 4, 0L, oldValue, 0, oldValue.length);
                        continue;
                    }
                    fHeaderLoc = loc;
                    fHeader = PageOps.p_byteGet(page, loc++);
                    switch (fHeader >> 2 & 3) {
                        default: {
                            fLen = PageOps.p_ushortGetLE(page, loc);
                            break;
                        }
                        case 1: {
                            fLen = (long)PageOps.p_intGetLE(page, loc) & 0xFFFFFFFFL;
                            break;
                        }
                        case 2: {
                            fLen = PageOps.p_uint48GetLE(page, loc);
                            break;
                        }
                        case 3: {
                            fLen = PageOps.p_longGetLE(page, loc);
                            if (fLen >= 0L) break;
                            node.release(op > 1);
                            throw new LargeValueException(fLen);
                        }
                    }
                    loc = BTreeValue.skipFragmentedLengthField(loc, fHeader);
                    switch (op) {
                        default: {
                            return fLen;
                        }
                        case 1: {
                            try {
                                if (bLen <= 0L || pos >= fLen) {
                                    return 0L;
                                }
                                bLen = (int)Math.min(fLen - pos, bLen);
                                total = (int)bLen;
                                if ((fHeader & 2) != 0) {
                                    fInlineLen = PageOps.p_ushortGetLE(page, loc);
                                    loc += 2;
                                    amt = (int)((long)fInlineLen - pos);
                                    if (amt <= 0) {
                                        pos -= (long)fInlineLen;
                                    } else {
                                        if (bLen <= (long)amt) {
                                            PageOps.p_copyToArray(page, (int)((long)loc + pos), b, bOff, (int)bLen);
                                            return bLen;
                                        }
                                        PageOps.p_copyToArray(page, (int)((long)loc + pos), b, bOff, amt);
                                        bLen -= (long)amt;
                                        bOff += amt;
                                        pos = 0L;
                                    }
                                    loc += fInlineLen;
                                }
                                db = node.getDatabase();
                                if ((fHeader & 1) == 0) {
                                    ipos = (int)pos;
                                    pageSize = BTreeValue.pageSize(db, page);
                                    loc += ipos / pageSize * 6;
                                    fNodeOff = ipos % pageSize;
                                    while (true) {
                                        amt = Math.min((int)bLen, pageSize - fNodeOff);
                                        fNodeId = PageOps.p_uint48GetLE(page, loc);
                                        if (fNodeId == 0L) {
                                            Arrays.fill(b, bOff, bOff + amt, (byte)0);
                                        } else {
                                            fNode = db.nodeMapLoadFragment(fNodeId);
                                            PageOps.p_copyToArray(fNode.mPage, fNodeOff, b, bOff, amt);
                                            fNode.releaseShared();
                                        }
                                        if ((bLen -= (long)amt) <= 0L) {
                                            return total;
                                        }
                                        bOff += amt;
                                        loc += 6;
                                        fNodeOff = 0;
                                    }
                                }
                                inodeId = PageOps.p_uint48GetLE(page, loc);
                                if (inodeId == 0L) {
                                    Arrays.fill(b, bOff, bOff + (int)bLen, (byte)0);
                                } else {
                                    levels = db.calculateInodeLevels(fLen);
                                    inode = db.nodeMapLoadFragment(inodeId);
                                    BTreeValue.readMultilevelFragments(pos, levels, inode, b, bOff, (int)bLen);
                                }
                                return total;
                            }
                            catch (Throwable e) {
                                node.releaseShared();
                                throw e;
                            }
                        }
                        case 2: 
                        case 3: {
                            if (op == 2) {
                                if ((bLen = Math.min(bLen, fLen - pos)) <= 0L) {
                                    return 0L;
                                }
                            } else {
                                if (pos >= fLen) break;
                                if (txn != null) {
                                    txn.pushUnextend(cursor.mTree.mId, cursor.mKey, fLen);
                                }
                                bLen = fLen - pos;
                            }
                            finalLength = pos;
                            fInlineLoc = loc;
                            fInlineLen = 0;
                            if ((fHeader & 2) != 0) {
                                fInlineLen = PageOps.p_ushortGetLE(page, loc);
                                fInlineLoc += 2;
                                loc += 2;
                                amt = (long)fInlineLen - pos;
                                if (amt > 0L) {
                                    iLoc = (int)((long)loc + pos);
                                    if (bLen <= amt) {
                                        iLen = (int)bLen;
                                        if (txn != null) {
                                            try {
                                                txn.pushUnwrite(cursor.mTree.mId, cursor.mKey, pos, page, iLoc, iLen);
                                            }
                                            catch (Throwable e) {
                                                throw BTreeValue.releaseExclusive(node, e);
                                            }
                                        }
                                        PageOps.p_clear(page, iLoc, iLoc + iLen);
                                        if (op == 3) {
                                            fHeaderLoc = BTreeValue.truncateFragmented(node, page, vHeaderLoc, vLen, iLen);
                                            BTreeValue.updateLengthField(page, fHeaderLoc, finalLength);
                                        }
                                        return 0L;
                                    }
                                    iLen = (int)amt;
                                    if (txn != null) {
                                        txn.pushUnwrite(cursor.mTree.mId, cursor.mKey, pos, page, iLoc, iLen);
                                    }
                                    PageOps.p_clear(page, iLoc, iLoc + iLen);
                                    bLen -= amt;
                                    pos = fInlineLen;
                                }
                                fLen -= (long)fInlineLen;
                                loc += fInlineLen;
                            }
                            v0 = toEnd = pos - (long)fInlineLen + bLen >= fLen;
                            if ((fHeader & 1) == 0) ** GOTO lbl330
                            inodeId = PageOps.p_uint48GetLE(page, loc);
                            if (inodeId != 0L) ** GOTO lbl279
                            if (op == 2) {
                                return 0L;
                            }
                            ** GOTO lbl326
lbl279:
                            // 1 sources

                            db = node.getDatabase();
                            inode = db.nodeMapLoadFragmentExclusive(inodeId, true);
                            if (db.markFragmentDirty(inode)) {
                                PageOps.p_int48PutLE(page, loc, inode.id());
                            }
                            levels = db.calculateInodeLevels(fLen - (long)fInlineLen);
                            BTreeValue.clearMultilevelFragments(txn, cursor, pos, pos - (long)fInlineLen, levels, inode, bLen, toEnd);
                            if (op != 2) ** GOTO lbl290
                            var31_82 = 0L;
                            inode.releaseExclusive();
                            return var31_82;
lbl290:
                            // 1 sources

                            try {
                                newLevels = db.calculateInodeLevels(finalLength - (long)fInlineLen);
                                if (newLevels < levels) {
                                    do {
                                        if ((childNodeId = PageOps.p_uint48GetLE(inode.mPage, 0)) == 0L) {
                                            inodeId = 0L;
                                            break;
                                        }
                                        try {
                                            childNode = db.nodeMapLoadFragmentExclusive(childNodeId, true);
                                        }
                                        catch (Throwable e) {
                                            inode.releaseExclusive();
                                            db.close(e);
                                            throw e;
                                        }
                                        toDelete = inode;
                                        inode = childNode;
                                        db.deleteNode(toDelete);
                                        inodeId = inode.id();
                                    } while (--levels > newLevels);
                                    PageOps.p_int48PutLE(page, loc, inodeId);
                                    if (newLevels <= 0) {
                                        if (pos == 0L) {
                                            PageOps.p_bytePut(page, vHeaderLoc, 0);
                                            garbageAccum = fHeaderLoc - vHeaderLoc + vLen - 1;
                                            node.garbage(node.garbage() + garbageAccum);
                                            db.deleteNode(inode);
                                        } else {
                                            PageOps.p_bytePut(page, fHeaderLoc, fHeader & -2);
                                        }
                                    }
                                }
                                ** GOTO lbl326
                            }
                            catch (Throwable e) {
                                throw BTreeValue.releaseExclusive(node, e);
                            }
                            {
                                catch (Throwable var36_106) {
                                    throw var36_106;
                                }
                            }
                            {
                                finally {
                                    inode.releaseExclusive();
                                }
lbl326:
                                // 3 sources

                                BTreeValue.updateLengthField(page, fHeaderLoc, finalLength);
                                return 0L;
                            }
lbl330:
                            // 1 sources

                            db = node.getDatabase();
                            ipos = (int)(pos - (long)fInlineLen);
                            pageSize = BTreeValue.pageSize(db, page);
                            fNodeOff = ipos % pageSize;
                            firstDeletedLoc = loc += ipos / pageSize * 6;
                            try {
                                while (true) {
                                    amt = Math.min((int)bLen, pageSize - fNodeOff);
                                    fNodeId = PageOps.p_uint48GetLE(page, loc);
                                    if (fNodeId == 0L) ** GOTO lbl366
                                    if (amt < pageSize && (!toEnd || fNodeOff > 0)) ** GOTO lbl353
                                    if (txn == null) {
                                        db.deleteFragment(fNodeId);
                                    } else {
                                        fNode = db.nodeMapLoadFragmentExclusive(fNodeId, true);
                                        try {
                                            txn.pushUnwrite(cursor.mTree.mId, cursor.mKey, pos, fNode.mPage, 0, amt);
                                        }
                                        catch (Throwable e) {
                                            fNode.releaseExclusive();
                                        }
                                        db.deleteNode(fNode);
                                    }
                                    PageOps.p_int48PutLE(page, loc, 0L);
                                    ** GOTO lbl366
lbl353:
                                    // 1 sources

                                    fNode = db.nodeMapLoadFragmentExclusive(fNodeId, true);
                                    try {
                                        if (db.markFragmentDirty(fNode)) {
                                            PageOps.p_int48PutLE(page, loc, fNode.id());
                                        }
                                        fNodePage = fNode.mPage;
                                        if (txn != null) {
                                            txn.pushUnwrite(cursor.mTree.mId, cursor.mKey, pos, fNodePage, fNodeOff, amt);
                                        }
                                        PageOps.p_clear(fNode.mPage, fNodeOff, fNodeOff + amt);
                                    }
                                    finally {
                                        fNode.releaseExclusive();
                                    }
                                    firstDeletedLoc += 6;
lbl366:
                                    // 3 sources

                                    loc += 6;
                                    if ((bLen -= (long)amt) <= 0L) {
                                        if (op == 3) {
                                            shrinkage = loc - firstDeletedLoc;
                                            if (ipos <= 0) {
                                                len = (int)finalLength;
                                                shrinkage = shrinkage - ipos + fInlineLen - len;
                                                BTreeValue.fragmentedToNormal(node, page, vHeaderLoc, fInlineLoc, len, shrinkage);
                                            } else {
                                                fHeaderLoc = BTreeValue.truncateFragmented(node, page, vHeaderLoc, vLen, shrinkage);
                                                BTreeValue.updateLengthField(page, fHeaderLoc, finalLength);
                                            }
                                        }
                                        return 0L;
                                    }
                                    pos += (long)amt;
                                    fNodeOff = 0;
                                }
                            }
                            catch (Throwable e) {
                                throw BTreeValue.releaseExclusive(node, e);
                            }
                        }
                        case 4: 
                    }
                    fInlineLen = 0;
                    if ((fHeader & 2) != 0) {
                        fInlineLen = PageOps.p_ushortGetLE(page, loc);
                        loc += 2;
                        amt = (long)fInlineLen - pos;
                        if (amt > 0L) {
                            iLoc = (int)((long)loc + pos);
                            if (bLen <= amt) {
                                iLen = (int)bLen;
                                if (txn != null) {
                                    txn.pushUnwrite(cursor.mTree.mId, cursor.mKey, pos, page, iLoc, iLen);
                                }
                                PageOps.p_copyFromArray(b, bOff, page, iLoc, iLen);
                                return 0L;
                            }
                            iLen = (int)amt;
                            if (txn != null) {
                                try {
                                    txn.pushUnwrite(cursor.mTree.mId, cursor.mKey, pos, page, iLoc, iLen);
                                }
                                catch (Throwable e) {
                                    throw BTreeValue.releaseExclusive(node, e);
                                }
                            }
                            PageOps.p_copyFromArray(b, bOff, page, iLoc, iLen);
                            bLen -= amt;
                            bOff = (int)((long)bOff + amt);
                            pos = fInlineLen;
                        }
                        loc += fInlineLen;
                    }
                    if ((endPos = pos + bLen) <= fLen) {
                        if (endPos < 0L) {
                            node.releaseExclusive();
                            throw new IllegalArgumentException("Length overflow");
                        }
                        if (bLen == 0L) {
                            return 0L;
                        }
                        db = node.getDatabase();
                        if ((fHeader & 1) != 0) {
                            try {
                                levels = db.calculateInodeLevels(fLen - (long)fInlineLen);
                                inode = BTreeValue.prepareMultilevelWrite(db, page, loc);
                                BTreeValue.writeMultilevelFragments(txn, cursor, pos, pos - (long)fInlineLen, levels, inode, b, bOff, (int)bLen);
                                return 0L;
                            }
                            catch (Throwable e) {
                                throw BTreeValue.releaseExclusive(node, e);
                            }
                        }
                        pageSize = BTreeValue.pageSize(db, page);
                        break block165;
                    }
                    fieldGrowth = BTreeValue.lengthFieldGrowth(fHeader, endPos);
                    if (fieldGrowth > 0) {
                        BTreeValue.tryIncreaseLengthField(cursor, frame, kHeaderLoc, vHeaderLoc, vLen, fHeaderLoc, fieldGrowth);
                        continue;
                    }
                    db = node.getDatabase();
                    if ((fHeader & 1) != 0) {
                        try {
                            if (txn != null) {
                                txn.pushUnextend(cursor.mTree.mId, cursor.mKey, fLen);
                                if (pos >= fLen) {
                                    txn = null;
                                }
                            }
                            inode = BTreeValue.prepareMultilevelWrite(db, page, loc);
                            levels = db.calculateInodeLevels(fLen - (long)fInlineLen);
                            newLen = endPos - (long)fInlineLen;
                            if (db.levelCap(levels) < newLen) {
                                newLevels = db.calculateInodeLevels(newLen);
                                if (newLevels <= levels) {
                                    throw new AssertionError();
                                }
                                pageSize = BTreeValue.pageSize(db, page);
                                newNodes = new Node[newLevels - levels];
                                for (i = 0; i < newNodes.length; ++i) {
                                    try {
                                        newNodes[i] = db.allocDirtyFragmentNode();
                                        continue;
                                    }
                                    catch (Throwable e) {
                                        try {
                                            while (--i >= 0) {
                                                db.deleteNode(newNodes[i], true);
                                            }
                                        }
                                        catch (Throwable e2) {
                                            Utils.suppress(e, e2);
                                            db.close(e);
                                        }
                                        throw e;
                                    }
                                }
                                for (Node upper : newNodes) {
                                    upage = upper.mPage;
                                    PageOps.p_int48PutLE(upage, 0, inode.id());
                                    inode.releaseExclusive();
                                    PageOps.p_clear(upage, 6, pageSize);
                                    inode = upper;
                                }
                                levels = newLevels;
                                PageOps.p_int48PutLE(page, loc, inode.id());
                            }
                            BTreeValue.updateLengthField(page, fHeaderLoc, endPos);
                            BTreeValue.writeMultilevelFragments(txn, cursor, pos, pos - (long)fInlineLen, levels, inode, b, bOff, (int)bLen);
                            return 0L;
                        }
                        catch (Throwable e) {
                            throw BTreeValue.releaseExclusive(node, e);
                        }
                    }
                    pageSize = BTreeValue.pageSize(db, page);
                    ptrGrowth = BTreeValue.pointerCount(pageSize, endPos - (long)fInlineLen) - BTreeValue.pointerCount(pageSize, fLen - (long)fInlineLen);
                    if (ptrGrowth <= 0L) break block166;
                    newLoc = BTreeValue.tryExtendDirect(cursor, frame, kHeaderLoc, vHeaderLoc, vLen, fHeaderLoc, ptrGrowth * 6L);
                    if (newLoc >= 0) break;
                }
                page = node.mPage;
                delta = newLoc - fHeaderLoc;
                loc += delta;
                fHeaderLoc = newLoc;
            }
            if (txn != null) {
                try {
                    txn.pushUnextend(cursor.mTree.mId, cursor.mKey, fLen);
                    if (pos >= fLen) {
                        txn = null;
                    }
                }
                catch (Throwable e) {
                    throw BTreeValue.releaseExclusive(node, e);
                }
            }
            BTreeValue.updateLengthField(page, fHeaderLoc, endPos);
        }
        ipos = (int)(pos - (long)fInlineLen);
        loc += ipos / pageSize * 6;
        fNodeOff = ipos % pageSize;
        try {
            while (true) {
                if ((amt = Math.min((int)bLen, pageSize - fNodeOff)) > 0) {
                    fNodeId = PageOps.p_uint48GetLE(page, loc);
                    if (fNodeId == 0L) {
                        if (txn != null) {
                            txn.pushUnalloc(cursor.mTree.mId, cursor.mKey, pos, amt);
                        }
                        fNode = db.allocDirtyFragmentNode();
                        try {
                            PageOps.p_int48PutLE(page, loc, fNode.id());
                            fNodePage = fNode.mPage;
                            PageOps.p_clear(fNodePage, 0, fNodeOff);
                            PageOps.p_copyFromArray(b, bOff, fNodePage, fNodeOff, amt);
                            PageOps.p_clear(fNodePage, fNodeOff + amt, pageSize);
                        }
                        finally {
                            fNode.releaseExclusive();
                        }
                    }
                    if (txn == null) {
                        fNode = db.nodeMapLoadFragmentExclusive(fNodeId, amt < pageSize);
                    } else {
                        fNode = db.nodeMapLoadFragmentExclusive(fNodeId, true);
                        try {
                            txn.pushUnwrite(cursor.mTree.mId, cursor.mKey, pos, fNode.mPage, fNodeOff, amt);
                        }
                        catch (Throwable e) {
                            fNode.releaseExclusive();
                            throw e;
                        }
                    }
                    try {
                        if (db.markFragmentDirty(fNode)) {
                            PageOps.p_int48PutLE(page, loc, fNode.id());
                        }
                        PageOps.p_copyFromArray(b, bOff, fNode.mPage, fNodeOff, amt);
                    }
                    finally {
                        fNode.releaseExclusive();
                    }
                    bLen -= (long)amt;
                }
                if (bLen <= 0L) {
                    return 0L;
                }
                bOff += amt;
                pos += (long)pageSize;
                loc += 6;
                fNodeOff = 0;
            }
        }
        catch (Throwable e) {
            throw BTreeValue.releaseExclusive(node, e);
        }
    }

    private static void readMultilevelFragments(long pos, int level, Node inode, byte[] b, int bOff, int bLen) throws IOException {
        LocalDatabase db = inode.getDatabase();
        block4: while (true) {
            byte[] page = inode.mPage;
            long levelCap = db.levelCap(--level);
            int poffset = (int)(pos / levelCap) * 6;
            long ppos = pos % levelCap;
            while (true) {
                long childNodeId = PageOps.p_uint48GetLE(page, poffset);
                int len = (int)Math.min(levelCap - ppos, (long)bLen);
                bLen -= len;
                if (childNodeId == 0L) {
                    Arrays.fill(b, bOff, bOff + len, (byte)0);
                    if (bLen <= 0) {
                        inode.releaseShared();
                        return;
                    }
                } else {
                    Node childNode;
                    try {
                        childNode = db.nodeMapLoadFragment(childNodeId);
                    }
                    catch (Throwable e) {
                        inode.releaseShared();
                        throw e;
                    }
                    if (level <= 0) {
                        PageOps.p_copyToArray(childNode.mPage, (int)ppos, b, bOff, len);
                        childNode.releaseShared();
                        if (bLen <= 0) {
                            inode.releaseShared();
                            return;
                        }
                    } else {
                        if (bLen <= 0) {
                            inode.releaseShared();
                            pos = ppos;
                            inode = childNode;
                            bLen = len;
                            continue block4;
                        }
                        try {
                            BTreeValue.readMultilevelFragments(ppos, level, childNode, b, bOff, len);
                        }
                        catch (Throwable e) {
                            inode.releaseShared();
                            throw e;
                        }
                    }
                }
                bOff += len;
                poffset += 6;
                ppos = 0L;
            }
            break;
        }
    }

    private static Node prepareMultilevelWrite(LocalDatabase db, byte[] page, int loc) throws IOException {
        Node inode;
        long inodeId = PageOps.p_uint48GetLE(page, loc);
        if (inodeId == 0L) {
            inode = db.allocDirtyFragmentNode();
            PageOps.p_clear(inode.mPage, 0, BTreeValue.pageSize(db, inode.mPage));
        } else {
            inode = db.nodeMapLoadFragmentExclusive(inodeId, true);
            try {
                if (!db.markFragmentDirty(inode)) {
                    return inode;
                }
            }
            catch (Throwable e) {
                throw BTreeValue.releaseExclusive(inode, e);
            }
        }
        PageOps.p_int48PutLE(page, loc, inode.id());
        return inode;
    }

    private static void writeMultilevelFragments(LocalTransaction txn, BTreeCursor cursor, long pos, long ppos, int level, Node inode, byte[] b, int bOff, int bLen) throws IOException {
        LocalDatabase db = inode.getDatabase();
        block10: while (true) {
            byte[] page = inode.mPage;
            long levelCap = db.levelCap(--level);
            int poffset = (int)(ppos / levelCap) * 6;
            ppos %= levelCap;
            int pageSize = BTreeValue.pageSize(db, page);
            while (true) {
                long childNodeId = PageOps.p_uint48GetLE(page, poffset);
                int len = (int)Math.min(levelCap - ppos, (long)bLen);
                bLen -= len;
                if (level <= 0) {
                    block23: {
                        block22: {
                            try {
                                if (childNodeId == 0L) {
                                    if (txn != null) {
                                        txn.pushUnalloc(cursor.mTree.mId, cursor.mKey, pos, len);
                                    }
                                    childNode = db.allocDirtyFragmentNode();
                                    if (ppos > 0L || len < pageSize) {
                                        PageOps.p_clear(childNode.mPage, 0, pageSize);
                                    }
                                    break block22;
                                }
                                if (txn == null) {
                                    childNode = db.nodeMapLoadFragmentExclusive(childNodeId, ppos > 0L | len < pageSize);
                                } else {
                                    childNode = db.nodeMapLoadFragmentExclusive(childNodeId, true);
                                    txn.pushUnwrite(cursor.mTree.mId, cursor.mKey, pos, childNode.mPage, (int)ppos, len);
                                }
                                try {
                                    if (db.markFragmentDirty(childNode)) break block22;
                                    break block23;
                                }
                                catch (Throwable e) {
                                    throw BTreeValue.releaseExclusive(childNode, e);
                                }
                            }
                            catch (Throwable e) {
                                throw BTreeValue.releaseExclusive(inode, e);
                            }
                        }
                        PageOps.p_int48PutLE(page, poffset, childNode.id());
                    }
                    PageOps.p_copyFromArray(b, bOff, childNode.mPage, (int)ppos, len);
                    childNode.releaseExclusive();
                    if (bLen <= 0) {
                        inode.releaseExclusive();
                        return;
                    }
                } else {
                    block25: {
                        block24: {
                            try {
                                if (childNodeId == 0L) {
                                    childNode = db.allocDirtyFragmentNode();
                                    PageOps.p_clear(childNode.mPage, 0, pageSize);
                                    break block24;
                                }
                                childNode = db.nodeMapLoadFragmentExclusive(childNodeId, true);
                                try {
                                    if (db.markFragmentDirty(childNode)) break block24;
                                    break block25;
                                }
                                catch (Throwable e) {
                                    throw BTreeValue.releaseExclusive(childNode, e);
                                }
                            }
                            catch (Throwable e) {
                                throw BTreeValue.releaseExclusive(inode, e);
                            }
                        }
                        PageOps.p_int48PutLE(page, poffset, childNode.id());
                    }
                    if (bLen <= 0) {
                        inode.releaseExclusive();
                        inode = childNode;
                        bLen = len;
                        continue block10;
                    }
                    try {
                        BTreeValue.writeMultilevelFragments(txn, cursor, pos, ppos, level, childNode, b, bOff, len);
                    }
                    catch (Throwable e) {
                        throw BTreeValue.releaseExclusive(inode, e);
                    }
                }
                pos += (long)len;
                bOff += len;
                poffset += 6;
                ppos = 0L;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearMultilevelFragments(LocalTransaction txn, BTreeCursor cursor, long pos, long ppos, int level, Node inode, long clearLen, boolean toEnd) throws IOException {
        LocalDatabase db = inode.getDatabase();
        byte[] page = inode.mPage;
        long levelCap = db.levelCap(--level);
        int poffset = (int)(ppos / levelCap) * 6;
        ppos %= levelCap;
        while (true) {
            long len = Math.min(levelCap - ppos, clearLen);
            long childNodeId = PageOps.p_uint48GetLE(page, poffset);
            if (childNodeId != 0L) {
                if (len >= levelCap || toEnd && ppos <= 0L) {
                    block16: {
                        block17: {
                            childNode = null;
                            try {
                                if (level <= 0) {
                                    if (txn == null) {
                                        db.deleteFragment(childNodeId);
                                        break block16;
                                    }
                                    childNode = db.nodeMapLoadFragmentExclusive(childNodeId, true);
                                    txn.pushUnwrite(cursor.mTree.mId, cursor.mKey, pos, childNode.mPage, 0, (int)len);
                                    break block17;
                                }
                                childNode = db.nodeMapLoadFragmentExclusive(childNodeId, true);
                                BTreeValue.clearMultilevelFragments(txn, cursor, pos, ppos, level, childNode, len, toEnd);
                            }
                            catch (Throwable e) {
                                if (childNode != null) {
                                    childNode.releaseExclusive();
                                }
                                throw e;
                            }
                        }
                        db.deleteNode(childNode);
                    }
                    PageOps.p_int48PutLE(page, poffset, 0L);
                } else {
                    childNode = db.nodeMapLoadFragmentExclusive(childNodeId, true);
                    try {
                        if (db.markFragmentDirty(childNode)) {
                            PageOps.p_int48PutLE(page, poffset, childNode.id());
                        }
                        if (level <= 0) {
                            byte[] childPage = childNode.mPage;
                            if (txn != null) {
                                txn.pushUnwrite(cursor.mTree.mId, cursor.mKey, pos, childPage, (int)ppos, (int)len);
                            }
                            PageOps.p_clear(childPage, (int)ppos, (int)(ppos + len));
                        } else {
                            BTreeValue.clearMultilevelFragments(txn, cursor, pos, ppos, level, childNode, len, toEnd);
                        }
                    }
                    finally {
                        childNode.releaseExclusive();
                    }
                }
            }
            if ((clearLen -= len) <= 0L) break;
            pos += len;
            poffset += 6;
            ppos = 0L;
        }
    }

    private static void touchMultilevelFragment(long ppos, int level, Node inode) throws IOException {
        LocalDatabase db = inode.getDatabase();
        long levelCap;
        int poffset;
        byte[] page;
        long childNodeId;
        while ((childNodeId = PageOps.p_uint48GetLE(page = inode.mPage, poffset = (int)(ppos / (levelCap = db.levelCap(--level))) * 6)) != 0L) {
            Node childNode;
            try {
                childNode = db.nodeMapLoadFragmentExclusive(childNodeId, true);
                try {
                    if (db.markFragmentDirty(childNode)) {
                        PageOps.p_int48PutLE(page, poffset, childNode.id());
                    }
                }
                catch (Throwable e) {
                    throw BTreeValue.releaseExclusive(childNode, e);
                }
            }
            catch (Throwable e) {
                throw BTreeValue.releaseExclusive(inode, e);
            }
            if (level <= 0) {
                childNode.releaseExclusive();
                inode.releaseExclusive();
                return;
            }
            inode.releaseExclusive();
            inode = childNode;
            ppos %= levelCap;
        }
        return;
    }

    private static int lengthFieldGrowth(int fHeader, long fLen) {
        int growth = 0;
        switch (fHeader >> 2 & 3) {
            case 0: {
                if (fLen < 65536L) break;
                growth = 2;
            }
            case 1: {
                if (fLen < 0x100000000L) break;
                growth += 2;
            }
            case 2: {
                if (fLen < 0x1000000000000L) break;
                growth += 2;
            }
        }
        return growth;
    }

    private static void updateLengthField(byte[] page, int fHeaderLoc, long fLen) {
        byte fHeader = PageOps.p_byteGet(page, fHeaderLoc);
        switch (fHeader >> 2 & 3) {
            case 0: {
                PageOps.p_shortPutLE(page, fHeaderLoc + 1, (int)fLen);
                break;
            }
            case 1: {
                PageOps.p_intPutLE(page, fHeaderLoc + 1, (int)fLen);
                break;
            }
            case 2: {
                PageOps.p_int48PutLE(page, fHeaderLoc + 1, fLen);
                break;
            }
            default: {
                PageOps.p_longPutLE(page, fHeaderLoc + 1, fLen);
            }
        }
    }

    private static void tryIncreaseLengthField(BTreeCursor cursor, CursorFrame frame, int kHeaderLoc, int vHeaderLoc, int vLen, int fHeaderLoc, long growth) throws IOException {
        int fOffset = fHeaderLoc - kHeaderLoc;
        long newEntryLen = (long)(fOffset + vLen) + growth;
        Node node = frame.mNode;
        if (newEntryLen > (long)node.getDatabase().mMaxFragmentedEntrySize) {
            BTreeValue.compactDirectFormat(cursor, frame, kHeaderLoc, vHeaderLoc, vLen, fHeaderLoc);
            return;
        }
        BTree tree = cursor.mTree;
        try {
            int igrowth = (int)growth;
            byte[] newValue = new byte[vLen + igrowth];
            byte[] page = node.mPage;
            byte fHeader = PageOps.p_byteGet(page, fHeaderLoc);
            newValue[0] = (byte)(fHeader + (igrowth << 1));
            int srcLoc = fHeaderLoc + 1;
            int fieldLen = BTreeValue.skipFragmentedLengthField(0, fHeader);
            PageOps.p_copyToArray(page, srcLoc, newValue, 1, fieldLen);
            int dstLoc = 1 + fieldLen + igrowth;
            PageOps.p_copyToArray(page, srcLoc += fieldLen, newValue, dstLoc, newValue.length - dstLoc);
            PageOps.p_bytePut(page, vHeaderLoc, PageOps.p_byteGet(page, vHeaderLoc) & 0xFFFFFFBF);
            node.updateLeafValue(tree, frame.mNodePos, 64, newValue);
        }
        catch (Throwable e) {
            throw BTreeValue.releaseExclusive(node, e);
        }
        if (node.mSplit != null) {
            tree.finishSplitCritical(frame, node);
        }
    }

    private static long pointerCount(long pageSize, long len) {
        long count = (len + pageSize - 1L) / pageSize;
        if (count < 0L) {
            count = BTreeValue.pointerCountOverflow(pageSize, len);
        }
        return count;
    }

    private static long pointerCountOverflow(long pageSize, long len) {
        return BigInteger.valueOf(len).add(BigInteger.valueOf(pageSize - 1L)).subtract(BigInteger.ONE).divide(BigInteger.valueOf(pageSize)).longValue();
    }

    private static int tryExtendDirect(BTreeCursor cursor, CursorFrame frame, int kHeaderLoc, int vHeaderLoc, int vLen, int fHeaderLoc, long growth) throws IOException {
        int fOffset = fHeaderLoc - kHeaderLoc;
        long newEntryLen = (long)(fOffset + vLen) + growth;
        Node node = frame.mNode;
        if (newEntryLen > (long)node.getDatabase().mMaxFragmentedEntrySize) {
            BTreeValue.compactDirectFormat(cursor, frame, kHeaderLoc, vHeaderLoc, vLen, fHeaderLoc);
            return -1;
        }
        BTree tree = cursor.mTree;
        int newValueLen = vLen + (int)growth;
        try {
            byte[] newValue = new byte[newValueLen];
            byte[] page = node.mPage;
            PageOps.p_copyToArray(page, fHeaderLoc, newValue, 0, vLen);
            PageOps.p_bytePut(page, vHeaderLoc, PageOps.p_byteGet(page, vHeaderLoc) & 0xFFFFFFBF);
            node.updateLeafValue(tree, frame.mNodePos, 64, newValue);
        }
        catch (Throwable e) {
            throw BTreeValue.releaseExclusive(node, e);
        }
        if (node.mSplit != null) {
            tree.finishSplitCritical(frame, node);
            return -2;
        }
        if (newValueLen > 8192 && vLen <= 8192) {
            return -1;
        }
        return PageOps.p_ushortGetLE(node.mPage, node.searchVecStart() + frame.mNodePos) + fOffset;
    }

    private static int skipFragmentedLengthField(int loc, int fHeader) {
        return loc + 2 + (fHeader >> 1 & 6);
    }

    private static void compactDirectFormat(BTreeCursor cursor, CursorFrame frame, int kHeaderLoc, int vHeaderLoc, int vLen, int fHeaderLoc) throws IOException {
        int shrinkage;
        int fInlineLen;
        Node node = frame.mNode;
        byte[] page = node.mPage;
        int loc = fHeaderLoc;
        byte fHeader = PageOps.p_byteGet(page, loc++);
        long fLen = LocalDatabase.decodeFullFragmentedValueLength(fHeader, page, loc);
        loc = BTreeValue.skipFragmentedLengthField(loc, fHeader);
        if ((fHeader & 2) == 0) {
            fInlineLen = 0;
        } else {
            fInlineLen = PageOps.p_ushortGetLE(page, loc);
            loc = loc + 2 + fInlineLen;
        }
        int tailLen = fHeaderLoc + vLen - loc;
        LocalDatabase db = node.getDatabase();
        int pageSize = BTreeValue.pageSize(db, page);
        if (fInlineLen > 0) {
            Node leftNode;
            if (fInlineLen < 4) {
                byte[] newValue;
                try {
                    byte[] fullValue = db.reconstruct(page, fHeaderLoc, vLen);
                    int max = db.mMaxFragmentedEntrySize - (vHeaderLoc - kHeaderLoc);
                    newValue = db.fragment(fullValue, fullValue.length, max, 0);
                }
                catch (Throwable e) {
                    throw BTreeValue.releaseExclusive(node, e);
                }
                try {
                    node.updateLeafValue(cursor.mTree, frame.mNodePos, 64, newValue);
                }
                catch (Throwable e) {
                    throw BTreeValue.releaseExclusive(node, e);
                }
                if (node.mSplit != null) {
                    cursor.mTree.finishSplitCritical(frame, node);
                }
                return;
            }
            Node rightNode = null;
            try {
                if (BTreeValue.pointerCount(pageSize, fLen) * 6L <= (long)tailLen) {
                    shrinkage = 2 + fInlineLen;
                } else {
                    rightNode = db.allocDirtyFragmentNode();
                    PageOps.p_clear(rightNode.mPage, fInlineLen, pageSize);
                    shrinkage = 2 + fInlineLen - 6;
                }
                leftNode = BTreeValue.shiftDirectRight(db, page, loc, loc + tailLen, fInlineLen, rightNode);
            }
            catch (Throwable e) {
                node.releaseExclusive();
                try {
                    if (rightNode != null) {
                        db.deleteNode(rightNode, true);
                    }
                }
                catch (Throwable e2) {
                    Utils.suppress(e, e2);
                    db.close(e);
                }
                throw e;
            }
            PageOps.p_copy(page, loc - fInlineLen, leftNode.mPage, 0, fInlineLen);
            leftNode.releaseExclusive();
            PageOps.p_copy(page, loc, page, loc - fInlineLen - 2, tailLen);
            if (rightNode != null) {
                PageOps.p_int48PutLE(page, loc - fInlineLen - 2 + tailLen, rightNode.id());
            }
            PageOps.p_bytePut(page, fHeaderLoc, fHeader & 0xFFFFFFFD);
        } else {
            if (fLen - (long)fInlineLen > (long)pageSize) {
                Node inode;
                try {
                    inode = db.allocDirtyFragmentNode();
                }
                catch (Throwable e) {
                    throw BTreeValue.releaseExclusive(node, e);
                }
                byte[] ipage = inode.mPage;
                PageOps.p_copy(page, loc, ipage, 0, tailLen);
                PageOps.p_clear(ipage, tailLen, pageSize);
                PageOps.p_int48PutLE(page, loc, inode.id());
                inode.releaseExclusive();
            }
            PageOps.p_bytePut(page, fHeaderLoc, fHeader | 1);
            shrinkage = tailLen - 6;
        }
        int newLen = vLen - shrinkage - 1;
        byte header = PageOps.p_byteGet(page, vHeaderLoc);
        if ((header & 0x20) == 0) {
            PageOps.p_bytePut(page, vHeaderLoc, header & 0xE0 | newLen >> 8);
            PageOps.p_bytePut(page, vHeaderLoc + 1, newLen);
        } else {
            PageOps.p_bytePut(page, vHeaderLoc, header & 0xF0 | newLen >> 16);
            PageOps.p_bytePut(page, vHeaderLoc + 1, newLen >> 8);
            PageOps.p_bytePut(page, vHeaderLoc + 2, newLen);
        }
        node.garbage(node.garbage() + shrinkage);
        if (node.shouldLeafMerge()) {
            cursor.mergeLeaf(frame, node);
            frame.acquireExclusive();
            cursor.notSplitDirty(frame);
        }
    }

    private static Node shiftDirectRight(LocalDatabase db, byte[] page, int startLoc, int endLoc, int amount, Node dstNode) throws IOException {
        Node[] fNodes = new Node[(endLoc - startLoc) / 6];
        int pageSize = BTreeValue.pageSize(db, page);
        try {
            boolean requireDest = true;
            int i = 0;
            for (int loc = startLoc; loc < endLoc; loc += 6) {
                long fNodeId = PageOps.p_uint48GetLE(page, loc);
                if (fNodeId != 0L) {
                    fNodes[i] = fNode = db.nodeMapLoadFragmentExclusive(fNodeId, true);
                    if (db.markFragmentDirty(fNode)) {
                        PageOps.p_int48PutLE(page, loc, fNode.id());
                    }
                    requireDest = true;
                } else if (requireDest) {
                    fNode = db.allocDirtyFragmentNode();
                    PageOps.p_clear(fNode.mPage, 0, pageSize);
                    fNodes[i] = fNode;
                    PageOps.p_int48PutLE(page, loc, fNode.id());
                    requireDest = false;
                }
                ++i;
            }
        }
        catch (Throwable e) {
            for (Node fNode : fNodes) {
                if (fNode == null) continue;
                fNode.releaseExclusive();
            }
            throw e;
        }
        int i = fNodes.length;
        while (--i >= 0) {
            Node fNode = fNodes[i];
            if (fNode == null) {
                if (dstNode != null) {
                    PageOps.p_clear(dstNode.mPage, 0, amount);
                    dstNode.releaseExclusive();
                }
            } else {
                byte[] fPage = fNode.mPage;
                if (dstNode != null) {
                    PageOps.p_copy(fPage, pageSize - amount, dstNode.mPage, 0, amount);
                    dstNode.releaseExclusive();
                }
                PageOps.p_copy(fPage, 0, fPage, amount, pageSize - amount);
            }
            dstNode = fNode;
        }
        return dstNode;
    }

    private static void fragmentedToNormal(Node node, byte[] page, int vHeaderLoc, int fInlineLoc, int fInlineLen, int shrinkage) {
        int loc = vHeaderLoc;
        if (fInlineLen <= 127) {
            PageOps.p_bytePut(page, loc++, fInlineLen);
        } else if (fInlineLen <= 8192) {
            PageOps.p_bytePut(page, loc++, 0x80 | fInlineLen - 1 >> 8);
            PageOps.p_bytePut(page, loc++, fInlineLen - 1);
        } else {
            PageOps.p_bytePut(page, loc++, 0xA0 | fInlineLen - 1 >> 16);
            PageOps.p_bytePut(page, loc++, fInlineLen - 1 >> 8);
            PageOps.p_bytePut(page, loc++, fInlineLen - 1);
        }
        PageOps.p_copy(page, fInlineLoc, page, loc, fInlineLen);
        node.garbage(node.garbage() + shrinkage + (fInlineLoc - loc));
    }

    private static int truncateFragmented(Node node, byte[] page, int vHeaderLoc, int vLen, int shrinkage) {
        int newLen = vLen - shrinkage;
        int loc = vHeaderLoc;
        if ((PageOps.p_byteGet(page, loc) & 0x20) == 0) {
            PageOps.p_bytePut(page, loc++, 0xC0 | newLen - 1 >> 8);
        } else {
            PageOps.p_bytePut(page, loc++, 0xE0 | newLen - 1 >> 16);
            PageOps.p_bytePut(page, loc++, newLen - 1 >> 8);
        }
        PageOps.p_bytePut(page, loc++, newLen - 1);
        node.garbage(node.garbage() + shrinkage);
        return loc;
    }

    private static int pageSize(LocalDatabase db, byte[] page) {
        return page.length;
    }

    private static RuntimeException releaseExclusive(Node node, Throwable cause) {
        node.releaseExclusive();
        throw Utils.rethrow(cause);
    }
}

