/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Checksum;
import org.cojen.tupl.io.Utils;

class CheckedInputStream
extends InputStream {
    private final InputStream mSource;
    private final Checksum mChecksum;
    private long mRemaining;

    CheckedInputStream(InputStream source, Checksum checksum, long length) {
        this.mSource = source;
        this.mChecksum = checksum;
        this.mRemaining = length;
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        return this.read(buf) <= 0 ? -1 : buf[0] & 0xFF;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int amt = this.mSource.read(buf, off, (long)len <= this.mRemaining ? len : (int)this.mRemaining);
        if (amt <= 0) {
            if (len == 0) {
                return 0;
            }
            if (this.mRemaining <= 0L) {
                return -1;
            }
            throw new EOFException("Remaining length: " + this.mRemaining);
        }
        this.mChecksum.update(buf, off, amt);
        if ((this.mRemaining -= (long)amt) <= 0L) {
            byte[] expectBuf = new byte[4];
            try {
                Utils.readFully(this.mSource, expectBuf, 0, expectBuf.length);
            }
            catch (EOFException e) {
                throw new EOFException("Checksum is missing");
            }
            int expect = Utils.decodeIntLE(expectBuf, 0);
            int actual = (int)this.mChecksum.getValue();
            if (expect != actual) {
                throw new IOException("Checksum mismatch: " + expect + " != " + actual);
            }
        }
        return amt;
    }

    @Override
    public void close() throws IOException {
        this.mSource.close();
    }
}

