/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.core.CoreDatabase;
import org.cojen.tupl.core.Launcher;
import org.cojen.tupl.core.ShutdownHook;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.diag.EventListener;
import org.cojen.tupl.diag.EventType;
import org.cojen.tupl.util.Latch;
import org.cojen.tupl.util.Parker;

final class Checkpointer
extends Latch
implements Runnable {
    private static final int STATE_INIT = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_CLOSED = 2;
    private final ReferenceQueue<CoreDatabase> mRefQueue;
    private final WeakReference<CoreDatabase> mDatabaseRef;
    private final long mRateNanos;
    private final long mSizeThreshold;
    private final long mDelayThresholdNanos;
    private volatile Thread mThread;
    private volatile int mState;
    private Thread mShutdownHook;
    private List<ShutdownHook> mToShutdown;
    private final ThreadPoolExecutor mExtraExecutor;
    private volatile int mSuspendCount;

    Checkpointer(CoreDatabase db, Launcher launcher, int extraLimit) {
        ThreadPoolExecutor extraExecutor;
        this.mRateNanos = launcher.mCheckpointRateNanos;
        this.mSizeThreshold = launcher.mCheckpointSizeThreshold;
        this.mDelayThresholdNanos = launcher.mCheckpointDelayThresholdNanos;
        if (this.mRateNanos < 0L) {
            this.mRefQueue = new ReferenceQueue();
            this.mDatabaseRef = new WeakReference<CoreDatabase>(db, this.mRefQueue);
        } else {
            this.mRefQueue = null;
            this.mDatabaseRef = new WeakReference<CoreDatabase>(db);
        }
        int max = launcher.mMaxCheckpointThreads;
        if (max < 0) {
            max = -max * Runtime.getRuntime().availableProcessors();
        }
        if ((max = Math.min(max, extraLimit) - 1) <= 0) {
            extraExecutor = null;
        } else {
            long keepAliveSeconds = 60L;
            long rateSeconds = TimeUnit.NANOSECONDS.toSeconds(launcher.mCheckpointRateNanos);
            if (rateSeconds <= keepAliveSeconds * 2L) {
                keepAliveSeconds = Math.max(keepAliveSeconds, rateSeconds + 5L);
            }
            extraExecutor = new ThreadPoolExecutor(max, max, keepAliveSeconds, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Checkpointer::newThread);
            extraExecutor.allowCoreThreadTimeOut(true);
        }
        this.mExtraExecutor = extraExecutor;
    }

    void start(boolean initialCheckpoint) {
        if (!initialCheckpoint) {
            this.mState = 1;
        }
        Thread t = Checkpointer.newThread(this);
        t.start();
        this.mThread = t;
    }

    boolean isStarted() {
        return this.mThread != null;
    }

    private static Thread newThread(Runnable r) {
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.setName("Checkpointer-" + Long.toUnsignedString(Parker.threadId(t)));
        return t;
    }

    @Override
    public void run() {
        try {
            if (this.mState == 0) {
                CoreDatabase db = (CoreDatabase)this.mDatabaseRef.get();
                if (db != null) {
                    db.checkpoint();
                }
                this.mState = 1;
            }
            if (this.mRefQueue != null) {
                this.mRefQueue.remove();
                this.close(null);
                return;
            }
            long lastDurationNanos = 0L;
            while (true) {
                CoreDatabase db;
                long delayMillis;
                if ((delayMillis = (this.mRateNanos - lastDurationNanos) / 1000000L) > 0L) {
                    Thread.sleep(delayMillis);
                }
                if ((db = (CoreDatabase)this.mDatabaseRef.get()) == null) {
                    this.close(null);
                    return;
                }
                if (this.isSuspended()) {
                    lastDurationNanos = 0L;
                    continue;
                }
                try {
                    long startNanos = System.nanoTime();
                    db.checkpoint(this.mSizeThreshold, this.mDelayThresholdNanos);
                    long endNanos = System.nanoTime();
                    lastDurationNanos = endNanos - startNanos;
                }
                catch (DatabaseException e) {
                    EventListener listener = db.eventListener();
                    if (listener != null) {
                        listener.notify(EventType.CHECKPOINT_FAILED, "Checkpoint failed: %1$s", e);
                    }
                    if (!e.isRecoverable()) {
                        throw e;
                    }
                    lastDurationNanos = 0L;
                }
            }
        }
        catch (Throwable e) {
            CoreDatabase db;
            if (this.mState != 2 && (db = (CoreDatabase)this.mDatabaseRef.get()) != null) {
                Utils.closeQuietly(db, e);
            }
            this.close(e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean register(ShutdownHook obj) {
        block10: {
            if (obj == null) {
                return false;
            }
            if (this.mState != 2) {
                Checkpointer checkpointer = this;
                synchronized (checkpointer) {
                    if (this.mState == 2) {
                        break block10;
                    }
                    if (this.mShutdownHook == null) {
                        Thread hook = new Thread(() -> this.close(null));
                        try {
                            Runtime.getRuntime().addShutdownHook(hook);
                            this.mShutdownHook = hook;
                        }
                        catch (IllegalStateException e) {
                            break block10;
                        }
                    }
                    if (this.mToShutdown == null) {
                        this.mToShutdown = new ArrayList<ShutdownHook>(2);
                    }
                    this.mToShutdown.add(obj);
                    return true;
                }
            }
        }
        obj.shutdown();
        return false;
    }

    void suspend() {
        this.suspend(1);
    }

    void resume() {
        this.suspend(-1);
    }

    boolean isSuspended() {
        return this.mSuspendCount != 0;
    }

    private void suspend(int amt) {
        this.acquireExclusive();
        try {
            int count = this.mSuspendCount + amt;
            if (count < 0) {
                throw new IllegalStateException();
            }
            this.mSuspendCount = count;
        }
        finally {
            this.releaseExclusive();
        }
    }

    void flushDirty(DirtySet[] dirtySets, int dirtyState) throws IOException {
        Runnable task;
        if (this.mExtraExecutor == null) {
            for (DirtySet set : dirtySets) {
                set.flushDirty(dirtyState);
            }
            return;
        }
        Latch countdown = new Latch(dirtySets.length){
            volatile Throwable mException;

            void failed(Throwable ex) {
                if (this.mException == null) {
                    this.mException = ex;
                }
                this.releaseShared();
            }
        };
        for (DirtySet set : dirtySets) {
            this.mExtraExecutor.execute(() -> Checkpointer.lambda$flushDirty$1(set, dirtyState, countdown));
        }
        while ((task = (Runnable)this.mExtraExecutor.getQueue().poll()) != null) {
            task.run();
        }
        countdown.acquireExclusive();
        Throwable ex = countdown.mException;
        if (ex != null) {
            Utils.rethrow(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(Throwable cause) {
        ArrayList<ShutdownHook> toShutdown;
        this.mState = 2;
        this.mDatabaseRef.enqueue();
        this.mDatabaseRef.clear();
        Checkpointer checkpointer = this;
        synchronized (checkpointer) {
            if (this.mShutdownHook != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook(this.mShutdownHook);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.mShutdownHook = null;
            }
            toShutdown = this.mToShutdown == null || cause != null ? null : new ArrayList<ShutdownHook>(this.mToShutdown);
            this.mToShutdown = null;
        }
        if (toShutdown != null) {
            for (ShutdownHook obj : toShutdown) {
                obj.shutdown();
            }
        }
    }

    Thread interrupt() {
        Thread t = this.mThread;
        if (t != null) {
            this.mThread = null;
            t.interrupt();
        }
        return t;
    }

    void shutdown() {
        if (this.mExtraExecutor != null) {
            this.mExtraExecutor.shutdownNow();
        }
    }

    private static /* synthetic */ void lambda$flushDirty$1(DirtySet set, int dirtyState, 1 countdown) {
        try {
            set.flushDirty(dirtyState);
        }
        catch (Throwable e) {
            countdown.failed(e);
            return;
        }
        countdown.releaseShared();
    }

    static interface DirtySet {
        public void flushDirty(int var1) throws IOException;
    }
}

