/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.function.Supplier;
import java.util.zip.Checksum;
import org.cojen.tupl.core.TransformedPageArray;
import org.cojen.tupl.io.DirectAccess;
import org.cojen.tupl.io.PageArray;
import org.cojen.tupl.io.UnsafeAccess;
import org.cojen.tupl.io.Utils;
import sun.misc.Unsafe;

abstract class ChecksumPageArray
extends TransformedPageArray {
    final Supplier<Checksum> mSupplier;

    static ChecksumPageArray open(PageArray source, Supplier<Checksum> supplier) {
        return source.isDirectIO() ? new Direct(source, supplier) : new Standard(source, supplier);
    }

    ChecksumPageArray(PageArray source, Supplier<Checksum> supplier) {
        super(source.pageSize() - 4, source);
        this.mSupplier = supplier;
    }

    @Override
    public boolean isReadOnly() {
        return this.mSource.isReadOnly();
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.mSource.isEmpty();
    }

    @Override
    public long pageCount() throws IOException {
        return this.mSource.pageCount();
    }

    @Override
    public void truncatePageCount(long count) throws IOException {
        this.mSource.truncatePageCount(count);
    }

    @Override
    public void expandPageCount(long count) throws IOException {
        this.mSource.expandPageCount(count);
    }

    @Override
    public void writePage(long index, byte[] src, int offset, ByteBuffer tail) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sync(boolean metadata) throws IOException {
        this.mSource.sync(metadata);
    }

    @Override
    public void syncPage(long index) throws IOException {
        this.mSource.syncPage(index);
    }

    @Override
    public void close(Throwable cause) throws IOException {
        this.mSource.close(cause);
    }

    @Override
    public PageArray open() throws IOException {
        PageArray array = this.mSource.open();
        return array == this.mSource ? this : ChecksumPageArray.open(array, this.mSupplier);
    }

    static void check(long index, int actualChecksum, Checksum checksum) throws IOException {
        if (actualChecksum != (int)checksum.getValue()) {
            throw new IOException("Checksum mismatch: " + Integer.toUnsignedString(actualChecksum, 16) + " != " + Integer.toUnsignedString((int)checksum.getValue(), 16) + "; page=" + index);
        }
    }

    private static class Direct
    extends ChecksumPageArray {
        private static final Unsafe UNSAFE = UnsafeAccess.obtain();
        private final int mAbsPageSize;
        private final ThreadLocal<Checksum> mLocalChecksum;

        Direct(PageArray source, Supplier<Checksum> supplier) {
            super(source, supplier);
            this.mAbsPageSize = Math.abs(source.directPageSize());
            this.mLocalChecksum = new ThreadLocal();
        }

        @Override
        public int directPageSize() {
            return this.mSource.directPageSize();
        }

        @Override
        public void readPage(long index, byte[] dst, int offset, int length) throws IOException {
            if (offset != 0 || length != this.pageSize()) {
                byte[] page = new byte[this.mAbsPageSize];
                this.readPage(index, page);
                System.arraycopy(page, 0, dst, offset, length);
            } else {
                this.mSource.readPage(index, dst, offset, this.mAbsPageSize);
                int actualChecksum = Utils.decodeIntLE(dst, offset + this.mAbsPageSize - 4);
                Checksum checksum = this.checksum();
                checksum.reset();
                checksum.update(dst, offset, length);
                Direct.check(index, actualChecksum, checksum);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void readPage(long index, long dstPtr, int offset, int length) throws IOException {
            if (offset != 0 || length != this.pageSize()) {
                long page = UnsafeAccess.alloc(this.mAbsPageSize, true);
                try {
                    this.readPage(index, page);
                    UnsafeAccess.copy(page, dstPtr + (long)offset, length);
                }
                finally {
                    UnsafeAccess.free(page);
                }
            } else {
                this.mSource.readPage(index, dstPtr, offset, this.mAbsPageSize);
                int actualChecksum = UNSAFE.getInt(dstPtr + (long)offset + (long)this.mAbsPageSize - 4L);
                Checksum checksum = this.checksum();
                checksum.reset();
                checksum.update(DirectAccess.ref(dstPtr + (long)offset, length));
                Direct.check(index, actualChecksum, checksum);
            }
        }

        @Override
        public void writePage(long index, byte[] src, int offset) throws IOException {
            if (offset != 0) {
                byte[] page = new byte[this.mAbsPageSize];
                System.arraycopy(src, offset, page, 0, page.length);
                this.writePage(index, page);
            } else {
                Checksum checksum = this.checksum();
                checksum.reset();
                checksum.update(src, offset, this.mAbsPageSize - 4);
                Utils.encodeIntLE(src, offset + this.mAbsPageSize - 4, (int)checksum.getValue());
                this.mSource.writePage(index, src, offset);
            }
        }

        @Override
        public void writePage(long index, long srcPtr, int offset) throws IOException {
            Checksum checksum = this.checksum();
            checksum.reset();
            checksum.update(DirectAccess.ref(srcPtr + (long)offset, this.mAbsPageSize - 4));
            UNSAFE.putInt(srcPtr + (long)offset + (long)this.mAbsPageSize - 4L, (int)checksum.getValue());
            this.mSource.writePage(index, srcPtr, offset);
        }

        private Checksum checksum() {
            Checksum checksum = this.mLocalChecksum.get();
            if (checksum == null) {
                checksum = (Checksum)this.mSupplier.get();
                this.mLocalChecksum.set(checksum);
            }
            return checksum;
        }
    }

    private static class Standard
    extends ChecksumPageArray {
        private final ThreadLocal<BufRef> mBufRef = new ThreadLocal();

        Standard(PageArray source, Supplier<Checksum> supplier) {
            super(source, supplier);
        }

        @Override
        public void readPage(long index, byte[] dst, int offset, int length) throws IOException {
            int pageSize = this.pageSize();
            if (offset != 0 || length != pageSize) {
                byte[] page = new byte[pageSize];
                this.readPage(index, page);
                System.arraycopy(page, 0, dst, offset, length);
            } else {
                BufRef ref = this.bufRef();
                ByteBuffer tail = ref.mBuffer;
                tail.position(0);
                this.mSource.readPage(index, dst, offset, length, tail);
                int actualChecksum = tail.getInt(0);
                Checksum checksum = ref.mChecksum;
                checksum.reset();
                checksum.update(dst, offset, length);
                Standard.check(index, actualChecksum, checksum);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void readPage(long index, long dstPtr, int offset, int length) throws IOException {
            int pageSize = this.pageSize();
            if (offset != 0 || length != this.pageSize()) {
                long page = UnsafeAccess.alloc(pageSize, false);
                try {
                    this.readPage(index, page);
                    UnsafeAccess.copy(page, dstPtr + (long)offset, length);
                }
                finally {
                    UnsafeAccess.free(page);
                }
            } else {
                BufRef ref = this.bufRef();
                ByteBuffer tail = ref.mBuffer;
                tail.position(0);
                this.mSource.readPage(index, dstPtr, offset, length, tail);
                int actualChecksum = tail.getInt(0);
                Checksum checksum = ref.mChecksum;
                checksum.reset();
                checksum.update(DirectAccess.ref(dstPtr + (long)offset, length));
                Standard.check(index, actualChecksum, checksum);
            }
        }

        @Override
        public void writePage(long index, byte[] src, int offset) throws IOException {
            BufRef ref = this.bufRef();
            Checksum checksum = ref.mChecksum;
            checksum.reset();
            checksum.update(src, offset, this.pageSize());
            ByteBuffer tail = ref.mBuffer;
            tail.position(0);
            tail.putInt(0, (int)checksum.getValue());
            this.mSource.writePage(index, src, offset, tail);
        }

        @Override
        public void writePage(long index, long srcPtr, int offset) throws IOException {
            BufRef ref = this.bufRef();
            Checksum checksum = ref.mChecksum;
            checksum.reset();
            checksum.update(DirectAccess.ref(srcPtr + (long)offset, this.pageSize()));
            ByteBuffer tail = ref.mBuffer;
            tail.position(0);
            tail.putInt(0, (int)checksum.getValue());
            this.mSource.writePage(index, srcPtr, offset, tail);
        }

        private BufRef bufRef() {
            BufRef ref = this.mBufRef.get();
            if (ref == null) {
                ByteBuffer bb = ByteBuffer.allocateDirect(4);
                bb.order(ByteOrder.LITTLE_ENDIAN);
                Checksum checksum = (Checksum)this.mSupplier.get();
                ref = new BufRef(bb, checksum);
                this.mBufRef.set(ref);
            }
            return ref;
        }

        static class BufRef {
            final ByteBuffer mBuffer;
            final Checksum mChecksum;

            BufRef(ByteBuffer buffer, Checksum checksum) {
                this.mBuffer = buffer;
                this.mChecksum = checksum;
            }
        }
    }
}

