/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.util.Latch;
import org.cojen.tupl.util.Parker;

final class CommitLock
implements Lock {
    private final LongAdder mSharedAcquire = new LongAdder();
    private final LongAdder mSharedRelease = new LongAdder();
    private final Latch mFullLatch = new Latch();
    private volatile Thread mExclusiveThread;
    private static final VarHandle cExclusiveThreadHandle;
    private final ThreadLocal<Shared> mShared = ThreadLocal.withInitial(() -> new Shared(this));

    CommitLock() {
    }

    @Override
    public final boolean tryLock() {
        return this.tryAcquireShared() != null;
    }

    public final Shared tryAcquireShared() {
        this.mSharedAcquire.increment();
        Shared shared = this.mShared.get();
        if (cExclusiveThreadHandle.getAcquire(this) != null && shared.count == 0) {
            this.doReleaseShared();
            return null;
        }
        ++shared.count;
        return shared;
    }

    @Override
    public final void lock() {
        this.acquireShared();
    }

    public final Shared acquireShared() {
        Shared shared = this.mShared.get();
        this.acquireShared(shared);
        return shared;
    }

    public final void acquireShared(Shared shared) {
        this.mSharedAcquire.increment();
        if (cExclusiveThreadHandle.getAcquire(this) != null && shared.count == 0) {
            this.doReleaseShared();
            this.mFullLatch.acquireShared();
            try {
                this.mSharedAcquire.increment();
            }
            finally {
                this.mFullLatch.releaseShared();
            }
        }
        ++shared.count;
    }

    public final Shared acquireSharedUnchecked() {
        this.mSharedAcquire.increment();
        Shared shared = this.mShared.get();
        ++shared.count;
        return shared;
    }

    @Override
    public final void lockInterruptibly() throws InterruptedException {
        this.acquireSharedInterruptibly();
    }

    public final Shared acquireSharedInterruptibly() throws InterruptedException {
        return this.tryAcquireShared(-1L, null);
    }

    @Override
    public final boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        return this.tryAcquireShared(time, unit) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Shared tryAcquireShared(long time, TimeUnit unit) throws InterruptedException {
        this.mSharedAcquire.increment();
        Shared shared = this.mShared.get();
        if (cExclusiveThreadHandle.getAcquire(this) != null && shared.count == 0) {
            this.doReleaseShared();
            if (time < 0L) {
                this.mFullLatch.acquireSharedInterruptibly();
            } else if (time == 0L || !this.mFullLatch.tryAcquireSharedNanos(unit.toNanos(time))) {
                return null;
            }
            try {
                this.mSharedAcquire.increment();
            }
            finally {
                this.mFullLatch.releaseShared();
            }
        }
        ++shared.count;
        return shared;
    }

    @Override
    public final void unlock() {
        this.releaseShared();
    }

    public final void releaseShared() {
        this.doReleaseShared();
        --this.mShared.get().count;
    }

    private void doReleaseShared() {
        this.mSharedRelease.increment();
        Thread t = cExclusiveThreadHandle.getAcquire(this);
        if (t != null && !this.hasSharedLockers()) {
            Parker.unpark(t);
        }
    }

    @Override
    public final Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    public final void acquireExclusive() {
        long nanosTimeout = 1000L;
        while (!this.finishAcquireExclusive(nanosTimeout)) {
            nanosTimeout <<= 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private boolean finishAcquireExclusive(long nanosTimeout) {
        this.mFullLatch.acquireExclusive();
        cExclusiveThreadHandle.setRelease(this, Thread.currentThread());
        try {
            Shared shared;
            block8: {
                shared = this.mShared.get();
                shared.addCountTo(this.mSharedRelease);
                try {
                    long nanosEnd;
                    if (!this.hasSharedLockers()) break block8;
                    long l = nanosEnd = nanosTimeout <= 0L ? 0L : System.nanoTime() + nanosTimeout;
                    do {
                        if (nanosTimeout < 0L) {
                            Parker.park(this);
                        } else {
                            Parker.parkNanos(this, nanosTimeout);
                        }
                        Thread.interrupted();
                        if (this.hasSharedLockers()) continue;
                        break block8;
                    } while (nanosTimeout < 0L || nanosTimeout != 0L && (nanosTimeout = nanosEnd - System.nanoTime()) > 0L);
                    cExclusiveThreadHandle.setRelease(this, null);
                    this.mFullLatch.releaseExclusive();
                    boolean bl = false;
                    return bl;
                }
                finally {
                    shared.addCountTo(this.mSharedAcquire);
                }
            }
            ++shared.count;
            return true;
        }
        catch (Throwable e) {
            cExclusiveThreadHandle.setRelease(this, null);
            this.mFullLatch.releaseExclusive();
            throw e;
        }
    }

    public final void releaseExclusive() {
        cExclusiveThreadHandle.setRelease(this, null);
        this.mFullLatch.releaseExclusive();
        --this.mShared.get().count;
    }

    public final boolean hasQueuedThreads() {
        return this.mFullLatch.hasQueuedThreads();
    }

    private boolean hasSharedLockers() {
        return this.mSharedRelease.sum() != this.mSharedAcquire.sum();
    }

    static {
        try {
            cExclusiveThreadHandle = MethodHandles.lookup().findVarHandle(CommitLock.class, "mExclusiveThread", Thread.class);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    public static final class Shared
    extends WeakReference<CommitLock> {
        int count;

        Shared(CommitLock lock) {
            super(lock);
        }

        public void release() {
            CommitLock lock = (CommitLock)this.get();
            if (lock != null) {
                lock.doReleaseShared();
            }
            --this.count;
        }

        private void addCountTo(LongAdder adder) {
            if (this.count > 0) {
                adder.add(this.count);
            }
        }
    }
}

