/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.Supplier;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.Index;
import org.cojen.tupl.Snapshot;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.core.CoreDatabase;
import org.cojen.tupl.core.Launcher;
import org.cojen.tupl.core.ReadableSnapshot;
import org.cojen.tupl.core.StoredPageDb;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.io.PageArray;
import org.cojen.tupl.io.PageCompressor;
import org.cojen.tupl.io.UnsafeAccess;
import org.cojen.tupl.util.LocalPool;

final class CompressedPageArray
extends PageArray
implements Supplier<PageCompressor> {
    private final CoreDatabase mDatabase;
    private final Index mPages;
    private final Supplier<PageCompressor> mCompressorFactory;
    private final LocalPool<PageCompressor> mCompressors;

    CompressedPageArray(int fullPageSize, CoreDatabase db, Index pages, Supplier<PageCompressor> factory) {
        super(fullPageSize);
        this.mDatabase = db;
        this.mPages = pages;
        this.mCompressorFactory = factory;
        this.mCompressors = new LocalPool<PageCompressor>(this);
    }

    @Override
    public PageCompressor get() {
        if (this.mDatabase.isClosed()) {
            throw new IllegalStateException();
        }
        return this.mCompressorFactory.get();
    }

    public boolean isCacheOnly() {
        return this.mDatabase.isCacheOnly();
    }

    @Override
    public boolean isReadOnly() {
        return this.mDatabase.isReadOnly();
    }

    @Override
    public boolean isEmpty() throws IOException {
        Cursor c = this.mPages.newCursor(Transaction.BOGUS);
        c.first();
        boolean isEmpty = c.key() == null;
        c.reset();
        return isEmpty;
    }

    @Override
    public long pageCount() throws IOException {
        Cursor c = this.mPages.newCursor(Transaction.BOGUS);
        c.last();
        byte[] key = c.key();
        c.reset();
        return key == null ? 0L : CompressedPageArray.indexFor(key) + 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncatePageCount(long count) throws IOException {
        Cursor c = this.mPages.newCursor(null);
        try {
            c.autoload(false);
            c.findGe(CompressedPageArray.keyFor(count));
            while (c.key() != null) {
                c.store(null);
                c.next();
            }
        }
        finally {
            c.reset();
        }
    }

    @Override
    public void expandPageCount(long count) throws IOException {
    }

    @Override
    public void readPage(long index, byte[] dst) throws IOException {
        this.readPage(index, dst, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPage(long index, byte[] dst, int offset) throws IOException {
        byte[] value = this.mPages.load(Transaction.BOGUS, CompressedPageArray.keyFor(index));
        if (value == null) {
            Arrays.fill(dst, offset, offset + this.pageSize(), (byte)0);
        } else {
            LocalPool.Entry<PageCompressor> entry = this.mCompressors.access();
            try {
                entry.get().decompress(value, 0, value.length, dst, offset, this.pageSize());
            }
            finally {
                entry.release();
            }
        }
    }

    @Override
    public void readPage(long index, byte[] dst, int offset, int length) throws IOException {
        int pageSize = this.pageSize();
        if (length == pageSize) {
            this.readPage(index, dst, offset);
        } else {
            byte[] page = new byte[pageSize];
            this.readPage(index, page, 0);
            System.arraycopy(page, 0, dst, offset, length);
        }
    }

    @Override
    public void readPage(long index, long dstPtr) throws IOException {
        this.readPage(index, dstPtr, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPage(long index, long dstPtr, int offset) throws IOException {
        byte[] value = this.mPages.load(Transaction.BOGUS, CompressedPageArray.keyFor(index));
        if (value == null) {
            UnsafeAccess.fill(dstPtr + (long)offset, this.pageSize(), (byte)0);
        } else {
            LocalPool.Entry<PageCompressor> entry = this.mCompressors.access();
            try {
                entry.get().decompress(value, 0, value.length, dstPtr, offset, this.pageSize());
            }
            finally {
                entry.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readPage(long index, long dstPtr, int offset, int length) throws IOException {
        int pageSize = this.pageSize();
        if (length == pageSize) {
            this.readPage(index, dstPtr, offset);
        } else {
            long page = UnsafeAccess.alloc(pageSize);
            try {
                this.readPage(index, page, 0);
                UnsafeAccess.copy(page, dstPtr + (long)offset, length);
            }
            finally {
                UnsafeAccess.free(page);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePage(long index, byte[] src, int offset) throws IOException {
        try (Cursor c = this.mPages.newAccessor(Transaction.BOGUS, CompressedPageArray.keyFor(index));){
            LocalPool.Entry<PageCompressor> entry = this.mCompressors.access();
            try {
                PageCompressor compressor = entry.get();
                int len = compressor.compress(src, offset, this.pageSize());
                c.valueWrite(0L, compressor.compressedBytes(), 0, len);
            }
            finally {
                entry.release();
            }
        }
    }

    @Override
    public void writePage(long index, byte[] src, int offset, ByteBuffer tail) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePage(long index, long srcPtr, int offset) throws IOException {
        try (Cursor c = this.mPages.newAccessor(Transaction.BOGUS, CompressedPageArray.keyFor(index));){
            LocalPool.Entry<PageCompressor> entry = this.mCompressors.access();
            try {
                PageCompressor compressor = entry.get();
                int len = compressor.compress(srcPtr, offset, this.pageSize());
                c.valueWrite(0L, compressor.compressedBytes(), 0, len);
            }
            finally {
                entry.release();
            }
        }
    }

    @Override
    public void sync(boolean metadata) throws IOException {
    }

    @Override
    public void syncPage(long index) throws IOException {
        this.mDatabase.checkpoint();
    }

    @Override
    public void close(Throwable cause) throws IOException {
        this.mDatabase.close(cause);
        this.mCompressors.clear(PageCompressor::close);
    }

    Snapshot beginSnapshot() throws IOException {
        long redoPos;
        final Snapshot snap = this.mDatabase.beginSnapshot();
        PageArray snapArray = ((ReadableSnapshot)snap).asPageArray();
        Launcher launcher = new Launcher();
        launcher.mBasicMode = true;
        launcher.dataPageArray(snapArray);
        launcher.minCacheSize(0L);
        launcher.maxCacheSize(100L * (long)snapArray.pageSize());
        launcher.readOnly(true);
        launcher.directPageAccess(this.mDatabase.isDirectPageAccess());
        launcher.encrypt(this.mDatabase.dataCrypto());
        launcher.checksumPages(this.mDatabase.checksumFactory());
        try (CoreDatabase snapDb = launcher.open(false, null);){
            snapArray = new CompressedPageArray(this.pageSize(), snapDb, snapDb.registry(), this.mCompressorFactory);
            StoredPageDb snapPageDb = StoredPageDb.open(null, snapArray, null, null, false);
            redoPos = snapPageDb.snapshotRedoPos();
        }
        return new Snapshot(){

            @Override
            public long length() {
                return snap.length();
            }

            @Override
            public long position() {
                return redoPos;
            }

            @Override
            public boolean isCompressible() {
                return false;
            }

            @Override
            public void writeTo(OutputStream out) throws IOException {
                snap.writeTo(out);
            }

            @Override
            public void close() throws IOException {
                snap.close();
            }
        };
    }

    private static byte[] keyFor(long index) {
        byte[] key = new byte[6];
        Utils.encodeInt48BE(key, 0, index);
        return key;
    }

    private static long indexFor(byte[] key) {
        return Utils.decodeUnsignedInt48BE(key, 0);
    }
}

