/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.util.Arrays;
import java.util.Objects;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.diag.DeadlockInfo;

public final class CoreDeadlockInfo
implements DeadlockInfo {
    private static final long serialVersionUID = 1L;
    Object mRow;
    long mIndexId;
    byte[] mIndexName;
    byte[] mKey;
    Object mAttachment;

    CoreDeadlockInfo() {
    }

    public CoreDeadlockInfo(Object row, long indexId, byte[] indexName, byte[] key, Object att) {
        this.mRow = row;
        this.mIndexId = indexId;
        this.mIndexName = indexName;
        this.mKey = key;
        this.mAttachment = att;
    }

    @Override
    public Object row() {
        return this.mRow;
    }

    @Override
    public long indexId() {
        return this.mIndexId;
    }

    @Override
    public byte[] indexName() {
        return this.mIndexName;
    }

    @Override
    public byte[] key() {
        return this.mKey;
    }

    @Override
    public Object ownerAttachment() {
        return this.mAttachment;
    }

    public int hashCode() {
        int hash = (int)this.mIndexId;
        hash = hash * 31 + Arrays.hashCode(this.mKey);
        hash = hash * 31 + Objects.hashCode(this.mAttachment);
        return hash;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof CoreDeadlockInfo)) return false;
        CoreDeadlockInfo other = (CoreDeadlockInfo)obj;
        if (this.mIndexId != other.mIndexId) return false;
        if (!Arrays.equals(this.mIndexName, other.mIndexName)) return false;
        if (!Arrays.equals(this.mKey, other.mKey)) return false;
        if (!Objects.equals(this.mAttachment, other.mAttachment)) return false;
        return true;
    }

    public String toString() {
        StringBuilder b = new StringBuilder().append('{');
        if (this.mRow != null) {
            b.append("row").append(": ").append(this.mRow).append(", ");
        }
        b.append("indexId").append(": ").append(this.mIndexId).append(", ");
        String name = Utils.utf8(this.mIndexName);
        if (name != null) {
            b.append("indexName").append(": ").append(name);
            b.append(", ");
        }
        b.append("key").append(": ").append(Utils.toHex(this.mKey));
        Object att = this.mAttachment;
        if (att != null) {
            b.append(", ");
            b.append("attachment").append(": ").append(att);
        }
        return b.append('}').toString();
    }
}

