/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.cojen.dirmi.ClassResolver;
import org.cojen.dirmi.Environment;
import org.cojen.tupl.Database;
import org.cojen.tupl.Server;
import org.cojen.tupl.core.CoreDatabase;
import org.cojen.tupl.core.Servers;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.remote.RemoteUtils;
import org.cojen.tupl.remote.ServerDatabase;

final class CoreServer
implements Server {
    private final Environment mEnv;
    private final Servers mServers;

    CoreServer(CoreDatabase db, Servers servers) throws IOException {
        this.mEnv = CoreServer.export(db);
        this.mServers = servers;
        servers.add(this);
    }

    private static Environment export(CoreDatabase db) throws IOException {
        ServerDatabase server = ServerDatabase.from(db);
        Environment env = RemoteUtils.createEnvironment();
        env.export((Object)Database.class.getName(), (Object)server);
        return env;
    }

    @Override
    public void acceptAll(ServerSocket ss, long ... tokens) throws IOException {
        if (tokens.length < 1 || tokens.length > 2) {
            throw new IllegalArgumentException("Must provide one or two tokens");
        }
        this.mEnv.acceptAll(ss, s -> {
            try {
                return RemoteUtils.testConnection(s.getInputStream(), s.getOutputStream(), tokens);
            }
            catch (IOException e) {
                throw Utils.rethrow(e);
            }
        });
    }

    @Override
    public void classResolver(ClassResolver resolver) {
        this.mEnv.classResolver(resolver);
    }

    void acceptedAndValidated(Socket s) throws IOException {
        this.mEnv.accepted(s);
    }

    @Override
    public void close() {
        this.mServers.remove(this);
        this.mEnv.close();
    }
}

