/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.cojen.tupl.NoSuchValueException;
import org.cojen.tupl.ValueAccessor;

public abstract class CoreValueAccessor
implements ValueAccessor {
    @Override
    public final int valueRead(long pos, byte[] buf, int off, int len) throws IOException {
        if (pos < 0L) {
            throw new IllegalArgumentException();
        }
        CoreValueAccessor.boundsCheck(buf, off, len);
        return this.doValueRead(pos, buf, off, len);
    }

    @Override
    public final void valueWrite(long pos, byte[] buf, int off, int len) throws IOException {
        if (pos < 0L) {
            throw new IllegalArgumentException();
        }
        CoreValueAccessor.boundsCheck(buf, off, len);
        this.doValueWrite(pos, buf, off, len);
    }

    @Override
    public final void valueClear(long pos, long length) throws IOException {
        if (pos < 0L || length < 0L) {
            throw new IllegalArgumentException();
        }
        this.doValueClear(pos, length);
    }

    @Override
    public final InputStream newValueInputStream(long pos) throws IOException {
        return this.newValueInputStream(pos, -1);
    }

    @Override
    public final InputStream newValueInputStream(long pos, int bufferSize) throws IOException {
        if (pos < 0L) {
            throw new IllegalArgumentException();
        }
        this.valueCheckOpen();
        return new In(pos, new byte[this.valueStreamBufferSize(bufferSize)]);
    }

    @Override
    public final OutputStream newValueOutputStream(long pos) throws IOException {
        return this.newValueOutputStream(pos, -1);
    }

    @Override
    public final OutputStream newValueOutputStream(long pos, int bufferSize) throws IOException {
        if (pos < 0L) {
            throw new IllegalArgumentException();
        }
        this.valueCheckOpen();
        return new Out(pos, new byte[this.valueStreamBufferSize(bufferSize)]);
    }

    protected abstract int doValueRead(long var1, byte[] var3, int var4, int var5) throws IOException;

    protected abstract void doValueWrite(long var1, byte[] var3, int var4, int var5) throws IOException;

    protected abstract void doValueClear(long var1, long var3) throws IOException;

    protected abstract int valueStreamBufferSize(int var1);

    protected abstract void valueCheckOpen();

    static void boundsCheck(byte[] buf, int off, int len) {
        if ((off | len | off + len | buf.length - (off + len)) < 0) {
            throw CoreValueAccessor.failBoundsCheck(buf, off, len);
        }
    }

    private static IndexOutOfBoundsException failBoundsCheck(byte[] buf, int off, int len) {
        String msg = null;
        if (off < 0) {
            msg = "Negative offset given: " + off;
        } else if (len < 0) {
            msg = "Negative length given: " + len;
        } else {
            long end = (long)off + (long)len;
            if (end > (long)buf.length) {
                msg = "End offset is too large: " + end + ", buf.length=" + buf.length + ", off=" + off + ", len=" + len;
            }
        }
        return new IndexOutOfBoundsException(msg);
    }

    final class In
    extends InputStream {
        private long mPos;
        private byte[] mBuffer;
        private int mStart;
        private int mEnd;

        In(long pos, byte[] buffer) {
            this.mPos = pos;
            this.mBuffer = buffer;
        }

        @Override
        public int read() throws IOException {
            byte[] buf = this.checkStreamOpen();
            int start = this.mStart;
            if (start < this.mEnd) {
                ++this.mPos;
                int b = buf[start] & 0xFF;
                this.mStart = start + 1;
                return b;
            }
            long pos = this.mPos;
            int amt = CoreValueAccessor.this.doValueRead(pos, buf, 0, buf.length);
            if (amt <= 0) {
                if (amt < 0) {
                    throw new NoSuchValueException();
                }
                return -1;
            }
            this.mEnd = amt;
            this.mPos = pos + 1L;
            this.mStart = 1;
            return buf[0] & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int initialOff;
            int amt;
            block7: {
                CoreValueAccessor.boundsCheck(b, off, len);
                byte[] buf = this.checkStreamOpen();
                int start = this.mStart;
                amt = this.mEnd - start;
                if (amt >= len) {
                    System.arraycopy(buf, start, b, off, len);
                    this.mStart = start + len;
                    this.mPos += (long)len;
                    return len;
                }
                initialOff = off;
                if (amt > 0) {
                    System.arraycopy(buf, start, b, off, amt);
                    this.mEnd = start;
                    off += amt;
                    len -= amt;
                    this.mPos += (long)amt;
                }
                while (len >= buf.length) {
                    amt = CoreValueAccessor.this.doValueRead(this.mPos, b, off, len);
                    if (amt <= 0) break block7;
                    off += amt;
                    this.mPos += (long)amt;
                    if ((len -= amt) > 0) continue;
                    break block7;
                }
                while ((amt = CoreValueAccessor.this.doValueRead(this.mPos, buf, 0, buf.length)) > 0) {
                    if (amt >= len) {
                        System.arraycopy(buf, 0, b, off, len);
                        off += len;
                        this.mPos += (long)len;
                        this.mStart = len;
                        this.mEnd = amt;
                        break;
                    }
                    System.arraycopy(buf, 0, b, off, amt);
                    off += amt;
                    len -= amt;
                    this.mPos += (long)amt;
                }
            }
            int actual = off - initialOff;
            if (actual <= 0) {
                if (amt < 0) {
                    throw new NoSuchValueException();
                }
                return -1;
            }
            return actual;
        }

        @Override
        public long skip(long n) throws IOException {
            this.checkStreamOpen();
            if (n <= 0L) {
                return 0L;
            }
            int start = this.mStart;
            int amt = this.mEnd - start;
            if (amt > 0) {
                if (n >= (long)amt) {
                    this.mEnd = start;
                } else {
                    amt = (int)n;
                    this.mStart = start + amt;
                }
                this.mPos += (long)amt;
                return amt;
            }
            long pos = this.mPos;
            long newPos = Math.min(pos + n, CoreValueAccessor.this.valueLength());
            if (newPos > pos) {
                this.mPos = newPos;
                return newPos - pos;
            }
            return 0L;
        }

        @Override
        public int available() {
            return this.mBuffer == null ? 0 : this.mEnd - this.mStart;
        }

        @Override
        public void close() throws IOException {
            this.mBuffer = null;
            CoreValueAccessor.this.close();
        }

        private byte[] checkStreamOpen() {
            byte[] buf = this.mBuffer;
            if (buf == null) {
                throw new IllegalStateException("Stream closed");
            }
            return buf;
        }
    }

    final class Out
    extends OutputStream {
        private long mPos;
        private byte[] mBuffer;
        private int mEnd;

        Out(long pos, byte[] buffer) {
            this.mPos = pos;
            this.mBuffer = buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            int end = this.mEnd;
            byte[] buf = this.checkStreamOpen();
            if (end >= buf.length) {
                this.flush();
                end = 0;
            }
            buf[end++] = (byte)b;
            try {
                if (end >= buf.length) {
                    CoreValueAccessor.this.doValueWrite(this.mPos, buf, 0, end);
                    this.mPos += (long)end;
                    end = 0;
                }
            }
            finally {
                this.mEnd = end;
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            CoreValueAccessor.boundsCheck(b, off, len);
            byte[] buf = this.checkStreamOpen();
            int end = this.mEnd;
            int avail = buf.length - end;
            if (len < avail) {
                System.arraycopy(b, off, buf, end, len);
                this.mEnd = end + len;
                return;
            }
            if (end != 0) {
                System.arraycopy(b, off, buf, end, avail);
                off += avail;
                len -= avail;
                avail = buf.length;
                try {
                    CoreValueAccessor.this.doValueWrite(this.mPos, buf, 0, avail);
                }
                catch (Throwable e) {
                    this.mEnd = avail;
                    throw e;
                }
                this.mPos += (long)avail;
                if (len < avail) {
                    System.arraycopy(b, off, buf, 0, len);
                    this.mEnd = len;
                    return;
                }
                this.mEnd = 0;
            }
            CoreValueAccessor.this.doValueWrite(this.mPos, b, off, len);
            this.mPos += (long)len;
        }

        @Override
        public void flush() throws IOException {
            this.doFlush(this.checkStreamOpen());
        }

        @Override
        public void close() throws IOException {
            byte[] buf = this.mBuffer;
            if (buf != null) {
                this.doFlush(buf);
                this.mBuffer = null;
            }
            CoreValueAccessor.this.close();
        }

        private void doFlush(byte[] buf) throws IOException {
            int end = this.mEnd;
            if (end > 0) {
                CoreValueAccessor.this.doValueWrite(this.mPos, buf, 0, end);
                this.mPos += (long)end;
                this.mEnd = 0;
            }
        }

        private byte[] checkStreamOpen() {
            byte[] buf = this.mBuffer;
            if (buf == null) {
                throw new IllegalStateException("Stream closed");
            }
            return buf;
        }
    }
}

