/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.core.DirectPageOps;
import org.cojen.tupl.core.TransformedPageArray;
import org.cojen.tupl.ext.Crypto;
import org.cojen.tupl.io.PageArray;
import org.cojen.tupl.io.Utils;

final class CryptoPageArray
extends TransformedPageArray {
    private final Crypto mCrypto;

    CryptoPageArray(PageArray source, Crypto crypto) {
        super(source);
        this.mCrypto = crypto;
    }

    @Override
    public int directPageSize() {
        return this.mSource.directPageSize();
    }

    @Override
    public boolean isFullyMapped() {
        return this.mSource.isFullyMapped();
    }

    @Override
    public boolean isReadOnly() {
        return this.mSource.isReadOnly();
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.mSource.isEmpty();
    }

    @Override
    public long pageCount() throws IOException {
        return this.mSource.pageCount();
    }

    @Override
    public void truncatePageCount(long count) throws IOException {
        this.mSource.truncatePageCount(count);
    }

    @Override
    public void expandPageCount(long count) throws IOException {
        this.mSource.expandPageCount(count);
    }

    @Override
    public long pageCountLimit() throws IOException {
        return this.mSource.pageCountLimit();
    }

    @Override
    public void readPage(long index, byte[] dst) throws IOException {
        try {
            this.mSource.readPage(index, dst);
            this.mCrypto.decryptPage(index, this.pageSize(), dst, 0);
        }
        catch (GeneralSecurityException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void readPage(long index, byte[] dst, int offset, int length) throws IOException {
        int pageSize = this.pageSize();
        if (offset == 0 && length == pageSize) {
            this.readPage(index, dst);
            return;
        }
        byte[] page = new byte[pageSize];
        this.readPage(index, page);
        System.arraycopy(page, 0, dst, offset, length);
    }

    @Override
    public void readPage(long index, long dstPtr) throws IOException {
        try {
            this.mSource.readPage(index, dstPtr);
            this.mCrypto.decryptPage(index, this.pageSize(), dstPtr, 0);
        }
        catch (GeneralSecurityException e) {
            throw new DatabaseException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readPage(long index, long dstPtr, int offset, int length) throws IOException {
        int pageSize = this.pageSize();
        if (offset == 0 && length == pageSize) {
            this.readPage(index, dstPtr);
            return;
        }
        long page = DirectPageOps.p_allocPage(this.mSource.directPageSize());
        try {
            this.readPage(index, page);
            DirectPageOps.p_copy(page, 0, dstPtr, offset, length);
        }
        finally {
            DirectPageOps.p_delete(page);
        }
    }

    @Override
    public void writePage(long index, byte[] src, int offset) throws IOException {
        try {
            int pageSize = this.pageSize();
            byte[] encrypted = new byte[pageSize];
            this.mCrypto.encryptPage(index, pageSize, src, offset, encrypted, 0);
            this.mSource.writePage(index, encrypted, 0);
        }
        catch (GeneralSecurityException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void writePage(long index, byte[] src, int offset, ByteBuffer tail) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePage(long index, long srcPtr, int offset) throws IOException {
        try {
            int pageSize = this.pageSize();
            long encrypted = DirectPageOps.p_allocPage(this.mSource.directPageSize());
            try {
                this.mCrypto.encryptPage(index, pageSize, srcPtr, offset, encrypted, 0);
                this.mSource.writePage(index, encrypted, 0);
            }
            finally {
                DirectPageOps.p_delete(encrypted);
            }
        }
        catch (GeneralSecurityException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public byte[] evictPage(long index, byte[] buf) throws IOException {
        try {
            this.mCrypto.encryptPage(index, this.pageSize(), buf, 0);
        }
        catch (GeneralSecurityException e) {
            throw new DatabaseException(e);
        }
        try {
            return this.mSource.evictPage(index, buf);
        }
        catch (Throwable e) {
            try {
                this.mCrypto.decryptPage(index, this.pageSize(), buf, 0);
            }
            catch (Throwable e2) {
                Utils.closeQuietly(this.mSource, e2);
            }
            throw e;
        }
    }

    @Override
    public long evictPage(long index, long bufPtr) throws IOException {
        try {
            this.mCrypto.encryptPage(index, this.pageSize(), bufPtr, 0);
        }
        catch (GeneralSecurityException e) {
            throw new DatabaseException(e);
        }
        try {
            return this.mSource.evictPage(index, bufPtr);
        }
        catch (Throwable e) {
            try {
                this.mCrypto.decryptPage(index, this.pageSize(), bufPtr, 0);
            }
            catch (Throwable e2) {
                Utils.closeQuietly(this.mSource, e2);
            }
            throw e;
        }
    }

    @Override
    public void sync(boolean metadata) throws IOException {
        this.mSource.sync(metadata);
    }

    @Override
    public void syncPage(long index) throws IOException {
        this.mSource.syncPage(index);
    }

    @Override
    public void close(Throwable cause) throws IOException {
        this.mSource.close(cause);
    }
}

