/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.cojen.tupl.core.Node;
import org.cojen.tupl.core.Utils;

class CursorFrame {
    static final int SPIN_LIMIT = Runtime.getRuntime().availableProcessors() > 1 ? 1024 : 0;
    private static final CursorFrame REBIND_FRAME = new CursorFrame();
    static final VarHandle cNextCousinHandle;
    static final VarHandle cLastHandle;
    volatile CursorFrame mPrevCousin;
    volatile CursorFrame mNextCousin;
    Node mNode;
    int mNodePos;
    CursorFrame mParentFrame;
    byte[] mNotFoundKey;

    CursorFrame() {
    }

    CursorFrame(CursorFrame parentFrame) {
        this.mParentFrame = parentFrame;
    }

    final Node acquireShared() {
        Node node = this.mNode;
        while (true) {
            node.acquireShared();
            Node actualNode = this.mNode;
            if (actualNode == node) {
                return actualNode;
            }
            node.releaseShared();
            node = actualNode;
        }
    }

    final Node tryAcquireShared() {
        Node node = this.mNode;
        while (node.tryAcquireShared()) {
            Node actualNode = this.mNode;
            if (actualNode == node) {
                return actualNode;
            }
            node.releaseShared();
            node = actualNode;
        }
        return null;
    }

    final Node acquireExclusive() {
        Node node = this.mNode;
        while (true) {
            node.acquireExclusive();
            Node actualNode = this.mNode;
            if (actualNode == node) {
                return actualNode;
            }
            node.releaseExclusive();
            node = actualNode;
        }
    }

    final Node acquireExclusiveIfBound() {
        Node node = this.mNode;
        while (node != null) {
            node.acquireExclusive();
            Node actualNode = this.mNode;
            if (actualNode == node) {
                return actualNode;
            }
            node.releaseExclusive();
            node = actualNode;
        }
        return null;
    }

    final Node tryAcquireExclusive() {
        Node node = this.mNode;
        while (node.tryAcquireExclusive()) {
            Node actualNode = this.mNode;
            if (actualNode == node) {
                return actualNode;
            }
            node.releaseExclusive();
            node = actualNode;
        }
        return null;
    }

    final void adjustParentPosition(int amount) {
        CursorFrame parent = this.mParentFrame;
        if (parent != null) {
            parent.mNodePos += amount;
        }
    }

    final void bind(Node node, int nodePos) {
        this.mNode = node;
        this.mNodePos = nodePos;
        this.mNextCousin = this;
        int trials = SPIN_LIMIT;
        while (true) {
            CursorFrame last;
            this.mPrevCousin = last = node.mLastCursorFrame;
            if (last == null) {
                if (cLastHandle.compareAndSet(node, null, this)) {
                    return;
                }
            } else if (last.mNextCousin == last && cNextCousinHandle.compareAndSet(last, last, this)) {
                while (node.mLastCursorFrame != last) {
                    Thread.onSpinWait();
                }
                node.mLastCursorFrame = this;
                return;
            }
            if (--trials < 0) {
                Thread.yield();
                trials = SPIN_LIMIT << 1;
                continue;
            }
            Thread.onSpinWait();
        }
    }

    final void bindOrReposition(Node node, int nodePos) {
        if (this.mNode == null) {
            this.bind(node, nodePos);
        } else if (this.mNode == node) {
            this.mNodePos = nodePos;
        } else {
            throw new IllegalStateException();
        }
    }

    final void rebind(Node node, int nodePos) {
        if (this.unbind(REBIND_FRAME)) {
            this.bind(node, nodePos);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean unbind(CursorFrame to) {
        int trials = SPIN_LIMIT;
        CursorFrame n;
        while ((n = this.mNextCousin) != null) {
            if (n == this) {
                Node node = this.mNode;
                if (node != null && node.mLastCursorFrame == this && cNextCousinHandle.compareAndSet(this, n, to)) {
                    if (node != this.mNode || node.mLastCursorFrame != this) {
                        this.mNextCousin = n;
                    } else {
                        CursorFrame p;
                        while (!((p = this.mPrevCousin) == null || p.mNextCousin == this && cNextCousinHandle.compareAndSet(p, this, p))) {
                        }
                        node.mLastCursorFrame = p;
                        return true;
                    }
                }
            } else if (n.mPrevCousin == this && cNextCousinHandle.compareAndSet(this, n, to)) {
                CursorFrame p;
                while (!((p = this.mPrevCousin) == null || p.mNextCousin == this && cNextCousinHandle.compareAndSet(p, this, n))) {
                }
                n.mPrevCousin = p;
                return true;
            }
            if (--trials < 0) {
                Thread.yield();
                trials = SPIN_LIMIT << 1;
                continue;
            }
            Thread.onSpinWait();
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final CursorFrame tryLock(CursorFrame lock) {
        int trials = SPIN_LIMIT;
        CursorFrame n;
        while ((n = this.mNextCousin) != null) {
            if (n == this) {
                Node node = this.mNode;
                if (node != null && node.mLastCursorFrame == this && cNextCousinHandle.compareAndSet(this, n, lock)) {
                    if (node == this.mNode && node.mLastCursorFrame == this) return n;
                    this.mNextCousin = n;
                }
            } else if (n.mPrevCousin == this && cNextCousinHandle.compareAndSet(this, n, lock)) {
                return n;
            }
            if (--trials < 0) {
                Thread.yield();
                trials = SPIN_LIMIT << 1;
                continue;
            }
            Thread.onSpinWait();
        }
        return null;
    }

    final CursorFrame tryLockPrevious(CursorFrame lock) {
        CursorFrame p;
        while (!((p = this.mPrevCousin) == null || p.mNextCousin == this && cNextCousinHandle.compareAndSet(p, this, lock))) {
        }
        return p;
    }

    final void unlock(CursorFrame n) {
        this.mNextCousin = n;
    }

    final CursorFrame pop() {
        this.unbind(null);
        CursorFrame parent = this.mParentFrame;
        this.mNode = null;
        this.mParentFrame = null;
        this.mNotFoundKey = null;
        return parent;
    }

    static void popAll(CursorFrame frame) {
        while ((frame = frame.mNode == null ? frame.mParentFrame : frame.pop()) != null) {
        }
    }

    final void popChildren(CursorFrame child) {
        while ((child = child.pop()) != this) {
        }
    }

    final void copyInto(CursorFrame dest) {
        Node node = this.acquireShared();
        CursorFrame parent = this.mParentFrame;
        if (parent != null) {
            node.releaseShared();
            CursorFrame parentCopy = new CursorFrame();
            while (true) {
                if (parent != null) {
                    parent.copyInto(parentCopy);
                }
                node = this.acquireShared();
                CursorFrame actualParent = this.mParentFrame;
                if (actualParent == parent) {
                    if (parent == null) break;
                    dest.mParentFrame = parentCopy;
                    break;
                }
                node.releaseShared();
                CursorFrame.popAll(parentCopy);
                parent = actualParent;
            }
        }
        dest.mNotFoundKey = this.mNotFoundKey;
        dest.bind(node, this.mNodePos);
        node.releaseShared();
    }

    public final String toString() {
        return Utils.toMiniString(this);
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            cNextCousinHandle = lookup.findVarHandle(CursorFrame.class, "mNextCousin", CursorFrame.class);
            cLastHandle = lookup.findVarHandle(Node.class, "mLastCursorFrame", CursorFrame.class);
        }
        catch (Throwable e) {
            throw org.cojen.tupl.io.Utils.rethrow(e);
        }
    }
}

