/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.cojen.tupl.core.RedoVisitor;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.util.WeakPool;

abstract class DataIn
extends InputStream {
    private final byte[] mBuffer;
    private int mStart;
    private int mEnd;
    long mPos;
    private WeakPool<byte[]> mWriteBufferPool;

    DataIn(long pos, int bufferSize) {
        if (pos < 0L) {
            throw new IllegalArgumentException("Negative position: " + pos);
        }
        this.mPos = pos;
        this.mBuffer = new byte[bufferSize];
    }

    abstract int doRead(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public int read() throws IOException {
        int start = this.mStart;
        if (this.mEnd - start > 0) {
            this.mStart = start + 1;
            ++this.mPos;
            return this.mBuffer[start] & 0xFF;
        }
        int amt = this.doRead(this.mBuffer, 0, this.mBuffer.length);
        if (amt <= 0) {
            return -1;
        }
        this.mStart = 1;
        this.mEnd = amt;
        ++this.mPos;
        return this.mBuffer[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int start = this.mStart;
        int avail = this.mEnd - start;
        if (avail >= len) {
            System.arraycopy(this.mBuffer, start, b, off, len);
            this.mStart = start + len;
            this.mPos += (long)len;
            return len;
        }
        if (avail > 0) {
            System.arraycopy(this.mBuffer, start, b, off, avail);
            this.mStart = 0;
            this.mEnd = 0;
            this.mPos += (long)avail;
            return avail;
        }
        if (len >= this.mBuffer.length) {
            int amt = this.doRead(b, off, len);
            if (amt > 0) {
                this.mPos += (long)amt;
            }
            return amt;
        }
        int amt = this.doRead(this.mBuffer, 0, this.mBuffer.length);
        if (amt <= 0) {
            return amt;
        }
        int fill = Math.min(amt, len);
        System.arraycopy(this.mBuffer, 0, b, off, fill);
        this.mStart = fill;
        this.mEnd = amt;
        this.mPos += (long)fill;
        return fill;
    }

    public int readIntLE() throws IOException {
        int start = this.require(4);
        int v = Utils.decodeIntLE(this.mBuffer, start);
        this.mStart = start + 4;
        this.mPos += 4L;
        return v;
    }

    public long readLongLE() throws IOException {
        int start = this.require(8);
        long v = Utils.decodeLongLE(this.mBuffer, start);
        this.mStart = start + 8;
        this.mPos += 8L;
        return v;
    }

    public int readUnsignedVarInt() throws IOException {
        int start = this.require(1);
        byte[] b = this.mBuffer;
        int v = b[start++];
        int amt = 1;
        if (v < 0) {
            switch (v >> 4 & 7) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    start = this.require(start, 1);
                    v = 128 + ((v & 0x3F) << 8 | b[start++] & 0xFF);
                    amt = 2;
                    break;
                }
                case 4: 
                case 5: {
                    start = this.require(start, 2);
                    v = 16512 + ((v & 0x1F) << 16 | (b[start++] & 0xFF) << 8 | b[start++] & 0xFF);
                    amt = 3;
                    break;
                }
                case 6: {
                    start = this.require(start, 3);
                    v = 2113664 + ((v & 0xF) << 24 | (b[start++] & 0xFF) << 16 | (b[start++] & 0xFF) << 8 | b[start++] & 0xFF);
                    amt = 4;
                    break;
                }
                default: {
                    start = this.require(start, 4);
                    v = 270549120 + (b[start++] << 24 | (b[start++] & 0xFF) << 16 | (b[start++] & 0xFF) << 8 | b[start++] & 0xFF);
                    amt = 5;
                }
            }
        }
        this.mStart = start;
        this.mPos += (long)amt;
        return v;
    }

    public long readUnsignedVarLong() throws IOException {
        int amt;
        long v;
        byte d;
        int start = this.require(1);
        byte[] b = this.mBuffer;
        if ((d = b[start++]) >= 0) {
            v = d;
            amt = 1;
        } else {
            block0 : switch (d >> 4 & 7) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    start = this.require(start, 1);
                    v = 128L + (long)((d & 0x3F) << 8 | b[start++] & 0xFF);
                    amt = 2;
                    break;
                }
                case 4: 
                case 5: {
                    start = this.require(start, 2);
                    v = 16512L + (long)((d & 0x1F) << 16 | (b[start++] & 0xFF) << 8 | b[start++] & 0xFF);
                    amt = 3;
                    break;
                }
                case 6: {
                    start = this.require(start, 3);
                    v = 2113664L + (long)((d & 0xF) << 24 | (b[start++] & 0xFF) << 16 | (b[start++] & 0xFF) << 8 | b[start++] & 0xFF);
                    amt = 4;
                    break;
                }
                default: {
                    switch (d & 0xF) {
                        default: {
                            start = this.require(start, 4);
                            v = 270549120L + (((long)d & 7L) << 32 | (long)(b[start++] & 0xFF) << 24 | (long)(b[start++] & 0xFF) << 16 | (long)(b[start++] & 0xFF) << 8 | (long)(b[start++] & 0xFF));
                            amt = 5;
                            break block0;
                        }
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: {
                            start = this.require(start, 5);
                            v = 34630287488L + (((long)d & 3L) << 40 | (long)(b[start++] & 0xFF) << 32 | (long)(b[start++] & 0xFF) << 24 | (long)(b[start++] & 0xFF) << 16 | (long)(b[start++] & 0xFF) << 8 | (long)(b[start++] & 0xFF));
                            amt = 6;
                            break block0;
                        }
                        case 12: 
                        case 13: {
                            start = this.require(start, 6);
                            v = 4432676798592L + (((long)d & 1L) << 48 | (long)(b[start++] & 0xFF) << 40 | (long)(b[start++] & 0xFF) << 32 | (long)(b[start++] & 0xFF) << 24 | (long)(b[start++] & 0xFF) << 16 | (long)(b[start++] & 0xFF) << 8 | (long)(b[start++] & 0xFF));
                            amt = 7;
                            break block0;
                        }
                        case 14: {
                            start = this.require(start, 7);
                            v = 567382630219904L + ((long)(b[start++] & 0xFF) << 48 | (long)(b[start++] & 0xFF) << 40 | (long)(b[start++] & 0xFF) << 32 | (long)(b[start++] & 0xFF) << 24 | (long)(b[start++] & 0xFF) << 16 | (long)(b[start++] & 0xFF) << 8 | (long)(b[start++] & 0xFF));
                            amt = 8;
                            break block0;
                        }
                        case 15: 
                    }
                    start = this.require(start, 8);
                    v = 72624976668147840L + ((long)b[start++] << 56 | (long)(b[start++] & 0xFF) << 48 | (long)(b[start++] & 0xFF) << 40 | (long)(b[start++] & 0xFF) << 32 | (long)(b[start++] & 0xFF) << 24 | (long)(b[start++] & 0xFF) << 16 | (long)(b[start++] & 0xFF) << 8 | (long)(b[start++] & 0xFF));
                    amt = 9;
                }
            }
        }
        this.mStart = start;
        this.mPos += (long)amt;
        return v;
    }

    public long readSignedVarLong() throws IOException {
        long v = this.readUnsignedVarLong();
        return (v & 1L) != 0L ? v >> 1 ^ 0xFFFFFFFFFFFFFFFFL | Long.MIN_VALUE : v >>> 1;
    }

    public void readFully(byte[] b) throws IOException {
        Utils.readFully(this, b, 0, b.length);
    }

    public byte[] readBytes() throws IOException {
        byte[] bytes = new byte[this.readUnsignedVarInt()];
        this.readFully(bytes);
        return bytes;
    }

    public void cursorValueWrite(RedoVisitor visitor, long cursorId, long txnId, long valuePos, int amount) throws IOException {
        byte[] buffer = this.mBuffer;
        WeakPool<Object> pool = this.mWriteBufferPool;
        if (pool == null) {
            pool = new WeakPool();
            this.mWriteBufferPool = pool;
        }
        while (true) {
            int rem;
            int writeOffset;
            byte[] writeBuf;
            WeakPool.Entry<byte[]> entry;
            if ((entry = pool.tryAccess()) == null) {
                writeBuf = new byte[Math.min(amount, buffer.length)];
                entry = pool.newEntry(writeBuf);
            } else {
                writeBuf = (byte[])entry.get();
                if (writeBuf == null || amount > writeBuf.length && writeBuf.length < buffer.length) {
                    entry.discard();
                    continue;
                }
            }
            int avail = this.mEnd - this.mStart;
            if (amount < avail) {
                System.arraycopy(buffer, this.mStart, writeBuf, 0, amount);
                this.mStart += amount;
                writeOffset = amount;
            } else {
                System.arraycopy(buffer, this.mStart, writeBuf, 0, avail);
                this.mStart = 0;
                this.mEnd = 0;
                writeOffset = avail;
            }
            this.mPos += (long)writeOffset;
            amount -= writeOffset;
            while ((rem = Math.min(amount, writeBuf.length - writeOffset)) > 0) {
                int amt = this.doRead(writeBuf, writeOffset, rem);
                if (amt <= 0) {
                    throw new EOFException();
                }
                this.mPos += (long)amt;
                writeOffset += amt;
                amount -= amt;
            }
            visitor.cursorValueWrite(cursorId, txnId, valuePos, entry, writeBuf, 0, writeOffset);
            if (amount <= 0) {
                return;
            }
            valuePos += (long)writeOffset;
        }
    }

    private int require(int amount) throws IOException {
        return this.require(this.mStart, amount);
    }

    private int require(int start, int amount) throws IOException {
        int amt;
        int avail = this.mEnd - start;
        if ((amount -= avail) <= 0) {
            return start;
        }
        if (this.mBuffer.length - this.mEnd < amount) {
            System.arraycopy(this.mBuffer, start, this.mBuffer, 0, avail);
            start = 0;
            this.mStart = 0;
            this.mEnd = avail;
        }
        do {
            if ((amt = this.doRead(this.mBuffer, this.mEnd, this.mBuffer.length - this.mEnd)) <= 0) {
                throw new EOFException();
            }
            this.mEnd += amt;
        } while ((amount -= amt) > 0);
        return start;
    }

    static final class Stream
    extends DataIn {
        private final InputStream mIn;

        Stream(long pos, InputStream in) {
            this(pos, in, 65536);
        }

        Stream(long pos, InputStream in, int bufferSize) {
            super(pos, bufferSize);
            this.mIn = in;
        }

        @Override
        int doRead(byte[] buf, int off, int len) throws IOException {
            return this.mIn.read(buf, off, len);
        }

        @Override
        public void close() throws IOException {
            this.mIn.close();
        }
    }
}

