/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import org.cojen.tupl.io.Utils;

public abstract class Delayed
implements Comparable<Delayed>,
Runnable {
    protected long mCounter;

    public Delayed(long counter) {
        this.mCounter = counter;
    }

    @Override
    public int compareTo(Delayed other) {
        return Long.signum(this.mCounter - other.mCounter);
    }

    @Override
    public final void run() {
        try {
            this.doRun();
        }
        catch (Throwable e) {
            Utils.uncaught(e);
        }
    }

    protected abstract void doRun() throws Throwable;

    static final class Runner
    extends Delayed {
        private final Runnable mTask;

        Runner(long counter, Runnable task) {
            super(counter);
            this.mTask = task;
        }

        @Override
        protected void doRun() {
            this.mTask.run();
        }
    }
}

