/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.util.concurrent.TimeUnit;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.core.DetachedLock;
import org.cojen.tupl.core.LocalTransaction;
import org.cojen.tupl.core.Lock;
import org.cojen.tupl.core.LockManager;
import org.cojen.tupl.core.Locker;
import org.cojen.tupl.util.LatchCondition;

class DetachedLockImpl
extends Lock
implements DetachedLock {
    LockManager.Bucket mBucket;

    DetachedLockImpl() {
    }

    void init(int hash, LocalTransaction owner, LockManager.Bucket bucket) {
        this.mHashCode = hash;
        this.mLockCount = Integer.MIN_VALUE;
        this.mOwner = owner;
        this.mBucket = bucket;
    }

    @Override
    public final void acquireShared(Transaction txn) throws LockFailureException {
        this.acquireShared((LocalTransaction)txn);
    }

    final void acquireShared(LocalTransaction txn) throws LockFailureException {
        long nanosTimeout = txn.lockTimeout(TimeUnit.NANOSECONDS);
        LockResult result = this.tryAcquireShared(txn, nanosTimeout);
        if (!result.isHeld()) {
            throw txn.failed(1, result, nanosTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Lock acquireSharedNoPush(LocalTransaction txn) throws LockFailureException {
        LockResult result;
        long nanosTimeout = txn.lockTimeout(TimeUnit.NANOSECONDS);
        LockManager.Bucket bucket = this.mBucket;
        bucket.acquireExclusive();
        try {
            result = this.tryLockShared(bucket, txn, nanosTimeout);
        }
        finally {
            bucket.releaseExclusive();
        }
        if (!result.isHeld()) {
            throw txn.failed(1, result, nanosTimeout);
        }
        return result == LockResult.ACQUIRED ? this : null;
    }

    @Override
    public final LockResult tryAcquireShared(Transaction txn, long nanosTimeout) {
        return this.tryAcquireShared((LocalTransaction)txn, nanosTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final LockResult tryAcquireShared(LocalTransaction txn, long nanosTimeout) {
        LockResult result;
        LockManager.Bucket bucket = this.mBucket;
        bucket.acquireExclusive();
        try {
            result = this.tryLockShared(bucket, txn, nanosTimeout);
        }
        finally {
            bucket.releaseExclusive();
        }
        if (result == LockResult.ACQUIRED) {
            txn.push(this);
        }
        return result;
    }

    @Override
    public final void acquireExclusive() throws LockFailureException {
        long nanosTimeout = ((LocalTransaction)this.mOwner).lockTimeout(TimeUnit.NANOSECONDS);
        LockResult result = this.tryAcquireExclusive(nanosTimeout);
        if (!result.isHeld()) {
            throw this.mOwner.failed(-1, result, nanosTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockResult tryAcquireExclusive(long nanosTimeout) {
        LockResult result;
        Locker locker = this.mOwner;
        LockManager.Bucket bucket = this.mBucket;
        bucket.acquireExclusive();
        try {
            result = this.tryLockExclusive(bucket, locker, nanosTimeout);
        }
        finally {
            bucket.releaseExclusive();
        }
        if (result == LockResult.UPGRADED) {
            locker.push(this);
            result = LockResult.ACQUIRED;
        }
        return result;
    }

    @Override
    protected void doUnlockOwnedUnrestricted(LockManager.Bucket bucket) {
        if (this.mLockCount == -1) {
            this.mLockCount = Integer.MIN_VALUE;
            LatchCondition queueSX = this.mQueueSX;
            if (queueSX != null) {
                queueSX.signalTagged(bucket);
            }
        }
        bucket.releaseExclusive();
    }
}

