/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.CRC32;
import org.cojen.tupl.ClosedIndexException;
import org.cojen.tupl.DeletedIndexException;
import org.cojen.tupl.core.IntegerRef;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.io.DirectAccess;
import org.cojen.tupl.io.MappedPageArray;
import org.cojen.tupl.io.UnsafeAccess;
import org.cojen.tupl.util.Latch;
import org.cojen.tupl.util.Runner;
import sun.misc.Unsafe;

public final class DirectPageOps {
    static final int NODE_OVERHEAD = 76;
    private static final boolean CHECK_BOUNDS;
    private static final int CHECKED_PAGE_SIZE;
    private static final Unsafe UNSAFE;
    private static final long BYTE_ARRAY_OFFSET;
    private static final long EMPTY_TREE_LEAF;
    private static final long CLOSED_TREE_PAGE;
    private static final long DELETED_TREE_PAGE;
    private static final long STUB_TREE_PAGE;
    private static volatile Arena[] cArenas;

    private static long newEmptyTreePage(int pageSize, int type) {
        long empty = DirectPageOps.p_callocPage(pageSize);
        DirectPageOps.p_bytePut(empty, 0, type);
        DirectPageOps.p_shortPutLE(empty, 4, 12);
        DirectPageOps.p_shortPutLE(empty, 6, pageSize - 1);
        DirectPageOps.p_shortPutLE(empty, 8, 12);
        DirectPageOps.p_shortPutLE(empty, 10, 10);
        return empty;
    }

    static long p_null() {
        return 0L;
    }

    static long p_nonTreePage() {
        return EMPTY_TREE_LEAF;
    }

    static long p_closedTreePage() {
        return CLOSED_TREE_PAGE;
    }

    static long p_deletedTreePage() {
        return DELETED_TREE_PAGE;
    }

    static boolean isClosedOrDeleted(long page) {
        return page == CLOSED_TREE_PAGE || page == DELETED_TREE_PAGE;
    }

    static void checkClosedIndexException(long page) throws ClosedIndexException {
        if (DirectPageOps.isClosedOrDeleted(page)) {
            throw DirectPageOps.newClosedIndexException(page);
        }
    }

    static ClosedIndexException newClosedIndexException(long page) {
        return page == DELETED_TREE_PAGE ? new DeletedIndexException() : new ClosedIndexException();
    }

    static long p_stubTreePage() {
        return STUB_TREE_PAGE;
    }

    public static long p_alloc(int size) {
        return UnsafeAccess.alloc(size);
    }

    static long p_allocPage(int size) {
        return UnsafeAccess.alloc(Math.abs(size), size < 0);
    }

    static long p_callocPage(int size) {
        return UnsafeAccess.calloc(Math.abs(size), size < 0);
    }

    static long[] p_allocArray(int size) {
        return new long[size];
    }

    public static void p_delete(long page) {
        if (page != CLOSED_TREE_PAGE && page != EMPTY_TREE_LEAF && !DirectPageOps.inArena(page)) {
            UnsafeAccess.free(page);
        }
    }

    static boolean inArena(long page) {
        Arena[] arenas = cArenas;
        if (arenas != null) {
            int low = 0;
            int high = arenas.length - 1;
            while (low <= high) {
                int mid = low + high >>> 1;
                int cmp = Long.compareUnsigned(arenas[mid].mStartPtr, page);
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                return true;
            }
            if (low > 0 && Long.compareUnsigned(page, arenas[low - 1].mEndPtr) < 0) {
                return true;
            }
        }
        return false;
    }

    private static synchronized void registerArena(Arena arena) {
        Arena[] existing = cArenas;
        if (existing == null) {
            cArenas = new Arena[]{arena};
        } else {
            Object[] arenas = new Arena[existing.length + 1];
            System.arraycopy(existing, 0, arenas, 0, existing.length);
            arenas[arenas.length - 1] = arena;
            Arrays.sort(arenas);
            cArenas = arenas;
        }
    }

    private static synchronized void unregisterArena(Arena arena) {
        Arena[] existing = cArenas;
        if (existing == null) {
            return;
        }
        if (existing.length == 1) {
            if (existing[0] == arena) {
                cArenas = null;
            }
            return;
        }
        try {
            Arena[] arenas = new Arena[existing.length - 1];
            int j = 0;
            for (int i = 0; i < existing.length; ++i) {
                Arena a = existing[i];
                if (a == arena) continue;
                arenas[j++] = a;
            }
            cArenas = arenas;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    static Object p_arenaAlloc(int pageSize, long pageCount) throws IOException {
        try {
            Arena arena = new Arena(pageSize, pageCount);
            DirectPageOps.registerArena(arena);
            return arena;
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    static void p_arenaDelete(Object arena) throws IOException {
        if (arena instanceof Arena) {
            Arena a = (Arena)arena;
            DirectPageOps.unregisterArena(a);
            a.close();
        } else if (arena != null) {
            throw new IllegalArgumentException();
        }
    }

    static long p_callocPage(Object arena, int size) {
        if (arena instanceof Arena) {
            Arena a = (Arena)arena;
            long page = a.p_calloc(Math.abs(size));
            if (page != DirectPageOps.p_null()) {
                return page;
            }
        } else if (arena != null) {
            throw new IllegalArgumentException();
        }
        return DirectPageOps.p_callocPage(size);
    }

    static long p_clonePage(long page, int pageSize) {
        long dst = DirectPageOps.p_allocPage(pageSize);
        UnsafeAccess.copy(page, dst, Math.abs(pageSize));
        return dst;
    }

    static long p_transfer(byte[] array) {
        int length = array.length;
        long page = DirectPageOps.p_alloc(length);
        DirectPageOps.p_copyFromArray(array, 0, page, 0, length);
        return page;
    }

    static long p_transferPage(byte[] array, int pageSize) {
        long page = DirectPageOps.p_allocPage(pageSize);
        DirectPageOps.p_copyFromArray(array, 0, page, 0, Math.abs(pageSize));
        return page;
    }

    static long p_transferArrayToPage(byte[] array, long page) {
        DirectPageOps.p_copyFromArray(array, 0, page, 0, array.length);
        return page;
    }

    static void p_transferPageToArray(long page, byte[] array) {
        DirectPageOps.p_copyToArray(page, 0, array, 0, array.length);
    }

    static byte p_byteGet(long page, int index) {
        if (CHECK_BOUNDS && Long.compareUnsigned(index, CHECKED_PAGE_SIZE) >= 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return UNSAFE.getByte(page + (long)index);
    }

    public static int p_ubyteGet(long page, int index) {
        return DirectPageOps.p_byteGet(page, index) & 0xFF;
    }

    public static void p_bytePut(long page, int index, byte v) {
        if (CHECK_BOUNDS && Long.compareUnsigned(index, CHECKED_PAGE_SIZE) >= 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        UNSAFE.putByte(page + (long)index, v);
    }

    public static void p_bytePut(long page, int index, int v) {
        DirectPageOps.p_bytePut(page, index, (byte)v);
    }

    static int p_ushortGetLE(long page, int index) {
        if (CHECK_BOUNDS && (index < 0 || index + 2 > CHECKED_PAGE_SIZE)) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return UNSAFE.getChar(page + (long)index);
    }

    static void p_shortPutLE(long page, int index, int v) {
        if (CHECK_BOUNDS && (index < 0 || index + 2 > CHECKED_PAGE_SIZE)) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        UNSAFE.putShort(page + (long)index, (short)v);
    }

    static int p_intGetLE(long page, int index) {
        if (CHECK_BOUNDS && (index < 0 || index + 4 > CHECKED_PAGE_SIZE)) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return UNSAFE.getInt(page + (long)index);
    }

    static void p_intPutLE(long page, int index, int v) {
        if (CHECK_BOUNDS && (index < 0 || index + 4 > CHECKED_PAGE_SIZE)) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        UNSAFE.putInt(page + (long)index, v);
    }

    static long p_uintGetVar(long page, int index) {
        int v;
        if ((v = DirectPageOps.p_byteGet(page, index++)) < 0) {
            switch (v >> 4 & 7) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    v = 128 + ((v & 0x3F) << 8 | DirectPageOps.p_ubyteGet(page, index++));
                    break;
                }
                case 4: 
                case 5: {
                    v = 16512 + ((v & 0x1F) << 16 | DirectPageOps.p_ubyteGet(page, index++) << 8 | DirectPageOps.p_ubyteGet(page, index++));
                    break;
                }
                case 6: {
                    v = 2113664 + ((v & 0xF) << 24 | DirectPageOps.p_ubyteGet(page, index++) << 16 | DirectPageOps.p_ubyteGet(page, index++) << 8 | DirectPageOps.p_ubyteGet(page, index++));
                    break;
                }
                default: {
                    v = 270549120 + (DirectPageOps.p_byteGet(page, index++) << 24 | DirectPageOps.p_ubyteGet(page, index++) << 16 | DirectPageOps.p_ubyteGet(page, index++) << 8 | DirectPageOps.p_ubyteGet(page, index++));
                }
            }
        }
        return (long)index << 32 | (long)v & 0xFFFFFFFFL;
    }

    static int p_uintPutVar(long page, int index, int v) {
        if (v < 128) {
            if (v < 0) {
                DirectPageOps.p_bytePut(page, index++, 255);
                DirectPageOps.p_bytePut(page, index++, (v -= 270549120) >> 24);
                DirectPageOps.p_bytePut(page, index++, v >> 16);
                DirectPageOps.p_bytePut(page, index++, v >> 8);
            }
        } else if ((v -= 128) < 16384) {
            DirectPageOps.p_bytePut(page, index++, 0x80 | v >> 8);
        } else {
            if ((v -= 16384) < 0x200000) {
                DirectPageOps.p_bytePut(page, index++, 0xC0 | v >> 16);
            } else {
                if ((v -= 0x200000) < 0x10000000) {
                    DirectPageOps.p_bytePut(page, index++, 0xE0 | v >> 24);
                } else {
                    DirectPageOps.p_bytePut(page, index++, 240);
                    DirectPageOps.p_bytePut(page, index++, (v -= 0x10000000) >> 24);
                }
                DirectPageOps.p_bytePut(page, index++, v >> 16);
            }
            DirectPageOps.p_bytePut(page, index++, v >> 8);
        }
        DirectPageOps.p_bytePut(page, index++, v);
        return index;
    }

    static long p_uint48GetLE(long page, int index) {
        return (long)DirectPageOps.p_intGetLE(page, index) & 0xFFFFFFFFL | (long)DirectPageOps.p_ushortGetLE(page, index + 4) << 32;
    }

    static void p_int48PutLE(long page, int index, long v) {
        DirectPageOps.p_intPutLE(page, index, (int)v);
        DirectPageOps.p_shortPutLE(page, index + 4, (short)(v >> 32));
    }

    static long p_longGetLE(long page, int index) {
        if (CHECK_BOUNDS && (index < 0 || index + 8 > CHECKED_PAGE_SIZE)) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return UNSAFE.getLong(page + (long)index);
    }

    static void p_longPutLE(long page, int index, long v) {
        if (CHECK_BOUNDS && (index < 0 || index + 8 > CHECKED_PAGE_SIZE)) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        UNSAFE.putLong(page + (long)index, v);
    }

    static long p_longGetBE(long page, int index) {
        return Long.reverseBytes(DirectPageOps.p_longGetLE(page, index));
    }

    static void p_longPutBE(long page, int index, long v) {
        DirectPageOps.p_longPutLE(page, index, Long.reverseBytes(v));
    }

    static long p_ulongGetVar(long page, IntegerRef ref) {
        byte val;
        int offset = ref.get();
        if ((val = DirectPageOps.p_byteGet(page, offset++)) >= 0) {
            ref.set(offset);
            return val;
        }
        long decoded = switch (val >> 4 & 7) {
            case 0, 1, 2, 3 -> 128L + (long)((val & 0x3F) << 8 | DirectPageOps.p_ubyteGet(page, offset++));
            case 4, 5 -> 16512L + (long)((val & 0x1F) << 16 | DirectPageOps.p_ubyteGet(page, offset++) << 8 | DirectPageOps.p_ubyteGet(page, offset++));
            case 6 -> 2113664L + (long)((val & 0xF) << 24 | DirectPageOps.p_ubyteGet(page, offset++) << 16 | DirectPageOps.p_ubyteGet(page, offset++) << 8 | DirectPageOps.p_ubyteGet(page, offset++));
            default -> {
                switch (val & 0xF) {
                    default: {
                        yield 270549120L + (((long)val & 7L) << 32 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 24 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 16 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 8 | (long)DirectPageOps.p_ubyteGet(page, offset++));
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        yield 34630287488L + (((long)val & 3L) << 40 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 32 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 24 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 16 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 8 | (long)DirectPageOps.p_ubyteGet(page, offset++));
                    }
                    case 12: 
                    case 13: {
                        yield 4432676798592L + (((long)val & 1L) << 48 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 40 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 32 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 24 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 16 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 8 | (long)DirectPageOps.p_ubyteGet(page, offset++));
                    }
                    case 14: {
                        yield 567382630219904L + ((long)DirectPageOps.p_ubyteGet(page, offset++) << 48 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 40 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 32 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 24 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 16 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 8 | (long)DirectPageOps.p_ubyteGet(page, offset++));
                    }
                    case 15: 
                }
                yield 72624976668147840L + ((long)DirectPageOps.p_byteGet(page, offset++) << 56 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 48 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 40 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 32 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 24 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 16 | (long)DirectPageOps.p_ubyteGet(page, offset++) << 8 | (long)DirectPageOps.p_ubyteGet(page, offset++));
            }
        };
        ref.set(offset);
        return decoded;
    }

    static int p_ulongPutVar(long page, int index, long v) {
        if (v < 128L) {
            if (v < 0L) {
                DirectPageOps.p_bytePut(page, index++, 255);
                DirectPageOps.p_bytePut(page, index++, (byte)((v -= 72624976668147840L) >> 56));
                DirectPageOps.p_bytePut(page, index++, (byte)(v >> 48));
                DirectPageOps.p_bytePut(page, index++, (byte)(v >> 40));
                DirectPageOps.p_bytePut(page, index++, (byte)(v >> 32));
                DirectPageOps.p_bytePut(page, index++, (byte)(v >> 24));
                DirectPageOps.p_bytePut(page, index++, (byte)(v >> 16));
                DirectPageOps.p_bytePut(page, index++, (byte)(v >> 8));
            }
        } else if ((v -= 128L) < 16384L) {
            DirectPageOps.p_bytePut(page, index++, 0x80 | (int)(v >> 8));
        } else {
            if ((v -= 16384L) < 0x200000L) {
                DirectPageOps.p_bytePut(page, index++, 0xC0 | (int)(v >> 16));
            } else {
                if ((v -= 0x200000L) < 0x10000000L) {
                    DirectPageOps.p_bytePut(page, index++, 0xE0 | (int)(v >> 24));
                } else {
                    if ((v -= 0x10000000L) < 0x800000000L) {
                        DirectPageOps.p_bytePut(page, index++, 0xF0 | (int)(v >> 32));
                    } else {
                        if ((v -= 0x800000000L) < 0x40000000000L) {
                            DirectPageOps.p_bytePut(page, index++, 0xF8 | (int)(v >> 40));
                        } else {
                            if ((v -= 0x40000000000L) < 0x2000000000000L) {
                                DirectPageOps.p_bytePut(page, index++, 0xFC | (int)(v >> 48));
                            } else {
                                if ((v -= 0x2000000000000L) < 0x100000000000000L) {
                                    DirectPageOps.p_bytePut(page, index++, 254);
                                } else {
                                    DirectPageOps.p_bytePut(page, index++, 255);
                                    DirectPageOps.p_bytePut(page, index++, (byte)((v -= 0x100000000000000L) >> 56));
                                }
                                DirectPageOps.p_bytePut(page, index++, (byte)(v >> 48));
                            }
                            DirectPageOps.p_bytePut(page, index++, (byte)(v >> 40));
                        }
                        DirectPageOps.p_bytePut(page, index++, (byte)(v >> 32));
                    }
                    DirectPageOps.p_bytePut(page, index++, (byte)(v >> 24));
                }
                DirectPageOps.p_bytePut(page, index++, (byte)(v >> 16));
            }
            DirectPageOps.p_bytePut(page, index++, (byte)(v >> 8));
        }
        DirectPageOps.p_bytePut(page, index++, (byte)v);
        return index;
    }

    static int p_ulongVarSize(long v) {
        return Utils.calcUnsignedVarLongLength(v);
    }

    static void p_clear(long page, int fromIndex, int toIndex) {
        int len = toIndex - fromIndex;
        if (len > 0) {
            if (CHECK_BOUNDS) {
                if (Long.compareUnsigned(fromIndex, CHECKED_PAGE_SIZE) >= 0) {
                    throw new ArrayIndexOutOfBoundsException(fromIndex);
                }
                if (Long.compareUnsigned(toIndex, CHECKED_PAGE_SIZE) > 0) {
                    throw new ArrayIndexOutOfBoundsException(toIndex);
                }
            }
            UnsafeAccess.fill(page + (long)fromIndex, len, (byte)0);
        }
    }

    static byte[] p_copyIfNotArray(long page, byte[] dstArray) {
        DirectPageOps.p_copyToArray(page, 0, dstArray, 0, dstArray.length);
        return dstArray;
    }

    public static void p_copyFromArray(byte[] src, int srcStart, long dstPage, int dstStart, int len) {
        if (CHECK_BOUNDS) {
            if (len < 0) {
                throw new IndexOutOfBoundsException("len: " + len);
            }
            if (srcStart < 0 || srcStart + len > src.length) {
                throw new IndexOutOfBoundsException("src: " + srcStart + ", " + len);
            }
            if (dstStart < 0 || dstStart + len > CHECKED_PAGE_SIZE) {
                throw new IndexOutOfBoundsException("dst: " + dstStart + ", " + len);
            }
        }
        UNSAFE.copyMemory(src, BYTE_ARRAY_OFFSET + (long)srcStart, null, dstPage + (long)dstStart, len);
    }

    public static void p_copyToArray(long srcPage, int srcStart, byte[] dst, int dstStart, int len) {
        if (CHECK_BOUNDS) {
            if (len < 0) {
                throw new IndexOutOfBoundsException("len: " + len);
            }
            if (srcStart < 0 || srcStart + len > CHECKED_PAGE_SIZE) {
                throw new IndexOutOfBoundsException("src: " + srcStart + ", " + len);
            }
            if (dstStart < 0 || dstStart + len > dst.length) {
                throw new IndexOutOfBoundsException("dst: " + dstStart + ", " + len);
            }
        }
        UNSAFE.copyMemory(null, srcPage + (long)srcStart, dst, BYTE_ARRAY_OFFSET + (long)dstStart, len);
    }

    static void p_copyFromBB(ByteBuffer src, long dstPage, int dstStart, int len) {
        src.limit(src.position() + len);
        DirectAccess.ref(dstPage + (long)dstStart, len).put(src);
        src.limit(src.capacity());
    }

    static void p_copyToBB(long srcPage, int srcStart, ByteBuffer dst, int len) {
        dst.put(DirectAccess.ref(srcPage + (long)srcStart, len));
    }

    public static void p_copy(long srcPage, int srcStart, long dstPage, int dstStart, int len) {
        if (CHECK_BOUNDS) {
            if (len < 0) {
                throw new IndexOutOfBoundsException("len: " + len);
            }
            if (srcStart < 0 || srcStart + len > CHECKED_PAGE_SIZE) {
                throw new IndexOutOfBoundsException("src: " + srcStart + ", " + len);
            }
            if (dstStart < 0 || dstStart + len > CHECKED_PAGE_SIZE) {
                throw new IndexOutOfBoundsException("dst: " + dstStart + ", " + len);
            }
        }
        UnsafeAccess.copy(srcPage + (long)srcStart, dstPage + (long)dstStart, len);
    }

    static void p_copies(long page, int start1, int dest1, int length1, int start2, int dest2, int length2) {
        if (dest1 < start1) {
            DirectPageOps.p_copy(page, start1, page, dest1, length1);
            DirectPageOps.p_copy(page, start2, page, dest2, length2);
        } else {
            DirectPageOps.p_copy(page, start2, page, dest2, length2);
            DirectPageOps.p_copy(page, start1, page, dest1, length1);
        }
    }

    static void p_copies(long page, int start1, int dest1, int length1, int start2, int dest2, int length2, int start3, int dest3, int length3) {
        if (dest1 < start1) {
            DirectPageOps.p_copy(page, start1, page, dest1, length1);
            DirectPageOps.p_copies(page, start2, dest2, length2, start3, dest3, length3);
        } else {
            DirectPageOps.p_copies(page, start2, dest2, length2, start3, dest3, length3);
            DirectPageOps.p_copy(page, start1, page, dest1, length1);
        }
    }

    static int p_compareKeysPageToArray(long apage, int aoff, int alen, byte[] b, int boff, int blen) {
        int minLen = Math.min(alen, blen);
        for (int i = 0; i < minLen; ++i) {
            byte bb;
            byte ab;
            if ((ab = DirectPageOps.p_byteGet(apage, aoff++)) == (bb = b[boff + i])) continue;
            return (ab & 0xFF) - (bb & 0xFF);
        }
        return alen - blen;
    }

    static int p_compareKeysPageToPage(long apage, int aoff, int alen, long bpage, int boff, int blen) {
        int minLen = Math.min(alen, blen);
        for (int i = 0; i < minLen; ++i) {
            byte bb;
            byte ab;
            if ((ab = DirectPageOps.p_byteGet(apage, aoff++)) == (bb = DirectPageOps.p_byteGet(bpage, boff++))) continue;
            return (ab & 0xFF) - (bb & 0xFF);
        }
        return alen - blen;
    }

    static byte[] p_midKeyLowPage(long lowPage, int lowOff, int lowLen, byte[] high, int highOff) {
        for (int i = 0; i < lowLen; ++i) {
            byte hi;
            byte lo = DirectPageOps.p_byteGet(lowPage, lowOff + i);
            if (lo == (hi = high[highOff + i])) continue;
            byte[] mid = new byte[i + 1];
            DirectPageOps.p_copyToArray(lowPage, lowOff, mid, 0, i);
            mid[i] = (byte)((lo & 0xFF) + (hi & 0xFF) + 1 >> 1);
            return mid;
        }
        byte[] mid = new byte[lowLen + 1];
        System.arraycopy(high, highOff, mid, 0, mid.length);
        return mid;
    }

    static byte[] p_midKeyHighPage(byte[] low, int lowOff, int lowLen, long highPage, int highOff) {
        for (int i = 0; i < lowLen; ++i) {
            byte lo = low[lowOff + i];
            byte hi = DirectPageOps.p_byteGet(highPage, highOff + i);
            if (lo == hi) continue;
            byte[] mid = new byte[i + 1];
            System.arraycopy(low, lowOff, mid, 0, i);
            mid[i] = (byte)((lo & 0xFF) + (hi & 0xFF) + 1 >> 1);
            return mid;
        }
        byte[] mid = new byte[lowLen + 1];
        DirectPageOps.p_copyToArray(highPage, highOff, mid, 0, mid.length);
        return mid;
    }

    static byte[] p_midKeyLowHighPage(long lowPage, int lowOff, int lowLen, long highPage, int highOff) {
        for (int i = 0; i < lowLen; ++i) {
            byte hi;
            byte lo = DirectPageOps.p_byteGet(lowPage, lowOff + i);
            if (lo == (hi = DirectPageOps.p_byteGet(highPage, highOff + i))) continue;
            byte[] mid = new byte[i + 1];
            DirectPageOps.p_copyToArray(lowPage, lowOff, mid, 0, i);
            mid[i] = (byte)((lo & 0xFF) + (hi & 0xFF) + 1 >> 1);
            return mid;
        }
        byte[] mid = new byte[lowLen + 1];
        DirectPageOps.p_copyToArray(highPage, highOff, mid, 0, mid.length);
        return mid;
    }

    static int p_crc32(long srcPage, int srcStart, int len) {
        CRC32 crc = new CRC32();
        crc.update(DirectAccess.ref(srcPage + (long)srcStart, len));
        return (int)crc.getValue();
    }

    static {
        UNSAFE = UnsafeAccess.obtain();
        BYTE_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
        Integer checkedPageSize = Integer.getInteger(DirectPageOps.class.getName() + ".checkedPageSize");
        if (checkedPageSize == null) {
            CHECK_BOUNDS = false;
            CHECKED_PAGE_SIZE = 0;
        } else {
            CHECK_BOUNDS = true;
            CHECKED_PAGE_SIZE = checkedPageSize;
        }
        EMPTY_TREE_LEAF = DirectPageOps.newEmptyTreePage(12, -118);
        CLOSED_TREE_PAGE = DirectPageOps.newEmptyTreePage(20, 100);
        DELETED_TREE_PAGE = DirectPageOps.newEmptyTreePage(20, 100);
        STUB_TREE_PAGE = DirectPageOps.newEmptyTreePage(20, 100);
    }

    static class Arena
    implements Comparable<Arena> {
        private final MappedPageArray mPageArray;
        private final long mStartPtr;
        private final long mEndPtr;
        private long mNextPtr;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Arena(int pageSize, long pageCount) throws IOException {
            pageSize = Math.abs(pageSize);
            this.mPageArray = MappedPageArray.open(pageSize, pageCount, null, null);
            this.mStartPtr = this.mPageArray.directPagePointer(0L);
            this.mEndPtr = this.mStartPtr + (long)pageSize * pageCount;
            Arena arena = this;
            synchronized (arena) {
                this.mNextPtr = this.mStartPtr;
            }
            int numThreads = Runtime.getRuntime().availableProcessors();
            Latch latch = new Latch(numThreads);
            int osPageSize = UNSAFE.pageSize();
            long osPageCount = (this.mEndPtr - this.mStartPtr) / (long)osPageSize;
            long startPtr = this.mStartPtr;
            for (int i = 1; i < numThreads; ++i) {
                long fstartPtr = startPtr;
                long endPtr = this.mStartPtr + (long)i * osPageCount / (long)numThreads * (long)osPageSize;
                Runner.start(() -> Arena.preTouch(fstartPtr, endPtr, osPageSize, latch));
                startPtr = endPtr;
            }
            Arena.preTouch(startPtr, this.mEndPtr, osPageSize, latch);
            latch.acquireExclusive();
        }

        private static void preTouch(long startPtr, long endPtr, int pageSize, Latch notify) {
            for (long ptr = startPtr; ptr < endPtr; ptr += (long)pageSize) {
                UNSAFE.putByte(ptr, (byte)0);
            }
            notify.releaseShared();
        }

        @Override
        public int compareTo(Arena other) {
            return Long.compareUnsigned(this.mStartPtr, other.mStartPtr);
        }

        synchronized long p_calloc(int size) {
            int pageSize = this.mPageArray.pageSize();
            if (size != pageSize) {
                throw new IllegalArgumentException();
            }
            long ptr = this.mNextPtr;
            if (ptr >= this.mEndPtr) {
                return DirectPageOps.p_null();
            }
            this.mNextPtr = ptr + (long)pageSize;
            return ptr;
        }

        synchronized void close() throws IOException {
            this.mNextPtr = this.mEndPtr;
            this.mPageArray.close();
        }
    }
}

