/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.util.Arrays;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.View;
import org.cojen.tupl.core.BTree;
import org.cojen.tupl.core.BTreeCursor;
import org.cojen.tupl.core.CommitLock;
import org.cojen.tupl.core.LHashTable;
import org.cojen.tupl.core.LocalDatabase;
import org.cojen.tupl.core.LocalTransaction;
import org.cojen.tupl.core.Node;
import org.cojen.tupl.core.PageOps;
import org.cojen.tupl.core.Utils;

final class FragmentedTrash {
    private FragmentedTrash() {
    }

    static void add(BTree trash, LocalTransaction txn, long indexId, byte[] entry, int keyStart, int keyLen, int valueStart, int valueLen) throws IOException {
        byte[] payload = new byte[valueLen];
        PageOps.p_copyToArray(entry, valueStart, payload, 0, valueLen);
        BTreeCursor cursor = FragmentedTrash.prepareEntry(trash, txn.txnId());
        byte[] key = cursor.key();
        try {
            txn.setHasTrash();
            cursor.store(payload);
            cursor.reset();
        }
        catch (Throwable e) {
            try {
                txn.borked(e);
            }
            catch (Throwable e2) {
                e = e2;
            }
            throw Utils.closeOnFailure(cursor, e);
        }
        int tidLen = key.length - 8;
        int payloadLen = keyLen + tidLen;
        if (payloadLen > payload.length) {
            payload = new byte[payloadLen];
        }
        PageOps.p_copyToArray(entry, keyStart, payload, 0, keyLen);
        System.arraycopy(key, 8, payload, keyLen, tidLen);
        txn.pushUndeleteFragmented(indexId, payload, 0, payloadLen);
    }

    private static BTreeCursor prepareEntry(BTree trash, long txnId) throws IOException {
        byte[] prefix = new byte[8];
        Utils.encodeLongBE(prefix, 0, txnId);
        BTreeCursor cursor = new BTreeCursor(trash, Transaction.BOGUS);
        try {
            cursor.autoload(false);
            cursor.findGt(prefix);
            byte[] key = cursor.key();
            if (key == null || Arrays.compareUnsigned(key, 0, 8, prefix, 0, 8) != 0) {
                key = new byte[9];
                System.arraycopy(prefix, 0, key, 0, 8);
                key[8] = -1;
                cursor.findNearby(key);
            } else {
                cursor.findNearby(Utils.decrementReverseUnsignedVar(key, 8));
            }
            return cursor;
        }
        catch (Throwable e) {
            throw Utils.closeOnFailure(cursor, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void remove(BTree trash, long txnId, BTree index, byte[] undoEntry) throws IOException {
        byte[] trashKey;
        byte[] indexKey;
        byte[] undo = PageOps.p_transfer(undoEntry);
        try {
            Node dbAccess = trash.mRoot;
            indexKey = Node.retrieveKeyAtLoc(dbAccess, undo, 0);
            int tidLoc = Node.keyLengthAtLoc(undo, 0);
            int tidLen = undoEntry.length - tidLoc;
            trashKey = new byte[8 + tidLen];
            Utils.encodeLongBE(trashKey, 0, txnId);
            PageOps.p_copyToArray(undo, tidLoc, trashKey, 8, tidLen);
        }
        finally {
            PageOps.p_delete(undo);
        }
        FragmentedTrash.remove(trash, index, indexKey, trashKey);
    }

    static void remove(BTree trash, BTree index, byte[] indexKey, byte[] trashKey) throws IOException {
        BTreeCursor trashCursor = new BTreeCursor(trash, Transaction.BOGUS);
        try {
            trashCursor.find(trashKey);
            if (index == null) {
                FragmentedTrash.deleteFragmented(trash.mDatabase, trashCursor);
            } else {
                byte[] fragmented = trashCursor.value();
                if (fragmented != null) {
                    BTreeCursor ixCursor = new BTreeCursor(index, Transaction.BOGUS);
                    try {
                        ixCursor.find(indexKey);
                        ixCursor.storeFragmented(fragmented);
                        ixCursor.reset();
                    }
                    catch (Throwable e) {
                        throw Utils.closeOnFailure(ixCursor, e);
                    }
                    trashCursor.store(null);
                }
            }
            trashCursor.reset();
        }
        catch (Throwable e) {
            throw Utils.closeOnFailure(trashCursor, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void emptyTrash(BTree trash, long txnId) throws IOException {
        byte[] prefix = new byte[8];
        Utils.encodeLongBE(prefix, 0, txnId);
        LocalDatabase db = trash.mDatabase;
        CommitLock commitLock = db.commitLock();
        BTreeCursor cursor = new BTreeCursor(trash, Transaction.BOGUS);
        try {
            byte[] key;
            cursor.autoload(false);
            cursor.findGt(prefix);
            while ((key = cursor.key()) != null && Arrays.compareUnsigned(key, 0, 8, prefix, 0, 8) == 0) {
                CommitLock.Shared shared = commitLock.acquireShared();
                try {
                    FragmentedTrash.deleteFragmented(db, cursor);
                }
                finally {
                    shared.release();
                }
                cursor.next();
            }
            cursor.reset();
        }
        catch (Throwable e) {
            throw Utils.closeOnFailure(cursor, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void emptyLingeringTrash(BTree trash, LHashTable<?> activeTxns) throws IOException {
        LocalDatabase db = trash.mDatabase;
        CommitLock commitLock = db.commitLock();
        byte[] boundary = new byte[8];
        Utils.encodeLongBE(boundary, 0, Long.MIN_VALUE);
        View view = activeTxns == null ? trash.viewGe(boundary) : trash.viewLt(boundary);
        try (Cursor cursor = view.newCursor(Transaction.BOGUS);){
            cursor.autoload(false);
            cursor.first();
            while (cursor.key() != null) {
                if (activeTxns == null || activeTxns.get(Utils.decodeLongBE(cursor.key(), 0)) == null) {
                    CommitLock.Shared shared = commitLock.acquireShared();
                    try {
                        FragmentedTrash.deleteFragmented(db, cursor);
                    }
                    finally {
                        shared.release();
                    }
                }
                cursor.next();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteFragmented(LocalDatabase db, Cursor cursor) throws IOException {
        cursor.load();
        byte[] value = cursor.value();
        if (value != null) {
            byte[] fragmented = PageOps.p_transfer(value);
            try {
                db.deleteFragments(fragmented, 0, value.length);
                cursor.store(null);
            }
            finally {
                PageOps.p_delete(fragmented);
            }
        }
    }
}

