/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import org.cojen.tupl.core.Utils;

abstract class Hasher {
    private static final VarHandle cShortArrayHandle;
    private static final VarHandle cIntArrayHandle;
    private static final VarHandle cLongArrayHandle;

    private Hasher() {
    }

    public static long hash(long hash, byte[] b) {
        return Hasher.hash(hash, b, 0, b.length);
    }

    public static long hash(long hash, byte[] b, int off, int len) {
        int end = off + len - 8;
        while (off <= end) {
            hash = (hash << 5) - hash ^ cLongArrayHandle.get(b, off);
            off += 8;
        }
        if (off <= (end += 4)) {
            hash = (hash << 5) - hash ^ (long)cIntArrayHandle.get(b, off);
            off += 4;
        }
        if (off <= (end += 2)) {
            hash = (hash << 5) - hash ^ (long)cShortArrayHandle.get(b, off);
            off += 2;
        }
        if (off <= ++end) {
            hash = (hash << 5) - hash ^ (long)b[off];
        }
        hash = Utils.scramble(hash);
        return hash;
    }

    static {
        try {
            ByteOrder order = ByteOrder.nativeOrder();
            cShortArrayHandle = MethodHandles.byteArrayViewVarHandle(short[].class, order);
            cIntArrayHandle = MethodHandles.byteArrayViewVarHandle(int[].class, order);
            cLongArrayHandle = MethodHandles.byteArrayViewVarHandle(long[].class, order);
        }
        catch (Throwable e) {
            throw new ExceptionInInitializerError();
        }
    }
}

