/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.zip.Checksum;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.LockUpgradeRule;
import org.cojen.tupl.core.CompressedPageArray;
import org.cojen.tupl.core.CoreDatabase;
import org.cojen.tupl.core.LHashTable;
import org.cojen.tupl.core.LocalDatabase;
import org.cojen.tupl.core.ReplUtils;
import org.cojen.tupl.core.TempFileManager;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.diag.EventListener;
import org.cojen.tupl.ev.ChainedEventListener;
import org.cojen.tupl.ext.Crypto;
import org.cojen.tupl.ext.CustomHandler;
import org.cojen.tupl.ext.PrepareHandler;
import org.cojen.tupl.io.OpenOption;
import org.cojen.tupl.io.PageArray;
import org.cojen.tupl.io.PageCompressor;
import org.cojen.tupl.repl.ReplicatorConfig;
import org.cojen.tupl.repl.StreamReplicator;

public final class Launcher
implements Cloneable {
    private static volatile Method cDirectOpen;
    private static volatile Method cDirectDestroy;
    private static volatile Method cDirectRestore;
    File mBaseFile;
    boolean mMkdirs;
    File[] mDataFiles;
    boolean mMapDataFiles;
    PageArray mDataPageArray;
    long mMinCacheBytes;
    long mMaxCacheBytes;
    DurabilityMode mDurabilityMode;
    LockUpgradeRule mLockUpgradeRule;
    long mLockTimeoutNanos;
    long mCheckpointRateNanos;
    long mCheckpointSizeThreshold;
    long mCheckpointDelayThresholdNanos;
    int mMaxCheckpointThreads;
    EventListener mEventListener;
    boolean mFileSync;
    boolean mReadOnly;
    int mPageSize;
    Boolean mDirectPageAccess;
    boolean mCachePriming;
    boolean mCleanShutdown;
    ReplicatorConfig mReplConfig;
    StreamReplicator mRepl;
    int mMaxReplicaThreads;
    boolean mEnableJMX;
    Crypto mDataCrypto;
    Crypto mRedoCrypto;
    Supplier<Checksum> mChecksumFactory;
    int mCompressorPageSize;
    long mCompressorCacheSize;
    Supplier<PageCompressor> mCompressorFactory;
    Map<String, CustomHandler> mCustomHandlers;
    Map<String, PrepareHandler> mPrepareHandlers;
    TempFileManager mTempFileManager;
    boolean mBasicMode;
    Map<String, ?> mDebugOpen;
    LHashTable.Obj mUnfinished;
    long mReplRecoveryStartNanos;
    long mReplInitialPosition;
    long mReplInitialTxnId;

    public Launcher() {
        this.createFilePath(true);
        this.durabilityMode(null);
        this.lockTimeout(1L, TimeUnit.SECONDS);
        this.checkpointRate(1L, TimeUnit.SECONDS);
        this.checkpointSizeThreshold(0x6400000L);
        this.checkpointDelayThreshold(1L, TimeUnit.MINUTES);
    }

    public void baseFile(File file) {
        this.mBaseFile = file;
    }

    public void createFilePath(boolean mkdirs) {
        this.mMkdirs = mkdirs;
    }

    public void dataFiles(File ... files) {
        if (files == null || files.length == 0) {
            this.mDataFiles = null;
        } else {
            this.mDataFiles = files;
            this.mDataPageArray = null;
        }
    }

    public void mapDataFiles(boolean mapped) {
        this.mMapDataFiles = mapped;
    }

    public void dataPageArray(PageArray array) {
        this.mDataPageArray = array;
        if (array != null) {
            int expected = this.mDataPageArray.pageSize();
            if (this.mPageSize != 0 && this.mPageSize != expected) {
                throw new IllegalStateException("Page size doesn't match data page array: " + this.mPageSize + " != " + expected);
            }
            this.mDataFiles = null;
            this.mPageSize = expected;
        }
    }

    public void minCacheSize(long minBytes) {
        this.mMinCacheBytes = minBytes;
    }

    public void maxCacheSize(long maxBytes) {
        this.mMaxCacheBytes = maxBytes;
    }

    public void durabilityMode(DurabilityMode durabilityMode) {
        if (durabilityMode == null) {
            durabilityMode = DurabilityMode.SYNC;
        }
        this.mDurabilityMode = durabilityMode;
    }

    public void lockUpgradeRule(LockUpgradeRule lockUpgradeRule) {
        if (lockUpgradeRule == null) {
            lockUpgradeRule = LockUpgradeRule.STRICT;
        }
        this.mLockUpgradeRule = lockUpgradeRule;
    }

    public void lockTimeout(long timeout, TimeUnit unit) {
        this.mLockTimeoutNanos = Utils.toNanos(timeout, unit);
    }

    public void checkpointRate(long rate, TimeUnit unit) {
        this.mCheckpointRateNanos = Utils.toNanos(rate, unit);
    }

    public void checkpointSizeThreshold(long bytes) {
        this.mCheckpointSizeThreshold = bytes;
    }

    public void checkpointDelayThreshold(long delay, TimeUnit unit) {
        this.mCheckpointDelayThresholdNanos = Utils.toNanos(delay, unit);
    }

    public void maxCheckpointThreads(int num) {
        this.mMaxCheckpointThreads = num;
    }

    public void eventListener(EventListener listener) {
        this.mEventListener = listener;
    }

    public void eventListeners(EventListener ... listeners) {
        this.mEventListener = ChainedEventListener.make(listeners);
    }

    public void syncWrites(boolean fileSync) {
        this.mFileSync = fileSync;
    }

    public void readOnly(boolean readOnly) {
        this.mReadOnly = readOnly;
    }

    public void pageSize(int size) {
        int expected;
        if (this.mDataPageArray != null && (expected = this.mDataPageArray.pageSize()) != size) {
            throw new IllegalStateException("Page size doesn't match data page array: " + size + " != " + expected);
        }
        this.mPageSize = size;
    }

    public void directPageAccess(boolean direct) {
        this.mDirectPageAccess = direct;
    }

    public void cachePriming(boolean priming) {
        this.mCachePriming = priming;
    }

    public void cleanShutdown(boolean shutdown) {
        this.mCleanShutdown = shutdown;
    }

    public void replicate(ReplicatorConfig config) {
        this.mReplConfig = config;
        this.mRepl = null;
    }

    public void replicate(StreamReplicator repl) {
        this.mRepl = repl;
        this.mReplConfig = null;
    }

    public void maxReplicaThreads(int num) {
        this.mMaxReplicaThreads = num;
    }

    public void enableJMX(boolean enable) {
        this.mEnableJMX = enable;
    }

    public void encrypt(Crypto crypto) {
        this.mDataCrypto = crypto;
        this.mRedoCrypto = crypto;
    }

    public void checksumPages(Supplier<Checksum> factory) {
        this.mChecksumFactory = factory;
    }

    public void compressPages(int fullPageSize, long cacheSize, Supplier<PageCompressor> factory) {
        this.mCompressorPageSize = fullPageSize;
        this.mCompressorCacheSize = cacheSize;
        this.mCompressorFactory = factory;
    }

    public void customHandlers(Map<String, ? extends CustomHandler> handlers) {
        this.mCustomHandlers = Launcher.mapClone(handlers);
    }

    public void prepareHandlers(Map<String, ? extends PrepareHandler> handlers) {
        this.mPrepareHandlers = Launcher.mapClone(handlers);
    }

    static <H> Map<String, H> mapClone(Map<String, ? extends H> map) {
        return map == null || map.isEmpty() ? null : new HashMap<String, H>(map);
    }

    static <H> LHashTable.Obj<H> newByIdMap(Map<String, ? extends H> map) {
        return map == null || map.isEmpty() ? null : new LHashTable.Obj(map.size());
    }

    public void debugOpen(PrintStream out, Map<String, ?> properties) throws IOException {
        if (out == null) {
            out = System.out;
        }
        if (properties == null) {
            properties = Collections.emptyMap();
        }
        Launcher launcher = this.clone();
        launcher.eventListener(EventListener.printTo(out));
        launcher.mReadOnly = true;
        launcher.mDebugOpen = properties;
        if (launcher.mDirectPageAccess == null) {
            launcher.directPageAccess(false);
        }
        launcher.open(false, null).close();
    }

    public Launcher clone() {
        try {
            return (Launcher)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw Utils.rethrow(e);
        }
    }

    TempFileManager tempFileManager() throws IOException {
        TempFileManager tfm = this.mTempFileManager;
        if (tfm == null && this.mBaseFile != null && !this.mBasicMode && this.mDebugOpen == null) {
            this.mTempFileManager = tfm = new TempFileManager(this.mBaseFile);
        }
        return tfm;
    }

    File[] dataFiles() {
        long encoding;
        if (this.mRepl != null && (encoding = this.mRepl.encoding()) == 0L) {
            throw new IllegalStateException("Illegal replicator encoding: " + encoding);
        }
        File[] dataFiles = this.mDataFiles;
        if (this.mBaseFile == null) {
            if (dataFiles != null && dataFiles.length > 0) {
                throw new IllegalStateException("Cannot specify data files when no base file is provided");
            }
            return null;
        }
        if (this.mBaseFile.isDirectory()) {
            throw new IllegalStateException("Base file is a directory: " + this.mBaseFile);
        }
        if (this.mDataPageArray != null) {
            return null;
        }
        if (dataFiles == null || dataFiles.length == 0) {
            dataFiles = new File[]{new File(this.mBaseFile.getPath() + ".db")};
        }
        for (File dataFile : dataFiles) {
            if (!dataFile.isDirectory()) continue;
            throw new IllegalStateException("Data file is a directory: " + dataFile);
        }
        return dataFiles;
    }

    EnumSet<OpenOption> createOpenOptions() {
        EnumSet<OpenOption> options = EnumSet.noneOf(OpenOption.class);
        options.add(OpenOption.RANDOM_ACCESS);
        if (this.mReadOnly) {
            options.add(OpenOption.READ_ONLY);
        }
        if (this.mFileSync) {
            options.add(OpenOption.SYNC_IO);
        }
        if (this.mMapDataFiles) {
            options.add(OpenOption.MAPPED);
        }
        if (this.mMkdirs) {
            options.add(OpenOption.CREATE);
        }
        return options;
    }

    private boolean openReplicator() throws IOException {
        if (this.mRepl != null || this.mReplConfig == null || this.mBaseFile == null || this.mBaseFile.isDirectory()) {
            return false;
        }
        ReplicatorConfig replConfig = this.mReplConfig.clone();
        if (this.mEventListener != null) {
            replConfig.eventListener(this.mEventListener);
        }
        replConfig.baseFilePath(this.mBaseFile.getPath() + ".repl");
        replConfig.createFilePath(this.mMkdirs);
        this.mRepl = StreamReplicator.open(replConfig);
        return true;
    }

    public final CoreDatabase open(boolean destroy, InputStream restore) throws IOException {
        Launcher launcher = this.clone();
        boolean openedReplicator = launcher.openReplicator();
        try {
            return launcher.doOpen(destroy, restore);
        }
        catch (Throwable e) {
            if (openedReplicator) {
                try {
                    launcher.mRepl.close();
                }
                catch (Throwable e2) {
                    Utils.suppress(e, e2);
                }
            }
            throw e;
        }
    }

    private CoreDatabase doOpen(boolean destroy, InputStream restore) throws IOException {
        Method m;
        Object[] args;
        block13: {
            block14: {
                File[] dataFiles;
                block15: {
                    if (restore != null || this.mRepl == null) break block13;
                    if (destroy) break block14;
                    dataFiles = this.dataFiles();
                    if (dataFiles != null) break block15;
                    if (this.mDataPageArray != null && this.mDataPageArray.isEmpty()) break block14;
                    break block13;
                }
                for (File file : dataFiles) {
                    if (!file.exists()) {
                        continue;
                    }
                    break block13;
                }
            }
            restore = ReplUtils.restoreRequest(this.mRepl, this.mEventListener);
        }
        if (this.mCompressorFactory != null) {
            this.tempFileManager();
            Launcher subLauncher = this.clone();
            subLauncher.mBasicMode = true;
            subLauncher.minCacheSize(this.mCompressorCacheSize);
            subLauncher.maxCacheSize(this.mCompressorCacheSize);
            subLauncher.durabilityMode(DurabilityMode.NO_FLUSH);
            subLauncher.checkpointRate(-1L, null);
            subLauncher.eventListener(null);
            subLauncher.cachePriming(false);
            subLauncher.cleanShutdown(false);
            subLauncher.replicate((StreamReplicator)null);
            subLauncher.enableJMX(false);
            subLauncher.compressPages(0, 0L, null);
            subLauncher.customHandlers(null);
            subLauncher.prepareHandlers(null);
            CoreDatabase sub = subLauncher.doOpen(destroy, restore);
            restore = null;
            CompressedPageArray compressed = new CompressedPageArray(this.mCompressorPageSize, sub, sub.registry(), this.mCompressorFactory);
            this.mPageSize = 0;
            this.dataPageArray(compressed);
            this.mDataCrypto = null;
            this.mChecksumFactory = null;
        }
        if (restore != null) {
            args = new Object[]{this, restore};
            m = this.directRestoreMethod();
        } else {
            args = new Object[]{this};
            m = destroy ? this.directDestroyMethod() : this.directOpenMethod();
        }
        Throwable e1 = null;
        if (m != null) {
            try {
                return (CoreDatabase)m.invoke(null, args);
            }
            catch (Exception e) {
                this.handleDirectException(e);
                e1 = e;
            }
        }
        try {
            if (restore != null) {
                return LocalDatabase.restoreFromSnapshot(this, restore);
            }
            if (destroy) {
                return LocalDatabase.destroy(this);
            }
            return LocalDatabase.open(this);
        }
        catch (Throwable e2) {
            e1 = Utils.rootCause(e1);
            e2 = Utils.rootCause(e2);
            if (e1 == null || e2 instanceof Error && !(e1 instanceof Error)) {
                Utils.suppress(e2, e1);
                throw Utils.rethrow(e2);
            }
            Utils.suppress(e1, e2);
            throw Utils.rethrow(e1);
        }
    }

    private Class<?> directOpenClass() throws IOException {
        if (this.mDirectPageAccess == Boolean.FALSE) {
            return null;
        }
        Object name = this.getClass().getName();
        name = ((String)name).substring(0, ((String)name).lastIndexOf(46) + 1) + "_LocalDatabase";
        try {
            return Class.forName((String)name);
        }
        catch (Exception e) {
            this.handleDirectException(e);
            return null;
        }
    }

    private Method directOpenMethod() throws IOException {
        if (this.mDirectPageAccess == Boolean.FALSE) {
            return null;
        }
        Method m = cDirectOpen;
        if (m == null) {
            cDirectOpen = m = this.findMethod("open", Launcher.class);
        }
        return m;
    }

    private Method directDestroyMethod() throws IOException {
        if (this.mDirectPageAccess == Boolean.FALSE) {
            return null;
        }
        Method m = cDirectDestroy;
        if (m == null) {
            cDirectDestroy = m = this.findMethod("destroy", Launcher.class);
        }
        return m;
    }

    private Method directRestoreMethod() throws IOException {
        if (this.mDirectPageAccess == Boolean.FALSE) {
            return null;
        }
        Method m = cDirectRestore;
        if (m == null) {
            cDirectRestore = m = this.findMethod("restoreFromSnapshot", Launcher.class, InputStream.class);
        }
        return m;
    }

    private void handleDirectException(Exception e) throws IOException {
        if (e instanceof RuntimeException || e instanceof IOException) {
            throw Utils.rethrow(e);
        }
        Throwable cause = e.getCause();
        if (cause == null) {
            cause = e;
        }
        if (cause instanceof RuntimeException || cause instanceof IOException) {
            throw Utils.rethrow(cause);
        }
        if (this.mDirectPageAccess == Boolean.TRUE) {
            throw new DatabaseException("Unable open with direct page access", cause);
        }
    }

    private Method findMethod(String name, Class<?> ... paramTypes) throws IOException {
        Class<?> directClass = this.directOpenClass();
        if (directClass != null) {
            try {
                return directClass.getDeclaredMethod(name, paramTypes);
            }
            catch (Exception e) {
                this.handleDirectException(e);
            }
        }
        return null;
    }
}

