/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.InvalidTransactionException;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.UnmodifiableReplicaException;
import org.cojen.tupl.core.BTree;
import org.cojen.tupl.core.BTreeCursor;
import org.cojen.tupl.core.CommitLock;
import org.cojen.tupl.core.CoreTransaction;
import org.cojen.tupl.core.FragmentedTrash;
import org.cojen.tupl.core.GhostFrame;
import org.cojen.tupl.core.LocalDatabase;
import org.cojen.tupl.core.Locker;
import org.cojen.tupl.core.PendingTxn;
import org.cojen.tupl.core.RedoWriter;
import org.cojen.tupl.core.ReplWriter;
import org.cojen.tupl.core.TransactionContext;
import org.cojen.tupl.core.UndoLog;
import org.cojen.tupl.core.Utils;

public final class LocalTransaction
extends Locker
implements CoreTransaction {
    public static final LocalTransaction BOGUS = new LocalTransaction();
    private static final int HAS_SCOPE = 1;
    private static final int HAS_COMMIT = 2;
    static final int HAS_TRASH = 4;
    static final int HAS_PREPARE = 8;
    static final int HAS_PREPARE_COMMIT = 16;
    final LocalDatabase mDatabase;
    final TransactionContext mContext;
    RedoWriter mRedo;
    DurabilityMode mDurabilityMode;
    LockMode mLockMode;
    long mLockTimeoutNanos;
    int mHasState;
    private long mSavepoint;
    long mTxnId;
    UndoLog mUndoLog;
    private Object mAttachment;
    private Object mBorked;

    LocalTransaction(LocalDatabase db, RedoWriter redo, DurabilityMode durabilityMode, LockMode lockMode, long timeoutNanos) {
        super(db.mLockManager);
        this.mDatabase = db;
        this.mContext = db.selectTransactionContext(this);
        this.mRedo = redo;
        this.mDurabilityMode = durabilityMode;
        this.mLockMode = lockMode;
        this.mLockTimeoutNanos = timeoutNanos;
    }

    LocalTransaction(LocalDatabase db, long txnId, LockMode lockMode, long timeoutNanos) {
        this(db, null, DurabilityMode.NO_REDO, lockMode, timeoutNanos);
        this.mTxnId = txnId;
    }

    LocalTransaction(LocalDatabase db, long txnId, int hasState) {
        this(db, null, DurabilityMode.NO_REDO, LockMode.UPGRADABLE_READ, 0L);
        this.mTxnId = txnId;
        this.mHasState = hasState | 4;
    }

    private LocalTransaction(LocalTransaction txn) {
        super(txn.mDatabase.mLockManager, txn.mHash);
        this.mDatabase = txn.mDatabase;
        this.mContext = txn.mContext;
        this.mRedo = txn.mRedo;
        this.mDurabilityMode = DurabilityMode.SYNC;
        this.mLockMode = LockMode.UNSAFE;
    }

    private LocalTransaction() {
        super(null);
        this.mDatabase = null;
        this.mContext = null;
        this.mRedo = null;
        this.mDurabilityMode = DurabilityMode.NO_REDO;
        this.mLockMode = LockMode.UNSAFE;
        this.mBorked = this;
    }

    final void recoveredScope(long savepoint, int hasState) {
        Locker.ParentScope parentScope = super.scopeEnter();
        parentScope.mLockMode = LockMode.UPGRADABLE_READ;
        parentScope.mLockTimeoutNanos = this.mLockTimeoutNanos;
        parentScope.mHasState = this.mHasState;
        parentScope.mSavepoint = this.mSavepoint;
        this.mSavepoint = savepoint;
        this.mHasState = hasState;
    }

    final void recoveredUndoLog(UndoLog undo) {
        this.mContext.register(undo);
        this.mUndoLog = undo;
    }

    @Override
    public final LocalDatabase getDatabase() {
        return this.mDatabase;
    }

    @Override
    public final void attach(Object obj) {
        this.mAttachment = obj;
    }

    @Override
    public final Object attachment() {
        return this.mAttachment;
    }

    @Override
    public final void lockMode(LockMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Lock mode is null");
        }
        this.bogusCheck();
        this.mLockMode = mode;
    }

    @Override
    public final LockMode lockMode() {
        return this.mLockMode;
    }

    @Override
    public final void lockTimeout(long timeout, TimeUnit unit) {
        this.bogusCheck();
        this.mLockTimeoutNanos = Utils.toNanos(timeout, unit);
    }

    @Override
    public final long lockTimeout(TimeUnit unit) {
        long timeoutNanos = this.mLockTimeoutNanos;
        return timeoutNanos < 0L ? -1L : unit.convert(timeoutNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public final void durabilityMode(DurabilityMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Durability mode is null");
        }
        this.bogusCheck();
        this.mDurabilityMode = mode;
    }

    @Override
    public final DurabilityMode durabilityMode() {
        return this.mDurabilityMode;
    }

    @Override
    public final void check() throws DatabaseException {
        Object borked = this.mBorked;
        if (borked != null) {
            this.check(borked);
        }
    }

    @Override
    public final boolean isBogus() {
        return this.mBorked == BOGUS;
    }

    private void check(Object borked) throws DatabaseException {
        if (borked == BOGUS) {
            throw new IllegalStateException("Transaction is bogus");
        }
        if (borked instanceof Throwable) {
            Throwable t = (Throwable)borked;
            throw new InvalidTransactionException(t);
        }
        throw new InvalidTransactionException(String.valueOf(borked));
    }

    private void bogusCheck() {
        if (this.mBorked == BOGUS) {
            throw new IllegalStateException("Transaction is bogus");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void commit() throws IOException {
        Locker.ParentScope parentScope;
        Object borked = this.mBorked;
        if (borked != null) {
            if (borked == BOGUS) {
                return;
            }
            this.check(borked);
        }
        if ((parentScope = this.mParentScope) == null) {
            try {
                UndoLog undo = this.mUndoLog;
                if (undo == null) {
                    int hasState = this.mHasState;
                    if ((hasState & 2) != 0) {
                        long commitPos = this.mContext.redoCommitFinal(this);
                        this.mHasState = hasState & 0xFFFFFFFC;
                        if (commitPos != 0L) {
                            if (commitPos == -1L) {
                                return;
                            }
                            this.mRedo.txnCommitSync(commitPos);
                        }
                    }
                    super.scopeUnlockAll();
                } else {
                    long commitPos;
                    CommitLock.Shared shared = this.mDatabase.commitLock().acquireShared();
                    try {
                        commitPos = this.mHasState & 2;
                        if (commitPos != 0L) {
                            commitPos = this.mContext.redoCommitFinal(this);
                            this.mHasState &= 0xFFFFFFFC;
                        }
                        undo.commit();
                    }
                    finally {
                        shared.release();
                    }
                    if (commitPos != 0L) {
                        if (commitPos == -1L) {
                            return;
                        }
                        try {
                            this.mRedo.txnCommitSync(commitPos);
                        }
                        catch (Throwable e) {
                            this.commitSyncFailed(e, commitPos);
                            throw e;
                        }
                    }
                    super.scopeUnlockAll();
                    undo.truncate();
                    this.mContext.unregister(undo);
                    this.mUndoLog = null;
                    int hasState = this.mHasState;
                    if ((hasState & 4) != 0) {
                        this.emptyTrash(hasState);
                    }
                }
                this.mTxnId = 0L;
            }
            catch (Throwable e) {
                this.borked(e, true, true);
            }
        } else {
            try {
                int hasState = this.mHasState;
                if ((hasState & 2) != 0) {
                    this.mContext.redoCommit(this.mRedo, this.mTxnId);
                    this.mHasState = hasState & 0xFFFFFFFC;
                    parentScope.mHasState |= 2;
                }
                super.promote();
                UndoLog undo = this.mUndoLog;
                if (undo != null) {
                    this.mSavepoint = undo.scopeCommit();
                }
            }
            catch (Throwable e) {
                this.borked(e);
            }
        }
    }

    private void commitSyncFailed(Throwable e, long commitPos) {
        if (!Utils.isRecoverable(e)) {
            this.panic(e);
            return;
        }
        try {
            if (e instanceof UnmodifiableReplicaException) {
                this.mUndoLog.uncommit();
                this.mContext.uncommitted(this.mTxnId);
            } else {
                RedoWriter redoWriter = this.mRedo;
                if (redoWriter instanceof ReplWriter) {
                    ReplWriter rw = (ReplWriter)redoWriter;
                    PendingTxn pending = this.preparePending();
                    rw.mReplWriter.uponCommit(commitPos, pos -> {
                        pending.commitPos(pos);
                        pending.run();
                    });
                }
            }
        }
        catch (Throwable e2) {
            Utils.suppress(e, e2);
            this.panic(e);
        }
    }

    PendingTxn preparePending() {
        return new PendingTxn(this);
    }

    private void emptyTrash(int hasState) throws IOException {
        BTree trash = this.mDatabase.tryFragmentedTrash();
        if (trash != null) {
            FragmentedTrash.emptyTrash(trash, this.mTxnId);
        }
        this.mHasState = hasState & 0xFFFFFFFB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void storeCommit(LocalTransaction undoTxn, BTreeCursor cursor, byte[] value) throws IOException {
        if (this.mRedo == null) {
            cursor.storeNoRedo(this, value);
            this.commit();
            return;
        }
        this.check();
        long txnId = this.mTxnId;
        CommitLock.Shared shared = this.mDatabase.commitLock().acquireShared();
        try {
            if (txnId == 0L) {
                txnId = this.doAssignTransactionId();
            }
        }
        catch (Throwable e) {
            shared.release();
            throw e;
        }
        int hasState = this.mHasState;
        byte[] key = cursor.mKey;
        Locker.ParentScope parentScope = this.mParentScope;
        if (parentScope == null) {
            try {
                long commitPos;
                try {
                    long cursorId;
                    cursor.storeNoRedo(undoTxn, value);
                    if ((hasState & 1) == 0) {
                        this.mContext.redoEnter(this.mRedo, txnId);
                        this.mHasState = hasState | 1;
                    }
                    if ((cursorId = cursor.mCursorId) == 0L) {
                        long indexId = cursor.mTree.mId;
                        commitPos = value == null ? this.mContext.redoDeleteCommitFinal(this, indexId, key) : this.mContext.redoStoreCommitFinal(this, indexId, key, value);
                    } else {
                        if (value == null) {
                            this.mContext.redoCursorDelete(this.mRedo, cursorId, txnId, key);
                        } else {
                            this.mContext.redoCursorStore(this.mRedo, cursorId, txnId, key, value);
                        }
                        commitPos = this.mContext.redoCommitFinal(this);
                    }
                }
                catch (Throwable e) {
                    shared.release();
                    throw e;
                }
                this.mHasState = hasState & 0xFFFFFFFC;
                UndoLog undo = this.mUndoLog;
                if (undo == null) {
                    shared.release();
                    if (commitPos != 0L) {
                        if (commitPos == -1L) {
                            return;
                        }
                        this.mRedo.txnCommitSync(commitPos);
                    }
                    super.scopeUnlockAll();
                } else {
                    undo.commit();
                    shared.release();
                    if (commitPos != 0L) {
                        if (commitPos == -1L) {
                            return;
                        }
                        try {
                            this.mRedo.txnCommitSync(commitPos);
                        }
                        catch (Throwable e) {
                            this.commitSyncFailed(e, commitPos);
                            throw e;
                        }
                    }
                    super.scopeUnlockAll();
                    undo.truncate();
                    this.mContext.unregister(undo);
                    this.mUndoLog = null;
                    if ((hasState & 4) != 0) {
                        this.emptyTrash(hasState);
                    }
                }
                this.mTxnId = 0L;
            }
            catch (Throwable e) {
                this.borked(e, true, true);
            }
        } else {
            try {
                try {
                    cursor.storeNoRedo(this, value);
                    long cursorId = cursor.mCursorId;
                    if (cursorId == 0L) {
                        long indexId = cursor.mTree.mId;
                        if ((hasState & 1) == 0) {
                            this.setScopeState(parentScope);
                            if (value == null) {
                                this.mContext.redoDelete(this.mRedo, (byte)37, txnId, indexId, key);
                            } else {
                                this.mContext.redoStore(this.mRedo, (byte)33, txnId, indexId, key, value);
                            }
                        } else if (value == null) {
                            this.mContext.redoDelete(this.mRedo, (byte)38, txnId, indexId, key);
                        } else {
                            this.mContext.redoStore(this.mRedo, (byte)34, txnId, indexId, key, value);
                        }
                    } else if ((hasState & 1) == 0) {
                        this.setScopeState(parentScope);
                        if (value == null) {
                            this.mContext.redoCursorDelete(this.mRedo, cursorId, txnId, key);
                        } else {
                            this.mContext.redoCursorStore(this.mRedo, cursorId, txnId, key, value);
                        }
                    } else {
                        if (value == null) {
                            this.mContext.redoCursorDelete(this.mRedo, cursorId, txnId, key);
                        } else {
                            this.mContext.redoCursorStore(this.mRedo, cursorId, txnId, key, value);
                        }
                        this.mContext.redoCommit(this.mRedo, txnId);
                    }
                }
                finally {
                    shared.release();
                }
                this.mHasState = hasState & 0xFFFFFFFC;
                parentScope.mHasState |= 2;
                super.promote();
                UndoLog undo = this.mUndoLog;
                if (undo != null) {
                    this.mSavepoint = undo.scopeCommit();
                }
            }
            catch (Throwable e) {
                this.borked(e);
            }
        }
    }

    @Override
    public final void commitAll() throws IOException {
        while (true) {
            this.commit();
            if (this.mParentScope == null) break;
            this.exit();
        }
    }

    @Override
    public final void enter() throws IOException {
        this.check();
        try {
            Locker.ParentScope parentScope = super.scopeEnter();
            parentScope.mLockMode = this.mLockMode;
            parentScope.mLockTimeoutNanos = this.mLockTimeoutNanos;
            parentScope.mHasState = this.mHasState;
            this.mLockMode = LockMode.UPGRADABLE_READ;
            UndoLog undo = this.mUndoLog;
            if (undo != null) {
                parentScope.mSavepoint = this.mSavepoint;
                this.mSavepoint = undo.scopeEnter();
            }
            this.mHasState &= 0xFFFFFFFC;
        }
        catch (Throwable e) {
            this.borked(e);
        }
    }

    @Override
    public final void exit() {
        if (this.mBorked != null) {
            super.scopeExit();
            return;
        }
        Locker.ParentScope parentScope = this.mParentScope;
        if (parentScope == null) {
            try {
                this.doRollback(this.mHasState);
            }
            catch (Throwable e) {
                this.borked(e, true, null);
            }
        } else {
            try {
                try {
                    int hasState = this.mHasState;
                    if ((hasState & 1) != 0) {
                        this.mContext.redoRollback(this.mRedo, this.mTxnId);
                        this.mHasState = hasState & 0xFFFFFFFC;
                    }
                }
                catch (UnmodifiableReplicaException hasState) {
                    // empty catch block
                }
                UndoLog undo = this.mUndoLog;
                if (undo != null) {
                    undo.scopeRollback(this.mSavepoint);
                }
                super.scopeExit();
                this.mLockMode = parentScope.mLockMode;
                this.mLockTimeoutNanos = parentScope.mLockTimeoutNanos;
                this.mHasState |= parentScope.mHasState;
                this.mSavepoint = parentScope.mSavepoint;
            }
            catch (Throwable e) {
                this.borked(e, false, null);
            }
        }
    }

    @Override
    public final void reset() {
        if (this.mBorked == null) {
            try {
                this.rollback();
            }
            catch (Throwable e) {
                this.borked(e, true, null);
            }
        } else {
            super.scopeExitAll();
        }
    }

    @Override
    public final void reset(Throwable cause) {
        if (cause == null) {
            try {
                this.reset();
                return;
            }
            catch (Throwable e) {
                cause = e;
            }
        }
        this.borked(cause, true, false);
    }

    private void rollback() throws IOException {
        int hasState = this.mHasState;
        Locker.ParentScope parentScope = this.mParentScope;
        while (parentScope != null) {
            hasState |= parentScope.mHasState;
            parentScope = parentScope.mParentScope;
        }
        this.doRollback(hasState);
    }

    private void doRollback(int hasState) throws IOException {
        UndoLog undo;
        if (hasState != 0) {
            if ((hasState & 8) != 0 && this.tryPreparedRollback()) {
                return;
            }
            if ((hasState & 3) != 0) {
                try {
                    this.mContext.redoRollbackFinal(this.mRedo, this.mTxnId);
                }
                catch (UnmodifiableReplicaException unmodifiableReplicaException) {
                    // empty catch block
                }
            }
            this.mHasState = 0;
        }
        if ((undo = this.mUndoLog) != null) {
            undo.rollback();
        }
        super.scopeExitAll();
        this.mSavepoint = 0L;
        if (undo != null) {
            this.mContext.unregister(undo);
            this.mUndoLog = null;
        }
        this.mTxnId = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryPreparedRollback() throws IOException {
        BTreeCursor c = this.checkPrepared();
        if (c == null) {
            return false;
        }
        try {
            this.mUndoLog.rollbackToPrepare();
            this.unlockToPrepare();
            LocalTransaction carrier = new LocalTransaction(this);
            try {
                CommitLock.Shared shared = this.mDatabase.commitLock().acquireShared();
                try {
                    carrier.undoLog().pushPreparedUnrollback(c.key());
                    c.store(Utils.EMPTY_BYTES);
                    this.mContext.redoPrepareRollback(this.mRedo, carrier.id(), this.mTxnId);
                    carrier.mHasState |= 2;
                }
                finally {
                    shared.release();
                }
                carrier.commit();
            }
            catch (Throwable e) {
                carrier.reset(e);
                if (e instanceof UnmodifiableReplicaException) {
                    this.preparedHandoff(e);
                }
                throw e;
            }
            this.mHasState = 0;
            this.mUndoLog.rollback();
            super.scopeExitAll();
            this.mSavepoint = 0L;
            this.mContext.unregister(this.mUndoLog);
            this.mUndoLog = null;
            this.mTxnId = 0L;
            c.store(null);
            boolean bl = true;
            return bl;
        }
        finally {
            c.reset();
        }
    }

    private void preparedHandoff(Throwable cause) {
        LocalTransaction txn = new LocalTransaction(this.mDatabase, this.mTxnId, LockMode.UPGRADABLE_READ, 0L);
        txn.mHasState = this.mHasState & 0xFFFFFFFC;
        txn.mUndoLog = this.mUndoLog;
        txn.mAttachment = this.mAttachment;
        this.transferExclusive(txn);
        this.mRedo.stashForRecovery(txn);
        this.mRedo = null;
        this.mHasState = 0;
        this.mTxnId = 0L;
        this.mUndoLog = null;
        this.mBorked = cause;
    }

    @Override
    public final void flush() throws IOException {
        if (this.mTxnId != 0L) {
            this.mContext.flush();
        }
    }

    public final String toString() {
        StringBuilder b = new StringBuilder(Transaction.class.getName());
        if (this == BOGUS) {
            return b.append('.').append("BOGUS").toString();
        }
        b.append('@').append(Integer.toHexString(this.hashCode()));
        b.append('{');
        b.append("id").append(": ").append(this.mTxnId);
        b.append(", ");
        b.append("durabilityMode").append(": ").append((Object)this.mDurabilityMode);
        b.append(", ");
        b.append("lockMode").append(": ").append((Object)this.mLockMode);
        b.append(", ");
        b.append("lockTimeout").append(": ");
        TimeUnit unit = Utils.inferUnit(TimeUnit.NANOSECONDS, this.mLockTimeoutNanos);
        Utils.appendTimeout(b, this.lockTimeout(unit), unit);
        Object att = this.mAttachment;
        if (att != null) {
            b.append(", ");
            b.append("attachment").append(": ").append(att);
        }
        try {
            if (this.isPrepared()) {
                b.append(", ");
                b.append((this.mHasState & 0x10) != 0 ? "preparedCommit" : "prepared");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Object borked = this.mBorked;
        if (borked != null) {
            b.append(", ");
            b.append("invalid").append(": ").append(borked);
        }
        return b.append('}').toString();
    }

    final LockResult doLockShared(long indexId, byte[] key, int hash) throws LockFailureException {
        return super.doLockShared(indexId, key, hash, this.mLockTimeoutNanos);
    }

    @Override
    public final LockResult lockShared(long indexId, byte[] key) throws LockFailureException {
        return this.lockShared(indexId, key, this.mLockTimeoutNanos);
    }

    @Override
    public final LockResult lockShared(long indexId, byte[] key, long nanosTimeout) throws LockFailureException {
        return this.doLockShared(indexId, key, nanosTimeout);
    }

    @Override
    public final LockResult tryLockShared(long indexId, byte[] key, long nanosTimeout) throws LockFailureException {
        return this.doTryLockShared(indexId, key, nanosTimeout);
    }

    @Override
    public final LockResult lockUpgradable(long indexId, byte[] key) throws LockFailureException {
        return this.lockUpgradable(indexId, key, this.mLockTimeoutNanos);
    }

    @Override
    public final LockResult lockUpgradable(long indexId, byte[] key, long nanosTimeout) throws LockFailureException {
        return this.doLockUpgradable(indexId, key, nanosTimeout);
    }

    @Override
    public final LockResult tryLockUpgradable(long indexId, byte[] key, long nanosTimeout) throws LockFailureException {
        return this.doTryLockUpgradable(indexId, key, nanosTimeout);
    }

    final LockResult doLockExclusive(long indexId, byte[] key) throws LockFailureException {
        return this.doLockExclusive(indexId, key, this.mLockTimeoutNanos);
    }

    final LockResult doLockExclusive(long indexId, byte[] key, int hash) throws LockFailureException {
        return this.doLockExclusive(indexId, key, hash, this.mLockTimeoutNanos);
    }

    @Override
    public final LockResult lockExclusive(long indexId, byte[] key) throws LockFailureException {
        return this.lockExclusive(indexId, key, this.mLockTimeoutNanos);
    }

    @Override
    public final LockResult lockExclusive(long indexId, byte[] key, long nanosTimeout) throws LockFailureException {
        return this.logExclusiveLock(this.doLockExclusive(indexId, key, nanosTimeout), indexId, key);
    }

    @Override
    public final LockResult tryLockExclusive(long indexId, byte[] key, long nanosTimeout) throws LockFailureException {
        return this.logExclusiveLock(this.doTryLockExclusive(indexId, key, nanosTimeout), indexId, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockResult logExclusiveLock(LockResult result, long indexId, byte[] key) throws LockFailureException {
        block17: {
            if (!result.isAcquired()) {
                return result;
            }
            try {
                this.check();
                CommitLock.Shared shared = this.mDatabase.commitLock().acquireShared();
                try {
                    this.undoLog().pushLock((byte)34, indexId, key);
                }
                catch (Throwable e) {
                    this.borked(e);
                }
                finally {
                    shared.release();
                }
                if (this.mRedo != null && this.mDurabilityMode != DurabilityMode.NO_REDO) {
                    int hasState;
                    long txnId = this.mTxnId;
                    if (txnId == 0L) {
                        txnId = this.assignTransactionId();
                    }
                    if (((hasState = this.mHasState) & 1) == 0) {
                        Locker.ParentScope parentScope = this.mParentScope;
                        if (parentScope != null) {
                            this.setScopeState(parentScope);
                        }
                        this.mContext.redoEnter(this.mRedo, txnId);
                        this.mHasState = hasState | 1;
                    }
                    this.mContext.redoLock(this.mRedo, (byte)31, txnId, indexId, key);
                }
            }
            catch (Throwable e) {
                if (e instanceof UnmodifiableReplicaException || this.mDatabase.isClosed()) break block17;
                LockFailureException fail = new LockFailureException(Utils.rootCause(e));
                try {
                    if (result == LockResult.UPGRADED) {
                        this.doUnlockToUpgradable();
                    } else {
                        this.unlock();
                    }
                }
                catch (Exception e2) {
                    Utils.suppress(fail, e2);
                }
                throw fail;
            }
        }
        return result;
    }

    public final void customRedo(int handlerId, byte[] message, long indexId, byte[] key) throws IOException {
        int hasState;
        this.check();
        if (this.mRedo == null) {
            return;
        }
        long txnId = this.mTxnId;
        if (txnId == 0L) {
            txnId = this.assignTransactionId();
        }
        if (((hasState = this.mHasState) & 1) == 0) {
            Locker.ParentScope parentScope = this.mParentScope;
            if (parentScope != null) {
                this.setScopeState(parentScope);
            }
            this.mContext.redoEnter(this.mRedo, txnId);
        }
        this.mHasState = hasState | 3;
        if (indexId == 0L) {
            if (key != null) {
                throw new IllegalArgumentException("Key cannot be used if indexId is zero");
            }
            this.mContext.redoCustom(this.mRedo, txnId, handlerId, message);
        } else {
            LockResult result = this.lockCheck(indexId, key);
            if (result != LockResult.OWNED_EXCLUSIVE) {
                throw new IllegalStateException("Lock isn't owned exclusively: " + result);
            }
            this.mContext.redoCustomLock(this.mRedo, txnId, handlerId, message, indexId, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void customUndo(int handlerId, byte[] message) throws IOException {
        this.check();
        CommitLock.Shared shared = this.mDatabase.commitLock().acquireShared();
        try {
            this.undoLog().pushCustom(handlerId, message);
        }
        catch (Throwable e) {
            this.borked(e);
        }
        finally {
            shared.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepare(int handlerId, byte[] message, boolean commit) throws IOException {
        this.check();
        long txnId = this.mTxnId;
        if (this.mRedo == null || this.mDurabilityMode == DurabilityMode.NO_REDO || txnId < 0L) {
            throw new IllegalStateException("Cannot prepare a no-redo transaction");
        }
        if (this.mParentScope != null) {
            throw new IllegalStateException("Cannot prepare within a nested scope");
        }
        if (txnId == 0L) {
            txnId = this.assignTransactionId();
        }
        byte[] prepareKey = new byte[8];
        Utils.encodeLongBE(prepareKey, 0, txnId);
        UndoLog undo = this.undoLog();
        BTree preparedTxns = this.mDatabase.preparedTxns();
        if ((this.mHasState & 1) == 0) {
            this.mContext.redoEnter(this.mRedo, txnId);
            this.mHasState |= 1;
        }
        super.scopeEnter();
        long savepoint = undo.savepoint();
        try {
            if (this.lockExclusive(preparedTxns.mId, prepareKey).isAlreadyOwned()) {
                throw new IllegalStateException("Transaction is already prepared");
            }
            LocalTransaction carrier = new LocalTransaction(this);
            try (BTreeCursor c = new BTreeCursor(preparedTxns);){
                c.mTxn = BOGUS;
                c.autoload(false);
                c.find(prepareKey);
                CommitLock.Shared shared = this.mDatabase.commitLock().acquireShared();
                try {
                    carrier.undoLog().pushUnprepare(prepareKey);
                    c.storeGhost(new GhostFrame());
                    this.mContext.redoPrepare(this.mRedo, carrier.id(), txnId, handlerId, message, commit);
                    carrier.mHasState |= 2;
                    undo.pushPrepared(handlerId, message, commit);
                }
                finally {
                    shared.release();
                }
                carrier.commit();
            }
            catch (Throwable e) {
                carrier.reset(e);
                throw e;
            }
            this.mHasState |= 0xA;
            super.promote();
            super.unlockNonExclusive();
        }
        catch (Throwable e) {
            try {
                undo.scopeRollback(savepoint);
            }
            catch (Throwable e2) {
                Utils.suppress(e, e2);
            }
            throw e;
        }
        finally {
            super.scopeExit();
        }
        if (commit) {
            this.finishPrepareCommit(prepareKey, handlerId, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareRedo(int handlerId, byte[] message, boolean commit) throws IOException {
        byte[] prepareKey = new byte[8];
        Utils.encodeLongBE(prepareKey, 0, this.mTxnId);
        UndoLog undo = this.undoLog();
        BTree preparedTxns = this.mDatabase.preparedTxns();
        try (BTreeCursor c = new BTreeCursor(preparedTxns);){
            c.mTxn = BOGUS;
            c.autoload(false);
            c.find(prepareKey);
            CommitLock.Shared shared = this.mDatabase.commitLock().acquireShared();
            try {
                c.storeGhost(new GhostFrame());
                undo.pushPrepared(handlerId, message, commit);
            }
            finally {
                shared.release();
            }
        }
        this.mHasState |= 8;
        if (commit) {
            this.finishPrepareCommit(prepareKey, handlerId, message);
        }
    }

    private void finishPrepareCommit(byte[] prepareKey, int handlerId, byte[] message) throws IOException {
        this.mHasState |= 0x10;
        this.doFinishPrepareCommit(prepareKey, handlerId, message);
    }

    private void doFinishPrepareCommit(int handlerId, byte[] message) throws IOException {
        byte[] prepareKey = new byte[8];
        Utils.encodeLongBE(prepareKey, 0, this.mTxnId);
        this.doFinishPrepareCommit(prepareKey, handlerId, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFinishPrepareCommit(byte[] prepareKey, int handlerId, byte[] message) throws IOException {
        this.unlockAllExceptPrepare();
        UndoLog oldUndo = this.mUndoLog;
        UndoLog newUndo = new UndoLog(this.mDatabase, this.mTxnId);
        newUndo.pushLock((byte)34, 4L, prepareKey);
        newUndo.pushPrepared(handlerId, message, true);
        CommitLock.Shared shared = this.mDatabase.commitLock().acquireShared();
        try {
            oldUndo.commit();
            this.mContext.unregister(oldUndo);
            this.mContext.register(newUndo);
        }
        finally {
            shared.release();
        }
        this.mUndoLog = newUndo;
        oldUndo.truncate();
        int hasState = this.mHasState;
        if ((hasState & 4) != 0) {
            this.emptyTrash(hasState);
        }
    }

    private boolean isPrepared() throws IOException {
        BTreeCursor c = this.checkPrepared();
        if (c == null) {
            return false;
        }
        c.reset();
        return true;
    }

    private BTreeCursor checkPrepared() throws IOException {
        if ((this.mHasState & 8) == 0) {
            return null;
        }
        BTree preparedTxns = this.mDatabase.tryPreparedTxns();
        if (preparedTxns != null) {
            byte[] prepareKey = new byte[8];
            Utils.encodeLongBE(prepareKey, 0, this.mTxnId);
            if (this.lockCheck(preparedTxns.mId, prepareKey) == LockResult.OWNED_EXCLUSIVE) {
                BTreeCursor c = new BTreeCursor(preparedTxns);
                try {
                    c.mTxn = BOGUS;
                    c.autoload(false);
                    c.find(prepareKey);
                    if (c.mFrame.mNotFoundKey == null) {
                        if (c.value() == null) {
                            return c;
                        }
                        c.store(null);
                    }
                    c.reset();
                }
                catch (Throwable e) {
                    c.reset();
                    throw e;
                }
            }
        }
        this.mHasState &= 0xFFFFFFE7;
        return null;
    }

    UndoLog.RTP rollbackForRecovery(RedoWriter redo, DurabilityMode durabilityMode, LockMode lockMode, long timeoutNanos) throws IOException {
        if ((this.mHasState & 8) == 0) {
            throw new AssertionError();
        }
        this.mRedo = redo;
        this.mDurabilityMode = durabilityMode;
        this.mLockMode = lockMode;
        this.mLockTimeoutNanos = timeoutNanos;
        this.mAttachment = null;
        this.mHasState |= 3;
        if (redo == null || durabilityMode == DurabilityMode.NO_REDO) {
            this.mHasState &= 0xFFFFFFFC;
        }
        UndoLog.RTP rtp = this.mUndoLog.rollbackToPrepare();
        this.unlockToPrepare();
        if (rtp.commit) {
            if ((this.mHasState & 0x10) == 0) {
                throw new AssertionError();
            }
            this.doFinishPrepareCommit(rtp.handlerId, rtp.message);
        } else if ((this.mHasState & 0x10) != 0) {
            throw new AssertionError();
        }
        return rtp;
    }

    @Override
    public final long id() {
        long txnId = this.mTxnId;
        if (txnId == 0L && this.mRedo != null) {
            txnId = this.assignTransactionId();
        }
        return txnId < 0L ? 0L : txnId;
    }

    final boolean recoveryCleanup(boolean finish) throws IOException {
        finish |= this.mTxnId < 0L;
        UndoLog undo = this.mUndoLog;
        if (undo != null) {
            finish |= undo.recoveryCleanup();
        }
        if (finish) {
            if (this.isPrepared()) {
                finish = false;
            } else {
                this.reset();
            }
        }
        return finish;
    }

    final void redoStore(long indexId, byte[] key, byte[] value) throws IOException {
        this.check();
        if (this.mRedo == null) {
            return;
        }
        long txnId = this.mTxnId;
        if (txnId == 0L) {
            txnId = this.doAssignTransactionId();
        }
        try {
            int hasState = this.mHasState;
            this.mHasState = hasState | 2;
            if ((hasState & 1) == 0) {
                Locker.ParentScope parentScope = this.mParentScope;
                if (parentScope != null) {
                    this.setScopeState(parentScope);
                }
                if (value == null) {
                    this.mContext.redoDelete(this.mRedo, (byte)36, txnId, indexId, key);
                } else {
                    this.mContext.redoStore(this.mRedo, (byte)32, txnId, indexId, key, value);
                }
                this.mHasState = hasState | 3;
            } else if (value == null) {
                this.mContext.redoDelete(this.mRedo, (byte)37, txnId, indexId, key);
            } else {
                this.mContext.redoStore(this.mRedo, (byte)33, txnId, indexId, key, value);
            }
        }
        catch (Throwable e) {
            this.borked(e);
        }
    }

    final void redoCursorStore(long cursorId, byte[] key, byte[] value) throws IOException {
        this.check();
        long txnId = this.mTxnId;
        if (txnId == 0L) {
            txnId = this.doAssignTransactionId();
        }
        try {
            int hasState = this.mHasState;
            this.mHasState = hasState | 2;
            if ((hasState & 1) == 0) {
                Locker.ParentScope parentScope = this.mParentScope;
                if (parentScope != null) {
                    this.setScopeState(parentScope);
                }
                this.mContext.redoEnter(this.mRedo, txnId);
            }
            if (value == null) {
                this.mContext.redoCursorDelete(this.mRedo, cursorId, txnId, key);
            } else {
                this.mContext.redoCursorStore(this.mRedo, cursorId, txnId, key, value);
            }
            this.mHasState = hasState | 3;
        }
        catch (Throwable e) {
            this.borked(e);
        }
    }

    final long redoStoreNoLock(long indexId, byte[] key, byte[] value) throws IOException {
        this.check();
        if (this.mRedo != null) {
            try {
                return this.mContext.redoStoreNoLockAutoCommit(this.mRedo, indexId, key, value, this.mDurabilityMode);
            }
            catch (Throwable e) {
                this.borked(e);
            }
        }
        return 0L;
    }

    private void setScopeState(Locker.ParentScope scope) throws IOException {
        int hasState = scope.mHasState;
        if ((hasState & 1) == 0) {
            Locker.ParentScope parentScope = scope.mParentScope;
            if (parentScope != null) {
                this.setScopeState(parentScope);
            }
            this.mContext.redoEnter(this.mRedo, this.mTxnId);
            scope.mHasState = hasState | 1;
        }
    }

    final long txnId() {
        long txnId = this.mTxnId;
        if (txnId == 0L) {
            txnId = this.mContext.nextTransactionId();
            if (this.mRedo != null) {
                txnId = this.mRedo.adjustTransactionId(txnId);
            }
            this.mTxnId = txnId;
        }
        return txnId;
    }

    private long doAssignTransactionId() {
        long txnId = this.mContext.nextTransactionId();
        this.mTxnId = txnId = this.mRedo.adjustTransactionId(txnId);
        return txnId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long assignTransactionId() {
        CommitLock.Shared shared = this.mDatabase.commitLock().acquireShared();
        try {
            long l = this.doAssignTransactionId();
            return l;
        }
        finally {
            shared.release();
        }
    }

    final boolean tryRedoCursorRegister(BTreeCursor cursor) throws IOException {
        if (this.mRedo == null || this.mTxnId <= 0L && this.mRedo.adjustTransactionId(1L) <= 0L) {
            return false;
        }
        this.doRedoCursorRegister(cursor);
        return true;
    }

    private long doRedoCursorRegister(BTreeCursor cursor) throws IOException {
        long cursorId = this.mContext.nextTransactionId();
        try {
            this.mContext.redoCursorRegister(this.mRedo, cursorId, cursor.mTree.mId);
        }
        catch (Throwable e) {
            this.borked(e);
        }
        BTree cursorRegistry = this.mDatabase.cursorRegistry();
        cursor.mCursorId = cursorId;
        this.mDatabase.registerCursor(cursorRegistry, cursor);
        return cursorId;
    }

    final void redoCursorValueModify(BTreeCursor cursor, int op, long pos, byte[] buf, int off, long len) throws IOException {
        this.check();
        if (this.mRedo == null) {
            return;
        }
        long txnId = this.mTxnId;
        if (txnId == 0L) {
            txnId = this.doAssignTransactionId();
        }
        try {
            int hasState = this.mHasState;
            if ((hasState & 1) == 0) {
                Locker.ParentScope parentScope = this.mParentScope;
                if (parentScope != null) {
                    this.setScopeState(parentScope);
                }
                this.mContext.redoEnter(this.mRedo, txnId);
            }
            this.mHasState = hasState | 3;
            long cursorId = cursor.mCursorId;
            if (cursorId < 0L) {
                cursorId &= Long.MAX_VALUE;
            } else {
                if (cursorId == 0L) {
                    cursorId = this.doRedoCursorRegister(cursor);
                }
                this.mContext.redoCursorFind(this.mRedo, cursorId, txnId, cursor.mKey);
                cursor.mCursorId = cursorId | Long.MIN_VALUE;
            }
            if (op == 3) {
                this.mContext.redoCursorValueSetLength(this.mRedo, cursorId, txnId, pos);
            } else if (op == 4) {
                this.mContext.redoCursorValueWrite(this.mRedo, cursorId, txnId, pos, buf, off, (int)len);
            } else {
                this.mContext.redoCursorValueClear(this.mRedo, cursorId, txnId, pos, len);
            }
        }
        catch (Throwable e) {
            this.borked(e);
        }
    }

    @Override
    public final void redoPredicateMode() throws IOException {
        RedoWriter redo = this.mRedo;
        if (redo != null) {
            long txnId = this.mTxnId;
            if (txnId == 0L) {
                txnId = this.assignTransactionId();
            }
            try {
                this.mContext.redoPredicateMode(redo, txnId);
            }
            catch (Throwable e) {
                this.borked(e);
            }
        }
    }

    final void setHasTrash() {
        this.mHasState |= 4;
    }

    final void pushUndoStore(long indexId, byte op, byte[] payload, int off, int len) throws IOException {
        this.check();
        try {
            this.undoLog().pushNodeEncoded(indexId, op, payload, off, len);
        }
        catch (Throwable e) {
            this.borked(e);
        }
    }

    final void pushUninsert(long indexId, byte[] key) throws IOException {
        this.check();
        try {
            this.undoLog().pushUninsert(indexId, key);
        }
        catch (Throwable e) {
            this.borked(e);
        }
    }

    final void pushUndeleteFragmented(long indexId, byte[] payload, int off, int len) throws IOException {
        this.check();
        try {
            this.undoLog().pushNodeEncoded(indexId, (byte)22, payload, off, len);
        }
        catch (Throwable e) {
            this.borked(e);
        }
    }

    final void pushUncreate(long indexId, byte[] key) throws IOException {
        this.check();
        try {
            this.undoLog().pushUncreate(indexId, key);
        }
        catch (Throwable e) {
            this.borked(e);
        }
    }

    final void pushUnextend(long indexId, byte[] key, long length) throws IOException {
        this.check();
        try {
            this.undoLog().pushUnextend(this.mSavepoint, indexId, key, length);
        }
        catch (Throwable e) {
            this.borked(e);
        }
    }

    final void pushUnalloc(long indexId, byte[] key, long pos, long length) throws IOException {
        this.check();
        try {
            this.undoLog().pushUnalloc(indexId, key, pos, length);
        }
        catch (Throwable e) {
            this.borked(e);
        }
    }

    final void pushUnwrite(long indexId, byte[] key, long pos, byte[] b, int off, int len) throws IOException {
        this.check();
        try {
            this.undoLog().pushUnwrite(indexId, key, pos, b, off, len);
        }
        catch (Throwable e) {
            this.borked(e);
        }
    }

    private UndoLog undoLog() throws IOException {
        UndoLog undo = this.mUndoLog;
        if (undo == null) {
            undo = new UndoLog(this.mDatabase, this.txnId());
            Locker.ParentScope parentScope = this.mParentScope;
            while (parentScope != null) {
                undo.doScopeEnter();
                parentScope = parentScope.mParentScope;
            }
            this.mContext.register(undo);
            this.mUndoLog = undo;
        }
        return undo;
    }

    final void borked(Throwable borked) {
        this.borked(borked, false, true);
    }

    private void borked(Throwable borked, boolean rollback, Boolean rethrow) {
        block9: {
            boolean closed;
            boolean bl = closed = this.mDatabase != null && this.mDatabase.isClosed();
            if (rethrow == null) {
                rethrow = !closed;
            }
            if (this.mBorked == null) {
                if (closed) {
                    Utils.initCause(borked, this.mDatabase.closedCause());
                    this.mBorked = borked;
                } else if (rollback) {
                    try {
                        this.rollback();
                    }
                    catch (Throwable rollbackFailed) {
                        if (this.mBorked != null) break block9;
                        if (rethrow.booleanValue() && Utils.isRecoverable(borked) && Utils.isRecoverable(rollbackFailed)) {
                            Utils.rethrow(borked);
                        }
                        Utils.suppress(borked, rollbackFailed);
                        this.panic(borked);
                        this.discardAllLocks();
                    }
                    this.mBorked = borked;
                    this.mUndoLog = null;
                }
            }
        }
        if (rethrow.booleanValue()) {
            Utils.rethrow(borked);
        }
    }

    private void panic(Throwable e) {
        try {
            Utils.closeOnFailure(this.mDatabase, e);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

