/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.core.Utils;

final class LockedFile
implements Closeable {
    private final RandomAccessFile mRaf;
    private final FileLock mLock;

    LockedFile(File file, boolean readOnly) throws IOException {
        FileLock lock;
        RandomAccessFile raf;
        block9: {
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                raf = new RandomAccessFile(file, readOnly ? "r" : "rw");
                lock = raf.getChannel().tryLock(8L, 0x7FFFFFFFFFFFFFF7L, readOnly);
                if (lock != null) break block9;
                Object message = "Database is open and locked by another process";
                try {
                    message = (String)message + ": " + raf.readLong();
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
                throw new DatabaseException((String)message);
            }
            catch (FileNotFoundException e) {
                if (readOnly) {
                    raf = null;
                    lock = null;
                }
                throw e;
            }
            catch (OverlappingFileLockException e) {
                throw new DatabaseException("Database is already open in the current process");
            }
        }
        this.mRaf = raf;
        this.mLock = lock;
        if (!readOnly) {
            raf.writeLong(ProcessHandle.current().pid());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mLock != null) {
            this.mLock.close();
        }
        if (this.mRaf != null) {
            this.mRaf.close();
        }
    }

    IOException delete(String path, IOException ex) {
        ex = Utils.closeQuietly(ex, this);
        new File(path).delete();
        return ex;
    }
}

