/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import org.cojen.tupl.CorruptDatabaseException;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.DatabaseFullException;
import org.cojen.tupl.WriteFailureException;
import org.cojen.tupl.core.BTree;
import org.cojen.tupl.core.BTreeCursor;
import org.cojen.tupl.core.CursorFrame;
import org.cojen.tupl.core.DatabaseAccess;
import org.cojen.tupl.core.FragmentedTrash;
import org.cojen.tupl.core.GhostFrame;
import org.cojen.tupl.core.LHashTable;
import org.cojen.tupl.core.LocalDatabase;
import org.cojen.tupl.core.LocalTransaction;
import org.cojen.tupl.core.NodeGroup;
import org.cojen.tupl.core.PageDb;
import org.cojen.tupl.core.PageOps;
import org.cojen.tupl.core.Split;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.diag.VerificationObserver;
import org.cojen.tupl.util.Clutch;

final class Node
extends Clutch
implements DatabaseAccess {
    static final byte CACHED_CLEAN = 0;
    static final byte CACHED_DIRTY_0 = 2;
    static final byte CACHED_DIRTY_1 = 3;
    static final byte TYPE_NONE = 0;
    static final byte TYPE_FRAGMENT = 32;
    static final byte TYPE_UNDO_LOG = 64;
    static final byte TYPE_TN_IN = 100;
    static final byte TYPE_TN_BIN = 116;
    static final byte TYPE_TN_LEAF = -128;
    static final byte LOW_EXTREMITY = 2;
    static final byte HIGH_EXTREMITY = 8;
    static final int TN_HEADER_SIZE = 12;
    private static final int CLOSED_ID = -1;
    static final int ENTRY_FRAGMENTED = 64;
    static final VarHandle cIdHandle;
    final NodeGroup mGroup;
    Node mMoreUsed;
    Node mLessUsed;
    Node mNextDirty;
    Node mPrevDirty;
    byte[] mPage;
    private long mId;
    byte mCachedState;
    private byte mType;
    private int mGarbage;
    private int mLeftSegTail;
    private int mRightSegTail;
    private int mSearchVecStart;
    private int mSearchVecEnd;
    Node mNodeMapNext;
    volatile CursorFrame mLastCursorFrame;
    Split mSplit;
    static final int OPTION_PARENT_RELEASE_SHARED = 1;
    static final int OPTION_CHILD_ACQUIRE_EXCLUSIVE = 4;
    private static final int SMALL_KEY_LIMIT = 128;

    Node(NodeGroup group, byte[] page) {
        this.mGroup = group;
        this.mPage = page;
    }

    Node(NodeGroup group) {
        super(Integer.MIN_VALUE);
        this.mGroup = group;
        this.mPage = PageOps.p_stubTreePage();
        this.id(-1L);
        this.mCachedState = 0;
        this.type((byte)100);
        this.garbage(0);
        this.leftSegTail(12);
        this.rightSegTail(19);
        this.searchVecStart(12);
        this.searchVecEnd(10);
    }

    private Node(long id) {
        super(Integer.MIN_VALUE);
        this.mGroup = null;
        this.id(id);
    }

    Node() {
        this.mGroup = null;
        this.id(Long.MIN_VALUE);
    }

    void delete(LocalDatabase db) {
        this.acquireExclusive();
        try {
            this.doDelete(db);
        }
        finally {
            this.releaseExclusive();
        }
    }

    void doDelete(LocalDatabase db) {
        byte[] page = this.mPage;
        if (!PageOps.isClosedOrDeleted(page)) {
            PageOps.p_delete(page);
            this.closeRoot(PageOps.p_closedTreePage());
        }
    }

    @Override
    protected Clutch.Pack getPack() {
        return this.mGroup;
    }

    @Override
    public LocalDatabase getDatabase() {
        return this.mGroup.mDatabase;
    }

    void asEmptyRoot() {
        this.id(0L);
        this.mCachedState = 0;
        this.type((byte)-118);
        this.clearEntries();
    }

    void asTrimmedRoot() {
        this.asEmptyLeaf(10);
    }

    void asEmptyLeaf(int extremity) {
        this.type((byte)(0xFFFFFF80 | extremity));
        this.clearEntries();
    }

    void asSortLeaf() {
        this.type((byte)-118);
        this.garbage(0);
        this.leftSegTail(12);
        int pageSize = this.pageSize(this.mPage);
        this.rightSegTail(pageSize - 1);
        this.searchVecStart(12);
        this.searchVecEnd(10);
    }

    void closeRoot(byte[] page) {
        this.id(-1L);
        this.mCachedState = 0;
        this.mPage = page;
        this.readFields();
    }

    Node cloneNode() {
        Node newNode = new Node(this.mGroup, this.mPage);
        newNode.id(this.id());
        newNode.mCachedState = this.mCachedState;
        newNode.type(this.type());
        newNode.garbage(this.garbage());
        newNode.leftSegTail(this.leftSegTail());
        newNode.rightSegTail(this.rightSegTail());
        newNode.searchVecStart(this.searchVecStart());
        newNode.searchVecEnd(this.searchVecEnd());
        return newNode;
    }

    private void clearEntries() {
        this.garbage(0);
        this.leftSegTail(12);
        int pageSize = this.pageSize(this.mPage);
        this.rightSegTail(pageSize - 1);
        this.searchVecStart(12 + (pageSize - 12 >> 1) & 0xFFFFFFFE);
        this.searchVecEnd(this.searchVecStart() - 2);
    }

    void used() {
        this.used(ThreadLocalRandom.current());
    }

    void used(ThreadLocalRandom rnd) {
        this.mGroup.used(this, rnd);
    }

    void unused() {
        this.mGroup.unused(this);
    }

    void makeEvictable() {
        this.mGroup.makeEvictable(this);
    }

    void makeEvictableNow() {
        this.mGroup.makeEvictableNow(this);
    }

    void makeUnevictable() {
        this.mGroup.makeUnevictable(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Node loadChild(LocalDatabase db, long childId, int options) throws IOException {
        Node childNode;
        Node lock;
        try {
            lock = new Node(childId);
            if (childId <= 1L) {
                PageOps.checkClosedIndexException(this.mPage);
                throw new CorruptDatabaseException("Illegal child id: " + childId);
            }
        }
        catch (Throwable e) {
            this.releaseEither();
            throw e;
        }
        try {
            while ((childNode = db.nodeMapPutIfAbsent(lock)) != null) {
                if ((options & 4) == 0) {
                    childNode.acquireShared();
                    if (childId == childNode.id()) {
                        Node node = childNode;
                        return node;
                    }
                    childNode.releaseShared();
                    continue;
                }
                childNode.acquireExclusive();
                if (childId == childNode.id()) {
                    Node node = childNode;
                    return node;
                }
                childNode.releaseExclusive();
            }
        }
        finally {
            if ((options & 1) != 0) {
                this.releaseShared();
            }
        }
        try {
            try {
                childNode = db.allocLatchedNode();
                childNode.id(childId);
            }
            catch (Throwable e) {
                db.nodeMapRemove(lock);
                throw e;
            }
            db.nodeMapReplace(lock, childNode);
            try {
                childNode.read(db, childId);
            }
            catch (Throwable e) {
                db.nodeMapRemove(childNode);
                childNode.id(0L);
                childNode.type((byte)0);
                childNode.releaseExclusive();
                throw e;
            }
            if ((options & 4) == 0) {
                childNode.downgrade();
            }
            Node node = childNode;
            return node;
        }
        catch (Throwable e) {
            if ((options & 1) == 0) {
                this.releaseEither();
            }
            throw e;
        }
        finally {
            lock.id(0L);
            lock.releaseExclusive();
        }
    }

    private Node tryLatchChildNotSplit(int childPos) throws IOException {
        Node childNode;
        block6: {
            LocalDatabase db;
            long childId;
            block5: {
                childId = this.retrieveChildRefId(childPos);
                db = this.getDatabase();
                childNode = db.nodeMapGet(childId);
                if (childNode == null) break block5;
                if (!childNode.tryAcquireExclusive()) {
                    return null;
                }
                if (childId == childNode.id()) break block6;
                childNode.releaseExclusive();
            }
            childNode = this.loadChild(db, childId, 4);
        }
        if (childNode.mSplit == null) {
            return childNode;
        }
        childNode.releaseExclusive();
        return null;
    }

    void finishSplitRoot() throws IOException {
        Node right;
        Node left;
        LocalDatabase db = this.mGroup.mDatabase;
        Node child = db.allocDirtyNode();
        db.nodeMapPut(child);
        byte[] newRootPage = child.mPage;
        child.mPage = this.mPage;
        child.type(this.type());
        child.garbage(this.garbage());
        child.leftSegTail(this.leftSegTail());
        child.rightSegTail(this.rightSegTail());
        child.searchVecStart(this.searchVecStart());
        child.searchVecEnd(this.searchVecEnd());
        Split split = this.mSplit;
        Node sibling = this.rebindSplitFrames(split);
        this.mSplit = null;
        CursorFrame frame = this.mLastCursorFrame;
        while (frame != null) {
            CursorFrame prev = frame.mPrevCousin;
            frame.rebind(child, frame.mNodePos);
            frame = prev;
        }
        if (split.mSplitRight) {
            left = child;
            right = sibling;
        } else {
            left = sibling;
            right = child;
        }
        int leftSegTail = split.copySplitKeyToParent(newRootPage, 12);
        int searchVecStart = this.pageSize(newRootPage) - (this.pageSize(newRootPage) - leftSegTail + 18 >> 1 & 0xFFFFFFFE);
        PageOps.p_shortPutLE(newRootPage, searchVecStart, 12);
        PageOps.p_longPutLE(newRootPage, searchVecStart + 2, left.id());
        PageOps.p_longPutLE(newRootPage, searchVecStart + 2 + 8, right.id());
        byte newType = this.isLeaf() ? (byte)126 : 110;
        this.mPage = newRootPage;
        this.type(newType);
        this.garbage(0);
        this.leftSegTail(leftSegTail);
        this.rightSegTail(this.pageSize(newRootPage) - 1);
        this.searchVecStart(searchVecStart);
        this.searchVecEnd(searchVecStart);
        CursorFrame lock = new CursorFrame();
        this.addParentFrames(lock, left, 0);
        this.addParentFrames(lock, right, 2);
        child.releaseExclusive();
        sibling.releaseExclusive();
        sibling.makeEvictable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addParentFrames(CursorFrame lock, Node child, int pos) {
        CursorFrame frame = child.mLastCursorFrame;
        while (frame != null) {
            CursorFrame lockResult = frame.tryLock(lock);
            if (lockResult != null) {
                try {
                    CursorFrame parentFrame = frame.mParentFrame;
                    if (parentFrame == null) {
                        parentFrame = new CursorFrame();
                        parentFrame.bind(this, pos);
                        frame.mParentFrame = parentFrame;
                    } else {
                        parentFrame.rebind(this, pos);
                    }
                }
                finally {
                    frame.unlock(lockResult);
                }
            }
            frame = frame.mPrevCousin;
        }
    }

    void read(LocalDatabase db, long id) throws IOException {
        db.readNode(this, id);
        try {
            this.readFields();
        }
        catch (IllegalStateException e) {
            throw new CorruptDatabaseException(e.getMessage());
        }
    }

    private void readFields() throws IllegalStateException {
        byte[] page = this.mPage;
        byte type = PageOps.p_byteGet(page, 0);
        this.type(type);
        this.garbage(PageOps.p_ushortGetLE(page, 2));
        if (type != 64) {
            this.leftSegTail(PageOps.p_ushortGetLE(page, 4));
            this.rightSegTail(PageOps.p_ushortGetLE(page, 6));
            this.searchVecStart(PageOps.p_ushortGetLE(page, 8));
            this.searchVecEnd(PageOps.p_ushortGetLE(page, 10));
            type = (byte)(type & 0xFFFFFFF5);
            if (type >= 0 && type != 100 && type != 116) {
                throw new IllegalStateException("Unknown node type: " + type + ", id: " + this.id());
            }
        }
        if (PageOps.p_byteGet(page, 1) != 0) {
            throw new IllegalStateException("Illegal reserved byte in node: " + PageOps.p_byteGet(page, 1) + ", id: " + this.id());
        }
    }

    void write(PageDb db) throws WriteFailureException {
        byte[] page = this.prepareWrite();
        try {
            db.writePage(this.id(), page);
        }
        catch (IOException e) {
            throw WriteFailureException.from(e);
        }
    }

    private byte[] prepareWrite() {
        if (this.mSplit != null) {
            throw new AssertionError((Object)"Cannot write partially split node");
        }
        byte[] page = this.mPage;
        if (this.type() != 32) {
            PageOps.p_bytePut(page, 0, this.type());
            PageOps.p_bytePut(page, 1, 0);
            PageOps.p_shortPutLE(page, 2, this.garbage());
            if (this.type() != 64) {
                PageOps.p_shortPutLE(page, 4, this.leftSegTail());
                PageOps.p_shortPutLE(page, 6, this.rightSegTail());
                PageOps.p_shortPutLE(page, 8, this.searchVecStart());
                PageOps.p_shortPutLE(page, 10, this.searchVecEnd());
            }
        }
        return page;
    }

    boolean evict(LocalDatabase db) throws IOException {
        CursorFrame last = this.mLastCursorFrame;
        if (last != null) {
            CursorFrame frame = last;
            do {
                if (frame instanceof GhostFrame) continue;
                this.releaseExclusive();
                return false;
            } while ((frame = frame.mPrevCousin) != null);
            do {
                frame = last.mPrevCousin;
                CursorFrame.popAll(last);
            } while ((last = frame) != null);
        }
        try {
            long id = this.id();
            if (id > 0L) {
                if (this.mCachedState != 0) {
                    byte[] page = this.prepareWrite();
                    byte[] newPage = db.mPageDb.evictPage(id, page);
                    if (newPage != page) {
                        this.mPage = newPage;
                    }
                    this.mCachedState = 0;
                }
                db.nodeMapRemove(this, Long.hashCode(id));
                this.id(0L);
            }
            return true;
        }
        catch (Throwable e) {
            this.releaseExclusive();
            throw e;
        }
    }

    void invalidateCursors(byte[] page) {
        this.invalidateCursors(page, Node.createClosedNode(page));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateCursors(byte[] page, Node closed) {
        int childPtr;
        int pos = this.isLeaf() ? -1 : 0;
        closed.acquireExclusive();
        try {
            CursorFrame frame = this.mLastCursorFrame;
            while (frame != null) {
                CursorFrame prev = frame.mPrevCousin;
                frame.rebind(closed, pos);
                frame = prev;
            }
        }
        finally {
            closed.releaseExclusive();
        }
        if (!this.isInternal()) {
            return;
        }
        LocalDatabase db = this.mGroup.mDatabase;
        closed = null;
        int highestPtr = childPtr + (this.highestInternalPos() << 2);
        for (childPtr = this.searchVecEnd() + 2; childPtr <= highestPtr; childPtr += 8) {
            long childId = PageOps.p_uint48GetLE(this.mPage, childPtr);
            Node child = db.nodeMapGetExclusive(childId);
            if (child == null) continue;
            try {
                if (closed == null) {
                    closed = Node.createClosedNode(page);
                }
                child.invalidateCursors(page, closed);
                continue;
            }
            finally {
                child.releaseExclusive();
            }
        }
    }

    private static Node createClosedNode(byte[] page) {
        Node closed = new Node(null, page);
        closed.id(-1L);
        closed.mCachedState = 0;
        closed.readFields();
        return closed;
    }

    private int pageSize(byte[] page) {
        return page.length;
    }

    long id() {
        return cIdHandle.getOpaque(this);
    }

    void id(long id) {
        cIdHandle.setOpaque(this, id);
    }

    byte type() {
        return this.mType;
    }

    void type(byte type) {
        this.mType = type;
    }

    int garbage() {
        return this.mGarbage;
    }

    void garbage(int garbage) {
        this.mGarbage = garbage;
    }

    int undoTop() {
        return this.mGarbage;
    }

    void undoTop(int top) {
        this.mGarbage = top;
    }

    private int leftSegTail() {
        return this.mLeftSegTail;
    }

    private void leftSegTail(int tail) {
        this.mLeftSegTail = tail;
    }

    private int rightSegTail() {
        return this.mRightSegTail;
    }

    private void rightSegTail(int tail) {
        this.mRightSegTail = tail;
    }

    int searchVecStart() {
        return this.mSearchVecStart;
    }

    void searchVecStart(int start) {
        this.mSearchVecStart = start;
    }

    int searchVecEnd() {
        return this.mSearchVecEnd;
    }

    void searchVecEnd(int end) {
        this.mSearchVecEnd = end;
    }

    boolean isLeaf() {
        return this.type() < 0;
    }

    boolean isInternal() {
        return (this.type() & 0xE0) == 96;
    }

    boolean isBottomInternal() {
        return (this.type() & 0xF0) == 112;
    }

    boolean isNonBottomInternal() {
        return (this.type() & 0xF0) == 96;
    }

    int numKeys() {
        return this.searchVecEnd() - this.searchVecStart() + 2 >> 1;
    }

    boolean hasKeys() {
        return this.searchVecEnd() >= this.searchVecStart();
    }

    int highestKeyPos() {
        return this.searchVecEnd() - this.searchVecStart();
    }

    int highestPos() {
        int pos = this.searchVecEnd() - this.searchVecStart();
        if (!this.isLeaf()) {
            pos += 2;
        }
        return pos;
    }

    int highestLeafPos() {
        return this.searchVecEnd() - this.searchVecStart();
    }

    int highestInternalPos() {
        return this.searchVecEnd() - this.searchVecStart() + 2;
    }

    int availableBytes() {
        return this.isLeaf() ? this.availableLeafBytes() : this.availableInternalBytes();
    }

    int availableLeafBytes() {
        return this.garbage() + this.searchVecStart() - this.searchVecEnd() - this.leftSegTail() + this.rightSegTail() + -1;
    }

    int availableInternalBytes() {
        return this.garbage() + 5 * (this.searchVecStart() - this.searchVecEnd()) - this.leftSegTail() + this.rightSegTail() + -17;
    }

    int countNonGhostKeys() {
        return this.countNonGhostKeys(this.searchVecStart(), this.searchVecEnd());
    }

    int countNonGhostKeys(int lowPos, int highPos) {
        byte[] page = this.mPage;
        int count = 0;
        for (int i = lowPos; i <= highPos; i += 2) {
            int loc = PageOps.p_ushortGetLE(page, i);
            if (PageOps.p_byteGet(page, loc + Node.keyLengthAtLoc(page, loc)) == -1) continue;
            ++count;
        }
        return count;
    }

    boolean shouldLeafMerge() {
        return this.shouldMerge(this.availableLeafBytes());
    }

    boolean shouldInternalMerge() {
        return this.shouldMerge(this.availableInternalBytes());
    }

    boolean shouldMerge(int availBytes) {
        return this.mSplit == null && ((this.type() & 0xA) == 0 && availBytes >= this.pageSize(this.mPage) - 12 >> 1 || !this.hasKeys());
    }

    boolean canQuickDeleteGhost() {
        return this.type() == -118 || this.searchVecEnd() > this.searchVecStart();
    }

    /*
     * Enabled aggressive block sorting
     */
    int binarySearch(byte[] key) throws IOException {
        int startPos;
        byte[] page = this.mPage;
        int keyLen = key.length;
        int lowPos = startPos = this.searchVecStart();
        int highPos = this.searchVecEnd();
        int lowMatch = 0;
        int highMatch = 0;
        block0: while (true) {
            int i;
            int compareLen;
            int midPos;
            block12: {
                int minLen;
                int compareLoc;
                block11: {
                    int minLen2;
                    byte[] compareKey;
                    block10: {
                        block9: {
                            block8: {
                                if (lowPos > highPos) {
                                    return ~(lowPos - startPos);
                                }
                                midPos = lowPos + highPos >> 1 & 0xFFFFFFFE;
                                compareLoc = PageOps.p_ushortGetLE(page, midPos);
                                if ((compareLen = PageOps.p_byteGet(page, compareLoc++)) < 0) break block8;
                                ++compareLen;
                                break block9;
                            }
                            int header = compareLen;
                            compareLen = (compareLen & 0x3F) << 8 | PageOps.p_ubyteGet(page, compareLoc++);
                            if ((header & 0x40) == 0) break block9;
                            compareKey = this.getDatabase().reconstructKey(page, compareLoc, compareLen);
                            compareLen = compareKey.length;
                            minLen2 = Math.min(compareLen, keyLen);
                            break block10;
                        }
                        minLen = Math.min(compareLen, keyLen);
                        break block11;
                    }
                    for (i = Math.min(lowMatch, highMatch); i < minLen2; ++i) {
                        byte cb = compareKey[i];
                        byte kb = key[i];
                        if (cb == kb) continue;
                        if ((cb & 0xFF) < (kb & 0xFF)) {
                            lowPos = midPos + 2;
                            lowMatch = i;
                            continue block0;
                        }
                        highPos = midPos - 2;
                        highMatch = i;
                        continue block0;
                    }
                    break block12;
                }
                for (i = Math.min(lowMatch, highMatch); i < minLen; ++i) {
                    byte kb;
                    byte cb = PageOps.p_byteGet(page, compareLoc + i);
                    if (cb == (kb = key[i])) continue;
                    if ((cb & 0xFF) < (kb & 0xFF)) {
                        lowPos = midPos + 2;
                        lowMatch = i;
                        continue block0;
                    }
                    highPos = midPos - 2;
                    highMatch = i;
                    continue block0;
                }
            }
            if (compareLen < keyLen) {
                lowPos = midPos + 2;
                lowMatch = i;
                continue;
            }
            if (compareLen <= keyLen) {
                return midPos - startPos;
            }
            highPos = midPos - 2;
            highMatch = i;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    int binarySearch(byte[] key, int midPos) throws IOException {
        int highPos;
        int startPos = this.searchVecStart();
        int lowPos = startPos;
        if (lowPos > (highPos = this.searchVecEnd())) {
            return -1;
        }
        if ((midPos += lowPos) > highPos) {
            midPos = highPos;
        }
        byte[] page = this.mPage;
        int keyLen = key.length;
        int lowMatch = 0;
        int highMatch = 0;
        while (true) {
            block12: {
                int i;
                int compareLen;
                block17: {
                    int minLen;
                    int compareLoc;
                    block16: {
                        int minLen2;
                        byte[] compareKey;
                        block15: {
                            block14: {
                                block13: {
                                    compareLoc = PageOps.p_ushortGetLE(page, midPos);
                                    if ((compareLen = PageOps.p_byteGet(page, compareLoc++)) < 0) break block13;
                                    ++compareLen;
                                    break block14;
                                }
                                int header = compareLen;
                                compareLen = (compareLen & 0x3F) << 8 | PageOps.p_ubyteGet(page, compareLoc++);
                                if ((header & 0x40) == 0) break block14;
                                compareKey = this.getDatabase().reconstructKey(page, compareLoc, compareLen);
                                compareLen = compareKey.length;
                                minLen2 = Math.min(compareLen, keyLen);
                                break block15;
                            }
                            minLen = Math.min(compareLen, keyLen);
                            break block16;
                        }
                        for (i = Math.min(lowMatch, highMatch); i < minLen2; ++i) {
                            byte cb = compareKey[i];
                            byte kb = key[i];
                            if (cb == kb) continue;
                            if ((cb & 0xFF) < (kb & 0xFF)) {
                                lowPos = midPos + 2;
                                lowMatch = i;
                                break block12;
                            } else {
                                highPos = midPos - 2;
                                highMatch = i;
                            }
                            break block12;
                        }
                        break block17;
                    }
                    for (i = Math.min(lowMatch, highMatch); i < minLen; ++i) {
                        byte kb;
                        byte cb = PageOps.p_byteGet(page, compareLoc + i);
                        if (cb == (kb = key[i])) continue;
                        if ((cb & 0xFF) < (kb & 0xFF)) {
                            lowPos = midPos + 2;
                            lowMatch = i;
                            break block12;
                        } else {
                            highPos = midPos - 2;
                            highMatch = i;
                        }
                        break block12;
                    }
                }
                if (compareLen < keyLen) {
                    lowPos = midPos + 2;
                    lowMatch = i;
                } else {
                    if (compareLen <= keyLen) return midPos - startPos;
                    highPos = midPos - 2;
                    highMatch = i;
                }
            }
            if (lowPos > highPos) {
                return ~(lowPos - startPos);
            }
            midPos = lowPos + highPos >> 1 & 0xFFFFFFFE;
        }
    }

    static int internalPos(int pos) {
        return pos < 0 ? ~pos : pos + 2;
    }

    int compareKey(int pos, byte[] rightKey) throws IOException {
        int keyLen;
        byte[] page = this.mPage;
        int loc = PageOps.p_ushortGetLE(page, this.searchVecStart() + pos);
        if ((keyLen = PageOps.p_byteGet(page, loc++)) >= 0) {
            ++keyLen;
        } else {
            int header = keyLen;
            keyLen = (keyLen & 0x3F) << 8 | PageOps.p_ubyteGet(page, loc++);
            if ((header & 0x40) != 0) {
                byte[] leftKey = this.getDatabase().reconstructKey(page, loc, keyLen);
                return Arrays.compareUnsigned(leftKey, rightKey);
            }
        }
        return PageOps.p_compareKeysPageToArray(page, loc, keyLen, rightKey, 0, rightKey.length);
    }

    static int compareKeys(Node left, int leftLoc, Node right, int rightLoc) throws IOException {
        byte[] leftPage = left.mPage;
        byte[] rightPage = right.mPage;
        int leftLen = PageOps.p_byteGet(leftPage, leftLoc++);
        int rightLen = PageOps.p_byteGet(rightPage, rightLoc++);
        if (leftLen >= 0) {
            ++leftLen;
        } else {
            int leftHeader = leftLen;
            leftLen = (leftLen & 0x3F) << 8 | PageOps.p_ubyteGet(leftPage, leftLoc++);
            if ((leftHeader & 0x40) != 0) {
                byte[] leftKey = left.getDatabase().reconstructKey(leftPage, leftLoc, leftLen);
                if (rightLen >= 0) {
                    ++rightLen;
                } else {
                    int rightHeader = rightLen;
                    rightLen = (rightLen & 0x3F) << 8 | PageOps.p_ubyteGet(rightPage, rightLoc++);
                    if ((rightHeader & 0x40) != 0) {
                        byte[] rightKey = right.getDatabase().reconstructKey(rightPage, rightLoc, rightLen);
                        return Arrays.compareUnsigned(leftKey, rightKey);
                    }
                }
                return -PageOps.p_compareKeysPageToArray(rightPage, rightLoc, rightLen, leftKey, 0, leftKey.length);
            }
        }
        if (rightLen >= 0) {
            ++rightLen;
        } else {
            int rightHeader = rightLen;
            rightLen = (rightLen & 0x3F) << 8 | PageOps.p_ubyteGet(rightPage, rightLoc++);
            if ((rightHeader & 0x40) != 0) {
                byte[] rightKey = right.getDatabase().reconstructKey(rightPage, rightLoc, rightLen);
                return PageOps.p_compareKeysPageToArray(leftPage, leftLoc, leftLen, rightKey, 0, rightKey.length);
            }
        }
        return PageOps.p_compareKeysPageToPage(leftPage, leftLoc, leftLen, rightPage, rightLoc, rightLen);
    }

    void retrieveKeyStats(int pos, long[] stats) throws IOException {
        int keyLen;
        byte[] page = this.mPage;
        int loc = PageOps.p_ushortGetLE(page, this.searchVecStart() + pos);
        if ((keyLen = PageOps.p_byteGet(page, loc++)) >= 0) {
            ++keyLen;
        } else {
            int header = keyLen;
            keyLen = (keyLen & 0x3F) << 8 | PageOps.p_ubyteGet(page, loc++);
            if ((header & 0x40) != 0) {
                this.getDatabase().reconstruct(page, loc, keyLen, stats);
                return;
            }
        }
        stats[0] = keyLen;
        stats[1] = 0L;
    }

    byte[] retrieveKey(int pos) throws IOException {
        byte[] page = this.mPage;
        return Node.retrieveKeyAtLoc(this, page, PageOps.p_ushortGetLE(page, this.searchVecStart() + pos));
    }

    byte[] retrieveKeyAtLoc(byte[] page, int loc) throws IOException {
        return Node.retrieveKeyAtLoc(this, page, loc);
    }

    static byte[] retrieveKeyAtLoc(DatabaseAccess dbAccess, byte[] page, int loc) throws IOException {
        int keyLen;
        if ((keyLen = PageOps.p_byteGet(page, loc++)) >= 0) {
            ++keyLen;
        } else {
            int header = keyLen;
            keyLen = (keyLen & 0x3F) << 8 | PageOps.p_ubyteGet(page, loc++);
            if ((header & 0x40) != 0) {
                return dbAccess.getDatabase().reconstructKey(page, loc, keyLen);
            }
        }
        byte[] key = new byte[keyLen];
        PageOps.p_copyToArray(page, loc, key, 0, keyLen);
        return key;
    }

    private void retrieveKeyAtLoc(byte[] page, int loc, Split split) throws IOException {
        byte[] fullKey;
        byte[] actualKey;
        int keyLen;
        if ((keyLen = PageOps.p_byteGet(page, loc++)) >= 0) {
            actualKey = new byte[++keyLen];
            PageOps.p_copyToArray(page, loc, actualKey, 0, keyLen);
            fullKey = actualKey;
        } else {
            int header = keyLen;
            keyLen = (keyLen & 0x3F) << 8 | PageOps.p_ubyteGet(page, loc++);
            actualKey = new byte[keyLen];
            PageOps.p_copyToArray(page, loc, actualKey, 0, keyLen);
            fullKey = actualKey;
            if ((header & 0x40) != 0) {
                fullKey = this.getDatabase().reconstructKey(page, loc, keyLen);
            }
        }
        split.setKey(fullKey, actualKey);
    }

    private static boolean retrieveActualKeyAtLoc(byte[] page, int loc, byte[][] akeyRef) throws IOException {
        int keyLen;
        boolean result = true;
        if ((keyLen = PageOps.p_byteGet(page, loc++)) >= 0) {
            ++keyLen;
        } else {
            int header = keyLen;
            keyLen = (keyLen & 0x3F) << 8 | PageOps.p_ubyteGet(page, loc++);
            result = (header & 0x40) == 0;
        }
        byte[] akey = new byte[keyLen];
        PageOps.p_copyToArray(page, loc, akey, 0, keyLen);
        akeyRef[0] = akey;
        return result;
    }

    byte[] retrieveKeyCmp(int pos, byte[] limitKey, int limitMode) throws IOException {
        int keyLen;
        byte[] page = this.mPage;
        int loc = PageOps.p_ushortGetLE(page, this.searchVecStart() + pos);
        if ((keyLen = PageOps.p_byteGet(page, loc++)) >= 0) {
            ++keyLen;
        } else {
            int header = keyLen;
            keyLen = (keyLen & 0x3F) << 8 | PageOps.p_ubyteGet(page, loc++);
            if ((header & 0x40) != 0) {
                byte[] key = this.getDatabase().reconstructKey(page, loc, keyLen);
                int cmp = Arrays.compareUnsigned(key, limitKey);
                if (cmp == 0) {
                    return limitKey;
                }
                return (byte[])((cmp ^ limitMode) < 0 ? key : null);
            }
        }
        int cmp = PageOps.p_compareKeysPageToArray(page, loc, keyLen, limitKey, 0, limitKey.length);
        if (cmp == 0) {
            return limitKey;
        }
        if ((cmp ^ limitMode) < 0) {
            byte[] key = new byte[keyLen];
            PageOps.p_copyToArray(page, loc, key, 0, keyLen);
            return key;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    static byte[][] retrieveKeyValueAtLoc(DatabaseAccess dbAccess, byte[] page, int loc) throws IOException {
        block2: {
            if ((header = PageOps.p_byteGet(page, loc++)) < 0) break block2;
            keyLen = header + 1;
            ** GOTO lbl-1000
        }
        keyLen = (header & 63) << 8 | PageOps.p_ubyteGet(page, loc++);
        if ((header & 64) != 0) {
            key = dbAccess.getDatabase().reconstructKey(page, loc, keyLen);
        } else lbl-1000:
        // 2 sources

        {
            key = new byte[keyLen];
            PageOps.p_copyToArray(page, loc, key, 0, keyLen);
        }
        return new byte[][]{key, Node.retrieveLeafValueAtLoc(null, page, loc + keyLen)};
    }

    static byte[] expandKeyAtLoc(DatabaseAccess dbAccess, byte[] page, int loc, int len, boolean stripValueHeader) throws IOException {
        int endLoc = loc + len;
        int keyLen = (PageOps.p_byteGet(page, loc++) & 0x3F) << 8 | PageOps.p_ubyteGet(page, loc++);
        int valueLoc = loc + keyLen;
        int valueLen = endLoc - valueLoc;
        if (stripValueHeader) {
            int skip = 1;
            byte header = PageOps.p_byteGet(page, valueLoc);
            if (header < 0) {
                if ((header & 0x20) == 0) {
                    skip = 2;
                } else if (header != -1) {
                    skip = 3;
                }
            }
            valueLoc += skip;
            valueLen -= skip;
        }
        byte[] key = dbAccess.getDatabase().reconstructKey(page, loc, keyLen);
        int keyHeaderLen = Utils.calcUnsignedVarIntLength(key.length);
        byte[] expanded = new byte[keyHeaderLen + key.length + valueLen];
        int offset = Utils.encodeUnsignedVarInt(expanded, 0, key.length);
        System.arraycopy(key, 0, expanded, offset, key.length);
        PageOps.p_copyToArray(page, valueLoc, expanded, offset += key.length, valueLen);
        return expanded;
    }

    private byte[] midKey(int lowPos, byte[] highKey) throws IOException {
        byte[] lowPage = this.mPage;
        int lowLoc = PageOps.p_ushortGetLE(lowPage, this.searchVecStart() + lowPos);
        byte lowKeyLen = PageOps.p_byteGet(lowPage, lowLoc);
        if (lowKeyLen < 0) {
            return Utils.midKey(this.retrieveKeyAtLoc(lowPage, lowLoc), highKey);
        }
        return PageOps.p_midKeyLowPage(lowPage, lowLoc + 1, lowKeyLen + 1, highKey, 0);
    }

    private byte[] midKey(byte[] lowKey, int highPos) throws IOException {
        byte[] highPage = this.mPage;
        int highLoc = PageOps.p_ushortGetLE(highPage, this.searchVecStart() + highPos);
        byte highKeyLen = PageOps.p_byteGet(highPage, highLoc);
        if (highKeyLen < 0) {
            return Utils.midKey(lowKey, this.retrieveKeyAtLoc(highPage, highLoc));
        }
        return PageOps.p_midKeyHighPage(lowKey, 0, lowKey.length, highPage, highLoc + 1);
    }

    byte[] midKey(int lowPos, Node highNode, int highPos) throws IOException {
        byte[] lowPage = this.mPage;
        int lowLoc = PageOps.p_ushortGetLE(lowPage, this.searchVecStart() + lowPos);
        int lowKeyLen = PageOps.p_byteGet(lowPage, lowLoc);
        if (lowKeyLen < 0) {
            return highNode.midKey(this.retrieveKeyAtLoc(lowPage, lowLoc), highPos);
        }
        ++lowLoc;
        ++lowKeyLen;
        byte[] highPage = highNode.mPage;
        int highLoc = PageOps.p_ushortGetLE(highPage, highNode.searchVecStart() + highPos);
        byte highKeyLen = PageOps.p_byteGet(highPage, highLoc);
        if (highKeyLen < 0) {
            byte[] highKey = this.retrieveKeyAtLoc(highPage, highLoc);
            return PageOps.p_midKeyLowPage(lowPage, lowLoc, lowKeyLen, highKey, 0);
        }
        return PageOps.p_midKeyLowHighPage(lowPage, lowLoc, lowKeyLen, highPage, highLoc + 1);
    }

    byte[] hasLeafValue(int pos) {
        byte[] page = this.mPage;
        int loc = PageOps.p_ushortGetLE(page, this.searchVecStart() + pos);
        return PageOps.p_byteGet(page, loc += Node.keyLengthAtLoc(page, loc)) == -1 ? null : Cursor.NOT_LOADED;
    }

    void retrieveLeafValueStats(int pos, long[] stats) throws IOException {
        int len;
        int header;
        byte[] page = this.mPage;
        int loc = PageOps.p_ushortGetLE(page, this.searchVecStart() + pos);
        loc += Node.keyLengthAtLoc(page, loc);
        if ((header = PageOps.p_byteGet(page, loc++)) >= 0) {
            len = header;
        } else {
            if ((header & 0x20) == 0) {
                len = 1 + ((header & 0x1F) << 8 | PageOps.p_ubyteGet(page, loc++));
            } else if (header != -1) {
                len = 1 + ((header & 0xF) << 16 | PageOps.p_ubyteGet(page, loc++) << 8 | PageOps.p_ubyteGet(page, loc++));
            } else {
                stats[0] = 0L;
                stats[1] = 0L;
                return;
            }
            if ((header & 0x40) != 0) {
                this.getDatabase().reconstruct(page, loc, len, stats);
                return;
            }
        }
        stats[0] = len;
        stats[1] = 0L;
    }

    byte[] retrieveLeafValue(int pos) throws IOException {
        byte[] page = this.mPage;
        int loc = PageOps.p_ushortGetLE(page, this.searchVecStart() + pos);
        loc += Node.keyLengthAtLoc(page, loc);
        return Node.retrieveLeafValueAtLoc(this, page, loc);
    }

    static byte[] retrieveLeafValueAtLoc(DatabaseAccess dbAccess, byte[] page, int loc) throws IOException {
        int len;
        int header;
        if ((header = PageOps.p_byteGet(page, loc++)) == 0) {
            return Utils.EMPTY_BYTES;
        }
        if (header >= 0) {
            len = header;
        } else {
            if ((header & 0x20) == 0) {
                len = 1 + ((header & 0x1F) << 8 | PageOps.p_ubyteGet(page, loc++));
            } else if (header != -1) {
                len = 1 + ((header & 0xF) << 16 | PageOps.p_ubyteGet(page, loc++) << 8 | PageOps.p_ubyteGet(page, loc++));
            } else {
                return null;
            }
            if ((header & 0x40) != 0) {
                return dbAccess.getDatabase().reconstruct(page, loc, len);
            }
        }
        byte[] value = new byte[len];
        PageOps.p_copyToArray(page, loc, value, 0, len);
        return value;
    }

    /*
     * Unable to fully structure code
     */
    void retrieveLeafEntry(int pos, BTreeCursor cursor) throws IOException {
        block2: {
            page = this.mPage;
            loc = PageOps.p_ushortGetLE(page, this.searchVecStart() + pos);
            if ((header = PageOps.p_byteGet(page, loc++)) < 0) break block2;
            keyLen = header + 1;
            ** GOTO lbl-1000
        }
        keyLen = (header & 63) << 8 | PageOps.p_ubyteGet(page, loc++);
        if ((header & 64) != 0) {
            key = this.getDatabase().reconstructKey(page, loc, keyLen);
        } else lbl-1000:
        // 2 sources

        {
            key = new byte[keyLen];
            PageOps.p_copyToArray(page, loc, key, 0, keyLen);
        }
        cursor.mKey = key;
        value = cursor.mKeyOnly != false ? (PageOps.p_byteGet(page, loc) == -1 ? null : Cursor.NOT_LOADED) : Node.retrieveLeafValueAtLoc(this, page, loc += keyLen);
        cursor.mValue = value;
    }

    boolean isFragmentedKey(int pos) {
        byte[] page = this.mPage;
        int loc = PageOps.p_ushortGetLE(page, this.searchVecStart() + pos);
        return (PageOps.p_byteGet(page, loc) & 0xC0) == 192;
    }

    boolean isFragmentedLeafValue(int pos) {
        byte header;
        byte[] page = this.mPage;
        int loc = PageOps.p_ushortGetLE(page, this.searchVecStart() + pos);
        return ((header = PageOps.p_byteGet(page, loc += Node.keyLengthAtLoc(page, loc))) & 0xC0) == 192 & header < -1;
    }

    /*
     * Unable to fully structure code
     */
    void txnDeleteLeafEntry(LocalTransaction txn, BTree tree, byte[] key, int keyHash, int pos) throws IOException {
        block7: {
            block6: {
                block5: {
                    block4: {
                        frame = new GhostFrame();
                        page = this.mPage;
                        loc = entryLoc = PageOps.p_ushortGetLE(page, this.searchVecStart() + pos);
                        loc += Node.keyLengthAtLoc(page, loc);
                        valueHeaderLoc = loc;
                        if ((header = PageOps.p_byteGet(page, loc++)) < 0) break block4;
                        loc += header;
                        ** GOTO lbl-1000
                    }
                    if ((header & 32) != 0) break block5;
                    loc += 2 + ((header & 31) << 8 | PageOps.p_ubyteGet(page, loc));
                    break block6;
                }
                if (header == -1) break block7;
                loc += 3 + ((header & 15) << 16 | PageOps.p_ubyteGet(page, loc) << 8 | PageOps.p_ubyteGet(page, loc + 1));
            }
            ** if ((header & 64) == 0) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                valueStartLoc = valueHeaderLoc + 2 + ((header & 32) >> 5);
                FragmentedTrash.add((BTree)tree.mDatabase.fragmentedTrash(), (LocalTransaction)txn, (long)tree.mId, (byte[])page, (int)entryLoc, (int)(valueHeaderLoc - entryLoc), (int)valueStartLoc, (int)(loc - valueStartLoc));
                ** GOTO lbl23
            }
lbl-1000:
            // 2 sources

            {
                txn.pushUndoStore(tree.mId, (byte)21, page, entryLoc, loc - entryLoc);
            }
        }
        frame.bind(this, pos);
        tree.mLockManager.ghosted(tree.mId, key, keyHash, frame);
        PageOps.p_bytePut(page, valueHeaderLoc, -1);
        this.spaceFreed(valueHeaderLoc + 1, loc);
    }

    void txnPreUpdateLeafEntry(LocalTransaction txn, BTree tree, int pos) throws IOException {
        int loc;
        int entryLoc;
        byte[] page;
        block5: {
            byte header;
            int valueHeaderLoc;
            block7: {
                block6: {
                    block4: {
                        page = this.mPage;
                        loc = entryLoc = PageOps.p_ushortGetLE(page, this.searchVecStart() + pos);
                        loc += Node.keyLengthAtLoc(page, loc);
                        valueHeaderLoc = loc;
                        if ((header = PageOps.p_byteGet(page, loc++)) < 0) break block4;
                        loc += header;
                        break block5;
                    }
                    if ((header & 0x20) != 0) break block6;
                    loc += 2 + ((header & 0x1F) << 8 | PageOps.p_ubyteGet(page, loc));
                    break block7;
                }
                if (header == -1) break block5;
                loc += 3 + ((header & 0xF) << 16 | PageOps.p_ubyteGet(page, loc) << 8 | PageOps.p_ubyteGet(page, loc + 1));
            }
            if ((header & 0x40) != 0) {
                int valueStartLoc = valueHeaderLoc + 2 + ((header & 0x20) >> 5);
                FragmentedTrash.add(tree.mDatabase.fragmentedTrash(), txn, tree.mId, page, entryLoc, valueHeaderLoc - entryLoc, valueStartLoc, loc - valueStartLoc);
                PageOps.p_bytePut(page, valueHeaderLoc, header & 0xFFFFFFBF);
                return;
            }
        }
        txn.pushUndoStore(tree.mId, (byte)20, page, entryLoc, loc - entryLoc);
    }

    long retrieveChildRefId(int pos) {
        return PageOps.p_uint48GetLE(this.mPage, this.searchVecEnd() + 2 + (pos << 2));
    }

    int retrieveChildEntryCount(int pos) {
        return PageOps.p_ushortGetLE(this.mPage, this.searchVecEnd() + 8 + (pos << 2)) - 1;
    }

    void storeChildEntryCount(int pos, int count) {
        if (count < 65535) {
            PageOps.p_shortPutLE(this.mPage, this.searchVecEnd() + 8 + (pos << 2), count + 1);
        }
    }

    static int leafEntryLengthAtLoc(byte[] page, int entryLoc) {
        byte header;
        int loc = entryLoc + Node.keyLengthAtLoc(page, entryLoc);
        if ((header = PageOps.p_byteGet(page, loc++)) >= 0) {
            loc += header;
        } else if ((header & 0x20) == 0) {
            loc += 2 + ((header & 0x1F) << 8 | PageOps.p_ubyteGet(page, loc));
        } else if (header != -1) {
            loc += 3 + ((header & 0xF) << 16 | PageOps.p_ubyteGet(page, loc) << 8 | PageOps.p_ubyteGet(page, loc + 1));
        }
        return loc - entryLoc;
    }

    static int keyLengthAtLoc(byte[] page, int keyLoc) {
        int header = PageOps.p_byteGet(page, keyLoc);
        return (header >= 0 ? header : (header & 0x3F) << 8 | PageOps.p_ubyteGet(page, keyLoc + 1)) + 2;
    }

    void insertLeafEntry(CursorFrame frame, BTree tree, int pos, byte[] okey, byte[] value) throws IOException {
        LocalDatabase db = tree.mDatabase;
        byte[] akey = okey;
        int encodedKeyLen = Node.calculateAllowedKeyLength(db, okey);
        if (encodedKeyLen < 0) {
            akey = db.fragmentKey(okey);
            encodedKeyLen = 2 + akey.length;
        }
        try {
            int vfrag;
            int encodedLen = encodedKeyLen + Node.calculateLeafValueLength(value);
            if (encodedLen <= db.mMaxEntrySize) {
                vfrag = 0;
            } else {
                if ((value = db.fragment(value, value.length, db.mMaxFragmentedEntrySize - encodedKeyLen)) == null) {
                    throw new AssertionError();
                }
                encodedLen = encodedKeyLen + Node.calculateFragmentedValueLength(value);
                vfrag = 64;
            }
            try {
                int entryLoc = this.createLeafEntry(frame, tree, pos, encodedLen);
                if (entryLoc < 0) {
                    this.splitLeafAndCreateEntry(tree, okey, akey, vfrag, value, encodedLen, pos, true);
                } else {
                    this.copyToLeafEntry(okey, akey, vfrag, value, entryLoc);
                }
            }
            catch (Throwable e) {
                if (vfrag == 64) {
                    this.cleanupFragments(e, value);
                }
                throw e;
            }
        }
        catch (Throwable e) {
            if (okey != akey) {
                this.cleanupFragments(e, akey);
            }
            throw e;
        }
    }

    void insertBlankLeafEntry(CursorFrame frame, BTree tree, int pos, byte[] okey, long vlength) throws IOException {
        if (vlength < 0L) {
            throw new IllegalArgumentException("Length overflow");
        }
        LocalDatabase db = tree.mDatabase;
        byte[] akey = okey;
        int encodedKeyLen = Node.calculateAllowedKeyLength(db, okey);
        if (encodedKeyLen < 0) {
            akey = db.fragmentKey(okey);
            encodedKeyLen = 2 + akey.length;
        }
        try {
            int encodedLen;
            byte[] value;
            int vfrag;
            long longEncodedLen = (long)encodedKeyLen + Node.calculateLeafValueLength(vlength);
            if (longEncodedLen <= (long)db.mMaxEntrySize && (int)vlength >= 0) {
                vfrag = 0;
                value = new byte[(int)vlength];
                encodedLen = (int)longEncodedLen;
            } else {
                value = db.fragment(null, vlength, db.mMaxFragmentedEntrySize - encodedKeyLen);
                if (value == null) {
                    throw new AssertionError();
                }
                encodedLen = encodedKeyLen + Node.calculateFragmentedValueLength(value);
                vfrag = 64;
            }
            try {
                int entryLoc = this.createLeafEntry(frame, tree, pos, encodedLen);
                if (entryLoc < 0) {
                    this.splitLeafAndCreateEntry(tree, okey, akey, vfrag, value, encodedLen, pos, true);
                } else {
                    this.copyToLeafEntry(okey, akey, vfrag, value, entryLoc);
                }
            }
            catch (Throwable e) {
                if (vfrag == 64) {
                    this.cleanupFragments(e, value);
                }
                throw e;
            }
        }
        catch (Throwable e) {
            if (okey != akey) {
                this.cleanupFragments(e, akey);
            }
            throw e;
        }
    }

    void insertFragmentedLeafEntry(CursorFrame frame, BTree tree, int pos, byte[] okey, byte[] value) throws IOException {
        LocalDatabase db = tree.mDatabase;
        byte[] akey = okey;
        int encodedKeyLen = Node.calculateAllowedKeyLength(db, okey);
        if (encodedKeyLen < 0) {
            akey = db.fragmentKey(okey);
            encodedKeyLen = 2 + akey.length;
        }
        try {
            int encodedLen = encodedKeyLen + Node.calculateFragmentedValueLength(value);
            int entryLoc = this.createLeafEntry(frame, tree, pos, encodedLen);
            if (entryLoc < 0) {
                this.splitLeafAndCreateEntry(tree, okey, akey, 64, value, encodedLen, pos, true);
            } else {
                this.copyToLeafEntry(okey, akey, 64, value, entryLoc);
            }
        }
        catch (Throwable e) {
            if (okey != akey) {
                this.cleanupFragments(e, akey);
            }
            throw e;
        }
    }

    private void panic(Throwable cause) {
        try {
            this.getDatabase().close(cause);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanupFragments(Throwable cause, byte[] fragmented) {
        if (fragmented != null) {
            byte[] copy = PageOps.p_transfer(fragmented);
            try {
                this.getDatabase().deleteFragments(copy, 0, fragmented.length);
            }
            catch (Throwable e) {
                Utils.suppress(cause, e);
                this.panic(cause);
            }
            finally {
                PageOps.p_delete(copy);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    int createLeafEntry(CursorFrame frame, BTree tree, int pos, int encodedLen) {
        block11: {
            block9: {
                block10: {
                    searchVecStart = this.searchVecStart();
                    searchVecEnd = this.searchVecEnd();
                    leftSpace = searchVecStart - this.leftSegTail();
                    rightSpace = this.rightSegTail() - searchVecEnd - 1;
                    page = this.mPage;
                    if (pos >= searchVecEnd - searchVecStart + 2 >> 1) break block9;
                    if ((leftSpace -= 2) < 0 || (entryLoc = this.allocPageEntry(encodedLen, leftSpace, rightSpace)) < 0) break block10;
                    PageOps.p_copy(page, searchVecStart, page, searchVecStart -= 2, pos);
                    pos += searchVecStart;
                    this.searchVecStart(searchVecStart);
                    break block11;
                }
                leftSpace += 2;
                ** GOTO lbl21
            }
            if ((rightSpace -= 2) >= 0 && (entryLoc = this.allocPageEntry(encodedLen, leftSpace, rightSpace)) >= 0) {
                PageOps.p_copy(page, pos += searchVecStart, page, pos + 2, (searchVecEnd += 2) - pos);
                this.searchVecEnd(searchVecEnd);
            } else {
                rightSpace += 2;
lbl21:
                // 2 sources

                remaining = leftSpace + rightSpace - encodedLen - 2;
                garbage = this.garbage();
                if (garbage > remaining) {
                    if (garbage + remaining >= 0) {
                        return this.compactLeaf(encodedLen, pos, true);
                    }
                    if (frame != null && (parentFrame = frame.mParentFrame) != null && (result = this.tryRebalanceLeaf(tree, parentFrame, pos, encodedLen, -remaining)) > 0) {
                        return result;
                    }
                    return ~(garbage + leftSpace + rightSpace);
                }
                vecLen = searchVecEnd - searchVecStart + 2;
                if (remaining > 0 || (this.rightSegTail() & 1) != 0) {
                    newSearchVecStart = this.rightSegTail() - vecLen + -1 - (remaining >> 1) & -2;
                    entryLoc = this.leftSegTail();
                    this.leftSegTail(entryLoc + encodedLen);
                } else if ((this.leftSegTail() & 1) == 0) {
                    newSearchVecStart = this.leftSegTail() + (remaining >> 1 & -2);
                    entryLoc = this.rightSegTail() - encodedLen + 1;
                    this.rightSegTail(entryLoc - 1);
                } else {
                    return this.compactLeaf(encodedLen, pos, true);
                }
                PageOps.p_copies(page, searchVecStart, newSearchVecStart, pos, searchVecStart + pos, newSearchVecStart + pos + 2, vecLen - pos);
                pos += newSearchVecStart;
                this.searchVecStart(newSearchVecStart);
                this.searchVecEnd(newSearchVecStart + vecLen);
            }
        }
        PageOps.p_shortPutLE(page, pos, entryLoc);
        return entryLoc;
    }

    private int tryRebalanceLeaf(BTree tree, CursorFrame parentFrame, int pos, int insertLen, int minAmount) {
        int result;
        if ((this.id() & 1L) == 0L) {
            result = this.tryRebalanceLeafLeft(tree, parentFrame, pos, insertLen, minAmount);
            if (result <= 0) {
                result = this.tryRebalanceLeafRight(tree, parentFrame, pos, insertLen, minAmount);
            }
        } else {
            result = this.tryRebalanceLeafRight(tree, parentFrame, pos, insertLen, minAmount);
            if (result <= 0) {
                result = this.tryRebalanceLeafLeft(tree, parentFrame, pos, insertLen, minAmount);
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private int tryRebalanceLeafLeft(BTree tree, CursorFrame parentFrame, int pos, int insertLen, int minAmount) {
        block23: {
            block22: {
                block21: {
                    rightPage = this.mPage;
                    moveAmount = 0;
                    insertLoc = 0;
                    insertSlack = 0x7FFFFFFF;
                    searchVecEnd = searchVecLoc + pos - 2;
                    for (searchVecLoc = this.searchVecStart(); searchVecLoc < searchVecEnd; searchVecLoc += 2) {
                        entryLoc = PageOps.p_ushortGetLE(rightPage, searchVecLoc);
                        encodedLen = Node.leafEntryLengthAtLoc(rightPage, entryLoc);
                        slack = encodedLen - insertLen;
                        if (slack >= 0 && slack < insertSlack) {
                            insertLoc = entryLoc;
                            insertSlack = slack;
                        }
                        if ((moveAmount += encodedLen + 2) < minAmount || insertLoc == 0) {
                            continue;
                        }
                        break block21;
                    }
                    return 0;
                }
                lastSearchVecLoc = searchVecLoc + 2;
                parent = parentFrame.tryAcquireExclusive();
                if (parent == null) {
                    return 0;
                }
                childPos = parentFrame.mNodePos;
                if (childPos <= 0 || parent.mSplit != null || parent.mCachedState != this.mCachedState) {
                    parent.releaseExclusive();
                    return 0;
                }
                try {
                    left = parent.tryLatchChildNotSplit(childPos - 2);
                }
                catch (IOException e) {
                    return 0;
                }
                if (left == null) {
                    parent.releaseExclusive();
                    return 0;
                }
                try {
                    leftAvail = left.availableLeafBytes();
                    if (leftAvail < moveAmount || (newKeyLen = Node.calculateAllowedKeyLength(tree.mDatabase, newKey = this.midKey((highPos = lastSearchVecLoc - this.searchVecStart()) - 2, this, highPos))) <= 0 || (parentKeyGrowth = newKeyLen - Node.keyLengthAtLoc(parentPage = parent.mPage, parentKeyLoc = PageOps.p_ushortGetLE(parentPage, parent.searchVecStart() + childPos - 2))) > 0 && parentKeyGrowth > parent.availableInternalBytes()) break block22;
                    break block23;
                }
                catch (IOException leftAvail) {
                    // empty catch block
                }
            }
            left.releaseExclusive();
            parent.releaseExclusive();
            return 0;
        }
        try {
            if (tree.mDatabase.markDirty(tree, left)) {
                parent.updateChildRefId(childPos - 2, left.id());
            }
        }
        catch (IOException e) {
            left.releaseExclusive();
            parent.releaseExclusive();
            return 0;
        }
        if (parentKeyGrowth <= 0) {
            Node.encodeNormalKey(newKey, parentPage, parentKeyLoc);
            parent.garbage(parent.garbage() - parentKeyGrowth);
        } else {
            parent.updateInternalKey(childPos - 2, parentKeyGrowth, newKey, newKeyLen);
        }
        garbageAccum = 0;
        lastPos = lastSearchVecLoc - searchVecLoc;
        for (searchVecLoc = this.searchVecStart(); searchVecLoc < lastSearchVecLoc; searchVecLoc += 2) {
            entryLoc = PageOps.p_ushortGetLE(rightPage, searchVecLoc);
            encodedLen = Node.leafEntryLengthAtLoc(rightPage, entryLoc);
            leftEntryLoc = left.createLeafEntry(null, tree, left.highestLeafPos() + 2, encodedLen);
            PageOps.p_copy(rightPage, entryLoc, left.mPage, leftEntryLoc, encodedLen);
            garbageAccum += encodedLen;
        }
        this.garbage(this.garbage() + garbageAccum);
        this.searchVecStart(lastSearchVecLoc);
        leftEndPos = left.highestLeafPos() + 2;
        frame = this.mLastCursorFrame;
        while (frame != null) {
            prev = frame.mPrevCousin;
            framePos = frame.mNodePos;
            mask = framePos >> 31;
            newPos = (framePos ^ mask) - lastPos;
            v0 = newPos < 0;
            if (!(newPos == 0 & mask != 0)) ** GOTO lbl-1000
            frameKey = frame.mNotFoundKey;
            if (frame.mNotFoundKey != null && Arrays.compareUnsigned(frameKey, newKey) < 0) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (v0 | v1) {
                frame.rebind(left, leftEndPos + newPos ^ mask);
                frame.adjustParentPosition(-2);
            } else {
                frame.mNodePos = newPos ^ mask;
            }
            frame = prev;
        }
        left.releaseExclusive();
        parent.releaseExclusive();
        this.garbage(this.garbage() - insertLen);
        searchVecStart = this.searchVecStart();
        PageOps.p_copy(rightPage, searchVecStart, rightPage, searchVecStart -= 2, pos -= lastPos);
        this.searchVecStart(searchVecStart);
        PageOps.p_shortPutLE(rightPage, searchVecStart + pos, insertLoc);
        return insertLoc;
    }

    /*
     * Unable to fully structure code
     */
    private int tryRebalanceLeafRight(BTree tree, CursorFrame parentFrame, int pos, int insertLen, int minAmount) {
        block23: {
            block22: {
                block21: {
                    leftPage = this.mPage;
                    moveAmount = 0;
                    insertLoc = 0;
                    insertSlack = 0x7FFFFFFF;
                    searchVecStart = this.searchVecStart() + pos;
                    for (searchVecLoc = this.searchVecEnd(); searchVecLoc > searchVecStart; searchVecLoc -= 2) {
                        entryLoc = PageOps.p_ushortGetLE(leftPage, searchVecLoc);
                        encodedLen = Node.leafEntryLengthAtLoc(leftPage, entryLoc);
                        slack = encodedLen - insertLen;
                        if (slack >= 0 && slack < insertSlack) {
                            insertLoc = entryLoc;
                            insertSlack = slack;
                        }
                        if ((moveAmount += encodedLen + 2) < minAmount || insertLoc == 0) {
                            continue;
                        }
                        break block21;
                    }
                    return 0;
                }
                firstSearchVecLoc = searchVecLoc;
                parent = parentFrame.tryAcquireExclusive();
                if (parent == null) {
                    return 0;
                }
                childPos = parentFrame.mNodePos;
                if (childPos >= parent.highestInternalPos() || parent.mSplit != null || parent.mCachedState != this.mCachedState) {
                    parent.releaseExclusive();
                    return 0;
                }
                try {
                    right = parent.tryLatchChildNotSplit(childPos + 2);
                }
                catch (IOException e) {
                    return 0;
                }
                if (right == null) {
                    parent.releaseExclusive();
                    return 0;
                }
                try {
                    rightAvail = right.availableLeafBytes();
                    if (rightAvail < moveAmount || (newKeyLen = Node.calculateAllowedKeyLength(tree.mDatabase, newKey = this.midKey((highPos = firstSearchVecLoc - this.searchVecStart()) - 2, this, highPos))) <= 0 || (parentKeyGrowth = newKeyLen - Node.keyLengthAtLoc(parentPage = parent.mPage, parentKeyLoc = PageOps.p_ushortGetLE(parentPage, parent.searchVecStart() + childPos))) > 0 && parentKeyGrowth > parent.availableInternalBytes()) break block22;
                    break block23;
                }
                catch (IOException rightAvail) {
                    // empty catch block
                }
            }
            right.releaseExclusive();
            parent.releaseExclusive();
            return 0;
        }
        try {
            if (tree.mDatabase.markDirty(tree, right)) {
                parent.updateChildRefId(childPos + 2, right.id());
            }
        }
        catch (IOException e) {
            right.releaseExclusive();
            parent.releaseExclusive();
            return 0;
        }
        if (parentKeyGrowth <= 0) {
            Node.encodeNormalKey(newKey, parentPage, parentKeyLoc);
            parent.garbage(parent.garbage() - parentKeyGrowth);
        } else {
            parent.updateInternalKey(childPos, parentKeyGrowth, newKey, newKeyLen);
        }
        garbageAccum = 0;
        moved = searchVecLoc - firstSearchVecLoc + 2;
        for (searchVecLoc = this.searchVecEnd(); searchVecLoc >= firstSearchVecLoc; searchVecLoc -= 2) {
            entryLoc = PageOps.p_ushortGetLE(leftPage, searchVecLoc);
            encodedLen = Node.leafEntryLengthAtLoc(leftPage, entryLoc);
            rightEntryLoc = right.createLeafEntry(null, tree, 0, encodedLen);
            PageOps.p_copy(leftPage, entryLoc, right.mPage, rightEntryLoc, encodedLen);
            garbageAccum += encodedLen;
        }
        this.garbage(this.garbage() + garbageAccum);
        this.searchVecEnd(firstSearchVecLoc - 2);
        frame = right.mLastCursorFrame;
        while (frame != null) {
            framePos = frame.mNodePos;
            mask = framePos >> 31;
            frame.mNodePos = (framePos ^ mask) + moved ^ mask;
            frame = frame.mPrevCousin;
        }
        leftEndPos = firstSearchVecLoc - this.searchVecStart();
        frame = this.mLastCursorFrame;
        while (frame != null) {
            prev = frame.mPrevCousin;
            framePos = frame.mNodePos;
            mask = framePos >> 31;
            newPos = (framePos ^ mask) - leftEndPos;
            v0 = newPos >= 0;
            if (newPos != 0 | mask == 0) ** GOTO lbl-1000
            frameKey = frame.mNotFoundKey;
            if (frame.mNotFoundKey != null && Arrays.compareUnsigned(frameKey, newKey) >= 0) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            if (v0 & v1) {
                frame.rebind(right, newPos ^ mask);
                frame.adjustParentPosition(2);
            }
            frame = prev;
        }
        right.releaseExclusive();
        parent.releaseExclusive();
        this.garbage(this.garbage() - insertLen);
        newSearchVecEnd = this.searchVecEnd() + 2;
        PageOps.p_copy(leftPage, pos += this.searchVecStart(), leftPage, pos + 2, newSearchVecEnd - pos);
        this.searchVecEnd(newSearchVecEnd);
        PageOps.p_shortPutLE(leftPage, pos, insertLoc);
        return insertLoc;
    }

    void insertSplitChildRef(CursorFrame frame, BTree tree, int keyPos, Node splitChild) throws IOException {
        InResult result;
        Node rightChild;
        Split split = splitChild.mSplit;
        Node newChild = splitChild.rebindSplitFrames(split);
        int newChildPos = keyPos >> 1;
        if (split.mSplitRight) {
            rightChild = newChild;
            ++newChildPos;
        } else {
            rightChild = splitChild;
        }
        CursorFrame f = this.mLastCursorFrame;
        while (f != null) {
            int fPos = f.mNodePos;
            if (fPos > keyPos) {
                f.mNodePos = fPos + 2;
            }
            f = f.mPrevCousin;
        }
        CursorFrame childFrame = rightChild.mLastCursorFrame;
        while (childFrame != null) {
            childFrame.adjustParentPosition(2);
            childFrame = childFrame.mPrevCousin;
        }
        try {
            result = new InResult();
            this.createInternalEntry(frame, result, tree, keyPos, split.splitKeyEncodedLength(), newChildPos << 3, true);
        }
        catch (Throwable e) {
            try {
                CursorFrame childFrame2 = rightChild.mLastCursorFrame;
                while (childFrame2 != null) {
                    childFrame2.adjustParentPosition(-2);
                    childFrame2 = childFrame2.mPrevCousin;
                }
                CursorFrame f2 = this.mLastCursorFrame;
                while (f2 != null) {
                    int fPos = f2.mNodePos;
                    if (fPos > keyPos) {
                        f2.mNodePos = fPos - 2;
                    }
                    f2 = f2.mPrevCousin;
                }
                splitChild.unrebindSplitFrames(split, newChild);
                splitChild.releaseExclusive();
                newChild.releaseExclusive();
                this.releaseExclusive();
            }
            catch (Throwable e2) {
                Utils.suppress(e, e2);
                this.panic(e);
            }
            throw e;
        }
        splitChild.mSplit = null;
        PageOps.p_longPutLE(result.mPage, result.mNewChildLoc, newChild.id());
        int entryLoc = result.mEntryLoc;
        if (entryLoc < 0) {
            this.mSplit.setKey(split);
        } else {
            split.copySplitKeyToParent(result.mPage, entryLoc);
        }
        splitChild.releaseExclusive();
        newChild.releaseExclusive();
        try {
            newChild.makeEvictable();
        }
        catch (Throwable e) {
            this.releaseExclusive();
            throw e;
        }
    }

    private void createInternalEntry(CursorFrame frame, InResult result, BTree tree, int keyPos, int encodedLen, int newChildPos, boolean allowSplit) throws IOException {
        int entryLoc;
        byte[] page;
        block10: {
            int newSearchVecStart;
            int remaining;
            int searchVecEnd;
            int searchVecStart;
            block13: {
                block15: {
                    block14: {
                        CursorFrame parentFrame;
                        block16: {
                            int adjust;
                            block17: {
                                int rightSpace;
                                int leftSpace;
                                block11: {
                                    block12: {
                                        block8: {
                                            block9: {
                                                searchVecStart = this.searchVecStart();
                                                searchVecEnd = this.searchVecEnd();
                                                leftSpace = searchVecStart - this.leftSegTail();
                                                rightSpace = this.rightSegTail() - searchVecEnd - (searchVecEnd - searchVecStart << 2) - 17;
                                                page = this.mPage;
                                                if (newChildPos >= 3 * (searchVecEnd - searchVecStart + 2) + keyPos + 8 >> 1) break block8;
                                                if ((leftSpace -= 10) < 0 || (entryLoc = this.allocPageEntry(encodedLen, leftSpace, rightSpace)) < 0) break block9;
                                                PageOps.p_copy(page, searchVecStart, page, searchVecStart - 10, keyPos);
                                                PageOps.p_copy(page, searchVecStart + keyPos, page, searchVecStart + keyPos - 8, searchVecEnd - searchVecStart + 2 - keyPos + newChildPos);
                                                this.searchVecStart(searchVecStart -= 10);
                                                keyPos += searchVecStart;
                                                this.searchVecEnd(searchVecEnd -= 8);
                                                newChildPos += searchVecEnd + 2;
                                                break block10;
                                            }
                                            leftSpace += 10;
                                            break block11;
                                        }
                                        if ((leftSpace -= 2) < 0 || (rightSpace -= 8) < 0 || (entryLoc = this.allocPageEntry(encodedLen, leftSpace, rightSpace)) < 0) break block12;
                                        PageOps.p_copy(page, searchVecStart, page, searchVecStart -= 2, keyPos);
                                        this.searchVecStart(searchVecStart);
                                        keyPos += searchVecStart;
                                        PageOps.p_copy(page, searchVecEnd + newChildPos + 2, page, searchVecEnd + newChildPos + 10, (searchVecEnd - searchVecStart << 2) + 8 - newChildPos);
                                        newChildPos += searchVecEnd + 2;
                                        break block10;
                                    }
                                    leftSpace += 2;
                                    rightSpace += 8;
                                }
                                remaining = leftSpace + rightSpace - encodedLen - 10;
                                int garbage = this.garbage();
                                if (garbage <= remaining) break block13;
                                if (garbage + remaining >= 0) break block14;
                                if (frame == null || (parentFrame = frame.mParentFrame) == null) break block15;
                                if ((this.id() & 1L) != 0L) break block16;
                                adjust = this.tryRebalanceInternalLeft(tree, parentFrame, keyPos, -remaining);
                                if (adjust != 0) break block17;
                                if (this.tryRebalanceInternalRight(tree, parentFrame, keyPos, -remaining)) break block14;
                                break block15;
                            }
                            keyPos -= adjust;
                            newChildPos -= adjust << 2;
                            break block14;
                        }
                        if (this.tryRebalanceInternalRight(tree, parentFrame, keyPos, -remaining)) break block14;
                        int adjust = this.tryRebalanceInternalLeft(tree, parentFrame, keyPos, -remaining);
                        if (adjust == 0) break block15;
                        keyPos -= adjust;
                        newChildPos -= adjust << 2;
                    }
                    this.compactInternal(result, encodedLen, keyPos, newChildPos);
                    return;
                }
                if (!allowSplit) {
                    throw new AssertionError((Object)"Split not allowed");
                }
                this.splitInternal(result, encodedLen, keyPos, newChildPos);
                return;
            }
            int vecLen = searchVecEnd - searchVecStart + 2;
            int childIdsLen = (vecLen << 2) + 8;
            if (remaining > 0 || (this.rightSegTail() & 1) != 0) {
                newSearchVecStart = this.rightSegTail() - vecLen - childIdsLen + -9 - (remaining >> 1) & 0xFFFFFFFE;
                entryLoc = this.leftSegTail();
                this.leftSegTail(entryLoc + encodedLen);
            } else if ((this.leftSegTail() & 1) == 0) {
                newSearchVecStart = this.leftSegTail() + (remaining >> 1 & 0xFFFFFFFE);
                entryLoc = this.rightSegTail() - encodedLen + 1;
                this.rightSegTail(entryLoc - 1);
            } else {
                this.compactInternal(result, encodedLen, keyPos, newChildPos);
                return;
            }
            int newSearchVecEnd = newSearchVecStart + vecLen;
            PageOps.p_copies(page, searchVecStart, newSearchVecStart, keyPos, searchVecStart + keyPos, newSearchVecStart + keyPos + 2, vecLen - keyPos + newChildPos, searchVecEnd + 2 + newChildPos, newSearchVecEnd + 10 + newChildPos, childIdsLen - newChildPos);
            keyPos += newSearchVecStart;
            newChildPos += newSearchVecEnd + 2;
            this.searchVecStart(newSearchVecStart);
            this.searchVecEnd(newSearchVecEnd);
        }
        PageOps.p_shortPutLE(page, keyPos, entryLoc);
        result.mPage = page;
        result.mNewChildLoc = newChildPos;
        result.mEntryLoc = entryLoc;
    }

    private int tryRebalanceInternalLeft(BTree tree, CursorFrame parentFrame, int keyPos, int minAmount) {
        int searchVecLoc;
        int parentKeyLoc;
        int parentKeyLen;
        int searchKeyLoc;
        int searchKeyLen;
        int parentKeyGrowth;
        Node left;
        int lastSearchVecLoc;
        int leftGrowth;
        byte[] rightPage;
        byte[] parentPage;
        int childPos;
        Node parent;
        block18: {
            int searchVecLoc2;
            parent = parentFrame.tryAcquireExclusive();
            if (parent == null) {
                return 0;
            }
            childPos = parentFrame.mNodePos;
            if (childPos <= 0 || parent.mSplit != null || parent.mCachedState != this.mCachedState) {
                parent.releaseExclusive();
                return 0;
            }
            parentPage = parent.mPage;
            rightPage = this.mPage;
            int rightShrink = 0;
            leftGrowth = 0;
            int searchVecEnd = searchVecLoc2 + keyPos - 2;
            for (searchVecLoc2 = this.searchVecStart(); searchVecLoc2 < searchVecEnd; searchVecLoc2 += 2) {
                int keyLoc = PageOps.p_ushortGetLE(rightPage, searchVecLoc2);
                int len = Node.keyLengthAtLoc(rightPage, keyLoc) + 10;
                leftGrowth += len;
                if ((rightShrink += len) < minAmount) continue;
                lastSearchVecLoc = searchVecLoc2;
                leftGrowth -= len;
                keyLoc = PageOps.p_ushortGetLE(parentPage, parent.searchVecStart() + childPos - 2);
                leftGrowth += Node.keyLengthAtLoc(parentPage, keyLoc) + 10;
                break block18;
            }
            parent.releaseExclusive();
            return 0;
        }
        try {
            left = parent.tryLatchChildNotSplit(childPos - 2);
        }
        catch (IOException e) {
            return 0;
        }
        if (left == null) {
            parent.releaseExclusive();
            return 0;
        }
        int leftAvail = left.availableInternalBytes();
        if (leftAvail < leftGrowth || (parentKeyGrowth = (searchKeyLen = Node.keyLengthAtLoc(rightPage, searchKeyLoc = PageOps.p_ushortGetLE(rightPage, lastSearchVecLoc))) - (parentKeyLen = Node.keyLengthAtLoc(parentPage, parentKeyLoc = PageOps.p_ushortGetLE(parentPage, parent.searchVecStart() + childPos - 2)))) > 0 && parentKeyGrowth > parent.availableInternalBytes()) {
            left.releaseExclusive();
            parent.releaseExclusive();
            return 0;
        }
        try {
            if (tree.mDatabase.markDirty(tree, left)) {
                parent.updateChildRefId(childPos - 2, left.id());
            }
        }
        catch (IOException e) {
            left.releaseExclusive();
            parent.releaseExclusive();
            return 0;
        }
        int garbageAccum = searchKeyLen;
        int moved = lastSearchVecLoc - searchVecLoc + 2;
        try {
            int pos = left.highestInternalPos();
            InResult result = new InResult();
            left.createInternalEntry(null, result, tree, pos, parentKeyLen, pos + 2 << 2, false);
            PageOps.p_copy(parentPage, parentKeyLoc, left.mPage, result.mEntryLoc, parentKeyLen);
            for (searchVecLoc = this.searchVecStart(); searchVecLoc < lastSearchVecLoc; searchVecLoc += 2) {
                int keyLoc = PageOps.p_ushortGetLE(rightPage, searchVecLoc);
                int encodedLen = Node.keyLengthAtLoc(rightPage, keyLoc);
                pos = left.highestInternalPos();
                left.createInternalEntry(null, result, tree, pos, encodedLen, pos + 2 << 2, false);
                PageOps.p_copy(rightPage, keyLoc, left.mPage, result.mEntryLoc, encodedLen);
                garbageAccum += encodedLen;
            }
        }
        catch (IOException e) {
            throw Utils.rethrow(e);
        }
        if (parentKeyGrowth <= 0) {
            PageOps.p_copy(rightPage, searchKeyLoc, parentPage, parentKeyLoc, searchKeyLen);
            parent.garbage(parent.garbage() - parentKeyGrowth);
        } else {
            parent.updateInternalKeyEncoded(childPos - 2, parentKeyGrowth, rightPage, searchKeyLoc, searchKeyLen);
        }
        int start = this.searchVecEnd() + 2;
        int len = moved << 2;
        int end = left.searchVecEnd();
        end = end + (end - left.searchVecStart() << 2) + 18 - len;
        PageOps.p_copy(rightPage, start, left.mPage, end, len);
        PageOps.p_copy(rightPage, start + len, rightPage, start, start - lastSearchVecLoc << 2);
        this.garbage(this.garbage() + garbageAccum);
        this.searchVecStart(lastSearchVecLoc + 2);
        int leftEndPos = left.highestInternalPos() + 2;
        CursorFrame frame = this.mLastCursorFrame;
        while (frame != null) {
            CursorFrame prev = frame.mPrevCousin;
            int framePos = frame.mNodePos;
            int newPos = framePos - moved;
            if (newPos < 0) {
                frame.rebind(left, leftEndPos + newPos);
                frame.adjustParentPosition(-2);
            } else {
                frame.mNodePos = newPos;
            }
            frame = prev;
        }
        left.releaseExclusive();
        parent.releaseExclusive();
        return moved;
    }

    private boolean tryRebalanceInternalRight(BTree tree, CursorFrame parentFrame, int keyPos, int minAmount) {
        int searchVecLoc;
        int parentKeyLoc;
        int parentKeyLen;
        int searchKeyLoc;
        int searchKeyLen;
        int parentKeyGrowth;
        Node right;
        int firstSearchVecLoc;
        int rightGrowth;
        byte[] leftPage;
        byte[] parentPage;
        int childPos;
        Node parent;
        block18: {
            parent = parentFrame.tryAcquireExclusive();
            if (parent == null) {
                return false;
            }
            childPos = parentFrame.mNodePos;
            if (childPos >= parent.highestInternalPos() || parent.mSplit != null || parent.mCachedState != this.mCachedState) {
                parent.releaseExclusive();
                return false;
            }
            parentPage = parent.mPage;
            leftPage = this.mPage;
            int leftShrink = 0;
            rightGrowth = 0;
            int searchVecStart = this.searchVecStart() + keyPos;
            for (int searchVecLoc2 = this.searchVecEnd(); searchVecLoc2 > searchVecStart; searchVecLoc2 -= 2) {
                int keyLoc = PageOps.p_ushortGetLE(leftPage, searchVecLoc2);
                int len = Node.keyLengthAtLoc(leftPage, keyLoc) + 10;
                rightGrowth += len;
                if ((leftShrink += len) < minAmount) continue;
                firstSearchVecLoc = searchVecLoc2;
                rightGrowth -= len;
                keyLoc = PageOps.p_ushortGetLE(parentPage, parent.searchVecStart() + childPos);
                rightGrowth += Node.keyLengthAtLoc(parentPage, keyLoc) + 10;
                break block18;
            }
            parent.releaseExclusive();
            return false;
        }
        try {
            right = parent.tryLatchChildNotSplit(childPos + 2);
        }
        catch (IOException e) {
            return false;
        }
        if (right == null) {
            parent.releaseExclusive();
            return false;
        }
        int rightAvail = right.availableInternalBytes();
        if (rightAvail < rightGrowth || (parentKeyGrowth = (searchKeyLen = Node.keyLengthAtLoc(leftPage, searchKeyLoc = PageOps.p_ushortGetLE(leftPage, firstSearchVecLoc))) - (parentKeyLen = Node.keyLengthAtLoc(parentPage, parentKeyLoc = PageOps.p_ushortGetLE(parentPage, parent.searchVecStart() + childPos)))) > 0 && parentKeyGrowth > parent.availableInternalBytes()) {
            right.releaseExclusive();
            parent.releaseExclusive();
            return false;
        }
        try {
            if (tree.mDatabase.markDirty(tree, right)) {
                parent.updateChildRefId(childPos + 2, right.id());
            }
        }
        catch (IOException e) {
            right.releaseExclusive();
            parent.releaseExclusive();
            return false;
        }
        int garbageAccum = searchKeyLen;
        int moved = searchVecLoc - firstSearchVecLoc + 2;
        try {
            InResult result = new InResult();
            right.createInternalEntry(null, result, tree, 0, parentKeyLen, 0, false);
            PageOps.p_copy(parentPage, parentKeyLoc, right.mPage, result.mEntryLoc, parentKeyLen);
            for (searchVecLoc = this.searchVecEnd(); searchVecLoc > firstSearchVecLoc; searchVecLoc -= 2) {
                int keyLoc = PageOps.p_ushortGetLE(leftPage, searchVecLoc);
                int encodedLen = Node.keyLengthAtLoc(leftPage, keyLoc);
                right.createInternalEntry(null, result, tree, 0, encodedLen, 0, false);
                PageOps.p_copy(leftPage, keyLoc, right.mPage, result.mEntryLoc, encodedLen);
                garbageAccum += encodedLen;
            }
        }
        catch (IOException e) {
            throw Utils.rethrow(e);
        }
        if (parentKeyGrowth <= 0) {
            PageOps.p_copy(leftPage, searchKeyLoc, parentPage, parentKeyLoc, searchKeyLen);
            parent.garbage(parent.garbage() - parentKeyGrowth);
        } else {
            parent.updateInternalKeyEncoded(childPos, parentKeyGrowth, leftPage, searchKeyLoc, searchKeyLen);
        }
        int start = this.searchVecEnd() + 2;
        int len = (start - this.searchVecStart() << 2) + 8 - (moved << 2);
        PageOps.p_copy(leftPage, start, leftPage, start - moved, len);
        PageOps.p_copy(leftPage, start + len, right.mPage, right.searchVecEnd() + 2, moved << 2);
        this.garbage(this.garbage() + garbageAccum);
        this.searchVecEnd(firstSearchVecLoc - 2);
        CursorFrame frame = right.mLastCursorFrame;
        while (frame != null) {
            frame.mNodePos += moved;
            frame = frame.mPrevCousin;
        }
        int adjust = firstSearchVecLoc - this.searchVecStart() + 4;
        CursorFrame frame2 = this.mLastCursorFrame;
        while (frame2 != null) {
            CursorFrame prev = frame2.mPrevCousin;
            int newPos = frame2.mNodePos - adjust;
            if (newPos >= 0) {
                frame2.rebind(right, newPos);
                frame2.adjustParentPosition(2);
            }
            frame2 = prev;
        }
        right.releaseExclusive();
        parent.releaseExclusive();
        return true;
    }

    private Node rebindSplitFrames(Split split) {
        Node sibling = split.latchSiblingEx();
        try {
            CursorFrame frame = this.mLastCursorFrame;
            while (frame != null) {
                CursorFrame prev = frame.mPrevCousin;
                split.rebindFrame(frame, sibling);
                frame = prev;
            }
            return sibling;
        }
        catch (Throwable e) {
            sibling.releaseExclusive();
            throw e;
        }
    }

    private void unrebindSplitFrames(Split split, Node sibling) {
        CursorFrame prev;
        CursorFrame frame = this.mLastCursorFrame;
        while (frame != null) {
            prev = frame.mPrevCousin;
            split.unrebindOriginalFrame(frame);
            frame = prev;
        }
        frame = sibling.mLastCursorFrame;
        while (frame != null) {
            prev = frame.mPrevCousin;
            split.unrebindSiblingFrame(frame, this);
            frame = prev;
        }
    }

    /*
     * Unable to fully structure code
     */
    void updateLeafValue(BTree tree, int pos, int vfrag, byte[] value) throws IOException {
        block27: {
            block28: {
                page = this.mPage;
                searchVecStart = this.searchVecStart();
                start = loc = PageOps.p_ushortGetLE(page, searchVecStart + pos);
                loc += Node.keyLengthAtLoc(page, loc);
                valueHeaderLoc = loc;
                if ((len = PageOps.p_byteGet(page, loc++)) >= 0) break block27;
                if ((len & 32) != 0) break block28;
                header = len;
                len = 1 + ((len & 31) << 8 | PageOps.p_ubyteGet(page, loc++));
                ** GOTO lbl17
            }
            if (len == -1) {
                len = 0;
            } else {
                header = len;
                len = 1 + ((len & 15) << 16 | PageOps.p_ubyteGet(page, loc++) << 8 | PageOps.p_ubyteGet(page, loc++));
lbl17:
                // 2 sources

                if ((header & 64) != 0) {
                    tree.mDatabase.deleteFragments(page, loc, len);
                    PageOps.p_bytePut(page, valueHeaderLoc, header & -65);
                }
            }
        }
        if ((valueLen = value.length) <= len) {
            if (valueLen == len) {
                if (valueLen == 0) {
                    PageOps.p_bytePut(page, valueHeaderLoc, 0);
                } else {
                    PageOps.p_copyFromArray(value, 0, page, loc, valueLen);
                    if (vfrag != 0) {
                        PageOps.p_bytePut(page, valueHeaderLoc, PageOps.p_byteGet(page, valueHeaderLoc) | vfrag);
                    }
                }
            } else {
                valueLoc = Node.copyToLeafValue(page, vfrag, value, valueHeaderLoc);
                this.spaceFreed(valueLoc + valueLen, loc + len);
            }
            return;
        }
        keyLen = valueHeaderLoc - start;
        garbage = this.garbage() + loc + len - start;
        searchVecEnd = this.searchVecEnd();
        leftSpace = searchVecStart - this.leftSegTail();
        rightSpace = this.rightSegTail() - searchVecEnd - 1;
        vfragOriginal = vfrag;
        if (vfrag != 0) {
            encodedLen = keyLen + Node.calculateFragmentedValueLength(value);
        } else {
            db = tree.mDatabase;
            encodedLen = keyLen + Node.calculateLeafValueLength(value);
            if (encodedLen > db.mMaxEntrySize) {
                if ((value = db.fragment(value, value.length, db.mMaxFragmentedEntrySize - keyLen)) == null) {
                    throw new AssertionError();
                }
                encodedLen = keyLen + Node.calculateFragmentedValueLength(value);
                vfrag = 64;
            }
        }
        try {
            entryLoc = this.allocPageEntry(encodedLen, leftSpace, rightSpace);
            if (entryLoc >= 0) {
                pos += searchVecStart;
            } else {
                remaining = leftSpace + rightSpace - encodedLen;
                if (garbage > remaining) {
                    akeyRef = new byte[1][];
                    isOriginal = Node.retrieveActualKeyAtLoc(page, start, akeyRef);
                    akey = akeyRef[0];
                    if (garbage + remaining < 0) {
                        if (this.mSplit == null) {
                            okey = isOriginal != false ? akey : Node.retrieveKeyAtLoc(this, page, start);
                            this.splitLeafAndCreateEntry(tree, okey, akey, vfrag, value, encodedLen, pos, false);
                            return;
                        }
                        if (vfrag != 0) {
                            throw new DatabaseException("Fragmented entry doesn't fit");
                        }
                        db = tree.mDatabase;
                        max = Math.min(db.mMaxFragmentedEntrySize, garbage + leftSpace + rightSpace);
                        if ((value = db.fragment(value, value.length, max - keyLen)) == null) {
                            throw new AssertionError();
                        }
                        encodedLen = keyLen + Node.calculateFragmentedValueLength(value);
                        vfrag = 64;
                    }
                    this.garbage(garbage);
                    entryLoc = this.compactLeaf(encodedLen, pos, false);
                    page = this.mPage;
                    entryLoc = isOriginal != false ? Node.encodeNormalKey(akey, page, entryLoc) : Node.encodeFragmentedKey(akey, page, entryLoc);
                    Node.copyToLeafValue(page, vfrag, value, entryLoc);
                    return;
                }
                vecLen = searchVecEnd - searchVecStart + 2;
                if (remaining > 0 || (this.rightSegTail() & 1) != 0) {
                    newSearchVecStart = this.rightSegTail() - vecLen + 1 - (remaining >> 1) & -2;
                    entryLoc = this.leftSegTail();
                    this.leftSegTail(entryLoc + encodedLen);
                } else if ((this.leftSegTail() & 1) == 0) {
                    newSearchVecStart = this.leftSegTail() + (remaining >> 1 & -2);
                    entryLoc = this.rightSegTail() - encodedLen + 1;
                    this.rightSegTail(entryLoc - 1);
                } else {
                    akeyRef = new byte[1][];
                    loc = PageOps.p_ushortGetLE(page, searchVecStart + pos);
                    isOriginal = Node.retrieveActualKeyAtLoc(page, loc, akeyRef);
                    akey = akeyRef[0];
                    this.garbage(garbage);
                    entryLoc = this.compactLeaf(encodedLen, pos, false);
                    page = this.mPage;
                    entryLoc = isOriginal != false ? Node.encodeNormalKey(akey, page, entryLoc) : Node.encodeFragmentedKey(akey, page, entryLoc);
                    Node.copyToLeafValue(page, vfrag, value, entryLoc);
                    return;
                }
                PageOps.p_copy(page, searchVecStart, page, newSearchVecStart, vecLen);
                pos += newSearchVecStart;
                this.searchVecStart(newSearchVecStart);
                this.searchVecEnd(newSearchVecStart + vecLen - 2);
            }
        }
        catch (Throwable e) {
            if (vfrag == 64 && vfragOriginal != 64) {
                this.cleanupFragments(e, value);
            }
            throw e;
        }
        PageOps.p_copy(page, start, page, entryLoc, keyLen);
        Node.copyToLeafValue(page, vfrag, value, entryLoc + keyLen);
        PageOps.p_shortPutLE(page, pos, entryLoc);
        this.garbage(garbage);
    }

    void updateInternalKey(int pos, int growth, byte[] key, int encodedLen) {
        int entryLoc = this.doUpdateInternalKey(pos, growth, encodedLen);
        Node.encodeNormalKey(key, this.mPage, entryLoc);
    }

    void updateInternalKeyEncoded(int pos, int growth, byte[] key, int keyStart, int encodedLen) {
        int entryLoc = this.doUpdateInternalKey(pos, growth, encodedLen);
        PageOps.p_copy(key, keyStart, this.mPage, entryLoc, encodedLen);
    }

    /*
     * Unable to fully structure code
     */
    int doUpdateInternalKey(int pos, int growth, int encodedLen) {
        block6: {
            block7: {
                block5: {
                    garbage = this.garbage() + encodedLen - growth;
                    searchVecStart = this.searchVecStart();
                    searchVecEnd = this.searchVecEnd();
                    leftSpace = searchVecStart - this.leftSegTail();
                    entryLoc = this.allocPageEntry(encodedLen, leftSpace, rightSpace = this.rightSegTail() - searchVecEnd - (searchVecEnd - searchVecStart << 2) - 17);
                    if (entryLoc < 0) break block5;
                    pos += searchVecStart;
                    break block6;
                }
                remaining = leftSpace + rightSpace - encodedLen;
                if (garbage <= remaining) break block7;
                if (garbage + remaining < 0) {
                    throw new AssertionError();
                }
                ** GOTO lbl-1000
            }
            vecLen = searchVecEnd - searchVecStart + 2;
            childIdsLen = (vecLen << 2) + 8;
            if (remaining > 0 || (this.rightSegTail() & 1) != 0) {
                newSearchVecStart = this.rightSegTail() - vecLen - childIdsLen + 1 - (remaining >> 1) & -2;
                entryLoc = this.leftSegTail();
                this.leftSegTail(entryLoc + encodedLen);
            } else {
                if ((this.leftSegTail() & 1) != 0) lbl-1000:
                // 2 sources

                {
                    this.garbage(garbage);
                    result = new InResult();
                    this.compactInternal(result, encodedLen, pos, -2147483648);
                    return result.mEntryLoc;
                }
                newSearchVecStart = this.leftSegTail() + (remaining >> 1 & -2);
                entryLoc = this.rightSegTail() - encodedLen + 1;
                this.rightSegTail(entryLoc - 1);
            }
            page = this.mPage;
            PageOps.p_copy(page, searchVecStart, page, newSearchVecStart, vecLen + childIdsLen);
            pos += newSearchVecStart;
            this.searchVecStart(newSearchVecStart);
            this.searchVecEnd(newSearchVecStart + vecLen - 2);
        }
        PageOps.p_shortPutLE(this.mPage, pos, entryLoc);
        this.garbage(garbage);
        return entryLoc;
    }

    void updateChildRefId(int pos, long id) {
        PageOps.p_longPutLE(this.mPage, this.searchVecEnd() + 2 + (pos << 2), id);
    }

    void deleteLeafEntry(int pos) throws IOException {
        byte[] page = this.mPage;
        int startLoc = PageOps.p_ushortGetLE(page, this.searchVecStart() + pos);
        int endLoc = this.doDeleteLeafEntry(page, startLoc);
        this.finishDeleteLeafEntry(pos, startLoc, endLoc);
    }

    private int doDeleteLeafEntry(byte[] page, int loc) throws IOException {
        block8: {
            int len;
            int header;
            block10: {
                block9: {
                    block7: {
                        int keyLen;
                        if ((keyLen = PageOps.p_byteGet(page, loc++)) >= 0) {
                            loc += keyLen + 1;
                        } else {
                            header = keyLen;
                            keyLen = (keyLen & 0x3F) << 8 | PageOps.p_ubyteGet(page, loc++);
                            if ((header & 0x40) != 0) {
                                this.getDatabase().deleteFragments(page, loc, keyLen);
                            }
                            loc += keyLen;
                        }
                        header = PageOps.p_byteGet(page, loc++);
                        if (header < 0) break block7;
                        loc += header;
                        break block8;
                    }
                    if ((header & 0x20) != 0) break block9;
                    len = 1 + ((header & 0x1F) << 8 | PageOps.p_ubyteGet(page, loc++));
                    break block10;
                }
                if (header == -1) break block8;
                len = 1 + ((header & 0xF) << 16 | PageOps.p_ubyteGet(page, loc++) << 8 | PageOps.p_ubyteGet(page, loc++));
            }
            if ((header & 0x40) != 0) {
                this.getDatabase().deleteFragments(page, loc, len);
            }
            loc += len;
        }
        return loc;
    }

    private void spaceFreed(int startLoc, int endLoc) {
        if (endLoc == this.leftSegTail()) {
            this.leftSegTail(startLoc);
        } else if (startLoc - 1 == this.rightSegTail()) {
            this.rightSegTail(endLoc - 1);
        } else {
            this.garbage(this.garbage() + (endLoc - startLoc));
        }
    }

    void finishDeleteLeafEntry(int pos, int entryLen) {
        this.garbage(this.garbage() + entryLen);
        this.doFinishDeleteLeafEntry(pos);
    }

    void finishDeleteLeafEntry(int pos, int startLoc, int endLoc) {
        this.spaceFreed(startLoc, endLoc);
        this.doFinishDeleteLeafEntry(pos);
    }

    private void doFinishDeleteLeafEntry(int pos) {
        byte[] page = this.mPage;
        int searchVecStart = this.searchVecStart();
        int searchVecEnd = this.searchVecEnd();
        if (pos < searchVecEnd - searchVecStart >> 1) {
            PageOps.p_copy(page, searchVecStart, page, searchVecStart += 2, pos);
            this.searchVecStart(searchVecStart);
        } else {
            PageOps.p_copy(page, (pos += searchVecStart) + 2, page, pos, searchVecEnd - pos);
            this.searchVecEnd(searchVecEnd - 2);
        }
    }

    void postDelete(int pos, byte[] key) {
        int newPos = ~pos;
        CursorFrame frame = this.mLastCursorFrame;
        do {
            int framePos;
            if ((framePos = frame.mNodePos) == pos) {
                frame.mNodePos = newPos;
                frame.mNotFoundKey = key;
                continue;
            }
            if (framePos > pos) {
                frame.mNodePos = framePos - 2;
                continue;
            }
            if (framePos >= newPos) continue;
            frame.mNodePos = framePos + 2;
        } while ((frame = frame.mPrevCousin) != null);
    }

    static void moveLeafToLeftAndDelete(BTree tree, Node leftNode, Node rightNode) throws IOException {
        tree.mDatabase.prepareToDelete(rightNode);
        byte[] rightPage = rightNode.mPage;
        int searchVecEnd = rightNode.searchVecEnd();
        int leftEndPos = leftNode.highestLeafPos() + 2;
        for (int searchVecStart = rightNode.searchVecStart(); searchVecStart <= searchVecEnd; searchVecStart += 2) {
            int entryLoc = PageOps.p_ushortGetLE(rightPage, searchVecStart);
            int encodedLen = Node.leafEntryLengthAtLoc(rightPage, entryLoc);
            int leftEntryLoc = leftNode.createLeafEntry(null, tree, leftNode.highestLeafPos() + 2, encodedLen);
            PageOps.p_copy(rightPage, entryLoc, leftNode.mPage, leftEntryLoc, encodedLen);
        }
        CursorFrame frame = rightNode.mLastCursorFrame;
        while (frame != null) {
            int framePos;
            CursorFrame prev = frame.mPrevCousin;
            frame.rebind(leftNode, framePos + ((framePos = frame.mNodePos) < 0 ? -leftEndPos : leftEndPos));
            frame = prev;
        }
        leftNode.type((byte)(leftNode.type() | rightNode.type() & 8));
        tree.mDatabase.finishDeleteNode(rightNode);
    }

    static void moveInternalToLeftAndDelete(BTree tree, Node leftNode, Node rightNode, byte[] parentPage, int parentLoc, int parentLen) throws IOException {
        tree.mDatabase.prepareToDelete(rightNode);
        int leftEndPos = leftNode.highestInternalPos();
        InResult result = new InResult();
        leftNode.createInternalEntry(null, result, tree, leftEndPos, parentLen, (leftEndPos += 2) << 2, false);
        byte[] rightPage = rightNode.mPage;
        int rightChildIdsLoc = rightNode.searchVecEnd() + 2;
        PageOps.p_copy(rightPage, rightChildIdsLoc, result.mPage, result.mNewChildLoc, 8);
        rightChildIdsLoc += 8;
        PageOps.p_copy(parentPage, parentLoc, result.mPage, result.mEntryLoc, parentLen);
        int searchVecEnd = rightNode.searchVecEnd();
        for (int searchVecStart = rightNode.searchVecStart(); searchVecStart <= searchVecEnd; searchVecStart += 2) {
            int entryLoc = PageOps.p_ushortGetLE(rightPage, searchVecStart);
            int encodedLen = Node.keyLengthAtLoc(rightPage, entryLoc);
            int pos = leftNode.highestInternalPos();
            leftNode.createInternalEntry(null, result, tree, pos, encodedLen, pos + 2 << 2, false);
            PageOps.p_copy(rightPage, rightChildIdsLoc, result.mPage, result.mNewChildLoc, 8);
            rightChildIdsLoc += 8;
            PageOps.p_copy(rightPage, entryLoc, result.mPage, result.mEntryLoc, encodedLen);
        }
        CursorFrame frame = rightNode.mLastCursorFrame;
        while (frame != null) {
            CursorFrame prev = frame.mPrevCousin;
            int framePos = frame.mNodePos;
            frame.rebind(leftNode, leftEndPos + framePos);
            frame = prev;
        }
        leftNode.type((byte)(leftNode.type() | rightNode.type() & 8));
        tree.mDatabase.finishDeleteNode(rightNode);
    }

    void deleteRightChildRef(int childPos) throws IOException {
        byte[] page = this.mPage;
        int keyPos = childPos - 2;
        int searchVecStart = this.searchVecStart();
        int entryLoc = PageOps.p_ushortGetLE(page, searchVecStart + keyPos);
        int keyLen = Node.keyLengthAtLoc(page, entryLoc);
        if (this.isBottomInternal() && (PageOps.p_byteGet(page, entryLoc) & 0xC0) == 192) {
            this.getDatabase().deleteFragments(page, entryLoc + 2, keyLen - 2);
        }
        this.garbage(this.garbage() + keyLen);
        int childLoc = childPos << 2;
        int searchVecEnd = this.searchVecEnd();
        if (childLoc < 3 * (searchVecEnd - searchVecStart) + keyPos + 8 >> 1) {
            PageOps.p_copy(page, searchVecStart + keyPos + 2, page, searchVecStart + keyPos + 10, searchVecEnd - searchVecStart - keyPos + childLoc);
            PageOps.p_copy(page, searchVecStart, page, searchVecStart += 10, keyPos);
            this.searchVecEnd(searchVecEnd + 8);
        } else {
            PageOps.p_copy(page, searchVecEnd + childLoc + 10, page, searchVecEnd + childLoc + 2, (searchVecEnd - searchVecStart << 2) + 8 - childLoc);
            PageOps.p_copy(page, searchVecStart, page, searchVecStart += 2, keyPos);
        }
        this.searchVecStart(searchVecStart);
        CursorFrame frame = this.mLastCursorFrame;
        while (frame != null) {
            int framePos = frame.mNodePos;
            if (framePos >= childPos) {
                frame.mNodePos = framePos - 2;
            }
            frame = frame.mPrevCousin;
        }
    }

    void deleteLowestChildRef() throws IOException {
        byte[] page = this.mPage;
        int searchVecStart = this.searchVecStart();
        int entryLoc = PageOps.p_ushortGetLE(page, searchVecStart);
        int keyLen = Node.keyLengthAtLoc(page, entryLoc);
        if ((PageOps.p_byteGet(page, entryLoc) & 0xC0) == 192) {
            this.getDatabase().deleteFragments(page, entryLoc + 2, keyLen - 2);
        }
        this.garbage(this.garbage() + keyLen);
        int searchVecEnd = this.searchVecEnd();
        PageOps.p_copy(page, searchVecStart + 2, page, searchVecStart + 10, searchVecEnd - searchVecStart);
        this.searchVecStart(searchVecStart + 10);
        this.searchVecEnd(searchVecEnd + 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rootDelete(BTree tree, Node child, Node stub) throws IOException {
        try {
            tree.mDatabase.prepareToDelete(child);
            try {
                this.doRootDelete(tree, child, stub);
            }
            catch (Throwable e) {
                child.releaseExclusive();
                throw e;
            }
            tree.mDatabase.finishDeleteNode(child);
        }
        finally {
            stub.releaseExclusive();
            this.releaseExclusive();
        }
    }

    private void doRootDelete(BTree tree, Node child, Node stub) throws IOException {
        byte[] oldRootPage = this.mPage;
        this.mPage = child.mPage;
        this.type(child.type());
        this.garbage(child.garbage());
        this.leftSegTail(child.leftSegTail());
        this.rightSegTail(child.rightSegTail());
        this.searchVecStart(child.searchVecStart());
        this.searchVecEnd(child.searchVecEnd());
        CursorFrame lock = new CursorFrame();
        CursorFrame childLastFrame = child.lockLastFrame(lock);
        CursorFrame thisLastFrame = this.lockLastFrame(lock);
        if (!CursorFrame.cLastHandle.compareAndSet(this, thisLastFrame, childLastFrame)) {
            throw new AssertionError();
        }
        if (!CursorFrame.cLastHandle.compareAndSet(child, childLastFrame, null)) {
            throw new AssertionError();
        }
        if (!CursorFrame.cLastHandle.compareAndSet(stub, null, thisLastFrame)) {
            throw new AssertionError();
        }
        this.fixFrameBindings(lock, childLastFrame);
        stub.fixFrameBindings(lock, thisLastFrame);
        child.mPage = oldRootPage;
    }

    private CursorFrame lockLastFrame(CursorFrame lock) {
        CursorFrame last;
        CursorFrame lockResult;
        while ((lockResult = (last = this.mLastCursorFrame).tryLock(lock)) != last) {
            if (lockResult == null) continue;
            last.unlock(lockResult);
        }
        return last;
    }

    private void fixFrameBindings(CursorFrame lock, CursorFrame frame) {
        CursorFrame lockResult = frame;
        while (true) {
            Node existing;
            if ((existing = frame.mNode) != null) {
                if (existing == this) {
                    throw new AssertionError();
                }
                frame.mNode = this;
            }
            CursorFrame prev = frame.tryLockPrevious(lock);
            frame.unlock(lockResult);
            if (prev == null) {
                return;
            }
            lockResult = frame;
            frame = prev;
        }
    }

    void rootSwap(Node other) {
        this.prepareWrite();
        other.prepareWrite();
        int pageSize = this.pageSize(this.mPage);
        byte[] tempPage = new byte[pageSize];
        PageOps.p_copyToArray(this.mPage, 0, tempPage, 0, pageSize);
        PageOps.p_copy(other.mPage, 0, this.mPage, 0, pageSize);
        PageOps.p_copyFromArray(tempPage, 0, other.mPage, 0, pageSize);
        this.readFields();
        other.readFields();
    }

    static int calculateAllowedKeyLength(LocalDatabase db, byte[] key) {
        int len = key.length;
        if ((len - 1 & 0xFFFFFF80) == 0) {
            return len + 1;
        }
        return len > db.mMaxKeySize ? -1 : len + 2;
    }

    static int calculateKeyLength(byte[] key) {
        int len;
        return len + (((len = key.length - 1) & 0xFFFFFF80) == 0 ? 2 : 3);
    }

    private static int calculateLeafValueLength(byte[] value) {
        int len;
        return len + ((len = value.length) <= 127 ? 1 : (len <= 8192 ? 2 : 3));
    }

    private static long calculateLeafValueLength(long vlength) {
        return vlength + (long)(vlength <= 127L ? 1 : (vlength <= 8192L ? 2 : 3));
    }

    private static int calculateFragmentedValueLength(byte[] value) {
        return Node.calculateFragmentedValueLength(value.length);
    }

    static int calculateFragmentedValueLength(int vlength) {
        return vlength + (vlength <= 8192 ? 2 : 3);
    }

    static int encodeNormalKey(byte[] key, byte[] page, int pageLoc) {
        int keyLen = key.length;
        if (keyLen <= 128 && keyLen > 0) {
            PageOps.p_bytePut(page, pageLoc++, keyLen - 1);
        } else {
            PageOps.p_bytePut(page, pageLoc++, 0x80 | keyLen >> 8);
            PageOps.p_bytePut(page, pageLoc++, keyLen);
        }
        PageOps.p_copyFromArray(key, 0, page, pageLoc, keyLen);
        return pageLoc + keyLen;
    }

    static int encodeFragmentedKey(byte[] key, byte[] page, int pageLoc) {
        int keyLen = key.length;
        PageOps.p_bytePut(page, pageLoc++, 0xC0 | keyLen >> 8);
        PageOps.p_bytePut(page, pageLoc++, keyLen);
        PageOps.p_copyFromArray(key, 0, page, pageLoc, keyLen);
        return pageLoc + keyLen;
    }

    private int allocPageEntry(int encodedLen, int leftSpace, int rightSpace) {
        int entryLoc;
        if (encodedLen <= leftSpace && leftSpace >= rightSpace) {
            entryLoc = this.leftSegTail();
            this.leftSegTail(entryLoc + encodedLen);
        } else if (encodedLen <= rightSpace) {
            entryLoc = this.rightSegTail() - encodedLen + 1;
            this.rightSegTail(entryLoc - 1);
        } else {
            return -1;
        }
        return entryLoc;
    }

    private void copyToLeafEntry(byte[] okey, byte[] akey, int vfrag, byte[] value, int entryLoc) {
        byte[] page = this.mPage;
        int vloc = okey == akey ? Node.encodeNormalKey(akey, page, entryLoc) : Node.encodeFragmentedKey(akey, page, entryLoc);
        Node.copyToLeafValue(page, vfrag, value, vloc);
    }

    private static int copyToLeafValue(byte[] page, int vfrag, byte[] value, int vloc) {
        int vlen = value.length;
        vloc = Node.encodeLeafValueHeader(page, vfrag, vlen, vloc);
        PageOps.p_copyFromArray(value, 0, page, vloc, vlen);
        return vloc;
    }

    static int encodeLeafValueHeader(byte[] page, int vfrag, int vlen, int vloc) {
        if (vlen > 127 || vfrag != 0) {
            if (--vlen < 8192) {
                PageOps.p_bytePut(page, vloc++, 0x80 | vfrag | vlen >> 8);
            } else {
                PageOps.p_bytePut(page, vloc++, 0xA0 | vfrag | vlen >> 16);
                PageOps.p_bytePut(page, vloc++, vlen >> 8);
            }
        }
        PageOps.p_bytePut(page, vloc++, vlen);
        return vloc;
    }

    private int compactLeaf(int encodedLen, int pos, boolean forInsert) {
        byte[] page = this.mPage;
        int searchVecLoc = this.searchVecStart();
        int newSearchVecSize = this.searchVecEnd() - searchVecLoc + 2;
        if (forInsert) {
            newSearchVecSize += 2;
        }
        pos += searchVecLoc;
        int searchVecCap = this.garbage() + this.rightSegTail() + 1 - this.leftSegTail() - encodedLen;
        int newSearchVecStart = this.pageSize(page) - (searchVecCap + newSearchVecSize >> 1 & 0xFFFFFFFE);
        int destLoc = 12;
        int newSearchVecLoc = newSearchVecStart;
        int newLoc = 0;
        int searchVecEnd = this.searchVecEnd();
        byte[] dest = this.mGroup.acquireSparePage();
        while (searchVecLoc <= searchVecEnd) {
            block6: {
                block5: {
                    if (searchVecLoc != pos) break block5;
                    newLoc = newSearchVecLoc;
                    if (!forInsert) break block6;
                    newSearchVecLoc += 2;
                }
                PageOps.p_shortPutLE(dest, newSearchVecLoc, destLoc);
                int sourceLoc = PageOps.p_ushortGetLE(page, searchVecLoc);
                int len = Node.leafEntryLengthAtLoc(page, sourceLoc);
                PageOps.p_copy(page, sourceLoc, dest, destLoc, len);
                destLoc += len;
            }
            searchVecLoc += 2;
            newSearchVecLoc += 2;
        }
        this.mGroup.releaseSparePage(page);
        this.mPage = dest;
        this.garbage(0);
        PageOps.p_shortPutLE(dest, newLoc == 0 ? newSearchVecLoc : newLoc, destLoc);
        this.leftSegTail(destLoc + encodedLen);
        this.rightSegTail(this.pageSize(dest) - 1);
        this.searchVecStart(newSearchVecStart);
        this.searchVecEnd(newSearchVecStart + newSearchVecSize - 2);
        return destLoc;
    }

    private void cleanupSplit(Throwable cause, Node newNode, Split split) {
        if (split != null) {
            this.cleanupFragments(cause, split.fragmentedKey());
        }
        try {
            this.getDatabase().finishDeleteNode(newNode);
        }
        catch (Throwable e) {
            Utils.suppress(cause, e);
            this.panic(cause);
        }
    }

    void splitLeafAscendingAndCopyEntry(BTree tree, Node snode, int spos, int encodedLen) throws IOException {
        if (this.mSplit != null) {
            throw new AssertionError((Object)"Node is already split");
        }
        byte[] page = this.mPage;
        PageOps.checkClosedIndexException(page);
        Node newNode = tree.mDatabase.allocDirtyNode(1);
        tree.mDatabase.nodeMapPut(newNode);
        byte[] newPage = newNode.mPage;
        newNode.garbage(0);
        Split split = null;
        try {
            split = this.newSplitRight(newNode);
            split.setKey(tree, this.midKey(this.highestLeafPos(), snode, spos));
        }
        catch (Throwable e) {
            this.cleanupSplit(e, newNode, split);
            throw e;
        }
        this.mSplit = split;
        newNode.rightSegTail(this.pageSize(newPage) - 1);
        int newSearchVecStart = this.pageSize(newPage) - 2;
        newNode.searchVecStart(newSearchVecStart);
        newNode.searchVecEnd(newSearchVecStart);
        byte[] spage = snode.mPage;
        int sloc = PageOps.p_ushortGetLE(spage, snode.searchVecStart() + spos);
        PageOps.p_copy(spage, sloc, newPage, 12, encodedLen);
        PageOps.p_shortPutLE(newPage, this.pageSize(newPage) - 2, 12);
        newNode.leftSegTail(12 + encodedLen);
        newNode.releaseExclusive();
    }

    /*
     * Unable to fully structure code
     */
    private void splitLeafAndCreateEntry(BTree tree, byte[] okey, byte[] akey, int vfrag, byte[] value, int encodedLen, int pos, boolean forInsert) throws IOException {
        block31: {
            if (this.mSplit != null) {
                throw new AssertionError((Object)"Node is already split");
            }
            page = this.mPage;
            PageOps.checkClosedIndexException(page);
            newNode = tree.mDatabase.allocDirtyNode(1);
            tree.mDatabase.nodeMapPut(newNode);
            newPage = newNode.mPage;
            newNode.garbage(0);
            if (forInsert && pos == 0) {
                split = null;
                try {
                    split = this.newSplitLeft(newNode);
                    split.setKey(tree, this.midKey(okey, 0));
                }
                catch (Throwable e) {
                    this.cleanupSplit(e, newNode, split);
                    throw e;
                }
                this.mSplit = split;
                newNode.leftSegTail(12);
                newNode.searchVecStart(12);
                newNode.searchVecEnd(12);
                destLoc = this.pageSize(newPage) - encodedLen;
                newNode.copyToLeafEntry(okey, akey, vfrag, value, destLoc);
                PageOps.p_shortPutLE(newPage, 12, destLoc);
                newNode.rightSegTail(destLoc - 1);
                newNode.releaseExclusive();
                return;
            }
            searchVecStart = this.searchVecStart();
            searchVecEnd = this.searchVecEnd();
            if (forInsert && (pos += searchVecStart) == searchVecEnd + 2) {
                split = null;
                try {
                    split = this.newSplitRight(newNode);
                    split.setKey(tree, this.midKey(pos - searchVecStart - 2, okey));
                }
                catch (Throwable e) {
                    this.cleanupSplit(e, newNode, split);
                    throw e;
                }
                this.mSplit = split;
                newNode.rightSegTail(this.pageSize(newPage) - 1);
                newSearchVecStart = this.pageSize(newPage) - 2;
                newNode.searchVecStart(newSearchVecStart);
                newNode.searchVecEnd(newSearchVecStart);
                newNode.copyToLeafEntry(okey, akey, vfrag, value, 12);
                PageOps.p_shortPutLE(newPage, this.pageSize(newPage) - 2, 12);
                newNode.leftSegTail(12 + encodedLen);
                newNode.releaseExclusive();
                return;
            }
            avail = this.availableLeafBytes();
            garbageAccum = 0;
            newLoc = 0;
            newAvail = this.pageSize(newPage) - 12;
            if (pos - searchVecStart >= searchVecEnd - pos) break block31;
            destLoc = this.pageSize(newPage);
            newSearchVecLoc = 12;
            fv = null;
            searchVecLoc = searchVecStart;
            while (newAvail > avail) {
                block34: {
                    block32: {
                        block33: {
                            entryLoc = PageOps.p_ushortGetLE(page, searchVecLoc);
                            entryLen = Node.leafEntryLengthAtLoc(page, entryLoc);
                            if (searchVecLoc != pos) break block32;
                            if ((newAvail -= encodedLen + 2) < 0) {
                                if (vfrag != 0) break;
                                params = new FragParams();
                                params.value = value;
                                params.encodedLen = encodedLen;
                                params.available = newAvail += encodedLen + 2;
                                try {
                                    Node.fragmentValueForSplit(tree, params);
                                }
                                catch (Throwable e) {
                                    this.cleanupSplit(e, newNode, null);
                                    throw e;
                                }
                                vfrag = 64;
                                value = params.value;
                                fv = params.value;
                                encodedLen = params.encodedLen;
                                newAvail = params.available;
                            }
                            newLoc = newSearchVecLoc;
                            if (!forInsert) break block33;
                            newSearchVecLoc += 2;
                            if (newAvail <= avail) {
                                break;
                            }
                            break block32;
                        }
                        garbageAccum += entryLen;
                        avail += entryLen;
                        break block34;
                    }
                    if (searchVecLoc == searchVecEnd || (newAvail -= entryLen + 2) < 0) break;
                    PageOps.p_copy(page, entryLoc, newPage, destLoc -= entryLen, entryLen);
                    PageOps.p_shortPutLE(newPage, newSearchVecLoc, destLoc);
                    garbageAccum += entryLen;
                    avail += entryLen + 2;
                }
                searchVecLoc += 2;
                newSearchVecLoc += 2;
            }
            newNode.leftSegTail(12);
            newNode.searchVecStart(12);
            newNode.searchVecEnd(newSearchVecLoc - 2);
            originalStart = this.searchVecStart();
            originalGarbage = this.garbage();
            this.searchVecStart(searchVecLoc);
            this.garbage(originalGarbage + garbageAccum);
            try {
                this.mSplit = this.newSplitLeft(newNode);
                if (newLoc == 0) {
                    fv = this.storeIntoSplitLeaf(tree, okey, akey, vfrag, value, encodedLen, forInsert);
                } else {
                    newNode.copyToLeafEntry(okey, akey, vfrag, value, destLoc -= encodedLen);
                    PageOps.p_shortPutLE(newPage, newLoc, destLoc);
                }
                this.mSplit.setKey(tree, newNode.midKey(newNode.highestKeyPos(), this, 0));
                newNode.rightSegTail(destLoc - 1);
                newNode.releaseExclusive();
            }
            catch (Throwable e) {
                this.searchVecStart(originalStart);
                this.garbage(originalGarbage);
                this.cleanupFragments(e, fv);
                this.cleanupSplit(e, newNode, this.mSplit);
                this.mSplit = null;
                throw e;
            }
        }
        destLoc = 12;
        newSearchVecLoc = this.pageSize(newPage) - 2;
        fv = null;
        searchVecLoc = searchVecEnd;
        while (newAvail > avail) {
            block35: {
                entryLoc = PageOps.p_ushortGetLE(page, searchVecLoc);
                entryLen = Node.leafEntryLengthAtLoc(page, entryLoc);
                if (!forInsert) break block35;
                if (searchVecLoc + 2 == pos) {
                    if ((newAvail -= encodedLen + 2) < 0) {
                        if (vfrag != 0) break;
                        params = new FragParams();
                        params.value = value;
                        params.encodedLen = encodedLen;
                        params.available = newAvail += encodedLen + 2;
                        try {
                            Node.fragmentValueForSplit(tree, params);
                        }
                        catch (Throwable e) {
                            this.cleanupSplit(e, newNode, null);
                            throw e;
                        }
                        vfrag = 64;
                        value = params.value;
                        fv = params.value;
                        encodedLen = params.encodedLen;
                        newAvail = params.available;
                    }
                    newLoc = newSearchVecLoc;
                    newSearchVecLoc -= 2;
                    if (newAvail <= avail) {
                        break;
                    }
                }
                ** GOTO lbl-1000
            }
            if (searchVecLoc == pos) {
                if ((newAvail -= encodedLen + 2) < 0) {
                    if (vfrag != 0) break;
                    params = new FragParams();
                    params.value = value;
                    params.encodedLen = encodedLen;
                    params.available = newAvail += encodedLen + 2;
                    try {
                        Node.fragmentValueForSplit(tree, params);
                    }
                    catch (Throwable e) {
                        this.cleanupSplit(e, newNode, null);
                        throw e;
                    }
                    vfrag = 64;
                    value = params.value;
                    fv = params.value;
                    encodedLen = params.encodedLen;
                    newAvail = params.available;
                }
                newLoc = newSearchVecLoc;
                garbageAccum += entryLen;
                avail += entryLen;
            } else lbl-1000:
            // 2 sources

            {
                if (searchVecLoc == searchVecStart || (newAvail -= entryLen + 2) < 0) break;
                PageOps.p_copy(page, entryLoc, newPage, destLoc, entryLen);
                PageOps.p_shortPutLE(newPage, newSearchVecLoc, destLoc);
                destLoc += entryLen;
                garbageAccum += entryLen;
                avail += entryLen + 2;
            }
            searchVecLoc -= 2;
            newSearchVecLoc -= 2;
        }
        newNode.rightSegTail(this.pageSize(newPage) - 1);
        newNode.searchVecStart(newSearchVecLoc + 2);
        newNode.searchVecEnd(this.pageSize(newPage) - 2);
        originalEnd = this.searchVecEnd();
        originalGarbage = this.garbage();
        this.searchVecEnd(searchVecLoc);
        this.garbage(originalGarbage + garbageAccum);
        try {
            this.mSplit = this.newSplitRight(newNode);
            if (newLoc == 0) {
                fv = this.storeIntoSplitLeaf(tree, okey, akey, vfrag, value, encodedLen, forInsert);
            } else {
                newNode.copyToLeafEntry(okey, akey, vfrag, value, destLoc);
                PageOps.p_shortPutLE(newPage, newLoc, destLoc);
                destLoc += encodedLen;
            }
            this.mSplit.setKey(tree, this.midKey(this.highestKeyPos(), newNode, 0));
            newNode.leftSegTail(destLoc);
            newNode.releaseExclusive();
        }
        catch (Throwable e) {
            this.searchVecEnd(originalEnd);
            this.garbage(originalGarbage);
            this.cleanupFragments(e, fv);
            this.cleanupSplit(e, newNode, this.mSplit);
            this.mSplit = null;
            throw e;
        }
    }

    private static void fragmentValueForSplit(BTree tree, FragParams params) throws IOException {
        byte[] value = params.value;
        int encodedKeyLen = params.encodedLen - Node.calculateLeafValueLength(value);
        LocalDatabase db = tree.mDatabase;
        int max = Math.min(params.available - 2, db.mMaxFragmentedEntrySize) - encodedKeyLen;
        if ((value = db.fragment(value, value.length, max)) == null) {
            throw new AssertionError((Object)("Frag max: " + max));
        }
        params.value = value;
        params.encodedLen = encodedKeyLen + Node.calculateFragmentedValueLength(value);
        if ((params.available -= params.encodedLen + 2) < 0) {
            throw new AssertionError();
        }
    }

    private byte[] storeIntoSplitLeaf(BTree tree, byte[] okey, byte[] akey, int vfrag, byte[] value, int encodedLen, boolean forInsert) throws IOException {
        int pos = this.binarySearch(okey);
        if (!forInsert) {
            if (pos < 0) {
                throw new AssertionError((Object)"Key not found");
            }
            this.updateLeafValue(tree, pos, vfrag, value);
            return null;
        }
        if (pos >= 0) {
            throw new AssertionError((Object)"Key exists");
        }
        int entryLoc = this.createLeafEntry(null, tree, ~pos, encodedLen);
        byte[] result = null;
        while (entryLoc < 0) {
            if (vfrag != 0) {
                throw new DatabaseException("Fragmented entry doesn't fit");
            }
            FragParams params = new FragParams();
            params.value = value;
            params.encodedLen = encodedLen;
            params.available = ~entryLoc;
            Node.fragmentValueForSplit(tree, params);
            vfrag = 64;
            value = params.value;
            result = params.value;
            encodedLen = params.encodedLen;
            entryLoc = this.createLeafEntry(null, tree, ~pos, encodedLen);
        }
        this.copyToLeafEntry(okey, akey, vfrag, value, entryLoc);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void splitInternal(InResult result, int encodedLen, int keyPos, int newChildPos) throws IOException {
        int newKeyLoc;
        int garbageAccum;
        Split split;
        byte[] newPage;
        block34: {
            int searchVecLoc;
            int newSearchVecLoc;
            int destLoc;
            Node newNode;
            if (this.mSplit != null) {
                throw new AssertionError((Object)"Node is already split");
            }
            LocalDatabase db = this.getDatabase();
            try {
                newNode = db.allocDirtyNode(1);
            }
            catch (DatabaseFullException e) {
                db.capacityLimitOverride(-1L);
                try {
                    newNode = db.allocDirtyNode(1);
                }
                finally {
                    db.capacityLimitOverride(0L);
                }
            }
            db.nodeMapPut(newNode);
            newPage = newNode.mPage;
            newNode.garbage(0);
            byte[] page = this.mPage;
            int searchVecStart = this.searchVecStart();
            int searchVecEnd = this.searchVecEnd();
            if (searchVecEnd - searchVecStart == 2 && keyPos == 2) {
                Split split2;
                try {
                    split2 = this.newSplitLeft(newNode);
                }
                catch (Throwable e) {
                    this.cleanupSplit(e, newNode, null);
                    throw e;
                }
                result.mEntryLoc = -1;
                int leftKeyLoc = PageOps.p_ushortGetLE(page, searchVecStart);
                int leftKeyLen = Node.keyLengthAtLoc(page, leftKeyLoc);
                PageOps.p_copy(page, leftKeyLoc, newPage, 12, leftKeyLen);
                int leftSearchVecStart = this.pageSize(newPage) - 18;
                PageOps.p_shortPutLE(newPage, leftSearchVecStart, 12);
                if (newChildPos == 8) {
                    result.mPage = newPage;
                    result.mNewChildLoc = leftSearchVecStart + 10;
                } else {
                    if (newChildPos != 16) {
                        throw new AssertionError();
                    }
                    result.mPage = page;
                    result.mNewChildLoc = searchVecEnd + 10;
                }
                PageOps.p_copy(page, searchVecEnd + 2, newPage, leftSearchVecStart + 2, newChildPos);
                newNode.leftSegTail(12 + leftKeyLen);
                newNode.rightSegTail(leftSearchVecStart + 17);
                newNode.searchVecStart(leftSearchVecStart);
                newNode.searchVecEnd(leftSearchVecStart);
                newNode.releaseExclusive();
                PageOps.p_copy(page, searchVecEnd, page, searchVecEnd + 8, 2);
                int newSearchVecStart = searchVecEnd + 8;
                this.searchVecStart(newSearchVecStart);
                this.searchVecEnd(newSearchVecStart);
                this.garbage(this.garbage() + leftKeyLen);
                this.mSplit = split2;
                return;
            }
            result.mPage = newPage;
            int keyLoc = keyPos + searchVecStart;
            int splitSide = keyPos < searchVecEnd - searchVecStart - keyPos ? -1 : 1;
            split = null;
            block11: while (true) {
                boolean full;
                int sizeChange;
                int entryLen;
                int entryLoc;
                garbageAccum = 0;
                newKeyLoc = 0;
                int size = 5 * (searchVecEnd - searchVecStart) + 17 + this.leftSegTail() + this.pageSize(page) - this.rightSegTail() - this.garbage();
                int newSize = 12;
                size -= 8;
                newSize += 8;
                if (splitSide < 0) {
                    destLoc = this.pageSize(newPage);
                    newSearchVecLoc = 12;
                    searchVecLoc = searchVecStart;
                    while (true) {
                        if (searchVecLoc == keyLoc) {
                            newKeyLoc = newSearchVecLoc;
                            newSearchVecLoc += 2;
                            if ((newSize += encodedLen + 10) > this.pageSize(newPage)) {
                                if (splitSide == -1) {
                                    splitSide = 2;
                                    continue block11;
                                }
                                throw new AssertionError();
                            }
                        }
                        entryLoc = PageOps.p_ushortGetLE(page, searchVecLoc);
                        entryLen = Node.keyLengthAtLoc(page, entryLoc);
                        sizeChange = entryLen + 10;
                        searchVecLoc += 2;
                        garbageAccum += entryLen;
                        full = (size -= sizeChange) < 12 | (newSize += sizeChange) > this.pageSize(newPage);
                        if (full || newSize >= size) {
                            if (newKeyLoc != 0) {
                                try {
                                    split = this.newSplitLeft(newNode);
                                    this.retrieveKeyAtLoc(page, entryLoc, split);
                                    break;
                                }
                                catch (Throwable e) {
                                    this.cleanupSplit(e, newNode, split);
                                    throw e;
                                }
                            }
                            if (splitSide == -1) {
                                splitSide = 2;
                                continue block11;
                            }
                            if (full || splitSide != -2) {
                                throw new AssertionError();
                            }
                        }
                        PageOps.p_copy(page, entryLoc, newPage, destLoc -= entryLen, entryLen);
                        PageOps.p_shortPutLE(newPage, newSearchVecLoc, destLoc);
                        newSearchVecLoc += 2;
                    }
                    result.mEntryLoc = destLoc - encodedLen;
                    PageOps.p_copy(page, searchVecEnd + 2, newPage, newSearchVecLoc, newChildPos);
                    result.mNewChildLoc = newSearchVecLoc + newChildPos;
                    int tailChildIdsLen = (searchVecLoc - searchVecStart << 2) - newChildPos;
                    PageOps.p_copy(page, searchVecEnd + 2 + newChildPos, newPage, newSearchVecLoc + newChildPos + 8, tailChildIdsLen);
                    newNode.leftSegTail(12);
                    newNode.rightSegTail(destLoc - encodedLen - 1);
                    newNode.searchVecStart(12);
                    newNode.searchVecEnd(newSearchVecLoc - 2);
                    newNode.releaseExclusive();
                    int shift = searchVecLoc - searchVecStart << 2;
                    int len = searchVecEnd - searchVecLoc + 2;
                    int newSearchVecStart = searchVecLoc + shift;
                    PageOps.p_copy(page, searchVecLoc, page, newSearchVecStart, len);
                    this.searchVecStart(newSearchVecStart);
                    this.searchVecEnd(searchVecEnd + shift);
                    break block34;
                }
                destLoc = 12;
                newSearchVecLoc = this.pageSize(newPage);
                searchVecLoc = searchVecEnd + 2;
                while (true) {
                    if (searchVecLoc == keyLoc) {
                        newKeyLoc = newSearchVecLoc -= 2;
                        if ((newSize += encodedLen + 10) > this.pageSize(newPage)) {
                            if (splitSide == 1) {
                                splitSide = -2;
                                continue block11;
                            }
                            throw new AssertionError();
                        }
                    }
                    entryLoc = PageOps.p_ushortGetLE(page, searchVecLoc -= 2);
                    entryLen = Node.keyLengthAtLoc(page, entryLoc);
                    sizeChange = entryLen + 10;
                    garbageAccum += entryLen;
                    full = (size -= sizeChange) < 12 | (newSize += sizeChange) > this.pageSize(newPage);
                    if (full || newSize >= size) {
                        if (newKeyLoc != 0) {
                            try {
                                split = this.newSplitRight(newNode);
                                this.retrieveKeyAtLoc(page, entryLoc, split);
                                break block11;
                            }
                            catch (Throwable e) {
                                this.cleanupSplit(e, newNode, split);
                                throw e;
                            }
                        }
                        if (splitSide == 1) {
                            splitSide = -2;
                            continue block11;
                        }
                        if (full || splitSide != 2) {
                            throw new AssertionError();
                        }
                    }
                    PageOps.p_copy(page, entryLoc, newPage, destLoc, entryLen);
                    PageOps.p_shortPutLE(newPage, newSearchVecLoc -= 2, destLoc);
                    destLoc += entryLen;
                }
                break;
            }
            result.mEntryLoc = destLoc;
            int newVecLen = this.pageSize(page) - newSearchVecLoc;
            int highestLoc = this.pageSize(newPage) - 5 * newVecLen - 8;
            int midLoc = destLoc + encodedLen + highestLoc + 1 >> 1 & 0xFFFFFFFE;
            PageOps.p_copy(newPage, newSearchVecLoc, newPage, midLoc, newVecLen);
            newKeyLoc -= newSearchVecLoc - midLoc;
            newSearchVecLoc = midLoc;
            int newSearchVecEnd = newSearchVecLoc + newVecLen - 2;
            int headChildIdsLen = newChildPos - (searchVecLoc - searchVecStart + 2 << 2);
            int newDestLoc = newSearchVecEnd + 2;
            PageOps.p_copy(page, searchVecEnd + 2 + newChildPos - headChildIdsLen, newPage, newDestLoc, headChildIdsLen);
            result.mNewChildLoc = newDestLoc += headChildIdsLen;
            int tailChildIdsLen = (searchVecEnd - searchVecStart << 2) + 16 - newChildPos;
            PageOps.p_copy(page, searchVecEnd + 2 + newChildPos, newPage, newDestLoc + 8, tailChildIdsLen);
            newNode.leftSegTail(destLoc + encodedLen);
            newNode.rightSegTail(this.pageSize(newPage) - 1);
            newNode.searchVecStart(newSearchVecLoc);
            newNode.searchVecEnd(newSearchVecEnd);
            newNode.releaseExclusive();
            int len = searchVecLoc - searchVecStart;
            int newSearchVecStart = searchVecEnd + 2 - len;
            PageOps.p_copy(page, searchVecStart, page, newSearchVecStart, len);
            this.searchVecStart(newSearchVecStart);
        }
        this.garbage(this.garbage() + garbageAccum);
        this.mSplit = split;
        PageOps.p_shortPutLE(newPage, newKeyLoc, result.mEntryLoc);
    }

    private void compactInternal(InResult result, int encodedLen, int keyPos, int childPos) {
        byte[] page = this.mPage;
        int searchVecLoc = this.searchVecStart();
        keyPos += searchVecLoc;
        int newSearchVecSize = this.searchVecEnd() - searchVecLoc + 4 + (childPos >> 30);
        int searchVecCap = this.garbage() + this.rightSegTail() + 1 - this.leftSegTail() - encodedLen;
        int newSearchVecStart = this.pageSize(page) - (searchVecCap + newSearchVecSize + (newSearchVecSize + 2 << 2) >> 1 & 0xFFFFFFFE);
        int destLoc = 12;
        int newSearchVecLoc = newSearchVecStart;
        int newLoc = 0;
        int searchVecEnd = this.searchVecEnd();
        byte[] dest = this.mGroup.acquireSparePage();
        while (searchVecLoc <= searchVecEnd) {
            block9: {
                block8: {
                    if (searchVecLoc != keyPos) break block8;
                    newLoc = newSearchVecLoc;
                    if (childPos < 0) break block9;
                    newSearchVecLoc += 2;
                }
                PageOps.p_shortPutLE(dest, newSearchVecLoc, destLoc);
                int sourceLoc = PageOps.p_ushortGetLE(page, searchVecLoc);
                int len = Node.keyLengthAtLoc(page, sourceLoc);
                PageOps.p_copy(page, sourceLoc, dest, destLoc, len);
                destLoc += len;
            }
            searchVecLoc += 2;
            newSearchVecLoc += 2;
        }
        if (childPos >= 0) {
            if (newLoc == 0) {
                newLoc = newSearchVecLoc;
                newSearchVecLoc += 2;
            }
            PageOps.p_copy(page, this.searchVecEnd() + 2, dest, newSearchVecLoc, childPos);
            PageOps.p_copy(page, this.searchVecEnd() + 2 + childPos, dest, newSearchVecLoc + childPos + 8, (newSearchVecSize << 2) - childPos);
        } else {
            if (newLoc == 0) {
                newLoc = newSearchVecLoc;
            }
            PageOps.p_copy(page, this.searchVecEnd() + 2, dest, newSearchVecLoc, (newSearchVecSize << 2) + 8);
        }
        this.mGroup.releaseSparePage(page);
        this.mPage = dest;
        this.garbage(0);
        PageOps.p_shortPutLE(dest, newLoc, destLoc);
        this.leftSegTail(destLoc + encodedLen);
        this.rightSegTail(this.pageSize(dest) - 1);
        this.searchVecStart(newSearchVecStart);
        this.searchVecEnd(newSearchVecLoc - 2);
        result.mPage = dest;
        result.mNewChildLoc = newSearchVecLoc + childPos;
        result.mEntryLoc = destLoc;
    }

    private Split newSplitLeft(Node newNode) {
        Split split = new Split(false, newNode);
        newNode.type((byte)(this.type() & 0xFFFFFFF7));
        this.type((byte)(this.type() & 0xFFFFFFFD));
        return split;
    }

    private Split newSplitRight(Node newNode) {
        Split split = new Split(true, newNode);
        newNode.type((byte)(this.type() & 0xFFFFFFFD));
        this.type((byte)(this.type() & 0xFFFFFFF7));
        return split;
    }

    static Node appendToSortLeaf(Node node, LocalDatabase db, byte[] okey, byte[] value, Supplier supplier) throws IOException {
        byte[] akey = okey;
        int encodedKeyLen = Node.calculateAllowedKeyLength(db, okey);
        if (encodedKeyLen < 0) {
            akey = db.fragmentKey(okey);
            encodedKeyLen = 2 + akey.length;
        }
        try {
            int vfrag;
            int encodedLen = encodedKeyLen + Node.calculateLeafValueLength(value);
            if (encodedLen <= db.mMaxEntrySize) {
                vfrag = 0;
            } else {
                if ((value = db.fragment(value, value.length, db.mMaxFragmentedEntrySize - encodedKeyLen)) == null) {
                    throw new AssertionError();
                }
                encodedLen = encodedKeyLen + Node.calculateFragmentedValueLength(value);
                vfrag = 64;
            }
            try {
                int start;
                int tail;
                byte[] page;
                while (true) {
                    page = node.mPage;
                    tail = node.leftSegTail();
                    if (tail == 12) {
                        if (PageOps.isClosedOrDeleted(page)) {
                            throw new DatabaseException("Closed");
                        }
                        start = node.pageSize(page) - 2;
                        node.searchVecEnd(start);
                        break;
                    }
                    start = node.searchVecStart() - 2;
                    if (encodedLen <= start - tail) break;
                    node.releaseExclusive();
                    node = supplier.newNode();
                }
                node.copyToLeafEntry(okey, akey, vfrag, value, tail);
                node.leftSegTail(tail + encodedLen);
                PageOps.p_shortPutLE(page, start, tail);
                node.searchVecStart(start);
                return node;
            }
            catch (Throwable e) {
                if (vfrag == 64) {
                    node.cleanupFragments(e, value);
                }
                throw e;
            }
        }
        catch (Throwable e) {
            if (okey != akey) {
                node.cleanupFragments(e, akey);
            }
            throw e;
        }
    }

    void sortLeaf() throws IOException {
        int halfPos;
        int len = this.searchVecEnd() + 2 - this.searchVecStart();
        if (len <= 2) {
            return;
        }
        int pos = halfPos = len >>> 1 & 0xFFFFFFFE;
        while ((pos -= 2) >= 0) {
            this.siftDownLeaf(pos, len, halfPos);
        }
        byte[] page = this.mPage;
        int start = this.searchVecStart();
        int lastHighLoc = -1;
        int vecPos = start + len;
        int pos2 = len - 2;
        do {
            int highLoc = PageOps.p_ushortGetLE(page, start);
            PageOps.p_shortPutLE(page, start, PageOps.p_ushortGetLE(page, start + pos2));
            if (highLoc != lastHighLoc) {
                PageOps.p_shortPutLE(page, vecPos -= 2, highLoc);
                lastHighLoc = highLoc;
            }
            if (pos2 <= 2) continue;
            this.siftDownLeaf(0, pos2, pos2 >>> 1 & 0xFFFFFFFE);
        } while ((pos2 -= 2) >= 0);
        this.searchVecStart(vecPos);
    }

    private void siftDownLeaf(int pos, int endPos, int halfPos) throws IOException {
        byte[] page = this.mPage;
        int start = this.searchVecStart();
        int loc = PageOps.p_ushortGetLE(page, start + pos);
        do {
            int compare;
            int childPos = (pos << 1) + 2;
            int childLoc = PageOps.p_ushortGetLE(page, start + childPos);
            int rightPos = childPos + 2;
            if (rightPos < endPos) {
                int rightLoc = PageOps.p_ushortGetLE(page, start + rightPos);
                int compare2 = Node.compareKeys(this, childLoc, this, rightLoc);
                if (compare2 < 0) {
                    childPos = rightPos;
                    childLoc = rightLoc;
                } else if (compare2 == 0) {
                    if (childLoc < rightLoc) {
                        this.replaceDuplicateLeafEntry(page, childLoc, rightLoc);
                        if (loc == childLoc) {
                            return;
                        }
                        childLoc = rightLoc;
                    } else if (childLoc > rightLoc) {
                        this.replaceDuplicateLeafEntry(page, rightLoc, childLoc);
                        if (loc == rightLoc) {
                            return;
                        }
                    }
                }
            }
            if ((compare = Node.compareKeys(this, loc, this, childLoc)) >= 0) {
                if (compare != 0) break;
                if (loc < childLoc) {
                    this.replaceDuplicateLeafEntry(page, loc, childLoc);
                    loc = childLoc;
                    break;
                }
                if (loc <= childLoc) break;
                this.replaceDuplicateLeafEntry(page, childLoc, loc);
                break;
            }
            PageOps.p_shortPutLE(page, start + pos, childLoc);
            pos = childPos;
        } while (pos < halfPos);
        PageOps.p_shortPutLE(page, start + pos, loc);
    }

    private void replaceDuplicateLeafEntry(byte[] page, int loc, int newLoc) throws IOException {
        int entryLen = this.doDeleteLeafEntry(page, loc) - loc;
        this.garbage(this.garbage() + entryLen);
        PageOps.p_shortPutLE(page, loc, 32768);
        PageOps.p_bytePut(page, loc + 2, -1);
        int endPos = this.searchVecEnd();
        for (int pos = this.searchVecStart(); pos <= endPos; pos += 2) {
            if (PageOps.p_ushortGetLE(page, pos) != loc) continue;
            PageOps.p_shortPutLE(page, pos, newLoc);
        }
    }

    void deleteFirstSortLeafEntry() throws IOException {
        byte[] page = this.mPage;
        int start = this.searchVecStart();
        this.doDeleteLeafEntry(page, PageOps.p_ushortGetLE(page, start));
        this.searchVecStart(start + 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long countCursors(boolean strict) {
        if (this.tryAcquireExclusive()) {
            long count = 0L;
            try {
                CursorFrame frame = this.mLastCursorFrame;
                while (frame != null) {
                    if (!(frame instanceof GhostFrame)) {
                        ++count;
                    }
                    frame = frame.mPrevCousin;
                }
            }
            finally {
                this.releaseExclusive();
            }
            return count;
        }
        if (strict) {
            this.acquireShared();
        } else if (!this.tryAcquireShared()) {
            return 0L;
        }
        try {
            CursorFrame lockResult;
            CursorFrame frame = this.mLastCursorFrame;
            if (frame == null) {
                long l = 0L;
                return l;
            }
            CursorFrame lock = new CursorFrame();
            while ((lockResult = frame.tryLock(lock)) == null) {
                frame = frame.mPrevCousin;
                if (frame != null) continue;
                long l = 0L;
                return l;
            }
            long count = 0L;
            while (true) {
                if (!(frame instanceof GhostFrame)) {
                    ++count;
                }
                CursorFrame prev = frame.tryLockPrevious(lock);
                frame.unlock(lockResult);
                if (prev == null) {
                    long l = count;
                    return l;
                }
                lockResult = frame;
                frame = prev;
            }
        }
        finally {
            this.releaseShared();
        }
    }

    @Override
    public String toString() {
        String prefix;
        switch (this.type()) {
            case 64: {
                return "UndoNode{id=" + this.id() + ", cachedState=" + this.mCachedState + ", topEntry=" + this.garbage() + ", lowerNodeId=" + PageOps.p_longGetLE(this.mPage, 4) + ", latchState=" + super.toString() + "}";
            }
            case 32: {
                return "FragmentNode{id=" + this.id() + ", cachedState=" + this.mCachedState + ", latchState=" + super.toString() + "}";
            }
            case 100: 
            case 102: 
            case 108: 
            case 110: {
                prefix = "Internal";
                break;
            }
            case 116: 
            case 118: 
            case 124: 
            case 126: {
                prefix = "BottomInternal";
                break;
            }
            default: {
                if (!this.isLeaf()) {
                    return "Node{id=" + this.id() + ", cachedState=" + this.mCachedState + ", latchState=" + super.toString() + "}";
                }
            }
            case -128: {
                prefix = "Leaf";
            }
        }
        char[] extremity = new char[]{'_', '_'};
        if ((this.type() & 2) != 0) {
            extremity[0] = 76;
        }
        if ((this.type() & 8) != 0) {
            extremity[1] = 72;
        }
        return prefix + "Node{id=" + this.id() + ", cachedState=" + this.mCachedState + ", isSplit=" + (this.mSplit != null) + ", availableBytes=" + this.availableBytes() + ", extremity=" + new String(extremity) + ", latchState=" + super.toString() + "}";
    }

    boolean verifyTreeNode(int level, VerificationObserver observer) throws IOException {
        return this.verifyTreeNode(level, observer, false);
    }

    private boolean verifyTreeNode(int level, VerificationObserver observer, boolean fix) throws IOException {
        int type = this.type() & 0xFFFFFFF5;
        if (type != 100 && type != 116 && !this.isLeaf()) {
            return this.verifyFailed(level, observer, "Not a tree node: " + type);
        }
        byte[] page = this.mPage;
        if (!fix) {
            if (this.leftSegTail() < 12) {
                return this.verifyFailed(level, observer, "Left segment tail: " + this.leftSegTail());
            }
            if (this.searchVecStart() < this.leftSegTail()) {
                return this.verifyFailed(level, observer, "Search vector start: " + this.searchVecStart());
            }
            if (this.searchVecEnd() < this.searchVecStart() - 2) {
                return this.verifyFailed(level, observer, "Search vector end: " + this.searchVecEnd());
            }
            if (this.rightSegTail() < this.searchVecEnd() || this.rightSegTail() > this.pageSize(page) - 1) {
                return this.verifyFailed(level, observer, "Right segment tail: " + this.rightSegTail());
            }
        }
        if (!this.isLeaf()) {
            int childIdsStart = this.searchVecEnd() + 2;
            int childIdsEnd = childIdsStart + (childIdsStart - this.searchVecStart() << 2) + 8;
            if (childIdsEnd > this.rightSegTail() + 1) {
                return this.verifyFailed(level, observer, "Child ids end: " + childIdsEnd);
            }
            LHashTable.Int childIds = new LHashTable.Int(512);
            for (int i = childIdsStart; i < childIdsEnd; i += 8) {
                long childId = PageOps.p_uint48GetLE(page, i);
                if (this.id() > 1L && childId <= 1L) {
                    return this.verifyFailed(level, observer, "Illegal child id: " + childId);
                }
                LHashTable.IntEntry e = (LHashTable.IntEntry)childIds.insert(childId);
                if (e.value != 0) {
                    return this.verifyFailed(level, observer, "Duplicate child id: " + childId);
                }
                e.value = 1;
            }
        }
        int used = 12;
        int leftTail = 12;
        int rightTail = this.pageSize(page);
        int largeValueCount = 0;
        int lastKeyLoc = 0;
        for (int i = this.searchVecStart(); i <= this.searchVecEnd(); i += 2) {
            int loc;
            block31: {
                int result;
                int keyLen;
                int keyLoc = PageOps.p_ushortGetLE(page, i);
                loc = keyLoc;
                if (loc < 12 || loc >= this.pageSize(page) || !fix && loc >= this.leftSegTail() && loc <= this.rightSegTail()) {
                    return this.verifyFailed(level, observer, "Entry location: " + loc);
                }
                used = this.isLeaf() ? (used += Node.leafEntryLengthAtLoc(page, loc)) : (used += Node.keyLengthAtLoc(page, loc));
                if (loc > this.searchVecEnd()) {
                    rightTail = Math.min(loc, rightTail);
                }
                try {
                    keyLen = PageOps.p_byteGet(page, loc++);
                    keyLen = keyLen >= 0 ? keyLen + 1 : (keyLen & 0x3F) << 8 | PageOps.p_ubyteGet(page, loc++);
                }
                catch (IndexOutOfBoundsException e) {
                    return this.verifyFailed(level, observer, "Key location out of bounds");
                }
                if ((loc += keyLen) > this.pageSize(page)) {
                    return this.verifyFailed(level, observer, "Key end location: " + loc);
                }
                if (lastKeyLoc != 0 && (result = Node.compareKeys(this, lastKeyLoc, this, keyLoc)) >= 0) {
                    return this.verifyFailed(level, observer, "Key order: " + result);
                }
                lastKeyLoc = keyLoc;
                if (this.isLeaf()) {
                    int len;
                    block30: {
                        try {
                            int header = PageOps.p_byteGet(page, loc++);
                            if (header >= 0) {
                                len = header;
                                break block30;
                            }
                            if ((header & 0x20) == 0) {
                                len = 1 + ((header & 0x1F) << 8 | PageOps.p_ubyteGet(page, loc++));
                            } else {
                                if (header == -1) break block31;
                                len = 1 + ((header & 0xF) << 16 | PageOps.p_ubyteGet(page, loc++) << 8 | PageOps.p_ubyteGet(page, loc++));
                            }
                            if ((header & 0x40) != 0) {
                                ++largeValueCount;
                            }
                        }
                        catch (IndexOutOfBoundsException e) {
                            return this.verifyFailed(level, observer, "Value location out of bounds");
                        }
                    }
                    if ((loc += len) > this.pageSize(page)) {
                        return this.verifyFailed(level, observer, "Value end location: " + loc);
                    }
                }
            }
            if (loc > this.searchVecStart()) continue;
            leftTail = Math.max(leftTail, loc);
        }
        if (fix) {
            garbage = this.pageSize(page) - (used + rightTail - leftTail);
            this.garbage(garbage);
            this.leftSegTail(leftTail);
            this.rightSegTail(rightTail - 1);
        } else {
            garbage = this.pageSize(page) - (used += this.rightSegTail() + 1 - this.leftSegTail());
            if (this.garbage() != garbage && this.id() > 1L) {
                return this.verifyFailed(level, observer, "Garbage: " + this.garbage() + " != " + garbage);
            }
        }
        if (observer == null) {
            return true;
        }
        int entryCount = this.numKeys();
        int freeBytes = this.availableBytes();
        long id = this.id();
        this.releaseShared();
        return observer.indexNodePassed(id, level, entryCount, freeBytes, largeValueCount);
    }

    private boolean verifyFailed(int level, VerificationObserver observer, String message) throws CorruptDatabaseException {
        if (observer == null) {
            throw new CorruptDatabaseException(message);
        }
        long id = this.id();
        this.releaseShared();
        observer.failed = true;
        return observer.indexNodeFailed(id, level, message);
    }

    static {
        try {
            cIdHandle = MethodHandles.lookup().findVarHandle(Node.class, "mId", Long.TYPE);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    static final class InResult {
        byte[] mPage;
        int mNewChildLoc;
        int mEntryLoc;

        InResult() {
        }
    }

    private static final class FragParams {
        byte[] value;
        int encodedLen;
        int available;

        private FragParams() {
        }
    }

    @FunctionalInterface
    static interface Supplier {
        public Node newNode() throws IOException;
    }
}

