/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.core.Checkpointer;
import org.cojen.tupl.core.LocalDatabase;
import org.cojen.tupl.core.Node;
import org.cojen.tupl.core.PageDb;
import org.cojen.tupl.core.PageOps;
import org.cojen.tupl.util.Clutch;
import org.cojen.tupl.util.Latch;

final class NodeGroup
extends Clutch.Pack
implements Checkpointer.DirtySet {
    static final int MODE_UNEVICTABLE = 1;
    static final int MODE_NO_EVICT = 2;
    private static final int PACK_SLOTS = 64;
    final LocalDatabase mDatabase;
    private final int mPageSize;
    private final long mUsedRate;
    private int mMaxSize;
    private int mSize;
    private Node mMostRecentlyUsed;
    private Node mLeastRecentlyUsed;
    private Node mFirstDirty;
    private Node mLastDirty;
    private long mDirtyCount;
    private Node mFlushNext;
    private final Latch mSparePageLatch;
    private byte[] mSparePage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeGroup(LocalDatabase db, long usedRate, int maxSize) {
        super(64);
        if (maxSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.mDatabase = db;
        this.mPageSize = db.pageSize();
        this.mUsedRate = usedRate;
        this.acquireExclusive();
        this.mMaxSize = maxSize;
        this.releaseExclusive();
        this.mSparePageLatch = new Latch();
        this.mSparePageLatch.acquireExclusive();
        try {
            this.mSparePage = PageOps.p_callocPage(db.mPageDb.directPageSize());
        }
        finally {
            this.mSparePageLatch.releaseExclusive();
        }
    }

    int pageSize() {
        return this.mPageSize;
    }

    void initialize(Object arena, int min) throws DatabaseException, OutOfMemoryError {
        while (--min >= 0) {
            this.acquireExclusive();
            if (this.mSize >= this.mMaxSize) {
                this.releaseExclusive();
                break;
            }
            this.doAllocLatchedNode(arena, 0).releaseExclusive();
        }
    }

    int nodeCount() {
        this.acquireShared();
        int size = this.mSize;
        this.releaseShared();
        return size;
    }

    Node tryAllocLatchedNode(int trial, int mode) throws IOException {
        this.acquireExclusive();
        int limit = this.mSize;
        do {
            Node moreUsed;
            Node node;
            if ((node = this.mLeastRecentlyUsed) == null || (moreUsed = node.mMoreUsed) == null) {
                if (this.mSize < this.mMaxSize) {
                    return this.doAllocLatchedNode(null, mode);
                }
                if (node == null) {
                    break;
                }
            } else {
                moreUsed.mLessUsed = null;
                this.mLeastRecentlyUsed = moreUsed;
                node.mMoreUsed = null;
                node.mLessUsed = this.mMostRecentlyUsed;
                this.mMostRecentlyUsed.mMoreUsed = node;
                this.mMostRecentlyUsed = node;
            }
            if (!node.tryAcquireExclusive()) continue;
            if (trial == 1) {
                if (node.mCachedState != 0) {
                    if (this.mSize < this.mMaxSize) {
                        node.releaseExclusive();
                        return this.doAllocLatchedNode(null, mode);
                    }
                    if ((mode & 2) != 0) {
                        node.releaseExclusive();
                        break;
                    }
                }
                this.releaseExclusive();
                if (node.evict(this.mDatabase)) {
                    if ((mode & 1) != 0) {
                        node.mGroup.makeUnevictable(node);
                    }
                    return node;
                }
                this.acquireExclusive();
                continue;
            }
            if ((mode & 2) != 0 && node.mCachedState != 0) {
                node.releaseExclusive();
                break;
            }
            try {
                if (node.evict(this.mDatabase)) {
                    if ((mode & 1) != 0) {
                        NodeGroup group = node.mGroup;
                        if (group == this) {
                            this.doMakeUnevictable(node);
                        } else {
                            this.releaseExclusive();
                            group.makeUnevictable(node);
                            return node;
                        }
                    }
                    this.releaseExclusive();
                    return node;
                }
            }
            catch (Throwable e) {
                this.releaseExclusive();
                throw e;
            }
        } while (--limit > 0);
        this.releaseExclusive();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node doAllocLatchedNode(Object arena, int mode) throws DatabaseException {
        try {
            this.mDatabase.checkClosed();
            byte[] page = PageOps.p_callocPage(arena, this.mDatabase.mPageDb.directPageSize());
            Node node = new Node(this, page);
            node.acquireExclusive();
            ++this.mSize;
            if ((mode & 1) == 0) {
                Node most;
                node.mLessUsed = most = this.mMostRecentlyUsed;
                if (most == null) {
                    this.mLeastRecentlyUsed = node;
                } else {
                    most.mMoreUsed = node;
                }
                this.mMostRecentlyUsed = node;
            }
            Node node2 = node;
            return node2;
        }
        finally {
            this.releaseExclusive();
        }
    }

    void used(Node node, ThreadLocalRandom rnd) {
        if ((rnd.nextLong() & this.mUsedRate) == 0L && this.tryAcquireExclusive()) {
            this.doUsed(node);
        }
    }

    private void doUsed(Node node) {
        Node moreUsed = node.mMoreUsed;
        if (moreUsed != null) {
            Node lessUsed;
            moreUsed.mLessUsed = lessUsed = node.mLessUsed;
            if (lessUsed == null) {
                this.mLeastRecentlyUsed = moreUsed;
            } else {
                lessUsed.mMoreUsed = moreUsed;
            }
            node.mMoreUsed = null;
            node.mLessUsed = this.mMostRecentlyUsed;
            this.mMostRecentlyUsed.mMoreUsed = node;
            this.mMostRecentlyUsed = node;
        }
        this.releaseExclusive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unused(Node node) {
        try {
            this.acquireExclusive();
        }
        catch (Throwable e) {
            node.releaseExclusive();
            throw e;
        }
        try {
            Node lessUsed = node.mLessUsed;
            if (lessUsed != null) {
                Node moreUsed;
                lessUsed.mMoreUsed = moreUsed = node.mMoreUsed;
                if (moreUsed == null) {
                    this.mMostRecentlyUsed = lessUsed;
                } else {
                    moreUsed.mLessUsed = lessUsed;
                }
                node.mLessUsed = null;
                node.mMoreUsed = this.mLeastRecentlyUsed;
                this.mLeastRecentlyUsed.mLessUsed = node;
                this.mLeastRecentlyUsed = node;
            } else if (this.mMaxSize != 0) {
                this.doMakeEvictableNow(node);
            }
        }
        finally {
            node.releaseExclusive();
            this.releaseExclusive();
        }
    }

    void makeEvictable(Node node) {
        this.acquireExclusive();
        try {
            Node most;
            if (this.mMaxSize != 0 && node.mMoreUsed == null && node != (most = this.mMostRecentlyUsed)) {
                node.mLessUsed = most;
                if (most == null) {
                    this.mLeastRecentlyUsed = node;
                } else {
                    most.mMoreUsed = node;
                }
                this.mMostRecentlyUsed = node;
            }
        }
        finally {
            this.releaseExclusive();
        }
    }

    void makeEvictableNow(Node node) {
        this.acquireExclusive();
        try {
            if (this.mMaxSize != 0 && node.mLessUsed == null) {
                this.doMakeEvictableNow(node);
            }
        }
        finally {
            this.releaseExclusive();
        }
    }

    private void doMakeEvictableNow(Node node) {
        Node least = this.mLeastRecentlyUsed;
        if (node != least) {
            node.mMoreUsed = least;
            if (least == null) {
                this.mMostRecentlyUsed = node;
            } else {
                least.mLessUsed = node;
            }
            this.mLeastRecentlyUsed = node;
        }
    }

    void makeUnevictable(Node node) {
        this.acquireExclusive();
        try {
            if (this.mMaxSize != 0) {
                this.doMakeUnevictable(node);
            }
        }
        finally {
            this.releaseExclusive();
        }
    }

    private void doMakeUnevictable(Node node) {
        Node lessUsed = node.mLessUsed;
        Node moreUsed = node.mMoreUsed;
        if (lessUsed != null) {
            node.mLessUsed = null;
            if (moreUsed != null) {
                node.mMoreUsed = null;
                lessUsed.mMoreUsed = moreUsed;
                moreUsed.mLessUsed = lessUsed;
            } else if (node == this.mMostRecentlyUsed) {
                this.mMostRecentlyUsed = lessUsed;
                lessUsed.mMoreUsed = null;
            }
        } else if (node == this.mLeastRecentlyUsed) {
            this.mLeastRecentlyUsed = moreUsed;
            if (moreUsed != null) {
                node.mMoreUsed = null;
                moreUsed.mLessUsed = null;
            } else {
                this.mMostRecentlyUsed = null;
            }
        }
    }

    synchronized void addDirty(Node node, byte cachedState) {
        node.mCachedState = cachedState;
        Node next = node.mNextDirty;
        Node prev = node.mPrevDirty;
        if (next != null) {
            next.mPrevDirty = prev;
            if (next.mPrevDirty == null) {
                this.mFirstDirty = next;
            } else {
                prev.mNextDirty = next;
            }
            node.mNextDirty = null;
            node.mPrevDirty = this.mLastDirty;
            this.mLastDirty.mNextDirty = node;
        } else if (prev == null) {
            Node last = this.mLastDirty;
            if (last == node) {
                return;
            }
            ++this.mDirtyCount;
            if (last == null) {
                this.mFirstDirty = node;
            } else {
                node.mPrevDirty = last;
                last.mNextDirty = node;
            }
        }
        this.mLastDirty = node;
        if (this.mFlushNext == node) {
            this.mFlushNext = next;
        }
    }

    synchronized void swapIfDirty(Node oldNode, Node newNode) {
        Node prev;
        Node next = oldNode.mNextDirty;
        if (next != null) {
            newNode.mNextDirty = next;
            next.mPrevDirty = newNode;
            oldNode.mNextDirty = null;
        }
        if ((prev = oldNode.mPrevDirty) != null) {
            newNode.mPrevDirty = prev;
            prev.mNextDirty = newNode;
            oldNode.mPrevDirty = null;
        }
        if (oldNode == this.mFirstDirty) {
            this.mFirstDirty = newNode;
        }
        if (oldNode == this.mLastDirty) {
            this.mLastDirty = newNode;
        }
        if (oldNode == this.mFlushNext) {
            this.mFlushNext = newNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushDirty(int dirtyState) throws IOException {
        PageDb pageDb = this.mDatabase.mPageDb;
        NodeGroup nodeGroup = this;
        synchronized (nodeGroup) {
            this.mFlushNext = this.mFirstDirty;
        }
        while (true) {
            byte state;
            Node node;
            NodeGroup nodeGroup2 = this;
            synchronized (nodeGroup2) {
                node = this.mFlushNext;
                if (node == null) {
                    return;
                }
                state = node.mCachedState;
                if (state == (dirtyState ^ 1)) {
                    this.mFlushNext = null;
                    return;
                }
                this.mFlushNext = node.mNextDirty;
                Node next = node.mNextDirty;
                Node prev = node.mPrevDirty;
                if (next != null) {
                    next.mPrevDirty = prev;
                    node.mNextDirty = null;
                } else if (this.mLastDirty == node) {
                    this.mLastDirty = prev;
                }
                if (prev != null) {
                    prev.mNextDirty = next;
                    node.mPrevDirty = null;
                } else if (this.mFirstDirty == node) {
                    this.mFirstDirty = next;
                }
                --this.mDirtyCount;
            }
            if (state == 0) continue;
            node.acquireExclusive();
            state = node.mCachedState;
            if (state != dirtyState) {
                node.releaseExclusive();
                continue;
            }
            node.downgrade();
            try {
                node.write(pageDb);
                node.mCachedState = 0;
                continue;
            }
            catch (Throwable e) {
                this.addDirty(node, state);
                throw e;
            }
            finally {
                node.releaseShared();
                continue;
            }
            break;
        }
    }

    synchronized long dirtyCount() {
        return this.mDirtyCount;
    }

    byte[] acquireSparePage() {
        this.mSparePageLatch.acquireExclusive();
        return this.mSparePage;
    }

    void releaseSparePage(byte[] page) {
        this.mSparePage = page;
        this.mSparePageLatch.releaseExclusive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete() {
        this.acquireExclusive();
        try {
            this.mMaxSize = 0;
            Node node = this.mLeastRecentlyUsed;
            this.mLeastRecentlyUsed = null;
            this.mMostRecentlyUsed = null;
            while (node != null) {
                Node next = node.mMoreUsed;
                node.mLessUsed = null;
                node.mMoreUsed = null;
                node.delete(this.mDatabase);
                node = next;
            }
        }
        finally {
            this.releaseExclusive();
        }
        NodeGroup nodeGroup = this;
        synchronized (nodeGroup) {
            Node node = this.mFirstDirty;
            this.mFlushNext = null;
            this.mFirstDirty = null;
            this.mLastDirty = null;
            while (node != null) {
                node.delete(this.mDatabase);
                Node next = node.mNextDirty;
                node.mPrevDirty = null;
                node.mNextDirty = null;
                node = next;
            }
        }
        this.mSparePageLatch.acquireExclusive();
        try {
            PageOps.p_delete(this.mSparePage);
            this.mSparePage = PageOps.p_null();
        }
        finally {
            this.mSparePageLatch.releaseExclusive();
        }
    }
}

