/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import org.cojen.tupl.CorruptDatabaseException;
import org.cojen.tupl.DatabaseFullException;
import org.cojen.tupl.WriteFailureException;
import org.cojen.tupl.core.CommitLock;
import org.cojen.tupl.core.LocalDatabase;
import org.cojen.tupl.core.PageDb;
import org.cojen.tupl.core.PageOps;
import org.cojen.tupl.core.PageQueue;
import org.cojen.tupl.diag.EventListener;
import org.cojen.tupl.diag.EventType;
import org.cojen.tupl.io.PageArray;

final class PageManager {
    static final int I_TOTAL_PAGE_COUNT = 0;
    static final int I_REGULAR_QUEUE = 8;
    static final int I_RECYCLE_QUEUE = 52;
    static final int I_RESERVE_QUEUE = 96;
    final PageArray mPageArray;
    private final int mPageSize;
    private final ReentrantLock mRemoveLock;
    private long mTotalPageCount;
    private long mPageLimit;
    private ThreadLocal<Long> mPageLimitOverride;
    private final PageQueue mRegularFreeList;
    private final PageQueue mRecycleFreeList;
    private volatile boolean mCompacting;
    private long mCompactionTargetPageCount;
    private PageQueue mReserveList;
    private long mReclaimUpperBound;
    LocalDatabase mPageCache;

    PageManager(PageArray array) throws IOException {
        this(null, false, false, array, PageOps.p_null(), 0);
    }

    PageManager(EventListener debugListener, boolean issues, PageArray array, byte[] header, int offset) throws IOException {
        this(debugListener, issues, true, array, header, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PageManager(EventListener debugListener, boolean issues, boolean restored, PageArray array, byte[] header, int offset) throws IOException {
        block19: {
            this.mCompactionTargetPageCount = Long.MAX_VALUE;
            this.mReclaimUpperBound = Long.MIN_VALUE;
            this.mPageArray = array;
            this.mPageSize = array.pageSize();
            this.mRemoveLock = new ReentrantLock(false);
            this.mRegularFreeList = PageQueue.newRegularFreeList(this);
            this.mRecycleFreeList = PageQueue.newRecycleFreeList(this);
            this.mPageLimit = -1L;
            try {
                PageQueue reserve;
                block20: {
                    long actualPageCount;
                    if (!restored) {
                        this.mTotalPageCount = 4L;
                        this.mRegularFreeList.init(2L);
                        this.mRecycleFreeList.init(3L);
                        break block19;
                    }
                    this.mTotalPageCount = PageManager.readTotalPageCount(header, offset);
                    if (debugListener != null) {
                        debugListener.notify(EventType.DEBUG, "TOTAL_PAGE_COUNT: %1$d", this.mTotalPageCount);
                    }
                    if ((actualPageCount = array.pageCount()) > this.mTotalPageCount) {
                        if (!issues && !array.isReadOnly()) {
                            if (this.mTotalPageCount < 4L) {
                                throw new CorruptDatabaseException("Invalid total page count: " + this.mTotalPageCount);
                            }
                            array.truncatePageCount(this.mTotalPageCount);
                        }
                    } else if (actualPageCount < this.mTotalPageCount) {
                        // empty if block
                    }
                    this.fullLock();
                    try {
                        this.mRegularFreeList.init(debugListener, header, offset + 8);
                        this.mRecycleFreeList.init(debugListener, header, offset + 52);
                        if (PageQueue.exists(header, offset + 96)) {
                            reserve = this.mRegularFreeList.newReserveFreeList();
                            try {
                                reserve.init(debugListener, header, offset + 96);
                                break block20;
                            }
                            catch (Throwable e) {
                                reserve.delete();
                                throw e;
                            }
                        }
                        reserve = null;
                        if (debugListener != null) {
                            debugListener.notify(EventType.DEBUG, "Reserve free list is null", new Object[0]);
                        }
                    }
                    finally {
                        this.fullUnlock();
                    }
                }
                if (reserve == null) break block19;
                try {
                    reserve.reclaim(this.mRemoveLock, this.mTotalPageCount - 1L);
                }
                finally {
                    reserve.delete();
                }
            }
            catch (Throwable e) {
                this.delete();
                throw e;
            }
        }
    }

    void delete() {
        PageQueue reserve;
        if (this.mRegularFreeList != null) {
            this.mRegularFreeList.delete();
        }
        if (this.mRecycleFreeList != null) {
            this.mRecycleFreeList.delete();
        }
        if ((reserve = this.mReserveList) != null) {
            reserve.delete();
            this.mReserveList = null;
        }
    }

    static long readTotalPageCount(byte[] header, int offset) {
        return PageOps.p_longGetLE(header, offset + 0);
    }

    int pageSize() {
        return this.mPageSize;
    }

    int directPageSize() {
        return this.mPageArray.directPageSize();
    }

    void pageCache(LocalDatabase cache) {
        this.fullLock();
        this.mPageCache = cache;
        this.fullUnlock();
    }

    public long allocPage() throws IOException {
        long pageId;
        while (true) {
            if ((pageId = this.mRecycleFreeList.tryUnappend()) == 0L) {
                ReentrantLock lock = this.mRemoveLock;
                lock.lock();
                pageId = this.mRecycleFreeList.tryRemove(lock);
                if (pageId == 0L && (pageId = this.mRegularFreeList.tryRemove(lock)) == 0L) {
                    PageQueue reserve = this.mReserveList;
                    if (reserve != null) {
                        if (this.mCompacting) {
                            this.mCompacting = false;
                        }
                        if (this.mReclaimUpperBound == Long.MIN_VALUE && (pageId = reserve.tryRemove(lock)) != 0L) {
                            return pageId;
                        }
                    }
                    try {
                        pageId = this.increasePageCount();
                    }
                    finally {
                        lock.unlock();
                    }
                    return pageId;
                }
            }
            if (pageId < this.mCompactionTargetPageCount || !this.mCompacting) break;
            this.mReserveList.append(pageId, true);
        }
        return pageId;
    }

    public void deletePage(long id, boolean force) throws IOException {
        if (id >= this.mCompactionTargetPageCount && this.mCompacting) {
            this.mReserveList.append(id, force);
        } else {
            this.mRegularFreeList.append(id, force);
        }
    }

    public void recyclePage(long id) throws IOException {
        if (id >= this.mCompactionTargetPageCount && this.mCompacting) {
            this.mReserveList.append(id, true);
        } else {
            this.mRecycleFreeList.append(id, true);
        }
    }

    public boolean hasDeletedOrRecycledPages() {
        return this.mRegularFreeList.hasAppendedPages() || this.mRecycleFreeList.hasAppendedPages();
    }

    public void allocAndRecyclePage() throws IOException {
        long pageId;
        this.mRemoveLock.lock();
        try {
            pageId = this.increasePageCount();
        }
        finally {
            this.mRemoveLock.unlock();
        }
        this.recyclePage(pageId);
    }

    private long increasePageCount() throws IOException, DatabaseFullException {
        Long limitObj;
        long total = this.mTotalPageCount;
        ThreadLocal<Long> override = this.mPageLimitOverride;
        long limit = override == null || (limitObj = override.get()) == null ? this.mPageLimit : limitObj;
        long max = this.mPageArray.pageCountLimit();
        if (max > 0L && (limit < 0L || limit > max)) {
            limit = max;
        }
        if (limit >= 0L && total >= limit) {
            throw new DatabaseFullException("Capacity limit reached: " + limit * (long)this.mPageArray.pageSize());
        }
        this.mTotalPageCount = total + 1L;
        return total;
    }

    public void pageLimit(long limit) {
        this.mRemoveLock.lock();
        try {
            this.mPageLimit = limit;
        }
        finally {
            this.mRemoveLock.unlock();
        }
    }

    public void pageLimitOverride(long limit) {
        this.mRemoveLock.lock();
        try {
            if (limit == 0L) {
                if (this.mPageLimitOverride != null) {
                    this.mPageLimitOverride.remove();
                }
            } else {
                if (this.mPageLimitOverride == null) {
                    this.mPageLimitOverride = new ThreadLocal();
                }
                this.mPageLimitOverride.set(limit);
            }
        }
        finally {
            this.mRemoveLock.unlock();
        }
    }

    public long pageLimit() {
        this.mRemoveLock.lock();
        try {
            long l = this.mPageLimit;
            return l;
        }
        finally {
            this.mRemoveLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compactionStart(long targetPageCount) throws IOException {
        PageQueue reserve;
        if (this.mCompacting) {
            throw new IllegalStateException("Compaction in progress");
        }
        if (this.mReserveList != null) {
            throw new IllegalStateException();
        }
        if (targetPageCount < 2L) {
            return false;
        }
        this.mRemoveLock.lock();
        try {
            if (targetPageCount >= this.mTotalPageCount && targetPageCount >= this.mPageArray.pageCount()) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.mRemoveLock.unlock();
        }
        long initPageId = this.mRecycleFreeList.tryUnappend();
        if (initPageId == 0L) {
            this.mRemoveLock.lock();
            initPageId = this.mRecycleFreeList.tryRemove(this.mRemoveLock);
            if (initPageId == 0L && (initPageId = this.mRegularFreeList.tryRemove(this.mRemoveLock)) == 0L) {
                this.mRemoveLock.unlock();
                return false;
            }
        }
        try {
            reserve = this.mRegularFreeList.newReserveFreeList();
            reserve.init(initPageId);
        }
        catch (Throwable e) {
            try {
                this.recyclePage(initPageId);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        this.mRemoveLock.lock();
        if (this.mReserveList != null) {
            this.mReserveList.delete();
        }
        this.mReserveList = reserve;
        this.mCompactionTargetPageCount = targetPageCount;
        this.mCompacting = true;
        this.mRemoveLock.unlock();
        return true;
    }

    public boolean compactionScanFreeList(CommitLock commitLock) throws IOException {
        return this.compactionScanFreeList(commitLock, this.mRecycleFreeList) && this.compactionScanFreeList(commitLock, this.mRegularFreeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compactionScanFreeList(CommitLock commitLock, PageQueue list) throws IOException {
        this.mRemoveLock.lock();
        long target = list.getRemoveScanTarget();
        this.mRemoveLock.unlock();
        CommitLock.Shared shared = commitLock.acquireShared();
        try {
            while (this.mCompacting) {
                long pageId;
                this.mRemoveLock.lock();
                if (list.isRemoveScanComplete(target) || (pageId = list.tryRemove(this.mRemoveLock)) == 0L) {
                    this.mRemoveLock.unlock();
                    boolean bl = this.mCompacting;
                    return bl;
                }
                if (pageId >= this.mCompactionTargetPageCount) {
                    this.mReserveList.append(pageId, true);
                } else {
                    this.mRecycleFreeList.append(pageId, true);
                }
                if (!commitLock.hasQueuedThreads()) continue;
                shared.release();
                commitLock.acquireShared(shared);
            }
        }
        finally {
            shared.release();
        }
        return false;
    }

    public boolean compactionVerify() throws IOException {
        if (!this.mCompacting) {
            return true;
        }
        this.mRemoveLock.lock();
        long total = this.mTotalPageCount;
        this.mRemoveLock.unlock();
        return this.mReserveList.verifyPageRange(this.mCompactionTargetPageCount, total);
    }

    public boolean compactionEnd(CommitLock commitLock) throws IOException {
        long upperBound = Long.MAX_VALUE;
        boolean ready = this.compactionVerify();
        commitLock.acquireExclusive();
        this.fullLock();
        if (ready && (ready = this.mCompacting && (this.mTotalPageCount > this.mCompactionTargetPageCount || this.mPageArray.pageCount() > this.mTotalPageCount))) {
            this.mTotalPageCount = this.mCompactionTargetPageCount;
            upperBound = this.mTotalPageCount - 1L;
        }
        this.mCompacting = false;
        this.mCompactionTargetPageCount = Long.MAX_VALUE;
        this.mReclaimUpperBound = upperBound;
        this.fullUnlock();
        commitLock.releaseExclusive();
        return ready;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compactionReclaim() throws IOException {
        this.mRemoveLock.lock();
        PageQueue reserve = this.mReserveList;
        long upperBound = this.mReclaimUpperBound;
        this.mReserveList = null;
        this.mReclaimUpperBound = Long.MIN_VALUE;
        this.mRemoveLock.unlock();
        if (reserve != null) {
            try {
                reserve.reclaim(this.mRemoveLock, upperBound);
            }
            finally {
                reserve.delete();
            }
        }
    }

    public boolean truncatePages() throws IOException {
        this.mRemoveLock.lock();
        try {
            if (this.mTotalPageCount < this.mPageArray.pageCount()) {
                try {
                    this.mPageArray.truncatePageCount(this.mTotalPageCount);
                    boolean bl = true;
                    return bl;
                }
                catch (IllegalStateException e) {
                    boolean bl = false;
                    this.mRemoveLock.unlock();
                    return bl;
                }
            }
        }
        finally {
            this.mRemoveLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitStart(byte[] header, int offset) throws IOException {
        this.fullLock();
        try {
            if (this.mPageLimit > 0L) {
                if (this.mPageLimitOverride == null) {
                    this.mPageLimitOverride = new ThreadLocal();
                }
                this.mPageLimitOverride.set(-1L);
            }
            try {
                this.mRegularFreeList.preCommit();
                this.mRecycleFreeList.preCommit();
                if (this.mReserveList != null) {
                    this.mReserveList.preCommit();
                }
            }
            catch (DatabaseFullException | WriteFailureException e) {
                throw e;
            }
            catch (IOException e) {
                throw WriteFailureException.from(e);
            }
            finally {
                if (this.mPageLimitOverride != null) {
                    this.mPageLimitOverride.remove();
                }
            }
            PageOps.p_longPutLE(header, offset + 0, this.mTotalPageCount);
            this.mRegularFreeList.commitStart(header, offset + 8);
            this.mRecycleFreeList.commitStart(header, offset + 52);
            if (this.mReserveList != null) {
                this.mReserveList.commitStart(header, offset + 96);
            }
        }
        finally {
            this.fullUnlock();
        }
    }

    public void commitEnd(byte[] header, int offset) throws IOException {
        this.mRemoveLock.lock();
        try {
            this.mRegularFreeList.commitEnd(header, offset + 8);
            this.mRecycleFreeList.commitEnd(header, offset + 52);
            if (this.mReserveList != null) {
                this.mReserveList.commitEnd(header, offset + 96);
            }
        }
        finally {
            this.mRemoveLock.unlock();
        }
    }

    private void fullLock() {
        this.mRegularFreeList.appendLock().lock();
        this.mRecycleFreeList.appendLock().lock();
        if (this.mReserveList != null) {
            this.mReserveList.appendLock().lock();
        }
        this.mRemoveLock.lock();
    }

    private void fullUnlock() {
        this.mRemoveLock.unlock();
        if (this.mReserveList != null) {
            this.mReserveList.appendLock().unlock();
        }
        this.mRecycleFreeList.appendLock().unlock();
        this.mRegularFreeList.appendLock().unlock();
    }

    void addTo(PageDb.Stats stats) {
        this.fullLock();
        try {
            stats.totalPages += this.mTotalPageCount;
            this.mRegularFreeList.addTo(stats);
            this.mRecycleFreeList.addTo(stats);
            if (this.mReserveList != null) {
                this.mReserveList.addTo(stats);
            }
        }
        finally {
            this.fullUnlock();
        }
    }

    boolean isPageOutOfBounds(long id) {
        return id <= 1L || id >= this.mTotalPageCount;
    }
}

