/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.util.function.LongConsumer;
import org.cojen.tupl.CorruptDatabaseException;
import org.cojen.tupl.core.DirectPageOps;
import org.cojen.tupl.core.IntegerRef;
import org.cojen.tupl.core.PageOps;
import org.cojen.tupl.io.PageArray;

class PageQueueScanner {
    PageQueueScanner() {
    }

    static void scan(PageArray array, long headerId, int headerOffset, LongConsumer dst) throws IOException {
        long ptr = 0L;
        int directPageSize = array.directPageSize();
        if (directPageSize < 0) {
            ptr = DirectPageOps.p_allocPage(directPageSize);
        }
        try {
            PageQueueScanner.doScan(array, headerId, headerOffset, dst, ptr);
        }
        catch (Throwable e) {
            if (ptr != 0L) {
                DirectPageOps.p_delete(ptr);
            }
            throw e;
        }
    }

    private static void doScan(PageArray array, long headerId, int headerOffset, LongConsumer dst, long ptr) throws IOException {
        byte[] buf = new byte[array.pageSize()];
        PageQueueScanner.readPage(array, headerId, buf, ptr);
        long pageCount = PageOps.p_longGetLE(buf, headerOffset + 0);
        long nodeCount = PageOps.p_longGetLE(buf, headerOffset + 8);
        long nodeId = PageOps.p_longGetLE(buf, headerOffset + 16);
        int nodeOffset = PageOps.p_intGetLE(buf, headerOffset + 24);
        long pageId = PageOps.p_longGetLE(buf, headerOffset + 28);
        long tailId = PageOps.p_longGetLE(buf, headerOffset + 36);
        if (nodeId == 0L) {
            if (pageCount != 0L || nodeCount != 0L) {
                throw new CorruptDatabaseException("Invalid empty page queue: " + pageCount + ", " + nodeCount);
            }
            return;
        }
        PageQueueScanner.readPage(array, nodeId, buf, ptr);
        if (pageId == 0L) {
            if (nodeOffset != 16) {
                throw new CorruptDatabaseException("Invalid node offset: " + nodeOffset);
            }
            pageId = PageOps.p_longGetBE(buf, 8);
        }
        long actualPageCount = 0L;
        long actualNodeCount = 1L;
        IntegerRef.Value nodeOffsetRef = new IntegerRef.Value();
        nodeOffsetRef.value = nodeOffset;
        while (true) {
            long delta;
            ++actualPageCount;
            dst.accept(pageId);
            if (nodeOffsetRef.value < buf.length && (delta = PageOps.p_ulongGetVar(buf, nodeOffsetRef)) > 0L) {
                pageId += delta;
                continue;
            }
            dst.accept(nodeId);
            nodeId = PageOps.p_longGetBE(buf, 0);
            if (nodeId == tailId) break;
            PageQueueScanner.readPage(array, nodeId, buf, ptr);
            ++actualNodeCount;
            pageId = PageOps.p_longGetBE(buf, 8);
            nodeOffsetRef.value = 16;
        }
        if (pageCount != actualPageCount) {
            throw new CorruptDatabaseException("Mismatched page count: " + pageCount + " != " + actualPageCount);
        }
        if (nodeCount != actualNodeCount) {
            throw new CorruptDatabaseException("Mismatched node count: " + nodeCount + " != " + actualNodeCount);
        }
    }

    private static void readPage(PageArray array, long id, byte[] buf, long ptr) throws IOException {
        if (ptr == 0L) {
            array.readPage(id, buf);
        } else {
            array.readPage(id, ptr);
            DirectPageOps.p_copyToArray(ptr, 0, buf, 0, buf.length);
        }
    }
}

