/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.cojen.tupl.CommitCallback;
import org.cojen.tupl.core.FragmentedTrash;
import org.cojen.tupl.core.LocalDatabase;
import org.cojen.tupl.core.LocalTransaction;
import org.cojen.tupl.core.Locker;
import org.cojen.tupl.core.TransactionContext;
import org.cojen.tupl.core.UndoLog;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.diag.EventListener;
import org.cojen.tupl.diag.EventType;

final class PendingTxn
extends Locker
implements Runnable {
    final TransactionContext mContext;
    final long mTxnId;
    final UndoLog mUndoLog;
    final int mHasState;
    private final Object mAttachment;
    private volatile long mCommitPos;
    private static final VarHandle cCommitPosHandle;
    private volatile PendingTxn mNext;
    private static final VarHandle cNextHandle;

    PendingTxn(LocalTransaction from) {
        super(from.mManager, from.mHash);
        Object att;
        this.mContext = from.mContext;
        this.mTxnId = from.mTxnId;
        this.mUndoLog = from.mUndoLog;
        this.mHasState = from.mHasState;
        this.mAttachment = att = from.attachment();
        from.transferExclusive(this);
        from.mUndoLog = null;
        from.mHasState = 0;
        from.mTxnId = 0L;
        if (att instanceof CommitCallback) {
            CommitCallback callback = (CommitCallback)att;
            try {
                callback.pending(this.mTxnId);
            }
            catch (Throwable e) {
                Utils.uncaught(e);
            }
        }
    }

    long commitPos() {
        return cCommitPosHandle.getOpaque(this);
    }

    void commitPos(long pos) {
        cCommitPosHandle.setOpaque(this, pos);
    }

    PendingTxn getNextVolatile() {
        return this.mNext;
    }

    void setNextVolatile(PendingTxn next) {
        this.mNext = next;
    }

    PendingTxn getNextPlain() {
        return cNextHandle.get(this);
    }

    void setNextPlain(PendingTxn next) {
        cNextHandle.set(this, next);
    }

    @Override
    public final LocalDatabase getDatabase() {
        UndoLog undo = this.mUndoLog;
        return undo == null ? super.getDatabase() : undo.getDatabase();
    }

    @Override
    public Object attachment() {
        return this.mAttachment;
    }

    @Override
    public void run() {
        block8: {
            try {
                long commitPos = this.commitPos();
                String status = null;
                if (commitPos < 0L) {
                    this.doRollback();
                    status = "Replication failure";
                } else {
                    this.scopeUnlockAll();
                    UndoLog undo = this.mUndoLog;
                    if (undo != null) {
                        undo.truncate();
                        this.mContext.unregister(undo);
                    }
                    if ((this.mHasState & 4) != 0) {
                        FragmentedTrash.emptyTrash(this.getDatabase().fragmentedTrash(), this.mTxnId);
                    }
                }
                this.finished(status);
            }
            catch (Throwable e) {
                LocalDatabase db = this.getDatabase();
                if (db == null || db.isClosed()) break block8;
                EventListener listener = db.eventListener();
                if (listener != null) {
                    listener.notify(EventType.REPLICATION_PANIC, "Unexpected transaction exception: %1$s", e);
                } else {
                    Utils.uncaught(e);
                }
                this.finished(e);
            }
        }
    }

    RuntimeException rollback(Throwable cause) {
        try {
            this.doRollback();
        }
        catch (Throwable e) {
            Utils.suppress(cause, e);
        }
        throw Utils.rethrow(cause);
    }

    private void doRollback() throws IOException {
        UndoLog undo = this.mUndoLog;
        if (undo != null) {
            undo.uncommit();
            this.mContext.uncommitted(this.mTxnId);
            undo.rollback();
        }
        this.scopeUnlockAll();
        if (undo != null) {
            this.mContext.unregister(undo);
        }
    }

    private void finished(Object status) {
        Object object = this.mAttachment;
        if (object instanceof CommitCallback) {
            CommitCallback callback = (CommitCallback)object;
            try {
                callback.finished(this.mTxnId, status);
            }
            catch (Throwable e) {
                Utils.uncaught(e);
            }
        }
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            cCommitPosHandle = lookup.findVarHandle(PendingTxn.class, "mCommitPos", Long.TYPE);
            cNextHandle = lookup.findVarHandle(PendingTxn.class, "mNext", PendingTxn.class);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }
}

