/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.DataInput;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.View;
import org.cojen.tupl.util.Runner;

final class Primer {
    private final View mView;
    private final DataInput mDin;
    private final int mTaskLimit;
    private int mTaskCount;
    private boolean mFinished;
    private IOException mEx;

    Primer(View view, DataInput din) {
        this.mView = view;
        this.mDin = din;
        this.mTaskLimit = Runtime.getRuntime().availableProcessors() * 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() throws IOException {
        Primer primer = this;
        synchronized (primer) {
            ++this.mTaskCount;
        }
        this.prime();
        primer = this;
        synchronized (primer) {
            while (true) {
                if (this.mEx != null) {
                    throw this.mEx;
                }
                if (this.mTaskCount <= 0) break;
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void prime() {
        try {
            Cursor c = this.mView.newCursor(Transaction.BOGUS);
            try {
                Primer primer;
                c.autoload(false);
                while (true) {
                    byte[] key;
                    block32: {
                        primer = this;
                        // MONITORENTER : primer
                        if (this.mFinished) {
                            // MONITOREXIT : primer
                            c.reset();
                            return;
                        }
                        int len = this.mDin.readUnsignedShort();
                        if (len == 65535) {
                            this.mFinished = true;
                            // MONITOREXIT : primer
                            c.reset();
                            return;
                        }
                        key = new byte[len];
                        this.mDin.readFully(key);
                        if (this.mTaskCount < this.mTaskLimit) {
                            try {
                                Runner.start(this::prime);
                            }
                            catch (Throwable e) {
                                break block32;
                            }
                            ++this.mTaskCount;
                        }
                    }
                    // MONITOREXIT : primer
                    c.findNearby(key);
                    continue;
                    break;
                }
                catch (IOException e) {
                    primer = this;
                    // MONITORENTER : primer
                    if (this.mEx == null) {
                        this.mEx = e;
                    }
                    // MONITOREXIT : primer
                    return;
                }
            }
            finally {
                c.reset();
            }
        }
        finally {
            Primer primer = this;
        }
    }
}

