/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.cojen.tupl.Snapshot;
import org.cojen.tupl.io.PageArray;

interface ReadableSnapshot
extends Snapshot {
    public int pageSize();

    public long pageCount();

    public void readPage(long var1, byte[] var3, int var4, int var5) throws IOException;

    public void readPage(long var1, long var3, int var5, int var6) throws IOException;

    default public PageArray asPageArray() {
        return new PageArray(this.pageSize()){

            @Override
            public boolean isReadOnly() {
                return true;
            }

            @Override
            public boolean isEmpty() throws IOException {
                return false;
            }

            @Override
            public long pageCount() throws IOException {
                return ReadableSnapshot.this.pageCount();
            }

            @Override
            public void truncatePageCount(long count) throws IOException {
            }

            @Override
            public void expandPageCount(long count) throws IOException {
            }

            @Override
            public void readPage(long index, byte[] dst, int offset, int length) throws IOException {
                ReadableSnapshot.this.readPage(index, dst, offset, length);
            }

            @Override
            public void readPage(long index, long dstPtr, int offset, int length) throws IOException {
                ReadableSnapshot.this.readPage(index, dstPtr, offset, length);
            }

            @Override
            public void writePage(long index, byte[] src, int offset) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void writePage(long index, byte[] src, int offset, ByteBuffer tail) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void sync(boolean metadata) throws IOException {
            }

            @Override
            public void close(Throwable cause) {
            }
        };
    }
}

