/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.EOFException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.core.DataIn;
import org.cojen.tupl.core.RedoVisitor;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.util.Latch;

abstract class RedoDecoder {
    private static final VarHandle cDecodePositionHandle;
    private final boolean mLenient;
    final DataIn mIn;
    long mTxnId;
    final Latch mDecodeLatch;
    long mDecodePosition;
    long mDecodeTransactionId;

    RedoDecoder(boolean lenient, long initialTxnId, DataIn in, Latch decodeLatch) {
        this.mLenient = lenient;
        this.mIn = in;
        this.mTxnId = initialTxnId;
        this.mDecodeLatch = decodeLatch;
        this.mDecodePosition = in.mPos;
        this.mDecodeTransactionId = initialTxnId;
    }

    boolean run(RedoVisitor visitor) throws IOException {
        this.mDecodeLatch.acquireExclusive();
        try {
            boolean bl = this.doRun(visitor, this.mIn);
            return bl;
        }
        finally {
            this.mDecodeLatch.releaseExclusive();
        }
    }

    long decodePositionOpaque() {
        return cDecodePositionHandle.getOpaque(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doRun(RedoVisitor visitor, DataIn in) throws IOException {
        block136: while (true) {
            int handlerId;
            byte[] key;
            long indexId;
            long txnId;
            byte[] message;
            int op;
            cDecodePositionHandle.setOpaque(this, in.mPos);
            this.mDecodeTransactionId = this.mTxnId;
            this.mDecodeLatch.releaseExclusive();
            try {
                op = in.read();
            }
            finally {
                this.mDecodeLatch.acquireExclusive();
            }
            if (op < 0) {
                return true;
            }
            switch (op &= 0xFF) {
                case 0: {
                    if (this.mLenient) {
                        return true;
                    }
                }
                default: {
                    throw new DatabaseException("Unknown redo log operation: " + op + " at " + (in.mPos - 1L));
                }
                case 1: {
                    this.mTxnId = 0L;
                    if (!this.verifyTerminator(in)) {
                        return false;
                    }
                    if (visitor.reset()) continue block136;
                    return false;
                }
                case 2: {
                    long ts;
                    try {
                        ts = in.readLongLE();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.timestamp(ts)) continue block136;
                    return false;
                }
                case 3: {
                    long ts;
                    try {
                        ts = in.readLongLE();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.shutdown(ts)) continue block136;
                    return false;
                }
                case 4: {
                    long ts;
                    try {
                        ts = in.readLongLE();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.close(ts)) continue block136;
                    return false;
                }
                case 5: {
                    long ts;
                    try {
                        ts = in.readLongLE();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.endFile(ts)) continue block136;
                    return false;
                }
                case 6: {
                    try {
                        in.readLongLE();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in)) continue block136;
                    return false;
                }
                case 8: {
                    try {
                        message = in.readBytes();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.control(message)) continue block136;
                    return false;
                }
                case 24: {
                    try {
                        txnId = this.readTxnId(in);
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.txnEnter(txnId)) continue block136;
                    return false;
                }
                case 25: {
                    try {
                        txnId = this.readTxnId(in);
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.txnRollback(txnId)) continue block136;
                    return false;
                }
                case 26: {
                    try {
                        txnId = this.readTxnId(in);
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.txnRollbackFinal(txnId)) continue block136;
                    return false;
                }
                case 27: {
                    try {
                        txnId = this.readTxnId(in);
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.txnCommit(txnId)) continue block136;
                    return false;
                }
                case 28: {
                    try {
                        txnId = this.readTxnId(in);
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.txnCommitFinal(txnId)) continue block136;
                    return false;
                }
                case 16: {
                    byte[] value;
                    try {
                        indexId = in.readLongLE();
                        key = in.readBytes();
                        value = in.readBytes();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.store(indexId, key, value)) continue block136;
                    return false;
                }
                case 17: {
                    byte[] value;
                    try {
                        indexId = in.readLongLE();
                        key = in.readBytes();
                        value = in.readBytes();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.storeNoLock(indexId, key, value)) continue block136;
                    return false;
                }
                case 18: {
                    try {
                        indexId = in.readLongLE();
                        key = in.readBytes();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.store(indexId, key, null)) continue block136;
                    return false;
                }
                case 19: {
                    try {
                        indexId = in.readLongLE();
                        key = in.readBytes();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.storeNoLock(indexId, key, null)) continue block136;
                    return false;
                }
                case 21: {
                    byte[] newName;
                    try {
                        txnId = this.readTxnId(in);
                        indexId = in.readLongLE();
                        newName = in.readBytes();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.renameIndex(txnId, indexId, newName)) continue block136;
                    return false;
                }
                case 22: {
                    try {
                        txnId = this.readTxnId(in);
                        indexId = in.readLongLE();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.deleteIndex(txnId, indexId)) continue block136;
                    return false;
                }
                case 32: {
                    byte[] value;
                    try {
                        txnId = this.readTxnId(in);
                        indexId = in.readLongLE();
                        key = in.readBytes();
                        value = in.readBytes();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.txnEnterStore(txnId, indexId, key, value)) continue block136;
                    return false;
                }
                case 33: {
                    byte[] value;
                    try {
                        txnId = this.readTxnId(in);
                        indexId = in.readLongLE();
                        key = in.readBytes();
                        value = in.readBytes();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.txnStore(txnId, indexId, key, value)) continue block136;
                    return false;
                }
                case 34: {
                    byte[] value;
                    try {
                        txnId = this.readTxnId(in);
                        indexId = in.readLongLE();
                        key = in.readBytes();
                        value = in.readBytes();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.txnStoreCommit(txnId, indexId, key, value)) continue block136;
                    return false;
                }
                case 35: {
                    byte[] value;
                    try {
                        txnId = this.readTxnId(in);
                        indexId = in.readLongLE();
                        key = in.readBytes();
                        value = in.readBytes();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.txnStoreCommitFinal(txnId, indexId, key, value)) continue block136;
                    return false;
                }
                case 36: {
                    try {
                        txnId = this.readTxnId(in);
                        indexId = in.readLongLE();
                        key = in.readBytes();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.txnEnterStore(txnId, indexId, key, null)) continue block136;
                    return false;
                }
                case 37: {
                    try {
                        txnId = this.readTxnId(in);
                        indexId = in.readLongLE();
                        key = in.readBytes();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.txnStore(txnId, indexId, key, null)) continue block136;
                    return false;
                }
                case 38: {
                    try {
                        txnId = this.readTxnId(in);
                        indexId = in.readLongLE();
                        key = in.readBytes();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.txnStoreCommit(txnId, indexId, key, null)) continue block136;
                    return false;
                }
                case 39: {
                    try {
                        txnId = this.readTxnId(in);
                        indexId = in.readLongLE();
                        key = in.readBytes();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.txnStoreCommitFinal(txnId, indexId, key, null)) continue block136;
                    return false;
                }
                case 40: {
                    long cursorId;
                    try {
                        cursorId = this.readTxnId(in);
                        indexId = in.readLongLE();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.cursorRegister(cursorId, indexId)) continue block136;
                    return false;
                }
                case 41: {
                    long cursorId;
                    try {
                        cursorId = this.readTxnId(in);
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.cursorUnregister(cursorId)) continue block136;
                    return false;
                }
                case 42: {
                    long cursorId;
                    byte[] value;
                    try {
                        cursorId = this.readTxnId(in);
                        txnId = this.readTxnId(in);
                        key = in.readBytes();
                        value = in.readBytes();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.cursorStore(cursorId, txnId, key, value)) continue block136;
                    return false;
                }
                case 43: {
                    long cursorId;
                    try {
                        cursorId = this.readTxnId(in);
                        txnId = this.readTxnId(in);
                        key = in.readBytes();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.cursorStore(cursorId, txnId, key, null)) continue block136;
                    return false;
                }
                case 44: {
                    long cursorId;
                    try {
                        cursorId = this.readTxnId(in);
                        txnId = this.readTxnId(in);
                        key = in.readBytes();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.cursorFind(cursorId, txnId, key)) continue block136;
                    return false;
                }
                case 45: {
                    long length;
                    long cursorId;
                    try {
                        cursorId = this.readTxnId(in);
                        txnId = this.readTxnId(in);
                        length = in.readUnsignedVarLong();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.cursorValueSetLength(cursorId, txnId, length)) continue block136;
                    return false;
                }
                case 46: {
                    long pos;
                    long cursorId;
                    try {
                        cursorId = this.readTxnId(in);
                        txnId = this.readTxnId(in);
                        pos = in.readUnsignedVarLong();
                        int amount = in.readUnsignedVarInt();
                        in.cursorValueWrite(visitor, cursorId, txnId, pos, amount);
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in)) continue block136;
                    return false;
                }
                case 47: {
                    long pos;
                    long length;
                    long cursorId;
                    try {
                        cursorId = this.readTxnId(in);
                        txnId = this.readTxnId(in);
                        pos = in.readUnsignedVarLong();
                        length = in.readUnsignedVarLong();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.cursorValueClear(cursorId, txnId, pos, length)) continue block136;
                    return false;
                }
                case 29: {
                    try {
                        txnId = this.readTxnId(in);
                        indexId = in.readLongLE();
                        key = in.readBytes();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.txnLockShared(txnId, indexId, key)) continue block136;
                    return false;
                }
                case 30: {
                    try {
                        txnId = this.readTxnId(in);
                        indexId = in.readLongLE();
                        key = in.readBytes();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.txnLockUpgradable(txnId, indexId, key)) continue block136;
                    return false;
                }
                case 31: {
                    try {
                        txnId = this.readTxnId(in);
                        indexId = in.readLongLE();
                        key = in.readBytes();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.txnLockExclusive(txnId, indexId, key)) continue block136;
                    return false;
                }
                case 48: 
                case 50: {
                    long prepareTxnId;
                    try {
                        txnId = this.readTxnId(in);
                        prepareTxnId = in.readLongLE();
                        handlerId = in.readUnsignedVarInt();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.txnPrepare(txnId, prepareTxnId, handlerId, null, op == 50)) continue block136;
                    return false;
                }
                case 49: 
                case 51: {
                    long prepareTxnId;
                    try {
                        txnId = this.readTxnId(in);
                        prepareTxnId = in.readLongLE();
                        handlerId = in.readUnsignedVarInt();
                        message = in.readBytes();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.txnPrepare(txnId, prepareTxnId, handlerId, message, op == 51)) continue block136;
                    return false;
                }
                case 52: {
                    long prepareTxnId;
                    try {
                        txnId = this.readTxnId(in);
                        prepareTxnId = in.readLongLE();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.txnPrepareRollback(txnId, prepareTxnId)) continue block136;
                    return false;
                }
                case 54: {
                    try {
                        txnId = this.readTxnId(in);
                        indexId = in.readLongLE();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.txnCommitFinalNotifySchema(txnId, indexId)) continue block136;
                    return false;
                }
                case 55: {
                    try {
                        txnId = this.readTxnId(in);
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.txnPredicateMode(txnId)) continue block136;
                    return false;
                }
                case 56: {
                    try {
                        txnId = this.readTxnId(in);
                        handlerId = in.readUnsignedVarInt();
                        message = in.readBytes();
                    }
                    catch (EOFException e) {
                        return true;
                    }
                    if (this.verifyTerminator(in) && visitor.txnCustom(txnId, handlerId, message)) continue block136;
                    return false;
                }
                case 57: 
            }
            try {
                txnId = this.readTxnId(in);
                handlerId = in.readUnsignedVarInt();
                indexId = in.readLongLE();
                key = in.readBytes();
                message = in.readBytes();
            }
            catch (EOFException e) {
                return true;
            }
            if (!this.verifyTerminator(in) || !visitor.txnCustomLock(txnId, handlerId, message, indexId, key)) break;
        }
        return false;
    }

    private long readTxnId(DataIn in) throws IOException {
        return this.mTxnId += in.readSignedVarLong();
    }

    abstract boolean verifyTerminator(DataIn var1) throws IOException;

    static {
        try {
            cDecodePositionHandle = MethodHandles.lookup().findVarHandle(RedoDecoder.class, "mDecodePosition", Long.TYPE);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }
}

