/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.File;
import java.time.Instant;
import org.cojen.tupl.core.RedoLog;
import org.cojen.tupl.core.RedoVisitor;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.diag.EventListener;
import org.cojen.tupl.diag.EventType;
import org.cojen.tupl.ext.Crypto;
import org.cojen.tupl.util.WeakPool;

class RedoEventPrinter
implements RedoVisitor {
    private static final int MAX_VALUE = 1000;
    private final EventListener mListener;
    private final EventType mType;

    public static void main(String[] args) throws Exception {
        File baseFile = new File(args[0]);
        long logId = Long.parseLong(args[1]);
        Crypto crypto = null;
        if (args.length > 2) {
            Class<?> clazz = Class.forName(args[2]);
            Class[] types = new Class[args.length - 3];
            String[] params = new String[types.length];
            for (int i = 0; i < types.length; ++i) {
                types[i] = String.class;
                params[i] = args[i + 3];
            }
            crypto = (Crypto)clazz.getConstructor(types).newInstance(params);
        }
        EventListener listener = (type, message, messageArgs) -> System.out.println(String.format(message, messageArgs));
        new RedoLog(crypto, baseFile, logId, 0L, null).replay(new RedoEventPrinter(listener, EventType.DEBUG), null, null, null);
    }

    RedoEventPrinter(EventListener listener, EventType type) {
        this.mListener = listener;
        this.mType = type;
    }

    @Override
    public boolean reset() {
        this.mListener.notify(this.mType, "Redo reset", new Object[0]);
        return true;
    }

    @Override
    public boolean timestamp(long timestamp) {
        this.mListener.notify(this.mType, "Redo %1$s: %2$s", "timestamp", RedoEventPrinter.toDateTime(timestamp));
        return true;
    }

    @Override
    public boolean shutdown(long timestamp) {
        this.mListener.notify(this.mType, "Redo %1$s: %2$s", "shutdown", RedoEventPrinter.toDateTime(timestamp));
        return true;
    }

    @Override
    public boolean close(long timestamp) {
        this.mListener.notify(this.mType, "Redo %1$s: %2$s", "close", RedoEventPrinter.toDateTime(timestamp));
        return true;
    }

    @Override
    public boolean endFile(long timestamp) {
        this.mListener.notify(this.mType, "Redo %1$s: %2$s", "endFile", RedoEventPrinter.toDateTime(timestamp));
        return true;
    }

    @Override
    public boolean control(byte[] message) {
        this.mListener.notify(this.mType, "Redo %1$s: %2$s", "control", RedoEventPrinter.valueStr(message));
        return true;
    }

    @Override
    public boolean store(long indexId, byte[] key, byte[] value) {
        this.mListener.notify(this.mType, "Redo %1$s: indexId=%2$d, key=%3$s, value=%4$s", "store", indexId, RedoEventPrinter.keyStr(key), RedoEventPrinter.valueStr(value));
        return true;
    }

    @Override
    public boolean storeNoLock(long indexId, byte[] key, byte[] value) {
        this.mListener.notify(this.mType, "Redo %1$s: indexId=%2$d, key=%3$s, value=%4$s", "storeNoLock", indexId, RedoEventPrinter.keyStr(key), RedoEventPrinter.valueStr(value));
        return true;
    }

    @Override
    public boolean renameIndex(long txnId, long indexId, byte[] newName) {
        this.mListener.notify(this.mType, "Redo %1$s: txnId=%2$d, indexId=%3$d, name=%4$s", "renameIndex", txnId, indexId, RedoEventPrinter.keyStr(newName));
        return true;
    }

    @Override
    public boolean deleteIndex(long txnId, long indexId) {
        this.mListener.notify(this.mType, "Redo %1$s: txnId=%2$d, indexId=%3$d", "deleteIndex", txnId, indexId);
        return true;
    }

    @Override
    public boolean txnEnter(long txnId) {
        this.mListener.notify(this.mType, "Redo %1$s: txnId=%2$d", "txnEnter", txnId);
        return true;
    }

    @Override
    public boolean txnRollback(long txnId) {
        this.mListener.notify(this.mType, "Redo %1$s: txnId=%2$d", "txnRollback", txnId);
        return true;
    }

    @Override
    public boolean txnRollbackFinal(long txnId) {
        this.mListener.notify(this.mType, "Redo %1$s: txnId=%2$d", "txnRollbackFinal", txnId);
        return true;
    }

    @Override
    public boolean txnCommit(long txnId) {
        this.mListener.notify(this.mType, "Redo %1$s: txnId=%2$d", "txnCommit", txnId);
        return true;
    }

    @Override
    public boolean txnCommitFinal(long txnId) {
        this.mListener.notify(this.mType, "Redo %1$s: txnId=%2$d", "txnCommitFinal", txnId);
        return true;
    }

    @Override
    public boolean txnEnterStore(long txnId, long indexId, byte[] key, byte[] value) {
        this.mListener.notify(this.mType, "Redo %1$s: txnId=%2$d, indexId=%3$d, key=%4$s, value=%5$s", "txnEnterStore", txnId, indexId, RedoEventPrinter.keyStr(key), RedoEventPrinter.valueStr(value));
        return true;
    }

    @Override
    public boolean txnStore(long txnId, long indexId, byte[] key, byte[] value) {
        this.mListener.notify(this.mType, "Redo %1$s: txnId=%2$d, indexId=%3$d, key=%4$s, value=%5$s", "txnStore", txnId, indexId, RedoEventPrinter.keyStr(key), RedoEventPrinter.valueStr(value));
        return true;
    }

    @Override
    public boolean txnStoreCommit(long txnId, long indexId, byte[] key, byte[] value) {
        this.mListener.notify(this.mType, "Redo %1$s: txnId=%2$d, indexId=%3$d, key=%4$s, value=%5$s", "txnStoreCommit", txnId, indexId, RedoEventPrinter.keyStr(key), RedoEventPrinter.valueStr(value));
        return true;
    }

    @Override
    public boolean txnStoreCommitFinal(long txnId, long indexId, byte[] key, byte[] value) {
        this.mListener.notify(this.mType, "Redo %1$s: txnId=%2$d, indexId=%3$d, key=%4$s, value=%5$s", "txnStoreCommitFinal", txnId, indexId, RedoEventPrinter.keyStr(key), RedoEventPrinter.valueStr(value));
        return true;
    }

    @Override
    public boolean cursorRegister(long cursorId, long indexId) {
        this.mListener.notify(this.mType, "Redo %1$s: cursorId=%2$d, indexId=%3$d", "txnCursorRegister", cursorId, indexId);
        return true;
    }

    @Override
    public boolean cursorUnregister(long cursorId) {
        this.mListener.notify(this.mType, "Redo %1$s: cursorId=%2$d", "cursorUnregister", cursorId);
        return true;
    }

    @Override
    public boolean cursorStore(long cursorId, long txnId, byte[] key, byte[] value) {
        this.mListener.notify(this.mType, "Redo %1$s: cursorId=%2$d, txnId=%3$d, key=%4$s, value=%5$s", "cursorStore", cursorId, txnId, RedoEventPrinter.keyStr(key), RedoEventPrinter.valueStr(value));
        return true;
    }

    @Override
    public boolean cursorFind(long cursorId, long txnId, byte[] key) {
        this.mListener.notify(this.mType, "Redo %1$s: cursorId=%2$d, txnId=%3$d, key=%4$s", "cursorFind", cursorId, txnId, RedoEventPrinter.keyStr(key));
        return true;
    }

    @Override
    public boolean cursorValueSetLength(long cursorId, long txnId, long length) {
        this.mListener.notify(this.mType, "Redo %1$s: cursorId=%2$d, txnId=%3$d, length=%4$d", "cursorValueSetLength", cursorId, txnId, length);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cursorValueWrite(long cursorId, long txnId, long pos, WeakPool.Entry<byte[]> entry, byte[] buf, int off, int len) {
        String str;
        try {
            str = RedoEventPrinter.valueStr(buf, off, len);
        }
        finally {
            entry.release();
        }
        this.mListener.notify(this.mType, "Redo %1$s: cursorId=%2$d, txnId=%3$d, pos=%4$d, value=%5$s", "cursorValueWrite", cursorId, txnId, pos, str);
        return true;
    }

    @Override
    public boolean cursorValueClear(long cursorId, long txnId, long pos, long length) {
        this.mListener.notify(this.mType, "Redo %1$s: cursorId=%2$d, txnId=%3$d, pos=%4$d, length=%5$d", "cursorValueClear", cursorId, txnId, pos, length);
        return true;
    }

    @Override
    public boolean txnLockShared(long txnId, long indexId, byte[] key) {
        this.mListener.notify(this.mType, "Redo %1$s: txnId=%2$d, indexId=%3$d, key=%4$s", "txnLockShared", txnId, indexId, RedoEventPrinter.keyStr(key));
        return true;
    }

    @Override
    public boolean txnLockUpgradable(long txnId, long indexId, byte[] key) {
        this.mListener.notify(this.mType, "Redo %1$s: txnId=%2$d, indexId=%3$d, key=%4$s", "txnLockUpgradable", txnId, indexId, RedoEventPrinter.keyStr(key));
        return true;
    }

    @Override
    public boolean txnLockExclusive(long txnId, long indexId, byte[] key) {
        this.mListener.notify(this.mType, "Redo %1$s: txnId=%2$d, indexId=%3$d, key=%4$s", "txnLockExclusive", txnId, indexId, RedoEventPrinter.keyStr(key));
        return true;
    }

    @Override
    public boolean txnPrepare(long txnId, long prepareTxnId, int handlerId, byte[] message, boolean commit) {
        String op = commit ? "txnPrepareCommit" : "txnPrepare";
        this.mListener.notify(this.mType, "Redo %1$s: txnId=%2$d, prepareTxnId=%3$d, handlerId=%4$d, message=%5$s", op, txnId, prepareTxnId, handlerId, RedoEventPrinter.valueStr(message));
        return true;
    }

    @Override
    public boolean txnPrepareRollback(long txnId, long prepareTxnId) {
        this.mListener.notify(this.mType, "Redo %1$s: txnId=%2$d, prepareTxnId=%3$d", "txnPrepareRollback", txnId, prepareTxnId);
        return true;
    }

    @Override
    public boolean txnCommitFinalNotifySchema(long txnId, long indexId) {
        this.mListener.notify(this.mType, "Redo %1$s: txnId=%2$d, indexId=%3$d", "txnCommitFinalNotifySchema", txnId, indexId);
        return true;
    }

    @Override
    public boolean txnPredicateMode(long txnId) {
        this.mListener.notify(this.mType, "Redo %1$s: txnId=%2$d", "txnPredicateMode", txnId);
        return true;
    }

    @Override
    public boolean txnCustom(long txnId, int handlerId, byte[] message) {
        this.mListener.notify(this.mType, "Redo %1$s: txnId=%2$d, handlerId=%3$d, message=%4$s", "txnCustom", txnId, handlerId, RedoEventPrinter.valueStr(message));
        return true;
    }

    @Override
    public boolean txnCustomLock(long txnId, int handlerId, byte[] message, long indexId, byte[] key) {
        this.mListener.notify(this.mType, "Redo %1$s: txnId=%2$d, handlerId=%3$d, message=%4$s, key=%5$s", "txnCustomLock", txnId, handlerId, RedoEventPrinter.valueStr(message), RedoEventPrinter.keyStr(key));
        return true;
    }

    private static String keyStr(byte[] key) {
        if (key == null) {
            return "null";
        }
        char[] chars = Utils.utf8(key).toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (!Character.isISOControl(chars[i])) continue;
            chars[i] = 65533;
        }
        return "0x" + Utils.toHex(key) + " (" + String.valueOf(chars) + ")";
    }

    private static String valueStr(byte[] value) {
        return RedoEventPrinter.valueStr(value, 0, value == null ? 0 : value.length);
    }

    private static String valueStr(byte[] value, int offset, int length) {
        if (value == null) {
            return "null";
        }
        StringBuilder b = new StringBuilder().append("0x");
        if (length <= 1000) {
            b.append(Utils.toHex(value, offset, length));
        } else {
            b.append(Utils.toHex(value, offset, 1000)).append("...");
        }
        return b.append(" (length=").append(length).append(')').toString();
    }

    private static String toDateTime(long timestamp) {
        return Instant.ofEpochMilli(timestamp).toString();
    }
}

