/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.security.GeneralSecurityException;
import java.util.TreeMap;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.WriteFailureException;
import org.cojen.tupl.core.DataIn;
import org.cojen.tupl.core.Launcher;
import org.cojen.tupl.core.LocalTransaction;
import org.cojen.tupl.core.PendingTxn;
import org.cojen.tupl.core.RedoLogDecoder;
import org.cojen.tupl.core.RedoVisitor;
import org.cojen.tupl.core.RedoWriter;
import org.cojen.tupl.core.TransactionContext;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.diag.EventListener;
import org.cojen.tupl.diag.EventType;
import org.cojen.tupl.ext.Crypto;
import org.cojen.tupl.io.FileIO;

final class RedoLog
extends RedoWriter {
    private static final long MAGIC_NUMBER = 431399725605778814L;
    private static final int ENCODING_VERSION = 20130106;
    private final Crypto mCrypto;
    private final File mBaseFile;
    private final boolean mReplayMode;
    private final byte[] mBuffer;
    private int mBufferPos;
    private boolean mAlwaysFlush;
    private long mLogId;
    private long mPosition;
    private OutputStream mOut;
    private volatile FileChannel mChannel;
    private int mTermRndSeed;
    private long mNextLogId;
    private long mNextPosition;
    private OutputStream mNextOut;
    private FileChannel mNextChannel;
    private int mNextTermRndSeed;
    private volatile OutputStream mOldOut;
    private volatile FileChannel mOldChannel;
    private long mDeleteLogId;

    RedoLog(Launcher launcher, long logId, long redoPos) throws IOException {
        this(launcher.mRedoCrypto, launcher.mBaseFile, logId, redoPos, null);
    }

    RedoLog(Launcher launcher, RedoLog replayed, TransactionContext context) throws IOException {
        this(launcher.mRedoCrypto, launcher.mBaseFile, replayed.mLogId, replayed.mPosition, context);
    }

    RedoLog(Crypto crypto, File baseFile, long logId, long redoPos, TransactionContext context) throws IOException {
        this.mCrypto = crypto;
        this.mBaseFile = baseFile;
        this.mReplayMode = context == null;
        this.mBuffer = new byte[8192];
        this.acquireExclusive();
        this.mLogId = logId;
        this.mPosition = redoPos;
        this.releaseExclusive();
        if (context != null) {
            this.mNextLogId = -1L;
            this.openNextFile(logId);
            this.applyNextFile(context);
            this.mDeleteLogId = logId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TreeMap<Long, File> replay(RedoVisitor visitor, EventListener listener, EventType type, String message) throws IOException {
        if (!this.mReplayMode || this.mBaseFile == null) {
            throw new IllegalStateException();
        }
        this.acquireExclusive();
        try {
            TreeMap<Long, File> files;
            block17: {
                boolean finished;
                files = new TreeMap<Long, File>();
                do {
                    InputStream in;
                    File file = RedoLog.fileFor(this.mBaseFile, this.mLogId);
                    try {
                        in = new FileInputStream(file);
                    }
                    catch (FileNotFoundException e) {
                        break block17;
                    }
                    try {
                        if (this.mCrypto != null) {
                            try {
                                in = this.mCrypto.newDecryptingStream(in);
                            }
                            catch (IOException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                throw new DatabaseException(e);
                            }
                        }
                        if (listener != null) {
                            listener.notify(type, message, this.mLogId);
                        }
                        files.put(this.mLogId, file);
                        DataIn.Stream din = new DataIn.Stream(this.mPosition, in);
                        finished = this.replay(din, visitor, listener);
                        this.mPosition = din.mPos;
                    }
                    finally {
                        Utils.closeQuietly(in);
                    }
                    ++this.mLogId;
                } while (finished);
                Utils.deleteNumberedFiles(this.mBaseFile, ".redo.", this.mLogId, Long.MAX_VALUE);
            }
            TreeMap<Long, File> treeMap = files;
            return treeMap;
        }
        catch (IOException e) {
            throw Utils.rethrow(e, this.mCloseCause);
        }
        finally {
            this.releaseExclusive();
        }
    }

    private void openNextFile(long logId) throws IOException {
        OutputStream nextOut;
        FileChannel nextChannel;
        if (this.mNextLogId == logId) {
            return;
        }
        byte[] header = new byte[24];
        File file = RedoLog.fileFor(this.mBaseFile, logId);
        if (file.exists() && file.length() > (long)header.length) {
            throw new FileNotFoundException("Log file already exists: " + file.getPath());
        }
        FileOutputStream fout = null;
        int nextTermRndSeed = 0;
        try {
            fout = new FileOutputStream(file);
            nextChannel = fout.getChannel();
            if (this.mCrypto == null) {
                nextOut = fout;
            } else {
                try {
                    nextOut = this.mCrypto.newEncryptingStream(fout);
                }
                catch (GeneralSecurityException e) {
                    throw new DatabaseException(e);
                }
            }
            int offset = 0;
            Utils.encodeLongLE(header, offset, 431399725605778814L);
            Utils.encodeIntLE(header, offset += 8, 20130106);
            Utils.encodeLongLE(header, offset += 4, logId);
            Utils.encodeIntLE(header, offset += 8, nextTermRndSeed);
            if ((offset += 4) != header.length) {
                throw new AssertionError();
            }
            nextOut.write(header);
            FileIO.dirSync(file);
        }
        catch (IOException e) {
            Utils.closeQuietly(fout);
            file.delete();
            throw WriteFailureException.from(e);
        }
        this.mNextLogId = logId;
        this.mNextOut = nextOut;
        this.mNextChannel = nextChannel;
        this.mNextTermRndSeed = nextTermRndSeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyNextFile(TransactionContext ... contexts) throws IOException {
        FileChannel oldChannel;
        OutputStream oldOut;
        TransactionContext context = contexts[0];
        int i = contexts.length;
        while (--i >= 1) {
            contexts[i].flush();
        }
        context.fullAcquireRedoLatch(this);
        try {
            oldOut = this.mOut;
            oldChannel = this.mChannel;
            if (oldOut != null) {
                context.doRedoTimestamp(this, (byte)5, DurabilityMode.NO_FLUSH);
                context.doFlush();
                this.doFlush();
            }
            this.mNextPosition = this.mPosition;
            this.mOut = this.mNextOut;
            this.mChannel = this.mNextChannel;
            this.mTermRndSeed = this.mNextTermRndSeed;
            this.mLogId = this.mNextLogId;
            this.mNextOut = null;
            this.mNextChannel = null;
            this.mLastTxnId = 0L;
            context.doRedoTimestamp(this, (byte)2, DurabilityMode.NO_FLUSH);
            context.doRedoReset(this);
            context.doFlush();
        }
        finally {
            context.releaseRedoLatch();
        }
        Utils.closeQuietly(this.mOldOut);
        this.mOldOut = oldOut;
        this.mOldChannel = oldChannel;
    }

    private static File fileFor(File base, long logId) {
        return base == null ? null : new File(base.getPath() + ".redo." + logId);
    }

    @Override
    void txnCommitSync(long commitPos) throws IOException {
        try {
            this.force(false, -1L);
        }
        catch (IOException e) {
            throw Utils.rethrow(e, this.mCloseCause);
        }
    }

    @Override
    final long encoding() {
        return 0L;
    }

    @Override
    final RedoWriter txnRedoWriter() {
        return this;
    }

    @Override
    boolean shouldCheckpoint(long size) {
        try {
            FileChannel channel = this.mChannel;
            return channel != null && channel.size() >= size;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    void checkpointPrepare() throws IOException {
        if (this.mReplayMode) {
            throw new IllegalStateException();
        }
        this.acquireShared();
        long logId = this.mLogId;
        this.releaseShared();
        this.openNextFile(logId + 1L);
    }

    @Override
    void checkpointSwitch(TransactionContext[] contexts) throws IOException {
        this.applyNextFile(contexts);
    }

    @Override
    long checkpointNumber() {
        return this.mNextLogId;
    }

    @Override
    long checkpointPosition() {
        return this.mNextPosition;
    }

    @Override
    long checkpointTransactionId() {
        return 0L;
    }

    @Override
    void checkpointAborted() {
        if (this.mNextOut != null) {
            Utils.closeQuietly(this.mNextOut);
            this.mNextOut = null;
        }
    }

    @Override
    void checkpointStarted() throws IOException {
    }

    @Override
    void checkpointFlushed() throws IOException {
    }

    @Override
    void checkpointFinished() throws IOException {
        this.mOldChannel = null;
        Utils.closeQuietly(this.mOldOut);
        long id = this.mNextLogId;
        while (--id >= this.mDeleteLogId) {
            Utils.delete(RedoLog.fileFor(this.mBaseFile, id));
        }
        this.mDeleteLogId = this.mNextLogId;
    }

    void initialCheckpointFailed(Throwable cause) {
        try {
            this.close();
            for (long id = this.mNextLogId; id >= this.mDeleteLogId; --id) {
                Utils.delete(RedoLog.fileFor(this.mBaseFile, id));
            }
        }
        catch (Throwable e2) {
            Utils.suppress(cause, e2);
            Utils.rethrow(cause);
        }
    }

    @Override
    DurabilityMode opWriteCheck(DurabilityMode mode) throws IOException {
        return mode;
    }

    @Override
    boolean shouldWriteTerminators() {
        return true;
    }

    @Override
    long write(boolean flush, byte[] bytes, int offset, int length, int commitLen, PendingTxn pending) throws IOException {
        try {
            byte[] buf = this.mBuffer;
            int avail = buf.length - this.mBufferPos;
            if (avail >= length) {
                if (this.mBufferPos == 0 && avail == length) {
                    this.mOut.write(bytes, offset, length);
                } else {
                    System.arraycopy(bytes, offset, buf, this.mBufferPos, length);
                    this.mBufferPos += length;
                    if (this.mBufferPos == buf.length || flush || this.mAlwaysFlush) {
                        this.mOut.write(buf, 0, this.mBufferPos);
                        this.mBufferPos = 0;
                    }
                }
            } else {
                System.arraycopy(bytes, offset, buf, this.mBufferPos, avail);
                this.mBufferPos = buf.length;
                this.mOut.write(buf, 0, this.mBufferPos);
                offset += avail;
                int rem = length - avail;
                if (rem >= buf.length || flush || this.mAlwaysFlush) {
                    this.mBufferPos = 0;
                    this.mOut.write(bytes, offset, rem);
                } else {
                    System.arraycopy(bytes, offset, buf, 0, rem);
                    this.mBufferPos = rem;
                }
            }
            return this.mPosition += (long)length;
        }
        catch (IOException e) {
            throw WriteFailureException.from(e);
        }
    }

    @Override
    void alwaysFlush(boolean enable) throws IOException {
        this.acquireExclusive();
        try {
            this.mAlwaysFlush = enable;
            if (enable) {
                this.doFlush();
            }
        }
        finally {
            this.releaseExclusive();
        }
    }

    @Override
    public void flush() throws IOException {
        this.acquireExclusive();
        try {
            this.doFlush();
        }
        finally {
            this.releaseExclusive();
        }
    }

    private void doFlush() throws IOException {
        try {
            if (this.mBufferPos > 0) {
                this.mOut.write(this.mBuffer, 0, this.mBufferPos);
                this.mBufferPos = 0;
            }
        }
        catch (IOException e) {
            throw WriteFailureException.from(e);
        }
    }

    @Override
    void force(boolean metadata, long nanosTimeout) throws IOException {
        FileChannel channel;
        FileChannel oldChannel = this.mOldChannel;
        if (oldChannel != null) {
            try {
                oldChannel.force(true);
            }
            catch (ClosedChannelException closedChannelException) {
                // empty catch block
            }
            this.mOldChannel = null;
        }
        if ((channel = this.mChannel) != null) {
            try {
                channel.force(metadata);
            }
            catch (ClosedChannelException closedChannelException) {
                // empty catch block
            }
        }
    }

    @Override
    public void close() throws IOException {
        RedoLog.close(this.mNextOut, this.mNextChannel);
        RedoLog.close(this.mOut, this.mChannel);
        RedoLog.close(this.mOldOut, this.mOldChannel);
    }

    private static void close(OutputStream out, FileChannel channel) throws IOException {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (ClosedChannelException closedChannelException) {
                // empty catch block
            }
        }
        Utils.closeQuietly(out);
    }

    @Override
    void stashForRecovery(LocalTransaction txn) {
    }

    int nextTermRnd() {
        this.mTermRndSeed = Utils.nextRandom(this.mTermRndSeed);
        return this.mTermRndSeed;
    }

    private boolean replay(DataIn in, RedoVisitor visitor, EventListener listener) throws IOException {
        try {
            long magic = in.readLongLE();
            if (magic != 431399725605778814L) {
                if (magic == 0L) {
                    return false;
                }
                throw new DatabaseException("Incorrect magic number in redo log file");
            }
        }
        catch (EOFException e) {
            return false;
        }
        int version = in.readIntLE();
        if (version != 20130106) {
            throw new DatabaseException("Unsupported redo log encoding version: " + version);
        }
        long id = in.readLongLE();
        if (id != this.mLogId) {
            throw new DatabaseException("Expected redo log identifier of " + this.mLogId + ", but actual is: " + id);
        }
        this.mTermRndSeed = in.readIntLE();
        try {
            return new RedoLogDecoder(this, in, listener).run(visitor);
        }
        catch (EOFException e) {
            if (listener != null) {
                listener.notify(EventType.RECOVERY_REDO_LOG_CORRUPTION, "Unexpected end of file", new Object[0]);
            }
            return false;
        }
    }
}

