/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.core.BTreeCursor;
import org.cojen.tupl.core.LHashTable;
import org.cojen.tupl.core.LocalDatabase;
import org.cojen.tupl.core.LocalTransaction;
import org.cojen.tupl.core.ReplEngine;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.util.Parker;

final class RedoLogApplier
extends ReplEngine {
    private long mHighestTxnId;

    RedoLogApplier(int maxThreads, LocalDatabase db, LHashTable.Obj<LocalTransaction> txns, LHashTable.Obj<BTreeCursor> cursors) throws IOException {
        super(null, maxThreads, db, txns, cursors);
    }

    public long highestTxnId(long txnId) {
        if (this.mHighestTxnId != 0L && (txnId == 0L || this.mHighestTxnId - txnId > 0L)) {
            txnId = this.mHighestTxnId;
        }
        return txnId;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.setName("Recovery-" + Long.toUnsignedString(Parker.threadId(t)));
        t.setUncaughtExceptionHandler((thread, ex) -> Utils.closeQuietly(this.mDatabase, ex));
        return t;
    }

    @Override
    public boolean reset() throws IOException {
        return true;
    }

    @Override
    protected LocalTransaction newTransaction(long txnId) {
        if (txnId > this.mHighestTxnId) {
            this.mHighestTxnId = txnId;
        }
        LocalTransaction txn = new LocalTransaction(this.mDatabase, txnId, LockMode.UPGRADABLE_READ, -1L);
        txn.attach(this.attachment());
        return txn;
    }

    @Override
    protected Object attachment() {
        return "recovery";
    }
}

