/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.EOFException;
import java.io.IOException;
import org.cojen.tupl.core.DataIn;
import org.cojen.tupl.core.RedoDecoder;
import org.cojen.tupl.core.RedoLog;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.diag.EventListener;
import org.cojen.tupl.diag.EventType;
import org.cojen.tupl.util.Latch;

final class RedoLogDecoder
extends RedoDecoder {
    private final RedoLog mLog;
    private final EventListener mListener;

    RedoLogDecoder(RedoLog log, DataIn in, EventListener listener) {
        super(true, 0L, in, new Latch());
        this.mLog = log;
        this.mListener = listener;
    }

    @Override
    boolean verifyTerminator(DataIn in) throws IOException {
        try {
            int term = in.readIntLE();
            if (term == this.mLog.nextTermRnd() || term == Utils.nzHash(this.mTxnId)) {
                return true;
            }
            if (this.mListener != null) {
                this.mListener.notify(EventType.RECOVERY_REDO_LOG_CORRUPTION, "Invalid message terminator", new Object[0]);
            }
            return false;
        }
        catch (EOFException e) {
            if (this.mListener != null) {
                this.mListener.notify(EventType.RECOVERY_REDO_LOG_CORRUPTION, "Unexpected end of file", new Object[0]);
            }
            return false;
        }
    }
}

