/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.core.LocalTransaction;
import org.cojen.tupl.core.PendingTxn;
import org.cojen.tupl.core.TransactionContext;
import org.cojen.tupl.diag.DatabaseStats;
import org.cojen.tupl.util.Latch;
import org.cojen.tupl.util.Runner;

abstract class RedoWriter
extends Latch
implements Closeable,
Flushable {
    long mLastTxnId;
    volatile Throwable mCloseCause;

    RedoWriter() {
    }

    final void closeCause(Throwable cause) {
        if (cause != null) {
            this.acquireExclusive();
            if (this.mCloseCause == null) {
                this.mCloseCause = cause;
            }
            this.releaseExclusive();
        }
    }

    boolean isLeader() {
        return true;
    }

    void uponLeader(Runnable acquired, Runnable lost) {
        if (acquired != null) {
            Runner.start(acquired);
        }
    }

    boolean failover() throws IOException {
        return false;
    }

    void addStats(DatabaseStats stats) {
    }

    abstract void txnCommitSync(long var1) throws IOException;

    abstract long encoding();

    abstract RedoWriter txnRedoWriter();

    abstract boolean shouldCheckpoint(long var1);

    abstract void checkpointPrepare() throws IOException;

    abstract void checkpointSwitch(TransactionContext[] var1) throws IOException;

    abstract long checkpointNumber() throws IOException;

    abstract long checkpointPosition() throws IOException;

    abstract long checkpointTransactionId() throws IOException;

    abstract void checkpointAborted();

    abstract void checkpointStarted() throws IOException;

    abstract void checkpointFlushed() throws IOException;

    abstract void checkpointFinished() throws IOException;

    long adjustTransactionId(long txnId) {
        return txnId;
    }

    abstract DurabilityMode opWriteCheck(DurabilityMode var1) throws IOException;

    abstract boolean shouldWriteTerminators();

    abstract long write(boolean var1, byte[] var2, int var3, int var4, int var5, PendingTxn var6) throws IOException;

    abstract void alwaysFlush(boolean var1) throws IOException;

    abstract void force(boolean var1, long var2) throws IOException;

    abstract void stashForRecovery(LocalTransaction var1);
}

