/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.lang.invoke.VarHandle;
import java.lang.ref.SoftReference;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.cojen.tupl.ClosedIndexException;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.Index;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.UnmodifiableReplicaException;
import org.cojen.tupl.core.BTree;
import org.cojen.tupl.core.BTreeCursor;
import org.cojen.tupl.core.CommitLock;
import org.cojen.tupl.core.LHashTable;
import org.cojen.tupl.core.LocalDatabase;
import org.cojen.tupl.core.LocalTransaction;
import org.cojen.tupl.core.Lock;
import org.cojen.tupl.core.Locker;
import org.cojen.tupl.core.PendingTxnFinisher;
import org.cojen.tupl.core.RedoDecoder;
import org.cojen.tupl.core.RedoListener;
import org.cojen.tupl.core.RedoVisitor;
import org.cojen.tupl.core.ReplController;
import org.cojen.tupl.core.ReplDecoder;
import org.cojen.tupl.core.ReplWriter;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.diag.EventListener;
import org.cojen.tupl.diag.EventType;
import org.cojen.tupl.ext.CustomHandler;
import org.cojen.tupl.repl.StreamReplicator;
import org.cojen.tupl.rows.RowStore;
import org.cojen.tupl.util.Latch;
import org.cojen.tupl.util.LatchCondition;
import org.cojen.tupl.util.Parker;
import org.cojen.tupl.util.Runner;
import org.cojen.tupl.util.WeakPool;
import org.cojen.tupl.util.Worker;
import org.cojen.tupl.util.WorkerGroup;

class ReplEngine
implements RedoVisitor,
ThreadFactory {
    private static final int MAX_QUEUE_SIZE = 1000;
    private static final int MAX_KEEP_ALIVE_MILLIS = 60000;
    static final long INFINITE_TIMEOUT = -1L;
    static final String ATTACHMENT = "replication";
    private static final VarHandle cDecodeExceptionHandle;
    private static final MutableCallSite cStoreListenerCallSite;
    private static final MethodHandle cStoreListenerHandle;
    private static int cStoreListenerActiveCount;
    final StreamReplicator mRepl;
    final LocalDatabase mDatabase;
    final ReplController mController;
    final PendingTxnFinisher mFinisher;
    private final WorkerGroup mWorkerGroup;
    private final Latch mDecodeLatch;
    private final TxnTable mTransactions;
    private LatchCondition mStashedCond;
    private final LHashTable.Obj<SoftReference<Index>> mIndexes;
    private final CursorTable mCursors;
    private volatile ReplDecoder mDecoder;
    private volatile Throwable mDecodeException;
    private volatile boolean mDecodeLatched;
    private volatile CopyOnWriteArrayList<RedoListener> mRedoListeners;

    private static MethodType storeListenerType() {
        return MethodType.methodType(Void.TYPE, ReplEngine.class, Transaction.class, Index.class, byte[].class, byte[].class);
    }

    private static MethodHandle emptyStoreListener() {
        return MethodHandles.empty(ReplEngine.storeListenerType());
    }

    ReplEngine(StreamReplicator repl, int maxThreads, LocalDatabase db, LHashTable.Obj<LocalTransaction> txns, LHashTable.Obj<BTreeCursor> cursors) throws IOException {
        CursorTable cursorTable;
        TxnTable txnTable;
        if (maxThreads <= 0) {
            int procCount = Runtime.getRuntime().availableProcessors();
            int n = maxThreads = maxThreads == 0 ? procCount : -maxThreads * procCount;
            if (maxThreads <= 0) {
                maxThreads = Integer.MAX_VALUE;
            }
        }
        this.mRepl = repl;
        this.mDatabase = db;
        this.mController = new ReplController(this);
        this.mFinisher = new PendingTxnFinisher(maxThreads);
        this.mDecodeLatch = new Latch();
        this.mWorkerGroup = maxThreads <= 1 ? null : WorkerGroup.make(maxThreads - 1, 1000, 60000L, TimeUnit.MILLISECONDS, this);
        if (txns == null) {
            txnTable = new TxnTable(16);
        } else {
            txnTable = new TxnTable(txns.size());
            txns.traverse(te -> {
                long scrambledTxnId = Utils.fibHash(te.key);
                LocalTransaction txn = (LocalTransaction)te.value;
                if (!txn.recoveryCleanup(false)) {
                    ((TxnEntry)txnTable.insert((long)scrambledTxnId)).mTxn = txn;
                }
                return true;
            });
        }
        this.mTransactions = txnTable;
        this.mIndexes = new LHashTable.Obj(0);
        if (cursors == null) {
            cursorTable = new CursorTable(4);
        } else {
            cursorTable = new CursorTable(cursors.size());
            cursors.traverse(ce -> {
                long scrambledCursorId = Utils.fibHash(ce.key);
                ((CursorEntry)cursorTable.insert(scrambledCursorId)).recovered((BTreeCursor)ce.value);
                return true;
            });
        }
        this.mCursors = cursorTable;
    }

    public ReplController initWriter(long redoNum) {
        this.mController.initCheckpointNumber(redoNum);
        return this.mController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplDecoder startReceiving(long initialPosition, long initialTxnId) {
        ReplDecoder decoder;
        try {
            this.mDecodeLatch.acquireExclusive();
            try {
                decoder = this.mDecoder;
                if (decoder == null || decoder.mDeactivated) {
                    this.mDecoder = decoder = new ReplDecoder(this.mRepl, initialPosition, initialTxnId, this.mDecodeLatch);
                    this.newThread(this::decode).start();
                }
            }
            finally {
                this.mDecodeLatch.releaseExclusive();
            }
        }
        catch (Throwable e) {
            this.fail(e);
            return null;
        }
        return decoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRedoListener(RedoListener listener) {
        boolean alreadyLatched = this.mDecodeLatched;
        if (!alreadyLatched) {
            this.mDecodeLatch.acquireExclusive();
        }
        try {
            if (this.mRedoListeners == null) {
                ReplEngine.activateRedoStoreListener();
                this.mRedoListeners = new CopyOnWriteArrayList();
            }
            if (!this.mRedoListeners.addIfAbsent(listener)) {
                boolean bl = false;
                return bl;
            }
            if (this.mWorkerGroup != null) {
                this.mWorkerGroup.join(false);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (!alreadyLatched) {
                this.mDecodeLatch.releaseExclusive();
            }
        }
    }

    public boolean removeRedoListener(RedoListener listener) {
        this.mDecodeLatch.acquireExclusive();
        try {
            if (this.mRedoListeners == null || !this.mRedoListeners.remove(listener)) {
                boolean bl = false;
                return bl;
            }
            if (this.mRedoListeners.isEmpty()) {
                ReplEngine.deactivateRedoStoreListener();
                this.mRedoListeners = null;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.mDecodeLatch.releaseExclusive();
        }
    }

    public void withRedoLock(Runnable callback) {
        this.mDecodeLatch.acquireExclusive();
        try {
            if (this.mWorkerGroup != null) {
                this.mWorkerGroup.join(false);
            }
            callback.run();
        }
        finally {
            this.mDecodeLatch.releaseExclusive();
        }
    }

    private static synchronized void activateRedoStoreListener() {
        if (cStoreListenerActiveCount == 0) {
            MethodHandle mh;
            try {
                mh = MethodHandles.lookup().findStatic(ReplEngine.class, "doRedoListenerStore", ReplEngine.storeListenerType());
            }
            catch (Throwable e) {
                throw Utils.rethrow(e);
            }
            cStoreListenerCallSite.setTarget(mh);
            MutableCallSite.syncAll(new MutableCallSite[]{cStoreListenerCallSite});
        }
        ++cStoreListenerActiveCount;
    }

    private static synchronized void deactivateRedoStoreListener() {
        if (cStoreListenerActiveCount > 1) {
            --cStoreListenerActiveCount;
        } else {
            cStoreListenerCallSite.setTarget(ReplEngine.emptyStoreListener());
            cStoreListenerActiveCount = 0;
        }
    }

    private static void redoListenerStore(ReplEngine repl, Transaction txn, Index ix, byte[] key, byte[] value) {
        try {
            cStoreListenerHandle.invokeExact(repl, txn, ix, key, value);
        }
        catch (Throwable e) {
            Utils.rethrow(e);
        }
    }

    private static void doRedoListenerStore(ReplEngine repl, Transaction txn, Index ix, byte[] key, byte[] value) {
        CopyOnWriteArrayList<RedoListener> listeners = repl.mRedoListeners;
        if (listeners != null) {
            listeners.forEach(listener -> {
                try {
                    listener.store(txn, ix, key, value);
                }
                catch (Throwable e) {
                    Utils.uncaught(e);
                }
            });
        }
    }

    @Override
    public Thread newThread(Runnable r) {
        return this.newThread(r, "ReplicationReceiver");
    }

    private Thread newThread(Runnable r, String namePrefix) {
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.setName(namePrefix + "-" + Long.toUnsignedString(Parker.threadId(t)));
        t.setUncaughtExceptionHandler((thread, exception) -> this.fail(exception, true));
        return t;
    }

    @Override
    public boolean reset() throws IOException {
        LHashTable.Obj<LocalTransaction> remaining = this.doReset(false);
        if (remaining != null) {
            remaining.traverse(entry -> {
                ((TxnEntry)this.mTransactions.insert((long)entry.key)).mTxn = (LocalTransaction)entry.value;
                return false;
            });
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LHashTable.Obj<LocalTransaction> doReset(boolean interrupt) throws IOException {
        LHashTable.Obj remaining;
        if (this.mTransactions.size() == 0) {
            remaining = null;
        } else {
            remaining = new LHashTable.Obj(16);
            this.mTransactions.traverse(te -> {
                this.runTask((TxnEntry)te, new Worker.Task((TxnEntry)te, remaining){
                    final /* synthetic */ TxnEntry val$te;
                    final /* synthetic */ LHashTable.Obj val$remaining;
                    {
                        this.val$te = txnEntry;
                        this.val$remaining = obj;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() throws IOException {
                        LocalTransaction txn = this.val$te.mTxn;
                        if (!txn.recoveryCleanup(true)) {
                            LHashTable.Obj obj = this.val$remaining;
                            synchronized (obj) {
                                ((LHashTable.ObjEntry)this.val$remaining.insert((long)this.val$te.key)).value = txn;
                            }
                        }
                    }
                });
                return true;
            });
        }
        if (this.mWorkerGroup != null) {
            this.mWorkerGroup.join(interrupt);
        }
        CursorTable cursorTable = this.mCursors;
        synchronized (cursorTable) {
            this.mCursors.traverse(entry -> {
                BTreeCursor cursor = entry.mCursor;
                this.mDatabase.unregisterCursor(cursor.mCursorId);
                this.reset(cursor);
                return true;
            });
        }
        this.mDatabase.emptyLingeringTrash(remaining);
        return remaining == null || remaining.size() == 0 ? null : remaining;
    }

    public LHashTable.Obj<LocalTransaction> finish() throws IOException {
        this.mDecodeLatch.acquireExclusive();
        try {
            int amt;
            EventListener listener = this.mDatabase.eventListener();
            if (listener != null && (amt = this.mTransactions.size()) != 0) {
                listener.notify(EventType.RECOVERY_PROCESS_REMAINING, "Processing remaining transactions: %1$d", amt);
            }
            LHashTable.Obj<LocalTransaction> obj = this.doReset(true);
            return obj;
        }
        finally {
            this.mDecodeLatch.releaseExclusive();
        }
    }

    @Override
    public boolean timestamp(long timestamp) throws IOException {
        return true;
    }

    @Override
    public boolean shutdown(long timestamp) throws IOException {
        return true;
    }

    @Override
    public boolean close(long timestamp) throws IOException {
        return true;
    }

    @Override
    public boolean endFile(long timestamp) throws IOException {
        return true;
    }

    @Override
    public boolean control(byte[] message) throws IOException {
        if (this.mWorkerGroup != null) {
            this.mWorkerGroup.join(false);
        }
        this.mRepl.controlMessageReceived(this.mDecoder.mIn.mPos, message);
        return true;
    }

    @Override
    public boolean store(long indexId, byte[] key, byte[] value) throws IOException {
        Locker locker = new Locker(this.mDatabase.mLockManager){

            @Override
            public Object attachment() {
                return ReplEngine.this.attachment();
            }
        };
        locker.doTryLockUpgradable(indexId, key, -1L);
        this.runTaskAnywhere(new Worker.Task(locker, indexId, key, value){
            final /* synthetic */ 2 val$locker;
            final /* synthetic */ long val$indexId;
            final /* synthetic */ byte[] val$key;
            final /* synthetic */ byte[] val$value;
            {
                this.val$locker = var2_2;
                this.val$indexId = l;
                this.val$key = byArray;
                this.val$value = byArray2;
            }

            @Override
            public void run() throws IOException {
                try {
                    this.val$locker.doLockExclusive(this.val$indexId, this.val$key, -1L);
                    ReplEngine.this.doStore(Transaction.BOGUS, this.val$indexId, this.val$key, this.val$value);
                }
                finally {
                    this.val$locker.scopeUnlockAll();
                }
            }
        });
        return true;
    }

    @Override
    public boolean storeNoLock(long indexId, byte[] key, byte[] value) throws IOException {
        return this.store(indexId, key, value);
    }

    @Override
    public boolean renameIndex(long txnId, long indexId, byte[] newName) throws IOException {
        block3: {
            Index ix = this.getIndex(indexId);
            if (ix != null) {
                try {
                    this.mDatabase.renameIndex(ix, newName, txnId);
                }
                catch (RuntimeException e) {
                    EventListener listener = this.mDatabase.eventListener();
                    if (listener == null) break block3;
                    listener.notify(EventType.REPLICATION_WARNING, "Unable to rename index: %1$s", Utils.rootCause(e));
                }
            }
        }
        return true;
    }

    @Override
    public boolean deleteIndex(long txnId, final long indexId) {
        final TxnEntry te = this.getTxnEntry(txnId);
        this.runTask(te, new Worker.Task(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() throws IOException {
                Runnable task;
                LocalTransaction txn = te.mTxn;
                Index ix = ReplEngine.this.getIndex(txn, indexId);
                LHashTable.Obj<SoftReference<Index>> obj = ReplEngine.this.mIndexes;
                synchronized (obj) {
                    ReplEngine.this.mIndexes.remove(indexId);
                }
                ReplEngine.this.mDatabase.redoMoveToTrash(txn, indexId);
                try {
                    txn.commit();
                }
                finally {
                    txn.exit();
                }
                RowStore rs = ReplEngine.this.mDatabase.rowStore(false);
                if (rs == null || (task = rs.redoDeleteIndex(indexId, () -> ReplEngine.this.doDeleteIndex(indexId, ix))) == null) {
                    task = ReplEngine.this.doDeleteIndex(indexId, ix);
                }
                Runner.start("IndexDeletion-" + (Serializable)(ix == null ? Long.valueOf(indexId) : ix.nameString()), task);
            }
        });
        return true;
    }

    private Runnable doDeleteIndex(long indexId, Index ix) {
        try {
            return this.mDatabase.replicaDeleteTree(indexId, ix);
        }
        catch (IOException e) {
            throw Utils.rethrow(e);
        }
    }

    @Override
    public boolean txnEnter(long txnId) throws IOException {
        long scrambledTxnId = Utils.fibHash(txnId);
        final TxnEntry te = (TxnEntry)this.mTransactions.get(scrambledTxnId);
        if (te == null) {
            ((TxnEntry)this.mTransactions.insert((long)scrambledTxnId)).mTxn = this.newTransaction(txnId);
        } else {
            this.runTask(te, new Worker.Task(){

                @Override
                public void run() throws IOException {
                    te.mTxn.enter();
                }
            });
        }
        return true;
    }

    @Override
    public boolean txnRollback(long txnId) {
        final TxnEntry te = this.getTxnEntry(txnId);
        te.mPredicateMode = false;
        this.runTask(te, new Worker.Task(){

            @Override
            public void run() {
                te.mTxn.exit();
            }
        });
        return true;
    }

    @Override
    public boolean txnRollbackFinal(long txnId) {
        final TxnEntry te = this.removeTxnEntry(txnId);
        if (te != null) {
            this.runTask(te, new Worker.Task(){

                @Override
                public void run() {
                    te.mTxn.reset();
                }
            });
        }
        return true;
    }

    @Override
    public boolean txnCommit(long txnId) {
        final TxnEntry te = this.getTxnEntry(txnId);
        te.mPredicateMode = false;
        this.runTask(te, new Worker.Task(){

            @Override
            public void run() throws IOException {
                te.mTxn.commit();
            }
        });
        return true;
    }

    @Override
    public boolean txnCommitFinal(long txnId) {
        final TxnEntry te = this.removeTxnEntry(txnId);
        if (te != null) {
            this.runTask(te, new Worker.Task(){

                @Override
                public void run() throws IOException {
                    te.mTxn.commitAll();
                }
            });
        }
        return true;
    }

    @Override
    public boolean txnEnterStore(long txnId, final long indexId, final byte[] key, final byte[] value) throws IOException {
        long scrambledTxnId = Utils.fibHash(txnId);
        TxnEntry te = (TxnEntry)this.mTransactions.get(scrambledTxnId);
        if (te == null) {
            final LocalTransaction txn = this.newTransaction(txnId);
            te = (TxnEntry)this.mTransactions.insert(scrambledTxnId);
            te.mTxn = txn;
            final Lock lock = txn.doLockUpgradableNoPush(indexId, key);
            this.runTask(te, new Worker.Task(){

                @Override
                public void run() throws IOException {
                    txn.push(lock);
                    ReplEngine.this.doStore(txn, indexId, key, value);
                }
            });
            return true;
        }
        final LocalTransaction txn = te.mTxn;
        if (te.mPredicateMode && value != null) {
            final Object locks = this.mDatabase.rowStore().acquireLocksNoPush(txn, indexId, key, value);
            this.runTask(te, new Worker.Task(){

                @Override
                public void run() throws IOException {
                    txn.enter();
                    ReplEngine.this.pushPredicateLocks(txn, locks);
                    ReplEngine.this.doStore(txn, indexId, key, value);
                }
            });
            return true;
        }
        final Lock lock = txn.doLockUpgradableNoPush(indexId, key);
        this.runTask(te, new Worker.Task(){

            @Override
            public void run() throws IOException {
                txn.enter();
                if (lock != null) {
                    txn.push(lock);
                }
                ReplEngine.this.doStore(txn, indexId, key, value);
            }
        });
        return true;
    }

    @Override
    public boolean txnStore(long txnId, final long indexId, final byte[] key, final byte[] value) throws IOException {
        TxnEntry te = this.getTxnEntry(txnId);
        final LocalTransaction txn = te.mTxn;
        if (te.mPredicateMode && value != null) {
            final Object locks = this.mDatabase.rowStore().acquireLocksNoPush(txn, indexId, key, value);
            this.runTask(te, new Worker.Task(){

                @Override
                public void run() throws IOException {
                    ReplEngine.this.pushPredicateLocks(txn, locks);
                    ReplEngine.this.doStore(txn, indexId, key, value);
                }
            });
            return true;
        }
        final Lock lock = txn.doLockUpgradableNoPush(indexId, key);
        this.runTask(te, new Worker.Task(){

            @Override
            public void run() throws IOException {
                if (lock != null) {
                    txn.push(lock);
                }
                ReplEngine.this.doStore(txn, indexId, key, value);
            }
        });
        return true;
    }

    @Override
    public boolean txnStoreCommit(long txnId, final long indexId, final byte[] key, final byte[] value) throws IOException {
        TxnEntry te = this.getTxnEntry(txnId);
        final LocalTransaction txn = te.mTxn;
        if (te.mPredicateMode) {
            te.mPredicateMode = false;
            if (value != null) {
                final Object locks = this.mDatabase.rowStore().acquireLocksNoPush(txn, indexId, key, value);
                this.runTask(te, new Worker.Task(){

                    @Override
                    public void run() throws IOException {
                        ReplEngine.this.pushPredicateLocks(txn, locks);
                        ReplEngine.this.doStore(txn, indexId, key, value);
                        txn.commit();
                    }
                });
                return true;
            }
        }
        final Lock lock = txn.doLockUpgradableNoPush(indexId, key);
        this.runTask(te, new Worker.Task(){

            @Override
            public void run() throws IOException {
                if (lock != null) {
                    txn.push(lock);
                }
                ReplEngine.this.doStore(txn, indexId, key, value);
                txn.commit();
            }
        });
        return true;
    }

    @Override
    public boolean txnStoreCommitFinal(long txnId, final long indexId, final byte[] key, final byte[] value) throws IOException {
        TxnEntry te = this.removeTxnEntry(txnId);
        if (te == null) {
            final LocalTransaction txn = this.newTransaction(txnId);
            final Lock lock = txn.doLockUpgradableNoPush(indexId, key);
            this.runTaskAnywhere(new Worker.Task(){

                @Override
                public void run() throws IOException {
                    txn.push(lock);
                    txn.doLockExclusive(indexId, key, -1L);
                    ReplEngine.this.doStore(Transaction.BOGUS, indexId, key, value);
                    txn.commitAll();
                }
            });
            return true;
        }
        final LocalTransaction txn = te.mTxn;
        if (te.mPredicateMode && value != null) {
            final Object locks = this.mDatabase.rowStore().acquireLocksNoPush(txn, indexId, key, value);
            this.runTask(te, new Worker.Task(){

                @Override
                public void run() throws IOException {
                    ReplEngine.this.pushPredicateLocks(txn, locks);
                    txn.doLockExclusive(indexId, key, -1L);
                    ReplEngine.this.doStore(Transaction.BOGUS, indexId, key, value);
                    txn.commitAll();
                }
            });
            return true;
        }
        final Lock lock = txn.doLockUpgradableNoPush(indexId, key);
        this.runTask(te, new Worker.Task(){

            @Override
            public void run() throws IOException {
                if (lock != null) {
                    txn.push(lock);
                }
                txn.doLockExclusive(indexId, key, -1L);
                ReplEngine.this.doStore(Transaction.BOGUS, indexId, key, value);
                txn.commitAll();
            }
        });
        return true;
    }

    private void doStore(Transaction txn, long indexId, byte[] key, byte[] value) throws IOException {
        Index ix = this.getIndex(indexId);
        while (ix != null) {
            try {
                ix.store(txn, key, value);
                break;
            }
            catch (Throwable e) {
                ix = this.reopenIndex(e, indexId);
            }
        }
        ReplEngine.redoListenerStore(this, txn, ix, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cursorRegister(long cursorId, long indexId) throws IOException {
        long scrambledCursorId = Utils.fibHash(cursorId);
        Index ix = this.getIndex(indexId);
        if (ix != null) {
            BTreeCursor tc = (BTreeCursor)ix.newCursor(Transaction.BOGUS);
            tc.mKeyOnly = true;
            tc.mCursorId = cursorId;
            this.register(tc);
            CursorTable cursorTable = this.mCursors;
            synchronized (cursorTable) {
                ((CursorEntry)this.mCursors.insert((long)scrambledCursorId)).mCursor = tc;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cursorUnregister(long cursorId) {
        CursorEntry ce;
        long scrambledCursorId = Utils.fibHash(cursorId);
        CursorTable cursorTable = this.mCursors;
        synchronized (cursorTable) {
            ce = (CursorEntry)this.mCursors.remove(scrambledCursorId);
        }
        if (ce != null) {
            final BTreeCursor tc = ce.mCursor;
            Worker w = ce.mWorker;
            if (w == null) {
                this.reset(tc);
            } else {
                w.enqueue(new Worker.Task(){

                    @Override
                    public void run() throws IOException {
                        ReplEngine.this.reset(tc);
                    }
                });
            }
        }
        return true;
    }

    @Override
    public boolean cursorStore(long cursorId, long txnId, final byte[] key, final byte[] value) throws IOException {
        final CursorEntry ce = this.getCursorEntry(cursorId);
        if (ce == null) {
            return true;
        }
        TxnEntry te = this.getTxnEntry(txnId);
        final LocalTransaction txn = te.mTxn;
        if (te.mPredicateMode && value != null) {
            long indexId = ce.mCursor.mTree.id();
            final Object locks = this.mDatabase.rowStore().acquireLocksNoPush(txn, indexId, key, value);
            this.runCursorTask(ce, te, new Worker.Task(){

                @Override
                public void run() throws IOException {
                    ReplEngine.this.pushPredicateLocks(txn, locks);
                    ReplEngine.this.doCursorStore(ce, txn, key, value);
                }
            });
            return true;
        }
        ce.mKey = key;
        final Lock lock = txn.doLockUpgradableNoPush(ce.mCursor.mTree.mId, key);
        this.runCursorTask(ce, te, new Worker.Task(){

            @Override
            public void run() throws IOException {
                if (lock != null) {
                    txn.push(lock);
                }
                ReplEngine.this.doCursorStore(ce, txn, key, value);
            }
        });
        return true;
    }

    private void doCursorStore(CursorEntry ce, LocalTransaction txn, byte[] key, byte[] value) throws IOException {
        BTreeCursor tc = this.findAndRegister(ce, txn, key);
        while (true) {
            try {
                tc.store(value);
                tc.mValue = Cursor.NOT_LOADED;
            }
            catch (ClosedIndexException e) {
                if ((tc = this.reopenCursor(e, ce)) != null) continue;
            }
            break;
        }
        ReplEngine.redoListenerStore(this, txn, tc.mTree, key, value);
    }

    @Override
    public boolean cursorFind(long cursorId, long txnId, final byte[] key) throws LockFailureException {
        final CursorEntry ce = this.getCursorEntry(cursorId);
        if (ce == null) {
            return true;
        }
        TxnEntry te = this.getTxnEntry(txnId);
        final LocalTransaction txn = te.mTxn;
        ce.mKey = key;
        final Lock lock = txn.doLockUpgradableNoPush(ce.mCursor.mTree.mId, key);
        this.runCursorTask(ce, te, new Worker.Task(){

            @Override
            public void run() throws IOException {
                if (lock != null) {
                    txn.push(lock);
                }
                ReplEngine.this.findAndRegister(ce, txn, key);
            }
        });
        return true;
    }

    @Override
    public boolean cursorValueSetLength(long cursorId, long txnId, final long length) throws LockFailureException {
        final CursorEntry ce = this.getCursorEntry(cursorId);
        if (ce == null) {
            return true;
        }
        TxnEntry te = this.getTxnEntry(txnId);
        final LocalTransaction txn = te.mTxn;
        BTreeCursor tc = ce.mCursor;
        final Lock lock = txn.doLockUpgradableNoPush(tc.mTree.mId, ce.mKey);
        this.runCursorTask(ce, te, new Worker.Task(){

            @Override
            public void run() throws IOException {
                if (lock != null) {
                    txn.push(lock);
                }
                BTreeCursor tc = ce.mCursor;
                tc.mTxn = txn;
                while (true) {
                    try {
                        tc.valueLength(length);
                    }
                    catch (ClosedIndexException e) {
                        if ((tc = ReplEngine.this.reopenCursor(e, ce)) != null) continue;
                    }
                    break;
                }
            }
        });
        return true;
    }

    @Override
    public boolean cursorValueWrite(long cursorId, long txnId, final long pos, final WeakPool.Entry<byte[]> entry, final byte[] buf, final int off, final int len) throws LockFailureException {
        final CursorEntry ce = this.getCursorEntry(cursorId);
        if (ce == null) {
            entry.release();
            return true;
        }
        try {
            TxnEntry te = this.getTxnEntry(txnId);
            final LocalTransaction txn = te.mTxn;
            BTreeCursor tc = ce.mCursor;
            final Lock lock = txn.doLockUpgradableNoPush(tc.mTree.mId, ce.mKey);
            this.runCursorTask(ce, te, new Worker.Task(){

                @Override
                public void run() throws IOException {
                    try {
                        if (lock != null) {
                            txn.push(lock);
                        }
                        BTreeCursor tc = ce.mCursor;
                        tc.mTxn = txn;
                        while (true) {
                            try {
                                tc.valueWrite(pos, buf, off, len);
                            }
                            catch (ClosedIndexException e) {
                                if ((tc = ReplEngine.this.reopenCursor(e, ce)) != null) continue;
                            }
                            break;
                        }
                    }
                    finally {
                        entry.release();
                    }
                }
            });
            return true;
        }
        catch (Throwable e) {
            entry.release();
            throw e;
        }
    }

    @Override
    public boolean cursorValueClear(long cursorId, long txnId, final long pos, final long length) throws LockFailureException {
        final CursorEntry ce = this.getCursorEntry(cursorId);
        if (ce == null) {
            return true;
        }
        TxnEntry te = this.getTxnEntry(txnId);
        final LocalTransaction txn = te.mTxn;
        BTreeCursor tc = ce.mCursor;
        final Lock lock = txn.doLockUpgradableNoPush(tc.mTree.mId, ce.mKey);
        this.runCursorTask(ce, te, new Worker.Task(){

            @Override
            public void run() throws IOException {
                if (lock != null) {
                    txn.push(lock);
                }
                BTreeCursor tc = ce.mCursor;
                tc.mTxn = txn;
                while (true) {
                    try {
                        tc.valueClear(pos, length);
                    }
                    catch (ClosedIndexException e) {
                        if ((tc = ReplEngine.this.reopenCursor(e, ce)) != null) continue;
                    }
                    break;
                }
            }
        });
        return true;
    }

    private void runCursorTask(CursorEntry ce, TxnEntry te, Worker.Task task) {
        Worker w = ce.mWorker;
        if (w == null) {
            w = te.mWorker;
            if (w == null) {
                te.mWorker = w = this.runTaskAnywhere(task);
            } else {
                w.enqueue(task);
            }
            ce.mWorker = w;
        } else {
            Worker txnWorker = te.mWorker;
            if (w != txnWorker) {
                if (txnWorker == null) {
                    txnWorker = w;
                    te.mWorker = w;
                } else {
                    w.join(false);
                    ce.mWorker = txnWorker;
                }
            }
            txnWorker.enqueue(task);
        }
    }

    @Override
    public boolean txnLockShared(long txnId, long indexId, byte[] key) throws LockFailureException {
        TxnEntry te = this.getTxnEntry(txnId);
        this.runLockPushTask(te, te.mTxn.doLockSharedNoPush(indexId, key));
        return true;
    }

    @Override
    public boolean txnLockUpgradable(long txnId, long indexId, byte[] key) throws LockFailureException {
        TxnEntry te = this.getTxnEntry(txnId);
        this.runLockPushTask(te, te.mTxn.doLockUpgradableNoPush(indexId, key));
        return true;
    }

    private void runLockPushTask(TxnEntry te, final Lock lock) {
        if (lock != null) {
            final LocalTransaction txn = te.mTxn;
            Worker w = te.mWorker;
            if (w == null) {
                txn.push(lock);
            } else {
                w.enqueue(new Worker.Task(){

                    @Override
                    public void run() {
                        txn.push(lock);
                    }
                });
            }
        }
    }

    @Override
    public boolean txnLockExclusive(long txnId, final long indexId, final byte[] key) throws LockFailureException {
        TxnEntry te = this.getTxnEntry(txnId);
        final LocalTransaction txn = te.mTxn;
        final Lock lock = txn.doLockUpgradableNoPush(indexId, key);
        this.runTask(te, new Worker.Task(){

            @Override
            public void run() throws IOException {
                if (lock != null) {
                    txn.push(lock);
                }
                txn.lockExclusive(indexId, key, -1L);
            }
        });
        return true;
    }

    @Override
    public boolean txnPrepare(long txnId, long prepareTxnId, final int handlerId, final byte[] message, final boolean commit) throws IOException {
        TxnEntry te = this.getTxnEntry(prepareTxnId);
        final LocalTransaction txn = te.mTxn;
        this.runTask(te, new Worker.Task(){

            @Override
            public void run() throws IOException {
                txn.prepareRedo(handlerId, message, commit);
            }
        });
        return true;
    }

    @Override
    public boolean txnPrepareRollback(long txnId, final long prepareTxnId) throws IOException {
        TxnEntry te = this.getTxnEntry(prepareTxnId);
        this.runTask(te, new Worker.Task(){

            @Override
            public void run() throws IOException {
                BTree preparedTxns = ReplEngine.this.mDatabase.tryPreparedTxns();
                if (preparedTxns != null) {
                    byte[] prepareKey = new byte[8];
                    Utils.encodeLongBE(prepareKey, 0, prepareTxnId);
                    preparedTxns.store(Transaction.BOGUS, prepareKey, null);
                }
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean txnCommitFinalNotifySchema(long txnId, long indexId) throws IOException {
        this.txnCommitFinal(txnId);
        if (this.mWorkerGroup != null) {
            this.mWorkerGroup.join(false);
        }
        this.mDecodeLatched = true;
        try {
            this.mDatabase.rowStore().notifySchema(indexId);
        }
        finally {
            this.mDecodeLatched = false;
        }
        return true;
    }

    @Override
    public boolean txnPredicateMode(long txnId) {
        this.getTxnEntry((long)txnId).mPredicateMode = true;
        return true;
    }

    @Override
    public boolean txnCustom(long txnId, int handlerId, final byte[] message) throws IOException {
        final CustomHandler handler = this.mDatabase.findCustomRecoveryHandler(handlerId);
        TxnEntry te = this.getTxnEntry(txnId);
        final LocalTransaction txn = te.mTxn;
        this.runTask(te, new Worker.Task(){

            @Override
            public void run() throws IOException {
                handler.redo(txn, message);
            }
        });
        return true;
    }

    @Override
    public boolean txnCustomLock(long txnId, int handlerId, final byte[] message, final long indexId, final byte[] key) throws IOException {
        final CustomHandler handler = this.mDatabase.findCustomRecoveryHandler(handlerId);
        TxnEntry te = this.getTxnEntry(txnId);
        final LocalTransaction txn = te.mTxn;
        final Lock lock = txn.doLockUpgradableNoPush(indexId, key);
        this.runTask(te, new Worker.Task(){

            @Override
            public void run() throws IOException {
                if (lock != null) {
                    txn.push(lock);
                }
                txn.doLockExclusive(indexId, key, -1L);
                handler.redo(txn, message, indexId, key);
            }
        });
        return true;
    }

    long decodePosition() {
        return this.decoder().decodePositionOpaque();
    }

    private RedoDecoder decoder() {
        ReplDecoder decoder = this.mDecoder;
        if (decoder == null) {
            throw new IllegalStateException("No decoder");
        }
        return decoder;
    }

    long suspendedDecodePosition() {
        return this.decoder().mDecodePosition;
    }

    long suspendedDecodeTransactionId() {
        ReplDecoder decoder = this.mDecoder;
        if (decoder != null) {
            return decoder.mDecodeTransactionId;
        }
        throw new IllegalStateException("Not decoding");
    }

    void suspend() throws IOException {
        try {
            this.mDecodeLatch.acquireExclusiveInterruptibly();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        try {
            Throwable ex;
            if (this.mWorkerGroup != null) {
                this.mWorkerGroup.join(false);
            }
            if ((ex = this.mDecodeException) != null) {
                throw new IOException("Cannot advance decode position", ex);
            }
        }
        catch (Throwable e) {
            this.mDecodeLatch.releaseExclusive();
            throw e;
        }
    }

    void resume() {
        this.mDecodeLatch.releaseExclusive();
    }

    void interrupt() {
        if (this.mWorkerGroup != null) {
            this.mWorkerGroup.interrupt();
        }
        this.mFinisher.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stashForRecovery(LocalTransaction txn) {
        long scrambledTxnId = Utils.fibHash(txn.id());
        this.mDecodeLatch.acquireExclusive();
        try {
            ((TxnEntry)this.mTransactions.insert((long)scrambledTxnId)).mTxn = txn;
            if (this.mStashedCond != null) {
                this.mStashedCond.signal(this.mDecodeLatch);
            }
        }
        finally {
            this.mDecodeLatch.releaseExclusive();
        }
    }

    void awaitPreparedTransactions() throws IOException {
        long nanosTimeout = 1000000000L;
        boolean report = false;
        while (!this.awaitPreparedTransactions(nanosTimeout, report) && !this.mDatabase.isClosed()) {
            nanosTimeout = Math.min(nanosTimeout << 1, 60000000000L);
            report = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean awaitPreparedTransactions(long nanosTimeout, boolean report) throws IOException {
        BTree preparedTxns = this.mDatabase.tryPreparedTxns();
        if (preparedTxns == null) {
            return true;
        }
        long nanosEnd = System.nanoTime() + nanosTimeout;
        while (true) {
            int result;
            boolean finished = true;
            try (BTreeCursor c = new BTreeCursor(preparedTxns);){
                c.mTxn = LocalTransaction.BOGUS;
                c.autoload(false);
                byte[] key = c.firstKey();
                while (key != null) {
                    block28: {
                        EventListener listener;
                        long txnId;
                        block27: {
                            TxnEntry te;
                            txnId = Utils.decodeLongBE(key, 0);
                            long scrambledTxnId = Utils.fibHash(txnId);
                            this.mDecodeLatch.acquireExclusive();
                            try {
                                te = (TxnEntry)this.mTransactions.get(scrambledTxnId);
                                if (te == null && this.mStashedCond == null) {
                                    this.mStashedCond = new LatchCondition();
                                }
                            }
                            finally {
                                this.mDecodeLatch.releaseExclusive();
                            }
                            if (te != null) break block27;
                            finished = false;
                            if (!report) break block28;
                        }
                        if ((listener = this.mDatabase.eventListener()) != null) {
                            listener.notify(EventType.RECOVERY_AWAIT_RELEASE, "Prepared transaction must be reset: %1$d", txnId);
                        }
                    }
                    key = c.nextKey();
                }
            }
            this.mDecodeLatch.acquireExclusive();
            try {
                if (finished) {
                    this.mStashedCond = null;
                    boolean bl = true;
                    return bl;
                }
                result = this.mStashedCond.await(this.mDecodeLatch, nanosTimeout, nanosEnd);
            }
            finally {
                this.mDecodeLatch.releaseExclusive();
            }
            if (result <= 0) {
                if (result == 0) {
                    return false;
                }
                throw new InterruptedIOException();
            }
            nanosTimeout = Math.max(nanosEnd - System.nanoTime(), 0L);
            report = false;
        }
    }

    private TxnEntry getTxnEntry(long txnId) {
        long scrambledTxnId = Utils.fibHash(txnId);
        TxnEntry te = (TxnEntry)this.mTransactions.get(scrambledTxnId);
        if (te == null) {
            LocalTransaction txn = this.newTransaction(txnId);
            te = (TxnEntry)this.mTransactions.insert(scrambledTxnId);
            te.mTxn = txn;
        }
        return te;
    }

    private void runTask(TxnEntry te, Worker.Task task) {
        Worker w = te.mWorker;
        if (w == null) {
            te.mWorker = this.runTaskAnywhere(task);
        } else {
            w.enqueue(task);
        }
    }

    private Worker runTaskAnywhere(Worker.Task task) {
        if (this.mWorkerGroup == null) {
            try {
                task.run();
            }
            catch (Throwable e) {
                Utils.uncaught(e);
            }
            return null;
        }
        return this.mWorkerGroup.enqueue(task);
    }

    protected LocalTransaction newTransaction(long txnId) {
        LocalTransaction txn = new LocalTransaction(this.mDatabase, txnId, LockMode.UPGRADABLE_READ, -1L);
        txn.attach(ATTACHMENT);
        return txn;
    }

    protected Object attachment() {
        return ATTACHMENT;
    }

    private TxnEntry removeTxnEntry(long txnId) {
        long scrambledTxnId = Utils.fibHash(txnId);
        return (TxnEntry)this.mTransactions.remove(scrambledTxnId);
    }

    private void pushPredicateLocks(LocalTransaction txn, Object locks) {
        if (locks != null) {
            if (locks instanceof Lock) {
                Lock lock = (Lock)locks;
                txn.push(lock);
            } else {
                this.pushPredicateLockArray(txn, locks);
            }
        }
    }

    private void pushPredicateLockArray(LocalTransaction txn, Object locks) {
        for (Lock lock : (Lock[])locks) {
            if (lock == null) break;
            txn.push(lock);
        }
    }

    private Index getIndex(Transaction txn, long indexId) throws IOException {
        Index ix;
        SoftReference ref;
        LHashTable.ObjEntry entry = (LHashTable.ObjEntry)this.mIndexes.get(indexId);
        if (entry != null && (ref = (SoftReference)entry.value) != null && (ix = (Index)ref.get()) != null) {
            return ix;
        }
        return this.openIndex(txn, indexId, entry);
    }

    private Index getIndex(long indexId) throws IOException {
        return this.getIndex(null, indexId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Index openIndex(Transaction txn, long indexId, Object cleanup) throws IOException {
        Index ix = this.mDatabase.anyIndexById(txn, indexId);
        if (ix == null) {
            return null;
        }
        SoftReference<Index> ref = new SoftReference<Index>(ix);
        LHashTable.Obj<SoftReference<Index>> obj = this.mIndexes;
        synchronized (obj) {
            ((LHashTable.ObjEntry)this.mIndexes.insert((long)indexId)).value = ref;
            if (cleanup != null) {
                this.mIndexes.traverse(e -> ((SoftReference)e.value).get() == null);
            }
        }
        return ix;
    }

    private Index openIndex(long indexId) throws IOException {
        return this.openIndex(null, indexId, null);
    }

    private Index reopenIndex(Throwable e, long indexId) throws IOException {
        ReplEngine.checkClosedIndex(e);
        return this.openIndex(indexId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(BTreeCursor tc) throws IOException {
        BTree cursorRegistry = this.mDatabase.cursorRegistry();
        CommitLock.Shared shared = this.mDatabase.commitLock().acquireShared();
        try {
            this.mDatabase.registerCursor(cursorRegistry, tc);
        }
        finally {
            shared.release();
        }
    }

    private BTreeCursor findAndRegister(CursorEntry ce, LocalTransaction txn, byte[] key) throws IOException {
        BTreeCursor tc = ce.mCursor;
        while (true) {
            try {
                tc.mTxn = txn;
                tc.findNearby(key);
                this.register(tc);
            }
            catch (ClosedIndexException e) {
                tc.mKey = key;
                if ((tc = this.reopenCursor(e, ce)) != null) continue;
            }
            break;
        }
        return tc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CursorEntry getCursorEntry(long cursorId) {
        long scrambledCursorId = Utils.fibHash(cursorId);
        CursorEntry ce = (CursorEntry)this.mCursors.get(scrambledCursorId);
        if (ce == null) {
            CursorTable cursorTable = this.mCursors;
            synchronized (cursorTable) {
                ce = (CursorEntry)this.mCursors.get(scrambledCursorId);
            }
        }
        return ce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BTreeCursor reopenCursor(Throwable e, CursorEntry ce) throws IOException {
        ReplEngine.checkClosedIndex(e);
        BTreeCursor tc = ce.mCursor;
        Index ix = this.openIndex(tc.mTree.mId);
        if (ix == null) {
            CursorTable cursorTable = this.mCursors;
            synchronized (cursorTable) {
                this.mCursors.remove(ce.key);
            }
        }
        long cursorId = tc.mCursorId;
        LocalTransaction txn = tc.mTxn;
        byte[] key = tc.key();
        this.reset(tc);
        tc = (BTreeCursor)ix.newCursor(txn);
        tc.mKeyOnly = true;
        tc.mTxn = txn;
        tc.mCursorId = cursorId;
        tc.findNearby(key);
        CursorTable cursorTable = this.mCursors;
        synchronized (cursorTable) {
            if (ce == this.mCursors.get(ce.key)) {
                ce.mCursor = tc;
                return tc;
            }
        }
        this.reset(tc);
        return null;
    }

    private static void checkClosedIndex(Throwable e) {
        Throwable cause = e;
        while (!(cause instanceof ClosedIndexException)) {
            if ((cause = cause.getCause()) != null) continue;
            Utils.rethrow(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decode() {
        LHashTable.Obj<LocalTransaction> remaining;
        ReplDecoder decoder = this.mDecoder;
        try {
            while (!decoder.run(this)) {
            }
            this.mDecodeLatch.acquireExclusive();
            try {
                if (this.mWorkerGroup != null) {
                    this.mWorkerGroup.join(false);
                }
                remaining = this.doReset(false);
            }
            finally {
                this.mDecodeLatch.releaseExclusive();
            }
        }
        catch (Throwable e) {
            this.fail(e);
            return;
        }
        finally {
            decoder.mDeactivated = true;
            LHashTable.Obj<SoftReference<Index>> obj = this.mIndexes;
            synchronized (obj) {
                this.mIndexes.clear(0);
            }
        }
        StreamReplicator.Writer writer = decoder.extractWriter();
        if (writer == null) {
            this.fail(new IllegalStateException("No writer for the leader"));
            return;
        }
        ReplWriter redo = null;
        try {
            redo = this.mController.leaderNotify(writer);
        }
        catch (UnmodifiableReplicaException unmodifiableReplicaException) {
        }
        catch (Throwable e) {
            Utils.closeQuietly(this.mDatabase, e);
            return;
        }
        if (remaining != null) {
            if (redo != null) {
                ReplWriter fredo = redo;
                Runner.start(() -> this.mDatabase.invokeRecoveryHandler(remaining, fredo));
            } else {
                this.mDatabase.invokeRecoveryHandler(remaining, null);
                remaining.traverse(entry -> {
                    this.stashForRecovery((LocalTransaction)entry.value);
                    return true;
                });
            }
        }
    }

    void fail(Throwable e) {
        this.fail(e, false);
    }

    void fail(Throwable e, boolean isUncaught) {
        cDecodeExceptionHandle.compareAndSet(this, null, e);
        if (!this.mDatabase.isClosed()) {
            EventListener listener = this.mDatabase.eventListener();
            if (listener != null) {
                listener.notify(EventType.REPLICATION_PANIC, "Unexpected replication exception: %1$s", Utils.rootCause(e));
            } else if (isUncaught) {
                Thread t = Thread.currentThread();
                t.getThreadGroup().uncaughtException(t, e);
            } else {
                Utils.uncaught(e);
            }
        }
        Utils.closeQuietly(this.mDatabase, e);
    }

    private void reset(BTreeCursor cursor) {
        long cursorId = cursor.mCursorId;
        cursor.mCursorId = 0L;
        cursor.reset();
        if (cursorId != 0L) {
            this.mDatabase.unregisterCursor(cursorId);
        }
    }

    static {
        try {
            cDecodeExceptionHandle = MethodHandles.lookup().findVarHandle(ReplEngine.class, "mDecodeException", Throwable.class);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
        cStoreListenerCallSite = new MutableCallSite(ReplEngine.emptyStoreListener());
        cStoreListenerHandle = cStoreListenerCallSite.dynamicInvoker();
    }

    static final class TxnTable
    extends LHashTable<TxnEntry> {
        TxnTable(int capacity) {
            super(capacity);
        }

        @Override
        protected TxnEntry newEntry() {
            return new TxnEntry();
        }
    }

    static final class CursorTable
    extends LHashTable<CursorEntry> {
        CursorTable(int capacity) {
            super(capacity);
        }

        @Override
        protected CursorEntry newEntry() {
            return new CursorEntry();
        }
    }

    static final class TxnEntry
    extends LHashTable.Entry<TxnEntry> {
        LocalTransaction mTxn;
        Worker mWorker;
        boolean mPredicateMode;

        TxnEntry() {
        }
    }

    static final class CursorEntry
    extends LHashTable.Entry<CursorEntry> {
        BTreeCursor mCursor;
        Worker mWorker;
        byte[] mKey;

        CursorEntry() {
        }

        void recovered(BTreeCursor c) {
            this.mCursor = c;
            this.mKey = c.key();
        }
    }
}

