/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.io.InputStream;

final class RestoreInputStream
extends InputStream {
    private final InputStream mSource;
    private volatile long mReceived;
    private volatile boolean mFinished;

    RestoreInputStream(InputStream source) {
        this.mSource = source;
    }

    public long received() {
        return this.mReceived;
    }

    public boolean isFinished() {
        return this.mFinished;
    }

    @Override
    public int read() throws IOException {
        int b = this.mSource.read();
        if (b < 0) {
            this.mFinished = true;
        } else {
            ++this.mReceived;
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int amt = this.mSource.read(b, off, len);
        if (amt < 0) {
            this.mFinished = true;
        } else {
            this.mReceived += (long)amt;
        }
        return amt;
    }

    @Override
    public long skip(long n) throws IOException {
        if ((n = this.mSource.skip(n)) < 0L) {
            this.mFinished = true;
        } else {
            this.mReceived += n;
        }
        return n;
    }

    @Override
    public int available() throws IOException {
        return this.mSource.available();
    }

    @Override
    public void close() throws IOException {
        this.mFinished = true;
        this.mSource.close();
    }
}

