/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.util.PriorityQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import org.cojen.tupl.core.Delayed;

public final class Scheduler {
    private final ExecutorService mExecutor;
    private final PriorityQueue<Delayed> mDelayed;
    private boolean mRunning;
    private static Scheduler cDaemon;

    public static synchronized Scheduler daemon() {
        if (cDaemon == null) {
            cDaemon = new Scheduler(Executors.newCachedThreadPool(r -> {
                Thread t = new Thread(r);
                t.setDaemon(true);
                return t;
            }));
        }
        return cDaemon;
    }

    public Scheduler() {
        this(Executors.newCachedThreadPool());
    }

    public Scheduler(ExecutorService executor) {
        if (executor == null) {
            throw new IllegalArgumentException();
        }
        this.mExecutor = executor;
        this.mDelayed = new PriorityQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.mExecutor.shutdown();
        Scheduler scheduler = this;
        synchronized (scheduler) {
            this.mDelayed.clear();
            this.notify();
        }
    }

    public boolean isShutdown() {
        return this.mExecutor.isShutdown();
    }

    public boolean execute(Runnable task) {
        try {
            this.mExecutor.execute(task);
        }
        catch (RejectedExecutionException e) {
            if (this.isShutdown()) {
                return false;
            }
            this.scheduleMillis(task, 1L);
        }
        return true;
    }

    public boolean scheduleMillis(Runnable task, long delayMillis) {
        return this.scheduleNanos(task, delayMillis * 1000000L);
    }

    public boolean scheduleNanos(Runnable task, long delayNanos) {
        return this.scheduleNanos(new Delayed.Runner(System.nanoTime() + delayNanos, task));
    }

    public synchronized boolean scheduleNanos(Delayed delayed) {
        this.mDelayed.add(delayed);
        if (!this.mRunning) {
            if (!this.doExecute(this::runDelayedTasks)) {
                return false;
            }
            this.mRunning = true;
        } else if (this.mDelayed.peek() == delayed) {
            this.notify();
        }
        return true;
    }

    private boolean doExecute(Runnable task) {
        while (true) {
            try {
                this.mExecutor.execute(task);
                return true;
            }
            catch (RejectedExecutionException e) {
                if (this.isShutdown()) {
                    return false;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runDelayedTasks() {
        while (true) {
            block13: {
                var2_2 = this;
                synchronized (var2_2) {
                    while (true) lbl-1000:
                    // 3 sources

                    {
                        if ((delayed = this.mDelayed.peek()) == null) {
                            this.mRunning = false;
                            return;
                        }
                        delayNanos = delayed.mCounter - System.nanoTime();
                        if (delayNanos <= 0L) {
                            if (delayed != this.mDelayed.remove()) {
                                ** break;
                            }
                            break block13;
                        }
                        try {
                            this.wait((delayNanos + 999999L) / 1000000L);
                        }
                        catch (InterruptedException e) {
                            if (this.isShutdown()) ** break;
                            continue;
                            this.mRunning = false;
                            return;
                        }
                        break;
                    }
                    ** GOTO lbl-1000
lbl22:
                    // 1 sources

                    this.mRunning = false;
                    throw new AssertionError();
                }
            }
            try {
                this.doExecute(delayed);
            }
            catch (Throwable e) {
                var3_5 = this;
                synchronized (var3_5) {
                    this.mRunning = false;
                    throw e;
                }
            }
        }
    }
}

