/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import org.cojen.tupl.core.Utils;
import org.cojen.tupl.util.Latch;
import org.cojen.tupl.util.Parker;

final class Sequencer
extends Latch {
    private Waiter[] mWaiters;
    private int mWaitersSize;
    private long mValue;

    public Sequencer(long initial, int numWaiters) {
        if (initial == Long.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.mWaiters = new Waiter[Utils.roundUpPower2(numWaiters)];
        this.mValue = initial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(long value, Waiter waiter) throws InterruptedException {
        boolean registered = false;
        do {
            this.acquireExclusive();
            try {
                if (this.mValue == Long.MAX_VALUE) {
                    boolean bl = false;
                    return bl;
                }
                if (this.mValue == value) {
                    boolean bl = true;
                    return bl;
                }
                if (this.mValue > value) {
                    throw new IllegalStateException();
                }
                if (!registered) {
                    if (waiter == null) {
                        waiter = new Waiter();
                    }
                    Waiter[] waiters = this.mWaiters;
                    int index = (int)value & waiters.length - 1;
                    Waiter w = waiters[index];
                    while (w != null) {
                        if (w.mValue == value) {
                            throw new IllegalStateException();
                        }
                        w = w.mNext;
                    }
                    if (this.mWaitersSize > waiters.length) {
                        this.grow();
                        waiters = this.mWaiters;
                        index = (int)value & waiters.length - 1;
                    }
                    waiter.mValue = value;
                    waiter.mNext = waiters[index];
                    waiters[index] = waiter;
                    ++this.mWaitersSize;
                    registered = true;
                }
            }
            finally {
                this.releaseExclusive();
            }
            Parker.parkNow(this);
        } while (!Thread.interrupted());
        throw new InterruptedException();
    }

    private void grow() {
        Waiter[] waiters = this.mWaiters;
        int capacity = waiters.length << 1;
        Waiter[] newWaiters = new Waiter[capacity];
        int newMask = capacity - 1;
        int i = waiters.length;
        while (--i >= 0) {
            Waiter w = waiters[i];
            while (w != null) {
                Waiter next = w.mNext;
                int ix = (int)w.mValue & newMask;
                w.mNext = newWaiters[ix];
                newWaiters[ix] = w;
                w = next;
            }
        }
        this.mWaiters = newWaiters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean signal(long value) {
        Waiter w;
        block11: {
            this.acquireExclusive();
            try {
                if (value <= this.mValue) {
                    if (this.mValue == Long.MAX_VALUE) {
                        boolean bl = false;
                        return bl;
                    }
                    throw new IllegalStateException();
                }
                this.mValue = value;
                Waiter[] waiters = this.mWaiters;
                int index = (int)value & waiters.length - 1;
                Waiter prev = null;
                w = waiters[index];
                while (w != null) {
                    if (w.mValue == value) {
                        if (prev == null) {
                            waiters[index] = w.mNext;
                        } else {
                            prev.mNext = w.mNext;
                        }
                        --this.mWaitersSize;
                        break block11;
                    }
                    prev = w;
                    w = w.mNext;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.releaseExclusive();
            }
        }
        Parker.unpark(w.mThread);
        w.mNext = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        this.acquireExclusive();
        try {
            this.mValue = Long.MAX_VALUE;
            Waiter[] waiters = this.mWaiters;
            for (int i = 0; i < waiters.length; ++i) {
                Waiter w = waiters[i];
                while (w != null) {
                    Parker.unpark(w.mThread);
                    Waiter next = w.mNext;
                    w.mNext = null;
                    w = next;
                }
                waiters[i] = null;
            }
            this.mWaitersSize = 0;
        }
        finally {
            this.releaseExclusive();
        }
    }

    public static class Waiter {
        private final Thread mThread = Thread.currentThread();
        private long mValue;
        private Waiter mNext;
    }
}

