/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.cojen.tupl.core.CoreDatabase;
import org.cojen.tupl.core.CoreServer;

final class Servers
implements Closeable {
    private Object mServers;
    private volatile CoreServer mReplServer;
    private boolean mClosed;

    Servers() {
    }

    CoreServer newServer(CoreDatabase db) throws IOException {
        return new CoreServer(db, this);
    }

    CoreServer replServer(CoreDatabase db) throws IOException {
        CoreServer server = this.mReplServer;
        return server != null ? server : this.openReplServer(db);
    }

    private synchronized CoreServer openReplServer(CoreDatabase db) throws IOException {
        CoreServer server = this.mReplServer;
        if (server == null) {
            this.mReplServer = server = new CoreServer(db, this);
        }
        return server;
    }

    @Override
    public synchronized void close() {
        this.mClosed = true;
        if (this.mServers != null) {
            Iterator iterator = this.mServers;
            if (iterator instanceof Set) {
                Set set = (Set)((Object)iterator);
                for (Object server : set) {
                    ((CoreServer)server).close();
                }
            } else {
                ((CoreServer)this.mServers).close();
            }
            this.mServers = null;
        }
    }

    synchronized void add(CoreServer server) {
        if (this.mClosed) {
            server.close();
        } else if (this.mServers == null) {
            this.mServers = server;
        } else {
            Object object = this.mServers;
            if (object instanceof Set) {
                Set set = (Set)object;
                set.add(server);
            } else {
                HashSet<Object> set = new HashSet<Object>(4);
                set.add(this.mServers);
                set.add(server);
                this.mServers = server;
            }
        }
    }

    synchronized void remove(CoreServer server) {
        Object object = this.mServers;
        if (object instanceof Set) {
            Set set = (Set)object;
            if (set.remove(server) && set.isEmpty()) {
                this.mServers = null;
            }
        } else if (this.mServers == server) {
            this.mServers = null;
        }
    }
}

