/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.Snapshot;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.core.BTree;
import org.cojen.tupl.core.BTreeCursor;
import org.cojen.tupl.core.DirectPageOps;
import org.cojen.tupl.core.Launcher;
import org.cojen.tupl.core.LocalDatabase;
import org.cojen.tupl.core.LocalTransaction;
import org.cojen.tupl.core.Node;
import org.cojen.tupl.core.PageOps;
import org.cojen.tupl.core.ReadableSnapshot;
import org.cojen.tupl.core.Sequencer;
import org.cojen.tupl.core.TempFileManager;
import org.cojen.tupl.core.TransformedPageArray;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.io.CauseCloseable;
import org.cojen.tupl.io.PageArray;
import org.cojen.tupl.util.Latch;
import org.cojen.tupl.util.Runner;

final class SnapshotPageArray
extends PageArray {
    final PageArray mSource;
    private volatile SnapshotImpl[] mSnapshots;

    SnapshotPageArray(PageArray source) {
        super(source.pageSize());
        this.mSource = source;
    }

    @Override
    public int directPageSize() {
        return this.mSource.directPageSize();
    }

    @Override
    public boolean isReadOnly() {
        return this.mSource.isReadOnly();
    }

    @Override
    public boolean isFullyMapped() {
        return this.mSource.isFullyMapped();
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.mSource.isEmpty();
    }

    @Override
    public long pageCount() throws IOException {
        return this.mSource.pageCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncatePageCount(long count) throws IOException {
        SnapshotPageArray snapshotPageArray = this;
        synchronized (snapshotPageArray) {
            if (this.mSnapshots == null) {
                this.mSource.truncatePageCount(count);
                return;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void expandPageCount(long count) throws IOException {
        this.mSource.expandPageCount(count);
    }

    @Override
    public long pageCountLimit() throws IOException {
        return this.mSource.pageCountLimit();
    }

    @Override
    public void readPage(long index, byte[] dst, int offset, int length) throws IOException {
        this.mSource.readPage(index, dst, offset, length);
    }

    @Override
    public void readPage(long index, long dstPtr, int offset, int length) throws IOException {
        this.mSource.readPage(index, dstPtr, offset, length);
    }

    @Override
    public void writePage(long index, byte[] src, int offset) throws IOException {
        this.preWritePage(index);
        this.mSource.writePage(index, src, offset);
    }

    @Override
    public void writePage(long index, byte[] src, int offset, ByteBuffer tail) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writePage(long index, long srcPtr, int offset) throws IOException {
        this.preWritePage(index);
        this.mSource.writePage(index, srcPtr, offset);
    }

    @Override
    public byte[] evictPage(long index, byte[] buf) throws IOException {
        this.preWritePage(index);
        return this.mSource.evictPage(index, buf);
    }

    @Override
    public long evictPage(long index, long bufPtr) throws IOException {
        this.preWritePage(index);
        return this.mSource.evictPage(index, bufPtr);
    }

    private void preWritePage(long index) throws IOException {
        if (index < 0L) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        SnapshotImpl[] snapshots = this.mSnapshots;
        if (snapshots != null) {
            for (SnapshotImpl snapshot : snapshots) {
                snapshot.capture(index);
            }
        }
    }

    @Override
    public long directPagePointer(long index) throws IOException {
        return this.mSource.directPagePointer(index);
    }

    @Override
    public long dirtyPage(long index) throws IOException {
        this.preCopyPage(index);
        return this.mSource.dirtyPage(index);
    }

    @Override
    public long copyPage(long srcIndex, long dstIndex) throws IOException {
        this.preCopyPage(dstIndex);
        return this.mSource.copyPage(srcIndex, dstIndex);
    }

    @Override
    public long copyPageFromPointer(long srcPointer, long dstIndex) throws IOException {
        this.preCopyPage(dstIndex);
        return this.mSource.copyPageFromPointer(srcPointer, dstIndex);
    }

    private void preCopyPage(long dstIndex) throws IOException {
        if (dstIndex < 0L) {
            throw new IndexOutOfBoundsException(String.valueOf(dstIndex));
        }
        SnapshotImpl[] snapshots = this.mSnapshots;
        if (snapshots != null) {
            for (SnapshotImpl snapshot : snapshots) {
                snapshot.capture(dstIndex);
            }
        }
    }

    @Override
    public void sync(boolean metadata) throws IOException {
        this.mSource.sync(metadata);
    }

    @Override
    public void syncPage(long index) throws IOException {
        this.mSource.syncPage(index);
    }

    @Override
    public void close(Throwable cause) throws IOException {
        this.mSource.close(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Snapshot beginSnapshot(LocalDatabase db, long pageCount, long redoPos) throws IOException {
        pageCount = Math.min(pageCount, this.pageCount());
        LocalDatabase nodeCache = db;
        PageArray rawSource = TransformedPageArray.rawSource(this.mSource);
        if (rawSource != this.mSource) {
            nodeCache = null;
        }
        TempFileManager tfm = db.mTempFileManager;
        SnapshotImpl snapshot = new SnapshotImpl(tfm, pageCount, redoPos, nodeCache, rawSource);
        SnapshotPageArray snapshotPageArray = this;
        synchronized (snapshotPageArray) {
            SnapshotImpl[] snapshots = this.mSnapshots;
            if (snapshots == null) {
                this.mSnapshots = new SnapshotImpl[]{snapshot};
            } else {
                SnapshotImpl[] newSnapshots = new SnapshotImpl[snapshots.length + 1];
                System.arraycopy(snapshots, 0, newSnapshots, 0, snapshots.length);
                newSnapshots[newSnapshots.length - 1] = snapshot;
                this.mSnapshots = newSnapshots;
            }
        }
        return snapshot;
    }

    synchronized void unregister(SnapshotImpl snapshot) {
        int pos;
        SnapshotImpl[] snapshots;
        block5: {
            snapshots = this.mSnapshots;
            if (snapshots == null) {
                return;
            }
            for (pos = 0; pos < snapshots.length; ++pos) {
                if (snapshots[pos] != snapshot) {
                    continue;
                }
                break block5;
            }
            return;
        }
        if (snapshots.length <= 1) {
            this.mSnapshots = null;
        } else {
            SnapshotImpl[] newSnapshots = new SnapshotImpl[snapshots.length - 1];
            System.arraycopy(snapshots, 0, newSnapshots, 0, pos);
            System.arraycopy(snapshots, pos + 1, newSnapshots, pos, newSnapshots.length - pos);
            this.mSnapshots = newSnapshots;
        }
    }

    class SnapshotImpl
    implements CauseCloseable,
    ReadableSnapshot {
        private final LocalDatabase mNodeCache;
        private final PageArray mRawPageArray;
        private final TempFileManager mTempFileManager;
        private final long mSnapshotPageCount;
        private final long mSnapshotRedoPosition;
        private final Copier[] mCopiers;
        private final Sequencer mSequencer;
        private final BTree mPageCopyIndex;
        private final File mTempFile;
        private OutputStream mOut;
        private volatile Object mClosed;

        SnapshotImpl(TempFileManager tfm, long pageCount, long redoPos, LocalDatabase nodeCache, PageArray rawPageArray) throws IOException {
            this.mNodeCache = nodeCache;
            this.mRawPageArray = rawPageArray;
            this.mTempFileManager = tfm;
            this.mSnapshotPageCount = pageCount;
            this.mSnapshotRedoPosition = redoPos;
            int numCopiers = Utils.roundUpPower2(Runtime.getRuntime().availableProcessors() * 2);
            this.mCopiers = new Copier[numCopiers];
            this.mSequencer = new Sequencer(0L, numCopiers);
            Launcher launcher = new Launcher();
            int pageSize = this.pageSize();
            launcher.pageSize(pageSize);
            launcher.minCacheSize((long)pageSize * Math.max(100L, (long)numCopiers * 16L));
            if (nodeCache != null) {
                launcher.directPageAccess(nodeCache.isDirectPageAccess());
            }
            this.mPageCopyIndex = LocalDatabase.openTemp(tfm, launcher);
            this.mTempFile = launcher.mBaseFile;
            for (int i = 0; i < this.mCopiers.length; ++i) {
                this.mCopiers[i] = new Copier(this, i, numCopiers);
            }
        }

        @Override
        public long length() {
            return this.mSnapshotPageCount * (long)this.pageSize();
        }

        @Override
        public long position() {
            return this.mSnapshotRedoPosition;
        }

        @Override
        public boolean isCompressible() {
            return this.mNodeCache != null;
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            this.mSequencer.acquireExclusive();
            try {
                this.checkClosed();
                if (this.mOut != null) {
                    throw new IllegalStateException("Snapshot already started");
                }
                this.mOut = out;
            }
            finally {
                this.mSequencer.releaseExclusive();
            }
            try {
                Future[] tasks = new Future[this.mCopiers.length - 1];
                for (int i = 0; i < tasks.length; ++i) {
                    tasks[i] = Runner.current().submit(this.mCopiers[i]);
                }
                this.mCopiers[this.mCopiers.length - 1].run();
                for (Future task : tasks) {
                    task.get();
                }
            }
            catch (Exception e) {
                this.close(Utils.rootCause(e));
            }
            this.checkClosed();
            this.close();
        }

        void capture(long index) {
            if (index < this.mSnapshotPageCount) {
                this.mCopiers[(int)(index & (long)(this.mCopiers.length - 1))].capture(index);
            }
        }

        boolean writePage(Sequencer.Waiter waiter, long pageId, byte[] page) throws IOException {
            try {
                if (this.mSequencer.await(pageId, waiter)) {
                    this.mOut.write(page);
                    this.mSequencer.signal(pageId + 1L);
                    return true;
                }
                return false;
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        }

        @Override
        public void close() {
            this.close(null);
        }

        @Override
        public void close(Throwable cause) {
            this.mSequencer.acquireExclusive();
            try {
                if (this.mClosed == null) {
                    this.mClosed = cause == null ? this : cause;
                }
            }
            finally {
                this.mSequencer.releaseExclusive();
            }
            for (Copier copier : this.mCopiers) {
                copier.close();
            }
            this.mSequencer.abort();
            SnapshotPageArray.this.unregister(this);
            Utils.closeQuietly(this.mPageCopyIndex.mDatabase);
            this.mTempFileManager.deleteTempFile(this.mTempFile);
        }

        private void checkClosed() throws IOException {
            Object closed = this.mClosed;
            if (closed != null) {
                Throwable cause = null;
                if (closed instanceof Throwable) {
                    Throwable t;
                    cause = t = (Throwable)closed;
                }
                if (cause instanceof InterruptedException || cause instanceof InterruptedIOException) {
                    throw new InterruptedIOException("Snapshot closed");
                }
                throw new IOException("Snapshot closed", cause);
            }
        }

        @Override
        public int pageSize() {
            return this.mRawPageArray.pageSize();
        }

        @Override
        public long pageCount() {
            return this.mSnapshotPageCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void readPage(long index, byte[] dst, int offset, int length) throws IOException {
            LocalTransaction txn = this.mPageCopyIndex.mDatabase.threadLocalTransaction(DurabilityMode.NO_REDO);
            try {
                txn.lockMode(LockMode.REPEATABLE_READ);
                byte[] key = new byte[8];
                Utils.encodeLongBE(key, 0, index);
                byte[] page = this.mPageCopyIndex.load(txn, key);
                if (page != null) {
                    System.arraycopy(page, 0, dst, offset, length);
                } else {
                    this.mRawPageArray.readPage(index, dst, offset, length);
                }
            }
            finally {
                txn.reset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void readPage(long index, long dstPtr, int offset, int length) throws IOException {
            LocalTransaction txn = this.mPageCopyIndex.mDatabase.threadLocalTransaction(DurabilityMode.NO_REDO);
            try {
                txn.lockMode(LockMode.REPEATABLE_READ);
                byte[] key = new byte[8];
                Utils.encodeLongBE(key, 0, index);
                byte[] page = this.mPageCopyIndex.load(txn, key);
                if (page != null) {
                    DirectPageOps.p_copyFromArray(page, 0, dstPtr, offset, length);
                } else {
                    this.mRawPageArray.readPage(index, dstPtr, offset, length);
                }
            }
            finally {
                txn.reset();
            }
        }
    }

    static class Copier
    extends Latch
    implements Runnable {
        private static final VarHandle cProgressHandle;
        private final SnapshotImpl mParent;
        private final long mOffset;
        private final long mStride;
        private final PageArray mRawPageArray;
        private final BTree mPageCopyIndex;
        private final byte[] mCaptureBufferArray;
        private byte[] mCaptureBuffer;
        private volatile long mProgress;

        Copier(SnapshotImpl parent, long offset, long stride) {
            this.mParent = parent;
            this.mOffset = offset;
            this.mStride = stride;
            this.mRawPageArray = parent.mRawPageArray;
            this.mPageCopyIndex = parent.mPageCopyIndex;
            this.mCaptureBufferArray = new byte[this.mRawPageArray.pageSize()];
            this.mCaptureBuffer = PageOps.p_transferPage(this.mCaptureBufferArray, this.mRawPageArray.directPageSize());
            this.mProgress = Long.MIN_VALUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block24: {
                this.acquireExclusive();
                try {
                    long progress = this.mProgress;
                    if (progress == Long.MAX_VALUE) {
                        return;
                    }
                    long init = this.mOffset - this.mStride;
                    if (progress > init) {
                        throw new IllegalStateException("Snapshot already started");
                    }
                    this.mProgress = init;
                }
                finally {
                    this.releaseExclusive();
                }
                Sequencer.Waiter waiter = new Sequencer.Waiter();
                int pageSize = this.mParent.pageSize();
                byte[] pageBufferArray = new byte[pageSize];
                byte[] pageBuffer = PageOps.p_transferPage(pageBufferArray, this.mRawPageArray.directPageSize());
                LocalDatabase cache = this.mParent.mNodeCache;
                long count = this.mParent.mSnapshotPageCount;
                LocalTransaction txn = (LocalTransaction)this.mPageCopyIndex.mDatabase.newTransaction();
                try {
                    txn.lockMode(LockMode.UNSAFE);
                    BTreeCursor c = this.mPageCopyIndex.newCursor(txn);
                    try {
                        for (long pageId = this.mOffset; pageId < count; pageId += this.mStride) {
                            byte[] key = new byte[8];
                            Utils.encodeLongBE(key, 0, pageId);
                            txn.doLockExclusive(this.mPageCopyIndex.id(), key);
                            c.findNearby(key);
                            byte[] value = c.value();
                            if (value != null) {
                                this.advanceProgress(pageId - this.mStride, pageId);
                                c.commit(null);
                            } else {
                                block23: {
                                    block22: {
                                        Node node;
                                        if (cache != null && (node = cache.nodeMapGet(pageId)) != null && node.tryAcquireShared()) {
                                            try {
                                                if (node.id() != pageId || node.mCachedState != 0) break block22;
                                                PageOps.p_copy(node.mPage, 0, pageBuffer, 0, pageSize);
                                                break block23;
                                            }
                                            finally {
                                                node.releaseShared();
                                            }
                                        }
                                    }
                                    this.mRawPageArray.readPage(pageId, pageBuffer);
                                }
                                this.advanceProgress(pageId - this.mStride, pageId);
                                txn.commit();
                                value = PageOps.p_copyIfNotArray(pageBuffer, pageBufferArray);
                            }
                            if (!this.mParent.writePage(waiter, pageId, value)) break;
                        }
                        c.reset();
                    }
                    catch (Throwable e) {
                        try {
                            this.mParent.close(e);
                            break block24;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            c.reset();
                            PageOps.p_delete(pageBuffer);
                            this.close();
                        }
                    }
                    PageOps.p_delete(pageBuffer);
                    this.close();
                }
                finally {
                    txn.reset();
                }
            }
        }

        private void advanceProgress(long oldProgress, long newProgress) {
            if (!cProgressHandle.compareAndSet(this, oldProgress, newProgress)) {
                throw new IllegalStateException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void capture(long pageId) {
            if (pageId <= this.mProgress) {
                return;
            }
            BTreeCursor c = this.mPageCopyIndex.newCursor(Transaction.BOGUS);
            try {
                block16: {
                    c.autoload(false);
                    byte[] key = new byte[8];
                    Utils.encodeLongBE(key, 0, pageId);
                    c.find(key);
                    if (c.value() != null) {
                        return;
                    }
                    Transaction txn = this.mPageCopyIndex.mDatabase.newTransaction();
                    try {
                        c.link(txn);
                        c.load();
                        if (c.value() == null && pageId > this.mProgress) break block16;
                        txn.reset();
                        return;
                    }
                    catch (Throwable e) {
                        txn.reset();
                        throw e;
                    }
                }
                this.acquireExclusive();
                try {
                    byte[] buffer = this.mCaptureBuffer;
                    if (buffer != PageOps.p_null()) {
                        this.mRawPageArray.readPage(pageId, buffer);
                        c.commit(PageOps.p_copyIfNotArray(buffer, this.mCaptureBufferArray));
                    }
                }
                finally {
                    this.releaseExclusive();
                }
            }
            catch (Throwable e) {
                Utils.closeQuietly(this.mParent, e);
            }
            finally {
                c.reset();
            }
        }

        void close() {
            if (this.mProgress != Long.MAX_VALUE) {
                this.mProgress = Long.MAX_VALUE;
                this.acquireExclusive();
                try {
                    byte[] buffer = this.mCaptureBuffer;
                    this.mCaptureBuffer = PageOps.p_null();
                    if (buffer != PageOps.p_null()) {
                        PageOps.p_delete(buffer);
                    }
                }
                finally {
                    this.releaseExclusive();
                }
            }
        }

        static {
            try {
                cProgressHandle = MethodHandles.lookup().findVarHandle(Copier.class, "mProgress", Long.TYPE);
            }
            catch (Throwable e) {
                throw Utils.rethrow(e);
            }
        }
    }
}

