/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.util.Arrays;
import org.cojen.tupl.core.BTree;
import org.cojen.tupl.core.CursorFrame;
import org.cojen.tupl.core.LocalDatabase;
import org.cojen.tupl.core.Node;

final class Split {
    final boolean mSplitRight;
    private final Node mSibling;
    private byte[] mFullKey;
    private byte[] mActualKey;

    Split(boolean splitRight, Node sibling) {
        this.mSplitRight = splitRight;
        this.mSibling = sibling;
    }

    final void setKey(Split split) {
        this.mFullKey = split.mFullKey;
        this.mActualKey = split.mActualKey;
    }

    final void setKey(BTree tree, byte[] fullKey) throws IOException {
        this.setKey(tree.mDatabase, fullKey);
    }

    final void setKey(LocalDatabase db, byte[] fullKey) throws IOException {
        byte[] actualKey = fullKey;
        if (Node.calculateAllowedKeyLength(db, fullKey) < 0) {
            actualKey = db.fragmentKey(fullKey);
        }
        this.mFullKey = fullKey;
        this.mActualKey = actualKey;
    }

    final void setKey(byte[] fullKey, byte[] actualKey) {
        this.mFullKey = fullKey;
        this.mActualKey = actualKey;
    }

    final byte[] fragmentedKey() {
        return this.mFullKey == this.mActualKey ? null : this.mActualKey;
    }

    final int compare(byte[] key) {
        return Arrays.compareUnsigned(key, this.mFullKey);
    }

    final Node selectNode(Node node, byte[] key) {
        Node right;
        Node left;
        Node sibling = this.mSibling;
        sibling.acquireShared();
        if (this.mSplitRight) {
            left = node;
            right = sibling;
        } else {
            left = sibling;
            right = node;
        }
        if (this.compare(key) < 0) {
            right.releaseShared();
            return left;
        }
        left.releaseShared();
        return right;
    }

    final int adjustBindPosition(int pos) {
        if (!this.mSplitRight) {
            Node sibling = this.latchSibling();
            pos += sibling.highestPos() + 2;
            sibling.releaseShared();
        }
        return pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final byte[] retrieveLeafValue(Node node, int pos) throws IOException {
        if (this.mSplitRight) {
            int highestPos = node.highestPos();
            if (pos > highestPos) {
                Node sibling = this.latchSibling();
                try {
                    byte[] byArray = sibling.retrieveLeafValue(pos - highestPos - 2);
                    return byArray;
                }
                finally {
                    sibling.releaseShared();
                }
            }
        } else {
            Node sibling = this.latchSibling();
            try {
                int highestPos = sibling.highestPos();
                if (pos <= highestPos) {
                    byte[] byArray = sibling.retrieveLeafValue(pos);
                    return byArray;
                }
                pos = pos - highestPos - 2;
            }
            finally {
                sibling.releaseShared();
            }
        }
        return node.retrieveLeafValue(pos);
    }

    final int binarySearchLeaf(Node node, byte[] key) throws IOException {
        int searchPos;
        Node right;
        Node left;
        Node sibling = this.latchSibling();
        if (this.mSplitRight) {
            left = node;
            right = sibling;
        } else {
            left = sibling;
            right = node;
        }
        if (this.compare(key) < 0) {
            searchPos = left.binarySearch(key);
        } else {
            int highestPos = left.highestLeafPos();
            searchPos = right.binarySearch(key);
            searchPos = searchPos < 0 ? searchPos - highestPos - 2 : highestPos + 2 + searchPos;
        }
        sibling.releaseShared();
        return searchPos;
    }

    final int highestPos(Node node) {
        Node sibling = this.latchSibling();
        int pos = node.isLeaf() ? node.highestLeafPos() + 2 + sibling.highestLeafPos() : node.highestInternalPos() + 2 + sibling.highestInternalPos();
        sibling.releaseShared();
        return pos;
    }

    final Node latchSibling() {
        Node sibling = this.mSibling;
        sibling.acquireShared();
        return sibling;
    }

    final Node latchSiblingEx() {
        Node sibling = this.mSibling;
        sibling.acquireExclusive();
        return sibling;
    }

    final void rebindFrame(CursorFrame frame, Node sibling) {
        int pos = frame.mNodePos;
        if (this.mSplitRight) {
            byte[] key;
            Node frameNode = frame.mNode;
            if (frameNode == null) {
                return;
            }
            int highestPos = frameNode.highestPos();
            if (pos >= 0) {
                if (pos > highestPos) {
                    frame.rebind(sibling, pos - highestPos - 2);
                }
                return;
            }
            if ((pos ^= 0xFFFFFFFF) <= highestPos) {
                return;
            }
            if (pos == highestPos + 2 && ((key = frame.mNotFoundKey) == null || this.compare(key) < 0)) {
                return;
            }
            frame.rebind(sibling, ~(pos - highestPos - 2));
        } else {
            int highestPos = sibling.highestPos();
            if (pos >= 0) {
                if (pos <= highestPos) {
                    frame.rebind(sibling, pos);
                } else {
                    frame.mNodePos = pos - highestPos - 2;
                }
                return;
            }
            if ((pos ^= 0xFFFFFFFF) <= highestPos) {
                frame.rebind(sibling, ~pos);
                return;
            }
            if (pos == highestPos + 2) {
                byte[] key = frame.mNotFoundKey;
                if (key == null) {
                    return;
                }
                if (this.compare(key) < 0) {
                    frame.rebind(sibling, ~pos);
                    return;
                }
            }
            frame.mNodePos = ~(pos - highestPos - 2);
        }
    }

    final void unrebindOriginalFrame(CursorFrame frame) {
        if (!this.mSplitRight) {
            int pos = frame.mNodePos;
            int adjust = this.mSibling.highestPos() + 2;
            pos = pos >= 0 ? (pos += adjust) : (pos -= adjust);
            frame.mNodePos = pos;
        }
    }

    final void unrebindSiblingFrame(CursorFrame frame, Node original) {
        int pos = frame.mNodePos;
        if (this.mSplitRight) {
            int adjust = original.highestPos() + 2;
            pos = pos >= 0 ? (pos += adjust) : (pos -= adjust);
        }
        frame.rebind(original, pos);
    }

    final int splitKeyEncodedLength() {
        byte[] actualKey = this.mActualKey;
        if (actualKey == this.mFullKey) {
            return Node.calculateKeyLength(actualKey);
        }
        return 2 + actualKey.length;
    }

    final int copySplitKeyToParent(byte[] dest, int destLoc) {
        byte[] actualKey = this.mActualKey;
        if (actualKey == this.mFullKey) {
            return Node.encodeNormalKey(actualKey, dest, destLoc);
        }
        return Node.encodeFragmentedKey(actualKey, dest, destLoc);
    }
}

