/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.cojen.tupl.core.Scheduler;
import org.cojen.tupl.core.ShutdownHook;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.io.CauseCloseable;

final class TempFileManager
implements CauseCloseable,
ShutdownHook {
    private File mBaseFile;
    private long mCount;
    private Map<File, Closeable> mFiles;
    private Throwable mCause;

    TempFileManager(File baseFile) throws IOException {
        this.mBaseFile = baseFile;
        Utils.deleteNumberedFiles(baseFile, ".temp.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File createTempFile() throws IOException {
        while (true) {
            File file;
            TempFileManager tempFileManager = this;
            synchronized (tempFileManager) {
                if (this.mBaseFile == null) {
                    throw new IOException("Shutting down", this.mCause);
                }
                file = new File(this.mBaseFile.getPath() + ".temp." + this.mCount++);
                if (this.mFiles == null) {
                    this.mFiles = new HashMap<File, Closeable>(4);
                }
                if (this.mFiles.containsKey(file)) {
                    continue;
                }
                this.mFiles.put(file, null);
            }
            if (file.createNewFile()) {
                return file;
            }
            tempFileManager = this;
            synchronized (tempFileManager) {
                this.mFiles.remove(file);
            }
        }
    }

    synchronized void register(File file, Closeable c) throws IOException {
        if (this.mFiles == null || !this.mFiles.containsKey(file)) {
            if (this.mBaseFile == null) {
                throw new IOException("Shutting down", this.mCause);
            }
            return;
        }
        if (this.mFiles.get(file) != null) {
            throw new IllegalStateException();
        }
        this.mFiles.put(file, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteTempFile(File file) {
        Closeable c;
        TempFileManager tempFileManager = this;
        synchronized (tempFileManager) {
            if (this.mFiles == null || !this.mFiles.containsKey(file)) {
                return;
            }
            c = this.mFiles.remove(file);
        }
        Utils.closeQuietly(c);
        this.delete(file, 1L);
    }

    @Override
    public void close() {
        this.close(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Throwable cause) {
        HashMap<File, Closeable> files;
        Iterator iterator = this;
        synchronized (iterator) {
            this.mBaseFile = null;
            if (cause != null) {
                this.mCause = cause;
            }
            if (this.mFiles == null) {
                files = null;
            } else {
                files = new HashMap<File, Closeable>(this.mFiles);
                this.mFiles = null;
            }
        }
        if (files != null) {
            for (Closeable c : files.values()) {
                Utils.closeQuietly(c, cause);
            }
            for (File f : files.keySet()) {
                this.delete(f, 1L);
            }
        }
    }

    @Override
    public void shutdown() {
        this.close();
    }

    private void delete(File file, long delay) {
        if (!file.delete()) {
            Scheduler.daemon().scheduleMillis(() -> this.delete(file, delay * 2L), delay);
        }
    }
}

