/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.util.function.Supplier;
import java.util.zip.Checksum;
import org.cojen.tupl.core.ChecksumPageArray;
import org.cojen.tupl.io.PageArray;

abstract class TransformedPageArray
extends PageArray {
    protected final PageArray mSource;

    TransformedPageArray(PageArray source) {
        super(source.pageSize());
        this.mSource = source;
    }

    TransformedPageArray(int pageSize, PageArray source) {
        super(pageSize);
        this.mSource = source;
    }

    static PageArray rawSource(PageArray array) {
        while (array instanceof TransformedPageArray) {
            TransformedPageArray tpa = (TransformedPageArray)array;
            array = tpa.mSource;
        }
        return array;
    }

    static Supplier<Checksum> checksumFactory(PageArray array) {
        while (true) {
            if (array instanceof ChecksumPageArray) {
                ChecksumPageArray cpa = (ChecksumPageArray)array;
                return cpa.mSupplier;
            }
            if (!(array instanceof TransformedPageArray)) {
                return null;
            }
            TransformedPageArray tpa = (TransformedPageArray)array;
            array = tpa.mSource;
        }
    }
}

