/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.cojen.tupl.Database;
import org.cojen.tupl.Index;
import org.cojen.tupl.diag.CompactionObserver;
import org.cojen.tupl.diag.VerificationObserver;
import org.cojen.tupl.views.ViewUtils;

abstract class Tree
implements Index {
    static final int REGISTRY_ID = 0;
    static final int REGISTRY_KEY_MAP_ID = 1;
    static final int CURSOR_REGISTRY_ID = 2;
    static final int FRAGMENTED_TRASH_ID = 3;
    static final int PREPARED_TXNS_ID = 4;
    static final int SCHEMATA_ID = 5;

    Tree() {
    }

    static boolean isInternal(long id) {
        return (id & 0xFFFFFFFFFFFFFF00L) == 0L;
    }

    abstract Index observableView();

    abstract boolean compactTree(Index var1, long var2, CompactionObserver var4) throws IOException;

    @Override
    public final boolean verify(VerificationObserver observer) throws IOException {
        if (observer == null) {
            observer = new VerificationObserver();
        }
        Index view = this.observableView();
        observer.failed = false;
        this.verifyTree(view, observer);
        boolean passed = !observer.failed;
        observer.indexComplete(view, passed, null);
        return passed;
    }

    abstract boolean verifyTree(Index var1, VerificationObserver var2) throws IOException;

    abstract long countCursors(boolean var1);

    abstract void writeCachePrimer(DataOutput var1) throws IOException;

    abstract void applyCachePrimer(DataInput var1) throws IOException;

    static void skipCachePrimer(DataInput din) throws IOException {
        int len;
        while ((len = din.readUnsignedShort()) != 65535) {
            int amt;
            while (len > 0 && (amt = din.skipBytes(len)) > 0) {
                len -= amt;
            }
        }
    }

    abstract boolean isMemberOf(Database var1);

    abstract boolean isUserOf(Tree var1);

    abstract void rename(byte[] var1, long var2) throws IOException;

    abstract void rootSwap(Tree var1) throws IOException;

    @Override
    public final void drop() throws IOException {
        this.drop(true).run();
    }

    abstract Runnable drop(boolean var1) throws IOException;

    abstract void forceClose();

    public String toString() {
        return ViewUtils.toString(this);
    }
}

