/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import org.cojen.tupl.ClosedIndexException;
import org.cojen.tupl.CorruptDatabaseException;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.DatabaseException;
import org.cojen.tupl.Index;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.core.BTree;
import org.cojen.tupl.core.BTreeCursor;
import org.cojen.tupl.core.CommitLock;
import org.cojen.tupl.core.DatabaseAccess;
import org.cojen.tupl.core.FragmentedTrash;
import org.cojen.tupl.core.GhostFrame;
import org.cojen.tupl.core.IntegerRef;
import org.cojen.tupl.core.LHashTable;
import org.cojen.tupl.core.LocalDatabase;
import org.cojen.tupl.core.LocalTransaction;
import org.cojen.tupl.core.Lock;
import org.cojen.tupl.core.LockManager;
import org.cojen.tupl.core.Node;
import org.cojen.tupl.core.PageOps;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.diag.EventListener;
import org.cojen.tupl.diag.EventType;

final class UndoLog
implements DatabaseAccess {
    UndoLog mPrev;
    UndoLog mNext;
    static final int I_LOWER_NODE_ID = 4;
    private static final int HEADER_SIZE = 12;
    private static final int INITIAL_BUFFER_SIZE = 128;
    private static final byte OP_SCOPE_ENTER = 1;
    private static final byte OP_SCOPE_COMMIT = 2;
    static final byte OP_UNCREATE = 12;
    private static final byte PAYLOAD_OP = 16;
    private static final byte OP_LOG_COPY = 16;
    private static final byte OP_LOG_REF = 17;
    private static final byte OP_INDEX = 18;
    static final byte OP_UNINSERT = 19;
    static final byte OP_UNUPDATE = 20;
    static final byte OP_UNDELETE = 21;
    static final byte OP_UNDELETE_FRAGMENTED = 22;
    static final byte OP_ACTIVE_KEY = 23;
    static final byte OP_CUSTOM = 24;
    private static final int LK_ADJUST = 5;
    static final byte OP_UNUPDATE_LK = 25;
    static final byte OP_UNDELETE_LK = 26;
    static final byte OP_UNDELETE_LK_FRAGMENTED = 27;
    static final byte OP_UNEXTEND = 29;
    static final byte OP_UNALLOC = 30;
    static final byte OP_UNWRITE = 31;
    private static final byte OP_LOG_COPY_C = 32;
    private static final byte OP_LOG_REF_C = 33;
    static final byte OP_LOCK_EXCLUSIVE = 34;
    static final byte OP_LOCK_UPGRADABLE = 35;
    static final byte OP_UNPREPARE = 36;
    static final byte OP_PREPARED = 37;
    static final byte OP_PREPARED_COMMIT = 38;
    static final byte OP_PREPARED_UNROLLBACK = 39;
    private final LocalDatabase mDatabase;
    final long mTxnId;
    private long mLength;
    private byte[] mBuffer;
    private int mBufferPos;
    private Node mNode;
    private int mNodeTopPos;
    private long mActiveIndexId;
    private byte[] mActiveKey;
    private int mCommitted;
    private static final VarHandle cCommittedHandle;

    UndoLog(LocalDatabase db, long txnId) {
        this.mDatabase = db;
        this.mTxnId = txnId;
    }

    @Override
    public LocalDatabase getDatabase() {
        return this.mDatabase;
    }

    long persistReady() throws IOException {
        Node node = this.mNode;
        if (node != null) {
            node.acquireExclusive();
            try {
                this.mDatabase.markUnmappedDirty(node);
            }
            catch (Throwable e) {
                node.releaseExclusive();
                throw e;
            }
        } else {
            if (this.mLength == 0L) {
                return 0L;
            }
            byte[] buffer = this.mBuffer;
            int pos = this.mBufferPos;
            int size = buffer.length - pos;
            this.mNode = node = this.allocUnevictableNode(0L);
            byte[] page = node.mPage;
            int newPos = this.pageSize(page) - size;
            PageOps.p_copyFromArray(buffer, pos, page, newPos, size);
            this.mNodeTopPos = newPos;
            this.mBuffer = null;
            this.mBufferPos = 0;
        }
        node.undoTop(this.mNodeTopPos);
        node.releaseExclusive();
        return this.mNode.id();
    }

    private int pageSize(byte[] page) {
        return page.length;
    }

    void delete() {
        this.mLength = 0L;
        this.mBufferPos = 0;
        this.mBuffer = null;
        Node node = this.mNode;
        if (node != null) {
            this.mNode = null;
            node.delete(this.mDatabase);
        }
    }

    void commit() {
        this.mCommitted = 16;
    }

    void uncommit() {
        cCommittedHandle.setRelease(this, 0);
    }

    boolean isCommitted() {
        return cCommittedHandle.getAcquire(this) != 0;
    }

    boolean recoveryCleanup() throws IOException {
        if (this.mCommitted == 0) {
            return false;
        }
        this.truncate();
        return true;
    }

    final void pushUninsert(long indexId, byte[] key) throws IOException {
        this.setActiveIndexId(indexId);
        this.doPush((byte)19, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void pushNodeEncoded(long indexId, byte op, byte[] payload, int off, int len) throws IOException {
        this.setActiveIndexId(indexId);
        if ((payload[off] & 0xC0) == 192) {
            byte[] copy = PageOps.p_transfer(payload);
            try {
                payload = Node.expandKeyAtLoc(this, copy, off, len, op != 22);
            }
            finally {
                PageOps.p_delete(copy);
            }
            off = 0;
            len = payload.length;
            op = (byte)(op + 5);
        }
        this.doPush(op, payload, off, len);
    }

    private void setActiveIndexId(long indexId) throws IOException {
        long activeIndexId = this.mActiveIndexId;
        if (indexId != activeIndexId) {
            if (activeIndexId != 0L) {
                byte[] payload = new byte[8];
                Utils.encodeLongLE(payload, 0, activeIndexId);
                this.doPush((byte)18, payload, 0, 8, 1);
            }
            this.mActiveIndexId = indexId;
        }
    }

    void pushCustom(int handlerId, byte[] message) throws IOException {
        byte[] payload = new byte[Utils.calcUnsignedVarIntLength(handlerId) + message.length];
        int pos = Utils.encodeUnsignedVarInt(payload, 0, handlerId);
        System.arraycopy(message, 0, payload, pos, message.length);
        this.doPush((byte)24, payload);
    }

    void pushUncreate(long indexId, byte[] key) throws IOException {
        this.setActiveIndexIdAndKey(indexId, key);
        this.doPush((byte)12);
    }

    void pushUnextend(long savepoint, long indexId, byte[] key, long length) throws IOException {
        block6: {
            long unlen;
            block8: {
                int payloadLen;
                block7: {
                    if (!this.setActiveIndexIdAndKey(indexId, key) || savepoint >= this.mLength) break block6;
                    Node node = this.mNode;
                    if (node != null) break block7;
                    byte op = this.mBuffer[this.mBufferPos];
                    if (op == 12) {
                        return;
                    }
                    if (op != 29) break block6;
                    int pos = this.mBufferPos + 1;
                    long decoded = Utils.decodeUnsignedVarInt(this.mBuffer, pos);
                    int payloadLen2 = (int)decoded;
                    pos = (int)(decoded >> 32);
                    IntegerRef.Value offsetRef = new IntegerRef.Value();
                    offsetRef.value = pos;
                    unlen = Utils.decodeUnsignedVarLong(this.mBuffer, offsetRef);
                    break block8;
                }
                byte op = PageOps.p_byteGet(this.mNode.mPage, this.mNodeTopPos);
                if (op == 12) {
                    return;
                }
                if (op != 29) break block6;
                int pos = this.mNodeTopPos + 1;
                long decoded = PageOps.p_uintGetVar(this.mNode.mPage, pos);
                if ((pos = (int)(decoded >> 32)) + (payloadLen = (int)decoded) > this.pageSize(this.mNode.mPage)) break block6;
                IntegerRef.Value offsetRef = new IntegerRef.Value();
                offsetRef.value = pos;
                unlen = PageOps.p_ulongGetVar(this.mNode.mPage, offsetRef);
            }
            if (unlen <= length) {
                return;
            }
        }
        byte[] payload = new byte[9];
        int off = Utils.encodeUnsignedVarLong(payload, 0, length);
        this.doPush((byte)29, payload, 0, off);
    }

    void pushUnalloc(long indexId, byte[] key, long pos, long length) throws IOException {
        this.setActiveIndexIdAndKey(indexId, key);
        byte[] payload = new byte[18];
        int off = Utils.encodeUnsignedVarLong(payload, 0, length);
        off = Utils.encodeUnsignedVarLong(payload, off, pos);
        this.doPush((byte)30, payload, 0, off);
    }

    void pushUnwrite(long indexId, byte[] key, long pos, byte[] b, int off, int len) throws IOException {
        this.setActiveIndexIdAndKey(indexId, key);
        int pLen = Utils.calcUnsignedVarLongLength(pos);
        int varIntLen = Utils.calcUnsignedVarIntLength(pLen + len);
        this.doPush((byte)31, b, off, len, varIntLen, pLen);
        Node node = this.mNode;
        int posOff = 1 + varIntLen;
        if (node != null) {
            PageOps.p_ulongPutVar(node.mPage, this.mNodeTopPos + posOff, pos);
        } else {
            Utils.encodeUnsignedVarLong(this.mBuffer, this.mBufferPos + posOff, pos);
        }
    }

    final void pushLock(byte op, long indexId, byte[] key) throws IOException {
        this.setActiveIndexId(indexId);
        this.doPush(op, key);
    }

    final void pushUnprepare(byte[] key) throws IOException {
        this.doPush((byte)36, key);
    }

    final void pushPrepared(int handlerId, byte[] message, boolean commit) throws IOException {
        byte[] payload;
        int handlerLen = Utils.calcUnsignedVarIntLength(handlerId);
        if (message == null) {
            payload = new byte[handlerLen];
        } else {
            int offset = handlerLen + 1;
            payload = new byte[offset + message.length];
            System.arraycopy(message, 0, payload, offset, message.length);
        }
        Utils.encodeUnsignedVarInt(payload, 0, handlerId);
        this.doPush(commit ? (byte)38 : 37, payload);
    }

    final void pushPreparedUnrollback(byte[] key) throws IOException {
        this.doPush((byte)39, key);
    }

    private boolean setActiveIndexIdAndKey(long indexId, byte[] key) throws IOException {
        byte[] activeKey;
        boolean result = true;
        long activeIndexId = this.mActiveIndexId;
        if (indexId != activeIndexId) {
            if (activeIndexId != 0L) {
                byte[] payload = new byte[8];
                Utils.encodeLongLE(payload, 0, activeIndexId);
                this.doPush((byte)18, payload, 0, 8, 1);
            }
            this.mActiveIndexId = indexId;
            result = false;
        }
        if (!Arrays.equals(key, activeKey = this.mActiveKey)) {
            if (activeKey != null) {
                this.doPush((byte)23, this.mActiveKey);
            }
            this.mActiveKey = key;
            result = false;
        }
        return result;
    }

    private void doPush(byte op) throws IOException {
        this.doPush(op, Utils.EMPTY_BYTES, 0, 0, 0);
    }

    private void doPush(byte op, byte[] payload) throws IOException {
        this.doPush(op, payload, 0, payload.length);
    }

    private void doPush(byte op, byte[] payload, int off, int len) throws IOException {
        this.doPush(op, payload, off, len, Utils.calcUnsignedVarIntLength(len), 0);
    }

    private void doPush(byte op, byte[] payload, int off, int len, int varIntLen) throws IOException {
        this.doPush(op, payload, off, len, varIntLen, 0);
    }

    /*
     * Unable to fully structure code
     */
    private void doPush(byte op, byte[] payload, int off, int len, int varIntLen, int pLen) throws IOException {
        block16: {
            block14: {
                block15: {
                    encodedLen = 1 + varIntLen + pLen + len;
                    node = this.mNode;
                    if (node != null) {
                        node.acquireExclusive();
                        try {
                            this.mDatabase.markUnmappedDirty(node);
                        }
                        catch (Throwable e) {
                            node.releaseExclusive();
                            throw e;
                        }
                    }
                    buffer = this.mBuffer;
                    if (buffer != null) break block14;
                    newCap = Math.max(128, Utils.roundUpPower2(encodedLen));
                    if (newCap > (pageSize = this.mDatabase.pageSize()) >> 1) break block15;
                    this.mBuffer = buffer = new byte[newCap];
                    this.mBufferPos = pos = newCap;
                    ** GOTO lbl43
                }
                this.mNode = node = this.allocUnevictableNode(0L);
                this.mNodeTopPos = pageSize;
                break block16;
            }
            pos = this.mBufferPos;
            if (pos >= encodedLen) ** GOTO lbl43
            size = buffer.length - pos;
            newCap = Utils.roundUpPower2(encodedLen + size);
            newCap = newCap < 0 ? 0x7FFFFFFF : Math.max(buffer.length << 1, newCap);
            if (newCap > this.mDatabase.pageSize() >> 1) {
                this.mNode = node = this.allocUnevictableNode(0L);
                page = node.mPage;
                newPos = this.pageSize(page) - size;
                PageOps.p_copyFromArray(buffer, pos, page, newPos, size);
                this.mNodeTopPos = newPos;
                this.mBuffer = null;
                this.mBufferPos = 0;
            } else {
                newBuf = new byte[newCap];
                newPos = newCap - size;
                System.arraycopy(buffer, pos, newBuf, newPos, size);
                buffer = newBuf;
                this.mBuffer = newBuf;
                this.mBufferPos = pos = newPos;
lbl43:
                // 3 sources

                buffer[pos -= encodedLen] = op;
                if (op >= 16) {
                    payloadPos = Utils.encodeUnsignedVarInt(buffer, pos + 1, pLen + len) + pLen;
                    System.arraycopy(payload, off, buffer, payloadPos, len);
                }
                this.mBufferPos = pos;
                this.mLength += (long)encodedLen;
                return;
            }
        }
        pos = this.mNodeTopPos;
        available = pos - 12;
        if (available >= encodedLen) {
            page = node.mPage;
            PageOps.p_bytePut(page, pos -= encodedLen, op);
            if (op >= 16) {
                payloadPos = PageOps.p_uintPutVar(page, pos + 1, pLen + len) + pLen;
                PageOps.p_copyFromArray(payload, off, page, payloadPos, len);
            }
            node.releaseExclusive();
            this.mNodeTopPos = pos;
            this.mLength += (long)encodedLen;
            return;
        }
        remaining = len;
        while (true) {
            amt = Math.min(available, remaining);
            page = node.mPage;
            PageOps.p_copyFromArray(payload, off + (remaining -= amt), page, pos -= amt, amt);
            if (remaining <= 0 && (available -= amt) >= encodedLen - len) {
                if (varIntLen > 0) {
                    PageOps.p_uintPutVar(page, pos -= varIntLen + pLen, pLen + len);
                }
                break;
            }
            try {
                newNode = this.allocUnevictableNode(node.id());
            }
            catch (Throwable e) {
                while (node != this.mNode) {
                    node = this.popNode(node, true);
                }
                node.releaseExclusive();
                throw e;
            }
            node.undoTop(pos);
            this.mDatabase.nodeMapPut(node);
            node.releaseExclusive();
            node.makeEvictable();
            node = newNode;
            pos = this.pageSize(page);
            available = pos - 12;
        }
        PageOps.p_bytePut(page, --pos, op);
        node.releaseExclusive();
        this.mNode = node;
        this.mNodeTopPos = pos;
        this.mLength += (long)encodedLen;
    }

    final long savepoint() {
        return this.mLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long scopeEnter() throws IOException {
        CommitLock.Shared shared = this.mDatabase.commitLock().acquireShared();
        try {
            long savepoint = this.mLength;
            this.doScopeEnter();
            long l = savepoint;
            return l;
        }
        finally {
            shared.release();
        }
    }

    final void doScopeEnter() throws IOException {
        this.doPush((byte)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long scopeCommit() throws IOException {
        CommitLock.Shared shared = this.mDatabase.commitLock().acquireShared();
        try {
            this.doPush((byte)2);
            long l = this.mLength;
            return l;
        }
        finally {
            shared.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void scopeRollback(long savepoint) throws IOException {
        CommitLock.Shared shared = this.mDatabase.commitLock().acquireShared();
        try {
            if (savepoint < this.mLength) {
                this.doRollback(savepoint);
            }
        }
        finally {
            shared.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void truncate() throws IOException {
        if (this.mLength <= 0L) {
            return;
        }
        CommitLock commitLock = this.mDatabase.commitLock();
        CommitLock.Shared shared = commitLock.acquireShared();
        try {
            Node node = this.mNode;
            if (node == null) {
                this.mBufferPos = this.mBuffer.length;
            } else {
                node.acquireExclusive();
                while (true) {
                    try {
                        node = this.popNode(node, true);
                        if (node == null) {
                            break;
                        }
                    }
                    catch (Throwable e) {
                        this.mNodeTopPos = 0;
                        this.mActiveKey = null;
                        throw e;
                    }
                    if (!commitLock.hasQueuedThreads()) continue;
                    this.mNodeTopPos = 0;
                    this.mActiveKey = null;
                    shared.release();
                    commitLock.acquireShared(shared);
                }
            }
            this.mLength = 0L;
            this.mActiveIndexId = 0L;
            this.mActiveKey = null;
        }
        finally {
            shared.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void truncateMaster() throws IOException {
        block9: {
            CommitLock commitLock = this.mDatabase.commitLock();
            CommitLock.Shared shared = commitLock.acquireShared();
            try {
                if (this.mDatabase.isClosed()) {
                    this.delete();
                    break block9;
                }
                Node node = this.mNode;
                if (node == null) {
                    this.mBufferPos = this.mBuffer.length;
                } else {
                    node.acquireExclusive();
                    try {
                        while ((node = this.popNode(node, true)) != null) {
                        }
                    }
                    catch (Throwable e) {
                        this.mNodeTopPos = 0;
                        this.mActiveKey = null;
                        throw e;
                    }
                }
                this.mLength = 0L;
                this.mActiveIndexId = 0L;
                this.mActiveKey = null;
            }
            finally {
                shared.release();
            }
        }
    }

    final void rollback() throws IOException {
        if (this.mLength == 0L) {
            return;
        }
        CommitLock.Shared shared = this.mDatabase.commitLock().acquireShared();
        try {
            this.mCommitted = 0;
            this.doRollback(0L);
        }
        finally {
            shared.release();
        }
    }

    private void doRollback(long savepoint) throws IOException {
        new PopAll(){
            Index activeIndex;

            @Override
            public boolean accept(byte op, byte[] entry) throws IOException {
                this.activeIndex = UndoLog.this.undo(this.activeIndex, op, entry);
                return true;
            }
        }.go(true, savepoint);
    }

    final RTP rollbackToPrepare() throws IOException {
        RTP rtp = new RTP();
        try {
            while (this.pop(true, rtp)) {
            }
            throw new IllegalStateException("Prepare operation not found");
        }
        catch (RTP rTP) {
            return rtp;
        }
    }

    private Index undo(Index activeIndex, byte op, byte[] entry) throws IOException {
        switch (op) {
            default: {
                throw new DatabaseException("Unknown undo log entry type: " + op);
            }
            case 1: 
            case 2: 
            case 34: 
            case 35: {
                break;
            }
            case 18: {
                this.mActiveIndexId = Utils.decodeLongLE(entry, 0);
                activeIndex = null;
                break;
            }
            case 12: {
                activeIndex = this.doUndo(activeIndex, ix -> ix.delete(Transaction.BOGUS, this.mActiveKey));
                break;
            }
            case 19: {
                activeIndex = this.doUndo(activeIndex, ix -> ix.delete(Transaction.BOGUS, entry));
                break;
            }
            case 20: 
            case 21: {
                byte[][] pair = this.decodeNodeKeyValuePair(entry);
                activeIndex = this.doUndo(activeIndex, ix -> ix.store(Transaction.BOGUS, pair[0], pair[1]));
                break;
            }
            case 25: 
            case 26: {
                long decoded = Utils.decodeUnsignedVarInt(entry, 0);
                byte[] key = new byte[(int)decoded];
                int keyLoc = (int)(decoded >> 32);
                System.arraycopy(entry, keyLoc, key, 0, key.length);
                int valueLoc = keyLoc + key.length;
                byte[] value = new byte[entry.length - valueLoc];
                System.arraycopy(entry, valueLoc, value, 0, value.length);
                activeIndex = this.doUndo(activeIndex, ix -> ix.store(Transaction.BOGUS, key, value));
                break;
            }
            case 22: {
                activeIndex = this.doUndo(activeIndex, ix -> FragmentedTrash.remove(this.mDatabase.fragmentedTrash(), this.mTxnId, (BTree)ix, entry));
                break;
            }
            case 27: {
                long decoded = Utils.decodeUnsignedVarInt(entry, 0);
                byte[] key = new byte[(int)decoded];
                int keyLoc = (int)(decoded >> 32);
                System.arraycopy(entry, keyLoc, key, 0, key.length);
                int tidLoc = keyLoc + key.length;
                int tidLen = entry.length - tidLoc;
                byte[] trashKey = new byte[8 + tidLen];
                Utils.encodeLongBE(trashKey, 0, this.mTxnId);
                System.arraycopy(entry, tidLoc, trashKey, 8, tidLen);
                activeIndex = this.doUndo(activeIndex, ix -> FragmentedTrash.remove(this.mDatabase.fragmentedTrash(), (BTree)ix, key, trashKey));
                break;
            }
            case 24: {
                long decoded = Utils.decodeUnsignedVarInt(entry, 0);
                int handlerId = (int)decoded;
                int messageLoc = (int)(decoded >> 32);
                byte[] message = new byte[entry.length - messageLoc];
                System.arraycopy(entry, messageLoc, message, 0, message.length);
                this.mDatabase.findCustomRecoveryHandler(handlerId).undo(null, message);
                break;
            }
            case 23: {
                this.mActiveKey = entry;
                break;
            }
            case 29: {
                long length = Utils.decodeUnsignedVarLong(entry, new IntegerRef.Value());
                activeIndex = this.doUndo(activeIndex, ix -> {
                    try (Cursor c = ix.newAccessor(Transaction.BOGUS, this.mActiveKey);){
                        c.valueLength(length);
                    }
                });
                break;
            }
            case 30: {
                IntegerRef.Value offsetRef = new IntegerRef.Value();
                long length = Utils.decodeUnsignedVarLong(entry, offsetRef);
                long pos = Utils.decodeUnsignedVarLong(entry, offsetRef);
                activeIndex = this.doUndo(activeIndex, ix -> {
                    try (Cursor c = ix.newAccessor(Transaction.BOGUS, this.mActiveKey);){
                        c.valueClear(pos, length);
                    }
                });
                break;
            }
            case 31: {
                IntegerRef.Value offsetRef = new IntegerRef.Value();
                long pos = Utils.decodeUnsignedVarLong(entry, offsetRef);
                int off = offsetRef.get();
                activeIndex = this.doUndo(activeIndex, ix -> {
                    try (Cursor c = ix.newAccessor(Transaction.BOGUS, this.mActiveKey);){
                        c.valueWrite(pos, entry, off, entry.length - off);
                    }
                });
                break;
            }
            case 36: {
                BTree preparedTxns = this.mDatabase.tryPreparedTxns();
                if (preparedTxns == null) break;
                preparedTxns.store(Transaction.BOGUS, entry, null);
                break;
            }
            case 37: 
            case 38: {
                break;
            }
            case 39: {
                BTree preparedTxns = this.mDatabase.preparedTxns();
                try (BTreeCursor c = new BTreeCursor(preparedTxns);){
                    c.mTxn = LocalTransaction.BOGUS;
                    c.autoload(false);
                    c.find(entry);
                    c.storeGhost(null);
                    break;
                }
            }
        }
        return activeIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] decodeNodeKey(byte[] entry) throws IOException {
        byte[] key;
        byte[] pentry = PageOps.p_transfer(entry);
        try {
            key = Node.retrieveKeyAtLoc(this, pentry, 0);
        }
        finally {
            PageOps.p_delete(pentry);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[][] decodeNodeKeyValuePair(byte[] entry) throws IOException {
        byte[][] pair;
        byte[] pentry = PageOps.p_transfer(entry);
        try {
            pair = Node.retrieveKeyValueAtLoc(this, pentry, 0);
        }
        finally {
            PageOps.p_delete(pentry);
        }
        return pair;
    }

    private Index doUndo(Index activeIndex, UndoTask task) throws IOException {
        while ((activeIndex = this.findIndex(activeIndex)) != null) {
            try {
                task.run(activeIndex);
                break;
            }
            catch (ClosedIndexException e) {
                activeIndex = null;
            }
        }
        return activeIndex;
    }

    private Index findIndex(Index activeIndex) throws IOException {
        if (activeIndex == null || activeIndex.isClosed()) {
            activeIndex = this.mDatabase.anyIndexById(this.mActiveIndexId);
        }
        return activeIndex;
    }

    private boolean pop(boolean delete, Popper popper) throws IOException {
        boolean result;
        long length;
        int nodeTopPos;
        block22: {
            byte op;
            byte[] page;
            Node node = this.mNode;
            if (node == null) {
                boolean result2;
                byte op2;
                int pos;
                byte[] buffer = this.mBuffer;
                if (buffer == null || (pos = this.mBufferPos) >= buffer.length) {
                    this.mLength = 0L;
                    return false;
                }
                if ((op2 = buffer[pos++]) < 16) {
                    result2 = popper.accept(op2, Utils.EMPTY_BYTES);
                    this.mBufferPos = pos;
                    --this.mLength;
                } else {
                    long decoded = Utils.decodeUnsignedVarInt(buffer, pos);
                    int payloadLen = (int)decoded;
                    int varIntLen = (int)(decoded >> 32) - pos;
                    byte[] entry = new byte[payloadLen];
                    System.arraycopy(buffer, pos += varIntLen, entry, 0, payloadLen);
                    result2 = popper.accept(op2, entry);
                    this.mBufferPos = pos + payloadLen;
                    this.mLength -= (long)(1 + varIntLen + payloadLen);
                }
                return result2;
            }
            node.acquireExclusive();
            while (this.mNodeTopPos >= this.pageSize(page = node.mPage)) {
                if ((node = this.popNode(node, delete)) != null) continue;
                this.mLength = 0L;
                return false;
            }
            nodeTopPos = this.mNodeTopPos;
            if ((op = PageOps.p_byteGet(page, nodeTopPos++)) < 16) {
                boolean result3;
                try {
                    result3 = popper.accept(op, Utils.EMPTY_BYTES);
                }
                catch (Throwable e) {
                    node.releaseExclusive();
                    throw e;
                }
                this.mNodeTopPos = nodeTopPos;
                --this.mLength;
                if (nodeTopPos >= this.pageSize(page)) {
                    node = this.popNode(node, delete);
                }
                if (node != null) {
                    node.releaseExclusive();
                }
                return result3;
            }
            length = this.mLength;
            long decoded = PageOps.p_uintGetVar(page, nodeTopPos);
            int payloadLen = (int)decoded;
            int varIntLen = (int)(decoded >> 32) - nodeTopPos;
            nodeTopPos += varIntLen;
            length -= (long)(1 + varIntLen + payloadLen);
            byte[] entry = new byte[payloadLen];
            int entryPos = 0;
            while (true) {
                int avail = Math.min(payloadLen, this.pageSize(page) - nodeTopPos);
                PageOps.p_copyToArray(page, nodeTopPos, entry, entryPos, avail);
                payloadLen -= avail;
                entryPos += avail;
                if ((nodeTopPos += avail) >= this.pageSize(page)) {
                    long lowerNodeId = PageOps.p_longGetLE(node.mPage, 4);
                    node.releaseExclusive();
                    if (lowerNodeId == 0L) {
                        node = null;
                        nodeTopPos = 0;
                    } else {
                        LocalDatabase db = this.mDatabase;
                        node = db.nodeMapGetExclusive(lowerNodeId);
                        if (node == null) {
                            node = UndoLog.readUndoLogNode(db, lowerNodeId, 0);
                            db.nodeMapPut(node);
                        }
                        nodeTopPos = node.undoTop();
                    }
                }
                if (payloadLen <= 0) break;
                if (node == null) {
                    throw new CorruptDatabaseException("Remainder of undo log is missing");
                }
                page = node.mPage;
            }
            long nodeId = 0L;
            if (node != null) {
                nodeId = node.id();
                node.releaseExclusive();
            }
            result = popper.accept(op, entry);
            Node n = this.mNode;
            if (node != n) {
                try {
                    n.acquireExclusive();
                    do {
                        if ((n = this.popNode(n, delete)) != null) continue;
                        if (nodeId != 0L) {
                            throw new AssertionError();
                        }
                        break block22;
                    } while (n.id() != nodeId);
                    n.releaseExclusive();
                }
                catch (Throwable e) {
                    this.mDatabase.close(e);
                    throw e;
                }
            }
        }
        this.mNodeTopPos = nodeTopPos;
        this.mLength = length;
        return result;
    }

    private Node popNode(Node parent, boolean delete) throws IOException {
        Node lowerNode = null;
        long lowerNodeId = PageOps.p_longGetLE(parent.mPage, 4);
        if (lowerNodeId != 0L) {
            lowerNode = this.mDatabase.nodeMapGetAndRemove(lowerNodeId);
            if (lowerNode != null) {
                lowerNode.makeUnevictable();
            } else {
                try {
                    lowerNode = UndoLog.readUndoLogNode(this.mDatabase, lowerNodeId);
                }
                catch (Throwable e) {
                    parent.releaseExclusive();
                    throw e;
                }
            }
        }
        parent.makeEvictable();
        if (delete) {
            try {
                this.mDatabase.deleteNode(parent, this.mTxnId == 0L);
            }
            catch (Throwable e) {
                if (lowerNode != null) {
                    this.mDatabase.nodeMapPut(lowerNode);
                    lowerNode.releaseExclusive();
                    lowerNode.makeEvictable();
                }
                throw e;
            }
        } else {
            parent.releaseExclusive();
        }
        this.mNode = lowerNode;
        this.mNodeTopPos = lowerNode == null ? 0 : lowerNode.undoTop();
        return lowerNode;
    }

    private void scanNodes(Visitor v) throws IOException {
        Node node = this.mNode;
        int nodeTopPos = this.mNodeTopPos;
        node.acquireExclusive();
        byte[] page = node.mPage;
        while (true) {
            int opPos = nodeTopPos;
            byte op = PageOps.p_byteGet(page, nodeTopPos++);
            int payloadLen = 0;
            if (op >= 16) {
                long decoded = PageOps.p_uintGetVar(page, nodeTopPos);
                payloadLen = (int)decoded;
                nodeTopPos = (int)(decoded >> 32);
            }
            int payloadRequired = v.accept(node, op, opPos);
            byte[] entry = null;
            int entryPos = 0;
            if (payloadRequired > 0) {
                entry = new byte[payloadRequired];
            }
            do {
                int avail = Math.min(payloadLen, this.pageSize(page) - nodeTopPos);
                if (entry != null) {
                    int amt = Math.min(avail, entry.length - entryPos);
                    PageOps.p_copyToArray(page, nodeTopPos, entry, entryPos, amt);
                    if ((entryPos += avail) >= entry.length) {
                        try {
                            v.payload(node, entry);
                        }
                        catch (Throwable e) {
                            node.releaseExclusive();
                            throw e;
                        }
                        entry = null;
                    }
                }
                payloadLen -= avail;
                if ((nodeTopPos += avail) < this.pageSize(page)) continue;
                long lowerNodeId = PageOps.p_longGetLE(page, 4);
                node.releaseExclusive();
                if (lowerNodeId == 0L) {
                    return;
                }
                LocalDatabase db = this.mDatabase;
                node = db.nodeMapGetExclusive(lowerNodeId);
                if (node == null) {
                    node = UndoLog.readUndoLogNode(db, lowerNodeId, 0);
                    db.nodeMapPut(node);
                }
                page = node.mPage;
                nodeTopPos = node.undoTop();
            } while (payloadLen > 0);
        }
    }

    private Node allocUnevictableNode(long lowerNodeId) throws IOException {
        Node node = this.mDatabase.allocDirtyNode(1);
        node.type((byte)64);
        PageOps.p_longPutLE(node.mPage, 4, lowerNodeId);
        return node;
    }

    final byte[] writeToMaster(UndoLog master, byte[] workspace) throws IOException {
        Node node;
        if (this.mActiveKey != null) {
            this.doPush((byte)23, this.mActiveKey);
            this.mActiveKey = null;
        }
        if ((node = this.mNode) == null) {
            byte[] buffer = this.mBuffer;
            if (buffer == null) {
                return workspace;
            }
            int pos = this.mBufferPos;
            int bsize = buffer.length - pos;
            if (bsize == 0) {
                return workspace;
            }
            int psize = 18 + bsize;
            if (workspace == null || workspace.length < psize) {
                workspace = new byte[Math.max(128, Utils.roundUpPower2(psize))];
            }
            this.writeHeaderToMaster(workspace);
            Utils.encodeShortLE(workspace, 16, bsize);
            System.arraycopy(buffer, pos, workspace, 18, bsize);
            master.doPush((byte)(16 + this.mCommitted), workspace, 0, psize);
        } else {
            if (workspace == null) {
                workspace = new byte[128];
            }
            this.writeHeaderToMaster(workspace);
            Utils.encodeLongLE(workspace, 16, this.mLength);
            Utils.encodeLongLE(workspace, 24, node.id());
            Utils.encodeShortLE(workspace, 32, this.mNodeTopPos);
            master.doPush((byte)(17 + this.mCommitted), workspace, 0, 34, 1);
        }
        return workspace;
    }

    private void writeHeaderToMaster(byte[] workspace) {
        Utils.encodeLongLE(workspace, 0, this.mTxnId);
        Utils.encodeLongLE(workspace, 8, this.mActiveIndexId);
    }

    static UndoLog recoverMasterUndoLog(LocalDatabase db, long nodeId) throws IOException {
        UndoLog log = new UndoLog(db, 0L);
        log.recoverMaster(nodeId, Long.MAX_VALUE);
        return log;
    }

    private void recoverMaster(long nodeId, long length) throws IOException {
        this.mLength = length;
        this.mNode = UndoLog.readUndoLogNode(this.mDatabase, nodeId);
        this.mNodeTopPos = this.mNode.undoTop();
        this.mNode.releaseExclusive();
    }

    LHashTable.Obj<Object> findCommitted() throws IOException {
        var finder = new Visitor(){
            LHashTable.Obj<Object> mTxns;

            @Override
            public int accept(Node node, byte op, int pos) {
                return op == 32 || op == 33 ? 8 : 0;
            }

            @Override
            public void payload(Node node, byte[] payload) {
                long txnId = Utils.decodeLongLE(payload, 0);
                if (this.mTxns == null) {
                    this.mTxns = new LHashTable.Obj(4);
                }
                this.mTxns.insert(txnId);
            }
        };
        this.scanNodes(finder);
        return finder.mTxns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markUncommitted(final LHashTable.Obj<Object> uncommitted) throws IOException {
        var uncommitter = new Visitor(){
            final Deque<Node> mMatched = new ArrayDeque<Node>();
            private int mOp;
            private int mPos;

            @Override
            public int accept(Node node, byte op, int pos) {
                if (op == 32 || op == 33) {
                    this.mMatched.add(node);
                    this.mOp = op - 16;
                    this.mPos = pos;
                    return 8;
                }
                return 0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void payload(Node node, byte[] payload) throws IOException {
                long txnId = Utils.decodeLongLE(payload, 0);
                if (uncommitted.get(txnId) != null) {
                    Node opNode = this.mMatched.getLast();
                    if (node == opNode) {
                        PageOps.p_bytePut(node.mPage, this.mPos, this.mOp);
                    } else {
                        opNode.acquireExclusive();
                        try {
                            PageOps.p_bytePut(opNode.mPage, this.mPos, this.mOp);
                        }
                        finally {
                            opNode.releaseExclusive();
                        }
                    }
                }
            }
        };
        this.scanNodes(uncommitter);
        for (Node node : uncommitter.mMatched) {
            node.acquireExclusive();
            try {
                node.write(this.mDatabase.mPageDb);
            }
            finally {
                node.releaseExclusive();
            }
        }
    }

    void recoverTransactions(final EventListener debugListener, final boolean trace, final LHashTable.Obj<LocalTransaction> txns) throws IOException {
        new PopAll(){

            @Override
            public boolean accept(byte op, byte[] entry) throws IOException {
                UndoLog log = UndoLog.this.recoverUndoLog(op, entry);
                if (debugListener != null) {
                    debugListener.notify(EventType.DEBUG, "Recovered transaction undo log: txnId=%1$d, length=%2$d, bufferPos=%3$d, nodeId=%4$d, nodeTopPos=%5$d, activeIndexId=%6$d, committed=%7$s", log.mTxnId, log.mLength, log.mBufferPos, log.mNode == null ? 0L : log.mNode.id(), log.mNodeTopPos, log.mActiveIndexId, log.mCommitted != 0);
                }
                LocalTransaction txn = log.recoverTransaction(debugListener, trace);
                txn.recoveredUndoLog(UndoLog.this.recoverUndoLog(op, entry));
                txn.attach("recovery");
                ((LHashTable.ObjEntry)txns.insert((long)log.mTxnId)).value = txn;
                return true;
            }
        }.go(true, 0L);
    }

    private LocalTransaction recoverTransaction(EventListener debugListener, boolean trace) throws IOException {
        if (this.mNode != null && this.mNodeTopPos == 0) {
            return new LocalTransaction(this.mDatabase, this.mTxnId, 0);
        }
        PopOne popper = new PopOne();
        Scope scope = new Scope();
        ArrayDeque<Scope> scopes = new ArrayDeque<Scope>();
        scopes.addFirst(scope);
        int depth = 1;
        int hasState = 0;
        block14: while (this.mLength > 0L && this.pop(false, popper)) {
            byte op = popper.mOp;
            byte[] entry = popper.mEntry;
            if (trace) {
                this.traceOp(debugListener, op, entry);
            }
            switch (op) {
                default: {
                    throw new DatabaseException("Unknown undo log entry type: " + op);
                }
                case 1: {
                    if (++depth <= scopes.size()) continue block14;
                    scope.mSavepoint = this.mLength;
                    scope = new Scope();
                    scopes.addFirst(scope);
                    continue block14;
                }
                case 2: {
                    --depth;
                    continue block14;
                }
                case 18: {
                    this.mActiveIndexId = Utils.decodeLongLE(entry, 0);
                    continue block14;
                }
                case 19: 
                case 34: {
                    scope.addExclusiveLock(this.mActiveIndexId, entry);
                    continue block14;
                }
                case 35: {
                    scope.addUpgradableLock(this.mActiveIndexId, entry);
                    continue block14;
                }
                case 20: 
                case 21: 
                case 22: {
                    byte[] key = this.decodeNodeKey(entry);
                    Lock lock = scope.addExclusiveLock(this.mActiveIndexId, key);
                    if (op == 20) continue block14;
                    lock.setGhostFrame(new GhostFrame());
                    continue block14;
                }
                case 25: 
                case 26: 
                case 27: {
                    long decoded = Utils.decodeUnsignedVarInt(entry, 0);
                    byte[] key = new byte[(int)decoded];
                    int keyLoc = (int)(decoded >> 32);
                    System.arraycopy(entry, keyLoc, key, 0, key.length);
                    Lock lock = scope.addExclusiveLock(this.mActiveIndexId, key);
                    if (op == 25) continue block14;
                    lock.setGhostFrame(new GhostFrame());
                    continue block14;
                }
                case 24: 
                case 36: 
                case 39: {
                    continue block14;
                }
                case 37: {
                    hasState |= 8;
                    continue block14;
                }
                case 38: {
                    hasState |= 0x18;
                    continue block14;
                }
                case 23: {
                    this.mActiveKey = entry;
                    continue block14;
                }
                case 12: 
                case 29: 
                case 30: 
                case 31: 
            }
            if (this.mActiveKey == null) continue;
            scope.addExclusiveLock(this.mActiveIndexId, this.mActiveKey);
            this.mActiveKey = null;
        }
        LocalTransaction txn = new LocalTransaction(this.mDatabase, this.mTxnId, hasState);
        scope = (Scope)scopes.pollFirst();
        scope.acquireLocks(txn);
        while ((scope = (Scope)scopes.pollFirst()) != null) {
            txn.recoveredScope(scope.mSavepoint, 4);
            scope.acquireLocks(txn);
        }
        return txn;
    }

    private void traceOp(EventListener debugListener, byte op, byte[] entry) throws IOException {
        String opStr;
        String payloadStr = null;
        switch (op) {
            default: {
                opStr = "UNKNOWN";
                payloadStr = "op=" + (op & 0xFF) + ", entry=0x" + Utils.toHex(entry);
                break;
            }
            case 1: {
                opStr = "SCOPE_ENTER";
                break;
            }
            case 2: {
                opStr = "SCOPE_COMMIT";
                break;
            }
            case 12: {
                opStr = "UNCREATE";
                break;
            }
            case 16: {
                opStr = "LOG_COPY";
                break;
            }
            case 17: {
                opStr = "LOG_REF";
                break;
            }
            case 32: {
                opStr = "LOG_COPY_C";
                break;
            }
            case 33: {
                opStr = "LOG_REF_C";
                break;
            }
            case 18: {
                opStr = "INDEX";
                payloadStr = "indexId=" + Utils.decodeLongLE(entry, 0);
                break;
            }
            case 19: {
                opStr = "UNINSERT";
                payloadStr = "key=0x" + Utils.toHex(entry) + " (" + Utils.utf8(entry) + ")";
                break;
            }
            case 20: 
            case 21: {
                opStr = op == 20 ? "UNUPDATE" : "UNDELETE";
                byte[][] pair = this.decodeNodeKeyValuePair(entry);
                payloadStr = "key=0x" + Utils.toHex(pair[0]) + " (" + Utils.utf8(pair[0]) + ") value=0x" + Utils.toHex(pair[1]);
                break;
            }
            case 22: {
                opStr = "UNDELETE_FRAGMENTED";
                byte[] key = this.decodeNodeKey(entry);
                payloadStr = "key=0x" + Utils.toHex(key) + " (" + Utils.utf8(key) + ")";
                break;
            }
            case 23: {
                opStr = "ACTIVE_KEY";
                payloadStr = "key=0x" + Utils.toHex(entry) + " (" + Utils.utf8(entry) + ")";
                break;
            }
            case 24: {
                opStr = "CUSTOM";
                long decoded = Utils.decodeUnsignedVarInt(entry, 0);
                int handlerId = (int)decoded;
                int messageLoc = (int)(decoded >> 32);
                String handlerName = this.mDatabase.findHandlerName(handlerId, (byte)7);
                payloadStr = "handlerId=" + handlerId + ", handlerName=" + handlerName + ", message=0x" + Utils.toHex(entry, messageLoc, entry.length - messageLoc);
                break;
            }
            case 25: 
            case 26: {
                opStr = op == 25 ? "UNUPDATE_LK" : "UNDELETE_LK";
                long decoded = Utils.decodeUnsignedVarInt(entry, 0);
                int keyLen = (int)decoded;
                int keyLoc = (int)(decoded >> 32);
                int valueLoc = keyLoc + keyLen;
                int valueLen = entry.length - valueLoc;
                payloadStr = "key=0x" + Utils.toHex(entry, keyLoc, keyLen) + " (" + Utils.utf8(entry, keyLoc, keyLen) + ") value=0x" + Utils.toHex(entry, valueLoc, valueLen);
                break;
            }
            case 27: {
                opStr = "UNDELETE_LK_FRAGMENTED";
                long decoded = Utils.decodeUnsignedVarInt(entry, 0);
                int keyLen = (int)decoded;
                int keyLoc = (int)(decoded >> 32);
                payloadStr = "key=0x" + Utils.toHex(entry, keyLoc, keyLen) + " (" + Utils.utf8(entry, keyLoc, keyLen) + ")";
                break;
            }
            case 29: {
                opStr = "UNEXTEND";
                payloadStr = "length=" + Utils.decodeUnsignedVarLong(entry, new IntegerRef.Value());
                break;
            }
            case 30: {
                opStr = "UNALLOC";
                IntegerRef.Value offsetRef = new IntegerRef.Value();
                long length = Utils.decodeUnsignedVarLong(entry, offsetRef);
                long pos = Utils.decodeUnsignedVarLong(entry, offsetRef);
                payloadStr = "pos=" + pos + ", length=" + length;
                break;
            }
            case 31: {
                opStr = "UNWRITE";
                IntegerRef.Value offsetRef = new IntegerRef.Value();
                long pos = Utils.decodeUnsignedVarLong(entry, offsetRef);
                int off = offsetRef.get();
                payloadStr = "pos=" + pos + ", value=0x" + Utils.toHex(entry, off, entry.length - off);
                break;
            }
            case 35: {
                opStr = "LOCK_UPGRADABLE";
                payloadStr = "key=0x" + Utils.toHex(entry) + " (" + Utils.utf8(entry) + ")";
                break;
            }
            case 34: {
                opStr = "LOCK_EXCLUSIVE";
                payloadStr = "key=0x" + Utils.toHex(entry) + " (" + Utils.utf8(entry) + ")";
                break;
            }
            case 36: {
                opStr = "UNPREPARE";
                payloadStr = "txnId=" + Utils.decodeLongBE(entry, 0);
                break;
            }
            case 37: 
            case 38: {
                opStr = op == 38 ? "PREPARED_COMMIT" : "PREPARED";
                long decoded = Utils.decodeUnsignedVarInt(entry, 0);
                int handlerId = (int)decoded;
                String handlerName = this.mDatabase.findHandlerName(handlerId, (byte)9);
                payloadStr = "handlerId=" + handlerId + ", handlerName=" + handlerName;
                int messageLoc = (int)(decoded >> 32) + 1;
                if (messageLoc > entry.length) break;
                payloadStr = payloadStr + ", message=0x" + Utils.toHex(entry, messageLoc, entry.length - messageLoc);
                break;
            }
            case 39: {
                opStr = "PREPARED_UNROLLBACK";
                payloadStr = "txnId=" + Utils.decodeLongBE(entry, 0);
            }
        }
        if (payloadStr == null) {
            debugListener.notify(EventType.DEBUG, "Undo recover %1$s", opStr);
        } else {
            debugListener.notify(EventType.DEBUG, "Undo recover %1$s %2$s", opStr, payloadStr);
        }
    }

    private UndoLog recoverUndoLog(byte masterLogOp, byte[] masterLogEntry) throws IOException {
        if (masterLogOp != 16 && masterLogOp != 17 && masterLogOp != 32 && masterLogOp != 33) {
            throw new DatabaseException("Unknown undo log entry type: " + masterLogOp);
        }
        long txnId = Utils.decodeLongLE(masterLogEntry, 0);
        UndoLog log = new UndoLog(this.mDatabase, txnId);
        log.mActiveIndexId = Utils.decodeLongLE(masterLogEntry, 8);
        if ((masterLogOp & 1) == 0) {
            int bsize = Utils.decodeUnsignedShortLE(masterLogEntry, 16);
            log.mLength = bsize;
            byte[] buffer = new byte[bsize];
            System.arraycopy(masterLogEntry, 18, buffer, 0, bsize);
            log.mBuffer = buffer;
            log.mBufferPos = 0;
        } else {
            log.mLength = Utils.decodeLongLE(masterLogEntry, 16);
            long nodeId = Utils.decodeLongLE(masterLogEntry, 24);
            int topEntry = Utils.decodeUnsignedShortLE(masterLogEntry, 32);
            log.mNode = UndoLog.readUndoLogNode(this.mDatabase, nodeId);
            log.mNodeTopPos = topEntry;
            log.mNode.releaseExclusive();
        }
        log.mCommitted = masterLogOp >> 1 & 0x10;
        return log;
    }

    private static Node readUndoLogNode(LocalDatabase db, long nodeId) throws IOException {
        return UndoLog.readUndoLogNode(db, nodeId, 1);
    }

    private static Node readUndoLogNode(LocalDatabase db, long nodeId, int mode) throws IOException {
        Node node = db.allocLatchedNode(mode);
        try {
            node.read(db, nodeId);
            if (node.type() != 64) {
                throw new CorruptDatabaseException("Not an undo log node type: " + node.type() + ", id: " + nodeId);
            }
            return node;
        }
        catch (Throwable e) {
            node.releaseExclusive();
            node.makeEvictableNow();
            throw e;
        }
    }

    static {
        try {
            cCommittedHandle = MethodHandles.lookup().findVarHandle(UndoLog.class, "mCommitted", Integer.TYPE);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    class RTP
    extends IOException
    implements Popper {
        private Index activeIndex;
        int handlerId;
        byte[] message;
        boolean commit;

        RTP() {
        }

        @Override
        public boolean accept(byte op, byte[] entry) throws IOException {
            if (op == 37 || op == 38) {
                long decoded = Utils.decodeUnsignedVarInt(entry, 0);
                this.handlerId = (int)decoded;
                int messageLoc = (int)(decoded >> 32) + 1;
                if (messageLoc <= entry.length) {
                    this.message = Arrays.copyOfRange(entry, messageLoc, entry.length);
                }
                if (op == 38) {
                    this.commit = true;
                }
                throw this;
            }
            this.activeIndex = UndoLog.this.undo(this.activeIndex, op, entry);
            return true;
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private static interface Popper {
        public boolean accept(byte var1, byte[] var2) throws IOException;
    }

    @FunctionalInterface
    private static interface UndoTask {
        public void run(Index var1) throws IOException;
    }

    private static interface Visitor {
        public int accept(Node var1, byte var2, int var3);

        public void payload(Node var1, byte[] var2) throws IOException;
    }

    private static class PopOne
    implements Popper {
        byte mOp;
        byte[] mEntry;

        private PopOne() {
        }

        @Override
        public boolean accept(byte op, byte[] entry) throws IOException {
            this.mOp = op;
            this.mEntry = entry;
            return true;
        }
    }

    static class Scope {
        long mSavepoint;
        Lock mTopLock;

        Scope() {
        }

        Lock addExclusiveLock(long indexId, byte[] key) {
            return this.addLock(indexId, key, -1);
        }

        Lock addUpgradableLock(long indexId, byte[] key) {
            return this.addLock(indexId, key, Integer.MIN_VALUE);
        }

        Lock addLock(long indexId, byte[] key, int lockCount) {
            Lock lock = new Lock();
            lock.mIndexId = indexId;
            lock.mKey = key;
            lock.mHashCode = LockManager.hash(indexId, key);
            lock.mLockNext = this.mTopLock;
            lock.mLockCount = lockCount;
            this.mTopLock = lock;
            return lock;
        }

        void acquireLocks(LocalTransaction txn) throws LockFailureException {
            Lock lock = this.mTopLock;
            if (lock != null) {
                while (true) {
                    Lock next = lock.mLockNext;
                    txn.recoverLock(lock);
                    if (next == null) break;
                    this.mTopLock = lock = next;
                }
            }
        }
    }

    private abstract class PopAll
    implements Popper {
        private PopAll() {
        }

        void go(boolean delete, long savepoint) throws IOException {
            while (UndoLog.this.pop(delete, this) && savepoint < UndoLog.this.mLength) {
            }
        }
    }
}

