/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.LongAdder;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.core.Chain;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.core._BTree;
import org.cojen.tupl.core._BTreeCursor;
import org.cojen.tupl.core._LocalDatabase;

abstract class _BTreeSeparator
extends LongAdder {
    protected final _LocalDatabase mDatabase;
    protected final _BTree[] mSources;
    protected final Executor mExecutor;
    private final int mWorkerCount;
    private final Worker[] mWorkerHashtable;
    private Worker mFirstWorker;
    private volatile Throwable mException;
    static final VarHandle cExceptionHandle;
    static final VarHandle cSpawnCountHandle;

    _BTreeSeparator(_LocalDatabase db, _BTree[] sources, Executor executor, int workerCount) {
        if (db == null || sources.length <= 0 || workerCount <= 0) {
            throw new IllegalArgumentException();
        }
        if (executor == null) {
            workerCount = 1;
        }
        this.mDatabase = db;
        this.mSources = sources;
        this.mExecutor = executor;
        this.mWorkerCount = workerCount;
        this.mWorkerHashtable = new Worker[Utils.roundUpPower2(workerCount)];
    }

    public void start() {
        this.startWorker(null, this.mWorkerCount - 1, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Worker[] hashtable;
        Worker[] workerArray = hashtable = this.mWorkerHashtable;
        synchronized (hashtable) {
            for (int slot = 0; slot < hashtable.length; ++slot) {
                Worker w = hashtable[slot];
                while (w != null) {
                    int spawnCount;
                    while (!cSpawnCountHandle.compareAndSet(w, spawnCount = w.mSpawnCount, spawnCount | Integer.MIN_VALUE)) {
                    }
                    w = w.mHashtableNext;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public Throwable exceptionCheck() {
        return this.mException;
    }

    protected void failed(Throwable cause) {
        cExceptionHandle.compareAndSet(this, null, cause);
        this.stop();
    }

    protected abstract void finished(Chain<_BTree> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWorker(Worker from, int spawnCount, byte[] lowKey, byte[] highKey) {
        Worker worker = new Worker(spawnCount, lowKey, highKey, this.mSources.length);
        Worker[] hashtable = this.mWorkerHashtable;
        int slot = worker.mHash & hashtable.length - 1;
        Worker[] workerArray = hashtable;
        synchronized (hashtable) {
            if (from != null && from.mSpawnCount < 0) {
                worker.mSpawnCount = spawnCount | Integer.MIN_VALUE;
            }
            worker.mHashtableNext = hashtable[slot];
            hashtable[slot] = worker;
            if (from == null) {
                this.mFirstWorker = worker;
            } else {
                Worker next = from.mNext;
                from.mNext = worker;
                if (next != null) {
                    worker.mNext = next;
                }
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            if (this.mExecutor == null) {
                worker.run();
            } else {
                this.mExecutor.execute(worker);
            }
            return;
        }
    }

    private _BTreeCursor openSourceCursor(int sourceSlot, byte[] lowKey) throws IOException {
        _BTreeCursor scursor = this.mSources[sourceSlot].newCursor(Transaction.BOGUS);
        scursor.mKeyOnly = true;
        if (lowKey == null) {
            scursor.first();
        } else {
            scursor.findGe(lowKey);
        }
        return scursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] selectSplitKey(byte[] lowKey, byte[] highKey) throws IOException {
        _BTree source = this.mSources[ThreadLocalRandom.current().nextInt(this.mSources.length)];
        _BTreeCursor scursor = source.newCursor(Transaction.BOGUS);
        try {
            scursor.mKeyOnly = true;
            scursor.random(lowKey, highKey);
            byte[] byArray = scursor.key();
            return byArray;
        }
        finally {
            scursor.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void workerFinished(Worker worker) {
        Worker[] hashtable = this.mWorkerHashtable;
        int slot = worker.mHash & hashtable.length - 1;
        Worker[] workerArray = hashtable;
        synchronized (hashtable) {
            Worker w = hashtable[slot];
            Worker prev = null;
            while (true) {
                Worker next = w.mHashtableNext;
                if (w == worker) {
                    if (prev == null) {
                        hashtable[slot] = next;
                        break;
                    }
                    prev.mHashtableNext = next;
                    break;
                }
                prev = w;
                w = next;
            }
            int addCount = 1 + (worker.mSpawnCount & Integer.MAX_VALUE);
            if (addCount < this.mWorkerCount) {
                int randomSlot = ThreadLocalRandom.current().nextInt(hashtable.length);
                while (true) {
                    Worker w2;
                    if ((w2 = hashtable[randomSlot]) != null) {
                        cSpawnCountHandle.getAndAdd(w2, addCount);
                        // ** MonitorExit[var5_4] (shouldn't be in output)
                        return;
                    }
                    if (++randomSlot < hashtable.length) continue;
                    randomSlot = 0;
                }
            }
            Worker first = this.mFirstWorker;
            this.mFirstWorker = null;
            // ** MonitorExit[var5_4] (shouldn't be in output)
            this.finished(first);
            return;
        }
    }

    static void siftDown(Selector[] selectors, int size, int pos, Selector element) {
        int half = size >>> 1;
        while (pos < half) {
            int childPos = (pos << 1) + 1;
            Selector child = selectors[childPos];
            int rightPos = childPos + 1;
            if (rightPos < size && child.compareTo(selectors[rightPos]) > 0) {
                childPos = rightPos;
                child = selectors[childPos];
            }
            if (element.compareTo(child) <= 0) break;
            selectors[pos] = child;
            pos = childPos;
        }
        selectors[pos] = element;
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            cExceptionHandle = lookup.findVarHandle(_BTreeSeparator.class, "mException", Throwable.class);
            cSpawnCountHandle = lookup.findVarHandle(Worker.class, "mSpawnCount", Integer.TYPE);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    private final class Worker
    implements Runnable,
    Chain<_BTree> {
        final int mHash = ThreadLocalRandom.current().nextInt();
        final byte[] mLowKey;
        byte[] mHighKey;
        final Selector[] mQueue;
        volatile int mSpawnCount;
        Worker mHashtableNext;
        private _BTree mTarget;
        Worker mNext;

        Worker(int spawnCount, byte[] lowKey, byte[] highKey, int numSources) {
            this.mLowKey = lowKey;
            this.mHighKey = highKey;
            this.mQueue = new Selector[numSources];
            this.mSpawnCount = spawnCount;
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (Throwable e) {
                for (Selector s : this.mQueue) {
                    if (s == null) continue;
                    s.mSource.reset();
                }
                _BTreeSeparator.this.failed(e);
            }
            _BTreeSeparator.this.workerFinished(this);
        }

        @Override
        public _BTree element() {
            return this.mTarget;
        }

        public Worker next() {
            return this.mNext;
        }

        private void doRun() throws Exception {
            Selector[] queue = this.mQueue;
            int queueSize = 0;
            for (int slot = 0; slot < queue.length; ++slot) {
                _BTreeCursor scursor = _BTreeSeparator.this.openSourceCursor(slot, this.mLowKey);
                if (scursor.key() == null) continue;
                queue[queueSize++] = new Selector(slot, scursor);
            }
            if (queueSize == 0) {
                return;
            }
            int i = queueSize >>> 1;
            while (--i >= 0) {
                _BTreeSeparator.siftDown(queue, queueSize, i, queue[i]);
            }
            _BTreeCursor tcursor = null;
            byte[] highKey = this.mHighKey;
            int count = 0;
            block2: while (true) {
                _BTreeCursor scursor;
                Selector selector;
                block18: {
                    block17: {
                        block16: {
                            selector = queue[0];
                            scursor = selector.mSource;
                            if (highKey == null || Arrays.compareUnsigned(scursor.key(), highKey) < 0) break block16;
                            scursor.reset();
                            break block17;
                        }
                        if (selector.mSkip) {
                            scursor.store(null);
                            scursor.next();
                            selector.mSkip = false;
                        } else {
                            if (tcursor == null) {
                                this.mTarget = _BTreeSeparator.this.mDatabase.newTemporaryIndex();
                                tcursor = this.mTarget.newCursor(Transaction.BOGUS);
                                tcursor.mKeyOnly = true;
                                tcursor.firstLeaf();
                            }
                            tcursor.appendTransfer(scursor);
                            count = (byte)(count + 1);
                            if (count == 0) {
                                _BTreeSeparator.this.add(256L);
                            }
                        }
                        if (scursor.key() != null) break block18;
                    }
                    if (--queueSize == 0) break;
                    selector = queue[queueSize];
                    queue[queueSize] = null;
                }
                _BTreeSeparator.siftDown(queue, queueSize, 0, selector);
                int spawnCount = this.mSpawnCount;
                if (spawnCount == 0) continue;
                if (spawnCount < 0) {
                    this.mHighKey = scursor.key();
                    for (int i2 = 0; i2 < queueSize; ++i2) {
                        queue[i2].mSource.reset();
                    }
                    break;
                }
                byte[] splitKey = _BTreeSeparator.this.selectSplitKey(queue[0].mSource.key(), highKey);
                if (splitKey == null) continue;
                for (int i3 = 0; i3 < queueSize; ++i3) {
                    if (Arrays.equals(splitKey, queue[i3].mSource.key())) continue block2;
                }
                _BTreeSeparator.this.startWorker(this, 0, splitKey, highKey);
                highKey = splitKey;
                this.mHighKey = splitKey;
                cSpawnCountHandle.getAndAdd(this, -1);
            }
            if (tcursor != null) {
                tcursor.reset();
            }
            _BTreeSeparator.this.add((long)count & 0xFFL);
        }
    }

    private static final class Selector {
        final int mSourceSlot;
        final _BTreeCursor mSource;
        boolean mSkip;

        Selector(int slot, _BTreeCursor source) {
            this.mSourceSlot = slot;
            this.mSource = source;
        }

        int compareTo(Selector other) {
            int compare = Arrays.compareUnsigned(this.mSource.key(), other.mSource.key());
            if (compare == 0) {
                if (this.mSourceSlot < other.mSourceSlot) {
                    this.mSkip = true;
                    compare = -1;
                } else {
                    other.mSkip = true;
                    compare = 1;
                }
            }
            return compare;
        }
    }
}

