/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import org.cojen.tupl.LargeKeyException;
import org.cojen.tupl.LargeValueException;
import org.cojen.tupl.core.DirectPageOps;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.core._BTree;
import org.cojen.tupl.core._BTreeCursor;
import org.cojen.tupl.core._CursorFrame;
import org.cojen.tupl.core._LocalDatabase;
import org.cojen.tupl.core._LocalTransaction;
import org.cojen.tupl.core._Node;

final class _BTreeValue {
    static final int OP_LENGTH = 0;
    static final int OP_READ = 1;
    static final int OP_CLEAR = 2;
    static final int OP_SET_LENGTH = 3;
    static final int OP_WRITE = 4;

    private _BTreeValue() {
    }

    static int compactCheck(_CursorFrame frame, boolean isKey, long pos, long highestNodeId) throws IOException {
        byte fHeader;
        long fLen;
        int len;
        byte header;
        _Node node = frame.mNode;
        int nodePos = frame.mNodePos;
        if (nodePos < 0) {
            return -2;
        }
        long page = node.mPage;
        int loc = DirectPageOps.p_ushortGetLE(page, node.searchVecStart() + nodePos);
        if (isKey) {
            if ((header = DirectPageOps.p_byteGet(page, loc++)) >= 0) {
                return pos >= (long)(header + 1) ? -2 : -1;
            }
            len = (header & 0x3F) << 8 | DirectPageOps.p_ubyteGet(page, loc++);
        } else {
            loc += _Node.keyLengthAtLoc(page, loc);
            if ((header = DirectPageOps.p_byteGet(page, loc++)) >= 0) {
                return pos >= (long)header ? -2 : -1;
            }
            if ((header & 0x20) == 0) {
                len = 1 + ((header & 0x1F) << 8 | DirectPageOps.p_ubyteGet(page, loc++));
            } else if (header != -1) {
                len = 1 + ((header & 0xF) << 16 | DirectPageOps.p_ubyteGet(page, loc++) << 8 | DirectPageOps.p_ubyteGet(page, loc++));
            } else {
                return -2;
            }
        }
        if ((header & 0x40) == 0) {
            return pos >= (long)len ? -2 : -1;
        }
        if (pos >= (fLen = _LocalDatabase.decodeFullFragmentedValueLength(fHeader = DirectPageOps.p_byteGet(page, loc++), page, loc))) {
            return -2;
        }
        loc = _BTreeValue.skipFragmentedLengthField(loc, fHeader);
        if ((fHeader & 2) != 0) {
            int fInlineLen = DirectPageOps.p_ushortGetLE(page, loc);
            if ((pos -= (long)fInlineLen) < 0L) {
                return fInlineLen;
            }
            fLen -= (long)fInlineLen;
            loc = loc + 2 + fInlineLen;
        }
        _LocalDatabase db = node.getDatabase();
        if ((fHeader & 1) == 0) {
            long fNodeId = DirectPageOps.p_uint48GetLE(page, loc += (int)pos / _BTreeValue.pageSize(db, page) * 6);
            return fNodeId > highestNodeId ? 0 : -1;
        }
        long inodeId = DirectPageOps.p_uint48GetLE(page, loc);
        if (inodeId == 0L) {
            return -1;
        }
        if (inodeId > highestNodeId) {
            return 0;
        }
        _Node inode = db.nodeMapLoadFragment(inodeId);
        int level = db.calculateInodeLevels(fLen);
        while (true) {
            long levelCap = db.levelCap(--level);
            long childNodeId = DirectPageOps.p_uint48GetLE(inode.mPage, (int)(pos / levelCap) * 6);
            inode.releaseShared();
            if (childNodeId > highestNodeId) {
                return 0;
            }
            if (level <= 0 || childNodeId == 0L) {
                return -1;
            }
            inode = db.nodeMapLoadFragment(childNodeId);
            pos %= levelCap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void touch(_CursorFrame frame, boolean isKey, long pos) throws IOException {
        long fLen;
        byte header;
        _Node node = frame.mNode;
        int nodePos = frame.mNodePos;
        if (nodePos < 0) {
            return;
        }
        long page = node.mPage;
        int loc = DirectPageOps.p_ushortGetLE(page, node.searchVecStart() + nodePos);
        if (isKey) {
            header = DirectPageOps.p_byteGet(page, loc);
            if (header >= 0) {
                return;
            }
            loc += 2;
        } else {
            if ((header = DirectPageOps.p_byteGet(page, loc += _Node.keyLengthAtLoc(page, loc))) >= 0) {
                return;
            }
            if ((header & 0x20) == 0) {
                loc += 2;
            } else if (header != -1) {
                loc += 3;
            } else {
                return;
            }
        }
        if ((header & 0x40) == 0) {
            return;
        }
        byte fHeader = DirectPageOps.p_byteGet(page, loc++);
        switch (fHeader >> 2 & 3) {
            default: {
                fLen = DirectPageOps.p_ushortGetLE(page, loc);
                break;
            }
            case 1: {
                fLen = (long)DirectPageOps.p_intGetLE(page, loc) & 0xFFFFFFFFL;
                break;
            }
            case 2: {
                fLen = DirectPageOps.p_uint48GetLE(page, loc);
                break;
            }
            case 3: {
                fLen = DirectPageOps.p_longGetLE(page, loc);
                if (fLen >= 0L) break;
                node.releaseExclusive();
                if (isKey) {
                    throw new LargeKeyException(fLen);
                }
                throw new LargeValueException(fLen);
            }
        }
        loc = _BTreeValue.skipFragmentedLengthField(loc, fHeader);
        int fInlineLen = 0;
        if ((fHeader & 2) != 0) {
            fInlineLen = DirectPageOps.p_ushortGetLE(page, loc);
            if (pos < (long)fInlineLen) {
                return;
            }
            loc += 2;
            loc += fInlineLen;
        }
        if (pos > fLen) {
            return;
        }
        _LocalDatabase db = node.getDatabase();
        try {
            if ((fHeader & 1) == 0) {
                long fNodeId = DirectPageOps.p_uint48GetLE(page, loc += (int)(pos - (long)fInlineLen) / _BTreeValue.pageSize(db, page) * 6);
                if (fNodeId != 0L) {
                    _Node fNode = db.nodeMapLoadFragmentExclusive(fNodeId, true);
                    try {
                        if (db.markFragmentDirty(fNode)) {
                            DirectPageOps.p_int48PutLE(page, loc, fNode.id());
                        }
                    }
                    finally {
                        fNode.releaseExclusive();
                    }
                }
                return;
            }
            long inodeId = DirectPageOps.p_uint48GetLE(page, loc);
            if (inodeId == 0L) {
                return;
            }
            _Node inode = db.nodeMapLoadFragmentExclusive(inodeId, true);
            try {
                if (db.markFragmentDirty(inode)) {
                    DirectPageOps.p_int48PutLE(page, loc, inode.id());
                }
            }
            catch (Throwable e) {
                throw _BTreeValue.releaseExclusive(inode, e);
            }
            int levels = db.calculateInodeLevels(fLen - (long)fInlineLen);
            _BTreeValue.touchMultilevelFragment(pos - (long)fInlineLen, levels, inode);
        }
        catch (Throwable e) {
            throw _BTreeValue.releaseExclusive(node, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static long action(_LocalTransaction txn, _BTreeCursor cursor, _CursorFrame frame, int op, long pos, byte[] b, int bOff, long bLen) throws IOException {
        block165: {
            block166: {
                while (true) {
                    block173: {
                        block169: {
                            block171: {
                                block172: {
                                    block170: {
                                        block168: {
                                            node = frame.mNode;
                                            nodePos = frame.mNodePos;
                                            if (nodePos < 0) {
                                                if (op <= 2) {
                                                    return -1L;
                                                }
                                                if (txn != null) {
                                                    try {
                                                        txn.pushUncreate(cursor.mTree.mId, cursor.mKey);
                                                        txn = null;
                                                    }
                                                    catch (Throwable e) {
                                                        throw _BTreeValue.releaseExclusive(node, e);
                                                    }
                                                }
                                                node = cursor.insertBlank(frame, node, pos + bLen);
                                                if (bLen <= 0L) {
                                                    return 0L;
                                                }
                                                nodePos = frame.mNodePos;
                                                if (nodePos < 0) {
                                                    return 0L;
                                                }
                                            }
                                            page = node.mPage;
                                            kHeaderLoc = loc = DirectPageOps.p_ushortGetLE(page, node.searchVecStart() + nodePos);
                                            loc += _Node.keyLengthAtLoc(page, loc);
                                            vHeaderLoc = loc;
                                            if ((vHeader = DirectPageOps.p_byteGet(page, loc++)) < 0) break block168;
                                            vLen = vHeader;
                                            break block169;
                                        }
                                        if ((vHeader & 32) != 0) break block170;
                                        vLen = 1 + ((vHeader & 31) << 8 | DirectPageOps.p_ubyteGet(page, loc++));
                                        break block171;
                                    }
                                    if (vHeader != -1) break block172;
                                    if (op <= 2) {
                                        return -1L;
                                    }
                                    DirectPageOps.p_bytePut(page, vHeaderLoc, 0);
                                    vLen = 0;
                                    break block169;
                                }
                                vLen = 1 + ((vHeader & 15) << 16 | DirectPageOps.p_ubyteGet(page, loc++) << 8 | DirectPageOps.p_ubyteGet(page, loc++));
                            }
                            if ((vHeader & 64) != 0) break block173;
                        }
                        switch (op) {
                            default: {
                                return vLen;
                            }
                            case 1: {
                                if (bLen <= 0L || pos >= (long)vLen) {
                                    bLen = 0L;
                                } else {
                                    bLen = Math.min((long)((int)((long)vLen - pos)), bLen);
                                    DirectPageOps.p_copyToArray(page, (int)((long)loc + pos), b, bOff, (int)bLen);
                                }
                                return bLen;
                            }
                            case 2: {
                                if (pos < (long)vLen) {
                                    iLoc = (int)((long)loc + pos);
                                    iLen = (int)Math.min(bLen, (long)vLen - pos);
                                    if (txn != null) {
                                        try {
                                            txn.pushUnwrite(cursor.mTree.mId, cursor.mKey, pos, page, iLoc, iLen);
                                        }
                                        catch (Throwable e) {
                                            throw _BTreeValue.releaseExclusive(node, e);
                                        }
                                    }
                                    DirectPageOps.p_clear(page, iLoc, iLoc + iLen);
                                }
                                return 0L;
                            }
                            case 3: {
                                if (pos > (long)vLen) break;
                                if (pos == (long)vLen) {
                                    return 0L;
                                }
                                newLen = (int)pos;
                                oldLen = vLen;
                                garbageAccum = oldLen - newLen;
                                if (txn != null) {
                                    try {
                                        txn.pushUnwrite(cursor.mTree.mId, cursor.mKey, pos, page, loc + newLen, garbageAccum);
                                    }
                                    catch (Throwable e) {
                                        throw _BTreeValue.releaseExclusive(node, e);
                                    }
                                }
                                if (newLen > 127) ** GOTO lbl82
                                DirectPageOps.p_bytePut(page, vHeaderLoc, newLen);
                                vShift = loc - (vHeaderLoc + 1);
                                ** GOTO lbl90
lbl82:
                                // 1 sources

                                if (newLen > 8192) {
                                    DirectPageOps.p_bytePut(page, vHeaderLoc, 160 | newLen - 1 >> 16);
                                    DirectPageOps.p_bytePut(page, vHeaderLoc + 1, newLen - 1 >> 8);
                                    DirectPageOps.p_bytePut(page, vHeaderLoc + 2, newLen - 1);
                                } else {
                                    DirectPageOps.p_bytePut(page, vHeaderLoc, 128 | newLen - 1 >> 8);
                                    DirectPageOps.p_bytePut(page, vHeaderLoc + 1, newLen - 1);
                                    vShift = loc - (vHeaderLoc + 2);
lbl90:
                                    // 2 sources

                                    if (vShift > 0) {
                                        garbageAccum += vShift;
                                        DirectPageOps.p_copy(page, loc, page, loc - vShift, newLen);
                                    }
                                }
                                node.garbage(node.garbage() + garbageAccum);
                                return 0L;
                            }
                            case 4: {
                                if (pos >= (long)vLen) break;
                                end = pos + bLen;
                                if (end <= (long)vLen) {
                                    iLoc = (int)((long)loc + pos);
                                    iLen = (int)bLen;
                                    if (txn != null) {
                                        try {
                                            txn.pushUnwrite(cursor.mTree.mId, cursor.mKey, pos, page, iLoc, iLen);
                                        }
                                        catch (Throwable e) {
                                            throw _BTreeValue.releaseExclusive(node, e);
                                        }
                                    }
                                    DirectPageOps.p_copyFromArray(b, bOff, page, iLoc, iLen);
                                    return 0L;
                                }
                                if (pos == 0L && bOff == 0 && bLen == (long)b.length) {
                                    try {
                                        tree = cursor.mTree;
                                        if (txn != null) {
                                            txn.pushUndoStore(tree.mId, (byte)20, page, kHeaderLoc, loc + vLen - kHeaderLoc);
                                        }
                                        node.updateLeafValue(tree, nodePos, 0, b);
                                    }
                                    catch (Throwable e) {
                                        throw _BTreeValue.releaseExclusive(node, e);
                                    }
                                    if (node.mSplit != null) {
                                        node = cursor.mTree.finishSplitCritical(frame, node);
                                    }
                                    return 0L;
                                }
                                iLoc = (int)((long)loc + pos);
                                iLen = (int)((long)vLen - pos);
                                if (txn != null) {
                                    try {
                                        txn.pushUnwrite(cursor.mTree.mId, cursor.mKey, pos, page, iLoc, iLen);
                                    }
                                    catch (Throwable e) {
                                        throw _BTreeValue.releaseExclusive(node, e);
                                    }
                                }
                                DirectPageOps.p_copyFromArray(b, bOff, page, iLoc, iLen);
                                pos = vLen;
                                bOff += iLen;
                                bLen -= (long)iLen;
                            }
                        }
                        try {
                            if (txn != null) {
                                txn.pushUnextend(cursor.mTree.mId, cursor.mKey, vLen);
                                txn = null;
                            }
                            oldValue = new byte[vLen];
                            DirectPageOps.p_copyToArray(page, loc, oldValue, 0, oldValue.length);
                            node.deleteLeafEntry(nodePos);
                        }
                        catch (Throwable e) {
                            throw _BTreeValue.releaseExclusive(node, e);
                        }
                        node.postDelete(nodePos, cursor.mKey);
                        cursor.insertBlank(frame, node, pos + bLen);
                        op = 4;
                        if (bLen <= 0L) {
                            pos = 0L;
                            b = oldValue;
                            bOff = 0;
                            bLen = oldValue.length;
                            continue;
                        }
                        _BTreeValue.action(null, cursor, frame, 4, 0L, oldValue, 0, oldValue.length);
                        continue;
                    }
                    fHeaderLoc = loc;
                    fHeader = DirectPageOps.p_byteGet(page, loc++);
                    switch (fHeader >> 2 & 3) {
                        default: {
                            fLen = DirectPageOps.p_ushortGetLE(page, loc);
                            break;
                        }
                        case 1: {
                            fLen = (long)DirectPageOps.p_intGetLE(page, loc) & 0xFFFFFFFFL;
                            break;
                        }
                        case 2: {
                            fLen = DirectPageOps.p_uint48GetLE(page, loc);
                            break;
                        }
                        case 3: {
                            fLen = DirectPageOps.p_longGetLE(page, loc);
                            if (fLen >= 0L) break;
                            node.release(op > 1);
                            throw new LargeValueException(fLen);
                        }
                    }
                    loc = _BTreeValue.skipFragmentedLengthField(loc, fHeader);
                    switch (op) {
                        default: {
                            return fLen;
                        }
                        case 1: {
                            try {
                                if (bLen <= 0L || pos >= fLen) {
                                    return 0L;
                                }
                                bLen = (int)Math.min(fLen - pos, bLen);
                                total = (int)bLen;
                                if ((fHeader & 2) != 0) {
                                    fInlineLen = DirectPageOps.p_ushortGetLE(page, loc);
                                    loc += 2;
                                    amt = (int)((long)fInlineLen - pos);
                                    if (amt <= 0) {
                                        pos -= (long)fInlineLen;
                                    } else {
                                        if (bLen <= (long)amt) {
                                            DirectPageOps.p_copyToArray(page, (int)((long)loc + pos), b, bOff, (int)bLen);
                                            return bLen;
                                        }
                                        DirectPageOps.p_copyToArray(page, (int)((long)loc + pos), b, bOff, amt);
                                        bLen -= (long)amt;
                                        bOff += amt;
                                        pos = 0L;
                                    }
                                    loc += fInlineLen;
                                }
                                db = node.getDatabase();
                                if ((fHeader & 1) == 0) {
                                    ipos = (int)pos;
                                    pageSize = _BTreeValue.pageSize(db, page);
                                    loc += ipos / pageSize * 6;
                                    fNodeOff = ipos % pageSize;
                                    while (true) {
                                        amt = Math.min((int)bLen, pageSize - fNodeOff);
                                        fNodeId = DirectPageOps.p_uint48GetLE(page, loc);
                                        if (fNodeId == 0L) {
                                            Arrays.fill(b, bOff, bOff + amt, (byte)0);
                                        } else {
                                            fNode = db.nodeMapLoadFragment(fNodeId);
                                            DirectPageOps.p_copyToArray(fNode.mPage, fNodeOff, b, bOff, amt);
                                            fNode.releaseShared();
                                        }
                                        if ((bLen -= (long)amt) <= 0L) {
                                            return total;
                                        }
                                        bOff += amt;
                                        loc += 6;
                                        fNodeOff = 0;
                                    }
                                }
                                inodeId = DirectPageOps.p_uint48GetLE(page, loc);
                                if (inodeId == 0L) {
                                    Arrays.fill(b, bOff, bOff + (int)bLen, (byte)0);
                                } else {
                                    levels = db.calculateInodeLevels(fLen);
                                    inode = db.nodeMapLoadFragment(inodeId);
                                    _BTreeValue.readMultilevelFragments(pos, levels, inode, b, bOff, (int)bLen);
                                }
                                return total;
                            }
                            catch (Throwable e) {
                                node.releaseShared();
                                throw e;
                            }
                        }
                        case 2: 
                        case 3: {
                            if (op == 2) {
                                if ((bLen = Math.min(bLen, fLen - pos)) <= 0L) {
                                    return 0L;
                                }
                            } else {
                                if (pos >= fLen) break;
                                if (txn != null) {
                                    txn.pushUnextend(cursor.mTree.mId, cursor.mKey, fLen);
                                }
                                bLen = fLen - pos;
                            }
                            finalLength = pos;
                            fInlineLoc = loc;
                            fInlineLen = 0;
                            if ((fHeader & 2) != 0) {
                                fInlineLen = DirectPageOps.p_ushortGetLE(page, loc);
                                fInlineLoc += 2;
                                loc += 2;
                                amt = (long)fInlineLen - pos;
                                if (amt > 0L) {
                                    iLoc = (int)((long)loc + pos);
                                    if (bLen <= amt) {
                                        iLen = (int)bLen;
                                        if (txn != null) {
                                            try {
                                                txn.pushUnwrite(cursor.mTree.mId, cursor.mKey, pos, page, iLoc, iLen);
                                            }
                                            catch (Throwable e) {
                                                throw _BTreeValue.releaseExclusive(node, e);
                                            }
                                        }
                                        DirectPageOps.p_clear(page, iLoc, iLoc + iLen);
                                        if (op == 3) {
                                            fHeaderLoc = _BTreeValue.truncateFragmented(node, page, vHeaderLoc, vLen, iLen);
                                            _BTreeValue.updateLengthField(page, fHeaderLoc, finalLength);
                                        }
                                        return 0L;
                                    }
                                    iLen = (int)amt;
                                    if (txn != null) {
                                        txn.pushUnwrite(cursor.mTree.mId, cursor.mKey, pos, page, iLoc, iLen);
                                    }
                                    DirectPageOps.p_clear(page, iLoc, iLoc + iLen);
                                    bLen -= amt;
                                    pos = fInlineLen;
                                }
                                fLen -= (long)fInlineLen;
                                loc += fInlineLen;
                            }
                            v0 = toEnd = pos - (long)fInlineLen + bLen >= fLen;
                            if ((fHeader & 1) == 0) ** GOTO lbl330
                            inodeId = DirectPageOps.p_uint48GetLE(page, loc);
                            if (inodeId != 0L) ** GOTO lbl279
                            if (op == 2) {
                                return 0L;
                            }
                            ** GOTO lbl326
lbl279:
                            // 1 sources

                            db = node.getDatabase();
                            inode = db.nodeMapLoadFragmentExclusive(inodeId, true);
                            if (db.markFragmentDirty(inode)) {
                                DirectPageOps.p_int48PutLE(page, loc, inode.id());
                            }
                            levels = db.calculateInodeLevels(fLen - (long)fInlineLen);
                            _BTreeValue.clearMultilevelFragments(txn, cursor, pos, pos - (long)fInlineLen, levels, inode, bLen, toEnd);
                            if (op != 2) ** GOTO lbl290
                            var32_82 = 0L;
                            inode.releaseExclusive();
                            return var32_82;
lbl290:
                            // 1 sources

                            try {
                                newLevels = db.calculateInodeLevels(finalLength - (long)fInlineLen);
                                if (newLevels < levels) {
                                    do {
                                        if ((childNodeId = DirectPageOps.p_uint48GetLE(inode.mPage, 0)) == 0L) {
                                            inodeId = 0L;
                                            break;
                                        }
                                        try {
                                            childNode = db.nodeMapLoadFragmentExclusive(childNodeId, true);
                                        }
                                        catch (Throwable e) {
                                            inode.releaseExclusive();
                                            db.close(e);
                                            throw e;
                                        }
                                        toDelete = inode;
                                        inode = childNode;
                                        db.deleteNode(toDelete);
                                        inodeId = inode.id();
                                    } while (--levels > newLevels);
                                    DirectPageOps.p_int48PutLE(page, loc, inodeId);
                                    if (newLevels <= 0) {
                                        if (pos == 0L) {
                                            DirectPageOps.p_bytePut(page, vHeaderLoc, 0);
                                            garbageAccum = fHeaderLoc - vHeaderLoc + vLen - 1;
                                            node.garbage(node.garbage() + garbageAccum);
                                            db.deleteNode(inode);
                                        } else {
                                            DirectPageOps.p_bytePut(page, fHeaderLoc, fHeader & -2);
                                        }
                                    }
                                }
                                ** GOTO lbl326
                            }
                            catch (Throwable e) {
                                throw _BTreeValue.releaseExclusive(node, e);
                            }
                            {
                                catch (Throwable var37_106) {
                                    throw var37_106;
                                }
                            }
                            {
                                finally {
                                    inode.releaseExclusive();
                                }
lbl326:
                                // 3 sources

                                _BTreeValue.updateLengthField(page, fHeaderLoc, finalLength);
                                return 0L;
                            }
lbl330:
                            // 1 sources

                            db = node.getDatabase();
                            ipos = (int)(pos - (long)fInlineLen);
                            pageSize = _BTreeValue.pageSize(db, page);
                            fNodeOff = ipos % pageSize;
                            firstDeletedLoc = loc += ipos / pageSize * 6;
                            try {
                                while (true) {
                                    amt = Math.min((int)bLen, pageSize - fNodeOff);
                                    fNodeId = DirectPageOps.p_uint48GetLE(page, loc);
                                    if (fNodeId == 0L) ** GOTO lbl366
                                    if (amt < pageSize && (!toEnd || fNodeOff > 0)) ** GOTO lbl353
                                    if (txn == null) {
                                        db.deleteFragment(fNodeId);
                                    } else {
                                        fNode = db.nodeMapLoadFragmentExclusive(fNodeId, true);
                                        try {
                                            txn.pushUnwrite(cursor.mTree.mId, cursor.mKey, pos, fNode.mPage, 0, amt);
                                        }
                                        catch (Throwable e) {
                                            fNode.releaseExclusive();
                                        }
                                        db.deleteNode(fNode);
                                    }
                                    DirectPageOps.p_int48PutLE(page, loc, 0L);
                                    ** GOTO lbl366
lbl353:
                                    // 1 sources

                                    fNode = db.nodeMapLoadFragmentExclusive(fNodeId, true);
                                    try {
                                        if (db.markFragmentDirty(fNode)) {
                                            DirectPageOps.p_int48PutLE(page, loc, fNode.id());
                                        }
                                        fNodePage = fNode.mPage;
                                        if (txn != null) {
                                            txn.pushUnwrite(cursor.mTree.mId, cursor.mKey, pos, fNodePage, fNodeOff, amt);
                                        }
                                        DirectPageOps.p_clear(fNode.mPage, fNodeOff, fNodeOff + amt);
                                    }
                                    finally {
                                        fNode.releaseExclusive();
                                    }
                                    firstDeletedLoc += 6;
lbl366:
                                    // 3 sources

                                    loc += 6;
                                    if ((bLen -= (long)amt) <= 0L) {
                                        if (op == 3) {
                                            shrinkage = loc - firstDeletedLoc;
                                            if (ipos <= 0) {
                                                len = (int)finalLength;
                                                shrinkage = shrinkage - ipos + fInlineLen - len;
                                                _BTreeValue.fragmentedToNormal(node, page, vHeaderLoc, fInlineLoc, len, shrinkage);
                                            } else {
                                                fHeaderLoc = _BTreeValue.truncateFragmented(node, page, vHeaderLoc, vLen, shrinkage);
                                                _BTreeValue.updateLengthField(page, fHeaderLoc, finalLength);
                                            }
                                        }
                                        return 0L;
                                    }
                                    pos += (long)amt;
                                    fNodeOff = 0;
                                }
                            }
                            catch (Throwable e) {
                                throw _BTreeValue.releaseExclusive(node, e);
                            }
                        }
                        case 4: 
                    }
                    fInlineLen = 0;
                    if ((fHeader & 2) != 0) {
                        fInlineLen = DirectPageOps.p_ushortGetLE(page, loc);
                        loc += 2;
                        amt = (long)fInlineLen - pos;
                        if (amt > 0L) {
                            iLoc = (int)((long)loc + pos);
                            if (bLen <= amt) {
                                iLen = (int)bLen;
                                if (txn != null) {
                                    txn.pushUnwrite(cursor.mTree.mId, cursor.mKey, pos, page, iLoc, iLen);
                                }
                                DirectPageOps.p_copyFromArray(b, bOff, page, iLoc, iLen);
                                return 0L;
                            }
                            iLen = (int)amt;
                            if (txn != null) {
                                try {
                                    txn.pushUnwrite(cursor.mTree.mId, cursor.mKey, pos, page, iLoc, iLen);
                                }
                                catch (Throwable e) {
                                    throw _BTreeValue.releaseExclusive(node, e);
                                }
                            }
                            DirectPageOps.p_copyFromArray(b, bOff, page, iLoc, iLen);
                            bLen -= amt;
                            bOff = (int)((long)bOff + amt);
                            pos = fInlineLen;
                        }
                        loc += fInlineLen;
                    }
                    if ((endPos = pos + bLen) <= fLen) {
                        if (endPos < 0L) {
                            node.releaseExclusive();
                            throw new IllegalArgumentException("Length overflow");
                        }
                        if (bLen == 0L) {
                            return 0L;
                        }
                        db = node.getDatabase();
                        if ((fHeader & 1) != 0) {
                            try {
                                levels = db.calculateInodeLevels(fLen - (long)fInlineLen);
                                inode = _BTreeValue.prepareMultilevelWrite(db, page, loc);
                                _BTreeValue.writeMultilevelFragments(txn, cursor, pos, pos - (long)fInlineLen, levels, inode, b, bOff, (int)bLen);
                                return 0L;
                            }
                            catch (Throwable e) {
                                throw _BTreeValue.releaseExclusive(node, e);
                            }
                        }
                        pageSize = _BTreeValue.pageSize(db, page);
                        break block165;
                    }
                    fieldGrowth = _BTreeValue.lengthFieldGrowth(fHeader, endPos);
                    if (fieldGrowth > 0) {
                        _BTreeValue.tryIncreaseLengthField(cursor, frame, kHeaderLoc, vHeaderLoc, vLen, fHeaderLoc, fieldGrowth);
                        continue;
                    }
                    db = node.getDatabase();
                    if ((fHeader & 1) != 0) {
                        try {
                            if (txn != null) {
                                txn.pushUnextend(cursor.mTree.mId, cursor.mKey, fLen);
                                if (pos >= fLen) {
                                    txn = null;
                                }
                            }
                            inode = _BTreeValue.prepareMultilevelWrite(db, page, loc);
                            levels = db.calculateInodeLevels(fLen - (long)fInlineLen);
                            newLen = endPos - (long)fInlineLen;
                            if (db.levelCap(levels) < newLen) {
                                newLevels = db.calculateInodeLevels(newLen);
                                if (newLevels <= levels) {
                                    throw new AssertionError();
                                }
                                pageSize = _BTreeValue.pageSize(db, page);
                                newNodes = new _Node[newLevels - levels];
                                for (i = 0; i < newNodes.length; ++i) {
                                    try {
                                        newNodes[i] = db.allocDirtyFragmentNode();
                                        continue;
                                    }
                                    catch (Throwable e) {
                                        try {
                                            while (--i >= 0) {
                                                db.deleteNode(newNodes[i], true);
                                            }
                                        }
                                        catch (Throwable e2) {
                                            Utils.suppress(e, e2);
                                            db.close(e);
                                        }
                                        throw e;
                                    }
                                }
                                for (_Node upper : newNodes) {
                                    upage = upper.mPage;
                                    DirectPageOps.p_int48PutLE(upage, 0, inode.id());
                                    inode.releaseExclusive();
                                    DirectPageOps.p_clear(upage, 6, pageSize);
                                    inode = upper;
                                }
                                levels = newLevels;
                                DirectPageOps.p_int48PutLE(page, loc, inode.id());
                            }
                            _BTreeValue.updateLengthField(page, fHeaderLoc, endPos);
                            _BTreeValue.writeMultilevelFragments(txn, cursor, pos, pos - (long)fInlineLen, levels, inode, b, bOff, (int)bLen);
                            return 0L;
                        }
                        catch (Throwable e) {
                            throw _BTreeValue.releaseExclusive(node, e);
                        }
                    }
                    pageSize = _BTreeValue.pageSize(db, page);
                    ptrGrowth = _BTreeValue.pointerCount(pageSize, endPos - (long)fInlineLen) - _BTreeValue.pointerCount(pageSize, fLen - (long)fInlineLen);
                    if (ptrGrowth <= 0L) break block166;
                    newLoc = _BTreeValue.tryExtendDirect(cursor, frame, kHeaderLoc, vHeaderLoc, vLen, fHeaderLoc, ptrGrowth * 6L);
                    if (newLoc >= 0) break;
                }
                page = node.mPage;
                delta = newLoc - fHeaderLoc;
                loc += delta;
                fHeaderLoc = newLoc;
            }
            if (txn != null) {
                try {
                    txn.pushUnextend(cursor.mTree.mId, cursor.mKey, fLen);
                    if (pos >= fLen) {
                        txn = null;
                    }
                }
                catch (Throwable e) {
                    throw _BTreeValue.releaseExclusive(node, e);
                }
            }
            _BTreeValue.updateLengthField(page, fHeaderLoc, endPos);
        }
        ipos = (int)(pos - (long)fInlineLen);
        loc += ipos / pageSize * 6;
        fNodeOff = ipos % pageSize;
        try {
            while (true) {
                if ((amt = Math.min((int)bLen, pageSize - fNodeOff)) > 0) {
                    fNodeId = DirectPageOps.p_uint48GetLE(page, loc);
                    if (fNodeId == 0L) {
                        if (txn != null) {
                            txn.pushUnalloc(cursor.mTree.mId, cursor.mKey, pos, amt);
                        }
                        fNode = db.allocDirtyFragmentNode();
                        try {
                            DirectPageOps.p_int48PutLE(page, loc, fNode.id());
                            fNodePage = fNode.mPage;
                            DirectPageOps.p_clear(fNodePage, 0, fNodeOff);
                            DirectPageOps.p_copyFromArray(b, bOff, fNodePage, fNodeOff, amt);
                            DirectPageOps.p_clear(fNodePage, fNodeOff + amt, pageSize);
                        }
                        finally {
                            fNode.releaseExclusive();
                        }
                    }
                    if (txn == null) {
                        fNode = db.nodeMapLoadFragmentExclusive(fNodeId, amt < pageSize);
                    } else {
                        fNode = db.nodeMapLoadFragmentExclusive(fNodeId, true);
                        try {
                            txn.pushUnwrite(cursor.mTree.mId, cursor.mKey, pos, fNode.mPage, fNodeOff, amt);
                        }
                        catch (Throwable e) {
                            fNode.releaseExclusive();
                            throw e;
                        }
                    }
                    try {
                        if (db.markFragmentDirty(fNode)) {
                            DirectPageOps.p_int48PutLE(page, loc, fNode.id());
                        }
                        DirectPageOps.p_copyFromArray(b, bOff, fNode.mPage, fNodeOff, amt);
                    }
                    finally {
                        fNode.releaseExclusive();
                    }
                    bLen -= (long)amt;
                }
                if (bLen <= 0L) {
                    return 0L;
                }
                bOff += amt;
                pos += (long)pageSize;
                loc += 6;
                fNodeOff = 0;
            }
        }
        catch (Throwable e) {
            throw _BTreeValue.releaseExclusive(node, e);
        }
    }

    private static void readMultilevelFragments(long pos, int level, _Node inode, byte[] b, int bOff, int bLen) throws IOException {
        _LocalDatabase db = inode.getDatabase();
        block4: while (true) {
            long page = inode.mPage;
            long levelCap = db.levelCap(--level);
            int poffset = (int)(pos / levelCap) * 6;
            long ppos = pos % levelCap;
            while (true) {
                long childNodeId = DirectPageOps.p_uint48GetLE(page, poffset);
                int len = (int)Math.min(levelCap - ppos, (long)bLen);
                bLen -= len;
                if (childNodeId == 0L) {
                    Arrays.fill(b, bOff, bOff + len, (byte)0);
                    if (bLen <= 0) {
                        inode.releaseShared();
                        return;
                    }
                } else {
                    _Node childNode;
                    try {
                        childNode = db.nodeMapLoadFragment(childNodeId);
                    }
                    catch (Throwable e) {
                        inode.releaseShared();
                        throw e;
                    }
                    if (level <= 0) {
                        DirectPageOps.p_copyToArray(childNode.mPage, (int)ppos, b, bOff, len);
                        childNode.releaseShared();
                        if (bLen <= 0) {
                            inode.releaseShared();
                            return;
                        }
                    } else {
                        if (bLen <= 0) {
                            inode.releaseShared();
                            pos = ppos;
                            inode = childNode;
                            bLen = len;
                            continue block4;
                        }
                        try {
                            _BTreeValue.readMultilevelFragments(ppos, level, childNode, b, bOff, len);
                        }
                        catch (Throwable e) {
                            inode.releaseShared();
                            throw e;
                        }
                    }
                }
                bOff += len;
                poffset += 6;
                ppos = 0L;
            }
            break;
        }
    }

    private static _Node prepareMultilevelWrite(_LocalDatabase db, long page, int loc) throws IOException {
        _Node inode;
        long inodeId = DirectPageOps.p_uint48GetLE(page, loc);
        if (inodeId == 0L) {
            inode = db.allocDirtyFragmentNode();
            DirectPageOps.p_clear(inode.mPage, 0, _BTreeValue.pageSize(db, inode.mPage));
        } else {
            inode = db.nodeMapLoadFragmentExclusive(inodeId, true);
            try {
                if (!db.markFragmentDirty(inode)) {
                    return inode;
                }
            }
            catch (Throwable e) {
                throw _BTreeValue.releaseExclusive(inode, e);
            }
        }
        DirectPageOps.p_int48PutLE(page, loc, inode.id());
        return inode;
    }

    private static void writeMultilevelFragments(_LocalTransaction txn, _BTreeCursor cursor, long pos, long ppos, int level, _Node inode, byte[] b, int bOff, int bLen) throws IOException {
        _LocalDatabase db = inode.getDatabase();
        block10: while (true) {
            long page = inode.mPage;
            long levelCap = db.levelCap(--level);
            int poffset = (int)(ppos / levelCap) * 6;
            ppos %= levelCap;
            int pageSize = _BTreeValue.pageSize(db, page);
            while (true) {
                long childNodeId = DirectPageOps.p_uint48GetLE(page, poffset);
                int len = (int)Math.min(levelCap - ppos, (long)bLen);
                bLen -= len;
                if (level <= 0) {
                    block23: {
                        block22: {
                            try {
                                if (childNodeId == 0L) {
                                    if (txn != null) {
                                        txn.pushUnalloc(cursor.mTree.mId, cursor.mKey, pos, len);
                                    }
                                    childNode = db.allocDirtyFragmentNode();
                                    if (ppos > 0L || len < pageSize) {
                                        DirectPageOps.p_clear(childNode.mPage, 0, pageSize);
                                    }
                                    break block22;
                                }
                                if (txn == null) {
                                    childNode = db.nodeMapLoadFragmentExclusive(childNodeId, ppos > 0L | len < pageSize);
                                } else {
                                    childNode = db.nodeMapLoadFragmentExclusive(childNodeId, true);
                                    txn.pushUnwrite(cursor.mTree.mId, cursor.mKey, pos, childNode.mPage, (int)ppos, len);
                                }
                                try {
                                    if (db.markFragmentDirty(childNode)) break block22;
                                    break block23;
                                }
                                catch (Throwable e) {
                                    throw _BTreeValue.releaseExclusive(childNode, e);
                                }
                            }
                            catch (Throwable e) {
                                throw _BTreeValue.releaseExclusive(inode, e);
                            }
                        }
                        DirectPageOps.p_int48PutLE(page, poffset, childNode.id());
                    }
                    DirectPageOps.p_copyFromArray(b, bOff, childNode.mPage, (int)ppos, len);
                    childNode.releaseExclusive();
                    if (bLen <= 0) {
                        inode.releaseExclusive();
                        return;
                    }
                } else {
                    block25: {
                        block24: {
                            try {
                                if (childNodeId == 0L) {
                                    childNode = db.allocDirtyFragmentNode();
                                    DirectPageOps.p_clear(childNode.mPage, 0, pageSize);
                                    break block24;
                                }
                                childNode = db.nodeMapLoadFragmentExclusive(childNodeId, true);
                                try {
                                    if (db.markFragmentDirty(childNode)) break block24;
                                    break block25;
                                }
                                catch (Throwable e) {
                                    throw _BTreeValue.releaseExclusive(childNode, e);
                                }
                            }
                            catch (Throwable e) {
                                throw _BTreeValue.releaseExclusive(inode, e);
                            }
                        }
                        DirectPageOps.p_int48PutLE(page, poffset, childNode.id());
                    }
                    if (bLen <= 0) {
                        inode.releaseExclusive();
                        inode = childNode;
                        bLen = len;
                        continue block10;
                    }
                    try {
                        _BTreeValue.writeMultilevelFragments(txn, cursor, pos, ppos, level, childNode, b, bOff, len);
                    }
                    catch (Throwable e) {
                        throw _BTreeValue.releaseExclusive(inode, e);
                    }
                }
                pos += (long)len;
                bOff += len;
                poffset += 6;
                ppos = 0L;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearMultilevelFragments(_LocalTransaction txn, _BTreeCursor cursor, long pos, long ppos, int level, _Node inode, long clearLen, boolean toEnd) throws IOException {
        _LocalDatabase db = inode.getDatabase();
        long page = inode.mPage;
        long levelCap = db.levelCap(--level);
        int poffset = (int)(ppos / levelCap) * 6;
        ppos %= levelCap;
        while (true) {
            long len = Math.min(levelCap - ppos, clearLen);
            long childNodeId = DirectPageOps.p_uint48GetLE(page, poffset);
            if (childNodeId != 0L) {
                if (len >= levelCap || toEnd && ppos <= 0L) {
                    block16: {
                        block17: {
                            childNode = null;
                            try {
                                if (level <= 0) {
                                    if (txn == null) {
                                        db.deleteFragment(childNodeId);
                                        break block16;
                                    }
                                    childNode = db.nodeMapLoadFragmentExclusive(childNodeId, true);
                                    txn.pushUnwrite(cursor.mTree.mId, cursor.mKey, pos, childNode.mPage, 0, (int)len);
                                    break block17;
                                }
                                childNode = db.nodeMapLoadFragmentExclusive(childNodeId, true);
                                _BTreeValue.clearMultilevelFragments(txn, cursor, pos, ppos, level, childNode, len, toEnd);
                            }
                            catch (Throwable e) {
                                if (childNode != null) {
                                    childNode.releaseExclusive();
                                }
                                throw e;
                            }
                        }
                        db.deleteNode(childNode);
                    }
                    DirectPageOps.p_int48PutLE(page, poffset, 0L);
                } else {
                    childNode = db.nodeMapLoadFragmentExclusive(childNodeId, true);
                    try {
                        if (db.markFragmentDirty(childNode)) {
                            DirectPageOps.p_int48PutLE(page, poffset, childNode.id());
                        }
                        if (level <= 0) {
                            long childPage = childNode.mPage;
                            if (txn != null) {
                                txn.pushUnwrite(cursor.mTree.mId, cursor.mKey, pos, childPage, (int)ppos, (int)len);
                            }
                            DirectPageOps.p_clear(childPage, (int)ppos, (int)(ppos + len));
                        } else {
                            _BTreeValue.clearMultilevelFragments(txn, cursor, pos, ppos, level, childNode, len, toEnd);
                        }
                    }
                    finally {
                        childNode.releaseExclusive();
                    }
                }
            }
            if ((clearLen -= len) <= 0L) break;
            pos += len;
            poffset += 6;
            ppos = 0L;
        }
    }

    private static void touchMultilevelFragment(long ppos, int level, _Node inode) throws IOException {
        _LocalDatabase db = inode.getDatabase();
        long levelCap;
        int poffset;
        long page;
        long childNodeId;
        while ((childNodeId = DirectPageOps.p_uint48GetLE(page = inode.mPage, poffset = (int)(ppos / (levelCap = db.levelCap(--level))) * 6)) != 0L) {
            _Node childNode;
            try {
                childNode = db.nodeMapLoadFragmentExclusive(childNodeId, true);
                try {
                    if (db.markFragmentDirty(childNode)) {
                        DirectPageOps.p_int48PutLE(page, poffset, childNode.id());
                    }
                }
                catch (Throwable e) {
                    throw _BTreeValue.releaseExclusive(childNode, e);
                }
            }
            catch (Throwable e) {
                throw _BTreeValue.releaseExclusive(inode, e);
            }
            if (level <= 0) {
                childNode.releaseExclusive();
                inode.releaseExclusive();
                return;
            }
            inode.releaseExclusive();
            inode = childNode;
            ppos %= levelCap;
        }
        return;
    }

    private static int lengthFieldGrowth(int fHeader, long fLen) {
        int growth = 0;
        switch (fHeader >> 2 & 3) {
            case 0: {
                if (fLen < 65536L) break;
                growth = 2;
            }
            case 1: {
                if (fLen < 0x100000000L) break;
                growth += 2;
            }
            case 2: {
                if (fLen < 0x1000000000000L) break;
                growth += 2;
            }
        }
        return growth;
    }

    private static void updateLengthField(long page, int fHeaderLoc, long fLen) {
        byte fHeader = DirectPageOps.p_byteGet(page, fHeaderLoc);
        switch (fHeader >> 2 & 3) {
            case 0: {
                DirectPageOps.p_shortPutLE(page, fHeaderLoc + 1, (int)fLen);
                break;
            }
            case 1: {
                DirectPageOps.p_intPutLE(page, fHeaderLoc + 1, (int)fLen);
                break;
            }
            case 2: {
                DirectPageOps.p_int48PutLE(page, fHeaderLoc + 1, fLen);
                break;
            }
            default: {
                DirectPageOps.p_longPutLE(page, fHeaderLoc + 1, fLen);
            }
        }
    }

    private static void tryIncreaseLengthField(_BTreeCursor cursor, _CursorFrame frame, int kHeaderLoc, int vHeaderLoc, int vLen, int fHeaderLoc, long growth) throws IOException {
        int fOffset = fHeaderLoc - kHeaderLoc;
        long newEntryLen = (long)(fOffset + vLen) + growth;
        _Node node = frame.mNode;
        if (newEntryLen > (long)node.getDatabase().mMaxFragmentedEntrySize) {
            _BTreeValue.compactDirectFormat(cursor, frame, kHeaderLoc, vHeaderLoc, vLen, fHeaderLoc);
            return;
        }
        _BTree tree = cursor.mTree;
        try {
            int igrowth = (int)growth;
            byte[] newValue = new byte[vLen + igrowth];
            long page = node.mPage;
            byte fHeader = DirectPageOps.p_byteGet(page, fHeaderLoc);
            newValue[0] = (byte)(fHeader + (igrowth << 1));
            int srcLoc = fHeaderLoc + 1;
            int fieldLen = _BTreeValue.skipFragmentedLengthField(0, fHeader);
            DirectPageOps.p_copyToArray(page, srcLoc, newValue, 1, fieldLen);
            int dstLoc = 1 + fieldLen + igrowth;
            DirectPageOps.p_copyToArray(page, srcLoc += fieldLen, newValue, dstLoc, newValue.length - dstLoc);
            DirectPageOps.p_bytePut(page, vHeaderLoc, DirectPageOps.p_byteGet(page, vHeaderLoc) & 0xFFFFFFBF);
            node.updateLeafValue(tree, frame.mNodePos, 64, newValue);
        }
        catch (Throwable e) {
            throw _BTreeValue.releaseExclusive(node, e);
        }
        if (node.mSplit != null) {
            tree.finishSplitCritical(frame, node);
        }
    }

    private static long pointerCount(long pageSize, long len) {
        long count = (len + pageSize - 1L) / pageSize;
        if (count < 0L) {
            count = _BTreeValue.pointerCountOverflow(pageSize, len);
        }
        return count;
    }

    private static long pointerCountOverflow(long pageSize, long len) {
        return BigInteger.valueOf(len).add(BigInteger.valueOf(pageSize - 1L)).subtract(BigInteger.ONE).divide(BigInteger.valueOf(pageSize)).longValue();
    }

    private static int tryExtendDirect(_BTreeCursor cursor, _CursorFrame frame, int kHeaderLoc, int vHeaderLoc, int vLen, int fHeaderLoc, long growth) throws IOException {
        int fOffset = fHeaderLoc - kHeaderLoc;
        long newEntryLen = (long)(fOffset + vLen) + growth;
        _Node node = frame.mNode;
        if (newEntryLen > (long)node.getDatabase().mMaxFragmentedEntrySize) {
            _BTreeValue.compactDirectFormat(cursor, frame, kHeaderLoc, vHeaderLoc, vLen, fHeaderLoc);
            return -1;
        }
        _BTree tree = cursor.mTree;
        int newValueLen = vLen + (int)growth;
        try {
            byte[] newValue = new byte[newValueLen];
            long page = node.mPage;
            DirectPageOps.p_copyToArray(page, fHeaderLoc, newValue, 0, vLen);
            DirectPageOps.p_bytePut(page, vHeaderLoc, DirectPageOps.p_byteGet(page, vHeaderLoc) & 0xFFFFFFBF);
            node.updateLeafValue(tree, frame.mNodePos, 64, newValue);
        }
        catch (Throwable e) {
            throw _BTreeValue.releaseExclusive(node, e);
        }
        if (node.mSplit != null) {
            tree.finishSplitCritical(frame, node);
            return -2;
        }
        if (newValueLen > 8192 && vLen <= 8192) {
            return -1;
        }
        return DirectPageOps.p_ushortGetLE(node.mPage, node.searchVecStart() + frame.mNodePos) + fOffset;
    }

    private static int skipFragmentedLengthField(int loc, int fHeader) {
        return loc + 2 + (fHeader >> 1 & 6);
    }

    private static void compactDirectFormat(_BTreeCursor cursor, _CursorFrame frame, int kHeaderLoc, int vHeaderLoc, int vLen, int fHeaderLoc) throws IOException {
        int shrinkage;
        int fInlineLen;
        _Node node = frame.mNode;
        long page = node.mPage;
        int loc = fHeaderLoc;
        byte fHeader = DirectPageOps.p_byteGet(page, loc++);
        long fLen = _LocalDatabase.decodeFullFragmentedValueLength(fHeader, page, loc);
        loc = _BTreeValue.skipFragmentedLengthField(loc, fHeader);
        if ((fHeader & 2) == 0) {
            fInlineLen = 0;
        } else {
            fInlineLen = DirectPageOps.p_ushortGetLE(page, loc);
            loc = loc + 2 + fInlineLen;
        }
        int tailLen = fHeaderLoc + vLen - loc;
        _LocalDatabase db = node.getDatabase();
        int pageSize = _BTreeValue.pageSize(db, page);
        if (fInlineLen > 0) {
            _Node leftNode;
            if (fInlineLen < 4) {
                byte[] newValue;
                try {
                    byte[] fullValue = db.reconstruct(page, fHeaderLoc, vLen);
                    int max = db.mMaxFragmentedEntrySize - (vHeaderLoc - kHeaderLoc);
                    newValue = db.fragment(fullValue, fullValue.length, max, 0);
                }
                catch (Throwable e) {
                    throw _BTreeValue.releaseExclusive(node, e);
                }
                try {
                    node.updateLeafValue(cursor.mTree, frame.mNodePos, 64, newValue);
                }
                catch (Throwable e) {
                    throw _BTreeValue.releaseExclusive(node, e);
                }
                if (node.mSplit != null) {
                    cursor.mTree.finishSplitCritical(frame, node);
                }
                return;
            }
            _Node rightNode = null;
            try {
                if (_BTreeValue.pointerCount(pageSize, fLen) * 6L <= (long)tailLen) {
                    shrinkage = 2 + fInlineLen;
                } else {
                    rightNode = db.allocDirtyFragmentNode();
                    DirectPageOps.p_clear(rightNode.mPage, fInlineLen, pageSize);
                    shrinkage = 2 + fInlineLen - 6;
                }
                leftNode = _BTreeValue.shiftDirectRight(db, page, loc, loc + tailLen, fInlineLen, rightNode);
            }
            catch (Throwable e) {
                node.releaseExclusive();
                try {
                    if (rightNode != null) {
                        db.deleteNode(rightNode, true);
                    }
                }
                catch (Throwable e2) {
                    Utils.suppress(e, e2);
                    db.close(e);
                }
                throw e;
            }
            DirectPageOps.p_copy(page, loc - fInlineLen, leftNode.mPage, 0, fInlineLen);
            leftNode.releaseExclusive();
            DirectPageOps.p_copy(page, loc, page, loc - fInlineLen - 2, tailLen);
            if (rightNode != null) {
                DirectPageOps.p_int48PutLE(page, loc - fInlineLen - 2 + tailLen, rightNode.id());
            }
            DirectPageOps.p_bytePut(page, fHeaderLoc, fHeader & 0xFFFFFFFD);
        } else {
            if (fLen - (long)fInlineLen > (long)pageSize) {
                _Node inode;
                try {
                    inode = db.allocDirtyFragmentNode();
                }
                catch (Throwable e) {
                    throw _BTreeValue.releaseExclusive(node, e);
                }
                long ipage = inode.mPage;
                DirectPageOps.p_copy(page, loc, ipage, 0, tailLen);
                DirectPageOps.p_clear(ipage, tailLen, pageSize);
                DirectPageOps.p_int48PutLE(page, loc, inode.id());
                inode.releaseExclusive();
            }
            DirectPageOps.p_bytePut(page, fHeaderLoc, fHeader | 1);
            shrinkage = tailLen - 6;
        }
        int newLen = vLen - shrinkage - 1;
        byte header = DirectPageOps.p_byteGet(page, vHeaderLoc);
        if ((header & 0x20) == 0) {
            DirectPageOps.p_bytePut(page, vHeaderLoc, header & 0xE0 | newLen >> 8);
            DirectPageOps.p_bytePut(page, vHeaderLoc + 1, newLen);
        } else {
            DirectPageOps.p_bytePut(page, vHeaderLoc, header & 0xF0 | newLen >> 16);
            DirectPageOps.p_bytePut(page, vHeaderLoc + 1, newLen >> 8);
            DirectPageOps.p_bytePut(page, vHeaderLoc + 2, newLen);
        }
        node.garbage(node.garbage() + shrinkage);
        if (node.shouldLeafMerge()) {
            cursor.mergeLeaf(frame, node);
            frame.acquireExclusive();
            cursor.notSplitDirty(frame);
        }
    }

    private static _Node shiftDirectRight(_LocalDatabase db, long page, int startLoc, int endLoc, int amount, _Node dstNode) throws IOException {
        _Node[] fNodes = new _Node[(endLoc - startLoc) / 6];
        int pageSize = _BTreeValue.pageSize(db, page);
        try {
            boolean requireDest = true;
            int i = 0;
            for (int loc = startLoc; loc < endLoc; loc += 6) {
                long fNodeId = DirectPageOps.p_uint48GetLE(page, loc);
                if (fNodeId != 0L) {
                    fNodes[i] = fNode = db.nodeMapLoadFragmentExclusive(fNodeId, true);
                    if (db.markFragmentDirty(fNode)) {
                        DirectPageOps.p_int48PutLE(page, loc, fNode.id());
                    }
                    requireDest = true;
                } else if (requireDest) {
                    fNode = db.allocDirtyFragmentNode();
                    DirectPageOps.p_clear(fNode.mPage, 0, pageSize);
                    fNodes[i] = fNode;
                    DirectPageOps.p_int48PutLE(page, loc, fNode.id());
                    requireDest = false;
                }
                ++i;
            }
        }
        catch (Throwable e) {
            for (_Node fNode : fNodes) {
                if (fNode == null) continue;
                fNode.releaseExclusive();
            }
            throw e;
        }
        int i = fNodes.length;
        while (--i >= 0) {
            _Node fNode = fNodes[i];
            if (fNode == null) {
                if (dstNode != null) {
                    DirectPageOps.p_clear(dstNode.mPage, 0, amount);
                    dstNode.releaseExclusive();
                }
            } else {
                long fPage = fNode.mPage;
                if (dstNode != null) {
                    DirectPageOps.p_copy(fPage, pageSize - amount, dstNode.mPage, 0, amount);
                    dstNode.releaseExclusive();
                }
                DirectPageOps.p_copy(fPage, 0, fPage, amount, pageSize - amount);
            }
            dstNode = fNode;
        }
        return dstNode;
    }

    private static void fragmentedToNormal(_Node node, long page, int vHeaderLoc, int fInlineLoc, int fInlineLen, int shrinkage) {
        int loc = vHeaderLoc;
        if (fInlineLen <= 127) {
            DirectPageOps.p_bytePut(page, loc++, fInlineLen);
        } else if (fInlineLen <= 8192) {
            DirectPageOps.p_bytePut(page, loc++, 0x80 | fInlineLen - 1 >> 8);
            DirectPageOps.p_bytePut(page, loc++, fInlineLen - 1);
        } else {
            DirectPageOps.p_bytePut(page, loc++, 0xA0 | fInlineLen - 1 >> 16);
            DirectPageOps.p_bytePut(page, loc++, fInlineLen - 1 >> 8);
            DirectPageOps.p_bytePut(page, loc++, fInlineLen - 1);
        }
        DirectPageOps.p_copy(page, fInlineLoc, page, loc, fInlineLen);
        node.garbage(node.garbage() + shrinkage + (fInlineLoc - loc));
    }

    private static int truncateFragmented(_Node node, long page, int vHeaderLoc, int vLen, int shrinkage) {
        int newLen = vLen - shrinkage;
        int loc = vHeaderLoc;
        if ((DirectPageOps.p_byteGet(page, loc) & 0x20) == 0) {
            DirectPageOps.p_bytePut(page, loc++, 0xC0 | newLen - 1 >> 8);
        } else {
            DirectPageOps.p_bytePut(page, loc++, 0xE0 | newLen - 1 >> 16);
            DirectPageOps.p_bytePut(page, loc++, newLen - 1 >> 8);
        }
        DirectPageOps.p_bytePut(page, loc++, newLen - 1);
        node.garbage(node.garbage() + shrinkage);
        return loc;
    }

    private static int pageSize(_LocalDatabase db, long page) {
        return db.pageSize();
    }

    private static RuntimeException releaseExclusive(_Node node, Throwable cause) {
        node.releaseExclusive();
        throw Utils.rethrow(cause);
    }
}

