/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl.core;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.core._Node;

class _CursorFrame {
    static final int SPIN_LIMIT = Runtime.getRuntime().availableProcessors() > 1 ? 1024 : 0;
    private static final _CursorFrame REBIND_FRAME = new _CursorFrame();
    static final VarHandle cNextCousinHandle;
    static final VarHandle cLastHandle;
    volatile _CursorFrame mPrevCousin;
    volatile _CursorFrame mNextCousin;
    _Node mNode;
    int mNodePos;
    _CursorFrame mParentFrame;
    byte[] mNotFoundKey;

    _CursorFrame() {
    }

    _CursorFrame(_CursorFrame parentFrame) {
        this.mParentFrame = parentFrame;
    }

    final _Node acquireShared() {
        _Node node = this.mNode;
        while (true) {
            node.acquireShared();
            _Node actualNode = this.mNode;
            if (actualNode == node) {
                return actualNode;
            }
            node.releaseShared();
            node = actualNode;
        }
    }

    final _Node tryAcquireShared() {
        _Node node = this.mNode;
        while (node.tryAcquireShared()) {
            _Node actualNode = this.mNode;
            if (actualNode == node) {
                return actualNode;
            }
            node.releaseShared();
            node = actualNode;
        }
        return null;
    }

    final _Node acquireExclusive() {
        _Node node = this.mNode;
        while (true) {
            node.acquireExclusive();
            _Node actualNode = this.mNode;
            if (actualNode == node) {
                return actualNode;
            }
            node.releaseExclusive();
            node = actualNode;
        }
    }

    final _Node acquireExclusiveIfBound() {
        _Node node = this.mNode;
        while (node != null) {
            node.acquireExclusive();
            _Node actualNode = this.mNode;
            if (actualNode == node) {
                return actualNode;
            }
            node.releaseExclusive();
            node = actualNode;
        }
        return null;
    }

    final _Node tryAcquireExclusive() {
        _Node node = this.mNode;
        while (node.tryAcquireExclusive()) {
            _Node actualNode = this.mNode;
            if (actualNode == node) {
                return actualNode;
            }
            node.releaseExclusive();
            node = actualNode;
        }
        return null;
    }

    final void adjustParentPosition(int amount) {
        _CursorFrame parent = this.mParentFrame;
        if (parent != null) {
            parent.mNodePos += amount;
        }
    }

    final void bind(_Node node, int nodePos) {
        this.mNode = node;
        this.mNodePos = nodePos;
        this.mNextCousin = this;
        int trials = SPIN_LIMIT;
        while (true) {
            _CursorFrame last;
            this.mPrevCousin = last = node.mLastCursorFrame;
            if (last == null) {
                if (cLastHandle.compareAndSet(node, null, this)) {
                    return;
                }
            } else if (last.mNextCousin == last && cNextCousinHandle.compareAndSet(last, last, this)) {
                while (node.mLastCursorFrame != last) {
                    Thread.onSpinWait();
                }
                node.mLastCursorFrame = this;
                return;
            }
            if (--trials < 0) {
                Thread.yield();
                trials = SPIN_LIMIT << 1;
                continue;
            }
            Thread.onSpinWait();
        }
    }

    final void bindOrReposition(_Node node, int nodePos) {
        if (this.mNode == null) {
            this.bind(node, nodePos);
        } else if (this.mNode == node) {
            this.mNodePos = nodePos;
        } else {
            throw new IllegalStateException();
        }
    }

    final void rebind(_Node node, int nodePos) {
        if (this.unbind(REBIND_FRAME)) {
            this.bind(node, nodePos);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean unbind(_CursorFrame to) {
        int trials = SPIN_LIMIT;
        _CursorFrame n;
        while ((n = this.mNextCousin) != null) {
            if (n == this) {
                _Node node = this.mNode;
                if (node != null && node.mLastCursorFrame == this && cNextCousinHandle.compareAndSet(this, n, to)) {
                    if (node != this.mNode || node.mLastCursorFrame != this) {
                        this.mNextCousin = n;
                    } else {
                        _CursorFrame p;
                        while (!((p = this.mPrevCousin) == null || p.mNextCousin == this && cNextCousinHandle.compareAndSet(p, this, p))) {
                        }
                        node.mLastCursorFrame = p;
                        return true;
                    }
                }
            } else if (n.mPrevCousin == this && cNextCousinHandle.compareAndSet(this, n, to)) {
                _CursorFrame p;
                while (!((p = this.mPrevCousin) == null || p.mNextCousin == this && cNextCousinHandle.compareAndSet(p, this, n))) {
                }
                n.mPrevCousin = p;
                return true;
            }
            if (--trials < 0) {
                Thread.yield();
                trials = SPIN_LIMIT << 1;
                continue;
            }
            Thread.onSpinWait();
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final _CursorFrame tryLock(_CursorFrame lock) {
        int trials = SPIN_LIMIT;
        _CursorFrame n;
        while ((n = this.mNextCousin) != null) {
            if (n == this) {
                _Node node = this.mNode;
                if (node != null && node.mLastCursorFrame == this && cNextCousinHandle.compareAndSet(this, n, lock)) {
                    if (node == this.mNode && node.mLastCursorFrame == this) return n;
                    this.mNextCousin = n;
                }
            } else if (n.mPrevCousin == this && cNextCousinHandle.compareAndSet(this, n, lock)) {
                return n;
            }
            if (--trials < 0) {
                Thread.yield();
                trials = SPIN_LIMIT << 1;
                continue;
            }
            Thread.onSpinWait();
        }
        return null;
    }

    final _CursorFrame tryLockPrevious(_CursorFrame lock) {
        _CursorFrame p;
        while (!((p = this.mPrevCousin) == null || p.mNextCousin == this && cNextCousinHandle.compareAndSet(p, this, lock))) {
        }
        return p;
    }

    final void unlock(_CursorFrame n) {
        this.mNextCousin = n;
    }

    final _CursorFrame pop() {
        this.unbind(null);
        _CursorFrame parent = this.mParentFrame;
        this.mNode = null;
        this.mParentFrame = null;
        this.mNotFoundKey = null;
        return parent;
    }

    static void popAll(_CursorFrame frame) {
        while ((frame = frame.mNode == null ? frame.mParentFrame : frame.pop()) != null) {
        }
    }

    final void popChildren(_CursorFrame child) {
        while ((child = child.pop()) != this) {
        }
    }

    final void copyInto(_CursorFrame dest) {
        _Node node = this.acquireShared();
        _CursorFrame parent = this.mParentFrame;
        if (parent != null) {
            node.releaseShared();
            _CursorFrame parentCopy = new _CursorFrame();
            while (true) {
                if (parent != null) {
                    parent.copyInto(parentCopy);
                }
                node = this.acquireShared();
                _CursorFrame actualParent = this.mParentFrame;
                if (actualParent == parent) {
                    if (parent == null) break;
                    dest.mParentFrame = parentCopy;
                    break;
                }
                node.releaseShared();
                _CursorFrame.popAll(parentCopy);
                parent = actualParent;
            }
        }
        dest.mNotFoundKey = this.mNotFoundKey;
        dest.bind(node, this.mNodePos);
        node.releaseShared();
    }

    public final String toString() {
        return Utils.toMiniString(this);
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            cNextCousinHandle = lookup.findVarHandle(_CursorFrame.class, "mNextCousin", _CursorFrame.class);
            cLastHandle = lookup.findVarHandle(_Node.class, "mLastCursorFrame", _CursorFrame.class);
        }
        catch (Throwable e) {
            throw org.cojen.tupl.io.Utils.rethrow(e);
        }
    }
}

